/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ 
/*      */ public class OracleSql
/*      */ {
/*      */   static final int UNINITIALIZED = -1;
/*   36 */   static final String[] EMPTY_LIST = new String[0];
/*      */   static final int MAX_IDENTIFIER_LENGTH = 258;
/*      */   DBConversion conversion;
/*      */   String originalSql;
/*      */   String parameterSql;
/*      */   String utickSql;
/*      */   String processedSql;
/*      */   String rowidSql;
/*      */   String actualSql;
/*      */   byte[] sqlBytes;
/*   50 */   OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
/*   51 */   byte sqlKindByte = -1;
/*   52 */   int parameterCount = -1;
/*   53 */   int returningIntoParameterCount = -1;
/*   54 */   boolean currentConvertNcharLiterals = true;
/*   55 */   boolean currentProcessEscapes = true;
/*   56 */   boolean includeRowid = false;
/*   57 */   String[] parameterList = EMPTY_LIST;
/*   58 */   char[] currentParameter = null;
/*      */ 
/*   60 */   int bindParameterCount = -1;
/*   61 */   String[] bindParameterList = null;
/*   62 */   int cachedBindParameterCount = -1;
/*   63 */   String[] cachedBindParameterList = null;
/*      */   String cachedParameterSql;
/*      */   String cachedUtickSql;
/*      */   String cachedProcessedSql;
/*      */   String cachedRowidSql;
/*      */   String cachedActualSql;
/*      */   byte[] cachedSqlBytes;
/*   70 */   int selectEndIndex = -1;
/*   71 */   int orderByStartIndex = -1;
/*   72 */   int orderByEndIndex = -1;
/*   73 */   int whereStartIndex = -1;
/*   74 */   int whereEndIndex = -1;
/*   75 */   int forUpdateStartIndex = -1;
/*   76 */   int forUpdateEndIndex = -1;
/*      */ 
/*   78 */   int[] ncharLiteralLocation = new int[513];
/*   79 */   int lastNcharLiteralLocation = -1;
/*      */   static final String paramPrefix = "rowid";
/*   82 */   int paramSuffix = 0;
/*      */ 
/*  427 */   StringBuffer stringBufferForScrollableStatement = null;
/*      */   private static final int cMax = 127;
/*  835 */   private static final int[][] TRANSITION = OracleSqlReadOnly.TRANSITION;
/*      */ 
/*  838 */   private static final int[][] ACTION = OracleSqlReadOnly.ACTION;
/*      */   private static final int NO_ACTION = 0;
/*      */   private static final int DELETE_ACTION = 1;
/*      */   private static final int INSERT_ACTION = 2;
/*      */   private static final int MERGE_ACTION = 3;
/*      */   private static final int UPDATE_ACTION = 4;
/*      */   private static final int PLSQL_ACTION = 5;
/*      */   private static final int CALL_ACTION = 6;
/*      */   private static final int SELECT_ACTION = 7;
/*      */   private static final int ORDER_ACTION = 10;
/*      */   private static final int ORDER_BY_ACTION = 11;
/*      */   private static final int WHERE_ACTION = 9;
/*      */   private static final int FOR_ACTION = 12;
/*      */   private static final int FOR_UPDATE_ACTION = 13;
/*      */   private static final int OTHER_ACTION = 8;
/*      */   private static final int QUESTION_ACTION = 14;
/*      */   private static final int PARAMETER_ACTION = 15;
/*      */   private static final int END_PARAMETER_ACTION = 16;
/*      */   private static final int START_NCHAR_LITERAL_ACTION = 17;
/*      */   private static final int END_NCHAR_LITERAL_ACTION = 18;
/*      */   private static final int SAVE_DELIMITER_ACTION = 19;
/*      */   private static final int LOOK_FOR_DELIMITER_ACTION = 20;
/*      */   private static final int ALTER_SESSION_ACTION = 21;
/*      */   private static final int RETURNING_ACTION = 22;
/*      */   private static final int INTO_ACTION = 23;
/*      */   private static final int INITIAL_STATE = 0;
/*      */   private static final int RESTART_STATE = 66;
/*  872 */   private static final OracleSqlReadOnly.ODBCAction[][] ODBC_ACTION = OracleSqlReadOnly.ODBC_ACTION;
/*      */   private static final boolean DEBUG_CBI = false;
/*      */   int current_argument;
/*      */   int i;
/*      */   int length;
/*      */   char currentChar;
/*      */   boolean first;
/*      */   String odbc_sql;
/*      */   StringBuffer oracle_sql;
/*      */   StringBuffer token_buffer;
/* 2170 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   protected OracleSql(DBConversion paramDBConversion)
/*      */   {
/*   93 */     this.conversion = paramDBConversion;
/*      */   }
/*      */ 
/*      */   protected void initialize(String paramString)
/*      */     throws SQLException
/*      */   {
/*  110 */     if ((paramString == null) || (paramString.length() == 0))
/*      */     {
/*  112 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 104);
/*  113 */       localSQLException.fillInStackTrace();
/*  114 */       throw localSQLException;
/*      */     }
/*      */ 
/*  117 */     this.originalSql = paramString;
/*  118 */     this.utickSql = null;
/*  119 */     this.processedSql = null;
/*  120 */     this.rowidSql = null;
/*  121 */     this.actualSql = null;
/*  122 */     this.sqlBytes = null;
/*  123 */     this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
/*  124 */     this.parameterCount = -1;
/*  125 */     this.parameterList = EMPTY_LIST;
/*  126 */     this.includeRowid = false;
/*      */ 
/*  128 */     this.parameterSql = this.originalSql;
/*  129 */     this.bindParameterCount = -1;
/*  130 */     this.bindParameterList = null;
/*  131 */     this.cachedBindParameterCount = -1;
/*  132 */     this.cachedBindParameterList = null;
/*  133 */     this.cachedParameterSql = null;
/*  134 */     this.cachedActualSql = null;
/*  135 */     this.cachedProcessedSql = null;
/*  136 */     this.cachedRowidSql = null;
/*  137 */     this.cachedSqlBytes = null;
/*  138 */     this.selectEndIndex = -1;
/*  139 */     this.orderByStartIndex = -1;
/*  140 */     this.orderByEndIndex = -1;
/*  141 */     this.whereStartIndex = -1;
/*  142 */     this.whereEndIndex = -1;
/*  143 */     this.forUpdateStartIndex = -1;
/*  144 */     this.forUpdateEndIndex = -1;
/*      */   }
/*      */ 
/*      */   String getOriginalSql()
/*      */   {
/*  158 */     return this.originalSql;
/*      */   }
/*      */ 
/*      */   boolean setNamedParameters(int paramInt, String[] paramArrayOfString)
/*      */     throws SQLException
/*      */   {
/*  170 */     boolean bool = false;
/*      */ 
/*  172 */     if (paramInt == 0)
/*      */     {
/*  174 */       this.bindParameterCount = -1;
/*  175 */       bool = this.bindParameterCount != this.cachedBindParameterCount;
/*      */     }
/*      */     else
/*      */     {
/*  179 */       this.bindParameterCount = paramInt;
/*  180 */       this.bindParameterList = paramArrayOfString;
/*  181 */       bool = this.bindParameterCount != this.cachedBindParameterCount;
/*      */ 
/*  183 */       if (!bool) {
/*  184 */         for (int j = 0; j < paramInt; j++)
/*  185 */           if (this.bindParameterList[j] != this.cachedBindParameterList[j])
/*      */           {
/*  187 */             bool = true;
/*      */ 
/*  189 */             break;
/*      */           }
/*      */       }
/*  192 */       if (bool)
/*      */       {
/*  194 */         if (this.bindParameterCount != getParameterCount())
/*      */         {
/*  196 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 197);
/*  197 */           ((SQLException)localObject).fillInStackTrace();
/*  198 */           throw ((Throwable)localObject);
/*      */         }
/*      */ 
/*  201 */         Object localObject = this.originalSql.toCharArray();
/*  202 */         StringBuffer localStringBuffer = new StringBuffer();
/*      */ 
/*  204 */         int k = 0;
/*      */ 
/*  206 */         for (int m = 0; m < localObject.length; m++)
/*      */         {
/*  208 */           if (localObject[m] != '?')
/*      */           {
/*  210 */             localStringBuffer.append(localObject[m]);
/*      */           }
/*      */           else
/*      */           {
/*  214 */             localStringBuffer.append(this.bindParameterList[(k++)]);
/*  215 */             localStringBuffer.append(new StringBuilder().append("=>").append(nextArgument()).toString());
/*      */           }
/*      */         }
/*      */ 
/*  219 */         this.parameterSql = localStringBuffer.toString();
/*  220 */         this.actualSql = null;
/*  221 */         this.utickSql = null;
/*  222 */         this.processedSql = null;
/*  223 */         this.rowidSql = null;
/*  224 */         this.sqlBytes = null;
/*      */       }
/*      */       else
/*      */       {
/*  228 */         this.parameterSql = this.cachedParameterSql;
/*  229 */         this.actualSql = this.cachedActualSql;
/*  230 */         this.utickSql = this.cachedUtickSql;
/*  231 */         this.processedSql = this.cachedProcessedSql;
/*  232 */         this.rowidSql = this.cachedRowidSql;
/*  233 */         this.sqlBytes = this.cachedSqlBytes;
/*      */       }
/*      */     }
/*      */ 
/*  237 */     this.cachedBindParameterList = null;
/*  238 */     this.cachedParameterSql = null;
/*  239 */     this.cachedActualSql = null;
/*  240 */     this.cachedUtickSql = null;
/*  241 */     this.cachedProcessedSql = null;
/*  242 */     this.cachedRowidSql = null;
/*  243 */     this.cachedSqlBytes = null;
/*      */ 
/*  245 */     return bool;
/*      */   }
/*      */ 
/*      */   void resetNamedParameters()
/*      */   {
/*  255 */     this.cachedBindParameterCount = this.bindParameterCount;
/*      */ 
/*  257 */     if (this.bindParameterCount != -1)
/*      */     {
/*  259 */       if ((this.cachedBindParameterList == null) || (this.cachedBindParameterList == this.bindParameterList) || (this.cachedBindParameterList.length < this.bindParameterCount))
/*      */       {
/*  262 */         this.cachedBindParameterList = new String[this.bindParameterCount];
/*      */       }
/*  264 */       System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
/*      */ 
/*  267 */       this.cachedParameterSql = this.parameterSql;
/*  268 */       this.cachedActualSql = this.actualSql;
/*  269 */       this.cachedUtickSql = this.utickSql;
/*  270 */       this.cachedProcessedSql = this.processedSql;
/*  271 */       this.cachedRowidSql = this.rowidSql;
/*  272 */       this.cachedSqlBytes = this.sqlBytes;
/*      */ 
/*  274 */       this.bindParameterCount = -1;
/*  275 */       this.bindParameterList = null;
/*  276 */       this.parameterSql = this.originalSql;
/*  277 */       this.actualSql = null;
/*  278 */       this.utickSql = null;
/*  279 */       this.processedSql = null;
/*  280 */       this.rowidSql = null;
/*  281 */       this.sqlBytes = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   String getSql(boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  300 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
/*  301 */       computeBasicInfo(this.parameterSql);
/*      */     }
/*      */ 
/*  304 */     if ((paramBoolean1 != this.currentProcessEscapes) || (paramBoolean2 != this.currentConvertNcharLiterals))
/*      */     {
/*  307 */       if (paramBoolean2 != this.currentConvertNcharLiterals) {
/*  308 */         this.utickSql = null;
/*      */       }
/*      */ 
/*  311 */       this.processedSql = null;
/*  312 */       this.rowidSql = null;
/*  313 */       this.actualSql = null;
/*  314 */       this.sqlBytes = null;
/*      */     }
/*      */ 
/*  317 */     this.currentConvertNcharLiterals = paramBoolean2;
/*  318 */     this.currentProcessEscapes = paramBoolean1;
/*      */ 
/*  320 */     if (this.actualSql == null) {
/*  321 */       if (this.utickSql == null) {
/*  322 */         this.utickSql = (this.currentConvertNcharLiterals ? convertNcharLiterals(this.parameterSql) : this.parameterSql);
/*      */       }
/*      */ 
/*  325 */       if (this.processedSql == null) {
/*  326 */         this.processedSql = (this.currentProcessEscapes ? parse(this.utickSql) : this.utickSql);
/*      */       }
/*  328 */       if (this.rowidSql == null) {
/*  329 */         this.rowidSql = (this.includeRowid ? addRowid(this.processedSql) : this.processedSql);
/*      */       }
/*  331 */       this.actualSql = this.rowidSql;
/*      */     }
/*      */ 
/*  334 */     return this.actualSql;
/*      */   }
/*      */ 
/*      */   String getRevisedSql()
/*      */     throws SQLException
/*      */   {
/*  343 */     String str = null;
/*      */ 
/*  345 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) computeBasicInfo(this.parameterSql);
/*      */ 
/*  347 */     str = removeOrderByForUpdate(this.parameterSql);
/*      */ 
/*  349 */     return addRowid(str);
/*      */   }
/*      */ 
/*      */   String removeForUpdate(String paramString)
/*      */     throws SQLException
/*      */   {
/*  364 */     if (this.forUpdateStartIndex != -1) {
/*  365 */       return paramString.substring(0, this.forUpdateStartIndex);
/*      */     }
/*      */ 
/*  368 */     return paramString;
/*      */   }
/*      */ 
/*      */   String removeOrderByForUpdate(String paramString)
/*      */     throws SQLException
/*      */   {
/*  385 */     if ((this.orderByStartIndex != -1) && ((this.forUpdateStartIndex == -1) || (this.forUpdateStartIndex > this.orderByStartIndex)))
/*      */     {
/*  389 */       paramString = paramString.substring(0, this.orderByStartIndex);
/*      */     }
/*  391 */     else if (this.forUpdateStartIndex != -1)
/*      */     {
/*  393 */       paramString = paramString.substring(0, this.forUpdateStartIndex);
/*      */     }
/*      */ 
/*  396 */     return paramString;
/*      */   }
/*      */ 
/*      */   void appendForUpdate(StringBuffer paramStringBuffer)
/*      */     throws SQLException
/*      */   {
/*  414 */     if ((this.orderByStartIndex != -1) && ((this.forUpdateStartIndex == -1) || (this.forUpdateStartIndex > this.orderByStartIndex)))
/*      */     {
/*  418 */       paramStringBuffer.append(this.originalSql.substring(this.orderByStartIndex));
/*      */     }
/*  420 */     else if (this.forUpdateStartIndex != -1)
/*      */     {
/*  422 */       paramStringBuffer.append(this.originalSql.substring(this.forUpdateStartIndex));
/*      */     }
/*      */   }
/*      */ 
/*      */   String getInsertSqlForUpdatableResultSet(UpdatableResultSet paramUpdatableResultSet)
/*      */     throws SQLException
/*      */   {
/*  440 */     String str = getOriginalSql();
/*  441 */     boolean bool = generatedSqlNeedEscapeProcessing();
/*      */ 
/*  443 */     if (this.stringBufferForScrollableStatement == null)
/*  444 */       this.stringBufferForScrollableStatement = new StringBuffer(str.length() + 100);
/*      */     else {
/*  446 */       this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
/*      */     }
/*  448 */     this.stringBufferForScrollableStatement.append("insert into (");
/*      */ 
/*  450 */     this.stringBufferForScrollableStatement.append(removeOrderByForUpdate(str));
/*  451 */     this.stringBufferForScrollableStatement.append(") values ( ");
/*      */ 
/*  453 */     for (int j = 0; 
/*  454 */       j < paramUpdatableResultSet.getColumnCount(); 
/*  455 */       j++)
/*      */     {
/*  457 */       if (j != 0) {
/*  458 */         this.stringBufferForScrollableStatement.append(", ");
/*      */       }
/*  460 */       if (bool)
/*  461 */         this.stringBufferForScrollableStatement.append("?");
/*      */       else {
/*  463 */         this.stringBufferForScrollableStatement.append(new StringBuilder().append(":").append(generateParameterName()).toString());
/*      */       }
/*      */     }
/*  466 */     this.stringBufferForScrollableStatement.append(")");
/*      */ 
/*  468 */     this.paramSuffix = 0;
/*      */ 
/*  470 */     return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
/*      */   }
/*      */ 
/*      */   String getRefetchSqlForScrollableResultSet(OracleResultSet paramOracleResultSet, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  487 */     throw new SQLException("no longer used");
/*      */   }
/*      */ 
/*      */   String getRefetchSql()
/*      */     throws SQLException
/*      */   {
/*  516 */     String str = removeForUpdate(this.parameterSql);
/*  517 */     StringBuilder localStringBuilder = new StringBuilder(str.length() + 240);
/*      */ 
/*  520 */     localStringBuilder.append("WITH \"__JDBC_ROWIDS__\" AS (SELECT COLUMN_VALUE ID, ROWNUM NUM FROM TABLE(");
/*  521 */     localStringBuilder.append(generatedSqlNeedEscapeProcessing() ? "?" : new StringBuilder().append(":").append(generateParameterName()).toString());
/*  522 */     localStringBuilder.append("))\n");
/*      */ 
/*  524 */     localStringBuilder.append("SELECT \"__JDBC_ORIGINAL__\".ROWID, \"__JDBC_ORIGINAL__\".*\n");
/*      */ 
/*  526 */     localStringBuilder.append("FROM (");
/*  527 */     localStringBuilder.append(str);
/*  528 */     localStringBuilder.append(") \"__JDBC_ORIGINAL__\", \"__JDBC_ROWIDS__\"\n");
/*      */ 
/*  530 */     localStringBuilder.append("WHERE \"__JDBC_ORIGINAL__\".ROWID(+) = \"__JDBC_ROWIDS__\".ID\n");
/*      */ 
/*  532 */     localStringBuilder.append("ORDER BY \"__JDBC_ROWIDS__\".NUM");
/*      */ 
/*  534 */     this.paramSuffix = 0;
/*      */ 
/*  536 */     return localStringBuilder.toString();
/*      */   }
/*      */ 
/*      */   String getUpdateSqlForUpdatableResultSet(UpdatableResultSet paramUpdatableResultSet, int paramInt, Object[] paramArrayOfObject, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/*  554 */     String str = getRevisedSql();
/*  555 */     boolean bool = generatedSqlNeedEscapeProcessing();
/*      */ 
/*  557 */     if (this.stringBufferForScrollableStatement == null)
/*  558 */       this.stringBufferForScrollableStatement = new StringBuffer(str.length() + 100);
/*      */     else {
/*  560 */       this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
/*      */     }
/*      */ 
/*  564 */     this.stringBufferForScrollableStatement.append("update (");
/*  565 */     this.stringBufferForScrollableStatement.append(str);
/*  566 */     this.stringBufferForScrollableStatement.append(") set ");
/*      */ 
/*  569 */     if (paramArrayOfObject != null)
/*      */     {
/*  571 */       for (int j = 0; j < paramInt; j++)
/*      */       {
/*  573 */         if (j > 0) {
/*  574 */           this.stringBufferForScrollableStatement.append(", ");
/*      */         }
/*  576 */         this.stringBufferForScrollableStatement.append(paramUpdatableResultSet.getInternalMetadata().getColumnName(paramArrayOfInt[j] + 1));
/*      */ 
/*  579 */         if (bool)
/*  580 */           this.stringBufferForScrollableStatement.append(" = ?");
/*      */         else {
/*  582 */           this.stringBufferForScrollableStatement.append(new StringBuilder().append(" = :").append(generateParameterName()).toString());
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  587 */     this.stringBufferForScrollableStatement.append(" WHERE ");
/*  588 */     if (bool)
/*  589 */       this.stringBufferForScrollableStatement.append(" ROWID = ?");
/*      */     else {
/*  591 */       this.stringBufferForScrollableStatement.append(new StringBuilder().append(" ROWID = :").append(generateParameterName()).toString());
/*      */     }
/*      */ 
/*  594 */     this.paramSuffix = 0;
/*      */ 
/*  596 */     return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
/*      */   }
/*      */ 
/*      */   String getDeleteSqlForUpdatableResultSet(UpdatableResultSet paramUpdatableResultSet)
/*      */     throws SQLException
/*      */   {
/*  612 */     String str = getRevisedSql();
/*  613 */     boolean bool = generatedSqlNeedEscapeProcessing();
/*      */ 
/*  615 */     if (this.stringBufferForScrollableStatement == null)
/*  616 */       this.stringBufferForScrollableStatement = new StringBuffer(str.length() + 100);
/*      */     else {
/*  618 */       this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
/*      */     }
/*      */ 
/*  622 */     this.stringBufferForScrollableStatement.append("delete from (");
/*  623 */     this.stringBufferForScrollableStatement.append(str);
/*  624 */     this.stringBufferForScrollableStatement.append(") where ");
/*      */ 
/*  626 */     if (bool)
/*  627 */       this.stringBufferForScrollableStatement.append(" ROWID = ?");
/*      */     else {
/*  629 */       this.stringBufferForScrollableStatement.append(new StringBuilder().append(" ROWID = :").append(generateParameterName()).toString());
/*      */     }
/*      */ 
/*  632 */     this.paramSuffix = 0;
/*      */ 
/*  634 */     return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
/*      */   }
/*      */ 
/*      */   final boolean generatedSqlNeedEscapeProcessing()
/*      */   {
/*  646 */     return (this.parameterCount > 0) && (this.parameterList == EMPTY_LIST);
/*      */   }
/*      */ 
/*      */   byte[] getSqlBytes(boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  659 */     if ((this.sqlBytes == null) || (paramBoolean1 != this.currentProcessEscapes))
/*      */     {
/*  661 */       this.sqlBytes = this.conversion.StringToCharBytes(getSql(paramBoolean1, paramBoolean2));
/*      */     }
/*      */ 
/*  665 */     return this.sqlBytes;
/*      */   }
/*      */ 
/*      */   OracleStatement.SqlKind getSqlKind()
/*      */     throws SQLException
/*      */   {
/*  679 */     if (this.parameterSql == null) {
/*  680 */       return OracleStatement.SqlKind.UNINITIALIZED;
/*      */     }
/*  682 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
/*  683 */       computeBasicInfo(this.parameterSql);
/*      */     }
/*  685 */     return this.sqlKind;
/*      */   }
/*      */ 
/*      */   protected int getParameterCount()
/*      */     throws SQLException
/*      */   {
/*  699 */     if (this.parameterCount == -1)
/*      */     {
/*  701 */       computeBasicInfo(this.parameterSql);
/*      */     }
/*      */ 
/*  704 */     return this.parameterCount;
/*      */   }
/*      */ 
/*      */   protected String[] getParameterList()
/*      */     throws SQLException
/*      */   {
/*  721 */     if (this.parameterCount == -1)
/*      */     {
/*  723 */       computeBasicInfo(this.parameterSql);
/*      */     }
/*      */ 
/*  726 */     return this.parameterList;
/*      */   }
/*      */ 
/*      */   void setIncludeRowid(boolean paramBoolean)
/*      */   {
/*  741 */     if (paramBoolean != this.includeRowid)
/*      */     {
/*  743 */       this.includeRowid = paramBoolean;
/*  744 */       this.rowidSql = null;
/*  745 */       this.actualSql = null;
/*  746 */       this.sqlBytes = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  755 */     return this.parameterSql == null ? "null" : this.parameterSql;
/*      */   }
/*      */ 
/*      */   private String hexUnicode(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  771 */     String str = Integer.toHexString(paramInt);
/*  772 */     switch (str.length()) {
/*      */     case 0:
/*  774 */       return "\\0000";
/*      */     case 1:
/*  775 */       return new StringBuilder().append("\\000").append(str).toString();
/*      */     case 2:
/*  776 */       return new StringBuilder().append("\\00").append(str).toString();
/*      */     case 3:
/*  777 */       return new StringBuilder().append("\\0").append(str).toString();
/*      */     case 4:
/*  778 */       return new StringBuilder().append("\\").append(str).toString();
/*      */     }
/*      */ 
/*  781 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89, new StringBuilder().append("Unexpected case in OracleSql.hexUnicode: ").append(paramInt).toString());
/*  782 */     localSQLException.fillInStackTrace();
/*  783 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   String convertNcharLiterals(String paramString)
/*      */     throws SQLException
/*      */   {
/*  806 */     if (this.lastNcharLiteralLocation <= 2) return paramString;
/*  807 */     String str = "";
/*  808 */     int j = 0;
/*      */     while (true)
/*      */     {
/*  811 */       int k = this.ncharLiteralLocation[(j++)];
/*  812 */       int m = this.ncharLiteralLocation[(j++)];
/*      */ 
/*  814 */       str = new StringBuilder().append(str).append(paramString.substring(k, m)).toString();
/*  815 */       if (j >= this.lastNcharLiteralLocation) break;
/*  816 */       k = this.ncharLiteralLocation[j];
/*  817 */       str = new StringBuilder().append(str).append("u'").toString();
/*      */ 
/*  819 */       for (int n = m + 2; n < k; n++)
/*      */       {
/*  821 */         char c = paramString.charAt(n);
/*  822 */         if (c == '\\') str = new StringBuilder().append(str).append("\\\\").toString();
/*  823 */         else if (c < '') str = new StringBuilder().append(str).append(c).toString(); else
/*  824 */           str = new StringBuilder().append(str).append(hexUnicode(c)).toString();
/*      */       }
/*      */     }
/*  827 */     return str;
/*      */   }
/*      */ 
/*      */   void computeBasicInfo(String paramString)
/*      */     throws SQLException
/*      */   {
/*  903 */     this.parameterCount = 0;
/*  904 */     int j = 0;
/*  905 */     int k = 0;
/*  906 */     this.returningIntoParameterCount = 0;
/*      */ 
/*  908 */     this.lastNcharLiteralLocation = 0;
/*  909 */     this.ncharLiteralLocation[(this.lastNcharLiteralLocation++)] = 0;
/*      */ 
/*  911 */     char c1 = '\000';
/*      */ 
/*  913 */     int m = 0;
/*      */ 
/*  915 */     int n = 0;
/*  916 */     int i1 = paramString.length();
/*  917 */     int i2 = -1;
/*  918 */     int i3 = -1;
/*  919 */     int i4 = i1 + 1;
/*      */ 
/*  922 */     for (int i5 = 0; i5 < i4; i5++)
/*      */     {
/*  924 */       char c2 = i5 < i1 ? paramString.charAt(i5) : ' ';
/*  925 */       this.currentChar = c2;
/*      */ 
/*  927 */       if (c2 > '')
/*      */       {
/*  933 */         if (Character.isLetterOrDigit(c2))
/*  934 */           this.currentChar = 'X';
/*      */         else
/*  936 */           this.currentChar = ' ';
/*      */       }
/*      */       Object localObject;
/*  941 */       switch (ACTION[n][this.currentChar])
/*      */       {
/*      */       case 0:
/*  945 */         break;
/*      */       case 1:
/*  948 */         this.sqlKind = OracleStatement.SqlKind.DELETE;
/*      */ 
/*  950 */         break;
/*      */       case 2:
/*  953 */         this.sqlKind = OracleStatement.SqlKind.INSERT;
/*      */ 
/*  955 */         break;
/*      */       case 3:
/*  958 */         this.sqlKind = OracleStatement.SqlKind.MERGE;
/*      */ 
/*  960 */         break;
/*      */       case 4:
/*  963 */         this.sqlKind = OracleStatement.SqlKind.UPDATE;
/*      */ 
/*  965 */         break;
/*      */       case 5:
/*  968 */         this.sqlKind = OracleStatement.SqlKind.PLSQL_BLOCK;
/*      */ 
/*  970 */         break;
/*      */       case 6:
/*  973 */         this.sqlKind = OracleStatement.SqlKind.CALL_BLOCK;
/*      */ 
/*  975 */         break;
/*      */       case 7:
/*  978 */         this.sqlKind = OracleStatement.SqlKind.SELECT;
/*  979 */         this.selectEndIndex = i5;
/*      */ 
/*  981 */         break;
/*      */       case 8:
/*  984 */         this.sqlKind = OracleStatement.SqlKind.OTHER;
/*      */ 
/*  986 */         break;
/*      */       case 9:
/*  989 */         this.whereStartIndex = (i5 - 5);
/*  990 */         this.whereEndIndex = i5;
/*      */ 
/*  992 */         break;
/*      */       case 10:
/*  995 */         i2 = i5 - 5;
/*      */ 
/*  997 */         break;
/*      */       case 11:
/* 1000 */         this.orderByStartIndex = i2;
/* 1001 */         this.orderByEndIndex = i5;
/*      */ 
/* 1003 */         break;
/*      */       case 12:
/* 1006 */         i3 = i5 - 3;
/*      */ 
/* 1008 */         break;
/*      */       case 13:
/* 1011 */         this.forUpdateStartIndex = i3;
/* 1012 */         this.forUpdateEndIndex = i5;
/* 1013 */         if (this.sqlKind == OracleStatement.SqlKind.SELECT)
/* 1014 */           this.sqlKind = OracleStatement.SqlKind.SELECT_FOR_UPDATE; break;
/*      */       case 21:
/* 1019 */         this.sqlKind = OracleStatement.SqlKind.ALTER_SESSION;
/*      */ 
/* 1021 */         break;
/*      */       case 14:
/* 1024 */         this.parameterCount += 1;
/* 1025 */         if (k != 0) this.returningIntoParameterCount += 1; break;
/*      */       case 15:
/* 1030 */         if (this.currentParameter == null) {
/* 1031 */           this.currentParameter = new char[258];
/*      */         }
/* 1033 */         if (m >= this.currentParameter.length)
/*      */         {
/* 1035 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 134, new String(this.currentParameter));
/* 1036 */           ((SQLException)localObject).fillInStackTrace();
/* 1037 */           throw ((Throwable)localObject);
/*      */         }
/*      */ 
/* 1040 */         this.currentParameter[(m++)] = c2;
/*      */ 
/* 1042 */         break;
/*      */       case 16:
/* 1045 */         if (m > 0)
/*      */         {
/* 1047 */           if (this.parameterList == EMPTY_LIST)
/*      */           {
/* 1049 */             this.parameterList = new String[Math.max(8, this.parameterCount * 4)];
/*      */           }
/* 1051 */           else if (this.parameterList.length <= this.parameterCount)
/*      */           {
/* 1053 */             localObject = new String[this.parameterList.length * 4];
/*      */ 
/* 1055 */             System.arraycopy(this.parameterList, 0, localObject, 0, this.parameterList.length);
/*      */ 
/* 1058 */             this.parameterList = ((String[])localObject);
/*      */           }
/*      */ 
/* 1061 */           this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, m).intern();
/*      */ 
/* 1063 */           m = 0;
/* 1064 */           this.parameterCount += 1;
/* 1065 */           if (k != 0) this.returningIntoParameterCount += 1;  } break;
/*      */       case 17:
/* 1071 */         this.ncharLiteralLocation[(this.lastNcharLiteralLocation++)] = (i5 - 1);
/* 1072 */         if (this.lastNcharLiteralLocation >= this.ncharLiteralLocation.length)
/* 1073 */           growNcharLiteralLocation(this.ncharLiteralLocation.length << 2); break;
/*      */       case 18:
/* 1077 */         this.ncharLiteralLocation[(this.lastNcharLiteralLocation++)] = i5;
/* 1078 */         if (this.lastNcharLiteralLocation >= this.ncharLiteralLocation.length)
/* 1079 */           growNcharLiteralLocation(this.ncharLiteralLocation.length << 2); break;
/*      */       case 19:
/* 1084 */         if (c2 == '[') c1 = ']';
/* 1085 */         else if (c2 == '{') c1 = '}';
/* 1086 */         else if (c2 == '<') c1 = '>';
/* 1087 */         else if (c2 == '(') c1 = ')'; else
/* 1088 */           c1 = c2;
/* 1089 */         break;
/*      */       case 20:
/* 1092 */         if (c2 == c1)
/*      */         {
/* 1095 */           n += 1; } break;
/*      */       case 22:
/* 1101 */         j = 1;
/* 1102 */         break;
/*      */       case 23:
/* 1105 */         if (j != 0) k = 1;
/*      */         break;
/*      */       }
/*      */ 
/* 1109 */       n = TRANSITION[n][this.currentChar];
/*      */     }
/*      */ 
/* 1112 */     if (this.lastNcharLiteralLocation + 2 >= this.ncharLiteralLocation.length)
/* 1113 */       growNcharLiteralLocation(this.lastNcharLiteralLocation + 2);
/* 1114 */     this.ncharLiteralLocation[(this.lastNcharLiteralLocation++)] = i1;
/* 1115 */     this.ncharLiteralLocation[this.lastNcharLiteralLocation] = i1;
/*      */   }
/*      */ 
/*      */   void growNcharLiteralLocation(int paramInt)
/*      */   {
/* 1123 */     int[] arrayOfInt = new int[paramInt];
/* 1124 */     System.arraycopy(this.ncharLiteralLocation, 0, arrayOfInt, 0, this.ncharLiteralLocation.length);
/* 1125 */     this.ncharLiteralLocation = null;
/* 1126 */     this.ncharLiteralLocation = arrayOfInt;
/*      */   }
/*      */ 
/*      */   private String addRowid(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1133 */     if (this.selectEndIndex == -1)
/*      */     {
/* 1135 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 88);
/* 1136 */       ((SQLException)localObject).fillInStackTrace();
/* 1137 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1140 */     Object localObject = new StringBuilder().append("select rowid as \"__Oracle_JDBC_interal_ROWID__\",").append(paramString.substring(this.selectEndIndex)).toString();
/* 1141 */     return localObject;
/*      */   }
/*      */ 
/*      */   String parse(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1174 */     this.first = true;
/* 1175 */     this.current_argument = 1;
/* 1176 */     this.i = 0;
/* 1177 */     this.odbc_sql = paramString;
/* 1178 */     this.length = this.odbc_sql.length();
/*      */ 
/* 1180 */     if (this.oracle_sql == null)
/*      */     {
/* 1182 */       this.oracle_sql = new StringBuffer(this.length);
/* 1183 */       this.token_buffer = new StringBuffer(32);
/*      */     }
/*      */     else
/*      */     {
/* 1187 */       this.oracle_sql.ensureCapacity(this.length);
/*      */     }
/*      */ 
/* 1190 */     this.oracle_sql.delete(0, this.oracle_sql.length());
/* 1191 */     skipSpace();
/* 1192 */     handleODBC(ParseMode.NORMAL);
/*      */ 
/* 1194 */     if (this.i < this.length)
/*      */     {
/* 1196 */       Integer localInteger = Integer.valueOf(this.i);
/*      */ 
/* 1199 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 33, localInteger);
/* 1200 */       localSQLException.fillInStackTrace();
/* 1201 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1205 */     return this.oracle_sql.substring(0, this.oracle_sql.length());
/*      */   }
/*      */ 
/*      */   void handleODBC(ParseMode paramParseMode)
/*      */     throws SQLException
/*      */   {
/* 1215 */     int j = paramParseMode == ParseMode.NORMAL ? 0 : 66;
/* 1216 */     char c1 = '\000';
/* 1217 */     int k = 0;
/*      */ 
/* 1219 */     while (this.i < this.length)
/*      */     {
/* 1221 */       char c2 = this.i < this.length ? this.odbc_sql.charAt(this.i) : ' ';
/* 1222 */       this.currentChar = c2;
/*      */ 
/* 1224 */       if (c2 > '')
/*      */       {
/* 1230 */         if (Character.isLetterOrDigit(c2))
/* 1231 */           this.currentChar = 'X';
/*      */         else {
/* 1233 */           this.currentChar = ' ';
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1238 */       switch (1.$SwitchMap$oracle$jdbc$driver$OracleSqlReadOnly$ODBCAction[ODBC_ACTION[j][this.currentChar].ordinal()])
/*      */       {
/*      */       case 1:
/* 1242 */         break;
/*      */       case 2:
/* 1245 */         this.oracle_sql.append(c2);
/* 1246 */         break;
/*      */       case 3:
/* 1249 */         this.oracle_sql.append(nextArgument());
/* 1250 */         this.oracle_sql.append(' ');
/* 1251 */         break;
/*      */       case 4:
/* 1254 */         if (c2 == '[') c1 = ']';
/* 1255 */         else if (c2 == '{') c1 = '}';
/* 1256 */         else if (c2 == '<') c1 = '>';
/* 1257 */         else if (c2 == '(') c1 = ')'; else
/* 1258 */           c1 = c2;
/* 1259 */         this.oracle_sql.append(c2);
/* 1260 */         break;
/*      */       case 5:
/* 1263 */         if (c2 == c1)
/*      */         {
/* 1266 */           j += 1;
/*      */         }
/* 1268 */         this.oracle_sql.append(c2);
/* 1269 */         break;
/*      */       case 6:
/* 1272 */         handleFunction();
/* 1273 */         break;
/*      */       case 7:
/* 1276 */         handleCall();
/* 1277 */         break;
/*      */       case 8:
/* 1280 */         handleTime();
/* 1281 */         break;
/*      */       case 9:
/* 1284 */         handleTimestamp();
/* 1285 */         break;
/*      */       case 10:
/* 1288 */         handleDate();
/* 1289 */         break;
/*      */       case 11:
/* 1292 */         handleEscape();
/* 1293 */         break;
/*      */       case 12:
/* 1296 */         handleScalarFunction();
/* 1297 */         break;
/*      */       case 13:
/* 1300 */         handleOuterJoin();
/* 1301 */         break;
/*      */       case 14:
/* 1305 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, Integer.valueOf(this.i));
/* 1306 */         localSQLException.fillInStackTrace();
/* 1307 */         throw localSQLException;
/*      */       case 15:
/* 1311 */         if (paramParseMode == ParseMode.SCALAR)
/*      */         {
/* 1313 */           j = TRANSITION[j][this.currentChar];
/* 1314 */           return;
/*      */         }
/*      */ 
/*      */       case 16:
/* 1320 */         if ((paramParseMode == ParseMode.LOCATE_1) && (k > 1)) {
/* 1321 */           this.oracle_sql.append(c2);
/*      */         } else {
/* 1323 */           if (paramParseMode == ParseMode.LOCATE_1)
/*      */           {
/* 1325 */             j = TRANSITION[j][this.currentChar];
/* 1326 */             return;
/*      */           }
/* 1328 */           if (paramParseMode != ParseMode.LOCATE_2)
/*      */           {
/* 1333 */             this.oracle_sql.append(c2);
/*      */           }
/*      */         }
/* 1335 */         break;
/*      */       case 17:
/* 1338 */         if (paramParseMode == ParseMode.LOCATE_1) {
/* 1339 */           if (k > 0) this.oracle_sql.append(c2);
/* 1340 */           k++;
/*      */         }
/* 1342 */         else if (paramParseMode == ParseMode.LOCATE_2) {
/* 1343 */           k++;
/* 1344 */           this.oracle_sql.append(c2);
/*      */         }
/*      */         else
/*      */         {
/* 1348 */           this.oracle_sql.append(c2);
/*      */         }
/* 1350 */         break;
/*      */       case 18:
/* 1353 */         if (paramParseMode == ParseMode.LOCATE_1) {
/* 1354 */           k--;
/* 1355 */           this.oracle_sql.append(c2);
/*      */         }
/* 1357 */         else if ((paramParseMode == ParseMode.LOCATE_2) && (k > 1)) {
/* 1358 */           k--;
/* 1359 */           this.oracle_sql.append(c2);
/*      */         } else {
/* 1361 */           if (paramParseMode == ParseMode.LOCATE_2) {
/* 1362 */             this.i += 1;
/*      */ 
/* 1364 */             j = TRANSITION[j][this.currentChar];
/* 1365 */             return;
/*      */           }
/*      */ 
/* 1369 */           this.oracle_sql.append(c2);
/*      */         }
/* 1371 */         break;
/*      */       case 19:
/* 1374 */         this.first = false;
/* 1375 */         this.oracle_sql.append(c2);
/* 1376 */         break;
/*      */       case 20:
/* 1379 */         handleLimit();
/*      */       }
/*      */ 
/* 1384 */       j = TRANSITION[j][this.currentChar];
/* 1385 */       this.i += 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   void handleFunction()
/*      */     throws SQLException
/*      */   {
/* 1394 */     boolean bool = this.first;
/* 1395 */     this.first = false;
/*      */ 
/* 1397 */     if (bool) {
/* 1398 */       this.oracle_sql.append("BEGIN ");
/*      */     }
/* 1400 */     appendChar(this.oracle_sql, '?');
/* 1401 */     skipSpace();
/*      */     String str;
/*      */     SQLException localSQLException;
/* 1403 */     if (this.currentChar != '=')
/*      */     {
/* 1405 */       str = new StringBuilder().append(this.i).append(". Expecting \"=\" got \"").append(this.currentChar).append("\"").toString();
/*      */ 
/* 1408 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 33, str);
/* 1409 */       localSQLException.fillInStackTrace();
/* 1410 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1414 */     this.i += 1;
/*      */ 
/* 1416 */     skipSpace();
/*      */ 
/* 1418 */     if (!this.odbc_sql.startsWith("call", this.i))
/*      */     {
/* 1420 */       str = new StringBuilder().append(this.i).append(". Expecting \"call\"").toString();
/*      */ 
/* 1423 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 33, str);
/* 1424 */       localSQLException.fillInStackTrace();
/* 1425 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1429 */     this.i += 4;
/*      */ 
/* 1431 */     this.oracle_sql.append(" := ");
/* 1432 */     skipSpace();
/* 1433 */     handleODBC(ParseMode.SCALAR);
/*      */ 
/* 1435 */     if (bool)
/* 1436 */       this.oracle_sql.append("; END;");
/*      */   }
/*      */ 
/*      */   void handleCall()
/*      */     throws SQLException
/*      */   {
/* 1444 */     boolean bool = this.first;
/* 1445 */     this.first = false;
/*      */ 
/* 1447 */     if (bool) {
/* 1448 */       this.oracle_sql.append("BEGIN ");
/*      */     }
/* 1450 */     skipSpace();
/* 1451 */     handleODBC(ParseMode.SCALAR);
/* 1452 */     skipSpace();
/*      */ 
/* 1454 */     if (bool)
/* 1455 */       this.oracle_sql.append("; END;");
/*      */   }
/*      */ 
/*      */   void handleTimestamp()
/*      */     throws SQLException
/*      */   {
/* 1464 */     this.oracle_sql.append("TO_TIMESTAMP (");
/* 1465 */     skipSpace();
/* 1466 */     handleODBC(ParseMode.SCALAR);
/* 1467 */     this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
/*      */   }
/*      */ 
/*      */   void handleTime()
/*      */     throws SQLException
/*      */   {
/* 1474 */     skipSpace();
/*      */ 
/* 1476 */     this.oracle_sql.append("TO_DATE('1-JAN-1970 '||TO_CHAR(TO_DATE(");
/*      */ 
/* 1478 */     handleODBC(ParseMode.SCALAR);
/*      */ 
/* 1480 */     this.oracle_sql.append(",'HH24:MI:SS'),'HH24:MI:SS'),'DD-MON-YYYY HH24:MI:SS')");
/*      */   }
/*      */ 
/*      */   void handleDate()
/*      */     throws SQLException
/*      */   {
/* 1487 */     this.oracle_sql.append("TO_DATE (");
/* 1488 */     skipSpace();
/* 1489 */     handleODBC(ParseMode.SCALAR);
/* 1490 */     this.oracle_sql.append(", 'YYYY-MM-DD')");
/*      */   }
/*      */ 
/*      */   void handleEscape()
/*      */     throws SQLException
/*      */   {
/* 1497 */     this.oracle_sql.append("ESCAPE ");
/* 1498 */     skipSpace();
/* 1499 */     handleODBC(ParseMode.SCALAR);
/*      */   }
/*      */ 
/*      */   void handleLimit()
/*      */     throws SQLException
/*      */   {
/* 1506 */     this.oracle_sql.append("ROWNUM <= ");
/* 1507 */     skipSpace();
/* 1508 */     handleODBC(ParseMode.SCALAR);
/*      */   }
/*      */ 
/*      */   void handleScalarFunction()
/*      */     throws SQLException
/*      */   {
/* 1516 */     this.token_buffer.delete(0, this.token_buffer.length());
/*      */ 
/* 1518 */     this.i += 1;
/*      */ 
/* 1520 */     skipSpace();
/*      */ 
/* 1524 */     while ((this.i < this.length) && ((Character.isJavaLetterOrDigit(this.currentChar = this.odbc_sql.charAt(this.i))) || (this.currentChar == '?')))
/*      */     {
/* 1527 */       this.token_buffer.append(this.currentChar);
/*      */ 
/* 1529 */       this.i += 1;
/*      */     }
/*      */ 
/* 1535 */     String str = this.token_buffer.substring(0, this.token_buffer.length()).toUpperCase().intern();
/*      */ 
/* 1543 */     if (str == "ABS") {
/* 1544 */       usingFunctionName(str);
/* 1545 */     } else if (str == "ACOS") {
/* 1546 */       usingFunctionName(str);
/* 1547 */     } else if (str == "ASIN") {
/* 1548 */       usingFunctionName(str);
/* 1549 */     } else if (str == "ATAN") {
/* 1550 */       usingFunctionName(str);
/* 1551 */     } else if (str == "ATAN2") {
/* 1552 */       usingFunctionName(str);
/* 1553 */     } else if (str == "CEILING") {
/* 1554 */       usingFunctionName("CEIL");
/* 1555 */     } else if (str == "COS") {
/* 1556 */       usingFunctionName(str);
/*      */     }
/*      */     else
/*      */     {
/*      */       Object localObject;
/* 1557 */       if (str == "COT")
/*      */       {
/* 1559 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1560 */         ((SQLException)localObject).fillInStackTrace();
/* 1561 */         throw ((Throwable)localObject);
/*      */       }
/* 1563 */       if (str == "DEGREES")
/*      */       {
/* 1565 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1566 */         ((SQLException)localObject).fillInStackTrace();
/* 1567 */         throw ((Throwable)localObject);
/*      */       }
/* 1569 */       if (str == "EXP") {
/* 1570 */         usingFunctionName(str);
/* 1571 */       } else if (str == "FLOOR") {
/* 1572 */         usingFunctionName(str);
/* 1573 */       } else if (str == "LOG") {
/* 1574 */         usingFunctionName("LN");
/* 1575 */       } else if (str == "LOG10") {
/* 1576 */         replacingFunctionPrefix("LOG ( 10, ");
/* 1577 */       } else if (str == "MOD") {
/* 1578 */         usingFunctionName(str);
/* 1579 */       } else if (str == "PI") {
/* 1580 */         replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
/* 1581 */       } else if (str == "POWER") {
/* 1582 */         usingFunctionName(str); } else {
/* 1583 */         if (str == "RADIANS")
/*      */         {
/* 1585 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1586 */           ((SQLException)localObject).fillInStackTrace();
/* 1587 */           throw ((Throwable)localObject);
/*      */         }
/* 1589 */         if (str == "RAND")
/*      */         {
/* 1591 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1592 */           ((SQLException)localObject).fillInStackTrace();
/* 1593 */           throw ((Throwable)localObject);
/*      */         }
/* 1595 */         if (str == "ROUND") {
/* 1596 */           usingFunctionName(str);
/* 1597 */         } else if (str == "SIGN") {
/* 1598 */           usingFunctionName(str);
/* 1599 */         } else if (str == "SIN") {
/* 1600 */           usingFunctionName(str);
/* 1601 */         } else if (str == "SQRT") {
/* 1602 */           usingFunctionName(str);
/* 1603 */         } else if (str == "TAN") {
/* 1604 */           usingFunctionName(str);
/* 1605 */         } else if (str == "TRUNCATE") {
/* 1606 */           usingFunctionName("TRUNC");
/*      */         }
/* 1609 */         else if (str == "ASCII") {
/* 1610 */           usingFunctionName(str);
/* 1611 */         } else if (str == "CHAR") {
/* 1612 */           usingFunctionName("CHR");
/* 1613 */         } else if (str == "CHAR_LENGTH") {
/* 1614 */           usingFunctionName("LENGTH");
/* 1615 */         } else if (str == "CHARACTER_LENGTH") {
/* 1616 */           usingFunctionName("LENGTH");
/* 1617 */         } else if (str == "CONCAT") {
/* 1618 */           usingFunctionName(str); } else {
/* 1619 */           if (str == "DIFFERENCE")
/*      */           {
/* 1621 */             localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1622 */             ((SQLException)localObject).fillInStackTrace();
/* 1623 */             throw ((Throwable)localObject);
/*      */           }
/* 1625 */           if (str == "INSERT")
/*      */           {
/* 1627 */             localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1628 */             ((SQLException)localObject).fillInStackTrace();
/* 1629 */             throw ((Throwable)localObject);
/*      */           }
/* 1631 */           if (str == "LCASE") {
/* 1632 */             usingFunctionName("LOWER"); } else {
/* 1633 */             if (str == "LEFT")
/*      */             {
/* 1635 */               localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1636 */               ((SQLException)localObject).fillInStackTrace();
/* 1637 */               throw ((Throwable)localObject);
/*      */             }
/* 1639 */             if (str == "LENGTH") {
/* 1640 */               usingFunctionName(str);
/* 1641 */             } else if (str == "LOCATE")
/*      */             {
/* 1645 */               localObject = this.oracle_sql;
/* 1646 */               this.oracle_sql = new StringBuffer();
/* 1647 */               handleODBC(ParseMode.LOCATE_1);
/* 1648 */               StringBuffer localStringBuffer = this.oracle_sql;
/* 1649 */               this.oracle_sql = ((StringBuffer)localObject);
/* 1650 */               this.oracle_sql.append("INSTR(");
/* 1651 */               handleODBC(ParseMode.LOCATE_2);
/* 1652 */               this.oracle_sql.append(',');
/* 1653 */               this.oracle_sql.append(localStringBuffer);
/* 1654 */               this.oracle_sql.append(')');
/* 1655 */               handleODBC(ParseMode.SCALAR);
/*      */             }
/* 1657 */             else if (str == "LTRIM") {
/* 1658 */               usingFunctionName(str);
/* 1659 */             } else if (str == "OCTET_LENGTH") {
/* 1660 */               usingFunctionName("LENGTHB"); } else {
/* 1661 */               if (str == "POSITION")
/*      */               {
/* 1663 */                 localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1664 */                 ((SQLException)localObject).fillInStackTrace();
/* 1665 */                 throw ((Throwable)localObject);
/*      */               }
/* 1667 */               if (str == "REPEAT")
/*      */               {
/* 1669 */                 localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1670 */                 ((SQLException)localObject).fillInStackTrace();
/* 1671 */                 throw ((Throwable)localObject);
/*      */               }
/* 1673 */               if (str == "REPLACE") {
/* 1674 */                 usingFunctionName(str); } else {
/* 1675 */                 if (str == "RIGHT")
/*      */                 {
/* 1677 */                   localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1678 */                   ((SQLException)localObject).fillInStackTrace();
/* 1679 */                   throw ((Throwable)localObject);
/*      */                 }
/* 1681 */                 if (str == "RTRIM") {
/* 1682 */                   usingFunctionName(str);
/* 1683 */                 } else if (str == "SOUNDEX") {
/* 1684 */                   usingFunctionName(str); } else {
/* 1685 */                   if (str == "SPACE")
/*      */                   {
/* 1687 */                     localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1688 */                     ((SQLException)localObject).fillInStackTrace();
/* 1689 */                     throw ((Throwable)localObject);
/*      */                   }
/* 1691 */                   if (str == "SUBSTRING") {
/* 1692 */                     usingFunctionName("SUBSTR");
/* 1693 */                   } else if (str == "UCASE") {
/* 1694 */                     usingFunctionName("UPPER");
/*      */                   }
/* 1698 */                   else if (str == "CURRENT_DATE") {
/* 1699 */                     replacingFunctionPrefix("(CURRENT_DATE"); } else {
/* 1700 */                     if (str == "CURRENT_TIME")
/*      */                     {
/* 1702 */                       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1703 */                       ((SQLException)localObject).fillInStackTrace();
/* 1704 */                       throw ((Throwable)localObject);
/*      */                     }
/* 1706 */                     if (str == "CURRENT_TIMESTAMP") {
/* 1707 */                       replacingFunctionPrefix("(CURRENT_TIMESTAMP");
/* 1708 */                     } else if (str == "CURDATE") {
/* 1709 */                       replacingFunctionPrefix("(CURRENT_DATE");
/* 1710 */                     } else if (str == "CURTIME") {
/* 1711 */                       replacingFunctionPrefix("(CURRENT_TIMESTAMP"); } else {
/* 1712 */                       if (str == "DAYNAME")
/*      */                       {
/* 1714 */                         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1715 */                         ((SQLException)localObject).fillInStackTrace();
/* 1716 */                         throw ((Throwable)localObject);
/*      */                       }
/* 1718 */                       if (str == "DAYOFMONTH") {
/* 1719 */                         replacingFunctionPrefix("EXTRACT ( DAY FROM "); } else {
/* 1720 */                         if (str == "DAYOFWEEK")
/*      */                         {
/* 1722 */                           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1723 */                           ((SQLException)localObject).fillInStackTrace();
/* 1724 */                           throw ((Throwable)localObject);
/*      */                         }
/* 1726 */                         if (str == "DAYOFYEAR")
/*      */                         {
/* 1728 */                           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1729 */                           ((SQLException)localObject).fillInStackTrace();
/* 1730 */                           throw ((Throwable)localObject);
/*      */                         }
/* 1732 */                         if (str == "EXTRACT") {
/* 1733 */                           usingFunctionName("EXTRACT");
/* 1734 */                         } else if (str == "HOUR") {
/* 1735 */                           replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
/* 1736 */                         } else if (str == "MINUTE") {
/* 1737 */                           replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
/* 1738 */                         } else if (str == "MONTH") {
/* 1739 */                           replacingFunctionPrefix("EXTRACT ( MONTH FROM "); } else {
/* 1740 */                           if (str == "MONTHNAME")
/*      */                           {
/* 1742 */                             localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1743 */                             ((SQLException)localObject).fillInStackTrace();
/* 1744 */                             throw ((Throwable)localObject);
/*      */                           }
/* 1746 */                           if (str == "NOW") {
/* 1747 */                             replacingFunctionPrefix("(CURRENT_TIMESTAMP"); } else {
/* 1748 */                             if (str == "QUARTER")
/*      */                             {
/* 1750 */                               localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1751 */                               ((SQLException)localObject).fillInStackTrace();
/* 1752 */                               throw ((Throwable)localObject);
/*      */                             }
/* 1754 */                             if (str == "SECOND") {
/* 1755 */                               replacingFunctionPrefix("EXTRACT ( SECOND FROM "); } else {
/* 1756 */                               if (str == "TIMESTAMPADD")
/*      */                               {
/* 1758 */                                 localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1759 */                                 ((SQLException)localObject).fillInStackTrace();
/* 1760 */                                 throw ((Throwable)localObject);
/*      */                               }
/* 1762 */                               if (str == "TIMESTAMPDIFF")
/*      */                               {
/* 1764 */                                 localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1765 */                                 ((SQLException)localObject).fillInStackTrace();
/* 1766 */                                 throw ((Throwable)localObject);
/*      */                               }
/* 1768 */                               if (str == "WEEK")
/*      */                               {
/* 1770 */                                 localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1771 */                                 ((SQLException)localObject).fillInStackTrace();
/* 1772 */                                 throw ((Throwable)localObject);
/*      */                               }
/* 1774 */                               if (str == "YEAR") {
/* 1775 */                                 replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
/*      */                               }
/*      */                               else {
/* 1778 */                                 if (str == "DATABASE")
/*      */                                 {
/* 1780 */                                   localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1781 */                                   ((SQLException)localObject).fillInStackTrace();
/* 1782 */                                   throw ((Throwable)localObject);
/*      */                                 }
/* 1784 */                                 if (str == "IFNULL") {
/* 1785 */                                   usingFunctionName("NVL");
/* 1786 */                                 } else if (str == "USER") {
/* 1787 */                                   replacingFunctionPrefix("(USER");
/*      */                                 }
/*      */                                 else {
/* 1790 */                                   if (str == "CONVERT")
/*      */                                   {
/* 1793 */                                     localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1794 */                                     ((SQLException)localObject).fillInStackTrace();
/* 1795 */                                     throw ((Throwable)localObject);
/*      */                                   }
/*      */ 
/* 1801 */                                   localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 34, str);
/* 1802 */                                   ((SQLException)localObject).fillInStackTrace();
/* 1803 */                                   throw ((Throwable)localObject); }  }  }  }  }  }  }  }  }  } 
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/* 1811 */   void usingFunctionName(String paramString) throws SQLException { this.oracle_sql.append(paramString);
/* 1812 */     skipSpace();
/* 1813 */     handleODBC(ParseMode.SCALAR);
/*      */   }
/*      */ 
/*      */   void replacingFunctionPrefix(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1820 */     skipSpace();
/*      */ 
/* 1823 */     if ((this.i < this.length) && ((this.currentChar = this.odbc_sql.charAt(this.i)) == '(')) {
/* 1824 */       this.i += 1;
/*      */     }
/*      */     else {
/* 1827 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 33);
/* 1828 */       localSQLException.fillInStackTrace();
/* 1829 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1832 */     this.oracle_sql.append(paramString);
/* 1833 */     skipSpace();
/* 1834 */     handleODBC(ParseMode.SCALAR);
/*      */   }
/*      */ 
/*      */   void handleOuterJoin()
/*      */     throws SQLException
/*      */   {
/* 1841 */     this.oracle_sql.append(" ( ");
/* 1842 */     skipSpace();
/* 1843 */     handleODBC(ParseMode.SCALAR);
/* 1844 */     this.oracle_sql.append(" ) ");
/*      */   }
/*      */ 
/*      */   String nextArgument()
/*      */   {
/* 1851 */     String str = new StringBuilder().append(":").append(this.current_argument).toString();
/*      */ 
/* 1853 */     this.current_argument += 1;
/*      */ 
/* 1855 */     return str;
/*      */   }
/*      */ 
/*      */   void appendChar(StringBuffer paramStringBuffer, char paramChar)
/*      */   {
/* 1862 */     if (paramChar == '?')
/* 1863 */       paramStringBuffer.append(nextArgument());
/*      */     else
/* 1865 */       paramStringBuffer.append(paramChar);
/*      */   }
/*      */ 
/*      */   void skipSpace()
/*      */   {
/* 1872 */     while ((this.i < this.length) && ((this.currentChar = this.odbc_sql.charAt(this.i)) == ' '))
/* 1873 */       this.i += 1;
/*      */   }
/*      */ 
/*      */   String generateParameterName()
/*      */   {
/* 1884 */     if ((this.parameterCount == 0) || (this.parameterList == null))
/*      */     {
/* 1886 */       return new StringBuilder().append("rowid").append(this.paramSuffix++).toString();
/*      */     }
/*      */ 
/* 1892 */     String str = new StringBuilder().append("rowid").append(this.paramSuffix++).toString();
/* 1893 */     for (int j = 0; ; j++) { if (j >= this.parameterList.length)
/*      */         break label109;
/* 1895 */       if (str.equals(this.parameterList[j]))
/*      */         break; }
/* 1897 */     label109: return str;
/*      */   }
/*      */ 
/*      */   static boolean isValidPlsqlWarning(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1917 */     return paramString.matches("('\\s*([a-zA-Z0-9:,\\(\\)\\s])*')\\s*(,\\s*'([a-zA-Z0-9:,\\(\\)\\s])*')*");
/*      */   }
/*      */ 
/*      */   public static boolean isValidObjectName(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1935 */     if (paramString.matches("([a-zA-Z]{1}\\w*(\\$|\\#)*\\w*)|(\".*)"))
/*      */     {
/* 1937 */       return true;
/*      */     }
/*      */ 
/* 1944 */     char[] arrayOfChar = paramString.toCharArray();
/* 1945 */     int j = arrayOfChar.length;
/*      */ 
/* 1948 */     if (!Character.isLetter(arrayOfChar[0]))
/*      */     {
/* 1950 */       return false;
/*      */     }
/*      */ 
/* 1953 */     for (int k = 1; k < j; k++)
/*      */     {
/* 1955 */       if ((!Character.isLetterOrDigit(arrayOfChar[k])) && (arrayOfChar[k] != '$') && (arrayOfChar[k] != '#') && (arrayOfChar[k] != '_'))
/*      */       {
/* 1960 */         return false;
/*      */       }
/*      */     }
/*      */ 
/* 1964 */     return true;
/*      */   }
/*      */ 
/*      */   public static void main(String[] paramArrayOfString)
/*      */   {
/* 1989 */     if (paramArrayOfString.length < 2) {
/* 1990 */       System.err.println("ERROR: incorrect usage. OracleSql (-transition <file> | <process_escapes> <convert_nchars> { <sql> } )");
/* 1991 */       return;
/*      */     }
/* 1993 */     if (paramArrayOfString[0].equals("-dump")) {
/* 1994 */       dumpTransitionMatrix(paramArrayOfString[1]);
/* 1995 */       return;
/*      */     }
/* 1997 */     boolean bool1 = paramArrayOfString[0].equals("true");
/* 1998 */     boolean bool2 = paramArrayOfString[1].equals("true");
/*      */     String[] arrayOfString1;
/* 2001 */     if (paramArrayOfString.length > 2) {
/* 2002 */       arrayOfString1 = new String[paramArrayOfString.length - 2];
/* 2003 */       System.arraycopy(paramArrayOfString, 2, arrayOfString1, 0, arrayOfString1.length);
/*      */     }
/*      */     else {
/* 2006 */       arrayOfString1 = new String[] { "select ? from dual", "insert into dual values (?)", "delete from dual", "update dual set dummy = ?", "merge tab into dual", " select ? from dual where ? = ?", "select ?from dual where?=?for update", "select '?', n'?', q'???', q'{?}', q'{cat's}' from dual", "select'?',n'?',q'???',q'{?}',q'{cat's}'from dual", "select--line\n? from dual", "select --line\n? from dual", "--line\nselect ? from dual", " --line\nselect ? from dual", "--line\n select ? from dual", "begin proc4in4out (:x1, :x2, :x3, :x4); end;", "{CALL tkpjpn01(:pin, :pinout, :pout)}", "select :NumberBindVar as the_number from dual", "select {fn locate(bob(carol(),ted(alice,sue)), 'xfy')} from dual", "CREATE USER vijay6 IDENTIFIED BY \"vjay?\"", "ALTER SESSION SET TIME", "SELECT ename FROM emp WHERE hiredate BETWEEN {ts'1980-12-17'} AND {ts '1981-09-28'} " };
/*      */     }
/*      */ 
/* 2035 */     for (String str1 : arrayOfString1)
/*      */       try {
/* 2037 */         System.out.println("\n\n-----------------------");
/* 2038 */         System.out.println(str1);
/* 2039 */         System.out.println();
/* 2040 */         OracleSql localOracleSql = new OracleSql(null);
/*      */ 
/* 2042 */         localOracleSql.initialize(str1);
/* 2043 */         String str2 = localOracleSql.getSql(bool1, bool2);
/*      */ 
/* 2045 */         System.out.println(new StringBuilder().append(localOracleSql.sqlKind).append(", ").append(localOracleSql.parameterCount).toString());
/*      */ 
/* 2047 */         String[] arrayOfString3 = localOracleSql.getParameterList();
/*      */         int m;
/* 2049 */         if (arrayOfString3 == EMPTY_LIST)
/* 2050 */           System.out.println("parameterList is empty");
/*      */         else {
/* 2052 */           for (m = 0; m < arrayOfString3.length; m++)
/* 2053 */             System.out.println(new StringBuilder().append("parameterList[").append(m).append("] = ").append(arrayOfString3[m]).toString());
/*      */         }
/* 2055 */         if (localOracleSql.getSqlKind().isDML()) {
/* 2056 */           m = localOracleSql.getReturnParameterCount();
/* 2057 */           if (m == -1) System.out.println("no return parameters"); else {
/* 2058 */             System.out.println(new StringBuilder().append(m).append(" return parameters").toString());
/*      */           }
/*      */         }
/* 2061 */         if (localOracleSql.lastNcharLiteralLocation == 2) { System.out.println("No NCHAR literals");
/*      */         } else {
/* 2063 */           System.out.println("NCHAR Literals");
/* 2064 */           for (m = 1; m < localOracleSql.lastNcharLiteralLocation - 1; )
/* 2065 */             System.out.println(str2.substring(localOracleSql.ncharLiteralLocation[(m++)], localOracleSql.ncharLiteralLocation[(m++)]));
/*      */         }
/* 2067 */         System.out.println("Keywords");
/* 2068 */         if (localOracleSql.selectEndIndex == -1) System.out.println("no select"); else
/* 2069 */           System.out.println(new StringBuilder().append("'").append(str2.substring(localOracleSql.selectEndIndex - 6, localOracleSql.selectEndIndex)).append("'").toString());
/* 2070 */         if (localOracleSql.orderByStartIndex == -1) System.out.println("no order by"); else
/* 2071 */           System.out.println(new StringBuilder().append("'").append(str2.substring(localOracleSql.orderByStartIndex, localOracleSql.orderByEndIndex)).append("'").toString());
/* 2072 */         if (localOracleSql.whereStartIndex == -1) System.out.println("no where"); else
/* 2073 */           System.out.println(new StringBuilder().append("'").append(str2.substring(localOracleSql.whereStartIndex, localOracleSql.whereEndIndex)).append("'").toString());
/* 2074 */         if (localOracleSql.forUpdateStartIndex == -1) System.out.println("no for update"); else {
/* 2075 */           System.out.println(new StringBuilder().append("'").append(str2.substring(localOracleSql.forUpdateStartIndex, localOracleSql.forUpdateEndIndex)).append("'").toString());
/*      */         }
/* 2077 */         System.out.println(new StringBuilder().append("isPlsqlOrCall(): ").append(localOracleSql.getSqlKind().isPlsqlOrCall()).toString());
/* 2078 */         System.out.println(new StringBuilder().append("isDML(): ").append(localOracleSql.getSqlKind().isDML()).toString());
/* 2079 */         System.out.println(new StringBuilder().append("isSELECT(): ").append(localOracleSql.getSqlKind().isSELECT()).toString());
/* 2080 */         System.out.println(new StringBuilder().append("isOTHER(): ").append(localOracleSql.getSqlKind().isOTHER()).toString());
/* 2081 */         System.out.println(new StringBuilder().append("\"").append(str2).append("\"").toString());
/* 2082 */         System.out.println(new StringBuilder().append("\"").append(localOracleSql.getRevisedSql()).append("\"").toString());
/* 2083 */         System.out.println(new StringBuilder().append("\"").append(localOracleSql.getRefetchSql()).append("\"").toString());
/*      */       }
/*      */       catch (Exception localException) {
/* 2086 */         System.out.println(localException);
/*      */       }
/*      */   }
/*      */ 
/*      */   private static final void dumpTransitionMatrix(String paramString)
/*      */   {
/*      */     try {
/* 2093 */       PrintWriter localPrintWriter = new PrintWriter(paramString);
/* 2094 */       localPrintWriter.print(",");
/* 2095 */       for (int j = 0; j < 128; j++) localPrintWriter.print(new StringBuilder().append("'").append(j < 32 ? new StringBuilder().append("0x").append(Integer.toHexString(j)).toString() : Character.toString((char)j)).append(j < 127 ? "'," : "'").toString());
/* 2096 */       localPrintWriter.println();
/* 2097 */       int[][] arrayOfInt = OracleSqlReadOnly.TRANSITION;
/* 2098 */       String[] arrayOfString = OracleSqlReadOnly.PARSER_STATE_NAME;
/* 2099 */       for (int k = 0; k < TRANSITION.length; k++) {
/* 2100 */         localPrintWriter.print(new StringBuilder().append(arrayOfString[k]).append(",").toString());
/* 2101 */         for (int m = 0; m < arrayOfInt[k].length; m++) localPrintWriter.print(new StringBuilder().append(arrayOfString[arrayOfInt[k][m]]).append(m < 127 ? "," : "").toString());
/* 2102 */         localPrintWriter.println();
/*      */       }
/* 2104 */       localPrintWriter.close();
/*      */     }
/*      */     catch (Throwable localThrowable) {
/* 2107 */       System.err.println(localThrowable);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 2124 */     return null;
/*      */   }
/*      */ 
/*      */   int getReturnParameterCount()
/*      */     throws SQLException
/*      */   {
/* 2137 */     if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
/* 2138 */       computeBasicInfo(this.parameterSql);
/*      */     }
/*      */ 
/* 2141 */     if (!this.sqlKind.isDML()) return -1;
/* 2142 */     return this.returningIntoParameterCount;
/*      */   }
/*      */ 
/*      */   private int getSubstrPos(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 2150 */     int j = -1;
/* 2151 */     int k = paramString1.indexOf(paramString2);
/*      */ 
/* 2153 */     if ((k >= 1) && (Character.isWhitespace(paramString1.charAt(k - 1))))
/*      */     {
/* 2156 */       int m = k + paramString2.length();
/*      */ 
/* 2158 */       if ((m < paramString1.length()) && (Character.isWhitespace(paramString1.charAt(m))))
/*      */       {
/* 2161 */         j = k;
/*      */       }
/*      */     }
/* 2164 */     return j;
/*      */   }
/*      */ 
/*      */   static enum ParseMode
/*      */   {
/* 1155 */     NORMAL, SCALAR, LOCATE_1, LOCATE_2;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleSql
 * JD-Core Version:    0.6.2
 */