/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class OracleSavepoint
/*     */   implements oracle.jdbc.internal.OracleSavepoint
/*     */ {
/*     */   private static final int MAX_ID_VALUE = 65535;
/*     */   private static final int INVALID_ID_VALUE = -1;
/*     */   static final int NAMED_SAVEPOINT_TYPE = 2;
/*     */   static final int UNNAMED_SAVEPOINT_TYPE = 1;
/*     */   static final int UNKNOWN_SAVEPOINT_TYPE = 0;
/*  31 */   private static int s_seedId = 0;
/*  32 */   private int m_id = -1;
/*  33 */   private String m_name = null;
/*  34 */   private int m_type = 0;
/*     */   Object acProxy;
/* 181 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleSavepoint()
/*     */   {
/*  45 */     this.m_type = 1;
/*  46 */     this.m_id = getNextId();
/*  47 */     this.m_name = null;
/*     */   }
/*     */ 
/*     */   OracleSavepoint(String paramString)
/*     */     throws SQLException
/*     */   {
/*  61 */     if ((paramString != null) && (paramString.length() != 0) && (!OracleSql.isValidObjectName(paramString)))
/*     */     {
/*  65 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  66 */       localSQLException.fillInStackTrace();
/*  67 */       throw localSQLException;
/*     */     }
/*     */ 
/*  70 */     if ((paramString == null) || (paramString.trim().compareTo("") == 0))
/*     */     {
/*  72 */       this.m_type = 1;
/*  73 */       this.m_id = getNextId();
/*  74 */       this.m_name = null;
/*     */     }
/*     */     else
/*     */     {
/*  78 */       this.m_type = 2;
/*  79 */       this.m_name = paramString;
/*  80 */       this.m_id = -1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getSavepointId()
/*     */     throws SQLException
/*     */   {
/*  98 */     if (this.m_type == 2)
/*     */     {
/* 100 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 118);
/* 101 */       localSQLException.fillInStackTrace();
/* 102 */       throw localSQLException;
/*     */     }
/*     */ 
/* 105 */     return this.m_id;
/*     */   }
/*     */ 
/*     */   public String getSavepointName()
/*     */     throws SQLException
/*     */   {
/* 122 */     if (this.m_type == 1)
/*     */     {
/* 124 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 119);
/* 125 */       localSQLException.fillInStackTrace();
/* 126 */       throw localSQLException;
/*     */     }
/*     */ 
/* 129 */     return this.m_name;
/*     */   }
/*     */ 
/*     */   int getType()
/*     */   {
/* 140 */     return this.m_type;
/*     */   }
/*     */ 
/*     */   private synchronized int getNextId()
/*     */   {
/* 147 */     s_seedId = (s_seedId + 1) % 65535;
/*     */ 
/* 149 */     return s_seedId;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 164 */     return null;
/*     */   }
/*     */ 
/*     */   public void setACProxy(Object paramObject)
/*     */   {
/* 172 */     this.acProxy = paramObject;
/*     */   }
/*     */ 
/*     */   public Object getACProxy()
/*     */   {
/* 177 */     return this.acProxy;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleSavepoint
 * JD-Core Version:    0.6.2
 */