/*    */ package oracle.jdbc.driver;
/*    */ 
/*    */ import java.sql.ResultSetMetaData;
/*    */ import java.sql.SQLException;
/*    */ 
/*    */ class OracleReturnResultSet extends ForwardOnlyResultSet
/*    */ {
/* 84 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*    */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*    */   public static final boolean TRACE = false;
/*    */ 
/*    */   OracleReturnResultSet(PhysicalConnection paramPhysicalConnection, OracleStatement paramOracleStatement)
/*    */     throws SQLException
/*    */   {
/* 19 */     super(paramPhysicalConnection, paramOracleStatement);
/*    */   }
/*    */ 
/*    */   public void close()
/*    */     throws SQLException
/*    */   {
/* 25 */     synchronized (this.statement.connection)
/*    */     {
/* 33 */       super.close();
/*    */ 
/* 35 */       this.statement.currentResultSet = null;
/* 36 */       this.statement.returnParamsFetched = false;
/* 37 */       this.statement.rowsDmlReturned = 0;
/*    */     }
/*    */   }
/*    */ 
/*    */   public ResultSetMetaData getMetaData()
/*    */     throws SQLException
/*    */   {
/* 45 */     synchronized (this.statement.connection)
/*    */     {
/* 53 */       if (!this.statement.isAutoGeneratedKey)
/*    */       {
/* 55 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/* 56 */         ((SQLException)localObject1).fillInStackTrace();
/* 57 */         throw ((Throwable)localObject1);
/*    */       }
/*    */ 
/* 60 */       if (this.closed)
/*    */       {
/* 62 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 63 */         ((SQLException)localObject1).fillInStackTrace();
/* 64 */         throw ((Throwable)localObject1);
/*    */       }
/*    */ 
/* 67 */       if (this.statement.closed)
/*    */       {
/* 69 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 70 */         ((SQLException)localObject1).fillInStackTrace();
/* 71 */         throw ((Throwable)localObject1);
/*    */       }
/*    */ 
/* 74 */       Object localObject1 = this.statement.autoKeyInfo;
/* 75 */       ((AutoKeyInfo)localObject1).statement = this.statement;
/* 76 */       ((AutoKeyInfo)localObject1).connection = this.connection;
/* 77 */       ((AutoKeyInfo)localObject1).initMetaData(this);
/* 78 */       return localObject1;
/*    */     }
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleReturnResultSet
 * JD-Core Version:    0.6.2
 */