/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.sql.SQLException;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleArray;
/*      */ import oracle.jdbc.OracleBfile;
/*      */ import oracle.jdbc.OracleBlob;
/*      */ import oracle.jdbc.OracleClob;
/*      */ import oracle.jdbc.OracleNClob;
/*      */ import oracle.jdbc.OracleOpaque;
/*      */ import oracle.jdbc.OracleRef;
/*      */ import oracle.jdbc.OracleResultSetMetaData.SecurityAttribute;
/*      */ import oracle.jdbc.OracleStruct;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.oracore.OracleNamedType;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.sql.StructDescriptor;
/*      */ import oracle.sql.TypeDescriptor;
/*      */ 
/*      */ class OracleResultSetMetaData
/*      */   implements oracle.jdbc.internal.OracleResultSetMetaData
/*      */ {
/*      */   PhysicalConnection connection;
/*      */   OracleStatement statement;
/*      */   int offsetOfFirstUserColumn;
/*      */   Object acProxy;
/* 1085 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleResultSetMetaData()
/*      */   {
/*      */   }
/*      */ 
/*      */   OracleResultSetMetaData(PhysicalConnection paramPhysicalConnection, OracleStatement paramOracleStatement, int paramInt)
/*      */     throws SQLException
/*      */   {
/*   49 */     this.connection = paramPhysicalConnection;
/*   50 */     this.statement = paramOracleStatement;
/*      */ 
/*   52 */     paramOracleStatement.describe();
/*      */ 
/*   54 */     this.offsetOfFirstUserColumn = paramInt;
/*      */   }
/*      */ 
/*      */   public int getColumnCount()
/*      */     throws SQLException
/*      */   {
/*   71 */     return this.statement.getNumberOfColumns();
/*      */   }
/*      */ 
/*      */   public boolean isAutoIncrement(int paramInt)
/*      */     throws SQLException
/*      */   {
/*   89 */     return false;
/*      */   }
/*      */ 
/*      */   int getValidColumnIndex(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  111 */     if ((paramInt <= 0) || (paramInt > this.statement.getNumberOfColumns()))
/*      */     {
/*  113 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex");
/*  114 */       localSQLException.fillInStackTrace();
/*  115 */       throw localSQLException;
/*      */     }
/*      */ 
/*  118 */     int i = paramInt + this.offsetOfFirstUserColumn;
/*  119 */     return i;
/*      */   }
/*      */ 
/*      */   public boolean isCaseSensitive(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  137 */     int i = getColumnType(paramInt);
/*      */ 
/*  139 */     return (i == 1) || (i == 12) || (i == -1) || (i == -15) || (i == -9);
/*      */   }
/*      */ 
/*      */   public boolean isSearchable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  162 */     int i = getColumnType(paramInt);
/*      */ 
/*  165 */     return (i != -4) && (i != -1) && (i != 2004) && (i != 2005) && (i != -13) && (i != 2011) && (i != 2002) && (i != 2008) && (i != 2007) && (i != 2003) && (i != 2006) && (i != -10);
/*      */   }
/*      */ 
/*      */   public boolean isCurrency(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  190 */     int i = getColumnType(paramInt);
/*      */ 
/*  192 */     return (i == 2) || (i == 6);
/*      */   }
/*      */ 
/*      */   public int isNullable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  210 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  212 */     return getDescription()[i].nullable ? 1 : 0;
/*      */   }
/*      */ 
/*      */   public boolean isSigned(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  231 */     return true;
/*      */   }
/*      */ 
/*      */   public int getColumnDisplaySize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  249 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  252 */     int j = getDescription()[i].describeType;
/*      */ 
/*  254 */     switch (j)
/*      */     {
/*      */     case 2:
/*  258 */       int k = getPrecision(paramInt);
/*  259 */       int m = getDescription()[i].scale;
/*      */ 
/*  261 */       if ((k != 0) && (m == -127))
/*      */       {
/*  265 */         k = (int)(k / 3.32193D);
/*  266 */         m = 1;
/*      */       }
/*      */       else
/*      */       {
/*  270 */         if (k == 0) {
/*  271 */           k = 38;
/*      */         }
/*  273 */         if (m == -127) {
/*  274 */           m = 0;
/*      */         }
/*      */       }
/*  277 */       int n = k + (m != 0 ? 1 : 0) + 1;
/*      */ 
/*  279 */       return n;
/*      */     }
/*      */ 
/*  283 */     return getDescription()[i].describeMaxLength;
/*      */   }
/*      */ 
/*      */   public String getColumnLabel(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  303 */     return getColumnName(paramInt);
/*      */   }
/*      */ 
/*      */   public String getColumnName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  321 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  323 */     return this.statement.getDescriptionWithNames()[i].columnName;
/*      */   }
/*      */ 
/*      */   public String getSchemaName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  342 */     return "";
/*      */   }
/*      */ 
/*      */   public int getPrecision(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  360 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  363 */     int j = getDescription()[i].describeType;
/*      */ 
/*  365 */     switch (j)
/*      */     {
/*      */     case 112:
/*      */     case 113:
/*  369 */       return -1;
/*      */     case 8:
/*      */     case 24:
/*  373 */       return 2147483647;
/*      */     case 1:
/*      */     case 96:
/*  377 */       return getDescription()[i].describeMaxLengthChars;
/*      */     }
/*      */ 
/*  380 */     return getDescription()[i].precision;
/*      */   }
/*      */ 
/*      */   public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  394 */     int i = getValidColumnIndex(paramInt);
/*  395 */     return getDescription()[i].securityAttribute;
/*      */   }
/*      */ 
/*      */   public int getScale(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  413 */     int i = getValidColumnIndex(paramInt);
/*  414 */     int j = getDescription()[i].scale;
/*      */ 
/*  416 */     return (j == -127) && (this.statement.connection.j2ee13Compliant) ? 0 : j;
/*      */   }
/*      */ 
/*      */   public boolean isVariableScale(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  435 */     int i = getValidColumnIndex(paramInt);
/*  436 */     int j = getDescription()[i].scale;
/*      */ 
/*  438 */     return j == -127;
/*      */   }
/*      */ 
/*      */   public String getTableName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  456 */     return "";
/*      */   }
/*      */ 
/*      */   public String getCatalogName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  475 */     return "";
/*      */   }
/*      */ 
/*      */   public int getColumnType(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  498 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  501 */     int j = getDescription()[i].describeType;
/*      */ 
/*  505 */     switch (j)
/*      */     {
/*      */     case 96:
/*  508 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  510 */         return -15;
/*      */       }
/*  512 */       return 1;
/*      */     case 1:
/*  515 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  517 */         return -9;
/*      */       }
/*  519 */       return 12;
/*      */     case 8:
/*  522 */       return -1;
/*      */     case 2:
/*      */     case 6:
/*  526 */       if ((this.statement.connection.j2ee13Compliant) && (getDescription()[i].precision != 0) && (getDescription()[i].scale == -127))
/*      */       {
/*  529 */         return 6;
/*      */       }
/*  531 */       return 2;
/*      */     case 100:
/*  534 */       return 100;
/*      */     case 101:
/*  537 */       return 101;
/*      */     case 23:
/*  540 */       return -3;
/*      */     case 24:
/*  543 */       return -4;
/*      */     case 104:
/*      */     case 208:
/*  547 */       return -8;
/*      */     case 102:
/*  550 */       return -10;
/*      */     case 12:
/*  556 */       return this.connection.mapDateToTimestamp ? 93 : 91;
/*      */     case 180:
/*  560 */       return 93;
/*      */     case 181:
/*  563 */       return -101;
/*      */     case 231:
/*  566 */       return -102;
/*      */     case 113:
/*  569 */       return 2004;
/*      */     case 112:
/*  572 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  574 */         return 2011;
/*      */       }
/*  576 */       return 2005;
/*      */     case 114:
/*  579 */       return -13;
/*      */     case 109:
/*  583 */       OracleNamedType localOracleNamedType = (OracleNamedType)getDescription()[i].describeOtype;
/*      */ 
/*  586 */       TypeDescriptor localTypeDescriptor = TypeDescriptor.getTypeDescriptor(localOracleNamedType.getFullName(), this.connection);
/*      */ 
/*  590 */       if (localTypeDescriptor != null) {
/*  591 */         return localTypeDescriptor.getTypeCode();
/*      */       }
/*      */ 
/*  594 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60);
/*  595 */       localSQLException.fillInStackTrace();
/*  596 */       throw localSQLException;
/*      */     case 111:
/*  601 */       return 2006;
/*      */     case 182:
/*  604 */       return -103;
/*      */     case 183:
/*  607 */       return -104;
/*      */     }
/*      */ 
/*  610 */     return 1111;
/*      */   }
/*      */ 
/*      */   public String getColumnTypeName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  629 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  632 */     int j = getDescription()[i].describeType;
/*      */     OracleTypeADT localOracleTypeADT;
/*  636 */     switch (j)
/*      */     {
/*      */     case 96:
/*  639 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  641 */         return "NCHAR";
/*      */       }
/*  643 */       return "CHAR";
/*      */     case 1:
/*  646 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  648 */         return "NVARCHAR2";
/*      */       }
/*  650 */       return "VARCHAR2";
/*      */     case 8:
/*  653 */       return "LONG";
/*      */     case 2:
/*      */     case 6:
/*  657 */       if ((this.statement.connection.j2ee13Compliant) && (getDescription()[i].precision != 0) && (getDescription()[i].scale == -127))
/*      */       {
/*  660 */         return "FLOAT";
/*      */       }
/*  662 */       return "NUMBER";
/*      */     case 100:
/*  665 */       return "BINARY_FLOAT";
/*      */     case 101:
/*  668 */       return "BINARY_DOUBLE";
/*      */     case 23:
/*  671 */       return "RAW";
/*      */     case 24:
/*  674 */       return "LONG RAW";
/*      */     case 104:
/*      */     case 208:
/*  678 */       return "ROWID";
/*      */     case 102:
/*  681 */       return "REFCURSOR";
/*      */     case 12:
/*  687 */       return "DATE";
/*      */     case 180:
/*  690 */       return "TIMESTAMP";
/*      */     case 181:
/*  693 */       return "TIMESTAMP WITH TIME ZONE";
/*      */     case 231:
/*  696 */       return "TIMESTAMP WITH LOCAL TIME ZONE";
/*      */     case 113:
/*  699 */       return "BLOB";
/*      */     case 112:
/*  702 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  704 */         return "NCLOB";
/*      */       }
/*  706 */       return "CLOB";
/*      */     case 114:
/*  709 */       return "BFILE";
/*      */     case 109:
/*  713 */       localOracleTypeADT = (OracleTypeADT)getDescription()[i].describeOtype;
/*      */ 
/*  716 */       return localOracleTypeADT.getFullName();
/*      */     case 111:
/*  721 */       localOracleTypeADT = (OracleTypeADT)getDescription()[i].describeOtype;
/*      */ 
/*  724 */       return localOracleTypeADT.getFullName();
/*      */     case 182:
/*  728 */       return "INTERVALYM";
/*      */     case 183:
/*  731 */       return "INTERVALDS";
/*      */     }
/*      */ 
/*  734 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  754 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isWritable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  773 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean isDefinitelyWritable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  792 */     return false;
/*      */   }
/*      */ 
/*      */   public String getColumnClassName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  819 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  822 */     int j = getDescription()[i].describeType;
/*      */ 
/*  824 */     switch (j)
/*      */     {
/*      */     case 1:
/*      */     case 8:
/*      */     case 96:
/*      */     case 999:
/*  830 */       return "java.lang.String";
/*      */     case 2:
/*      */     case 6:
/*  834 */       if ((getDescription()[i].precision != 0) && (getDescription()[i].scale == -127))
/*      */       {
/*  836 */         return "java.lang.Double";
/*      */       }
/*  838 */       return "java.math.BigDecimal";
/*      */     case 23:
/*      */     case 24:
/*  842 */       return "byte[]";
/*      */     case 12:
/*  845 */       return "java.sql.Timestamp";
/*      */     case 180:
/*  848 */       if (this.statement.connection.j2ee13Compliant) {
/*  849 */         return "java.sql.Timestamp";
/*      */       }
/*  851 */       return "oracle.sql.TIMESTAMP";
/*      */     case 181:
/*  854 */       return "oracle.sql.TIMESTAMPTZ";
/*      */     case 231:
/*  857 */       return "oracle.sql.TIMESTAMPLTZ";
/*      */     case 182:
/*  860 */       return "oracle.sql.INTERVALYM";
/*      */     case 183:
/*  863 */       return "oracle.sql.INTERVALDS";
/*      */     case 104:
/*      */     case 208:
/*  867 */       return "oracle.sql.ROWID";
/*      */     case 113:
/*  870 */       return OracleBlob.class.getName();
/*      */     case 112:
/*  873 */       if (getDescription()[i].formOfUse == 2)
/*      */       {
/*  875 */         return OracleNClob.class.getName();
/*      */       }
/*  877 */       return OracleClob.class.getName();
/*      */     case 114:
/*  880 */       return OracleBfile.class.getName();
/*      */     case 102:
/*  883 */       return "OracleResultSet";
/*      */     case 109:
/*      */       Object localObject2;
/*  887 */       switch (getColumnType(paramInt))
/*      */       {
/*      */       case 2003:
/*  890 */         return OracleArray.class.getName();
/*      */       case 2007:
/*  893 */         return OracleOpaque.class.getName();
/*      */       case 2008:
/*  897 */         localObject1 = (OracleNamedType)getDescription()[i].describeOtype;
/*      */ 
/*  900 */         localObject2 = this.connection.getJavaObjectTypeMap();
/*      */ 
/*  902 */         if (localObject2 != null)
/*      */         {
/*  904 */           Class localClass = (Class)((Map)localObject2).get(((OracleNamedType)localObject1).getFullName());
/*      */ 
/*  906 */           if (localClass != null) {
/*  907 */             return localClass.getName();
/*      */           }
/*      */         }
/*  910 */         return StructDescriptor.getJavaObjectClassName(this.connection, ((OracleNamedType)localObject1).getSchemaName(), ((OracleNamedType)localObject1).getSimpleName());
/*      */       case 2002:
/*  916 */         localObject1 = this.connection.getTypeMap();
/*      */ 
/*  918 */         if (localObject1 != null)
/*      */         {
/*  920 */           localObject2 = (Class)((Map)localObject1).get(((OracleNamedType)getDescription()[i].describeOtype).getFullName());
/*      */ 
/*  923 */           if (localObject2 != null) {
/*  924 */             return ((Class)localObject2).getName();
/*      */           }
/*      */         }
/*  927 */         return OracleStruct.class.getName();
/*      */       case 2009:
/*  931 */         return "java.sql.SQLXML";
/*      */       case 2004:
/*      */       case 2005:
/*      */       case 2006:
/*  935 */       }Object localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  936 */       ((SQLException)localObject1).fillInStackTrace();
/*  937 */       throw ((Throwable)localObject1);
/*      */     case 111:
/*  943 */       return OracleRef.class.getName();
/*      */     case 101:
/*  947 */       return "oracle.sql.BINARY_DOUBLE";
/*      */     case 100:
/*  950 */       return "oracle.sql.BINARY_FLOAT";
/*      */     }
/*      */ 
/*  953 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean isNCHAR(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  977 */     int i = getValidColumnIndex(paramInt);
/*      */ 
/*  979 */     return getDescription()[i].formOfUse == 2;
/*      */   }
/*      */ 
/*      */   public boolean isColumnInvisible(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  992 */     int i = getValidColumnIndex(paramInt);
/*  993 */     return getDescription()[i].isColumnInvisible();
/*      */   }
/*      */ 
/*      */   Accessor[] getDescription()
/*      */     throws SQLException
/*      */   {
/* 1002 */     return this.statement.getDescription();
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1022 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 1024 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1025 */     localSQLException.fillInStackTrace();
/* 1026 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1048 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 1050 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1051 */     localSQLException.fillInStackTrace();
/* 1052 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1068 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 1076 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 1081 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleResultSetMetaData
 * JD-Core Version:    0.6.2
 */