/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.Statement;
/*      */ import oracle.jdbc.OracleResultSet.AuthorizationIndicator;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ 
/*      */ abstract class OracleResultSet extends GeneratedResultSet
/*      */ {
/*      */   static final boolean DEBUG = false;
/*      */   boolean closed;
/*      */   SQLWarning sqlWarning;
/*  256 */   protected boolean closeStatementOnClose = false;
/*      */ 
/* 1104 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   static OracleResultSet createResultSet(OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/*  233 */     if (!paramOracleStatement.sqlKind.isSELECT()) {
/*  234 */       paramOracleStatement.realRsetType = ResultSetType.FORWARD_READ_ONLY;
/*  235 */       paramOracleStatement.described = true;
/*      */     }
/*      */ 
/*  238 */     if (paramOracleStatement.realRsetType == ResultSetType.UNKNOWN) {
/*  239 */       return paramOracleStatement.userRsetType.createResultSet(paramOracleStatement);
/*      */     }
/*      */ 
/*  242 */     return paramOracleStatement.realRsetType.createResultSet(paramOracleStatement);
/*      */   }
/*      */ 
/*      */   protected OracleResultSet(PhysicalConnection paramPhysicalConnection)
/*      */   {
/*  263 */     super(paramPhysicalConnection);
/*      */ 
/*  265 */     this.closed = false;
/*  266 */     this.sqlWarning = null;
/*      */   }
/*      */ 
/*      */   protected abstract void doneFetchingRows(boolean paramBoolean)
/*      */     throws SQLException;
/*      */ 
/*      */   public void closeStatementOnClose()
/*      */   {
/*  285 */     this.closeStatementOnClose = true;
/*      */   }
/*      */ 
/*      */   public abstract OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(String paramString)
/*      */     throws SQLException
/*      */   {
/*  296 */     return getAuthorizationIndicator(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   boolean isValidRow()
/*      */     throws SQLException
/*      */   {
/*  307 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "isValidRow");
/*  308 */     localSQLException.fillInStackTrace();
/*  309 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*  326 */     this.closed = true;
/*      */   }
/*      */ 
/*      */   public boolean isClosed()
/*      */     throws SQLException
/*      */   {
/*  339 */     return this.closed;
/*      */   }
/*      */ 
/*      */   public SQLWarning getWarnings()
/*      */     throws SQLException
/*      */   {
/*  358 */     return this.sqlWarning;
/*      */   }
/*      */ 
/*      */   public void clearWarnings()
/*      */     throws SQLException
/*      */   {
/*  377 */     this.sqlWarning = null;
/*      */   }
/*      */ 
/*      */   public abstract String getCursorName()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ResultSetMetaData getMetaData()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean next()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean wasNull()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isBeforeFirst()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isAfterLast()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isFirst()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isLast()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void beforeFirst()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void afterLast()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean first()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean last()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean absolute(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean relative(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean previous()
/*      */     throws SQLException;
/*      */ 
/*      */   public void setFetchDirection(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   public int getFetchDirection()
/*      */     throws SQLException
/*      */   {
/*  623 */     return 1000;
/*      */   }
/*      */ 
/*      */   public abstract void setFetchSize(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getFetchSize()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getType()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getConcurrency()
/*      */     throws SQLException;
/*      */ 
/*      */   public int getHoldability()
/*      */     throws SQLException
/*      */   {
/*  684 */     if (isClosed())
/*      */     {
/*  686 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, null);
/*  687 */       localSQLException.fillInStackTrace();
/*  688 */       throw localSQLException;
/*      */     }
/*      */ 
/*  693 */     return 1;
/*      */   }
/*      */ 
/*      */   public void insertRow()
/*      */     throws SQLException
/*      */   {
/*  717 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "insertRow");
/*  718 */     localSQLException.fillInStackTrace();
/*  719 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateRow()
/*      */     throws SQLException
/*      */   {
/*  741 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateRow");
/*  742 */     localSQLException.fillInStackTrace();
/*  743 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void deleteRow()
/*      */     throws SQLException
/*      */   {
/*  765 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "deleteRow");
/*  766 */     localSQLException.fillInStackTrace();
/*  767 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void refreshRow()
/*      */     throws SQLException
/*      */   {
/*  801 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, null);
/*  802 */     localSQLException.fillInStackTrace();
/*  803 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void moveToInsertRow()
/*      */     throws SQLException
/*      */   {
/*  825 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "moveToInsertRow");
/*  826 */     localSQLException.fillInStackTrace();
/*  827 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void cancelRowUpdates()
/*      */     throws SQLException
/*      */   {
/*  854 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "cancelRowUpdates");
/*  855 */     localSQLException.fillInStackTrace();
/*  856 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void moveToCurrentRow()
/*      */     throws SQLException
/*      */   {
/*  878 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "moveToCurrentRow");
/*  879 */     localSQLException.fillInStackTrace();
/*  880 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public abstract Statement getStatement()
/*      */     throws SQLException;
/*      */ 
/*      */   public void updateNull(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  920 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNull");
/*  921 */     localSQLException.fillInStackTrace();
/*  922 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNull(String paramString)
/*      */     throws SQLException
/*      */   {
/*  943 */     updateNull(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public boolean rowUpdated()
/*      */     throws SQLException
/*      */   {
/*  962 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean rowInserted()
/*      */     throws SQLException
/*      */   {
/*  982 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean rowDeleted()
/*      */     throws SQLException
/*      */   {
/* 1002 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1022 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 1024 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1025 */     localSQLException.fillInStackTrace();
/* 1026 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1048 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 1050 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1051 */     localSQLException.fillInStackTrace();
/* 1052 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1072 */     return null;
/*      */   }
/*      */ 
/*      */   abstract OracleStatement getOracleStatement()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract int refreshRows(int paramInt1, int paramInt2)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void removeCurrentRowFromCache()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract int getColumnCount()
/*      */     throws SQLException;
/*      */ 
/*      */   static abstract enum ResultSetType
/*      */   {
/*   72 */     UNKNOWN(-1, -1, false), 
/*      */ 
/*   88 */     FORWARD_READ_ONLY(1003, 1007, false), 
/*      */ 
/*  102 */     FORWARD_UPDATABLE(1003, 1008, true), 
/*      */ 
/*  117 */     INSENSITIVE_READ_ONLY(1004, 1007, false), 
/*      */ 
/*  131 */     INSENSITIVE_UPDATABLE(1004, 1008, true), 
/*      */ 
/*  146 */     SENSITIVE_READ_ONLY(1005, 1007, true), 
/*      */ 
/*  160 */     SENSITIVE_UPDATABLE(1005, 1008, true);
/*      */ 
/*      */     private final int type;
/*      */     private final int concur;
/*      */     private final boolean isIdentifierRequired;
/*      */ 
/*      */     static ResultSetType typeFor(int paramInt1, int paramInt2)
/*      */       throws SQLException
/*      */     {
/*  184 */       for (ResultSetType localResultSetType : (ResultSetType[])ResultSetType.class.getEnumConstants()) {
/*  185 */         if ((localResultSetType.getType() == paramInt1) && (localResultSetType.getConcur() == paramInt2)) return localResultSetType;
/*      */       }
/*      */ 
/*  188 */       ??? = DatabaseError.createSqlException(null, 68, "type: " + paramInt1 + " concurency: " + paramInt2);
/*  189 */       ((SQLException)???).fillInStackTrace();
/*  190 */       throw ((Throwable)???);
/*      */     }
/*      */ 
/*      */     private ResultSetType(int paramInt1, int paramInt2, boolean paramBoolean)
/*      */     {
/*  199 */       this.type = paramInt1;
/*  200 */       this.concur = paramInt2;
/*  201 */       this.isIdentifierRequired = paramBoolean;
/*      */     }
/*      */     int getType() {
/*  204 */       return this.type;
/*      */     }
/*  206 */     int getConcur() { return this.concur; } 
/*      */     boolean isIdentifierRequired() {
/*  208 */       return this.isIdentifierRequired;
/*      */     }
/*  210 */     boolean isForwardOnly() { return this.type == 1003; } 
/*      */     boolean isScrollable() {
/*  212 */       return this.type != 1003;
/*      */     }
/*  214 */     boolean isUpdatable() { return this.concur == 1008; }
/*      */ 
/*      */ 
/*      */     abstract OracleResultSet createResultSet(OracleStatement paramOracleStatement)
/*      */       throws SQLException;
/*      */ 
/*      */     abstract ResultSetType downgrade();
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleResultSet
 * JD-Core Version:    0.6.2
 */