/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.io.BufferedInputStream;
/*       */ import java.io.BufferedReader;
/*       */ import java.io.ByteArrayInputStream;
/*       */ import java.io.IOException;
/*       */ import java.io.InputStream;
/*       */ import java.io.Reader;
/*       */ import java.io.StringReader;
/*       */ import java.math.BigDecimal;
/*       */ import java.math.BigInteger;
/*       */ import java.net.URL;
/*       */ import java.security.AccessController;
/*       */ import java.security.PrivilegedAction;
/*       */ import java.sql.Array;
/*       */ import java.sql.BatchUpdateException;
/*       */ import java.sql.Blob;
/*       */ import java.sql.Clob;
/*       */ import java.sql.Date;
/*       */ import java.sql.NClob;
/*       */ import java.sql.ParameterMetaData;
/*       */ import java.sql.Ref;
/*       */ import java.sql.ResultSet;
/*       */ import java.sql.ResultSetMetaData;
/*       */ import java.sql.RowId;
/*       */ import java.sql.SQLData;
/*       */ import java.sql.SQLException;
/*       */ import java.sql.SQLXML;
/*       */ import java.sql.Statement;
/*       */ import java.sql.Time;
/*       */ import java.sql.Timestamp;
/*       */ import java.util.Calendar;
/*       */ import java.util.Locale;
/*       */ import java.util.TimeZone;
/*       */ import oracle.jdbc.OracleData;
/*       */ import oracle.jdbc.internal.ObjectData;
/*       */ import oracle.jdbc.internal.OracleStatement.BindChecksumListener;
/*       */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*       */ import oracle.jdbc.oracore.OracleTypeADT;
/*       */ import oracle.jdbc.oracore.OracleTypeNUMBER;
/*       */ import oracle.jdbc.proxy.ProxyFactory;
/*       */ import oracle.jdbc.proxy._Proxy_;
/*       */ import oracle.sql.ARRAY;
/*       */ import oracle.sql.ArrayDescriptor;
/*       */ import oracle.sql.BFILE;
/*       */ import oracle.sql.BINARY_DOUBLE;
/*       */ import oracle.sql.BINARY_FLOAT;
/*       */ import oracle.sql.BLOB;
/*       */ import oracle.sql.CHAR;
/*       */ import oracle.sql.CLOB;
/*       */ import oracle.sql.CharacterSet;
/*       */ import oracle.sql.CustomDatum;
/*       */ import oracle.sql.DATE;
/*       */ import oracle.sql.Datum;
/*       */ import oracle.sql.INTERVALDS;
/*       */ import oracle.sql.INTERVALYM;
/*       */ import oracle.sql.NUMBER;
/*       */ import oracle.sql.OPAQUE;
/*       */ import oracle.sql.ORAData;
/*       */ import oracle.sql.OpaqueDescriptor;
/*       */ import oracle.sql.RAW;
/*       */ import oracle.sql.REF;
/*       */ import oracle.sql.ROWID;
/*       */ import oracle.sql.STRUCT;
/*       */ import oracle.sql.StructDescriptor;
/*       */ import oracle.sql.TIMESTAMP;
/*       */ import oracle.sql.TIMESTAMPLTZ;
/*       */ import oracle.sql.TIMESTAMPTZ;
/*       */ 
/*       */ abstract class OraclePreparedStatement extends OracleStatement
/*       */   implements oracle.jdbc.internal.OraclePreparedStatement
/*       */ {
/*       */   int numberOfBindRowsAllocated;
/*   117 */   static Binder theStaticVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
/*       */ 
/*   119 */   static Binder theStaticVarnumNullBinder = OraclePreparedStatementReadOnly.theStaticVarnumNullBinder;
/*       */ 
/*   121 */   Binder theVarnumNullBinder = theStaticVarnumNullBinder;
/*       */ 
/*   123 */   static Binder theStaticBooleanBinder = OraclePreparedStatementReadOnly.theStaticBooleanBinder;
/*       */ 
/*   125 */   Binder theBooleanBinder = theStaticBooleanBinder;
/*       */ 
/*   127 */   static Binder theStaticByteBinder = OraclePreparedStatementReadOnly.theStaticByteBinder;
/*       */ 
/*   129 */   Binder theByteBinder = theStaticByteBinder;
/*       */ 
/*   131 */   static Binder theStaticShortBinder = OraclePreparedStatementReadOnly.theStaticShortBinder;
/*       */ 
/*   133 */   Binder theShortBinder = theStaticShortBinder;
/*       */ 
/*   135 */   static Binder theStaticIntBinder = OraclePreparedStatementReadOnly.theStaticIntBinder;
/*       */ 
/*   137 */   Binder theIntBinder = theStaticIntBinder;
/*       */ 
/*   139 */   static Binder theStaticLongBinder = OraclePreparedStatementReadOnly.theStaticLongBinder;
/*       */ 
/*   141 */   Binder theLongBinder = theStaticLongBinder;
/*       */ 
/*   143 */   static Binder theStaticFloatBinder = OraclePreparedStatementReadOnly.theStaticFloatBinder;
/*       */ 
/*   145 */   Binder theFloatBinder = null;
/*       */ 
/*   147 */   static Binder theStaticDoubleBinder = OraclePreparedStatementReadOnly.theStaticDoubleBinder;
/*       */ 
/*   149 */   Binder theDoubleBinder = null;
/*       */ 
/*   151 */   static Binder theStaticBigDecimalBinder = OraclePreparedStatementReadOnly.theStaticBigDecimalBinder;
/*       */ 
/*   153 */   Binder theBigDecimalBinder = theStaticBigDecimalBinder;
/*       */ 
/*   155 */   static Binder theStaticVarcharCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarcharCopyingBinder;
/*       */ 
/*   157 */   static Binder theStaticVarcharNullBinder = OraclePreparedStatementReadOnly.theStaticVarcharNullBinder;
/*       */ 
/*   159 */   Binder theVarcharNullBinder = theStaticVarcharNullBinder;
/*       */ 
/*   161 */   static Binder theStaticStringBinder = OraclePreparedStatementReadOnly.theStaticStringBinder;
/*       */ 
/*   163 */   Binder theStringBinder = theStaticStringBinder;
/*       */ 
/*   165 */   static Binder theStaticSetCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticSetCHARCopyingBinder;
/*       */ 
/*   167 */   static Binder theStaticSetCHARBinder = OraclePreparedStatementReadOnly.theStaticSetCHARBinder;
/*       */ 
/*   169 */   static Binder theStaticLittleEndianSetCHARBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianSetCHARBinder;
/*       */ 
/*   171 */   static Binder theStaticSetCHARNullBinder = OraclePreparedStatementReadOnly.theStaticSetCHARNullBinder;
/*       */   Binder theSetCHARBinder;
/*   174 */   Binder theSetCHARNullBinder = theStaticSetCHARNullBinder;
/*       */ 
/*   176 */   static Binder theStaticFixedCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARCopyingBinder;
/*       */ 
/*   178 */   static Binder theStaticFixedCHARBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARBinder;
/*       */ 
/*   180 */   static Binder theStaticFixedCHARNullBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARNullBinder;
/*       */ 
/*   182 */   Binder theFixedCHARBinder = theStaticFixedCHARBinder;
/*   183 */   Binder theFixedCHARNullBinder = theStaticFixedCHARNullBinder;
/*       */ 
/*   185 */   static Binder theStaticDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
/*       */ 
/*   187 */   static Binder theStaticDateBinder = OraclePreparedStatementReadOnly.theStaticDateBinder;
/*       */ 
/*   189 */   static Binder theStaticDateNullBinder = OraclePreparedStatementReadOnly.theStaticDateNullBinder;
/*       */ 
/*   191 */   Binder theDateBinder = theStaticDateBinder;
/*   192 */   Binder theDateNullBinder = theStaticDateNullBinder;
/*       */ 
/*   194 */   static Binder theStaticTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
/*       */ 
/*   196 */   static Binder theStaticTimeBinder = OraclePreparedStatementReadOnly.theStaticTimeBinder;
/*       */ 
/*   198 */   Binder theTimeBinder = theStaticTimeBinder;
/*       */ 
/*   200 */   static Binder theStaticTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
/*       */ 
/*   202 */   static Binder theStaticTimestampBinder = OraclePreparedStatementReadOnly.theStaticTimestampBinder;
/*       */ 
/*   204 */   static Binder theStaticTimestampNullBinder = OraclePreparedStatementReadOnly.theStaticTimestampNullBinder;
/*       */ 
/*   206 */   Binder theTimestampBinder = theStaticTimestampBinder;
/*   207 */   Binder theTimestampNullBinder = theStaticTimestampNullBinder;
/*       */ 
/*   209 */   static Binder theStaticOracleNumberBinder = OraclePreparedStatementReadOnly.theStaticOracleNumberBinder;
/*       */ 
/*   211 */   Binder theOracleNumberBinder = theStaticOracleNumberBinder;
/*       */ 
/*   213 */   static Binder theStaticOracleDateBinder = OraclePreparedStatementReadOnly.theStaticOracleDateBinder;
/*       */ 
/*   215 */   Binder theOracleDateBinder = theStaticOracleDateBinder;
/*       */ 
/*   217 */   static Binder theStaticOracleTimestampBinder = OraclePreparedStatementReadOnly.theStaticOracleTimestampBinder;
/*       */ 
/*   219 */   Binder theOracleTimestampBinder = theStaticOracleTimestampBinder;
/*       */ 
/*   221 */   static Binder theStaticTSTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSTZCopyingBinder;
/*       */ 
/*   223 */   static Binder theStaticTSTZBinder = OraclePreparedStatementReadOnly.theStaticTSTZBinder;
/*       */ 
/*   225 */   static Binder theStaticTSTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSTZNullBinder;
/*       */ 
/*   227 */   Binder theTSTZBinder = theStaticTSTZBinder;
/*   228 */   Binder theTSTZNullBinder = theStaticTSTZNullBinder;
/*       */ 
/*   230 */   static Binder theStaticTSLTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSLTZCopyingBinder;
/*       */ 
/*   232 */   static Binder theStaticTSLTZBinder = OraclePreparedStatementReadOnly.theStaticTSLTZBinder;
/*       */ 
/*   234 */   static Binder theStaticTSLTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSLTZNullBinder;
/*       */ 
/*   236 */   Binder theTSLTZBinder = theStaticTSLTZBinder;
/*   237 */   Binder theTSLTZNullBinder = theStaticTSLTZNullBinder;
/*       */ 
/*   239 */   static Binder theStaticRowidCopyingBinder = OraclePreparedStatementReadOnly.theStaticRowidCopyingBinder;
/*       */ 
/*   241 */   static Binder theStaticRowidBinder = OraclePreparedStatementReadOnly.theStaticRowidBinder;
/*       */ 
/*   243 */   static Binder theStaticLittleEndianRowidBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianRowidBinder;
/*       */ 
/*   245 */   static Binder theStaticRowidNullBinder = OraclePreparedStatementReadOnly.theStaticRowidNullBinder;
/*       */ 
/*   247 */   static Binder theStaticURowidNullBinder = OraclePreparedStatementReadOnly.theStaticURowidNullBinder;
/*       */   Binder theRowidBinder;
/*   250 */   Binder theRowidNullBinder = theStaticRowidNullBinder;
/*       */   Binder theURowidBinder;
/*   253 */   Binder theURowidNullBinder = theStaticURowidNullBinder;
/*       */ 
/*   255 */   static Binder theStaticIntervalDSCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSCopyingBinder;
/*       */ 
/*   257 */   static Binder theStaticIntervalDSBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSBinder;
/*       */ 
/*   259 */   static Binder theStaticIntervalDSNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSNullBinder;
/*       */ 
/*   261 */   Binder theIntervalDSBinder = theStaticIntervalDSBinder;
/*   262 */   Binder theIntervalDSNullBinder = theStaticIntervalDSNullBinder;
/*       */ 
/*   264 */   static Binder theStaticIntervalYMCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMCopyingBinder;
/*       */ 
/*   266 */   static Binder theStaticIntervalYMBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMBinder;
/*       */ 
/*   268 */   static Binder theStaticIntervalYMNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMNullBinder;
/*       */ 
/*   270 */   Binder theIntervalYMBinder = theStaticIntervalYMBinder;
/*   271 */   Binder theIntervalYMNullBinder = theStaticIntervalYMNullBinder;
/*       */ 
/*   273 */   static Binder theStaticBfileCopyingBinder = OraclePreparedStatementReadOnly.theStaticBfileCopyingBinder;
/*       */ 
/*   275 */   static Binder theStaticBfileBinder = OraclePreparedStatementReadOnly.theStaticBfileBinder;
/*       */ 
/*   277 */   static Binder theStaticBfileNullBinder = OraclePreparedStatementReadOnly.theStaticBfileNullBinder;
/*       */ 
/*   279 */   Binder theBfileBinder = theStaticBfileBinder;
/*   280 */   Binder theBfileNullBinder = theStaticBfileNullBinder;
/*       */ 
/*   282 */   static Binder theStaticBlobCopyingBinder = OraclePreparedStatementReadOnly.theStaticBlobCopyingBinder;
/*       */ 
/*   284 */   static Binder theStaticBlobBinder = OraclePreparedStatementReadOnly.theStaticBlobBinder;
/*       */ 
/*   286 */   static Binder theStaticBlobNullBinder = OraclePreparedStatementReadOnly.theStaticBlobNullBinder;
/*       */ 
/*   288 */   Binder theBlobBinder = theStaticBlobBinder;
/*   289 */   Binder theBlobNullBinder = theStaticBlobNullBinder;
/*       */ 
/*   291 */   static Binder theStaticClobCopyingBinder = OraclePreparedStatementReadOnly.theStaticClobCopyingBinder;
/*       */ 
/*   293 */   static Binder theStaticClobBinder = OraclePreparedStatementReadOnly.theStaticClobBinder;
/*       */ 
/*   295 */   static Binder theStaticClobNullBinder = OraclePreparedStatementReadOnly.theStaticClobNullBinder;
/*       */ 
/*   297 */   Binder theClobBinder = theStaticClobBinder;
/*   298 */   Binder theClobNullBinder = theStaticClobNullBinder;
/*       */ 
/*   300 */   static Binder theStaticRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticRawCopyingBinder;
/*       */ 
/*   302 */   static Binder theStaticRawBinder = OraclePreparedStatementReadOnly.theStaticRawBinder;
/*       */ 
/*   304 */   static Binder theStaticRawNullBinder = OraclePreparedStatementReadOnly.theStaticRawNullBinder;
/*       */ 
/*   306 */   Binder theRawBinder = theStaticRawBinder;
/*   307 */   Binder theRawNullBinder = theStaticRawNullBinder;
/*       */ 
/*   309 */   static Binder theStaticPlsqlRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawCopyingBinder;
/*       */ 
/*   311 */   static Binder theStaticPlsqlRawBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawBinder;
/*       */ 
/*   313 */   Binder thePlsqlRawBinder = theStaticPlsqlRawBinder;
/*       */ 
/*   315 */   static Binder theStaticBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
/*       */ 
/*   317 */   static Binder theStaticBinaryFloatBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatBinder;
/*       */ 
/*   319 */   static Binder theStaticBinaryFloatNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatNullBinder;
/*       */ 
/*   321 */   Binder theBinaryFloatBinder = theStaticBinaryFloatBinder;
/*   322 */   Binder theBinaryFloatNullBinder = theStaticBinaryFloatNullBinder;
/*       */ 
/*   324 */   static Binder theStaticBINARY_FLOATCopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATCopyingBinder;
/*       */ 
/*   326 */   static Binder theStaticBINARY_FLOATBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATBinder;
/*       */ 
/*   328 */   static Binder theStaticBINARY_FLOATNullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATNullBinder;
/*       */ 
/*   330 */   Binder theBINARY_FLOATBinder = theStaticBINARY_FLOATBinder;
/*   331 */   Binder theBINARY_FLOATNullBinder = theStaticBINARY_FLOATNullBinder;
/*       */ 
/*   333 */   static Binder theStaticBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;
/*       */ 
/*   335 */   static Binder theStaticBinaryDoubleBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleBinder;
/*       */ 
/*   337 */   static Binder theStaticBinaryDoubleNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleNullBinder;
/*       */ 
/*   339 */   Binder theBinaryDoubleBinder = theStaticBinaryDoubleBinder;
/*   340 */   Binder theBinaryDoubleNullBinder = theStaticBinaryDoubleNullBinder;
/*       */ 
/*   342 */   static Binder theStaticBINARY_DOUBLECopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLECopyingBinder;
/*       */ 
/*   344 */   static Binder theStaticBINARY_DOUBLEBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLEBinder;
/*       */ 
/*   346 */   static Binder theStaticBINARY_DOUBLENullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLENullBinder;
/*       */ 
/*   348 */   Binder theBINARY_DOUBLEBinder = theStaticBINARY_DOUBLEBinder;
/*   349 */   Binder theBINARY_DOUBLENullBinder = theStaticBINARY_DOUBLENullBinder;
/*       */ 
/*   351 */   static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
/*       */ 
/*   353 */   Binder theLongStreamBinder = theStaticLongStreamBinder;
/*       */ 
/*   355 */   static Binder theStaticLongStreamForStringBinder = OraclePreparedStatementReadOnly.theStaticLongStreamForStringBinder;
/*       */ 
/*   357 */   Binder theLongStreamForStringBinder = theStaticLongStreamForStringBinder;
/*   358 */   static Binder theStaticLongStreamForStringCopyingBinder = OraclePreparedStatementReadOnly.theStaticLongStreamForStringCopyingBinder;
/*       */ 
/*   361 */   static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
/*       */ 
/*   363 */   Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
/*       */ 
/*   365 */   static Binder theStaticLongRawStreamForBytesBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamForBytesBinder;
/*       */ 
/*   367 */   Binder theLongRawStreamForBytesBinder = theStaticLongRawStreamForBytesBinder;
/*   368 */   static Binder theStaticLongRawStreamForBytesCopyingBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamForBytesCopyingBinder;
/*       */ 
/*   371 */   static Binder theStaticNamedTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeCopyingBinder;
/*       */ 
/*   373 */   static Binder theStaticNamedTypeBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeBinder;
/*       */ 
/*   375 */   static Binder theStaticNamedTypeNullBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeNullBinder;
/*       */ 
/*   377 */   Binder theNamedTypeBinder = theStaticNamedTypeBinder;
/*   378 */   Binder theNamedTypeNullBinder = theStaticNamedTypeNullBinder;
/*       */ 
/*   380 */   static Binder theStaticRefTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticRefTypeCopyingBinder;
/*       */ 
/*   382 */   static Binder theStaticRefTypeBinder = OraclePreparedStatementReadOnly.theStaticRefTypeBinder;
/*       */ 
/*   384 */   static Binder theStaticRefTypeNullBinder = OraclePreparedStatementReadOnly.theStaticRefTypeNullBinder;
/*       */ 
/*   386 */   Binder theRefTypeBinder = theStaticRefTypeBinder;
/*   387 */   Binder theRefTypeNullBinder = theStaticRefTypeNullBinder;
/*       */ 
/*   389 */   static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
/*       */ 
/*   391 */   static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
/*       */ 
/*   393 */   static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
/*       */ 
/*   395 */   Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
/*   396 */   Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
/*       */ 
/*   398 */   static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
/*       */ 
/*   400 */   Binder theOutBinder = theStaticOutBinder;
/*       */ 
/*   402 */   static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
/*       */ 
/*   404 */   Binder theReturnParamBinder = theStaticReturnParamBinder;
/*       */ 
/*   406 */   static Binder theStaticT4CRowidBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidBinder;
/*       */ 
/*   408 */   static Binder theStaticT4CURowidBinder = OraclePreparedStatementReadOnly.theStaticT4CURowidBinder;
/*       */ 
/*   410 */   static Binder theStaticT4CRowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidNullBinder;
/*       */ 
/*   412 */   static Binder theStaticT4CURowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CURowidNullBinder;
/*       */ 
/*   419 */   private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
/*   420 */   private static final Calendar UTC_US_CALENDAR = Calendar.getInstance(UTC_TIME_ZONE, Locale.US);
/*       */ 
/*   422 */   protected Calendar cachedUTCUSCalendar = (Calendar)UTC_US_CALENDAR.clone();
/*       */   public static final int TypeBinder_BYTELEN = 24;
/*   426 */   char[] digits = new char[20];
/*       */   Binder[][] binders;
/*       */   int[][] parameterInt;
/*       */   long[][] parameterLong;
/*       */   float[][] parameterFloat;
/*       */   double[][] parameterDouble;
/*       */   BigDecimal[][] parameterBigDecimal;
/*       */   String[][] parameterString;
/*       */   Date[][] parameterDate;
/*       */   Time[][] parameterTime;
/*       */   Timestamp[][] parameterTimestamp;
/*       */   byte[][][] parameterDatum;
/*       */   OracleTypeADT[][] parameterOtype;
/*       */   CLOB[] lastBoundClobs;
/*       */   BLOB[] lastBoundBlobs;
/*       */   PlsqlIbtBindInfo[][] parameterPlsqlIbt;
/*       */   Binder[] currentRowBinders;
/*       */   int[] currentRowByteLens;
/*       */   int[] currentRowCharLens;
/*       */   Accessor[] currentRowBindAccessors;
/*       */   short[] currentRowFormOfUse;
/*   550 */   boolean currentRowNeedToPrepareBinds = true;
/*       */   int[] currentBatchByteLens;
/*       */   int[] currentBatchCharLens;
/*       */   Accessor[] currentBatchBindAccessors;
/*       */   short[] currentBatchFormOfUse;
/*       */   boolean currentBatchNeedToPrepareBinds;
/*       */   int currentBatchAccumulatedBindsSize;
/*       */   static final int BATCH_SIZE_THRESHOLD = 2097152;
/*       */   PushedBatch pushedBatches;
/*       */   PushedBatch pushedBatchesTail;
/*   907 */   int cachedBindByteSize = 0;
/*   908 */   int cachedBindCharSize = 0;
/*   909 */   int cachedBindIndicatorSize = 0;
/*       */   int totalBindByteLength;
/*       */   int totalBindCharLength;
/*       */   int totalBindIndicatorLength;
/*       */   static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
/*       */   static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_HI = 1;
/*       */   static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_LO = 2;
/*       */   static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_HI = 3;
/*       */   static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_LO = 4;
/*       */   static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 5;
/*       */   static final int BIND_METADATA_TYPE_OFFSET = 0;
/*       */   static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
/*       */   static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
/*       */   static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
/*       */   static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
/*       */   static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
/*       */   static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
/*       */   static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
/*       */   static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
/*       */   static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
/*       */   static final int BIND_METADATA_PER_POSITION_SIZE = 10;
/*       */   static final int SETLOB_NO_LENGTH = -1;
/*       */   int bindBufferCapacity;
/*       */   int numberOfBoundRows;
/*       */   int indicatorsOffset;
/*       */   int valueLengthsOffset;
/*       */   boolean preparedAllBinds;
/*       */   boolean preparedByteBinds;
/*       */   boolean preparedCharBinds;
/*       */   Binder[] lastBinders;
/*       */   byte[] lastBoundBytes;
/*       */   int lastBoundByteOffset;
/*       */   char[] lastBoundChars;
/*       */   int lastBoundCharOffset;
/*       */   int[] lastBoundByteOffsets;
/*       */   int[] lastBoundCharOffsets;
/*       */   int[] lastBoundByteLens;
/*       */   int[] lastBoundCharLens;
/*       */   short[] lastBoundInds;
/*       */   short[] lastBoundLens;
/*  1033 */   boolean lastBoundNeeded = false;
/*       */   byte[][] lastBoundTypeBytes;
/*       */   OracleTypeADT[] lastBoundTypeOtypes;
/*       */   InputStream[] lastBoundStream;
/*       */   private static final int STREAM_MAX_BYTES_SQL = 2147483647;
/*       */   int maxRawBytesSql;
/*       */   int maxRawBytesPlsql;
/*       */   int maxVcsCharsSql;
/*       */   int maxVcsNCharsSql;
/*       */   int maxVcsBytesPlsql;
/*  1134 */   private int maxCharSize = 0;
/*       */ 
/*  1140 */   private int maxNCharSize = 0;
/*       */ 
/*  1148 */   private int charMaxCharsSql = 0;
/*       */ 
/*  1156 */   private int charMaxNCharsSql = 0;
/*       */ 
/*  1163 */   protected int maxVcsCharsPlsql = 0;
/*       */ 
/*  1170 */   private int maxVcsNCharsPlsql = 0;
/*       */ 
/*  1176 */   int maxIbtVarcharElementLength = 0;
/*       */ 
/*  1184 */   private int maxStreamCharsSql = 0;
/*       */ 
/*  1192 */   private int maxStreamNCharsSql = 0;
/*       */ 
/*  1198 */   protected boolean isServerCharSetFixedWidth = false;
/*       */ 
/*  1204 */   private boolean isServerNCharSetFixedWidth = false;
/*       */   int minVcsBindSize;
/*       */   int prematureBatchCount;
/*  1255 */   boolean checkBindTypes = true;
/*       */   boolean scrollRsetTypeSolved;
/*       */   private static final double MIN_NUMBER = 1.E-130D;
/*       */   private static final double MAX_NUMBER = 9.999999999999999E+125D;
/*  5709 */   int SetBigStringTryClob = 0;
/*       */   static final int BSTYLE_UNKNOWN = 0;
/*       */   static final int BSTYLE_ORACLE = 1;
/*       */   static final int BSTYLE_JDBC = 2;
/* 10685 */   int m_batchStyle = 0;
/*       */ 
/* 16078 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   OraclePreparedStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  1288 */     this(paramPhysicalConnection, paramString, paramInt1, paramInt2, 1003, 1007);
/*       */ 
/*  1291 */     this.cacheState = 1;
/*       */   }
/*       */ 
/*       */   OraclePreparedStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/*  1303 */     super(paramPhysicalConnection, paramInt1, paramInt2, paramInt3, paramInt4);
/*       */ 
/*  1307 */     this.cacheState = 1;
/*       */ 
/*  1309 */     if (paramInt1 > 1) {
/*  1310 */       setOracleBatchStyle();
/*       */     }
/*  1312 */     this.theSetCHARBinder = (paramPhysicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianSetCHARBinder : theStaticSetCHARBinder);
/*       */ 
/*  1316 */     this.theURowidBinder = (this.theRowidBinder = paramPhysicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianRowidBinder : theStaticRowidBinder);
/*       */ 
/*  1322 */     this.statementType = 1;
/*  1323 */     this.needToParse = true;
/*       */ 
/*  1325 */     this.processEscapes = paramPhysicalConnection.processEscapes;
/*  1326 */     this.sqlObject.initialize(paramString);
/*       */ 
/*  1328 */     this.sqlKind = this.sqlObject.getSqlKind();
/*       */ 
/*  1330 */     this.clearParameters = true;
/*  1331 */     this.scrollRsetTypeSolved = false;
/*  1332 */     this.prematureBatchCount = 0;
/*       */ 
/*  1334 */     initializeBinds();
/*       */ 
/*  1336 */     this.minVcsBindSize = paramPhysicalConnection.minVcsBindSize;
/*  1337 */     this.maxRawBytesSql = paramPhysicalConnection.maxRawBytesSql;
/*  1338 */     this.maxRawBytesPlsql = paramPhysicalConnection.maxRawBytesPlsql;
/*  1339 */     this.maxVcsCharsSql = paramPhysicalConnection.maxVcsCharsSql;
/*  1340 */     this.maxVcsNCharsSql = paramPhysicalConnection.maxVcsNCharsSql;
/*  1341 */     this.maxVcsBytesPlsql = paramPhysicalConnection.maxVcsBytesPlsql;
/*  1342 */     this.maxIbtVarcharElementLength = paramPhysicalConnection.maxIbtVarcharElementLength;
/*  1343 */     this.maxCharSize = this.connection.conversion.sMaxCharSize;
/*  1344 */     this.maxNCharSize = this.connection.conversion.maxNCharSize;
/*  1345 */     this.maxVcsCharsPlsql = (this.maxVcsBytesPlsql / this.maxCharSize);
/*  1346 */     this.maxVcsNCharsPlsql = (this.maxVcsBytesPlsql / this.maxNCharSize);
/*  1347 */     this.maxStreamCharsSql = (2147483647 / this.maxCharSize);
/*  1348 */     this.maxStreamNCharsSql = (this.maxRawBytesSql / this.maxNCharSize);
/*  1349 */     this.isServerCharSetFixedWidth = this.connection.conversion.isServerCharSetFixedWidth;
/*  1350 */     this.isServerNCharSetFixedWidth = this.connection.conversion.isServerNCharSetFixedWidth;
/*       */   }
/*       */ 
/*       */   void allocBinds(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1366 */     int i = paramInt > this.numberOfBindRowsAllocated ? 1 : 0;
/*       */ 
/*  1370 */     initializeIndicatorSubRange();
/*       */ 
/*  1374 */     int j = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
/*       */ 
/*  1381 */     int k = paramInt * this.numberOfBindPositions;
/*       */ 
/*  1384 */     int m = j + 2 * k;
/*       */ 
/*  1390 */     if (m > this.totalBindIndicatorLength)
/*       */     {
/*  1392 */       short[] arrayOfShort = this.bindIndicators;
/*  1393 */       i1 = this.bindIndicatorOffset;
/*       */ 
/*  1395 */       this.bindIndicatorOffset = 0;
/*  1396 */       this.bindIndicators = new short[m];
/*  1397 */       this.totalBindIndicatorLength = m;
/*       */ 
/*  1399 */       if ((arrayOfShort != null) && (i != 0))
/*       */       {
/*  1402 */         System.arraycopy(arrayOfShort, i1, this.bindIndicators, this.bindIndicatorOffset, j);
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  1407 */     this.bindIndicatorSubRange += this.bindIndicatorOffset;
/*       */ 
/*  1414 */     this.bindIndicators[(this.bindIndicatorSubRange + 0)] = ((short)this.numberOfBindPositions);
/*       */ 
/*  1418 */     this.indicatorsOffset = (this.bindIndicatorOffset + j);
/*  1419 */     this.valueLengthsOffset = (this.indicatorsOffset + k);
/*       */ 
/*  1421 */     int n = this.indicatorsOffset;
/*  1422 */     int i1 = this.valueLengthsOffset;
/*  1423 */     int i2 = this.bindIndicatorSubRange + 5;
/*       */ 
/*  1427 */     for (int i3 = 0; i3 < this.numberOfBindPositions; i3++)
/*       */     {
/*  1431 */       this.bindIndicators[(i2 + 5)] = ((short)(n >> 16));
/*       */ 
/*  1434 */       this.bindIndicators[(i2 + 6)] = ((short)(n & 0xFFFF));
/*       */ 
/*  1437 */       this.bindIndicators[(i2 + 7)] = ((short)(i1 >> 16));
/*       */ 
/*  1439 */       this.bindIndicators[(i2 + 8)] = ((short)(i1 & 0xFFFF));
/*       */ 
/*  1443 */       n += paramInt;
/*  1444 */       i1 += paramInt;
/*  1445 */       i2 += 10;
/*       */     }
/*       */   }
/*       */ 
/*       */   void initializeBinds()
/*       */     throws SQLException
/*       */   {
/*  1465 */     this.numberOfBindPositions = this.sqlObject.getParameterCount();
/*  1466 */     this.numReturnParams = this.sqlObject.getReturnParameterCount();
/*       */ 
/*  1468 */     if (this.numberOfBindPositions == 0)
/*       */     {
/*  1472 */       this.currentRowNeedToPrepareBinds = false;
/*       */ 
/*  1474 */       return;
/*       */     }
/*       */ 
/*  1480 */     this.numberOfBindRowsAllocated = this.batch;
/*       */ 
/*  1483 */     this.binders = new Binder[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */ 
/*  1485 */     this.currentRowBinders = this.binders[0];
/*       */ 
/*  1487 */     this.currentRowByteLens = new int[this.numberOfBindPositions];
/*  1488 */     this.currentBatchByteLens = new int[this.numberOfBindPositions];
/*       */ 
/*  1490 */     this.currentRowCharLens = new int[this.numberOfBindPositions];
/*  1491 */     this.currentBatchCharLens = new int[this.numberOfBindPositions];
/*       */ 
/*  1493 */     this.currentRowFormOfUse = new short[this.numberOfBindPositions];
/*  1494 */     this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
/*       */ 
/*  1496 */     this.lastBoundClobs = new CLOB[this.numberOfBindPositions];
/*  1497 */     this.lastBoundBlobs = new BLOB[this.numberOfBindPositions];
/*       */ 
/*  1499 */     int i = 1;
/*       */ 
/*  1501 */     if (this.connection.defaultnchar) {
/*  1502 */       i = 2;
/*       */     }
/*  1504 */     for (int j = 0; j < this.numberOfBindPositions; j++)
/*       */     {
/*  1506 */       this.currentRowFormOfUse[j] = i;
/*  1507 */       this.currentBatchFormOfUse[j] = i;
/*       */     }
/*       */ 
/*  1510 */     this.lastBinders = new Binder[this.numberOfBindPositions];
/*  1511 */     this.lastBoundCharLens = new int[this.numberOfBindPositions];
/*  1512 */     this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
/*  1513 */     this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
/*  1514 */     this.lastBoundByteLens = new int[this.numberOfBindPositions];
/*  1515 */     this.lastBoundInds = new short[this.numberOfBindPositions];
/*  1516 */     this.lastBoundLens = new short[this.numberOfBindPositions];
/*       */ 
/*  1518 */     this.lastBoundTypeBytes = new byte[this.numberOfBindPositions][];
/*  1519 */     this.lastBoundTypeOtypes = new OracleTypeADT[this.numberOfBindPositions];
/*       */ 
/*  1522 */     allocBinds(this.numberOfBindRowsAllocated);
/*       */   }
/*       */ 
/*       */   void growBinds(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1541 */     Binder[][] arrayOfBinder = this.binders;
/*       */ 
/*  1543 */     this.binders = new Binder[paramInt][];
/*       */ 
/*  1546 */     if (arrayOfBinder != null) {
/*  1547 */       System.arraycopy(arrayOfBinder, 0, this.binders, 0, this.numberOfBindRowsAllocated);
/*       */     }
/*       */ 
/*  1551 */     for (int i = this.numberOfBindRowsAllocated; i < paramInt; 
/*  1552 */       i++) {
/*  1553 */       this.binders[i] = new Binder[this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  1559 */     allocBinds(paramInt);
/*       */     Object localObject;
/*  1563 */     if (this.parameterInt != null)
/*       */     {
/*  1565 */       localObject = this.parameterInt;
/*       */ 
/*  1567 */       this.parameterInt = new int[paramInt][];
/*       */ 
/*  1569 */       System.arraycopy(localObject, 0, this.parameterInt, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1572 */       for (i = this.numberOfBindRowsAllocated; 
/*  1573 */         i < paramInt; i++) {
/*  1574 */         this.parameterInt[i] = new int[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1577 */     if (this.parameterLong != null)
/*       */     {
/*  1579 */       localObject = this.parameterLong;
/*       */ 
/*  1581 */       this.parameterLong = new long[paramInt][];
/*       */ 
/*  1583 */       System.arraycopy(localObject, 0, this.parameterLong, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1586 */       for (i = this.numberOfBindRowsAllocated; 
/*  1587 */         i < paramInt; i++) {
/*  1588 */         this.parameterLong[i] = new long[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1591 */     if (this.parameterFloat != null)
/*       */     {
/*  1593 */       localObject = this.parameterFloat;
/*       */ 
/*  1595 */       this.parameterFloat = new float[paramInt][];
/*       */ 
/*  1597 */       System.arraycopy(localObject, 0, this.parameterFloat, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1600 */       for (i = this.numberOfBindRowsAllocated; 
/*  1601 */         i < paramInt; i++) {
/*  1602 */         this.parameterFloat[i] = new float[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1605 */     if (this.parameterDouble != null)
/*       */     {
/*  1607 */       localObject = this.parameterDouble;
/*       */ 
/*  1609 */       this.parameterDouble = new double[paramInt][];
/*       */ 
/*  1611 */       System.arraycopy(localObject, 0, this.parameterDouble, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1614 */       for (i = this.numberOfBindRowsAllocated; 
/*  1615 */         i < paramInt; i++) {
/*  1616 */         this.parameterDouble[i] = new double[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1619 */     if (this.parameterBigDecimal != null)
/*       */     {
/*  1621 */       localObject = this.parameterBigDecimal;
/*       */ 
/*  1623 */       this.parameterBigDecimal = new BigDecimal[paramInt][];
/*       */ 
/*  1626 */       System.arraycopy(localObject, 0, this.parameterBigDecimal, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1629 */       for (i = this.numberOfBindRowsAllocated; 
/*  1630 */         i < paramInt; i++) {
/*  1631 */         this.parameterBigDecimal[i] = new BigDecimal[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1634 */     if (this.parameterString != null)
/*       */     {
/*  1636 */       localObject = this.parameterString;
/*       */ 
/*  1638 */       this.parameterString = new String[paramInt][];
/*       */ 
/*  1640 */       System.arraycopy(localObject, 0, this.parameterString, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1643 */       for (i = this.numberOfBindRowsAllocated; 
/*  1644 */         i < paramInt; i++) {
/*  1645 */         this.parameterString[i] = new String[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1648 */     if (this.parameterDate != null)
/*       */     {
/*  1650 */       localObject = this.parameterDate;
/*       */ 
/*  1652 */       this.parameterDate = new Date[paramInt][];
/*       */ 
/*  1654 */       System.arraycopy(localObject, 0, this.parameterDate, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1657 */       for (i = this.numberOfBindRowsAllocated; 
/*  1658 */         i < paramInt; i++) {
/*  1659 */         this.parameterDate[i] = new Date[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1662 */     if (this.parameterTime != null)
/*       */     {
/*  1664 */       localObject = this.parameterTime;
/*       */ 
/*  1666 */       this.parameterTime = new Time[paramInt][];
/*       */ 
/*  1668 */       System.arraycopy(localObject, 0, this.parameterTime, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1671 */       for (i = this.numberOfBindRowsAllocated; 
/*  1672 */         i < paramInt; i++) {
/*  1673 */         this.parameterTime[i] = new Time[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1676 */     if (this.parameterTimestamp != null)
/*       */     {
/*  1678 */       localObject = this.parameterTimestamp;
/*       */ 
/*  1680 */       this.parameterTimestamp = new Timestamp[paramInt][];
/*       */ 
/*  1682 */       System.arraycopy(localObject, 0, this.parameterTimestamp, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1685 */       for (i = this.numberOfBindRowsAllocated; 
/*  1686 */         i < paramInt; i++) {
/*  1687 */         this.parameterTimestamp[i] = new Timestamp[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1690 */     if (this.parameterDatum != null)
/*       */     {
/*  1692 */       localObject = this.parameterDatum;
/*       */ 
/*  1694 */       this.parameterDatum = new byte[paramInt][][];
/*       */ 
/*  1696 */       System.arraycopy(localObject, 0, this.parameterDatum, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1699 */       for (i = this.numberOfBindRowsAllocated; 
/*  1700 */         i < paramInt; i++) {
/*  1701 */         this.parameterDatum[i] = new byte[this.numberOfBindPositions][];
/*       */       }
/*       */     }
/*  1704 */     if (this.parameterOtype != null)
/*       */     {
/*  1706 */       localObject = this.parameterOtype;
/*       */ 
/*  1708 */       this.parameterOtype = new OracleTypeADT[paramInt][];
/*       */ 
/*  1710 */       System.arraycopy(localObject, 0, this.parameterOtype, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1713 */       for (i = this.numberOfBindRowsAllocated; 
/*  1714 */         i < paramInt; i++) {
/*  1715 */         this.parameterOtype[i] = new OracleTypeADT[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1718 */     if (this.parameterStream != null)
/*       */     {
/*  1720 */       localObject = this.parameterStream;
/*       */ 
/*  1722 */       this.parameterStream = new InputStream[paramInt][];
/*       */ 
/*  1724 */       System.arraycopy(localObject, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1727 */       for (i = this.numberOfBindRowsAllocated; 
/*  1728 */         i < paramInt; i++) {
/*  1729 */         this.parameterStream[i] = new InputStream[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1732 */     if (this.userStream != null)
/*       */     {
/*  1734 */       localObject = this.userStream;
/*       */ 
/*  1736 */       this.userStream = new Object[paramInt][];
/*       */ 
/*  1738 */       System.arraycopy(localObject, 0, this.userStream, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1741 */       for (i = this.numberOfBindRowsAllocated; 
/*  1742 */         i < paramInt; i++) {
/*  1743 */         this.userStream[i] = new Object[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*  1746 */     if (this.parameterPlsqlIbt != null)
/*       */     {
/*  1748 */       localObject = this.parameterPlsqlIbt;
/*       */ 
/*  1750 */       this.parameterPlsqlIbt = new PlsqlIbtBindInfo[paramInt][];
/*       */ 
/*  1753 */       System.arraycopy(localObject, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
/*       */ 
/*  1756 */       for (i = this.numberOfBindRowsAllocated; 
/*  1757 */         i < paramInt; i++) {
/*  1758 */         this.parameterPlsqlIbt[i] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
/*       */       }
/*       */     }
/*       */ 
/*  1762 */     this.numberOfBindRowsAllocated = paramInt;
/*       */ 
/*  1765 */     this.currentRowNeedToPrepareBinds = true;
/*       */   }
/*       */ 
/*       */   void processCompletedBindRow(int paramInt, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  1839 */     if (this.numberOfBindPositions == 0)
/*       */     {
/*  1842 */       return;
/*       */     }
/*       */ 
/*  1845 */     int j = 0;
/*  1846 */     int k = 0;
/*  1847 */     int m = 0;
/*  1848 */     int n = this.currentRank == this.firstRowInBatch ? 1 : 0;
/*       */ 
/*  1855 */     Binder[] arrayOfBinder = this.currentRank == 0 ? this.lastBinders : this.lastBinders[0] == null ? null : this.binders[(this.currentRank - 1)];
/*       */     Object localObject2;
/*       */     Object localObject3;
/*  1859 */     if (this.currentRowBindAccessors == null)
/*       */     {
/*  1861 */       int i1 = (this.isAutoGeneratedKey) && (this.clearParameters) ? 1 : 0;
/*       */ 
/*  1864 */       if (arrayOfBinder == null)
/*       */       {
/*  1868 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*  1869 */           if (this.currentRowBinders[i] == null)
/*       */           {
/*  1871 */             if (i1 != 0)
/*       */             {
/*  1873 */               registerReturnParamsForAutoKey();
/*  1874 */               i1 = 0;
/*       */             }
/*       */             else {
/*  1877 */               localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 41, Integer.valueOf(i + 1));
/*  1878 */               ((SQLException)localObject2).fillInStackTrace();
/*  1879 */               throw ((Throwable)localObject2);
/*       */             }
/*       */           }
/*       */       }
/*  1883 */       if (this.checkBindTypes)
/*       */       {
/*  1888 */         localObject2 = this.parameterOtype == null ? null : this.currentRank == 0 ? this.lastBoundTypeOtypes : this.parameterOtype[(this.currentRank - 1)];
/*       */ 
/*  1892 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  1894 */           if ((this.currentRowBinders[i] == null) && (i1 != 0))
/*       */           {
/*  1896 */             registerReturnParamsForAutoKey();
/*  1897 */             i1 = 0;
/*       */           }
/*  1899 */           localObject3 = this.currentRowBinders[i];
/*       */ 
/*  1901 */           if (localObject3 == null)
/*       */           {
/*  1906 */             if (this.clearParameters)
/*       */             {
/*  1908 */               SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 41, Integer.valueOf(i + 1));
/*  1909 */               localSQLException2.fillInStackTrace();
/*  1910 */               throw localSQLException2;
/*       */             }
/*       */ 
/*  1919 */             this.currentRowBinders[i] = arrayOfBinder[i].copyingBinder();
/*       */ 
/*  1922 */             if (this.currentRank == 0) {
/*  1923 */               this.currentRowBinders[i].lastBoundValueCleanup(this, i);
/*       */             }
/*       */ 
/*  1930 */             this.currentRowByteLens[i] = -1;
/*  1931 */             this.currentRowCharLens[i] = -1;
/*       */ 
/*  1937 */             k = 1;
/*       */           }
/*       */           else
/*       */           {
/*  1941 */             int i6 = ((Binder)localObject3).type;
/*       */ 
/*  1943 */             if ((i6 == arrayOfBinder[i].type) && (((i6 != 109) && (i6 != 111)) || (this.parameterOtype[this.currentRank][i].isInHierarchyOf(localObject2[i])))) { if (i6 == 9)
/*       */               {
/*  1943 */                 if ((((Binder)localObject3).bytelen == 0 ? 1 : 0) == (arrayOfBinder[i].bytelen == 0 ? 1 : 0));
/*       */               }
/*       */ 
/*       */             }
/*       */             else
/*       */             {
/*  1952 */               j = 1;
/*       */             }
/*       */           }
/*  1955 */           if (this.currentBatchFormOfUse[i] != this.currentRowFormOfUse[i])
/*       */           {
/*  1959 */             j = 1;
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*       */       }
/*       */       else
/*       */       {
/*  1968 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  1970 */           localObject2 = this.currentRowBinders[i];
/*       */ 
/*  1972 */           if (localObject2 == null)
/*       */           {
/*  1977 */             if (this.clearParameters)
/*       */             {
/*  1979 */               localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 41, Integer.valueOf(i + 1));
/*  1980 */               ((SQLException)localObject3).fillInStackTrace();
/*  1981 */               throw ((Throwable)localObject3);
/*       */             }
/*       */ 
/*  1990 */             this.currentRowBinders[i] = arrayOfBinder[i].copyingBinder();
/*       */ 
/*  1993 */             if (this.currentRank == 0) {
/*  1994 */               this.currentRowBinders[i].lastBoundValueCleanup(this, i);
/*       */             }
/*       */ 
/*  2000 */             this.currentRowByteLens[i] = -1;
/*  2001 */             this.currentRowCharLens[i] = -1;
/*       */ 
/*  2007 */             k = 1;
/*       */           }
/*       */         }
/*       */       }
/*       */ 
/*  2012 */       if ((k != 0) && ((n != 0) || (this.m_batchStyle == 2)))
/*       */       {
/*  2014 */         this.lastBoundNeeded = true;
/*       */       }
/*       */     }
/*       */     else
/*       */     {
/*       */       Object localObject1;
/*  2020 */       if (arrayOfBinder == null)
/*       */       {
/*  2026 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  2028 */           localObject1 = this.currentRowBinders[i];
/*  2029 */           localObject2 = this.currentRowBindAccessors[i];
/*       */ 
/*  2031 */           if (localObject1 == null)
/*       */           {
/*  2036 */             if (localObject2 == null)
/*       */             {
/*  2041 */               localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 41, Integer.valueOf(i + 1));
/*  2042 */               ((SQLException)localObject3).fillInStackTrace();
/*  2043 */               throw ((Throwable)localObject3);
/*       */             }
/*       */ 
/*  2049 */             this.currentRowBinders[i] = this.theOutBinder;
/*       */           }
/*  2051 */           else if ((localObject2 != null) && (!isDefineTypeCompatibleWithBindType(((Accessor)localObject2).defineType, ((Binder)localObject1).type)))
/*       */           {
/*  2056 */             m = 1;
/*       */           }
/*       */         }
/*       */       }
/*  2060 */       if (this.checkBindTypes)
/*       */       {
/*  2067 */         localObject1 = this.parameterOtype == null ? null : this.currentRank == 0 ? this.lastBoundTypeOtypes : this.parameterOtype[(this.currentRank - 1)];
/*       */ 
/*  2071 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  2073 */           localObject2 = this.currentRowBinders[i];
/*  2074 */           localObject3 = this.currentRowBindAccessors[i];
/*       */ 
/*  2076 */           if (localObject2 == null)
/*       */           {
/*  2082 */             if ((this.clearParameters) && (arrayOfBinder[i] != this.theOutBinder))
/*       */             {
/*  2085 */               SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 41, Integer.valueOf(i + 1));
/*  2086 */               localSQLException3.fillInStackTrace();
/*  2087 */               throw localSQLException3;
/*       */             }
/*       */ 
/*  2098 */             localObject2 = arrayOfBinder[i];
/*  2099 */             this.currentRowBinders[i] = localObject2;
/*  2100 */             this.currentRowByteLens[i] = -1;
/*  2101 */             this.currentRowCharLens[i] = -1;
/*       */ 
/*  2103 */             if (localObject2 != this.theOutBinder)
/*       */             {
/*  2109 */               k = 1;
/*       */             }
/*       */           }
/*       */           else {
/*  2113 */             int i7 = ((Binder)localObject2).type;
/*       */ 
/*  2115 */             if ((i7 == arrayOfBinder[i].type) && (((i7 != 109) && (i7 != 111)) || (this.parameterOtype[this.currentRank][i].isInHierarchyOf(localObject1[i])))) { if (i7 == 9)
/*       */               {
/*  2115 */                 if ((((Binder)localObject2).bytelen == 0 ? 1 : 0) == (arrayOfBinder[i].bytelen == 0 ? 1 : 0));
/*       */               }
/*       */ 
/*       */             }
/*       */             else
/*       */             {
/*  2124 */               j = 1;
/*       */             }
/*       */           }
/*  2127 */           if (this.currentBatchFormOfUse[i] != this.currentRowFormOfUse[i])
/*       */           {
/*  2131 */             j = 1;
/*       */           }
/*  2133 */           Accessor localAccessor = this.currentBatchBindAccessors[i];
/*       */ 
/*  2135 */           if (localObject3 == null)
/*       */           {
/*  2141 */             localObject3 = localAccessor;
/*  2142 */             this.currentRowBindAccessors[i] = localObject3;
/*       */           }
/*  2144 */           else if ((localAccessor != null) && (((Accessor)localObject3).defineType != localAccessor.defineType))
/*       */           {
/*  2149 */             j = 1;
/*       */           }
/*  2151 */           if ((localObject3 != null) && (localObject2 != this.theOutBinder) && (((Accessor)localObject3).defineType != ((Binder)localObject2).type))
/*       */           {
/*  2160 */             if ((!this.connection.permitTimestampDateMismatch) || (((Binder)localObject2).type != 180) || (((Accessor)localObject3).defineType != 12))
/*       */             {
/*  2164 */               m = 1;
/*       */             }
/*       */ 
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*       */       }
/*       */       else
/*       */       {
/*  2175 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  2177 */           localObject1 = this.currentRowBinders[i];
/*       */ 
/*  2179 */           if (localObject1 == null)
/*       */           {
/*  2185 */             if ((this.clearParameters) && (arrayOfBinder[i] != this.theOutBinder))
/*       */             {
/*  2187 */               localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 41, Integer.valueOf(i + 1));
/*  2188 */               ((SQLException)localObject2).fillInStackTrace();
/*  2189 */               throw ((Throwable)localObject2);
/*       */             }
/*       */ 
/*  2199 */             localObject1 = arrayOfBinder[i];
/*  2200 */             this.currentRowBinders[i] = localObject1;
/*  2201 */             this.currentRowByteLens[i] = -1;
/*  2202 */             this.currentRowCharLens[i] = -1;
/*       */ 
/*  2204 */             if (localObject1 != this.theOutBinder)
/*       */             {
/*  2210 */               k = 1;
/*       */             }
/*       */           }
/*  2213 */           if (this.currentRowBindAccessors[i] == null)
/*       */           {
/*  2218 */             this.currentRowBindAccessors[i] = this.currentBatchBindAccessors[i];
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*       */       }
/*       */ 
/*  2230 */       if ((k != 0) && (n != 0))
/*  2231 */         this.lastBoundNeeded = true;
/*       */     }
/*       */     int i2;
/*  2234 */     if (j != 0)
/*       */     {
/*  2238 */       if (n == 0)
/*       */       {
/*  2244 */         if (this.m_batchStyle == 2)
/*       */         {
/*  2251 */           pushBatch(false);
/*       */         }
/*       */         else
/*       */         {
/*  2260 */           i2 = this.validRows;
/*       */ 
/*  2262 */           this.prematureBatchCount = sendBatch();
/*  2263 */           this.validRows = i2;
/*       */ 
/*  2268 */           for (i = 0; i < this.numberOfBindPositions; i++) {
/*  2269 */             this.currentRowBinders[i].lastBoundValueCleanup(this, i);
/*       */           }
/*       */ 
/*  2273 */           if (k != 0) {
/*  2274 */             this.lastBoundNeeded = true;
/*       */           }
/*       */         }
/*       */ 
/*       */       }
/*       */ 
/*  2280 */       this.needToParse = true;
/*       */ 
/*  2284 */       this.currentRowNeedToPrepareBinds = true;
/*       */ 
/*  2287 */       this.needToPrepareDefineBuffer = true;
/*       */     }
/*  2289 */     else if (paramBoolean)
/*       */     {
/*  2295 */       pushBatch(false);
/*       */ 
/*  2299 */       this.needToParse = false;
/*       */ 
/*  2307 */       this.currentBatchNeedToPrepareBinds = false;
/*       */     }
/*       */ 
/*  2317 */     if ((this.currentBatchAccumulatedBindsSize > 2097152) && (this.m_batchStyle == 2))
/*       */     {
/*  2320 */       pushBatch(false);
/*  2321 */       this.needToParse = false;
/*       */     }
/*       */     int i5;
/*  2326 */     for (int i = 0; i < this.numberOfBindPositions; i++)
/*       */     {
/*  2329 */       i2 = this.currentRowCharLens[i];
/*  2330 */       if ((i2 == -1) && (this.currentRank == this.firstRowInBatch)) {
/*  2331 */         i2 = this.lastBoundCharLens[i];
/*       */       }
/*  2333 */       i5 = this.currentRowByteLens[i];
/*  2334 */       if ((i5 == -1) && (this.currentRank == this.firstRowInBatch)) {
/*  2335 */         i5 = this.lastBoundByteLens[i];
/*       */       }
/*  2337 */       this.currentBatchAccumulatedBindsSize += i2 + i5;
/*       */     }
/*       */ 
/*  2340 */     if (m != 0)
/*       */     {
/*  2347 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12);
/*  2348 */       localSQLException1.fillInStackTrace();
/*  2349 */       throw localSQLException1;
/*       */     }
/*       */ 
/*  2361 */     for (i = 0; i < this.numberOfBindPositions; i++)
/*       */     {
/*  2363 */       int i3 = this.currentRowByteLens[i];
/*       */ 
/*  2365 */       if ((i3 == -1) && (this.currentRank == this.firstRowInBatch)) {
/*  2366 */         i3 = this.lastBoundByteLens[i];
/*       */       }
/*  2368 */       if (this.currentBatchByteLens[i] < i3) {
/*  2369 */         this.currentBatchByteLens[i] = i3;
/*       */       }
/*  2371 */       i5 = this.currentRowCharLens[i];
/*  2372 */       if ((i5 == -1) && (this.currentRank == this.firstRowInBatch)) {
/*  2373 */         i5 = this.lastBoundCharLens[i];
/*       */       }
/*  2375 */       if (this.currentBatchCharLens[i] < i5) {
/*  2376 */         this.currentBatchCharLens[i] = i5;
/*       */       }
/*  2378 */       this.currentRowByteLens[i] = 0;
/*  2379 */       this.currentRowCharLens[i] = 0;
/*  2380 */       this.currentBatchFormOfUse[i] = this.currentRowFormOfUse[i];
/*       */     }
/*       */ 
/*  2385 */     if (this.currentRowNeedToPrepareBinds) {
/*  2386 */       this.currentBatchNeedToPrepareBinds = true;
/*       */     }
/*       */ 
/*  2395 */     if (this.currentRowBindAccessors != null)
/*       */     {
/*  2397 */       Accessor[] arrayOfAccessor = this.currentBatchBindAccessors;
/*       */ 
/*  2399 */       this.currentBatchBindAccessors = this.currentRowBindAccessors;
/*       */ 
/*  2401 */       if (arrayOfAccessor == null)
/*  2402 */         arrayOfAccessor = new Accessor[this.numberOfBindPositions];
/*       */       else {
/*  2404 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*  2405 */           arrayOfAccessor[i] = null;
/*       */       }
/*  2407 */       this.currentRowBindAccessors = arrayOfAccessor;
/*       */     }
/*       */ 
/*  2410 */     int i4 = this.currentRank + 1;
/*       */ 
/*  2412 */     if (i4 < paramInt)
/*       */     {
/*  2417 */       if (i4 >= this.numberOfBindRowsAllocated)
/*       */       {
/*  2423 */         i5 = this.numberOfBindRowsAllocated << 1;
/*       */ 
/*  2425 */         if (i5 <= i4) {
/*  2426 */           i5 = i4 + 1;
/*       */         }
/*  2428 */         growBinds(i5);
/*       */ 
/*  2430 */         this.currentBatchNeedToPrepareBinds = true;
/*       */ 
/*  2432 */         if (this.pushedBatches != null) {
/*  2433 */           this.pushedBatches.current_batch_need_to_prepare_binds = true;
/*       */         }
/*       */       }
/*       */ 
/*  2437 */       this.currentRowBinders = this.binders[i4];
/*       */     }
/*       */     else
/*       */     {
/*  2446 */       setupBindBuffers(0, paramInt);
/*       */ 
/*  2453 */       this.currentRowBinders = this.binders[0];
/*       */     }
/*       */ 
/*  2458 */     this.currentRowNeedToPrepareBinds = false;
/*       */ 
/*  2460 */     this.clearParameters = false;
/*       */   }
/*       */ 
/*       */   private boolean isDefineTypeCompatibleWithBindType(int paramInt1, int paramInt2)
/*       */   {
/*  2477 */     boolean bool = false;
/*       */ 
/*  2480 */     if (paramInt1 == paramInt2)
/*       */     {
/*  2482 */       bool = true;
/*       */     }
/*  2488 */     else if ((this.connection.permitTimestampDateMismatch) && (paramInt2 == 180) && (paramInt1 == 12))
/*       */     {
/*  2492 */       bool = true;
/*       */     }
/*       */ 
/*  2512 */     return bool;
/*       */   }
/*       */ 
/*       */   void processPlsqlIndexTabBinds(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2522 */     int i = 0;
/*  2523 */     int j = 0;
/*  2524 */     int k = 0;
/*  2525 */     int m = 0;
/*       */ 
/*  2527 */     Binder[] arrayOfBinder = this.binders[paramInt];
/*  2528 */     PlsqlIbtBindInfo[] arrayOfPlsqlIbtBindInfo = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[paramInt];
/*       */     Accessor localAccessor3;
/*  2532 */     for (Accessor localAccessor1 = 0; localAccessor1 < this.numberOfBindPositions; localAccessor1++)
/*       */     {
/*  2534 */       Binder localBinder1 = arrayOfBinder[localAccessor1];
/*  2535 */       localAccessor3 = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[localAccessor1];
/*       */ 
/*  2537 */       PlsqlIbtBindInfo localPlsqlIbtBindInfo1 = localAccessor3 == null ? null : localAccessor3.plsqlIndexTableBindInfo();
/*       */ 
/*  2539 */       PlsqlIbtBindInfo localPlsqlIbtBindInfo2 = localPlsqlIbtBindInfo1;
/*       */ 
/*  2541 */       if (localBinder1.type == 998)
/*       */       {
/*  2544 */         localPlsqlIbtBindInfo2 = arrayOfPlsqlIbtBindInfo[localAccessor1];
/*       */ 
/*  2546 */         if (localPlsqlIbtBindInfo1 != null)
/*       */         {
/*  2548 */           if (localPlsqlIbtBindInfo2.element_internal_type != localPlsqlIbtBindInfo1.element_internal_type)
/*       */           {
/*  2551 */             SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12);
/*  2552 */             localSQLException.fillInStackTrace();
/*  2553 */             throw localSQLException;
/*       */           }
/*       */ 
/*  2556 */           if (localPlsqlIbtBindInfo2.maxLen < localPlsqlIbtBindInfo1.maxLen) {
/*  2557 */             localPlsqlIbtBindInfo2.maxLen = localPlsqlIbtBindInfo1.maxLen;
/*       */           }
/*  2559 */           if (localPlsqlIbtBindInfo2.elemMaxLen < localPlsqlIbtBindInfo1.elemMaxLen) {
/*  2560 */             localPlsqlIbtBindInfo2.elemMaxLen = localPlsqlIbtBindInfo1.elemMaxLen;
/*       */           }
/*  2562 */           if (localPlsqlIbtBindInfo2.ibtByteLength > 0) {
/*  2563 */             localPlsqlIbtBindInfo2.ibtByteLength = (localPlsqlIbtBindInfo2.elemMaxLen * localPlsqlIbtBindInfo2.maxLen);
/*       */           }
/*       */           else {
/*  2566 */             localPlsqlIbtBindInfo2.ibtCharLength = (localPlsqlIbtBindInfo2.elemMaxLen * localPlsqlIbtBindInfo2.maxLen);
/*       */           }
/*       */         }
/*       */       }
/*       */ 
/*  2571 */       if (localPlsqlIbtBindInfo2 != null)
/*       */       {
/*  2573 */         i++;
/*  2574 */         k += localPlsqlIbtBindInfo2.ibtByteLength;
/*  2575 */         m += localPlsqlIbtBindInfo2.ibtCharLength;
/*  2576 */         j += localPlsqlIbtBindInfo2.maxLen;
/*       */       }
/*       */     }
/*       */ 
/*  2580 */     if (i == 0) {
/*  2581 */       return;
/*       */     }
/*       */ 
/*  2608 */     this.ibtBindIndicatorSize = (6 + i * 8 + j * 2);
/*       */ 
/*  2611 */     this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
/*  2612 */     this.ibtBindIndicatorOffset = 0;
/*       */ 
/*  2614 */     if (k > 0)
/*  2615 */       this.ibtBindBytes = new byte[k];
/*  2616 */     this.ibtBindByteOffset = 0;
/*       */ 
/*  2618 */     if (m > 0)
/*  2619 */       this.ibtBindChars = new char[m];
/*  2620 */     this.ibtBindCharOffset = 0;
/*       */ 
/*  2622 */     localAccessor1 = this.ibtBindByteOffset;
/*  2623 */     Accessor localAccessor2 = this.ibtBindCharOffset;
/*       */ 
/*  2625 */     int n = this.ibtBindIndicatorOffset;
/*  2626 */     int i1 = n + 6 + i * 8;
/*       */ 
/*  2628 */     this.ibtBindIndicators[(n++)] = ((short)(i >> 16));
/*  2629 */     this.ibtBindIndicators[(n++)] = ((short)(i & 0xFFFF));
/*       */ 
/*  2631 */     this.ibtBindIndicators[(n++)] = ((short)(k >> 16));
/*  2632 */     this.ibtBindIndicators[(n++)] = ((short)(k & 0xFFFF));
/*  2633 */     this.ibtBindIndicators[(n++)] = ((short)(m >> 16));
/*  2634 */     this.ibtBindIndicators[(n++)] = ((short)(m & 0xFFFF));
/*       */ 
/*  2637 */     for (int i2 = 0; i2 < this.numberOfBindPositions; i2++)
/*       */     {
/*  2639 */       Binder localBinder2 = arrayOfBinder[i2];
/*  2640 */       Accessor localAccessor4 = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[i2];
/*       */ 
/*  2642 */       PlsqlIbtBindInfo localPlsqlIbtBindInfo3 = localAccessor4 == null ? null : localAccessor4.plsqlIndexTableBindInfo();
/*       */ 
/*  2644 */       PlsqlIbtBindInfo localPlsqlIbtBindInfo4 = localPlsqlIbtBindInfo3;
/*       */ 
/*  2646 */       if (localBinder2.type == 998)
/*       */       {
/*  2648 */         localPlsqlIbtBindInfo4 = arrayOfPlsqlIbtBindInfo[i2];
/*       */       }
/*  2650 */       if (localPlsqlIbtBindInfo4 != null)
/*       */       {
/*  2653 */         int i3 = localPlsqlIbtBindInfo4.maxLen;
/*       */ 
/*  2655 */         this.ibtBindIndicators[(n++)] = ((short)localPlsqlIbtBindInfo4.element_internal_type);
/*       */ 
/*  2657 */         this.ibtBindIndicators[(n++)] = ((short)localPlsqlIbtBindInfo4.elemMaxLen);
/*  2658 */         this.ibtBindIndicators[(n++)] = ((short)(i3 >> 16));
/*  2659 */         this.ibtBindIndicators[(n++)] = ((short)(i3 & 0xFFFF));
/*  2660 */         this.ibtBindIndicators[(n++)] = ((short)(localPlsqlIbtBindInfo4.curLen >> 16));
/*  2661 */         this.ibtBindIndicators[(n++)] = ((short)(localPlsqlIbtBindInfo4.curLen & 0xFFFF));
/*       */ 
/*  2663 */         if (localPlsqlIbtBindInfo4.ibtByteLength > 0)
/*       */         {
/*  2665 */           localAccessor3 = localAccessor1;
/*  2666 */           localAccessor1 += localPlsqlIbtBindInfo4.ibtByteLength;
/*       */         }
/*       */         else
/*       */         {
/*  2670 */           localAccessor3 = localAccessor2;
/*  2671 */           localAccessor2 += localPlsqlIbtBindInfo4.ibtCharLength;
/*       */         }
/*       */ 
/*  2674 */         this.ibtBindIndicators[(n++)] = ((short)(localAccessor3 >> 16));
/*  2675 */         this.ibtBindIndicators[(n++)] = ((short)(localAccessor3 & 0xFFFF));
/*  2676 */         localPlsqlIbtBindInfo4.ibtValueIndex = localAccessor3;
/*       */ 
/*  2678 */         localPlsqlIbtBindInfo4.ibtIndicatorIndex = i1;
/*  2679 */         localPlsqlIbtBindInfo4.ibtLengthIndex = (i1 + i3);
/*       */ 
/*  2681 */         if (localPlsqlIbtBindInfo3 != null)
/*       */         {
/*  2683 */           if (localPlsqlIbtBindInfo3 != localPlsqlIbtBindInfo4)
/*       */           {
/*  2685 */             localPlsqlIbtBindInfo3.ibtIndicatorIndex = localPlsqlIbtBindInfo4.ibtIndicatorIndex;
/*  2686 */             localPlsqlIbtBindInfo3.ibtLengthIndex = localPlsqlIbtBindInfo4.ibtLengthIndex;
/*  2687 */             localPlsqlIbtBindInfo3.ibtValueIndex = localAccessor3;
/*       */           }
/*  2689 */           initializePlsqlIndexByTableAccessor(localAccessor4, n);
/*       */         }
/*       */ 
/*  2692 */         i1 += 2 * i3;
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void initializePlsqlIndexByTableAccessor(Accessor paramAccessor, int paramInt)
/*       */   {
/*       */   }
/*       */ 
/*       */   void initializeBindSubRanges(int paramInt1, int paramInt2)
/*       */   {
/*  2722 */     this.bindByteSubRange = 0;
/*  2723 */     this.bindCharSubRange = 0;
/*       */   }
/*       */ 
/*       */   int calculateIndicatorSubRangeSize()
/*       */   {
/*  2731 */     return 0;
/*       */   }
/*       */ 
/*       */   short getInoutIndicator(int paramInt)
/*       */   {
/*  2738 */     return 0;
/*       */   }
/*       */ 
/*       */   void initializeIndicatorSubRange()
/*       */   {
/*  2745 */     this.bindIndicatorSubRange = calculateIndicatorSubRangeSize();
/*       */   }
/*       */ 
/*       */   void prepareBindPreambles(int paramInt1, int paramInt2)
/*       */   {
/*       */   }
/*       */ 
/*       */   protected void configureBindData()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   void setupBindBuffers(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  2817 */     if (this.bindIndicators == null) allocBinds(paramInt2);
/*       */ 
/*       */     try
/*       */     {
/*  2821 */       if (this.numberOfBindPositions == 0)
/*       */       {
/*  2823 */         if (paramInt2 != 0)
/*       */         {
/*  2826 */           this.numberOfBoundRows = paramInt2;
/*  2827 */           this.bindIndicators[(this.bindIndicatorSubRange + 3)] = ((short)((this.numberOfBoundRows & 0xFFFF0000) >> 16));
/*       */ 
/*  2830 */           this.bindIndicators[(this.bindIndicatorSubRange + 4)] = ((short)(this.numberOfBoundRows & 0xFFFF));
/*       */         }
/*       */ 
/*  2835 */         return;
/*       */       }
/*       */ 
/*  2842 */       this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
/*  2843 */       this.preparedByteBinds = false;
/*  2844 */       this.preparedCharBinds = false;
/*       */ 
/*  2848 */       this.currentBatchNeedToPrepareBinds = false;
/*       */ 
/*  2851 */       this.numberOfBoundRows = paramInt2;
/*  2852 */       this.bindIndicators[(this.bindIndicatorSubRange + 3)] = ((short)((this.numberOfBoundRows & 0xFFFF0000) >> 16));
/*       */ 
/*  2855 */       this.bindIndicators[(this.bindIndicatorSubRange + 4)] = ((short)(this.numberOfBoundRows & 0xFFFF));
/*       */ 
/*  2863 */       int j = this.bindBufferCapacity;
/*       */ 
/*  2865 */       if (this.numberOfBoundRows > this.bindBufferCapacity)
/*       */       {
/*  2867 */         j = this.numberOfBoundRows;
/*  2868 */         this.preparedAllBinds = true;
/*       */       }
/*       */ 
/*  2871 */       if (this.currentBatchBindAccessors != null)
/*       */       {
/*  2878 */         if (this.outBindAccessors == null) {
/*  2879 */           this.outBindAccessors = new Accessor[this.numberOfBindPositions];
/*       */         }
/*  2881 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  2883 */           Accessor localAccessor1 = this.currentBatchBindAccessors[i];
/*       */ 
/*  2885 */           this.outBindAccessors[i] = localAccessor1;
/*       */ 
/*  2887 */           if (localAccessor1 != null)
/*       */           {
/*  2892 */             m = localAccessor1.byteLength;
/*  2893 */             n = localAccessor1.charLength;
/*       */ 
/*  2896 */             if (this.currentBatchByteLens[i] < m) {
/*  2897 */               this.currentBatchByteLens[i] = m;
/*       */             }
/*  2899 */             if ((n == 0) || (this.currentBatchCharLens[i] < n)) {
/*  2900 */               this.currentBatchCharLens[i] = n;
/*       */             }
/*       */           }
/*       */         }
/*       */       }
/*       */ 
/*  2906 */       int k = 0;
/*  2907 */       int m = 0;
/*       */ 
/*  2913 */       int n = this.bindIndicatorSubRange + 5;
/*       */ 
/*  2915 */       int i1 = n;
/*       */ 
/*  2917 */       if (this.preparedAllBinds)
/*       */       {
/*  2922 */         this.preparedByteBinds = true;
/*  2923 */         this.preparedCharBinds = true;
/*       */ 
/*  2929 */         Binder[] arrayOfBinder = this.binders[paramInt1];
/*       */ 
/*  2931 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  2933 */           Binder localBinder = arrayOfBinder[i];
/*       */ 
/*  2935 */           i5 = this.currentBatchByteLens[i];
/*  2936 */           i6 = this.currentBatchCharLens[i];
/*       */ 
/*  2938 */           if (localBinder == this.theOutBinder)
/*       */           {
/*  2940 */             Accessor localAccessor2 = this.currentBatchBindAccessors[i];
/*  2941 */             i4 = (short)localAccessor2.defineType;
/*       */           }
/*       */           else
/*       */           {
/*  2945 */             i4 = localBinder.type;
/*       */           }
/*       */ 
/*  2948 */           m += i5;
/*  2949 */           k += i6;
/*  2950 */           this.bindIndicators[(i1 + 0)] = i4;
/*  2951 */           this.bindIndicators[(i1 + 1)] = ((short)i5);
/*       */ 
/*  2953 */           this.bindIndicators[(i1 + 2)] = ((short)i6);
/*       */ 
/*  2955 */           this.bindIndicators[(i1 + 9)] = this.currentBatchFormOfUse[i];
/*       */ 
/*  2957 */           i1 += 10;
/*       */         }
/*       */       } else {
/*  2960 */         if ((this.preparedByteBinds | this.preparedCharBinds))
/*       */         {
/*  2965 */           for (i = 0; i < this.numberOfBindPositions; i++)
/*       */           {
/*  2967 */             i2 = this.currentBatchByteLens[i];
/*  2968 */             i3 = this.currentBatchCharLens[i];
/*       */ 
/*  2970 */             m += i2;
/*  2971 */             k += i3;
/*       */ 
/*  2973 */             this.bindIndicators[(i1 + 1)] = ((short)i2);
/*       */ 
/*  2975 */             this.bindIndicators[(i1 + 2)] = ((short)i3);
/*       */ 
/*  2977 */             i1 += 10;
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*  2992 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  2994 */           i2 = i1 + 1;
/*  2995 */           i3 = i1 + 2;
/*  2996 */           i4 = this.currentBatchByteLens[i];
/*  2997 */           i5 = this.currentBatchCharLens[i];
/*  2998 */           i6 = this.bindIndicators[i2];
/*  2999 */           i7 = this.bindIndicators[i3];
/*  3000 */           i8 = (this.bindIndicators[(i1 + 5)] << 16) + (this.bindIndicators[(i1 + 6)] & 0xFFFF);
/*       */ 
/*  3003 */           int i9 = this.bindIndicators[i8] == -1 ? 1 : 0;
/*       */ 
/*  3007 */           if ((i9 != 0) && (i4 > 1))
/*       */           {
/*  3009 */             this.preparedByteBinds = true;
/*       */           }
/*       */ 
/*  3012 */           if ((i6 >= i4) && (!this.preparedByteBinds))
/*       */           {
/*  3014 */             this.currentBatchByteLens[i] = i6;
/*  3015 */             m += i6;
/*       */           }
/*       */           else
/*       */           {
/*  3019 */             this.bindIndicators[i2] = ((short)i4);
/*  3020 */             m += i4;
/*  3021 */             this.preparedByteBinds = true;
/*       */           }
/*       */ 
/*  3024 */           if ((i9 != 0) && (i5 > 1))
/*       */           {
/*  3026 */             this.preparedCharBinds = true;
/*       */           }
/*       */ 
/*  3029 */           if ((i7 >= i5) && (!this.preparedCharBinds))
/*       */           {
/*  3031 */             this.currentBatchCharLens[i] = i7;
/*  3032 */             k += i7;
/*       */           }
/*       */           else
/*       */           {
/*  3036 */             this.bindIndicators[i3] = ((short)i5);
/*  3037 */             k += i5;
/*  3038 */             this.preparedCharBinds = true;
/*       */           }
/*       */ 
/*  3041 */           i1 += 10;
/*       */         }
/*       */ 
/*       */       }
/*       */ 
/*  3053 */       if ((this.preparedByteBinds | this.preparedCharBinds)) {
/*  3054 */         initializeBindSubRanges(this.numberOfBoundRows, j);
/*       */       }
/*  3056 */       if (this.preparedByteBinds)
/*       */       {
/*  3062 */         i2 = this.bindByteSubRange + m * j;
/*       */ 
/*  3074 */         if ((this.lastBoundNeeded) || (i2 > this.totalBindByteLength))
/*       */         {
/*  3078 */           this.bindByteOffset = 0;
/*  3079 */           this.bindBytes = this.connection.getByteBuffer(i2);
/*       */ 
/*  3082 */           this.totalBindByteLength = i2;
/*       */         }
/*       */ 
/*  3105 */         this.bindBufferCapacity = j;
/*       */ 
/*  3108 */         this.bindIndicators[(this.bindIndicatorSubRange + 1)] = ((short)((this.bindBufferCapacity & 0xFFFF0000) >> 16));
/*       */ 
/*  3111 */         this.bindIndicators[(this.bindIndicatorSubRange + 2)] = ((short)(this.bindBufferCapacity & 0xFFFF));
/*       */       }
/*       */ 
/*  3117 */       if (this.preparedCharBinds)
/*       */       {
/*  3123 */         i2 = this.bindCharSubRange + k * this.bindBufferCapacity;
/*       */ 
/*  3135 */         if ((this.lastBoundNeeded) || (i2 > this.totalBindCharLength))
/*       */         {
/*  3139 */           this.bindCharOffset = 0;
/*  3140 */           this.bindChars = this.connection.getCharBuffer(i2);
/*       */ 
/*  3143 */           this.totalBindCharLength = i2;
/*       */         }
/*       */ 
/*  3167 */         this.bindByteSubRange += this.bindByteOffset;
/*  3168 */         this.bindCharSubRange += this.bindCharOffset;
/*       */       }
/*       */ 
/*  3172 */       int i2 = this.bindByteSubRange;
/*  3173 */       int i3 = this.bindCharSubRange;
/*  3174 */       int i4 = this.indicatorsOffset;
/*  3175 */       int i5 = this.valueLengthsOffset;
/*       */ 
/*  3177 */       i1 = n;
/*       */ 
/*  3179 */       if ((this.preparedByteBinds | this.preparedCharBinds))
/*       */       {
/*  3181 */         if (this.currentBatchBindAccessors == null)
/*       */         {
/*  3185 */           for (i = 0; i < this.numberOfBindPositions; i++)
/*       */           {
/*  3189 */             i6 = this.currentBatchByteLens[i];
/*  3190 */             i7 = this.currentBatchCharLens[i];
/*       */ 
/*  3192 */             i8 = i7 == 0 ? i2 : i3;
/*       */ 
/*  3195 */             this.bindIndicators[(i1 + 3)] = ((short)(i8 >> 16));
/*       */ 
/*  3198 */             this.bindIndicators[(i1 + 4)] = ((short)(i8 & 0xFFFF));
/*       */ 
/*  3203 */             i2 += i6 * this.bindBufferCapacity;
/*  3204 */             i3 += i7 * this.bindBufferCapacity;
/*  3205 */             i1 += 10;
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*  3214 */         for (i = 0; i < this.numberOfBindPositions; i++)
/*       */         {
/*  3218 */           i6 = this.currentBatchByteLens[i];
/*  3219 */           i7 = this.currentBatchCharLens[i];
/*       */ 
/*  3221 */           i8 = i7 == 0 ? i2 : i3;
/*       */ 
/*  3224 */           this.bindIndicators[(i1 + 3)] = ((short)(i8 >> 16));
/*       */ 
/*  3227 */           this.bindIndicators[(i1 + 4)] = ((short)(i8 & 0xFFFF));
/*       */ 
/*  3232 */           localObject = this.currentBatchBindAccessors[i];
/*       */ 
/*  3234 */           if (localObject != null)
/*       */           {
/*  3239 */             if (i7 > 0)
/*       */             {
/*  3241 */               ((Accessor)localObject).columnDataOffset = i3;
/*  3242 */               ((Accessor)localObject).charLength = i7;
/*       */             }
/*       */             else
/*       */             {
/*  3246 */               ((Accessor)localObject).columnDataOffset = i2;
/*  3247 */               ((Accessor)localObject).byteLength = i6;
/*       */             }
/*       */ 
/*  3250 */             ((Accessor)localObject).lengthIndex = i5;
/*  3251 */             ((Accessor)localObject).indicatorIndex = i4;
/*  3252 */             ((Accessor)localObject).rowSpaceIndicator = this.bindIndicators;
/*       */ 
/*  3254 */             ((Accessor)localObject).setCapacity(this.bindBufferCapacity);
/*       */           }
/*       */ 
/*  3259 */           i2 += i6 * this.bindBufferCapacity;
/*  3260 */           i3 += i7 * this.bindBufferCapacity;
/*  3261 */           i4 += this.numberOfBindRowsAllocated;
/*  3262 */           i5 += this.numberOfBindRowsAllocated;
/*  3263 */           i1 += 10;
/*       */         }
/*       */ 
/*  3269 */         i2 = this.bindByteSubRange;
/*  3270 */         i3 = this.bindCharSubRange;
/*  3271 */         i4 = this.indicatorsOffset;
/*  3272 */         i5 = this.valueLengthsOffset;
/*  3273 */         i1 = n;
/*       */       }
/*       */ 
/*  3277 */       int i6 = this.bindBufferCapacity - this.numberOfBoundRows;
/*  3278 */       int i7 = this.numberOfBoundRows - 1;
/*  3279 */       int i8 = i7 + paramInt1;
/*  3280 */       Object localObject = this.binders[i8];
/*       */ 
/*  3282 */       if (this.parameterOtype != null)
/*       */       {
/*  3284 */         System.arraycopy(this.parameterDatum[i8], 0, this.lastBoundTypeBytes, 0, this.numberOfBindPositions);
/*       */ 
/*  3286 */         System.arraycopy(this.parameterOtype[i8], 0, this.lastBoundTypeOtypes, 0, this.numberOfBindPositions);
/*       */       }
/*       */ 
/*  3290 */       if (this.hasIbtBind) {
/*  3291 */         processPlsqlIndexTabBinds(paramInt1);
/*       */       }
/*  3293 */       if ((this.numReturnParams > 0) && ((this.accessors == null) || (this.accessors.length < this.numReturnParams)))
/*       */       {
/*  3297 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 173);
/*  3298 */         localSQLException2.fillInStackTrace();
/*  3299 */         throw localSQLException2;
/*       */       }
/*       */ 
/*  3302 */       if (this.numReturnParams > 0) processDmlReturningBind();
/*       */ 
/*  3304 */       boolean bool1 = (!this.sqlKind.isPlsqlOrCall()) || (this.currentRowBindAccessors == null);
/*       */ 
/*  3313 */       this.localCheckSum = this.checkSum;
/*       */ 
/*  3315 */       for (int i = 0; i < this.numberOfBindPositions; i++)
/*       */       {
/*  3318 */         int i10 = this.currentBatchByteLens[i];
/*  3319 */         int i11 = this.currentBatchCharLens[i];
/*       */ 
/*  3322 */         this.lastBinders[i] = localObject[i];
/*  3323 */         this.lastBoundByteLens[i] = i10;
/*       */ 
/*  3332 */         for (int i12 = 0; i12 < this.numberOfBoundRows; 
/*  3333 */           i12++)
/*       */         {
/*  3335 */           int i13 = paramInt1 + i12;
/*       */ 
/*  3337 */           this.localCheckSum = this.binders[i13][i].bind(this, i, i12, i13, this.bindBytes, this.bindChars, this.bindIndicators, i10, i11, i2, i3, i5 + i12, i4 + i12, bool1, this.localCheckSum);
/*       */ 
/*  3344 */           this.binders[i13][i] = null;
/*  3345 */           if (this.userStream != null) this.userStream[i12][i] = null;
/*       */ 
/*  3347 */           i2 += i10;
/*  3348 */           i3 += i11;
/*       */         }
/*  3350 */         if (this.bindChecksumListener != null) {
/*  3351 */           boolean bool2 = this.bindChecksumListener.shouldContinue(this.checkSum);
/*       */ 
/*  3357 */           this.bindChecksumListener = null;
/*       */ 
/*  3360 */           if (!bool2)
/*       */           {
/*  3362 */             SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 290);
/*  3363 */             localSQLException3.fillInStackTrace();
/*  3364 */             throw localSQLException3;
/*       */           }
/*       */         }
/*       */ 
/*  3368 */         this.lastBoundByteOffsets[i] = (i2 - i10);
/*  3369 */         this.lastBoundCharOffsets[i] = (i3 - i11);
/*  3370 */         this.lastBoundInds[i] = this.bindIndicators[(i4 + i7)];
/*  3371 */         this.lastBoundLens[i] = this.bindIndicators[(i5 + i7)];
/*       */ 
/*  3376 */         this.lastBoundByteLens[i] = 0;
/*       */ 
/*  3381 */         this.lastBoundCharLens[i] = 0;
/*       */ 
/*  3384 */         i2 += i6 * i10;
/*  3385 */         i3 += i6 * i11;
/*  3386 */         i4 += this.numberOfBindRowsAllocated;
/*  3387 */         i5 += this.numberOfBindRowsAllocated;
/*  3388 */         i1 += 10;
/*       */       }
/*  3390 */       this.checkSum = this.localCheckSum;
/*       */ 
/*  3393 */       this.lastBoundBytes = this.bindBytes;
/*  3394 */       this.lastBoundByteOffset = this.bindByteOffset;
/*  3395 */       this.lastBoundChars = this.bindChars;
/*  3396 */       this.lastBoundCharOffset = this.bindCharOffset;
/*  3397 */       if (this.parameterStream != null) {
/*  3398 */         this.lastBoundStream = this.parameterStream[(paramInt1 + this.numberOfBoundRows - 1)];
/*       */       }
/*       */ 
/*  3402 */       int[] arrayOfInt1 = this.currentBatchByteLens;
/*       */ 
/*  3404 */       this.currentBatchByteLens = this.lastBoundByteLens;
/*  3405 */       this.lastBoundByteLens = arrayOfInt1;
/*       */ 
/*  3409 */       int[] arrayOfInt2 = this.currentBatchCharLens;
/*       */ 
/*  3411 */       this.currentBatchCharLens = this.lastBoundCharLens;
/*  3412 */       this.lastBoundCharLens = arrayOfInt2;
/*       */ 
/*  3415 */       this.lastBoundNeeded = false;
/*       */ 
/*  3419 */       prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
/*       */ 
/*  3421 */       configureBindData();
/*       */ 
/*  3425 */       this.checkSum = this.localCheckSum;
/*  3426 */       this.localCheckSum = 0L;
/*       */     }
/*       */     catch (NullPointerException localNullPointerException)
/*       */     {
/*  3433 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89, null, localNullPointerException);
/*  3434 */       localSQLException1.fillInStackTrace();
/*  3435 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   void releaseBuffers()
/*       */   {
/*  3445 */     super.releaseBuffers();
/*       */ 
/*  3448 */     this.parameterStream = ((InputStream[][])null);
/*  3449 */     this.parameterInt = ((int[][])null);
/*  3450 */     this.parameterLong = ((long[][])null);
/*  3451 */     this.parameterFloat = ((float[][])null);
/*  3452 */     this.parameterDouble = ((double[][])null);
/*  3453 */     this.parameterBigDecimal = ((BigDecimal[][])null);
/*  3454 */     this.parameterString = ((String[][])null);
/*  3455 */     this.parameterDate = ((Date[][])null);
/*  3456 */     this.parameterTime = ((Time[][])null);
/*  3457 */     this.parameterTimestamp = ((Timestamp[][])null);
/*  3458 */     this.parameterDatum = ((byte[][][])null);
/*  3459 */     this.parameterOtype = ((OracleTypeADT[][])null);
/*       */ 
/*  3462 */     this.connection.cacheBuffer(this.bindBytes);
/*  3463 */     this.bindBytes = null;
/*  3464 */     this.totalBindByteLength = 0;
/*  3465 */     this.connection.cacheBuffer(this.bindChars);
/*  3466 */     this.bindChars = null;
/*  3467 */     this.totalBindCharLength = 0;
/*  3468 */     this.bindIndicators = null;
/*  3469 */     this.totalBindIndicatorLength = 0;
/*  3470 */     this.bindBufferCapacity = 0;
/*  3471 */     this.numberOfBindRowsAllocated = 1;
/*       */ 
/*  3473 */     this.lastBoundStream = null;
/*  3474 */     this.userStream = ((Object[][])null);
/*       */     try
/*       */     {
/*  3478 */       clearParameters();
/*       */     }
/*       */     catch (SQLException localSQLException)
/*       */     {
/*       */     }
/*       */   }
/*       */ 
/*       */   public void enterImplicitCache()
/*       */     throws SQLException
/*       */   {
/*  3501 */     alwaysOnClose();
/*       */ 
/*  3506 */     if (!this.connection.isClosed())
/*       */     {
/*  3508 */       cleanAllTempLobs();
/*       */     }
/*       */ 
/*  3511 */     if (this.connection.clearStatementMetaData)
/*       */     {
/*  3513 */       this.lastBoundBytes = null;
/*  3514 */       this.lastBoundChars = null;
/*       */     }
/*       */ 
/*  3520 */     this.cacheState = 2;
/*  3521 */     this.creationState = 1;
/*       */ 
/*  3525 */     this.currentResultSet = null;
/*  3526 */     this.lastIndex = 0;
/*       */ 
/*  3528 */     this.queryTimeout = 0;
/*  3529 */     this.rowPrefetchChanged = false;
/*  3530 */     this.currentRank = 0;
/*  3531 */     this.currentBatchAccumulatedBindsSize = 0;
/*  3532 */     this.validRows = 0;
/*  3533 */     this.maxRows = 0;
/*  3534 */     this.maxFieldSize = 0;
/*  3535 */     this.gotLastBatch = false;
/*  3536 */     this.clearParameters = true;
/*  3537 */     this.defaultTimeZone = null;
/*  3538 */     this.defaultCalendar = null;
/*  3539 */     this.checkSum = 0L;
/*  3540 */     this.checkSumComputationFailure = false;
/*       */ 
/*  3542 */     if (this.sqlKind.isOTHER())
/*       */     {
/*  3544 */       this.needToParse = true;
/*  3545 */       this.needToPrepareDefineBuffer = true;
/*  3546 */       this.columnsDefinedByUser = false;
/*       */     }
/*       */ 
/*  3549 */     releaseBuffers();
/*       */ 
/*  3552 */     this.definedColumnType = null;
/*  3553 */     this.definedColumnSize = null;
/*  3554 */     this.definedColumnFormOfUse = null;
/*       */ 
/*  3559 */     if (this.accessors != null)
/*       */     {
/*  3561 */       int i = this.accessors.length;
/*       */ 
/*  3563 */       for (int j = 0; j < i; j++)
/*       */       {
/*  3565 */         if (this.accessors[j] != null)
/*       */         {
/*  3567 */           this.accessors[j].rowSpaceIndicator = null;
/*  3568 */           if (this.columnsDefinedByUser) {
/*  3569 */             this.accessors[j].externalType = 0;
/*       */           }
/*       */         }
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  3576 */     this.fixedString = this.connection.getDefaultFixedString();
/*  3577 */     this.defaultRowPrefetch = this.rowPrefetch;
/*  3578 */     this.rowPrefetchInLastFetch = -1;
/*       */ 
/*  3584 */     if (this.connection.clearStatementMetaData)
/*       */     {
/*  3588 */       this.needToParse = true;
/*  3589 */       this.needToPrepareDefineBuffer = true;
/*  3590 */       this.columnsDefinedByUser = false;
/*       */ 
/*  3595 */       if (this.userRsetType == OracleResultSet.ResultSetType.UNKNOWN)
/*       */       {
/*  3597 */         this.userRsetType = DEFAULT_RESULT_SET_TYPE;
/*  3598 */         this.realRsetType = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
/*       */       }
/*  3600 */       this.currentRowNeedToPrepareBinds = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void enterExplicitCache()
/*       */     throws SQLException
/*       */   {
/*  3618 */     this.cacheState = 2;
/*  3619 */     this.creationState = 2;
/*  3620 */     this.defaultTimeZone = null;
/*       */ 
/*  3622 */     alwaysOnClose();
/*       */   }
/*       */ 
/*       */   public void exitImplicitCacheToActive()
/*       */     throws SQLException
/*       */   {
/*  3637 */     this.cacheState = 1;
/*  3638 */     this.closed = false;
/*       */ 
/*  3645 */     if (this.rowPrefetch != this.connection.getDefaultRowPrefetch())
/*       */     {
/*  3647 */       if (this.streamList == null)
/*       */       {
/*  3655 */         this.rowPrefetch = this.connection.getDefaultRowPrefetch();
/*  3656 */         this.defaultRowPrefetch = this.rowPrefetch;
/*       */ 
/*  3659 */         this.rowPrefetchChanged = true;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/*  3668 */     if (this.batch != this.connection.getDefaultExecuteBatch())
/*       */     {
/*  3670 */       resetBatch();
/*       */     }
/*       */ 
/*  3678 */     this.processEscapes = this.connection.processEscapes;
/*       */ 
/*  3680 */     if (this.accessors != null) {
/*  3681 */       doInitializationAfterDefineBufferRestore();
/*       */     }
/*  3683 */     if ((this.cachedBindCharSize != 0) || (this.cachedBindByteSize != 0))
/*       */     {
/*  3685 */       if (this.cachedBindByteSize > 0)
/*  3686 */         this.bindBytes = this.connection.getByteBuffer(this.cachedBindByteSize);
/*  3687 */       if (this.cachedBindCharSize > 0)
/*  3688 */         this.bindChars = this.connection.getCharBuffer(this.cachedBindCharSize);
/*  3689 */       doLocalInitialization();
/*       */     }
/*       */   }
/*       */ 
/*       */   void doLocalInitialization()
/*       */   {
/*       */   }
/*       */ 
/*       */   void doInitializationAfterDefineBufferRestore()
/*       */   {
/*       */   }
/*       */ 
/*       */   public void exitExplicitCacheToActive()
/*       */     throws SQLException
/*       */   {
/*  3721 */     this.cacheState = 1;
/*  3722 */     this.closed = false;
/*       */   }
/*       */ 
/*       */   public void exitImplicitCacheToClose()
/*       */     throws SQLException
/*       */   {
/*  3737 */     this.cacheState = 0;
/*  3738 */     this.closed = false;
/*       */ 
/*  3740 */     synchronized (this.connection) {
/*  3741 */       hardClose();
/*       */     }
/*       */   }
/*       */ 
/*       */   public void exitExplicitCacheToClose()
/*       */     throws SQLException
/*       */   {
/*  3757 */     this.cacheState = 0;
/*  3758 */     this.closed = false;
/*       */ 
/*  3760 */     synchronized (this.connection) {
/*  3761 */       hardClose();
/*       */     }
/*       */   }
/*       */ 
/*       */   public void closeWithKey(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3777 */     synchronized (this.connection)
/*       */     {
/*  3787 */       closeOrCache(paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   int executeInternal()
/*       */     throws SQLException
/*       */   {
/*  3795 */     this.noMoreUpdateCounts = false;
/*  3796 */     this.checkSum = 0L;
/*  3797 */     this.checkSumComputationFailure = false;
/*       */ 
/*  3799 */     ensureOpen();
/*       */ 
/*  3802 */     if ((this.currentRank > 0) && (this.m_batchStyle == 2))
/*       */     {
/*  3805 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
/*  3806 */       localSQLException.fillInStackTrace();
/*  3807 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3811 */     int i = this.userRsetType == DEFAULT_RESULT_SET_TYPE ? 1 : 0;
/*       */ 
/*  3813 */     prepareForNewResults(true, false, true);
/*       */ 
/*  3815 */     processCompletedBindRow(this.sqlKind.isSELECT() ? 1 : this.batch, false);
/*       */ 
/*  3817 */     if ((i == 0) && (!this.scrollRsetTypeSolved)) {
/*  3818 */       return doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
/*       */     }
/*  3820 */     doExecuteWithTimeout();
/*       */ 
/*  3822 */     int j = (this.prematureBatchCount != 0) && (this.validRows > 0) ? 1 : 0;
/*       */ 
/*  3824 */     if (i == 0)
/*       */     {
/*  3826 */       computeOffsetOfFirstUserColumn();
/*  3827 */       this.currentResultSet = OracleResultSet.createResultSet(this);
/*       */ 
/*  3829 */       if (!this.connection.accumulateBatchResult) {
/*  3830 */         j = 0;
/*       */       }
/*       */     }
/*  3833 */     if (j != 0)
/*       */     {
/*  3836 */       this.validRows += this.prematureBatchCount;
/*  3837 */       this.prematureBatchCount = 0;
/*       */     }
/*  3839 */     if (this.sqlKind.isOTHER()) this.needToParse = true;
/*  3840 */     return this.validRows;
/*       */   }
/*       */ 
/*       */   public ResultSet executeQuery()
/*       */     throws SQLException
/*       */   {
/*  3854 */     synchronized (this.connection)
/*       */     {
/*  3864 */       this.executeDoneForDefines = true;
/*  3865 */       this.executionType = 1;
/*       */ 
/*  3867 */       executeInternal();
/*       */ 
/*  3869 */       computeOffsetOfFirstUserColumn();
/*  3870 */       this.currentResultSet = OracleResultSet.createResultSet(this);
/*  3871 */       return this.currentResultSet;
/*       */     }
/*       */   }
/*       */ 
/*       */   public int executeUpdate()
/*       */     throws SQLException
/*       */   {
/*  3885 */     synchronized (this.connection)
/*       */     {
/*  3895 */       this.executionType = 2;
/*       */ 
/*  3897 */       return executeInternal();
/*       */     }
/*       */   }
/*       */ 
/*       */   public boolean execute()
/*       */     throws SQLException
/*       */   {
/*  3910 */     synchronized (this.connection)
/*       */     {
/*  3920 */       this.executeDoneForDefines = true;
/*  3921 */       this.executionType = 3;
/*       */ 
/*  3923 */       executeInternal();
/*       */ 
/*  3925 */       return this.sqlKind.isSELECT();
/*       */     }
/*       */   }
/*       */ 
/*       */   void slideDownCurrentRow(int paramInt)
/*       */   {
/*  3943 */     if (this.binders != null)
/*       */     {
/*  3945 */       this.binders[paramInt] = this.binders[0];
/*  3946 */       this.binders[0] = this.currentRowBinders;
/*       */     }
/*       */     Object localObject;
/*  3950 */     if (this.parameterInt != null)
/*       */     {
/*  3952 */       localObject = this.parameterInt[0];
/*       */ 
/*  3954 */       this.parameterInt[0] = this.parameterInt[paramInt];
/*  3955 */       this.parameterInt[paramInt] = localObject;
/*       */     }
/*       */ 
/*  3958 */     if (this.parameterLong != null)
/*       */     {
/*  3960 */       localObject = this.parameterLong[0];
/*       */ 
/*  3962 */       this.parameterLong[0] = this.parameterLong[paramInt];
/*  3963 */       this.parameterLong[paramInt] = localObject;
/*       */     }
/*       */ 
/*  3966 */     if (this.parameterFloat != null)
/*       */     {
/*  3968 */       localObject = this.parameterFloat[0];
/*       */ 
/*  3970 */       this.parameterFloat[0] = this.parameterFloat[paramInt];
/*  3971 */       this.parameterFloat[paramInt] = localObject;
/*       */     }
/*       */ 
/*  3974 */     if (this.parameterDouble != null)
/*       */     {
/*  3976 */       localObject = this.parameterDouble[0];
/*       */ 
/*  3978 */       this.parameterDouble[0] = this.parameterDouble[paramInt];
/*  3979 */       this.parameterDouble[paramInt] = localObject;
/*       */     }
/*       */ 
/*  3982 */     if (this.parameterBigDecimal != null)
/*       */     {
/*  3984 */       localObject = this.parameterBigDecimal[0];
/*       */ 
/*  3986 */       this.parameterBigDecimal[0] = this.parameterBigDecimal[paramInt];
/*  3987 */       this.parameterBigDecimal[paramInt] = localObject;
/*       */     }
/*       */ 
/*  3990 */     if (this.parameterString != null)
/*       */     {
/*  3992 */       localObject = this.parameterString[0];
/*       */ 
/*  3994 */       this.parameterString[0] = this.parameterString[paramInt];
/*  3995 */       this.parameterString[paramInt] = localObject;
/*       */     }
/*       */ 
/*  3998 */     if (this.parameterDate != null)
/*       */     {
/*  4000 */       localObject = this.parameterDate[0];
/*       */ 
/*  4002 */       this.parameterDate[0] = this.parameterDate[paramInt];
/*  4003 */       this.parameterDate[paramInt] = localObject;
/*       */     }
/*       */ 
/*  4006 */     if (this.parameterTime != null)
/*       */     {
/*  4008 */       localObject = this.parameterTime[0];
/*       */ 
/*  4010 */       this.parameterTime[0] = this.parameterTime[paramInt];
/*  4011 */       this.parameterTime[paramInt] = localObject;
/*       */     }
/*       */ 
/*  4014 */     if (this.parameterTimestamp != null)
/*       */     {
/*  4016 */       localObject = this.parameterTimestamp[0];
/*       */ 
/*  4018 */       this.parameterTimestamp[0] = this.parameterTimestamp[paramInt];
/*  4019 */       this.parameterTimestamp[paramInt] = localObject;
/*       */     }
/*       */ 
/*  4022 */     if (this.parameterDatum != null)
/*       */     {
/*  4024 */       localObject = this.parameterDatum[0];
/*       */ 
/*  4026 */       this.parameterDatum[0] = this.parameterDatum[paramInt];
/*  4027 */       this.parameterDatum[paramInt] = localObject;
/*       */     }
/*       */ 
/*  4030 */     if (this.parameterOtype != null)
/*       */     {
/*  4032 */       localObject = this.parameterOtype[0];
/*       */ 
/*  4034 */       this.parameterOtype[0] = this.parameterOtype[paramInt];
/*  4035 */       this.parameterOtype[paramInt] = localObject;
/*       */     }
/*       */ 
/*  4038 */     if (this.parameterStream != null)
/*       */     {
/*  4040 */       localObject = this.parameterStream[0];
/*       */ 
/*  4042 */       this.parameterStream[0] = this.parameterStream[paramInt];
/*  4043 */       this.parameterStream[paramInt] = localObject;
/*       */     }
/*       */ 
/*  4046 */     if (this.userStream != null)
/*       */     {
/*  4048 */       localObject = this.userStream[0];
/*       */ 
/*  4050 */       this.userStream[0] = this.userStream[paramInt];
/*  4051 */       this.userStream[paramInt] = localObject;
/*       */     }
/*       */   }
/*       */ 
/*       */   void resetBatch()
/*       */   {
/*  4059 */     this.batch = this.connection.getDefaultExecuteBatch();
/*       */   }
/*       */ 
/*       */   public int sendBatch()
/*       */     throws SQLException
/*       */   {
/*  4094 */     if (isJdbcBatchStyle())
/*       */     {
/*  4096 */       return 0;
/*       */     }
/*       */ 
/*  4101 */     synchronized (this.connection)
/*       */     {
/*  4104 */       if ((!this.connection.isUsable()) || (this.bsendBatchInProgress))
/*       */       {
/*  4106 */         clearBatch();
/*  4107 */         this.bsendBatchInProgress = false;
/*  4108 */         return 0;
/*       */       }
/*       */ 
/*       */       try
/*       */       {
/*  4118 */         ensureOpen();
/*       */ 
/*  4122 */         if (this.currentRank <= 0) {
/*  4123 */           i = this.connection.accumulateBatchResult ? 0 : this.validRows;
/*       */ 
/*  4168 */           this.currentRank = 0;
/*  4169 */           this.bsendBatchInProgress = false; return i;
/*       */         }
/*  4130 */         int i = this.batch;
/*  4131 */         this.bsendBatchInProgress = true;
/*       */         try
/*       */         {
/*  4135 */           j = this.currentRank;
/*       */ 
/*  4137 */           if (this.batch != this.currentRank) {
/*  4138 */             this.batch = this.currentRank;
/*       */           }
/*  4140 */           setupBindBuffers(0, this.currentRank);
/*  4141 */           this.currentRank -= 1;
/*  4142 */           doExecuteWithTimeout();
/*       */ 
/*  4146 */           slideDownCurrentRow(j);
/*       */ 
/*  4150 */           if (this.batch != i)
/*  4151 */             this.batch = i;
/*       */         }
/*       */         finally
/*       */         {
/*  4150 */           if (this.batch != i) {
/*  4151 */             this.batch = i;
/*       */           }
/*       */ 
/*       */         }
/*       */ 
/*  4156 */         if (this.connection.accumulateBatchResult)
/*       */         {
/*  4159 */           this.validRows += this.prematureBatchCount;
/*  4160 */           this.prematureBatchCount = 0;
/*       */         }
/*  4162 */         int j = this.validRows;
/*       */ 
/*  4168 */         this.currentRank = 0;
/*  4169 */         this.bsendBatchInProgress = false; return j;
/*       */       }
/*       */       finally
/*       */       {
/*  4168 */         this.currentRank = 0;
/*  4169 */         this.bsendBatchInProgress = false;
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setExecuteBatch(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4209 */     synchronized (this.connection)
/*       */     {
/*  4217 */       if (paramInt <= 0)
/*       */       {
/*  4219 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 42);
/*  4220 */         localSQLException.fillInStackTrace();
/*  4221 */         throw localSQLException;
/*       */       }
/*       */ 
/*  4224 */       setOracleBatchStyle();
/*  4225 */       set_execute_batch(paramInt);
/*       */     }
/*       */   }
/*       */ 
/*       */   void set_execute_batch(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4236 */     synchronized (this.connection)
/*       */     {
/*  4239 */       if (paramInt <= 0)
/*       */       {
/*  4241 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 42);
/*  4242 */         localSQLException.fillInStackTrace();
/*  4243 */         throw localSQLException;
/*       */       }
/*       */ 
/*  4246 */       if (paramInt == this.batch) {
/*  4247 */         return;
/*       */       }
/*       */ 
/*  4253 */       if (this.currentRank > 0)
/*       */       {
/*  4258 */         i = this.validRows;
/*       */ 
/*  4260 */         this.prematureBatchCount = sendBatch();
/*  4261 */         this.validRows = i;
/*       */       }
/*       */ 
/*  4264 */       int i = this.batch;
/*       */ 
/*  4266 */       this.batch = paramInt;
/*       */ 
/*  4268 */       if (this.numberOfBindRowsAllocated < this.batch)
/*  4269 */         growBinds(this.batch);
/*       */     }
/*       */   }
/*       */ 
/*       */   public final int getExecuteBatch()
/*       */   {
/*  4291 */     return this.batch;
/*       */   }
/*       */ 
/*       */   public void defineParameterTypeBytes(int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  4323 */     synchronized (this.connection)
/*       */     {
/*       */       SQLException localSQLException;
/*  4331 */       if (paramInt3 < 0)
/*       */       {
/*  4333 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 53);
/*  4334 */         localSQLException.fillInStackTrace();
/*  4335 */         throw localSQLException;
/*       */       }
/*       */ 
/*  4338 */       if (paramInt1 < 1)
/*       */       {
/*  4340 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  4341 */         localSQLException.fillInStackTrace();
/*  4342 */         throw localSQLException;
/*       */       }
/*       */ 
/*  4345 */       switch (paramInt2)
/*       */       {
/*       */       case -7:
/*       */       case -6:
/*       */       case -5:
/*       */       case 2:
/*       */       case 3:
/*       */       case 4:
/*       */       case 5:
/*       */       case 6:
/*       */       case 7:
/*       */       case 8:
/*  4370 */         paramInt2 = 6;
/*       */ 
/*  4372 */         break;
/*       */       case 1:
/*  4377 */         paramInt2 = 96;
/*       */ 
/*  4379 */         break;
/*       */       case 12:
/*  4384 */         paramInt2 = 1;
/*       */ 
/*  4386 */         break;
/*       */       case 91:
/*       */       case 92:
/*  4393 */         paramInt2 = 12;
/*       */ 
/*  4395 */         break;
/*       */       case -103:
/*  4400 */         paramInt2 = 182;
/*       */ 
/*  4402 */         break;
/*       */       case -104:
/*  4407 */         paramInt2 = 183;
/*       */ 
/*  4409 */         break;
/*       */       case -100:
/*       */       case 93:
/*  4416 */         paramInt2 = 180;
/*       */ 
/*  4418 */         break;
/*       */       case -101:
/*  4423 */         paramInt2 = 181;
/*       */ 
/*  4425 */         break;
/*       */       case -102:
/*  4430 */         paramInt2 = 231;
/*       */ 
/*  4432 */         break;
/*       */       case -3:
/*       */       case -2:
/*  4439 */         paramInt2 = 23;
/*       */ 
/*  4441 */         break;
/*       */       case 100:
/*  4446 */         paramInt2 = 100;
/*       */ 
/*  4448 */         break;
/*       */       case 101:
/*  4453 */         paramInt2 = 101;
/*       */ 
/*  4455 */         break;
/*       */       case -8:
/*  4460 */         paramInt2 = 104;
/*       */ 
/*  4462 */         break;
/*       */       case 2004:
/*  4467 */         paramInt2 = 113;
/*       */ 
/*  4469 */         break;
/*       */       case 2005:
/*  4474 */         paramInt2 = 112;
/*       */ 
/*  4476 */         break;
/*       */       case -13:
/*  4481 */         paramInt2 = 114;
/*       */ 
/*  4483 */         break;
/*       */       case -10:
/*  4488 */         paramInt2 = 102;
/*       */ 
/*  4490 */         break;
/*       */       case 0:
/*  4495 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  4496 */         localSQLException.fillInStackTrace();
/*  4497 */         throw localSQLException;
/*       */       default:
/*  4502 */         localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  4503 */         localSQLException.fillInStackTrace();
/*  4504 */         throw localSQLException;
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   public void defineParameterTypeChars(int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  4542 */     synchronized (this.connection)
/*       */     {
/*  4552 */       int i = this.connection.getNlsRatio();
/*       */ 
/*  4554 */       if ((paramInt2 == 1) || (paramInt2 == 12))
/*  4555 */         defineParameterTypeBytes(paramInt1, paramInt2, paramInt3 * i);
/*       */       else
/*  4557 */         defineParameterTypeBytes(paramInt1, paramInt2, paramInt3);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void defineParameterType(int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  4571 */     synchronized (this.connection)
/*       */     {
/*  4580 */       defineParameterTypeBytes(paramInt1, paramInt2, paramInt3);
/*       */     }
/*       */   }
/*       */ 
/*       */   public ResultSetMetaData getMetaData()
/*       */     throws SQLException
/*       */   {
/*  4602 */     ensureOpen();
/*  4603 */     if (this.sqlKind.isSELECT()) return getResultSetMetaData();
/*  4604 */     return null;
/*       */   }
/*       */ 
/*       */   public void setNull(int paramInt1, int paramInt2, String paramString)
/*       */     throws SQLException
/*       */   {
/*  4648 */     setNullInternal(paramInt1, paramInt2, paramString);
/*       */   }
/*       */ 
/*       */   void setNullInternal(int paramInt1, int paramInt2, String paramString)
/*       */     throws SQLException
/*       */   {
/*  4656 */     int i = paramInt1 - 1;
/*       */ 
/*  4658 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/*  4660 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  4661 */       localSQLException.fillInStackTrace();
/*  4662 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4665 */     if ((paramInt2 == 2002) || (paramInt2 == 2008) || (paramInt2 == 2003) || (paramInt2 == 2007) || (paramInt2 == 2009) || (paramInt2 == 2006))
/*       */     {
/*  4672 */       synchronized (this.connection) {
/*  4673 */         setNullCritical(i, paramInt2, paramString);
/*       */       }
/*       */ 
/*       */     }
/*       */     else
/*       */     {
/*  4679 */       setNullInternal(paramInt1, paramInt2);
/*       */ 
/*  4681 */       return;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setNullInternal(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  4689 */     synchronized (this.connection)
/*       */     {
/*  4691 */       setNullCritical(paramInt1, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setNullCritical(int paramInt1, int paramInt2, String paramString)
/*       */     throws SQLException
/*       */   {
/*  4700 */     Object localObject1 = null;
/*  4701 */     Binder localBinder = this.theNamedTypeNullBinder;
/*       */     Object localObject2;
/*  4703 */     switch (paramInt2)
/*       */     {
/*       */     case 2006:
/*  4707 */       localBinder = this.theRefTypeNullBinder;
/*       */     case 2002:
/*       */     case 2008:
/*  4713 */       localObject2 = StructDescriptor.createDescriptor(paramString, this.connection);
/*       */ 
/*  4716 */       localObject1 = ((StructDescriptor)localObject2).getOracleTypeADT();
/*       */ 
/*  4718 */       break;
/*       */     case 2003:
/*  4723 */       localObject2 = ArrayDescriptor.createDescriptor(paramString, this.connection);
/*       */ 
/*  4726 */       localObject1 = ((ArrayDescriptor)localObject2).getOracleTypeCOLLECTION();
/*       */ 
/*  4728 */       break;
/*       */     case 2007:
/*       */     case 2009:
/*  4734 */       localObject2 = OpaqueDescriptor.createDescriptor(paramString, this.connection);
/*       */ 
/*  4737 */       localObject1 = (OracleTypeADT)((OpaqueDescriptor)localObject2).getPickler();
/*       */ 
/*  4739 */       break;
/*       */     case 2004:
/*       */     case 2005:
/*       */     }
/*  4743 */     this.currentRowBinders[paramInt1] = localBinder;
/*       */ 
/*  4745 */     if (this.parameterDatum == null) {
/*  4746 */       this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  4751 */     this.parameterDatum[this.currentRank][paramInt1] = null;
/*       */ 
/*  4753 */     if (localObject1 != null) {
/*  4754 */       ((OracleTypeADT)localObject1).getTOID();
/*       */     }
/*  4756 */     if (this.parameterOtype == null) {
/*  4757 */       this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  4760 */     this.parameterOtype[this.currentRank][paramInt1] = localObject1;
/*       */ 
/*  4762 */     this.currentRowByteLens[paramInt1] = localBinder.bytelen;
/*  4763 */     this.currentRowCharLens[paramInt1] = 0;
/*       */   }
/*       */ 
/*       */   public void setNullAtName(String paramString1, int paramInt, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  4786 */     if (paramString1 == null)
/*       */     {
/*  4788 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4789 */       ((SQLException)localObject).fillInStackTrace();
/*  4790 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4795 */     Object localObject = paramString1.intern();
/*  4796 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*  4797 */     int i = 0;
/*  4798 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/*  4800 */     for (int k = 0; k < j; k++) {
/*  4801 */       if (arrayOfString[k] == localObject) {
/*  4802 */         setNullInternal(k + 1, paramInt, paramString2);
/*       */ 
/*  4804 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/*  4808 */     if (i == 0)
/*       */     {
/*  4810 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/*  4811 */       localSQLException.fillInStackTrace();
/*  4812 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNull(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  4832 */     synchronized (this.connection)
/*       */     {
/*  4840 */       setNullCritical(paramInt1, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setNullCritical(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  4848 */     int i = paramInt1 - 1;
/*       */ 
/*  4850 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/*  4852 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  4853 */       ((SQLException)localObject).fillInStackTrace();
/*  4854 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4857 */     Object localObject = null;
/*  4858 */     int j = getInternalType(paramInt2);
/*  4859 */     int k = 1;
/*       */     SQLException localSQLException;
/*  4861 */     switch (j)
/*       */     {
/*       */     case 6:
/*  4865 */       localObject = this.theVarnumNullBinder;
/*  4866 */       break;
/*       */     case 1:
/*       */     case 8:
/*       */     case 96:
/*       */     case 995:
/*  4875 */       localObject = this.theVarcharNullBinder;
/*  4876 */       k = 0;
/*       */ 
/*  4878 */       break;
/*       */     case 999:
/*  4881 */       localObject = this.theFixedCHARNullBinder;
/*  4882 */       k = 0;
/*       */ 
/*  4884 */       break;
/*       */     case 12:
/*  4887 */       localObject = this.theDateNullBinder;
/*       */ 
/*  4889 */       break;
/*       */     case 180:
/*  4893 */       localObject = this.theTimestampNullBinder;
/*       */ 
/*  4895 */       break;
/*       */     case 181:
/*  4898 */       localObject = this.theTSTZNullBinder;
/*       */ 
/*  4900 */       break;
/*       */     case 231:
/*  4903 */       localObject = this.theTSLTZNullBinder;
/*       */ 
/*  4905 */       break;
/*       */     case 104:
/*  4908 */       localObject = getRowidNullBinder(i);
/*       */ 
/*  4910 */       break;
/*       */     case 183:
/*  4913 */       localObject = this.theIntervalDSNullBinder;
/*       */ 
/*  4915 */       break;
/*       */     case 182:
/*  4918 */       localObject = this.theIntervalYMNullBinder;
/*       */ 
/*  4920 */       break;
/*       */     case 23:
/*       */     case 24:
/*  4925 */       localObject = this.theRawNullBinder;
/*       */ 
/*  4927 */       break;
/*       */     case 100:
/*  4930 */       localObject = this.theBinaryFloatNullBinder;
/*       */ 
/*  4932 */       break;
/*       */     case 101:
/*  4935 */       localObject = this.theBinaryDoubleNullBinder;
/*       */ 
/*  4937 */       break;
/*       */     case 113:
/*  4940 */       localObject = this.theBlobNullBinder;
/*       */ 
/*  4942 */       break;
/*       */     case 112:
/*  4945 */       localObject = this.theClobNullBinder;
/*       */ 
/*  4947 */       break;
/*       */     case 114:
/*  4950 */       localObject = this.theBfileNullBinder;
/*       */ 
/*  4952 */       break;
/*       */     case 109:
/*       */     case 111:
/*  4958 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, new StringBuilder().append("sqlType=").append(paramInt2).toString());
/*  4959 */       localSQLException.fillInStackTrace();
/*  4960 */       throw localSQLException;
/*       */     case 102:
/*       */     case 998:
/*       */     default:
/*  4971 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, new StringBuilder().append("sqlType=").append(paramInt2).toString());
/*  4972 */       localSQLException.fillInStackTrace();
/*  4973 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4977 */     this.currentRowBinders[i] = localObject;
/*  4978 */     if (k != 0)
/*       */     {
/*  4980 */       this.currentRowByteLens[i] = ((Binder)localObject).bytelen;
/*  4981 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */     else
/*       */     {
/*  4985 */       this.currentRowByteLens[i] = 0;
/*  4986 */       this.currentRowCharLens[i] = 1;
/*       */     }
/*       */   }
/*       */ 
/*       */   Binder getRowidNullBinder(int paramInt)
/*       */   {
/*  4994 */     return this.theRowidNullBinder;
/*       */   }
/*       */ 
/*       */   public void setNullAtName(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5014 */     if (paramString == null)
/*       */     {
/*  5016 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  5017 */       ((SQLException)localObject).fillInStackTrace();
/*  5018 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5023 */     Object localObject = paramString.intern();
/*  5024 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*  5025 */     int i = 0;
/*  5026 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/*  5028 */     for (int k = 0; k < j; k++) {
/*  5029 */       if (arrayOfString[k] == localObject) {
/*  5030 */         setNull(k + 1, paramInt);
/*       */ 
/*  5032 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/*  5036 */     if (i == 0)
/*       */     {
/*  5038 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/*  5039 */       localSQLException.fillInStackTrace();
/*  5040 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBoolean(int paramInt, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  5057 */     synchronized (this.connection)
/*       */     {
/*  5065 */       setBooleanInternal(paramInt, paramBoolean);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBooleanInternal(int paramInt, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  5073 */     int i = paramInt - 1;
/*       */ 
/*  5075 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5077 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5078 */       localSQLException.fillInStackTrace();
/*  5079 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5083 */     this.currentRowBinders[i] = this.theBooleanBinder;
/*  5084 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5085 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5087 */     if (this.parameterInt == null) {
/*  5088 */       this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5092 */     this.parameterInt[this.currentRank][i] = (paramBoolean ? 1 : 0);
/*       */   }
/*       */ 
/*       */   public void setByte(int paramInt, byte paramByte)
/*       */     throws SQLException
/*       */   {
/*  5105 */     synchronized (this.connection)
/*       */     {
/*  5113 */       setByteInternal(paramInt, paramByte);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setByteInternal(int paramInt, byte paramByte)
/*       */     throws SQLException
/*       */   {
/*  5121 */     int i = paramInt - 1;
/*       */ 
/*  5123 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5125 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5126 */       localSQLException.fillInStackTrace();
/*  5127 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5130 */     this.currentRowBinders[i] = this.theByteBinder;
/*  5131 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5132 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5135 */     if (this.parameterInt == null) {
/*  5136 */       this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5140 */     this.parameterInt[this.currentRank][i] = paramByte;
/*       */   }
/*       */ 
/*       */   public void setShort(int paramInt, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  5154 */     synchronized (this.connection)
/*       */     {
/*  5162 */       setShortInternal(paramInt, paramShort);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setShortInternal(int paramInt, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  5170 */     int i = paramInt - 1;
/*       */ 
/*  5172 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5174 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5175 */       localSQLException.fillInStackTrace();
/*  5176 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5179 */     this.currentRowBinders[i] = this.theShortBinder;
/*  5180 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5181 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5183 */     if (this.parameterInt == null) {
/*  5184 */       this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5188 */     this.parameterInt[this.currentRank][i] = paramShort;
/*       */   }
/*       */ 
/*       */   public void setInt(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  5202 */     synchronized (this.connection)
/*       */     {
/*  5210 */       setIntInternal(paramInt1, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setIntInternal(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  5218 */     int i = paramInt1 - 1;
/*       */ 
/*  5220 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/*  5222 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5223 */       localSQLException.fillInStackTrace();
/*  5224 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5227 */     this.currentRowBinders[i] = this.theIntBinder;
/*  5228 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5229 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5231 */     if (this.parameterInt == null) {
/*  5232 */       this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5236 */     this.parameterInt[this.currentRank][i] = paramInt2;
/*       */   }
/*       */ 
/*       */   public void setLong(int paramInt, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  5249 */     synchronized (this.connection)
/*       */     {
/*  5257 */       setLongInternal(paramInt, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setLongInternal(int paramInt, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  5265 */     int i = paramInt - 1;
/*       */ 
/*  5267 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5269 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5270 */       localSQLException.fillInStackTrace();
/*  5271 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5274 */     this.currentRowBinders[i] = this.theLongBinder;
/*  5275 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5276 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5278 */     if (this.parameterLong == null) {
/*  5279 */       this.parameterLong = new long[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5284 */     this.parameterLong[this.currentRank][i] = paramLong;
/*       */   }
/*       */ 
/*       */   public void setFloat(int paramInt, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  5298 */     synchronized (this.connection)
/*       */     {
/*  5306 */       setFloatInternal(paramInt, paramFloat);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setFloatInternal(int paramInt, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  5314 */     int i = paramInt - 1;
/*       */ 
/*  5316 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5318 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5319 */       localSQLException.fillInStackTrace();
/*  5320 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5329 */     if (!this.connection.setFloatAndDoubleUseBinary)
/*       */     {
/*  5331 */       if (Float.isNaN(paramFloat)) {
/*  5332 */         throw new IllegalArgumentException("NaN");
/*       */       }
/*       */     }
/*       */ 
/*  5336 */     if (this.theFloatBinder == null) {
/*  5337 */       this.theFloatBinder = theStaticFloatBinder;
/*  5338 */       if (this.connection.setFloatAndDoubleUseBinary) {
/*  5339 */         this.theFloatBinder = theStaticBinaryFloatBinder;
/*       */       }
/*       */     }
/*       */ 
/*  5343 */     this.currentRowBinders[i] = this.theFloatBinder;
/*  5344 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5345 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5347 */     if (this.theFloatBinder == theStaticFloatBinder) {
/*  5348 */       if (this.parameterDouble == null) {
/*  5349 */         this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  5352 */       this.parameterDouble[this.currentRank][i] = paramFloat;
/*       */     }
/*       */     else {
/*  5355 */       if (this.parameterFloat == null) {
/*  5356 */         this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  5359 */       this.parameterFloat[this.currentRank][i] = paramFloat;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryFloat(int paramInt, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  5375 */     synchronized (this.connection)
/*       */     {
/*  5383 */       setBinaryFloatInternal(paramInt, paramFloat);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBinaryFloatInternal(int paramInt, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  5391 */     int i = paramInt - 1;
/*       */ 
/*  5393 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5395 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5396 */       localSQLException.fillInStackTrace();
/*  5397 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5400 */     this.currentRowBinders[i] = this.theBinaryFloatBinder;
/*  5401 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5402 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5404 */     if (this.parameterFloat == null) {
/*  5405 */       this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5410 */     this.parameterFloat[this.currentRank][i] = paramFloat;
/*       */   }
/*       */ 
/*       */   public void setBinaryFloat(int paramInt, BINARY_FLOAT paramBINARY_FLOAT)
/*       */     throws SQLException
/*       */   {
/*  5417 */     synchronized (this.connection)
/*       */     {
/*  5425 */       setBinaryFloatInternal(paramInt, paramBINARY_FLOAT);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBinaryFloatInternal(int paramInt, BINARY_FLOAT paramBINARY_FLOAT)
/*       */     throws SQLException
/*       */   {
/*  5434 */     int i = paramInt - 1;
/*       */ 
/*  5436 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5438 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5439 */       localSQLException.fillInStackTrace();
/*  5440 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5443 */     if (paramBINARY_FLOAT == null)
/*       */     {
/*  5445 */       this.currentRowBinders[i] = this.theBINARY_FLOATNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  5449 */       this.currentRowBinders[i] = this.theBINARY_FLOATBinder;
/*       */ 
/*  5451 */       if (this.parameterDatum == null)
/*       */       {
/*  5453 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  5458 */       this.parameterDatum[this.currentRank][i] = paramBINARY_FLOAT.getBytes();
/*       */     }
/*       */ 
/*  5461 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5462 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setBinaryDouble(int paramInt, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  5477 */     synchronized (this.connection)
/*       */     {
/*  5485 */       setBinaryDoubleInternal(paramInt, paramDouble);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBinaryDoubleInternal(int paramInt, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  5493 */     int i = paramInt - 1;
/*       */ 
/*  5495 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5497 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5498 */       localSQLException.fillInStackTrace();
/*  5499 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5502 */     this.currentRowBinders[i] = this.theBinaryDoubleBinder;
/*       */ 
/*  5504 */     if (this.parameterDouble == null) {
/*  5505 */       this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5508 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5509 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5513 */     this.parameterDouble[this.currentRank][i] = paramDouble;
/*       */   }
/*       */ 
/*       */   public void setBinaryDouble(int paramInt, BINARY_DOUBLE paramBINARY_DOUBLE)
/*       */     throws SQLException
/*       */   {
/*  5529 */     synchronized (this.connection)
/*       */     {
/*  5537 */       setBinaryDoubleInternal(paramInt, paramBINARY_DOUBLE);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBinaryDoubleInternal(int paramInt, BINARY_DOUBLE paramBINARY_DOUBLE)
/*       */     throws SQLException
/*       */   {
/*  5546 */     int i = paramInt - 1;
/*       */ 
/*  5548 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5550 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5551 */       localSQLException.fillInStackTrace();
/*  5552 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5555 */     if (paramBINARY_DOUBLE == null)
/*       */     {
/*  5557 */       this.currentRowBinders[i] = this.theBINARY_DOUBLENullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  5561 */       this.currentRowBinders[i] = this.theBINARY_DOUBLEBinder;
/*       */ 
/*  5563 */       if (this.parameterDatum == null)
/*       */       {
/*  5565 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  5570 */       this.parameterDatum[this.currentRank][i] = paramBINARY_DOUBLE.getBytes();
/*       */     }
/*       */ 
/*  5573 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5574 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setDouble(int paramInt, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  5588 */     synchronized (this.connection)
/*       */     {
/*  5596 */       setDoubleInternal(paramInt, paramDouble);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setDoubleInternal(int paramInt, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  5604 */     int i = paramInt - 1;
/*       */ 
/*  5606 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5608 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5609 */       localSQLException.fillInStackTrace();
/*  5610 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5619 */     if (!this.connection.setFloatAndDoubleUseBinary) {
/*  5620 */       if (Double.isNaN(paramDouble)) {
/*  5621 */         throw new IllegalArgumentException("NaN");
/*       */       }
/*       */ 
/*  5624 */       double d = Math.abs(paramDouble);
/*  5625 */       if ((d != 0.0D) && (d < 1.E-130D)) {
/*  5626 */         throw new IllegalArgumentException("Underflow");
/*       */       }
/*  5628 */       if (d >= 9.999999999999999E+125D) {
/*  5629 */         throw new IllegalArgumentException("Overflow");
/*       */       }
/*       */     }
/*       */ 
/*  5633 */     if (this.theDoubleBinder == null) {
/*  5634 */       this.theDoubleBinder = theStaticDoubleBinder;
/*  5635 */       if (this.connection.setFloatAndDoubleUseBinary) {
/*  5636 */         this.theDoubleBinder = theStaticBinaryDoubleBinder;
/*       */       }
/*       */     }
/*       */ 
/*  5640 */     this.currentRowBinders[i] = this.theDoubleBinder;
/*  5641 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5642 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  5644 */     if (this.parameterDouble == null) {
/*  5645 */       this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  5649 */     this.parameterDouble[this.currentRank][i] = paramDouble;
/*       */   }
/*       */ 
/*       */   public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*       */     throws SQLException
/*       */   {
/*  5663 */     synchronized (this.connection)
/*       */     {
/*  5671 */       setBigDecimalInternal(paramInt, paramBigDecimal);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBigDecimalInternal(int paramInt, BigDecimal paramBigDecimal)
/*       */     throws SQLException
/*       */   {
/*  5679 */     int i = paramInt - 1;
/*       */ 
/*  5681 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5683 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5684 */       localSQLException.fillInStackTrace();
/*  5685 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5689 */     if (paramBigDecimal == null) {
/*  5690 */       this.currentRowBinders[i] = this.theVarnumNullBinder;
/*       */     }
/*       */     else {
/*  5693 */       this.currentRowBinders[i] = this.theBigDecimalBinder;
/*       */ 
/*  5695 */       if (this.parameterBigDecimal == null) {
/*  5696 */         this.parameterBigDecimal = new BigDecimal[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  5700 */       this.parameterBigDecimal[this.currentRank][i] = paramBigDecimal;
/*       */     }
/*       */ 
/*  5703 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  5704 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setString(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  5729 */     setStringInternal(paramInt, paramString);
/*       */   }
/*       */ 
/*       */   void setStringInternal(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  5737 */     int i = paramInt - 1;
/*  5738 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  5740 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5741 */       localSQLException.fillInStackTrace();
/*  5742 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5746 */     int j = paramString != null ? paramString.length() : 0;
/*       */ 
/*  5748 */     if (j == 0) {
/*  5749 */       setNull(paramInt, 12);
/*       */     }
/*       */     else
/*       */     {
/*       */       int k;
/*  5752 */       if (this.currentRowFormOfUse[(paramInt - 1)] == 1) {
/*  5753 */         if (this.sqlKind.isPlsqlOrCall()) {
/*  5754 */           if ((j > this.maxVcsBytesPlsql) || ((j > this.maxVcsCharsPlsql) && (this.isServerCharSetFixedWidth)))
/*       */           {
/*  5757 */             setStringForClobCritical(paramInt, paramString);
/*       */           }
/*  5759 */           else if (j > this.maxVcsCharsPlsql)
/*       */           {
/*  5761 */             k = this.connection.conversion.encodedByteLength(paramString, false);
/*       */ 
/*  5763 */             if (k > this.maxVcsBytesPlsql) {
/*  5764 */               setStringForClobCritical(paramInt, paramString);
/*       */             }
/*       */             else
/*  5767 */               basicBindString(paramInt, paramString);
/*       */           }
/*       */           else
/*       */           {
/*  5771 */             basicBindString(paramInt, paramString);
/*       */           }
/*       */ 
/*       */         }
/*  5775 */         else if (j <= this.maxVcsCharsSql) {
/*  5776 */           basicBindString(paramInt, paramString);
/*       */         }
/*  5778 */         else if (j <= this.maxStreamCharsSql)
/*       */         {
/*  5780 */           basicBindCharacterStream(paramInt, new StringReader(paramString), j, true);
/*       */         }
/*       */         else
/*       */         {
/*  5784 */           setStringForClobCritical(paramInt, paramString);
/*       */         }
/*       */ 
/*       */       }
/*  5789 */       else if (this.sqlKind.isPlsqlOrCall()) {
/*  5790 */         if ((j > this.maxVcsBytesPlsql) || ((j > this.maxVcsNCharsPlsql) && (this.isServerNCharSetFixedWidth)))
/*       */         {
/*  5793 */           setStringForClobCritical(paramInt, paramString);
/*       */         }
/*  5795 */         else if (j > this.maxVcsNCharsPlsql)
/*       */         {
/*  5797 */           k = this.connection.conversion.encodedByteLength(paramString, true);
/*       */ 
/*  5799 */           if (k > this.maxVcsBytesPlsql) {
/*  5800 */             setStringForClobCritical(paramInt, paramString);
/*       */           }
/*       */           else
/*  5803 */             basicBindString(paramInt, paramString);
/*       */         }
/*       */         else
/*       */         {
/*  5807 */           basicBindString(paramInt, paramString);
/*       */         }
/*       */ 
/*       */       }
/*  5811 */       else if (j <= this.maxVcsCharsSql) {
/*  5812 */         basicBindString(paramInt, paramString);
/*       */       }
/*       */       else
/*  5815 */         setStringForClobCritical(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   void basicBindNullString(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5825 */     synchronized (this.connection)
/*       */     {
/*  5827 */       int i = paramInt - 1;
/*  5828 */       this.currentRowBinders[i] = this.theVarcharNullBinder;
/*       */ 
/*  5830 */       if (this.sqlKind.isPlsqlOrCall())
/*  5831 */         this.currentRowCharLens[i] = this.minVcsBindSize;
/*       */       else
/*  5833 */         this.currentRowCharLens[i] = 1;
/*  5834 */       this.currentRowByteLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void basicBindString(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  5842 */     synchronized (this.connection)
/*       */     {
/*  5844 */       int i = paramInt - 1;
/*  5845 */       this.currentRowBinders[i] = this.theStringBinder;
/*  5846 */       int j = paramString.length();
/*       */ 
/*  5848 */       if (this.sqlKind.isPlsqlOrCall())
/*       */       {
/*  5850 */         int k = this.connection.minVcsBindSize;
/*  5851 */         int m = j + 1;
/*       */ 
/*  5853 */         this.currentRowCharLens[i] = (m < k ? k : m);
/*       */       }
/*       */       else {
/*  5856 */         this.currentRowCharLens[i] = (j + 1);
/*       */       }
/*  5858 */       if (this.parameterString == null) {
/*  5859 */         this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  5862 */       this.parameterString[this.currentRank][i] = paramString;
/*  5863 */       this.currentRowByteLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setStringForClob(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  5886 */     if (paramString == null)
/*       */     {
/*  5888 */       setNull(paramInt, 1);
/*  5889 */       return;
/*       */     }
/*  5891 */     int i = paramString.length();
/*  5892 */     if (i == 0)
/*       */     {
/*  5894 */       setNull(paramInt, 1);
/*  5895 */       return;
/*       */     }
/*       */ 
/*  5898 */     if (this.sqlKind.isPlsqlOrCall())
/*       */     {
/*  5900 */       if (i <= this.maxVcsCharsPlsql)
/*       */       {
/*  5902 */         setStringInternal(paramInt, paramString);
/*       */       }
/*       */       else
/*       */       {
/*  5906 */         setStringForClobCritical(paramInt, paramString);
/*       */       }
/*       */ 
/*       */     }
/*  5911 */     else if (i <= this.maxVcsCharsSql)
/*       */     {
/*  5913 */       setStringInternal(paramInt, paramString);
/*       */     }
/*       */     else
/*       */     {
/*  5917 */       setStringForClobCritical(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setStringForClobCritical(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  5926 */     synchronized (this.connection) {
/*  5927 */       CLOB localCLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[(paramInt - 1)]);
/*       */ 
/*  5930 */       localCLOB.setString(1L, paramString);
/*  5931 */       addToTempLobsToFree(localCLOB);
/*  5932 */       this.lastBoundClobs[(paramInt - 1)] = localCLOB;
/*  5933 */       setCLOBInternal(paramInt, localCLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setReaderContentsForClobCritical(int paramInt, Reader paramReader, long paramLong, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  5943 */     synchronized (this.connection)
/*       */     {
/*       */       try
/*       */       {
/*  5947 */         if ((paramReader = isReaderEmpty(paramReader)) == null)
/*       */         {
/*  5949 */           if (paramBoolean)
/*       */           {
/*  5951 */             throw new IOException(new StringBuilder().append(paramLong).append(" char of CLOB data cannot be read").toString());
/*       */           }
/*  5953 */           setCLOBInternal(paramInt, null);
/*  5954 */           return;
/*       */         }
/*       */ 
/*       */       }
/*       */       catch (IOException localIOException1)
/*       */       {
/*  5960 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/*  5961 */         ((SQLException)localObject1).fillInStackTrace();
/*  5962 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  5966 */       CLOB localCLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[(paramInt - 1)]);
/*       */ 
/*  5969 */       Object localObject1 = (OracleClobWriter)localCLOB.setCharacterStream(1L);
/*  5970 */       int i = localCLOB.getBufferSize();
/*  5971 */       char[] arrayOfChar = new char[i];
/*  5972 */       long l = 0L;
/*  5973 */       int j = 0;
/*       */ 
/*  5976 */       l = paramBoolean ? paramLong : 9223372036854775807L;
/*       */       try
/*       */       {
/*  5980 */         while (l > 0L)
/*       */         {
/*  5982 */           if (l >= i)
/*  5983 */             j = paramReader.read(arrayOfChar);
/*       */           else {
/*  5985 */             j = paramReader.read(arrayOfChar, 0, (int)l);
/*       */           }
/*  5987 */           if (j == -1)
/*       */           {
/*  5989 */             if (!paramBoolean)
/*       */               break;
/*  5991 */             throw new IOException(new StringBuilder().append(l).append(" char of CLOB data cannot be read").toString());
/*       */           }
/*       */ 
/*  5997 */           ((OracleClobWriter)localObject1).write(arrayOfChar, 0, j);
/*       */ 
/*  5999 */           l -= j;
/*       */         }
/*  6001 */         ((OracleClobWriter)localObject1).flush();
/*       */       }
/*       */       catch (IOException localIOException2)
/*       */       {
/*  6006 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/*  6007 */         localSQLException.fillInStackTrace();
/*  6008 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6012 */       addToTempLobsToFree(localCLOB);
/*  6013 */       this.lastBoundClobs[(paramInt - 1)] = localCLOB;
/*  6014 */       setCLOBInternal(paramInt, localCLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setAsciiStreamContentsForClobCritical(int paramInt, InputStream paramInputStream, long paramLong, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  6024 */     synchronized (this.connection)
/*       */     {
/*       */       try
/*       */       {
/*  6028 */         if ((paramInputStream = isInputStreamEmpty(paramInputStream)) == null)
/*       */         {
/*  6030 */           if (paramBoolean)
/*       */           {
/*  6032 */             throw new IOException(new StringBuilder().append(paramLong).append(" byte of CLOB data cannot be read").toString());
/*       */           }
/*  6034 */           setCLOBInternal(paramInt, null);
/*  6035 */           return;
/*       */         }
/*       */ 
/*       */       }
/*       */       catch (IOException localIOException1)
/*       */       {
/*  6041 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/*  6042 */         ((SQLException)localObject1).fillInStackTrace();
/*  6043 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  6046 */       CLOB localCLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[(paramInt - 1)]);
/*       */ 
/*  6049 */       Object localObject1 = (OracleClobWriter)localCLOB.setCharacterStream(1L);
/*  6050 */       int i = localCLOB.getBufferSize();
/*  6051 */       byte[] arrayOfByte = new byte[i];
/*  6052 */       char[] arrayOfChar = new char[i];
/*  6053 */       int j = 0;
/*       */ 
/*  6055 */       long l = paramBoolean ? paramLong : 9223372036854775807L;
/*       */       try
/*       */       {
/*  6059 */         while (l > 0L)
/*       */         {
/*  6061 */           if (l >= i)
/*  6062 */             j = paramInputStream.read(arrayOfByte);
/*       */           else {
/*  6064 */             j = paramInputStream.read(arrayOfByte, 0, (int)l);
/*       */           }
/*  6066 */           if (j == -1)
/*       */           {
/*  6068 */             if (!paramBoolean)
/*       */               break;
/*  6070 */             throw new IOException(new StringBuilder().append(l).append(" byte of CLOB data cannot be read").toString());
/*       */           }
/*       */ 
/*  6077 */           DBConversion.asciiBytesToJavaChars(arrayOfByte, j, arrayOfChar);
/*  6078 */           ((OracleClobWriter)localObject1).write(arrayOfChar, 0, j);
/*       */ 
/*  6080 */           l -= j;
/*       */         }
/*  6082 */         ((OracleClobWriter)localObject1).flush();
/*       */       }
/*       */       catch (IOException localIOException2)
/*       */       {
/*  6087 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/*  6088 */         localSQLException.fillInStackTrace();
/*  6089 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6092 */       addToTempLobsToFree(localCLOB);
/*  6093 */       this.lastBoundClobs[(paramInt - 1)] = localCLOB;
/*  6094 */       setCLOBInternal(paramInt, localCLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setStringForClobAtName(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  6116 */     if (paramString1 == null)
/*       */     {
/*  6118 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6119 */       ((SQLException)localObject).fillInStackTrace();
/*  6120 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  6125 */     Object localObject = paramString1.intern();
/*  6126 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*  6127 */     int i = 0;
/*  6128 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/*  6130 */     for (int k = 0; k < j; k++) {
/*  6131 */       if (arrayOfString[k] == localObject) {
/*  6132 */         setStringForClob(k + 1, paramString2);
/*       */ 
/*  6134 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/*  6138 */     if (i == 0)
/*       */     {
/*  6140 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/*  6141 */       localSQLException.fillInStackTrace();
/*  6142 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setFixedCHAR(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  6161 */     synchronized (this.connection)
/*       */     {
/*  6169 */       setFixedCHARInternal(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setFixedCHARInternal(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  6177 */     int i = paramInt - 1;
/*       */ 
/*  6179 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6181 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6182 */       localSQLException1.fillInStackTrace();
/*  6183 */       throw localSQLException1;
/*       */     }
/*       */ 
/*  6186 */     int j = 0;
/*       */ 
/*  6188 */     if (paramString != null) {
/*  6189 */       j = paramString.length();
/*       */     }
/*       */ 
/*  6194 */     if (j > 32766)
/*       */     {
/*  6196 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 157);
/*  6197 */       localSQLException2.fillInStackTrace();
/*  6198 */       throw localSQLException2;
/*       */     }
/*       */ 
/*  6201 */     if (paramString == null)
/*       */     {
/*  6203 */       this.currentRowBinders[i] = this.theFixedCHARNullBinder;
/*  6204 */       this.currentRowCharLens[i] = 1;
/*       */     }
/*       */     else
/*       */     {
/*  6208 */       this.currentRowBinders[i] = this.theFixedCHARBinder;
/*  6209 */       this.currentRowCharLens[i] = (j + 1);
/*       */ 
/*  6211 */       if (this.parameterString == null) {
/*  6212 */         this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  6215 */       this.parameterString[this.currentRank][i] = paramString;
/*       */     }
/*  6217 */     this.currentRowByteLens[i] = 0;
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void setCursor(int paramInt, ResultSet paramResultSet)
/*       */     throws SQLException
/*       */   {
/*  6236 */     synchronized (this.connection)
/*       */     {
/*  6243 */       setCursorInternal(paramInt, paramResultSet);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setCursorInternal(int paramInt, ResultSet paramResultSet)
/*       */     throws SQLException
/*       */   {
/*  6252 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  6253 */     localSQLException.fillInStackTrace();
/*  6254 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setROWID(int paramInt, ROWID paramROWID)
/*       */     throws SQLException
/*       */   {
/*  6272 */     synchronized (this.connection)
/*       */     {
/*  6280 */       setROWIDInternal(paramInt, paramROWID);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setROWIDInternal(int paramInt, ROWID paramROWID)
/*       */     throws SQLException
/*       */   {
/*  6289 */     if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*       */     {
/*  6291 */       if (paramROWID == null)
/*       */       {
/*  6293 */         setNull(paramInt, 12);
/*       */       }
/*       */       else {
/*  6296 */         setStringInternal(paramInt, paramROWID.stringValue());
/*       */       }
/*       */ 
/*  6299 */       return;
/*       */     }
/*       */ 
/*  6302 */     int i = paramInt - 1;
/*       */     Object localObject;
/*  6304 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6306 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6307 */       ((SQLException)localObject).fillInStackTrace();
/*  6308 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  6311 */     if ((paramROWID == null) || (paramROWID.shareBytes() == null))
/*       */     {
/*  6313 */       this.currentRowBinders[i] = this.theRowidNullBinder;
/*  6314 */       this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*       */     }
/*       */     else
/*       */     {
/*  6318 */       this.currentRowBinders[i] = (T4CRowidAccessor.isUROWID(paramROWID.shareBytes(), 0) ? this.theURowidBinder : this.theRowidBinder);
/*       */ 
/*  6320 */       if (this.parameterDatum == null)
/*       */       {
/*  6322 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  6327 */       localObject = paramROWID.getBytes();
/*  6328 */       this.parameterDatum[this.currentRank][i] = localObject;
/*       */ 
/*  6330 */       this.currentRowByteLens[i] = (localObject.length + 2);
/*       */     }
/*  6332 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setArray(int paramInt, Array paramArray)
/*       */     throws SQLException
/*       */   {
/*  6355 */     setARRAYInternal(paramInt, (ARRAY)paramArray);
/*       */   }
/*       */ 
/*       */   void setArrayInternal(int paramInt, Array paramArray)
/*       */     throws SQLException
/*       */   {
/*  6362 */     setARRAYInternal(paramInt, (ARRAY)paramArray);
/*       */   }
/*       */ 
/*       */   public void setARRAY(int paramInt, ARRAY paramARRAY)
/*       */     throws SQLException
/*       */   {
/*  6385 */     setARRAYInternal(paramInt, paramARRAY);
/*       */   }
/*       */ 
/*       */   void setARRAYInternal(int paramInt, ARRAY paramARRAY)
/*       */     throws SQLException
/*       */   {
/*  6392 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/*  6394 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6396 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6397 */       localSQLException.fillInStackTrace();
/*  6398 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6401 */     if (paramARRAY == null)
/*       */     {
/*  6404 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6405 */       localSQLException.fillInStackTrace();
/*  6406 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6411 */     synchronized (this.connection) {
/*  6412 */       setArrayCritical(i, paramARRAY);
/*       */ 
/*  6414 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setArrayCritical(int paramInt, ARRAY paramARRAY)
/*       */     throws SQLException
/*       */   {
/*  6431 */     ArrayDescriptor localArrayDescriptor = paramARRAY.getDescriptor();
/*       */ 
/*  6433 */     if (localArrayDescriptor == null)
/*       */     {
/*  6437 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 61);
/*  6438 */       ((SQLException)localObject).fillInStackTrace();
/*  6439 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  6444 */     this.currentRowBinders[paramInt] = this.theNamedTypeBinder;
/*  6445 */     this.currentRowByteLens[paramInt] = this.currentRowBinders[paramInt].bytelen;
/*  6446 */     this.currentRowCharLens[paramInt] = 0;
/*       */ 
/*  6448 */     if (this.parameterDatum == null)
/*       */     {
/*  6450 */       this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6455 */     this.parameterDatum[this.currentRank][paramInt] = paramARRAY.toBytes();
/*       */ 
/*  6457 */     Object localObject = localArrayDescriptor.getOracleTypeCOLLECTION();
/*       */ 
/*  6459 */     ((OracleTypeADT)localObject).getTOID();
/*       */ 
/*  6461 */     if (this.parameterOtype == null)
/*       */     {
/*  6463 */       this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6467 */     this.parameterOtype[this.currentRank][paramInt] = localObject;
/*       */   }
/*       */ 
/*       */   public void setOPAQUE(int paramInt, OPAQUE paramOPAQUE)
/*       */     throws SQLException
/*       */   {
/*  6490 */     setOPAQUEInternal(paramInt, paramOPAQUE);
/*       */   }
/*       */ 
/*       */   void setOPAQUEInternal(int paramInt, OPAQUE paramOPAQUE)
/*       */     throws SQLException
/*       */   {
/*  6497 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/*  6499 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6501 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6502 */       localSQLException.fillInStackTrace();
/*  6503 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6506 */     if (paramOPAQUE == null)
/*       */     {
/*  6509 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6510 */       localSQLException.fillInStackTrace();
/*  6511 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6516 */     synchronized (this.connection) {
/*  6517 */       setOPAQUECritical(i, paramOPAQUE);
/*       */ 
/*  6519 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setOPAQUECritical(int paramInt, OPAQUE paramOPAQUE)
/*       */     throws SQLException
/*       */   {
/*  6536 */     OpaqueDescriptor localOpaqueDescriptor = paramOPAQUE.getDescriptor();
/*       */ 
/*  6538 */     if (localOpaqueDescriptor == null)
/*       */     {
/*  6542 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 61);
/*  6543 */       ((SQLException)localObject).fillInStackTrace();
/*  6544 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  6549 */     this.currentRowBinders[paramInt] = this.theNamedTypeBinder;
/*  6550 */     this.currentRowByteLens[paramInt] = this.currentRowBinders[paramInt].bytelen;
/*  6551 */     this.currentRowCharLens[paramInt] = 0;
/*       */ 
/*  6553 */     if (this.parameterDatum == null)
/*       */     {
/*  6555 */       this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6560 */     this.parameterDatum[this.currentRank][paramInt] = paramOPAQUE.toBytes();
/*       */ 
/*  6562 */     Object localObject = (OracleTypeADT)localOpaqueDescriptor.getPickler();
/*       */ 
/*  6564 */     ((OracleTypeADT)localObject).getTOID();
/*       */ 
/*  6566 */     if (this.parameterOtype == null)
/*       */     {
/*  6568 */       this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6572 */     this.parameterOtype[this.currentRank][paramInt] = localObject;
/*       */   }
/*       */ 
/*       */   void setSQLXMLInternal(int paramInt, SQLXML paramSQLXML)
/*       */     throws SQLException
/*       */   {
/*  6588 */     if (paramSQLXML == null)
/*       */     {
/*  6591 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6592 */       localSQLException.fillInStackTrace();
/*  6593 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6598 */     setOPAQUEInternal(paramInt, (OPAQUE)paramSQLXML);
/*       */   }
/*       */ 
/*       */   public void setStructDescriptor(int paramInt, StructDescriptor paramStructDescriptor)
/*       */     throws SQLException
/*       */   {
/*  6622 */     setStructDescriptorInternal(paramInt, paramStructDescriptor);
/*       */   }
/*       */ 
/*       */   void setStructDescriptorInternal(int paramInt, StructDescriptor paramStructDescriptor)
/*       */     throws SQLException
/*       */   {
/*  6630 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/*  6632 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6634 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6635 */       localSQLException.fillInStackTrace();
/*  6636 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6639 */     if (paramStructDescriptor == null)
/*       */     {
/*  6641 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6642 */       localSQLException.fillInStackTrace();
/*  6643 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6646 */     synchronized (this.connection) {
/*  6647 */       setStructDescriptorCritical(i, paramStructDescriptor);
/*       */ 
/*  6649 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setStructDescriptorCritical(int paramInt, StructDescriptor paramStructDescriptor)
/*       */     throws SQLException
/*       */   {
/*  6665 */     this.currentRowBinders[paramInt] = this.theNamedTypeBinder;
/*  6666 */     this.currentRowByteLens[paramInt] = this.currentRowBinders[paramInt].bytelen;
/*  6667 */     this.currentRowCharLens[paramInt] = 0;
/*       */ 
/*  6669 */     if (this.parameterDatum == null) {
/*  6670 */       this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6673 */     OracleTypeADT localOracleTypeADT = paramStructDescriptor.getOracleTypeADT();
/*       */ 
/*  6675 */     localOracleTypeADT.getTOID();
/*       */ 
/*  6677 */     if (this.parameterOtype == null) {
/*  6678 */       this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6682 */     this.parameterOtype[this.currentRank][paramInt] = localOracleTypeADT;
/*       */   }
/*       */ 
/*       */   public void setStructDescriptorAtName(String paramString, StructDescriptor paramStructDescriptor)
/*       */     throws SQLException
/*       */   {
/*  6705 */     if (paramString == null)
/*       */     {
/*  6707 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6708 */       ((SQLException)localObject).fillInStackTrace();
/*  6709 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  6714 */     Object localObject = paramString.intern();
/*  6715 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*  6716 */     int i = 0;
/*  6717 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/*  6719 */     for (int k = 0; k < j; k++) {
/*  6720 */       if (arrayOfString[k] == localObject) {
/*  6721 */         setStructDescriptorInternal(k + 1, paramStructDescriptor);
/*       */ 
/*  6723 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/*  6727 */     if (i == 0)
/*       */     {
/*  6729 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/*  6730 */       localSQLException.fillInStackTrace();
/*  6731 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setPreBindsCompelete()
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public void setSTRUCT(int paramInt, STRUCT paramSTRUCT)
/*       */     throws SQLException
/*       */   {
/*  6766 */     setSTRUCTInternal(paramInt, paramSTRUCT);
/*       */   }
/*       */ 
/*       */   void setSTRUCTInternal(int paramInt, STRUCT paramSTRUCT)
/*       */     throws SQLException
/*       */   {
/*  6773 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/*  6775 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6777 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6778 */       localSQLException.fillInStackTrace();
/*  6779 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6782 */     if (paramSTRUCT == null)
/*       */     {
/*  6785 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  6786 */       localSQLException.fillInStackTrace();
/*  6787 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6792 */     synchronized (this.connection) {
/*  6793 */       setSTRUCTCritical(i, paramSTRUCT);
/*       */ 
/*  6795 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setSTRUCTCritical(int paramInt, STRUCT paramSTRUCT)
/*       */     throws SQLException
/*       */   {
/*  6813 */     StructDescriptor localStructDescriptor = paramSTRUCT.getDescriptor();
/*       */ 
/*  6815 */     if (localStructDescriptor == null)
/*       */     {
/*  6819 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 61);
/*  6820 */       ((SQLException)localObject).fillInStackTrace();
/*  6821 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  6826 */     this.currentRowBinders[paramInt] = this.theNamedTypeBinder;
/*  6827 */     this.currentRowByteLens[paramInt] = this.currentRowBinders[paramInt].bytelen;
/*  6828 */     this.currentRowCharLens[paramInt] = 0;
/*       */ 
/*  6830 */     if (this.parameterDatum == null)
/*       */     {
/*  6832 */       this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6837 */     this.parameterDatum[this.currentRank][paramInt] = paramSTRUCT.toBytes();
/*       */ 
/*  6841 */     Object localObject = localStructDescriptor.getOracleTypeADT();
/*       */ 
/*  6843 */     ((OracleTypeADT)localObject).getTOID();
/*       */ 
/*  6845 */     if (this.parameterOtype == null)
/*       */     {
/*  6847 */       this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  6851 */     this.parameterOtype[this.currentRank][paramInt] = localObject;
/*       */   }
/*       */ 
/*       */   public void setRAW(int paramInt, RAW paramRAW)
/*       */     throws SQLException
/*       */   {
/*  6874 */     setRAWInternal(paramInt, paramRAW);
/*       */   }
/*       */ 
/*       */   void setRAWInternal(int paramInt, RAW paramRAW)
/*       */     throws SQLException
/*       */   {
/*  6881 */     int i = 0;
/*  6882 */     synchronized (this.connection) {
/*  6883 */       int j = paramInt - 1;
/*       */ 
/*  6885 */       if ((j < 0) || (paramInt > this.numberOfBindPositions))
/*       */       {
/*  6887 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6888 */         localSQLException.fillInStackTrace();
/*  6889 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6892 */       if (paramRAW == null)
/*       */       {
/*  6894 */         this.currentRowBinders[j] = this.theRawNullBinder;
/*  6895 */         this.currentRowByteLens[j] = this.currentRowBinders[j].bytelen;
/*  6896 */         this.currentRowCharLens[j] = 0;
/*       */       }
/*       */       else {
/*  6899 */         i = 1;
/*       */       }
/*       */     }
/*  6901 */     if (i != 0)
/*  6902 */       setBytesInternal(paramInt, paramRAW.getBytes());
/*       */   }
/*       */ 
/*       */   public void setCHAR(int paramInt, CHAR paramCHAR)
/*       */     throws SQLException
/*       */   {
/*  6918 */     synchronized (this.connection)
/*       */     {
/*  6925 */       setCHARInternal(paramInt, paramCHAR);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setCHARInternal(int paramInt, CHAR paramCHAR)
/*       */     throws SQLException
/*       */   {
/*  6933 */     int i = paramInt - 1;
/*       */ 
/*  6935 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  6937 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  6938 */       localSQLException.fillInStackTrace();
/*  6939 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6942 */     if ((paramCHAR == null) || (paramCHAR.getLength() == 0L))
/*       */     {
/*  6945 */       this.currentRowBinders[i] = this.theSetCHARNullBinder;
/*  6946 */       this.currentRowCharLens[i] = 1;
/*       */     }
/*       */     else
/*       */     {
/*  6950 */       int j = (short)paramCHAR.oracleId();
/*  6951 */       this.currentRowBinders[i] = this.theSetCHARBinder;
/*       */ 
/*  6953 */       if (this.parameterDatum == null)
/*       */       {
/*  6955 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  6959 */       CharacterSet localCharacterSet = this.currentRowFormOfUse[i] == 2 ? this.connection.setCHARNCharSetObj : this.connection.setCHARCharSetObj;
/*       */       byte[] arrayOfByte1;
/*  6966 */       if ((localCharacterSet != null) && (localCharacterSet.getOracleId() != j))
/*       */       {
/*  6968 */         byte[] arrayOfByte2 = paramCHAR.shareBytes();
/*       */ 
/*  6970 */         arrayOfByte1 = localCharacterSet.convert(paramCHAR.getCharacterSet(), arrayOfByte2, 0, arrayOfByte2.length);
/*       */       }
/*       */       else {
/*  6973 */         arrayOfByte1 = paramCHAR.getBytes();
/*       */       }
/*  6975 */       this.parameterDatum[this.currentRank][i] = arrayOfByte1;
/*       */ 
/*  6981 */       this.currentRowCharLens[i] = ((arrayOfByte1.length + 1 >> 1) + 1);
/*       */     }
/*       */ 
/*  6985 */     if (this.sqlKind.isPlsqlOrCall())
/*       */     {
/*  6989 */       if (this.currentRowCharLens[i] < this.minVcsBindSize)
/*  6990 */         this.currentRowCharLens[i] = this.minVcsBindSize;
/*       */     }
/*  6992 */     this.currentRowByteLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setDATE(int paramInt, DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/*  7013 */     synchronized (this.connection)
/*       */     {
/*  7021 */       setDATEInternal(paramInt, paramDATE);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setDATEInternal(int paramInt, DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/*  7029 */     int i = paramInt - 1;
/*       */ 
/*  7031 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7033 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7034 */       localSQLException.fillInStackTrace();
/*  7035 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7038 */     if (paramDATE == null)
/*       */     {
/*  7040 */       this.currentRowBinders[i] = this.theDateNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  7044 */       this.currentRowBinders[i] = this.theOracleDateBinder;
/*       */ 
/*  7046 */       if (this.parameterDatum == null)
/*       */       {
/*  7048 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7053 */       this.parameterDatum[this.currentRank][i] = paramDATE.getBytes();
/*       */     }
/*  7055 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7056 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setNUMBER(int paramInt, NUMBER paramNUMBER)
/*       */     throws SQLException
/*       */   {
/*  7072 */     synchronized (this.connection)
/*       */     {
/*  7080 */       setNUMBERInternal(paramInt, paramNUMBER);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setNUMBERInternal(int paramInt, NUMBER paramNUMBER)
/*       */     throws SQLException
/*       */   {
/*  7088 */     int i = paramInt - 1;
/*       */ 
/*  7090 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7092 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7093 */       localSQLException.fillInStackTrace();
/*  7094 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7097 */     if (paramNUMBER == null)
/*       */     {
/*  7099 */       this.currentRowBinders[i] = this.theVarnumNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  7103 */       this.currentRowBinders[i] = this.theOracleNumberBinder;
/*       */ 
/*  7105 */       if (this.parameterDatum == null)
/*       */       {
/*  7107 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7112 */       this.parameterDatum[this.currentRank][i] = paramNUMBER.getBytes();
/*       */     }
/*  7114 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7115 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setBLOB(int paramInt, BLOB paramBLOB)
/*       */     throws SQLException
/*       */   {
/*  7131 */     synchronized (this.connection)
/*       */     {
/*  7139 */       setBLOBInternal(paramInt, paramBLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBLOBInternal(int paramInt, BLOB paramBLOB)
/*       */     throws SQLException
/*       */   {
/*  7147 */     int i = paramInt - 1;
/*       */ 
/*  7149 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7151 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7152 */       localSQLException.fillInStackTrace();
/*  7153 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7156 */     if (paramBLOB == null) {
/*  7157 */       this.currentRowBinders[i] = this.theBlobNullBinder;
/*       */     }
/*       */     else {
/*  7160 */       this.currentRowBinders[i] = this.theBlobBinder;
/*       */ 
/*  7162 */       if (this.parameterDatum == null) {
/*  7163 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7168 */       this.parameterDatum[this.currentRank][i] = paramBLOB.getBytes();
/*       */     }
/*  7170 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7171 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setBlob(int paramInt, Blob paramBlob)
/*       */     throws SQLException
/*       */   {
/*  7186 */     synchronized (this.connection)
/*       */     {
/*  7193 */       setBLOBInternal(paramInt, (BLOB)paramBlob);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBlobInternal(int paramInt, Blob paramBlob)
/*       */     throws SQLException
/*       */   {
/*  7201 */     setBLOBInternal(paramInt, (BLOB)paramBlob);
/*       */   }
/*       */ 
/*       */   public void setCLOB(int paramInt, CLOB paramCLOB)
/*       */     throws SQLException
/*       */   {
/*  7218 */     synchronized (this.connection)
/*       */     {
/*  7226 */       setCLOBInternal(paramInt, paramCLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setCLOBInternal(int paramInt, CLOB paramCLOB)
/*       */     throws SQLException
/*       */   {
/*  7234 */     int i = paramInt - 1;
/*       */ 
/*  7236 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7238 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7239 */       localSQLException.fillInStackTrace();
/*  7240 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7243 */     if (paramCLOB == null) {
/*  7244 */       this.currentRowBinders[i] = this.theClobNullBinder;
/*       */     }
/*       */     else {
/*  7247 */       this.currentRowBinders[i] = this.theClobBinder;
/*       */ 
/*  7249 */       if (this.parameterDatum == null) {
/*  7250 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7255 */       this.parameterDatum[this.currentRank][i] = paramCLOB.getBytes();
/*       */     }
/*  7257 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7258 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setClob(int paramInt, Clob paramClob)
/*       */     throws SQLException
/*       */   {
/*  7274 */     synchronized (this.connection)
/*       */     {
/*  7281 */       setCLOBInternal(paramInt, (CLOB)paramClob);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setClobInternal(int paramInt, Clob paramClob)
/*       */     throws SQLException
/*       */   {
/*  7289 */     setCLOBInternal(paramInt, (CLOB)paramClob);
/*       */   }
/*       */ 
/*       */   public void setBFILE(int paramInt, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  7304 */     synchronized (this.connection)
/*       */     {
/*  7312 */       setBFILEInternal(paramInt, paramBFILE);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBFILEInternal(int paramInt, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  7320 */     int i = paramInt - 1;
/*       */ 
/*  7322 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7324 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7325 */       localSQLException.fillInStackTrace();
/*  7326 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7329 */     if (paramBFILE == null) {
/*  7330 */       this.currentRowBinders[i] = this.theBfileNullBinder;
/*       */     }
/*       */     else {
/*  7333 */       this.currentRowBinders[i] = this.theBfileBinder;
/*       */ 
/*  7335 */       if (this.parameterDatum == null) {
/*  7336 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7341 */       this.parameterDatum[this.currentRank][i] = paramBFILE.getBytes();
/*       */     }
/*  7343 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7344 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setBfile(int paramInt, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  7359 */     synchronized (this.connection)
/*       */     {
/*  7366 */       setBFILEInternal(paramInt, paramBFILE);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBfileInternal(int paramInt, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  7374 */     setBFILEInternal(paramInt, paramBFILE);
/*       */   }
/*       */ 
/*       */   public void setBytes(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7394 */     setBytesInternal(paramInt, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   void setBytesInternal(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7401 */     int i = paramInt - 1;
/*       */ 
/*  7403 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7405 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7406 */       localSQLException.fillInStackTrace();
/*  7407 */       throw localSQLException;
/*       */     }
/*  7409 */     int j = paramArrayOfByte != null ? paramArrayOfByte.length : 0;
/*  7410 */     if (j == 0)
/*       */     {
/*  7412 */       setNullInternal(paramInt, -2);
/*       */     }
/*  7416 */     else if (this.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK)
/*       */     {
/*  7418 */       if (j > this.maxRawBytesPlsql)
/*  7419 */         setBytesForBlobCritical(paramInt, paramArrayOfByte);
/*       */       else
/*  7421 */         basicBindBytes(paramInt, paramArrayOfByte);
/*       */     }
/*  7423 */     else if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK)
/*       */     {
/*  7425 */       if (j > this.maxRawBytesPlsql)
/*  7426 */         setBytesForBlobCritical(paramInt, paramArrayOfByte);
/*       */       else {
/*  7428 */         basicBindBytes(paramInt, paramArrayOfByte);
/*       */       }
/*       */ 
/*       */     }
/*  7432 */     else if (j > this.maxRawBytesSql)
/*       */     {
/*  7434 */       bindBytesAsStream(paramInt, paramArrayOfByte);
/*       */     }
/*       */     else
/*  7437 */       basicBindBytes(paramInt, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   void bindBytesAsStream(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7446 */     int i = paramArrayOfByte.length;
/*  7447 */     byte[] arrayOfByte = new byte[i];
/*  7448 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, i);
/*  7449 */     set_execute_batch(1);
/*  7450 */     basicBindBinaryStream(paramInt, new ByteArrayInputStream(arrayOfByte), i, true);
/*       */   }
/*       */ 
/*       */   void basicBindBytes(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7458 */     synchronized (this.connection)
/*       */     {
/*  7460 */       int i = paramInt - 1;
/*  7461 */       Binder localBinder = this.sqlKind.isPlsqlOrCall() ? this.thePlsqlRawBinder : this.theRawBinder;
/*  7462 */       this.currentRowBinders[i] = localBinder;
/*       */ 
/*  7464 */       if (this.parameterDatum == null) {
/*  7465 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7468 */       this.parameterDatum[this.currentRank][i] = paramArrayOfByte;
/*  7469 */       this.currentRowByteLens[i] = paramArrayOfByte.length;
/*  7470 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void basicBindBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7479 */     basicBindBinaryStream(paramInt1, paramInputStream, paramInt2, false);
/*       */   }
/*       */ 
/*       */   void basicBindBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  7487 */     synchronized (this.connection)
/*       */     {
/*  7489 */       int i = paramInt1 - 1;
/*       */ 
/*  7491 */       if (paramBoolean)
/*  7492 */         this.currentRowBinders[i] = this.theLongRawStreamForBytesBinder;
/*       */       else {
/*  7494 */         this.currentRowBinders[i] = this.theLongRawStreamBinder;
/*       */       }
/*  7496 */       if (this.parameterStream == null) {
/*  7497 */         this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7500 */       this.parameterStream[this.currentRank][i] = (paramBoolean ? this.connection.conversion.ConvertStreamInternal(paramInputStream, 6, paramInt2) : this.connection.conversion.ConvertStream(paramInputStream, 6, paramInt2));
/*       */ 
/*  7505 */       this.currentRowByteLens[i] = 0;
/*  7506 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBytesForBlob(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7530 */     if (paramArrayOfByte == null)
/*       */     {
/*  7532 */       setNull(paramInt, -2);
/*  7533 */       return;
/*       */     }
/*  7535 */     int i = paramArrayOfByte.length;
/*  7536 */     if (i == 0)
/*       */     {
/*  7538 */       setNull(paramInt, -2);
/*  7539 */       return;
/*       */     }
/*  7541 */     if (this.sqlKind.isPlsqlOrCall())
/*       */     {
/*  7543 */       if (i <= this.maxRawBytesPlsql)
/*       */       {
/*  7545 */         setBytes(paramInt, paramArrayOfByte);
/*       */       }
/*       */       else
/*       */       {
/*  7549 */         setBytesForBlobCritical(paramInt, paramArrayOfByte);
/*       */       }
/*       */ 
/*       */     }
/*  7554 */     else if (i <= this.maxRawBytesSql)
/*       */     {
/*  7556 */       setBytes(paramInt, paramArrayOfByte);
/*       */     }
/*       */     else
/*       */     {
/*  7565 */       setBytesForBlobCritical(paramInt, paramArrayOfByte);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBytesForBlobCritical(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7575 */     BLOB localBLOB = BLOB.createTemporary(this.connection, true, 10);
/*       */ 
/*  7577 */     localBLOB.putBytes(1L, paramArrayOfByte);
/*  7578 */     addToTempLobsToFree(localBLOB);
/*  7579 */     this.lastBoundBlobs[(paramInt - 1)] = localBLOB;
/*  7580 */     setBLOBInternal(paramInt, localBLOB);
/*       */   }
/*       */ 
/*       */   void setBinaryStreamContentsForBlobCritical(int paramInt, InputStream paramInputStream, long paramLong, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  7591 */     synchronized (this.connection)
/*       */     {
/*       */       try
/*       */       {
/*  7596 */         if ((paramInputStream = isInputStreamEmpty(paramInputStream)) == null)
/*       */         {
/*  7598 */           if (paramBoolean)
/*       */           {
/*  7600 */             throw new IOException(new StringBuilder().append(paramLong).append(" byte of BLOB data cannot be read").toString());
/*       */           }
/*  7602 */           setBLOBInternal(paramInt, null);
/*  7603 */           return;
/*       */         }
/*       */ 
/*       */       }
/*       */       catch (IOException localIOException1)
/*       */       {
/*  7609 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/*  7610 */         ((SQLException)localObject1).fillInStackTrace();
/*  7611 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  7615 */       BLOB localBLOB = BLOB.createTemporary(this.connection, true, 10);
/*       */ 
/*  7618 */       Object localObject1 = (OracleBlobOutputStream)localBLOB.setBinaryStream(1L);
/*       */ 
/*  7620 */       int i = localBLOB.getBufferSize();
/*  7621 */       byte[] arrayOfByte = new byte[i];
/*  7622 */       long l = 0L;
/*  7623 */       int j = 0;
/*       */ 
/*  7626 */       l = paramBoolean ? paramLong : 9223372036854775807L;
/*       */       try
/*       */       {
/*  7630 */         while (l > 0L)
/*       */         {
/*  7632 */           if (l >= i)
/*  7633 */             j = paramInputStream.read(arrayOfByte);
/*       */           else {
/*  7635 */             j = paramInputStream.read(arrayOfByte, 0, (int)l);
/*       */           }
/*  7637 */           if (j == -1)
/*       */           {
/*  7639 */             if (!paramBoolean)
/*       */               break;
/*  7641 */             throw new IOException(new StringBuilder().append(l).append(" byte of BLOB data cannot be read").toString());
/*       */           }
/*       */ 
/*  7647 */           ((OracleBlobOutputStream)localObject1).write(arrayOfByte, 0, j);
/*  7648 */           l -= j;
/*       */         }
/*  7650 */         ((OracleBlobOutputStream)localObject1).flush();
/*       */       }
/*       */       catch (IOException localIOException2)
/*       */       {
/*  7655 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException2);
/*  7656 */         localSQLException.fillInStackTrace();
/*  7657 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7660 */       addToTempLobsToFree(localBLOB);
/*  7661 */       this.lastBoundBlobs[(paramInt - 1)] = localBLOB;
/*  7662 */       setBLOBInternal(paramInt, localBLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBytesForBlobAtName(String paramString, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7684 */     if (paramString == null)
/*       */     {
/*  7686 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  7687 */       ((SQLException)localObject).fillInStackTrace();
/*  7688 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  7693 */     Object localObject = paramString.intern();
/*  7694 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*  7695 */     int i = 0;
/*  7696 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/*  7698 */     for (int k = 0; k < j; k++) {
/*  7699 */       if (arrayOfString[k] == localObject) {
/*  7700 */         setBytesForBlob(k + 1, paramArrayOfByte);
/*       */ 
/*  7702 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/*  7706 */     if (i == 0)
/*       */     {
/*  7708 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/*  7709 */       localSQLException.fillInStackTrace();
/*  7710 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setInternalBytes(int paramInt1, byte[] paramArrayOfByte, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7725 */     synchronized (this.connection)
/*       */     {
/*  7728 */       setInternalBytesInternal(paramInt1, paramArrayOfByte, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setInternalBytesInternal(int paramInt1, byte[] paramArrayOfByte, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7740 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  7741 */     localSQLException.fillInStackTrace();
/*  7742 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void setDate(int paramInt, Date paramDate)
/*       */     throws SQLException
/*       */   {
/*  7757 */     synchronized (this.connection)
/*       */     {
/*  7765 */       setDATEInternal(paramInt, paramDate == null ? null : new DATE(paramDate, getDefaultCalendar()));
/*       */     }
/*       */   }
/*       */ 
/*       */   void setDateInternal(int paramInt, Date paramDate)
/*       */     throws SQLException
/*       */   {
/*  7775 */     setDATEInternal(paramInt, paramDate == null ? null : new DATE(paramDate, getDefaultCalendar()));
/*       */   }
/*       */ 
/*       */   public void setTime(int paramInt, Time paramTime)
/*       */     throws SQLException
/*       */   {
/*  7791 */     synchronized (this.connection)
/*       */     {
/*  7799 */       setTimeInternal(paramInt, paramTime);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setTimeInternal(int paramInt, Time paramTime)
/*       */     throws SQLException
/*       */   {
/*  7807 */     int i = paramInt - 1;
/*       */ 
/*  7809 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7811 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7812 */       localSQLException.fillInStackTrace();
/*  7813 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7816 */     if (paramTime == null) {
/*  7817 */       this.currentRowBinders[i] = this.theDateNullBinder;
/*       */     }
/*       */     else {
/*  7820 */       this.currentRowBinders[i] = this.theTimeBinder;
/*       */ 
/*  7822 */       if (this.parameterTime == null) {
/*  7823 */         this.parameterTime = new Time[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7828 */       this.parameterTime[this.currentRank][i] = paramTime;
/*       */     }
/*       */ 
/*  7831 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7832 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setTimestamp(int paramInt, Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/*  7847 */     synchronized (this.connection)
/*       */     {
/*  7855 */       setTimestampInternal(paramInt, paramTimestamp);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setTimestampInternal(int paramInt, Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/*  7865 */     int i = paramInt - 1;
/*       */ 
/*  7867 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7869 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*       */ 
/*  7871 */       localSQLException.fillInStackTrace();
/*  7872 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7875 */     if (paramTimestamp == null) {
/*  7876 */       this.currentRowBinders[i] = this.theTimestampNullBinder;
/*       */     }
/*       */     else {
/*  7879 */       this.currentRowBinders[i] = this.theTimestampBinder;
/*       */ 
/*  7881 */       if (this.parameterTimestamp == null) {
/*  7882 */         this.parameterTimestamp = new Timestamp[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7887 */       this.parameterTimestamp[this.currentRank][i] = paramTimestamp;
/*       */     }
/*       */ 
/*  7890 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7891 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setINTERVALYM(int paramInt, INTERVALYM paramINTERVALYM)
/*       */     throws SQLException
/*       */   {
/*  7912 */     synchronized (this.connection)
/*       */     {
/*  7920 */       setINTERVALYMInternal(paramInt, paramINTERVALYM);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setINTERVALYMInternal(int paramInt, INTERVALYM paramINTERVALYM)
/*       */     throws SQLException
/*       */   {
/*  7928 */     int i = paramInt - 1;
/*       */ 
/*  7930 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7932 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7933 */       localSQLException.fillInStackTrace();
/*  7934 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7937 */     if (paramINTERVALYM == null)
/*       */     {
/*  7939 */       this.currentRowBinders[i] = this.theIntervalYMNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  7943 */       this.currentRowBinders[i] = this.theIntervalYMBinder;
/*       */ 
/*  7945 */       if (this.parameterDatum == null)
/*       */       {
/*  7947 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  7952 */       this.parameterDatum[this.currentRank][i] = paramINTERVALYM.getBytes();
/*       */     }
/*       */ 
/*  7955 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  7956 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setINTERVALDS(int paramInt, INTERVALDS paramINTERVALDS)
/*       */     throws SQLException
/*       */   {
/*  7977 */     synchronized (this.connection)
/*       */     {
/*  7985 */       setINTERVALDSInternal(paramInt, paramINTERVALDS);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setINTERVALDSInternal(int paramInt, INTERVALDS paramINTERVALDS)
/*       */     throws SQLException
/*       */   {
/*  7993 */     int i = paramInt - 1;
/*       */ 
/*  7995 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  7997 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  7998 */       localSQLException.fillInStackTrace();
/*  7999 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8002 */     if (paramINTERVALDS == null)
/*       */     {
/*  8004 */       this.currentRowBinders[i] = this.theIntervalDSNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  8008 */       this.currentRowBinders[i] = this.theIntervalDSBinder;
/*       */ 
/*  8010 */       if (this.parameterDatum == null)
/*       */       {
/*  8012 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  8017 */       this.parameterDatum[this.currentRank][i] = paramINTERVALDS.getBytes();
/*       */     }
/*       */ 
/*  8020 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  8021 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMP(int paramInt, TIMESTAMP paramTIMESTAMP)
/*       */     throws SQLException
/*       */   {
/*  8042 */     synchronized (this.connection)
/*       */     {
/*  8050 */       setTIMESTAMPInternal(paramInt, paramTIMESTAMP);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setTIMESTAMPInternal(int paramInt, TIMESTAMP paramTIMESTAMP)
/*       */     throws SQLException
/*       */   {
/*  8058 */     int i = paramInt - 1;
/*       */ 
/*  8060 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  8062 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  8063 */       localSQLException.fillInStackTrace();
/*  8064 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8067 */     if (paramTIMESTAMP == null)
/*       */     {
/*  8069 */       this.currentRowBinders[i] = this.theTimestampNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  8073 */       this.currentRowBinders[i] = this.theOracleTimestampBinder;
/*       */ 
/*  8075 */       if (this.parameterDatum == null)
/*       */       {
/*  8077 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  8082 */       this.parameterDatum[this.currentRank][i] = paramTIMESTAMP.getBytes();
/*       */     }
/*       */ 
/*  8085 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  8086 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPTZ(int paramInt, TIMESTAMPTZ paramTIMESTAMPTZ)
/*       */     throws SQLException
/*       */   {
/*  8107 */     synchronized (this.connection)
/*       */     {
/*  8115 */       setTIMESTAMPTZInternal(paramInt, paramTIMESTAMPTZ);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setTIMESTAMPTZInternal(int paramInt, TIMESTAMPTZ paramTIMESTAMPTZ)
/*       */     throws SQLException
/*       */   {
/*  8124 */     int i = paramInt - 1;
/*       */ 
/*  8126 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  8128 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  8129 */       localSQLException.fillInStackTrace();
/*  8130 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8133 */     if (paramTIMESTAMPTZ == null)
/*       */     {
/*  8135 */       this.currentRowBinders[i] = this.theTSTZNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  8139 */       this.currentRowBinders[i] = this.theTSTZBinder;
/*       */ 
/*  8141 */       if (this.parameterDatum == null)
/*       */       {
/*  8143 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  8148 */       this.parameterDatum[this.currentRank][i] = paramTIMESTAMPTZ.getBytes();
/*       */     }
/*       */ 
/*  8151 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  8152 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPLTZ(int paramInt, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*       */     throws SQLException
/*       */   {
/*  8177 */     synchronized (this.connection)
/*       */     {
/*  8185 */       setTIMESTAMPLTZInternal(paramInt, paramTIMESTAMPLTZ);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setTIMESTAMPLTZInternal(int paramInt, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*       */     throws SQLException
/*       */   {
/*  8194 */     if (this.connection.getSessionTimeZone() == null)
/*       */     {
/*  8197 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 105);
/*  8198 */       localSQLException1.fillInStackTrace();
/*  8199 */       throw localSQLException1;
/*       */     }
/*       */ 
/*  8203 */     int i = paramInt - 1;
/*       */ 
/*  8205 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  8207 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  8208 */       localSQLException2.fillInStackTrace();
/*  8209 */       throw localSQLException2;
/*       */     }
/*       */ 
/*  8212 */     if (paramTIMESTAMPLTZ == null)
/*       */     {
/*  8214 */       this.currentRowBinders[i] = this.theTSLTZNullBinder;
/*       */     }
/*       */     else
/*       */     {
/*  8218 */       this.currentRowBinders[i] = this.theTSLTZBinder;
/*       */ 
/*  8220 */       if (this.parameterDatum == null)
/*       */       {
/*  8222 */         this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  8227 */       this.parameterDatum[this.currentRank][i] = paramTIMESTAMPLTZ.getBytes();
/*       */     }
/*       */ 
/*  8230 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  8231 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   private Reader isReaderEmpty(Reader paramReader)
/*       */     throws IOException
/*       */   {
/*  8240 */     if (!paramReader.markSupported()) paramReader = new BufferedReader(paramReader, 4096);
/*  8241 */     paramReader.mark(10);
/*  8242 */     if (paramReader.read() == -1) {
/*  8243 */       return null;
/*       */     }
/*  8245 */     paramReader.reset();
/*  8246 */     return paramReader;
/*       */   }
/*       */ 
/*       */   private InputStream isInputStreamEmpty(InputStream paramInputStream)
/*       */     throws IOException
/*       */   {
/*  8252 */     if (!paramInputStream.markSupported()) paramInputStream = new BufferedInputStream(paramInputStream, 4096);
/*  8253 */     paramInputStream.mark(10);
/*  8254 */     if (paramInputStream.read() == -1) {
/*  8255 */       return null;
/*       */     }
/*  8257 */     paramInputStream.reset();
/*  8258 */     return paramInputStream;
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8284 */     synchronized (this.connection)
/*       */     {
/*  8292 */       setAsciiStreamInternal(paramInt1, paramInputStream, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setAsciiStreamInternal(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8301 */     setAsciiStreamInternal(paramInt1, paramInputStream, paramInt2, true);
/*       */   }
/*       */ 
/*       */   void setAsciiStreamInternal(int paramInt, InputStream paramInputStream, long paramLong, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  8309 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/*  8311 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  8313 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  8314 */       localSQLException.fillInStackTrace();
/*  8315 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8321 */     set_execute_batch(1);
/*  8322 */     checkUserStreamForDuplicates(paramInputStream, i);
/*  8323 */     if (paramInputStream == null) {
/*  8324 */       basicBindNullString(paramInt); } else {
/*  8325 */       if ((this.userRsetType != DEFAULT_RESULT_SET_TYPE) && ((paramLong > this.maxVcsCharsSql) || (!paramBoolean)))
/*       */       {
/*  8328 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 169);
/*  8329 */         localSQLException.fillInStackTrace();
/*  8330 */         throw localSQLException;
/*       */       }
/*  8332 */       if (!paramBoolean)
/*  8333 */         setAsciiStreamContentsForClobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*  8334 */       else if (this.currentRowFormOfUse[i] == 1)
/*       */       {
/*  8336 */         if (this.sqlKind.isPlsqlOrCall())
/*       */         {
/*  8338 */           if (paramLong <= this.maxVcsCharsPlsql)
/*       */           {
/*  8340 */             setAsciiStreamContentsForStringInternal(paramInt, paramInputStream, (int)paramLong);
/*       */           }
/*       */           else
/*       */           {
/*  8344 */             setAsciiStreamContentsForClobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */           }
/*       */ 
/*       */         }
/*  8349 */         else if (paramLong <= this.maxVcsCharsSql)
/*       */         {
/*  8351 */           setAsciiStreamContentsForStringInternal(paramInt, paramInputStream, (int)paramLong);
/*       */         }
/*  8353 */         else if (paramLong > 2147483647L)
/*       */         {
/*  8355 */           setAsciiStreamContentsForClobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */         }
/*       */         else
/*       */         {
/*  8359 */           basicBindAsciiStream(paramInt, paramInputStream, (int)paramLong);
/*       */         }
/*       */ 
/*       */       }
/*  8365 */       else if (this.sqlKind.isPlsqlOrCall())
/*       */       {
/*  8367 */         if (paramLong <= this.maxVcsNCharsPlsql)
/*       */         {
/*  8369 */           setAsciiStreamContentsForStringInternal(paramInt, paramInputStream, (int)paramLong);
/*       */         }
/*       */         else
/*       */         {
/*  8373 */           setAsciiStreamContentsForClobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */         }
/*       */ 
/*       */       }
/*  8378 */       else if (paramLong <= this.maxVcsNCharsSql)
/*       */       {
/*  8380 */         setAsciiStreamContentsForStringInternal(paramInt, paramInputStream, (int)paramLong);
/*       */       }
/*       */       else
/*       */       {
/*  8384 */         setAsciiStreamContentsForClobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void basicBindAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8395 */     synchronized (this.connection)
/*       */     {
/*  8398 */       if (this.userRsetType != DEFAULT_RESULT_SET_TYPE)
/*       */       {
/*  8400 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 169);
/*  8401 */         localSQLException.fillInStackTrace();
/*  8402 */         throw localSQLException;
/*       */       }
/*  8404 */       int i = paramInt1 - 1;
/*  8405 */       this.currentRowBinders[i] = this.theLongStreamBinder;
/*       */ 
/*  8407 */       if (this.parameterStream == null) {
/*  8408 */         this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/*       */ 
/*  8411 */       this.parameterStream[this.currentRank][i] = this.connection.conversion.ConvertStream(paramInputStream, 5, paramInt2);
/*       */ 
/*  8415 */       this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  8416 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setAsciiStreamContentsForStringInternal(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8426 */     byte[] arrayOfByte = new byte[paramInt2];
/*  8427 */     int i = 0;
/*  8428 */     int j = paramInt2;
/*       */     try
/*       */     {
/*       */       int k;
/*  8434 */       while ((j > 0) && ((k = paramInputStream.read(arrayOfByte, i, j)) != -1)) {
/*  8435 */         i += k;
/*  8436 */         j -= k;
/*       */       }
/*       */ 
/*       */     }
/*       */     catch (IOException localIOException)
/*       */     {
/*  8442 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  8443 */       localSQLException.fillInStackTrace();
/*  8444 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8449 */     char[] arrayOfChar = new char[paramInt2];
/*  8450 */     DBConversion.asciiBytesToJavaChars(arrayOfByte, i, arrayOfChar);
/*       */ 
/*  8455 */     basicBindString(paramInt1, new String(arrayOfChar));
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8487 */     setBinaryStreamInternal(paramInt1, paramInputStream, paramInt2);
/*       */   }
/*       */ 
/*       */   void setBinaryStreamInternal(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8495 */     setBinaryStreamInternal(paramInt1, paramInputStream, paramInt2, true);
/*       */   }
/*       */ 
/*       */   void checkUserStreamForDuplicates(Object paramObject, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  8503 */     if (paramObject == null)
/*       */     {
/*  8505 */       return;
/*       */     }
/*  8507 */     if (this.userStream != null)
/*       */     {
/*  8509 */       for (Object[] arrayOfObject1 : this.userStream)
/*       */       {
/*  8511 */         for (Object localObject : arrayOfObject1)
/*       */         {
/*  8513 */           if (localObject == paramObject)
/*       */           {
/*  8516 */             SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 270, Integer.valueOf(paramInt + 1));
/*  8517 */             localSQLException.fillInStackTrace();
/*  8518 */             throw localSQLException;
/*       */           }
/*       */         }
/*       */       }
/*       */ 
/*       */     }
/*       */     else
/*       */     {
/*  8526 */       this.userStream = new Object[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*  8528 */     this.userStream[this.currentRank][paramInt] = paramObject;
/*       */   }
/*       */ 
/*       */   void setBinaryStreamInternal(int paramInt, InputStream paramInputStream, long paramLong, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  8536 */     synchronized (this.connection)
/*       */     {
/*  8538 */       int i = paramInt - 1;
/*       */       SQLException localSQLException;
/*  8540 */       if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */       {
/*  8542 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  8543 */         localSQLException.fillInStackTrace();
/*  8544 */         throw localSQLException;
/*       */       }
/*       */ 
/*  8549 */       set_execute_batch(1);
/*       */ 
/*  8551 */       checkUserStreamForDuplicates(paramInputStream, i);
/*       */ 
/*  8553 */       if (paramInputStream == null) {
/*  8554 */         setRAWInternal(paramInt, null); } else {
/*  8555 */         if ((this.userRsetType != DEFAULT_RESULT_SET_TYPE) && ((paramLong > this.maxRawBytesSql) || (!paramBoolean)))
/*       */         {
/*  8558 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 169);
/*  8559 */           localSQLException.fillInStackTrace();
/*  8560 */           throw localSQLException;
/*       */         }
/*  8562 */         if (!paramBoolean) {
/*  8563 */           setBinaryStreamContentsForBlobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */         }
/*  8565 */         else if (this.sqlKind.isPlsqlOrCall())
/*       */         {
/*  8567 */           if (paramLong > this.maxRawBytesPlsql)
/*       */           {
/*  8569 */             setBinaryStreamContentsForBlobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */           }
/*       */           else
/*       */           {
/*  8574 */             setBinaryStreamContentsForByteArrayInternal(paramInt, paramInputStream, (int)paramLong);
/*       */           }
/*       */ 
/*       */         }
/*  8580 */         else if (paramLong > 2147483647L)
/*       */         {
/*  8582 */           setBinaryStreamContentsForBlobCritical(paramInt, paramInputStream, paramLong, paramBoolean);
/*       */         }
/*  8585 */         else if (paramLong > this.maxRawBytesSql)
/*       */         {
/*  8587 */           basicBindBinaryStream(paramInt, paramInputStream, (int)paramLong);
/*       */         }
/*       */         else
/*       */         {
/*  8591 */           setBinaryStreamContentsForByteArrayInternal(paramInt, paramInputStream, (int)paramLong);
/*       */         }
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void setBinaryStreamContentsForByteArrayInternal(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8605 */     Object localObject = new byte[paramInt2];
/*  8606 */     int i = 0;
/*  8607 */     int j = paramInt2;
/*       */     try
/*       */     {
/*       */       int k;
/*  8614 */       while ((j > 0) && ((k = paramInputStream.read((byte[])localObject, i, j)) != -1))
/*       */       {
/*  8616 */         i += k;
/*  8617 */         j -= k;
/*       */       }
/*       */ 
/*       */     }
/*       */     catch (IOException localIOException)
/*       */     {
/*  8623 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  8624 */       localSQLException.fillInStackTrace();
/*  8625 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8629 */     if (i != paramInt2)
/*       */     {
/*  8631 */       byte[] arrayOfByte = new byte[i];
/*       */ 
/*  8633 */       System.arraycopy(localObject, 0, arrayOfByte, 0, i);
/*       */ 
/*  8635 */       localObject = arrayOfByte;
/*       */     }
/*       */ 
/*  8638 */     setBytesInternal(paramInt1, (byte[])localObject);
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void setUnicodeStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8674 */     setUnicodeStreamInternal(paramInt1, paramInputStream, paramInt2);
/*       */   }
/*       */ 
/*       */   void setUnicodeStreamInternal(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  8682 */     synchronized (this.connection)
/*       */     {
/*  8684 */       int i = paramInt1 - 1;
/*       */       Object localObject1;
/*  8686 */       if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */       {
/*  8688 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  8689 */         ((SQLException)localObject1).fillInStackTrace();
/*  8690 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  8696 */       set_execute_batch(1);
/*  8697 */       checkUserStreamForDuplicates(paramInputStream, i);
/*  8698 */       if (paramInputStream == null) {
/*  8699 */         setStringInternal(paramInt1, null); } else {
/*  8700 */         if ((this.userRsetType != DEFAULT_RESULT_SET_TYPE) && (paramInt2 > this.maxVcsCharsSql))
/*       */         {
/*  8702 */           localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 169);
/*  8703 */           ((SQLException)localObject1).fillInStackTrace();
/*  8704 */           throw ((Throwable)localObject1);
/*       */         }
/*  8706 */         if ((this.sqlKind.isPlsqlOrCall()) || (paramInt2 <= this.maxVcsCharsSql))
/*       */         {
/*  8708 */           localObject1 = new byte[paramInt2];
/*  8709 */           int j = 0;
/*  8710 */           int k = paramInt2;
/*       */           try
/*       */           {
/*       */             int m;
/*  8717 */             while ((k > 0) && ((m = paramInputStream.read((byte[])localObject1, j, k)) != -1))
/*       */             {
/*  8719 */               j += m;
/*  8720 */               k -= m;
/*       */             }
/*       */ 
/*       */           }
/*       */           catch (IOException localIOException)
/*       */           {
/*  8726 */             SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/*  8727 */             localSQLException.fillInStackTrace();
/*  8728 */             throw localSQLException;
/*       */           }
/*       */ 
/*  8732 */           char[] arrayOfChar = new char[j >> 1];
/*       */ 
/*  8734 */           DBConversion.ucs2BytesToJavaChars((byte[])localObject1, j, arrayOfChar);
/*       */ 
/*  8737 */           setStringInternal(paramInt1, new String(arrayOfChar));
/*       */         }
/*       */         else
/*       */         {
/*  8741 */           this.currentRowBinders[i] = this.theLongStreamBinder;
/*       */ 
/*  8743 */           if (this.parameterStream == null) {
/*  8744 */             this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */           }
/*       */ 
/*  8747 */           this.parameterStream[this.currentRank][i] = this.connection.conversion.ConvertStream(paramInputStream, 4, paramInt2);
/*       */ 
/*  8751 */           this.currentRowByteLens[i] = 0;
/*  8752 */           this.currentRowCharLens[i] = 0;
/*       */         }
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void setCustomDatum(int paramInt, CustomDatum paramCustomDatum)
/*       */     throws SQLException
/*       */   {
/*  8772 */     synchronized (this.connection)
/*       */     {
/*  8783 */       setObjectInternal(paramInt, this.connection.toDatum(paramCustomDatum));
/*       */     }
/*       */   }
/*       */ 
/*       */   void setCustomDatumInternal(int paramInt, CustomDatum paramCustomDatum)
/*       */     throws SQLException
/*       */   {
/*  8791 */     synchronized (this.connection)
/*       */     {
/*  8793 */       Datum localDatum = this.connection.toDatum(paramCustomDatum);
/*  8794 */       int i = sqlTypeForObject(localDatum);
/*       */ 
/*  8796 */       setObjectCritical(paramInt, localDatum, i, 0);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setORAData(int paramInt, ORAData paramORAData)
/*       */     throws SQLException
/*       */   {
/*  8821 */     setORADataInternal(paramInt, paramORAData);
/*       */   }
/*       */ 
/*       */   void setORADataInternal(int paramInt, ORAData paramORAData)
/*       */     throws SQLException
/*       */   {
/*  8827 */     synchronized (this.connection)
/*       */     {
/*  8829 */       Datum localDatum = paramORAData.toDatum(this.connection);
/*  8830 */       int i = sqlTypeForObject(localDatum);
/*       */ 
/*  8832 */       setObjectCritical(paramInt, localDatum, i, 0);
/*       */ 
/*  8834 */       if ((i == 2002) || (i == 2008) || (i == 2003))
/*       */       {
/*  8838 */         this.currentRowCharLens[(paramInt - 1)] = 0;
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void setOracleDataInternal(int paramInt, OracleData paramOracleData)
/*       */     throws SQLException
/*       */   {
/*  8846 */     synchronized (this.connection)
/*       */     {
/*  8849 */       Object localObject1 = paramOracleData.toJDBCObject(this.connection);
/*       */ 
/*  8855 */       if ((localObject1 instanceof _Proxy_))
/*       */       {
/*  8857 */         final _Proxy_ local_Proxy_ = (_Proxy_)localObject1;
/*  8858 */         localObject1 = AccessController.doPrivileged(new PrivilegedAction()
/*       */         {
/*       */           public Object run()
/*       */           {
/*  8863 */             return ProxyFactory.extractDelegate(local_Proxy_);
/*       */           }
/*       */         });
/*       */       }
/*       */ 
/*  8868 */       int i = sqlTypeForObject(localObject1);
/*       */ 
/*  8870 */       setObjectCritical(paramInt, localObject1, i, 0);
/*       */ 
/*  8872 */       if ((i == 2002) || (i == 2008) || (i == 2003))
/*       */       {
/*  8876 */         this.currentRowCharLens[(paramInt - 1)] = 0;
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setObject(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  8906 */     synchronized (this.connection)
/*       */     {
/*  8914 */       setObjectInternal(paramInt1, paramObject, paramInt2, paramInt3);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setObjectInternal(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*  8926 */     if ((paramObject == null) && (paramInt2 != 2002) && (paramInt2 != 2008) && (paramInt2 != 2003) && (paramInt2 != 2007) && (paramInt2 != 2006) && (paramInt2 != 2009))
/*       */     {
/*  8935 */       setNullInternal(paramInt1, paramInt2);
/*       */     }
/*  8939 */     else if ((paramInt2 == 2002) || (paramInt2 == 2008) || (paramInt2 == 2003) || (paramInt2 == 2009))
/*       */     {
/*  8946 */       setObjectCritical(paramInt1, paramObject, paramInt2, paramInt3);
/*       */ 
/*  8948 */       this.currentRowCharLens[(paramInt1 - 1)] = 0;
/*       */     }
/*       */     else
/*       */     {
/*  8954 */       setObjectCritical(paramInt1, paramObject, paramInt2, paramInt3);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setObjectCritical(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/*  8979 */     switch (paramInt2)
/*       */     {
/*       */     case -15:
/*  8983 */       setFormOfUse(paramInt1, (short)2);
/*       */     case 1:
/*  8987 */       if ((paramObject instanceof CHAR)) {
/*  8988 */         setCHARInternal(paramInt1, (CHAR)paramObject);
/*  8989 */       } else if ((paramObject instanceof String)) {
/*  8990 */         setStringInternal(paramInt1, (String)paramObject);
/*  8991 */       } else if ((paramObject instanceof Boolean)) {
/*  8992 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Boolean)paramObject).booleanValue() ? 1 : 0).toString());
/*       */       }
/*  8994 */       else if ((paramObject instanceof Integer)) {
/*  8995 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Integer)paramObject).intValue()).toString());
/*  8996 */       } else if ((paramObject instanceof Long)) {
/*  8997 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Long)paramObject).longValue()).toString());
/*  8998 */       } else if ((paramObject instanceof Float)) {
/*  8999 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Float)paramObject).floatValue()).toString());
/*  9000 */       } else if ((paramObject instanceof Double)) {
/*  9001 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Double)paramObject).doubleValue()).toString());
/*  9002 */       } else if ((paramObject instanceof BigDecimal)) {
/*  9003 */         setStringInternal(paramInt1, ((BigDecimal)paramObject).toString());
/*  9004 */       } else if ((paramObject instanceof Date)) {
/*  9005 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Date)paramObject).toString()).toString());
/*  9006 */       } else if ((paramObject instanceof Time)) {
/*  9007 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Time)paramObject).toString()).toString());
/*  9008 */       } else if ((paramObject instanceof Timestamp)) {
/*  9009 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Timestamp)paramObject).toString()).toString());
/*  9010 */       } else if ((paramObject instanceof URL)) {
/*  9011 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((URL)paramObject).toString()).toString());
/*       */       }
/*       */       else {
/*  9014 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9016 */         localSQLException.fillInStackTrace();
/*  9017 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case -9:
/*  9023 */       setFormOfUse(paramInt1, (short)2);
/*       */     case 12:
/*  9027 */       if ((paramObject instanceof String)) {
/*  9028 */         setStringInternal(paramInt1, (String)paramObject);
/*  9029 */       } else if ((paramObject instanceof Boolean)) {
/*  9030 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Boolean)paramObject).booleanValue() ? 1 : 0).toString());
/*       */       }
/*  9032 */       else if ((paramObject instanceof Integer)) {
/*  9033 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Integer)paramObject).intValue()).toString());
/*  9034 */       } else if ((paramObject instanceof Long)) {
/*  9035 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Long)paramObject).longValue()).toString());
/*  9036 */       } else if ((paramObject instanceof Float)) {
/*  9037 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Float)paramObject).floatValue()).toString());
/*  9038 */       } else if ((paramObject instanceof Double)) {
/*  9039 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Double)paramObject).doubleValue()).toString());
/*  9040 */       } else if ((paramObject instanceof BigDecimal)) {
/*  9041 */         setStringInternal(paramInt1, ((BigDecimal)paramObject).toString());
/*  9042 */       } else if ((paramObject instanceof Date)) {
/*  9043 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Date)paramObject).toString()).toString());
/*  9044 */       } else if ((paramObject instanceof Time)) {
/*  9045 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Time)paramObject).toString()).toString());
/*  9046 */       } else if ((paramObject instanceof Timestamp)) {
/*  9047 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Timestamp)paramObject).toString()).toString());
/*  9048 */       } else if ((paramObject instanceof URL)) {
/*  9049 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((URL)paramObject).toString()).toString());
/*       */       }
/*       */       else {
/*  9052 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9054 */         localSQLException.fillInStackTrace();
/*  9055 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 999:
/*  9061 */       setFixedCHARInternal(paramInt1, (String)paramObject);
/*       */ 
/*  9063 */       break;
/*       */     case -16:
/*  9066 */       setFormOfUse(paramInt1, (short)2);
/*       */     case -1:
/*  9070 */       if ((paramObject instanceof String)) {
/*  9071 */         setStringInternal(paramInt1, (String)paramObject);
/*  9072 */       } else if ((paramObject instanceof Boolean)) {
/*  9073 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Boolean)paramObject).booleanValue() ? 1 : 0).toString());
/*       */       }
/*  9076 */       else if ((paramObject instanceof Integer)) {
/*  9077 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Integer)paramObject).intValue()).toString());
/*       */       }
/*  9079 */       else if ((paramObject instanceof Long)) {
/*  9080 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Long)paramObject).longValue()).toString());
/*       */       }
/*  9082 */       else if ((paramObject instanceof Float)) {
/*  9083 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Float)paramObject).floatValue()).toString());
/*       */       }
/*  9085 */       else if ((paramObject instanceof Double)) {
/*  9086 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Double)paramObject).doubleValue()).toString());
/*       */       }
/*  9088 */       else if ((paramObject instanceof BigDecimal)) {
/*  9089 */         setStringInternal(paramInt1, ((BigDecimal)paramObject).toString());
/*  9090 */       } else if ((paramObject instanceof Date)) {
/*  9091 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Date)paramObject).toString()).toString());
/*  9092 */       } else if ((paramObject instanceof Time)) {
/*  9093 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Time)paramObject).toString()).toString());
/*  9094 */       } else if ((paramObject instanceof Timestamp)) {
/*  9095 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((Timestamp)paramObject).toString()).toString());
/*       */       }
/*  9097 */       else if ((paramObject instanceof URL)) {
/*  9098 */         setStringInternal(paramInt1, new StringBuilder().append("").append(((URL)paramObject).toString()).toString());
/*       */       }
/*       */       else {
/*  9101 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9103 */         localSQLException.fillInStackTrace();
/*  9104 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 2:
/*  9112 */       if ((paramObject instanceof NUMBER)) {
/*  9113 */         setNUMBERInternal(paramInt1, (NUMBER)paramObject);
/*  9114 */       } else if ((paramObject instanceof Integer)) {
/*  9115 */         setIntInternal(paramInt1, ((Integer)paramObject).intValue());
/*  9116 */       } else if ((paramObject instanceof Long)) {
/*  9117 */         setLongInternal(paramInt1, ((Long)paramObject).longValue());
/*  9118 */       } else if ((paramObject instanceof Float)) {
/*  9119 */         setFloatInternal(paramInt1, ((Float)paramObject).floatValue());
/*  9120 */       } else if ((paramObject instanceof Double)) {
/*  9121 */         setDoubleInternal(paramInt1, ((Double)paramObject).doubleValue());
/*  9122 */       } else if ((paramObject instanceof BigDecimal)) {
/*  9123 */         setBigDecimalInternal(paramInt1, (BigDecimal)paramObject);
/*  9124 */       } else if ((paramObject instanceof BigInteger)) {
/*  9125 */         setBigDecimalInternal(paramInt1, new BigDecimal((BigInteger)paramObject));
/*  9126 */       } else if ((paramObject instanceof String)) {
/*  9127 */         setNUMBERInternal(paramInt1, new NUMBER((String)paramObject, paramInt3));
/*  9128 */       } else if ((paramObject instanceof Boolean)) {
/*  9129 */         setIntInternal(paramInt1, ((Boolean)paramObject).booleanValue() ? 1 : 0);
/*  9130 */       } else if ((paramObject instanceof Short)) {
/*  9131 */         setShortInternal(paramInt1, ((Short)paramObject).shortValue());
/*  9132 */       } else if ((paramObject instanceof Byte)) {
/*  9133 */         setByteInternal(paramInt1, ((Byte)paramObject).byteValue());
/*       */       }
/*       */       else {
/*  9136 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9138 */         localSQLException.fillInStackTrace();
/*  9139 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 3:
/*  9145 */       if ((paramObject instanceof BigDecimal)) {
/*  9146 */         setBigDecimalInternal(paramInt1, (BigDecimal)paramObject);
/*  9147 */       } else if ((paramObject instanceof Number)) {
/*  9148 */         setBigDecimalInternal(paramInt1, new BigDecimal(((Number)paramObject).doubleValue()));
/*       */       }
/*  9150 */       else if ((paramObject instanceof NUMBER)) {
/*  9151 */         setBigDecimalInternal(paramInt1, ((NUMBER)paramObject).bigDecimalValue());
/*  9152 */       } else if ((paramObject instanceof String)) {
/*  9153 */         setBigDecimalInternal(paramInt1, new BigDecimal((String)paramObject));
/*  9154 */       } else if ((paramObject instanceof Boolean)) {
/*  9155 */         setBigDecimalInternal(paramInt1, new BigDecimal(((Boolean)paramObject).booleanValue() ? 1.0D : 0.0D));
/*       */       }
/*       */       else
/*       */       {
/*  9160 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9162 */         localSQLException.fillInStackTrace();
/*  9163 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case -7:
/*  9169 */       if ((paramObject instanceof Boolean)) {
/*  9170 */         setByteInternal(paramInt1, (byte)(((Boolean)paramObject).booleanValue() ? 1 : 0));
/*       */       }
/*  9172 */       else if ((paramObject instanceof String)) {
/*  9173 */         setByteInternal(paramInt1, (byte)(("true".equalsIgnoreCase((String)paramObject)) || ("1".equals(paramObject)) ? 1 : 0));
/*       */       }
/*  9177 */       else if ((paramObject instanceof Number)) {
/*  9178 */         setIntInternal(paramInt1, ((Number)paramObject).byteValue() != 0 ? 1 : 0);
/*       */       }
/*       */       else {
/*  9181 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9183 */         localSQLException.fillInStackTrace();
/*  9184 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case -6:
/*  9192 */       if ((paramObject instanceof Number)) {
/*  9193 */         setByteInternal(paramInt1, ((Number)paramObject).byteValue());
/*  9194 */       } else if ((paramObject instanceof String)) {
/*  9195 */         setByteInternal(paramInt1, Byte.parseByte((String)paramObject));
/*  9196 */       } else if ((paramObject instanceof Boolean)) {
/*  9197 */         setByteInternal(paramInt1, (byte)(((Boolean)paramObject).booleanValue() ? 1 : 0));
/*       */       }
/*       */       else
/*       */       {
/*  9201 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9203 */         localSQLException.fillInStackTrace();
/*  9204 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 5:
/*  9212 */       if ((paramObject instanceof Number)) {
/*  9213 */         setShortInternal(paramInt1, ((Number)paramObject).shortValue());
/*  9214 */       } else if ((paramObject instanceof String)) {
/*  9215 */         setShortInternal(paramInt1, Short.parseShort((String)paramObject));
/*  9216 */       } else if ((paramObject instanceof Boolean)) {
/*  9217 */         setShortInternal(paramInt1, (short)(((Boolean)paramObject).booleanValue() ? 1 : 0));
/*       */       }
/*       */       else
/*       */       {
/*  9221 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9223 */         localSQLException.fillInStackTrace();
/*  9224 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 4:
/*  9230 */       if ((paramObject instanceof Number)) {
/*  9231 */         setIntInternal(paramInt1, ((Number)paramObject).intValue());
/*  9232 */       } else if ((paramObject instanceof String)) {
/*  9233 */         setIntInternal(paramInt1, Integer.parseInt((String)paramObject));
/*  9234 */       } else if ((paramObject instanceof Boolean)) {
/*  9235 */         setIntInternal(paramInt1, ((Boolean)paramObject).booleanValue() ? 1 : 0);
/*       */       }
/*       */       else {
/*  9238 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9240 */         localSQLException.fillInStackTrace();
/*  9241 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case -5:
/*  9247 */       if ((paramObject instanceof Number)) {
/*  9248 */         setLongInternal(paramInt1, ((Number)paramObject).longValue());
/*  9249 */       } else if ((paramObject instanceof String)) {
/*  9250 */         setLongInternal(paramInt1, Long.parseLong((String)paramObject));
/*  9251 */       } else if ((paramObject instanceof Boolean)) {
/*  9252 */         setLongInternal(paramInt1, ((Boolean)paramObject).booleanValue() ? 1L : 0L);
/*       */       }
/*       */       else {
/*  9255 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9257 */         localSQLException.fillInStackTrace();
/*  9258 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 7:
/*  9264 */       if ((paramObject instanceof Number)) {
/*  9265 */         setFloatInternal(paramInt1, ((Number)paramObject).floatValue());
/*  9266 */       } else if ((paramObject instanceof String)) {
/*  9267 */         setFloatInternal(paramInt1, Float.valueOf((String)paramObject).floatValue());
/*  9268 */       } else if ((paramObject instanceof Boolean)) {
/*  9269 */         setFloatInternal(paramInt1, ((Boolean)paramObject).booleanValue() ? 1.0F : 0.0F);
/*       */       }
/*       */       else {
/*  9272 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9274 */         localSQLException.fillInStackTrace();
/*  9275 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 6:
/*       */     case 8:
/*  9283 */       if ((paramObject instanceof Number)) {
/*  9284 */         setDoubleInternal(paramInt1, ((Number)paramObject).doubleValue());
/*  9285 */       } else if ((paramObject instanceof String)) {
/*  9286 */         setDoubleInternal(paramInt1, Double.valueOf((String)paramObject).doubleValue());
/*       */       }
/*  9288 */       else if ((paramObject instanceof Boolean)) {
/*  9289 */         setDoubleInternal(paramInt1, ((Boolean)paramObject).booleanValue() ? 1.0D : 0.0D);
/*       */       }
/*       */       else
/*       */       {
/*  9293 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9295 */         localSQLException.fillInStackTrace();
/*  9296 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case -2:
/*  9302 */       if ((paramObject instanceof RAW))
/*  9303 */         setRAWInternal(paramInt1, (RAW)paramObject);
/*       */       else {
/*  9305 */         setBytesInternal(paramInt1, (byte[])paramObject);
/*       */       }
/*  9307 */       break;
/*       */     case -3:
/*  9310 */       setBytesInternal(paramInt1, (byte[])paramObject);
/*       */ 
/*  9312 */       break;
/*       */     case -4:
/*  9315 */       setBytesInternal(paramInt1, (byte[])paramObject);
/*       */ 
/*  9317 */       break;
/*       */     case 91:
/*  9320 */       if ((paramObject instanceof DATE)) {
/*  9321 */         setDATEInternal(paramInt1, (DATE)paramObject);
/*  9322 */       } else if ((paramObject instanceof Date)) {
/*  9323 */         setDATEInternal(paramInt1, new DATE(paramObject, getDefaultCalendar()));
/*  9324 */       } else if ((paramObject instanceof Timestamp)) {
/*  9325 */         setDATEInternal(paramInt1, new DATE((Timestamp)paramObject));
/*  9326 */       } else if ((paramObject instanceof String)) {
/*  9327 */         setDateInternal(paramInt1, Date.valueOf((String)paramObject));
/*       */       }
/*       */       else {
/*  9330 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9332 */         localSQLException.fillInStackTrace();
/*  9333 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 92:
/*  9339 */       if ((paramObject instanceof Time)) {
/*  9340 */         setTimeInternal(paramInt1, (Time)paramObject);
/*  9341 */       } else if ((paramObject instanceof Timestamp)) {
/*  9342 */         setTimeInternal(paramInt1, new Time(((Timestamp)paramObject).getTime()));
/*       */       }
/*  9344 */       else if ((paramObject instanceof Date)) {
/*  9345 */         setTimeInternal(paramInt1, new Time(((Date)paramObject).getTime()));
/*  9346 */       } else if ((paramObject instanceof String)) {
/*  9347 */         setTimeInternal(paramInt1, Time.valueOf((String)paramObject));
/*       */       }
/*       */       else {
/*  9350 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9352 */         localSQLException.fillInStackTrace();
/*  9353 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case 93:
/*  9359 */       if ((paramObject instanceof TIMESTAMP)) {
/*  9360 */         setTIMESTAMPInternal(paramInt1, (TIMESTAMP)paramObject);
/*  9361 */       } else if ((paramObject instanceof Timestamp)) {
/*  9362 */         setTimestampInternal(paramInt1, (Timestamp)paramObject);
/*  9363 */       } else if ((paramObject instanceof Date)) {
/*  9364 */         setTIMESTAMPInternal(paramInt1, new TIMESTAMP((Date)paramObject));
/*  9365 */       } else if ((paramObject instanceof DATE)) {
/*  9366 */         setTIMESTAMPInternal(paramInt1, new TIMESTAMP(((DATE)paramObject).timestampValue()));
/*  9367 */       } else if ((paramObject instanceof String)) {
/*  9368 */         setTimestampInternal(paramInt1, Timestamp.valueOf((String)paramObject));
/*       */       }
/*       */       else {
/*  9371 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 132);
/*       */ 
/*  9373 */         localSQLException.fillInStackTrace();
/*  9374 */         throw localSQLException;
/*       */       }
/*       */ 
/*       */       break;
/*       */     case -100:
/*  9380 */       setTIMESTAMPInternal(paramInt1, (TIMESTAMP)paramObject);
/*       */ 
/*  9382 */       break;
/*       */     case -101:
/*  9385 */       setTIMESTAMPTZInternal(paramInt1, (TIMESTAMPTZ)paramObject);
/*       */ 
/*  9387 */       break;
/*       */     case -102:
/*  9390 */       setTIMESTAMPLTZInternal(paramInt1, (TIMESTAMPLTZ)paramObject);
/*       */ 
/*  9392 */       break;
/*       */     case -103:
/*  9395 */       setINTERVALYMInternal(paramInt1, (INTERVALYM)paramObject);
/*       */ 
/*  9397 */       break;
/*       */     case -104:
/*  9400 */       setINTERVALDSInternal(paramInt1, (INTERVALDS)paramObject);
/*       */ 
/*  9402 */       break;
/*       */     case -8:
/*  9405 */       setROWIDInternal(paramInt1, (ROWID)paramObject);
/*       */ 
/*  9407 */       break;
/*       */     case 100:
/*  9410 */       setBinaryFloatInternal(paramInt1, (BINARY_FLOAT)paramObject);
/*       */ 
/*  9412 */       break;
/*       */     case 101:
/*  9415 */       setBinaryDoubleInternal(paramInt1, (BINARY_DOUBLE)paramObject);
/*       */ 
/*  9417 */       break;
/*       */     case 2004:
/*  9420 */       setBLOBInternal(paramInt1, (BLOB)paramObject);
/*       */ 
/*  9422 */       break;
/*       */     case 2005:
/*       */     case 2011:
/*  9427 */       setCLOBInternal(paramInt1, (CLOB)paramObject);
/*  9428 */       if (((CLOB)paramObject).isNCLOB())
/*       */       {
/*  9430 */         setFormOfUse(paramInt1, (short)2); } break;
/*       */     case -13:
/*  9435 */       setBFILEInternal(paramInt1, (BFILE)paramObject);
/*       */ 
/*  9437 */       break;
/*       */     case 2002:
/*       */     case 2008:
/*  9442 */       setSTRUCTInternal(paramInt1, STRUCT.toSTRUCT(paramObject, this.connection));
/*       */ 
/*  9444 */       break;
/*       */     case 2003:
/*  9447 */       setARRAYInternal(paramInt1, ARRAY.toARRAY(paramObject, this.connection));
/*       */ 
/*  9450 */       break;
/*       */     case 2007:
/*  9453 */       setOPAQUEInternal(paramInt1, (OPAQUE)paramObject);
/*       */ 
/*  9455 */       break;
/*       */     case 2006:
/*  9458 */       setREFInternal(paramInt1, (REF)paramObject);
/*       */ 
/*  9460 */       break;
/*       */     case 2009:
/*  9463 */       setSQLXMLInternal(paramInt1, (SQLXML)paramObject);
/*       */ 
/*  9465 */       break;
/*       */     default:
/*  9469 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*  9470 */       localSQLException.fillInStackTrace();
/*  9471 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setObjectAtName(String paramString, Object paramObject, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  9496 */     if (paramString == null)
/*       */     {
/*  9498 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9499 */       ((SQLException)localObject).fillInStackTrace();
/*  9500 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9505 */     Object localObject = paramString.intern();
/*  9506 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*  9507 */     int i = 0;
/*  9508 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/*  9510 */     for (int k = 0; k < j; k++) {
/*  9511 */       if (arrayOfString[k] == localObject) {
/*  9512 */         setObjectInternal(k + 1, paramObject);
/*       */ 
/*  9514 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/*  9518 */     if (i == 0)
/*       */     {
/*  9520 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/*  9521 */       localSQLException.fillInStackTrace();
/*  9522 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setObject(int paramInt1, Object paramObject, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  9548 */     setObjectInternal(paramInt1, paramObject, paramInt2, 0);
/*       */   }
/*       */ 
/*       */   void setObjectInternal(int paramInt1, Object paramObject, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  9557 */     setObjectInternal(paramInt1, paramObject, paramInt2, 0);
/*       */   }
/*       */ 
/*       */   public void setRefType(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  9578 */     setREFInternal(paramInt, paramREF);
/*       */   }
/*       */ 
/*       */   void setRefTypeInternal(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  9585 */     setREFInternal(paramInt, paramREF);
/*       */   }
/*       */ 
/*       */   public void setRef(int paramInt, Ref paramRef)
/*       */     throws SQLException
/*       */   {
/*  9607 */     setREFInternal(paramInt, (REF)paramRef);
/*       */   }
/*       */ 
/*       */   void setRefInternal(int paramInt, Ref paramRef)
/*       */     throws SQLException
/*       */   {
/*  9615 */     setREFInternal(paramInt, (REF)paramRef);
/*       */   }
/*       */ 
/*       */   public void setREF(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  9637 */     setREFInternal(paramInt, paramREF);
/*       */   }
/*       */ 
/*       */   void setREFInternal(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  9644 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/*  9646 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/*  9648 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  9649 */       localSQLException.fillInStackTrace();
/*  9650 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9653 */     if (paramREF == null)
/*       */     {
/*  9656 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9657 */       localSQLException.fillInStackTrace();
/*  9658 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9664 */     setREFCritical(i, paramREF);
/*       */ 
/*  9666 */     this.currentRowCharLens[i] = 0;
/*       */   }
/*       */ 
/*       */   void setREFCritical(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  9683 */     StructDescriptor localStructDescriptor = paramREF.getDescriptor();
/*       */ 
/*  9686 */     if (localStructDescriptor == null)
/*       */     {
/*  9688 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 52);
/*  9689 */       ((SQLException)localObject).fillInStackTrace();
/*  9690 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9694 */     this.currentRowBinders[paramInt] = this.theRefTypeBinder;
/*       */ 
/*  9696 */     if (this.parameterDatum == null)
/*       */     {
/*  9698 */       this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  9703 */     this.parameterDatum[this.currentRank][paramInt] = paramREF.getBytes();
/*       */ 
/*  9705 */     Object localObject = localStructDescriptor.getOracleTypeADT();
/*       */ 
/*  9707 */     ((OracleTypeADT)localObject).getTOID();
/*       */ 
/*  9709 */     if (this.parameterOtype == null)
/*       */     {
/*  9711 */       this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  9715 */     this.parameterOtype[this.currentRank][paramInt] = localObject;
/*  9716 */     this.currentRowByteLens[paramInt] = this.currentRowBinders[paramInt].bytelen;
/*  9717 */     this.currentRowCharLens[paramInt] = 0;
/*       */   }
/*       */ 
/*       */   public void setObject(int paramInt, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  9743 */     setObjectInternal(paramInt, paramObject);
/*       */   }
/*       */ 
/*       */   void setObjectInternal(int paramInt, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  9750 */     if ((paramObject instanceof ORAData))
/*       */     {
/*  9752 */       setORADataInternal(paramInt, (ORAData)paramObject);
/*       */     }
/*  9754 */     else if ((paramObject instanceof CustomDatum))
/*       */     {
/*  9756 */       setCustomDatumInternal(paramInt, (CustomDatum)paramObject);
/*       */     }
/*  9758 */     else if ((paramObject instanceof OracleData))
/*       */     {
/*  9760 */       setOracleDataInternal(paramInt, (OracleData)paramObject);
/*       */     }
/*       */     else
/*       */     {
/*  9764 */       int i = sqlTypeForObject(paramObject);
/*       */ 
/*  9766 */       setObjectInternal(paramInt, paramObject, i, 0);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setOracleObject(int paramInt, Datum paramDatum)
/*       */     throws SQLException
/*       */   {
/*  9789 */     setObjectInternal(paramInt, paramDatum);
/*       */   }
/*       */ 
/*       */   void setOracleObjectInternal(int paramInt, Datum paramDatum)
/*       */     throws SQLException
/*       */   {
/*  9797 */     setObjectInternal(paramInt, paramDatum);
/*       */   }
/*       */ 
/*       */   public void setPlsqlIndexTable(int paramInt1, Object paramObject, int paramInt2, int paramInt3, int paramInt4, int paramInt5)
/*       */     throws SQLException
/*       */   {
/*  9824 */     synchronized (this.connection)
/*       */     {
/*  9831 */       setPlsqlIndexTableInternal(paramInt1, paramObject, paramInt2, paramInt3, paramInt4, paramInt5);
/*       */     }
/*       */   }
/*       */ 
/*       */   void setPlsqlIndexTableInternal(int paramInt1, Object paramObject, int paramInt2, int paramInt3, int paramInt4, int paramInt5)
/*       */     throws SQLException
/*       */   {
/*  9845 */     int i = paramInt1 - 1;
/*       */     SQLException localSQLException;
/*  9847 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/*  9849 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  9850 */       localSQLException.fillInStackTrace();
/*  9851 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9854 */     if (paramObject == null)
/*       */     {
/*  9856 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 271);
/*  9857 */       localSQLException.fillInStackTrace();
/*  9858 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9863 */     int j = getInternalType(paramInt4);
/*       */ 
/*  9865 */     Object localObject1 = null;
/*       */     Object localObject2;
/*  9868 */     switch (j)
/*       */     {
/*       */     case 1:
/*       */     case 96:
/*  9875 */       localObject2 = null;
/*  9876 */       int k = 0;
/*       */       Object localObject3;
/*  9879 */       if ((paramObject instanceof CHAR[]))
/*       */       {
/*  9881 */         localObject3 = (CHAR[])paramObject;
/*  9882 */         k = localObject3.length;
/*       */ 
/*  9884 */         localObject2 = new String[k];
/*       */ 
/*  9886 */         for (int n = 0; n < k; n++)
/*       */         {
/*  9888 */           Object localObject5 = localObject3[n];
/*  9889 */           if (localObject5 != null)
/*  9890 */             localObject2[n] = localObject5.getString();
/*       */         }
/*       */       }
/*  9893 */       else if ((paramObject instanceof String[]))
/*       */       {
/*  9895 */         localObject2 = (String[])paramObject;
/*  9896 */         k = localObject2.length;
/*       */       }
/*       */       else {
/*  9899 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/*  9900 */         ((SQLException)localObject3).fillInStackTrace();
/*  9901 */         throw ((Throwable)localObject3);
/*       */       }
/*       */ 
/*  9905 */       if ((paramInt5 == 0) && (localObject2 != null)) {
/*  9906 */         for (int m = 0; m < k; m++)
/*       */         {
/*  9908 */           Object localObject4 = localObject2[m];
/*  9909 */           if ((localObject4 != null) && (paramInt5 < localObject4.length()))
/*  9910 */             paramInt5 = localObject4.length();
/*       */         }
/*       */       }
/*  9913 */       localObject1 = localObject2;
/*       */ 
/*  9915 */       break;
/*       */     case 2:
/*       */     case 6:
/*  9922 */       localObject1 = OracleTypeNUMBER.toNUMBERArray(paramObject, this.connection, 1L, paramInt3);
/*       */ 
/*  9925 */       if ((paramInt5 == 0) && (localObject1 != null))
/*       */       {
/*  9927 */         paramInt5 = 22;
/*       */       }
/*       */ 
/*  9930 */       this.currentRowCharLens[i] = 0;
/*       */ 
/*  9932 */       break;
/*       */     default:
/*  9951 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 97);
/*  9952 */       ((SQLException)localObject2).fillInStackTrace();
/*  9953 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  9957 */     if ((localObject1.length == 0) && (paramInt2 == 0))
/*       */     {
/*  9959 */       localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 272);
/*  9960 */       ((SQLException)localObject2).fillInStackTrace();
/*  9961 */       throw ((Throwable)localObject2);
/*       */     }
/*       */ 
/*  9964 */     this.currentRowBinders[i] = this.thePlsqlIbtBinder;
/*  9965 */     this.currentRowByteLens[i] = this.currentRowBinders[i].bytelen;
/*  9966 */     this.currentRowCharLens[i] = 0;
/*       */ 
/*  9968 */     if (this.parameterPlsqlIbt == null) {
/*  9969 */       this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */     }
/*       */ 
/*  9972 */     this.parameterPlsqlIbt[this.currentRank][i] = new PlsqlIbtBindInfo(this, (Object[])localObject1, paramInt2, paramInt3, j, paramInt5);
/*       */ 
/*  9980 */     this.hasIbtBind = true;
/*       */   }
/*       */ 
/*       */   public void setPlsqlIndexTableAtName(String paramString, Object paramObject, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/* 10004 */     synchronized (this.connection)
/*       */     {
/* 10012 */       if (paramString == null)
/*       */       {
/* 10014 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 10015 */         ((SQLException)localObject1).fillInStackTrace();
/* 10016 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/* 10021 */       Object localObject1 = paramString.intern();
/* 10022 */       String[] arrayOfString = this.sqlObject.getParameterList();
/* 10023 */       int i = 0;
/* 10024 */       int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 10026 */       for (int k = 0; k < j; k++) {
/* 10027 */         if (arrayOfString[k] == localObject1) {
/* 10028 */           setPlsqlIndexTableInternal(k + 1, paramObject, paramInt1, paramInt2, paramInt3, paramInt4);
/*       */ 
/* 10031 */           i = 1;
/*       */         }
/*       */       }
/*       */ 
/* 10035 */       if (i == 0)
/*       */       {
/* 10037 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 10038 */         localSQLException.fillInStackTrace();
/* 10039 */         throw localSQLException;
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void endOfResultSet(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10062 */     if (!paramBoolean)
/*       */     {
/* 10065 */       prepareForNewResults(false, false, false);
/*       */     }
/* 10067 */     this.rowPrefetchInLastFetch = -1;
/*       */   }
/*       */ 
/*       */   int sqlTypeForObject(Object paramObject)
/*       */   {
/* 10079 */     if (paramObject == null)
/*       */     {
/* 10081 */       return 0;
/*       */     }
/*       */ 
/* 10084 */     if (!(paramObject instanceof Datum))
/*       */     {
/* 10086 */       if ((paramObject instanceof String))
/*       */       {
/* 10089 */         return this.fixedString ? 999 : 12;
/*       */       }
/* 10091 */       if ((paramObject instanceof BigDecimal)) {
/* 10092 */         return 2;
/*       */       }
/* 10094 */       if ((paramObject instanceof BigInteger)) {
/* 10095 */         return 2;
/*       */       }
/* 10097 */       if ((paramObject instanceof Boolean)) {
/* 10098 */         return -7;
/*       */       }
/* 10100 */       if ((paramObject instanceof Integer)) {
/* 10101 */         return 4;
/*       */       }
/* 10103 */       if ((paramObject instanceof Long)) {
/* 10104 */         return -5;
/*       */       }
/* 10106 */       if ((paramObject instanceof Float)) {
/* 10107 */         return 7;
/*       */       }
/* 10109 */       if ((paramObject instanceof Double)) {
/* 10110 */         return 8;
/*       */       }
/* 10112 */       if ((paramObject instanceof byte[])) {
/* 10113 */         return -3;
/*       */       }
/*       */ 
/* 10117 */       if ((paramObject instanceof Short)) {
/* 10118 */         return 5;
/*       */       }
/* 10120 */       if ((paramObject instanceof Byte)) {
/* 10121 */         return -6;
/*       */       }
/* 10123 */       if ((paramObject instanceof Date)) {
/* 10124 */         return 91;
/*       */       }
/* 10126 */       if ((paramObject instanceof Time)) {
/* 10127 */         return 92;
/*       */       }
/* 10129 */       if ((paramObject instanceof Timestamp)) {
/* 10130 */         return 93;
/*       */       }
/* 10132 */       if ((paramObject instanceof SQLData)) {
/* 10133 */         return 2002;
/*       */       }
/* 10135 */       if ((paramObject instanceof ObjectData)) {
/* 10136 */         return 2002;
/*       */       }
/* 10138 */       if ((paramObject instanceof URL))
/* 10139 */         return this.fixedString ? 999 : 12;
/*       */     }
/*       */     else
/*       */     {
/* 10143 */       if ((paramObject instanceof BINARY_FLOAT)) {
/* 10144 */         return 100;
/*       */       }
/* 10146 */       if ((paramObject instanceof BINARY_DOUBLE)) {
/* 10147 */         return 101;
/*       */       }
/* 10149 */       if ((paramObject instanceof BLOB)) {
/* 10150 */         return 2004;
/*       */       }
/* 10152 */       if ((paramObject instanceof CLOB)) {
/* 10153 */         return 2005;
/*       */       }
/* 10155 */       if ((paramObject instanceof BFILE)) {
/* 10156 */         return -13;
/*       */       }
/* 10158 */       if ((paramObject instanceof ROWID)) {
/* 10159 */         return -8;
/*       */       }
/* 10161 */       if ((paramObject instanceof NUMBER)) {
/* 10162 */         return 2;
/*       */       }
/* 10164 */       if ((paramObject instanceof DATE)) {
/* 10165 */         return 91;
/*       */       }
/* 10167 */       if ((paramObject instanceof TIMESTAMP)) {
/* 10168 */         return 93;
/*       */       }
/* 10170 */       if ((paramObject instanceof TIMESTAMPTZ)) {
/* 10171 */         return -101;
/*       */       }
/* 10173 */       if ((paramObject instanceof TIMESTAMPLTZ)) {
/* 10174 */         return -102;
/*       */       }
/* 10176 */       if ((paramObject instanceof REF)) {
/* 10177 */         return 2006;
/*       */       }
/* 10179 */       if ((paramObject instanceof CHAR)) {
/* 10180 */         return 1;
/*       */       }
/* 10182 */       if ((paramObject instanceof RAW)) {
/* 10183 */         return -2;
/*       */       }
/* 10185 */       if ((paramObject instanceof ARRAY)) {
/* 10186 */         return 2003;
/*       */       }
/* 10188 */       if ((paramObject instanceof STRUCT)) {
/* 10189 */         return 2002;
/*       */       }
/* 10191 */       if ((paramObject instanceof OPAQUE)) {
/* 10192 */         return 2007;
/*       */       }
/* 10194 */       if ((paramObject instanceof INTERVALYM)) {
/* 10195 */         return -103;
/*       */       }
/* 10197 */       if ((paramObject instanceof INTERVALDS)) {
/* 10198 */         return -104;
/*       */       }
/* 10200 */       if ((paramObject instanceof SQLXML)) {
/* 10201 */         return 2009;
/*       */       }
/*       */     }
/* 10204 */     return 1111;
/*       */   }
/*       */ 
/*       */   public void clearParameters()
/*       */     throws SQLException
/*       */   {
/* 10217 */     synchronized (this.connection)
/*       */     {
/* 10227 */       this.clearParameters = true;
/*       */ 
/* 10229 */       for (int i = 0; i < this.numberOfBindPositions; i++)
/* 10230 */         this.currentRowBinders[i] = null;
/*       */     }
/*       */   }
/*       */ 
/*       */   void printByteArray(byte[] paramArrayOfByte)
/*       */   {
/* 10241 */     if (paramArrayOfByte != null)
/*       */     {
/* 10248 */       int j = paramArrayOfByte.length;
/*       */ 
/* 10250 */       for (int i = 0; i < j; i++)
/*       */       {
/* 10252 */         int k = paramArrayOfByte[i] & 0xFF;
/*       */ 
/* 10254 */         if (k >= 16);
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*       */     throws SQLException
/*       */   {
/* 10306 */     setCharacterStreamInternal(paramInt1, paramReader, paramInt2);
/*       */   }
/*       */ 
/*       */   void setCharacterStreamInternal(int paramInt1, Reader paramReader, int paramInt2)
/*       */     throws SQLException
/*       */   {
/* 10320 */     setCharacterStreamInternal(paramInt1, paramReader, paramInt2, true);
/*       */   }
/*       */ 
/*       */   void setCharacterStreamInternal(int paramInt, Reader paramReader, long paramLong, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10328 */     int i = paramInt - 1;
/*       */     SQLException localSQLException;
/* 10330 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/* 10332 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 10333 */       localSQLException.fillInStackTrace();
/* 10334 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10340 */     set_execute_batch(1);
/* 10341 */     checkUserStreamForDuplicates(paramReader, i);
/* 10342 */     if (paramReader == null) {
/* 10343 */       basicBindNullString(paramInt); } else {
/* 10344 */       if ((this.userRsetType != DEFAULT_RESULT_SET_TYPE) && ((paramLong > this.maxVcsCharsSql) || (!paramBoolean)))
/*       */       {
/* 10346 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 169);
/* 10347 */         localSQLException.fillInStackTrace();
/* 10348 */         throw localSQLException;
/*       */       }
/* 10350 */       if (!paramBoolean)
/*       */       {
/* 10352 */         setReaderContentsForClobCritical(paramInt, paramReader, paramLong, paramBoolean);
/*       */       }
/* 10354 */       else if (this.currentRowFormOfUse[i] == 1)
/*       */       {
/* 10356 */         if (this.sqlKind.isPlsqlOrCall())
/*       */         {
/* 10358 */           if ((paramLong > this.maxVcsBytesPlsql) || ((paramLong > this.maxVcsCharsPlsql) && (this.isServerCharSetFixedWidth)))
/*       */           {
/* 10361 */             setReaderContentsForClobCritical(paramInt, paramReader, paramLong, paramBoolean);
/*       */           }
/* 10363 */           else if (paramLong <= this.maxVcsCharsPlsql)
/*       */           {
/* 10365 */             setReaderContentsForStringInternal(paramInt, paramReader, (int)paramLong);
/*       */           }
/*       */           else
/*       */           {
/* 10372 */             setReaderContentsForStringOrClobInVariableWidthCase(paramInt, paramReader, (int)paramLong, false);
/*       */           }
/*       */ 
/*       */         }
/* 10377 */         else if (paramLong <= this.maxVcsCharsSql)
/*       */         {
/* 10379 */           setReaderContentsForStringInternal(paramInt, paramReader, (int)paramLong);
/*       */         }
/* 10381 */         else if (paramLong > 2147483647L)
/*       */         {
/* 10383 */           setReaderContentsForClobCritical(paramInt, paramReader, paramLong, paramBoolean);
/*       */         }
/*       */         else
/*       */         {
/* 10387 */           basicBindCharacterStream(paramInt, paramReader, (int)paramLong, false);
/*       */         }
/*       */ 
/*       */       }
/* 10393 */       else if (this.sqlKind.isPlsqlOrCall())
/*       */       {
/* 10395 */         if ((paramLong > this.maxVcsBytesPlsql) || ((paramLong > this.maxVcsNCharsPlsql) && (this.isServerCharSetFixedWidth)))
/*       */         {
/* 10398 */           setReaderContentsForClobCritical(paramInt, paramReader, paramLong, paramBoolean);
/*       */         }
/* 10400 */         else if (paramLong <= this.maxVcsNCharsPlsql)
/*       */         {
/* 10402 */           setReaderContentsForStringInternal(paramInt, paramReader, (int)paramLong);
/*       */         }
/*       */         else
/*       */         {
/* 10406 */           setReaderContentsForStringOrClobInVariableWidthCase(paramInt, paramReader, (int)paramLong, true);
/*       */         }
/*       */ 
/*       */       }
/* 10411 */       else if (paramLong <= this.maxVcsNCharsSql)
/*       */       {
/* 10413 */         setReaderContentsForStringInternal(paramInt, paramReader, (int)paramLong);
/*       */       }
/*       */       else
/*       */       {
/* 10417 */         setReaderContentsForClobCritical(paramInt, paramReader, paramLong, paramBoolean);
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   void basicBindCharacterStream(int paramInt1, Reader paramReader, int paramInt2, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10428 */     synchronized (this.connection)
/*       */     {
/* 10430 */       int i = paramInt1 - 1;
/* 10431 */       if (paramBoolean)
/* 10432 */         this.currentRowBinders[i] = this.theLongStreamForStringBinder;
/*       */       else
/* 10434 */         this.currentRowBinders[i] = this.theLongStreamBinder;
/* 10435 */       if (this.parameterStream == null) {
/* 10436 */         this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
/*       */       }
/* 10438 */       this.parameterStream[this.currentRank][i] = (paramBoolean ? this.connection.conversion.ConvertStreamInternal(paramReader, 7, paramInt2, this.currentRowFormOfUse[i]) : this.connection.conversion.ConvertStream(paramReader, 7, paramInt2, this.currentRowFormOfUse[i]));
/*       */ 
/* 10445 */       this.currentRowByteLens[i] = 0;
/* 10446 */       this.currentRowCharLens[i] = 0;
/*       */     }
/*       */   }
/*       */ 
/*       */   void setReaderContentsForStringOrClobInVariableWidthCase(int paramInt1, Reader paramReader, int paramInt2, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10466 */     Object localObject = new char[paramInt2];
/* 10467 */     int i = 0;
/* 10468 */     int j = paramInt2;
/*       */     try
/*       */     {
/*       */       int k;
/* 10475 */       while ((j > 0) && ((k = paramReader.read((char[])localObject, i, j)) != -1))
/*       */       {
/* 10477 */         i += k;
/* 10478 */         j -= k;
/*       */       }
/*       */ 
/*       */     }
/*       */     catch (IOException localIOException)
/*       */     {
/* 10484 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 10485 */       localSQLException.fillInStackTrace();
/* 10486 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10490 */     if (i != paramInt2)
/*       */     {
/* 10492 */       char[] arrayOfChar = new char[i];
/*       */ 
/* 10494 */       System.arraycopy(localObject, 0, arrayOfChar, 0, i);
/*       */ 
/* 10496 */       localObject = arrayOfChar;
/*       */     }
/* 10498 */     int m = this.connection.conversion.encodedByteLength((char[])localObject, paramBoolean);
/*       */ 
/* 10500 */     if (m < this.maxVcsBytesPlsql)
/*       */     {
/* 10502 */       setStringInternal(paramInt1, new String((char[])localObject));
/*       */     }
/*       */     else
/*       */     {
/* 10506 */       setStringForClobCritical(paramInt1, new String((char[])localObject));
/*       */     }
/*       */   }
/*       */ 
/*       */   void setReaderContentsForStringInternal(int paramInt1, Reader paramReader, int paramInt2)
/*       */     throws SQLException
/*       */   {
/* 10516 */     Object localObject = new char[paramInt2];
/* 10517 */     int i = 0;
/* 10518 */     int j = paramInt2;
/*       */     try
/*       */     {
/*       */       int k;
/* 10525 */       while ((j > 0) && ((k = paramReader.read((char[])localObject, i, j)) != -1))
/*       */       {
/* 10527 */         i += k;
/* 10528 */         j -= k;
/*       */       }
/*       */ 
/*       */     }
/*       */     catch (IOException localIOException)
/*       */     {
/* 10534 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 10535 */       localSQLException.fillInStackTrace();
/* 10536 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10540 */     if (i != paramInt2)
/*       */     {
/* 10542 */       char[] arrayOfChar = new char[i];
/*       */ 
/* 10544 */       System.arraycopy(localObject, 0, arrayOfChar, 0, i);
/*       */ 
/* 10546 */       localObject = arrayOfChar;
/*       */     }
/* 10548 */     setStringInternal(paramInt1, new String((char[])localObject));
/*       */   }
/*       */ 
/*       */   public void setDate(int paramInt, Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10571 */     setDATEInternal(paramInt, paramDate == null ? null : new DATE(paramDate, paramCalendar));
/*       */   }
/*       */ 
/*       */   void setDateInternal(int paramInt, Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10579 */     setDATEInternal(paramInt, paramDate == null ? null : new DATE(paramDate, paramCalendar));
/*       */   }
/*       */ 
/*       */   public void setTime(int paramInt, Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10601 */     setDATEInternal(paramInt, paramTime == null ? null : new DATE(paramTime, paramCalendar));
/*       */   }
/*       */ 
/*       */   void setTimeInternal(int paramInt, Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10609 */     setDATEInternal(paramInt, paramTime == null ? null : new DATE(paramTime, paramCalendar));
/*       */   }
/*       */ 
/*       */   public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10631 */     setTimestampInternal(paramInt, paramTimestamp, paramCalendar);
/*       */   }
/*       */ 
/*       */   void setTimestampInternal(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 10639 */     setTIMESTAMPInternal(paramInt, paramTimestamp == null ? null : new TIMESTAMP(paramTimestamp, paramCalendar));
/*       */   }
/*       */ 
/*       */   public void setCheckBindTypes(boolean paramBoolean)
/*       */   {
/* 10656 */     this.checkBindTypes = paramBoolean;
/*       */   }
/*       */ 
/*       */   final void setOracleBatchStyle()
/*       */     throws SQLException
/*       */   {
/* 10696 */     if (this.m_batchStyle == 2)
/*       */     {
/* 10699 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "operation cannot be mixed with JDBC-2.0-style batching");
/* 10700 */       localSQLException.fillInStackTrace();
/* 10701 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10704 */     if (this.m_batchStyle == 0);
/* 10709 */     this.m_batchStyle = 1;
/*       */   }
/*       */ 
/*       */   boolean isOracleBatchStyle()
/*       */   {
/* 10716 */     return this.m_batchStyle == 1;
/*       */   }
/*       */ 
/*       */   final void setJdbcBatchStyle()
/*       */     throws SQLException
/*       */   {
/* 10729 */     if (this.m_batchStyle == 1)
/*       */     {
/* 10732 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "operation cannot be mixed with Oracle-style batching");
/* 10733 */       localSQLException.fillInStackTrace();
/* 10734 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10738 */     this.m_batchStyle = 2;
/*       */   }
/*       */ 
/*       */   final void checkIfJdbcBatchExists()
/*       */     throws SQLException
/*       */   {
/* 10754 */     if (doesJdbcBatchExist())
/*       */     {
/* 10757 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
/* 10758 */       localSQLException.fillInStackTrace();
/* 10759 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   boolean doesJdbcBatchExist()
/*       */   {
/* 10768 */     if ((this.currentRank > 0) && (this.m_batchStyle == 2)) {
/* 10769 */       return true;
/*       */     }
/* 10771 */     return false;
/*       */   }
/*       */ 
/*       */   boolean isJdbcBatchStyle()
/*       */   {
/* 10778 */     return this.m_batchStyle == 2;
/*       */   }
/*       */ 
/*       */   boolean isBatchStyleSet()
/*       */   {
/* 10785 */     return this.m_batchStyle != 0;
/*       */   }
/*       */ 
/*       */   public void addBatch()
/*       */     throws SQLException
/*       */   {
/* 10806 */     synchronized (this.connection)
/*       */     {
/* 10826 */       setJdbcBatchStyle();
/*       */ 
/* 10836 */       processCompletedBindRow(this.currentRank + 2, (this.currentRank > 0) && (this.sqlKind.isPlsqlOrCall()));
/*       */ 
/* 10840 */       this.currentRank += 1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void addBatch(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10850 */     synchronized (this.connection)
/*       */     {
/* 10858 */       SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 10859 */       localSQLException.fillInStackTrace();
/* 10860 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void clearBatch()
/*       */     throws SQLException
/*       */   {
/* 10879 */     synchronized (this.connection)
/*       */     {
/* 10886 */       for (int i = this.currentRank - 1; i >= 0; i--) {
/* 10887 */         for (int j = 0; j < this.numberOfBindPositions; j++)
/* 10888 */           this.binders[i][j] = null;
/*       */       }
/* 10890 */       this.currentRank = 0;
/*       */ 
/* 10892 */       this.pushedBatches = null;
/* 10893 */       this.pushedBatchesTail = null;
/* 10894 */       this.firstRowInBatch = 0;
/* 10895 */       this.currentBatchAccumulatedBindsSize = 0;
/*       */ 
/* 10897 */       releaseBuffers();
/* 10898 */       if (this.binders != null)
/* 10899 */         this.currentRowBinders = this.binders[0];
/*       */     }
/*       */   }
/*       */ 
/*       */   void executeForRowsWithTimeout(boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 10913 */     if (this.queryTimeout > 0)
/*       */     {
/*       */       try
/*       */       {
/* 10917 */         this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
/* 10918 */         this.cancelLock.enterExecuting();
/* 10919 */         executeForRows(paramBoolean);
/*       */       }
/*       */       finally
/*       */       {
/* 10923 */         this.connection.getTimeout().cancelTimeout();
/* 10924 */         this.cancelLock.exitExecuting();
/*       */       }
/*       */     }
/*       */     else
/*       */     {
/*       */       try
/*       */       {
/* 10931 */         this.cancelLock.enterExecuting();
/* 10932 */         executeForRows(paramBoolean);
/*       */       }
/*       */       finally
/*       */       {
/* 10936 */         this.cancelLock.exitExecuting();
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   public int[] executeBatch()
/*       */     throws SQLException
/*       */   {
/* 10963 */     synchronized (this.connection)
/*       */     {
/* 10971 */       Object localObject1 = new int[this.currentRank];
/* 10972 */       this.checkSum = 0L;
/* 10973 */       this.checkSumComputationFailure = false;
/*       */ 
/* 10979 */       int i = 0;
/*       */ 
/* 10981 */       cleanOldTempLobs();
/* 10982 */       setJdbcBatchStyle();
/*       */ 
/* 10984 */       if (this.currentRank > 0)
/*       */       {
/* 10988 */         ensureOpen();
/*       */ 
/* 10991 */         prepareForNewResults(true, true, true);
/*       */ 
/* 10993 */         if (this.sqlKind.isSELECT())
/*       */         {
/* 10996 */           BatchUpdateException localBatchUpdateException1 = DatabaseError.createBatchUpdateException(80, 0, null);
/* 10997 */           localBatchUpdateException1.fillInStackTrace();
/* 10998 */           throw localBatchUpdateException1;
/*       */         }
/*       */ 
/* 11003 */         this.noMoreUpdateCounts = false;
/*       */ 
/* 11005 */         int j = 0;
/*       */         try
/*       */         {
/* 11017 */           this.connection.registerHeartbeat();
/*       */ 
/* 11019 */           this.connection.needLine();
/*       */ 
/* 11025 */           if (!this.isOpen)
/*       */           {
/* 11027 */             this.connection.open(this);
/*       */ 
/* 11029 */             this.isOpen = true;
/*       */           }
/*       */ 
/* 11035 */           int k = this.currentRank;
/*       */ 
/* 11037 */           if (this.pushedBatches == null)
/*       */           {
/* 11042 */             setupBindBuffers(0, this.currentRank);
/* 11043 */             executeForRowsWithTimeout(false);
/*       */ 
/* 11045 */             j = this.validRows;
/*       */ 
/* 11047 */             if (this.batchRowsUpdatedArray != null)
/*       */             {
/* 11049 */               assert (localObject1.length == this.batchRowsUpdatedArray.length);
/* 11050 */               localObject1 = this.batchRowsUpdatedArray;
/*       */             }
/*       */             else
/*       */             {
/* 11054 */               for (i = 0; i < localObject1.length; i++)
/*       */               {
/* 11056 */                 localObject1[i] = -2;
/*       */               }
/*       */ 
/*       */             }
/*       */ 
/*       */           }
/*       */           else
/*       */           {
/* 11066 */             if (this.currentRank > this.firstRowInBatch)
/*       */             {
/* 11070 */               pushBatch(true);
/*       */             }
/* 11072 */             boolean bool = this.needToParse;
/*       */             do
/*       */             {
/* 11080 */               PushedBatch localPushedBatch = this.pushedBatches;
/*       */ 
/* 11082 */               this.currentBatchByteLens = localPushedBatch.currentBatchByteLens;
/* 11083 */               this.lastBoundByteLens = localPushedBatch.lastBoundByteLens;
/* 11084 */               this.currentBatchCharLens = localPushedBatch.currentBatchCharLens;
/* 11085 */               this.lastBoundCharLens = localPushedBatch.lastBoundCharLens;
/* 11086 */               this.lastBoundNeeded = localPushedBatch.lastBoundNeeded;
/* 11087 */               this.currentBatchBindAccessors = localPushedBatch.currentBatchBindAccessors;
/* 11088 */               this.needToParse = localPushedBatch.need_to_parse;
/* 11089 */               this.currentBatchNeedToPrepareBinds = localPushedBatch.current_batch_need_to_prepare_binds;
/*       */ 
/* 11091 */               this.firstRowInBatch = localPushedBatch.first_row_in_batch;
/*       */ 
/* 11093 */               setupBindBuffers(localPushedBatch.first_row_in_batch, localPushedBatch.number_of_rows_to_be_bound);
/*       */ 
/* 11098 */               this.currentRank = localPushedBatch.number_of_rows_to_be_bound;
/*       */ 
/* 11100 */               executeForRowsWithTimeout(false);
/*       */ 
/* 11102 */               j += this.validRows;
/*       */ 
/* 11104 */               if (this.batchRowsUpdatedArray != null)
/*       */               {
/* 11106 */                 assert (this.batchRowsUpdatedArray.length == this.currentRank);
/* 11107 */                 System.arraycopy(this.batchRowsUpdatedArray, 0, localObject1, this.firstRowInBatch, this.currentRank);
/*       */               }
/* 11111 */               else if (this.sqlKind.isPlsqlOrCall())
/*       */               {
/* 11113 */                 localObject1[(i++)] = this.validRows;
/*       */               }
/*       */               else
/*       */               {
/* 11117 */                 for (int m = 0; m < this.currentRank; m++)
/*       */                 {
/* 11119 */                   localObject1[(this.firstRowInBatch + m)] = -2;
/*       */                 }
/*       */ 
/*       */               }
/*       */ 
/* 11124 */               this.pushedBatches = localPushedBatch.next;
/*       */             }
/*       */ 
/* 11127 */             while (this.pushedBatches != null);
/*       */ 
/* 11130 */             this.pushedBatchesTail = null;
/* 11131 */             this.firstRowInBatch = 0;
/*       */ 
/* 11133 */             this.needToParse = bool;
/*       */           }
/*       */ 
/* 11138 */           slideDownCurrentRow(k);
/*       */         }
/*       */         catch (SQLException localSQLException)
/*       */         {
/* 11145 */           this.needToParse = true;
/*       */ 
/* 11147 */           if (!this.sqlKind.isPlsqlOrCall())
/*       */           {
/* 11150 */             if (this.batchRowsUpdatedArray != null)
/*       */             {
/* 11152 */               if (this.firstRowInBatch == 0)
/*       */               {
/* 11154 */                 localObject1 = this.batchRowsUpdatedArray;
/*       */               }
/*       */               else
/*       */               {
/* 11158 */                 localObject2 = new int[this.firstRowInBatch + this.batchRowsUpdatedArray.length];
/* 11159 */                 System.arraycopy(localObject1, 0, localObject2, 0, this.firstRowInBatch);
/* 11160 */                 System.arraycopy(this.batchRowsUpdatedArray, 0, localObject2, this.firstRowInBatch, this.batchRowsUpdatedArray.length);
/* 11161 */                 localObject1 = localObject2;
/*       */               }
/*       */ 
/*       */             }
/* 11170 */             else if ((this.numberOfExecutedElementsInBatch != -1) && (this.numberOfExecutedElementsInBatch != this.currentRank))
/*       */             {
/* 11175 */               localObject1 = new int[this.numberOfExecutedElementsInBatch];
/* 11176 */               for (i = 0; i < this.numberOfExecutedElementsInBatch; ) {
/* 11177 */                 localObject1[i] = -2;
/*       */ 
/* 11176 */                 i++; continue;
/*       */ 
/* 11180 */                 for (i = 0; i < localObject1.length; i++)
/* 11181 */                   localObject1[i] = -3;
/*       */               }
/*       */             }
/*       */           }
/* 11185 */           clearBatch();
/* 11186 */           resetCurrentRowBinders();
/*       */ 
/* 11189 */           Object localObject2 = DatabaseError.createBatchUpdateException(localSQLException, this.sqlKind.isPlsqlOrCall() ? i : localObject1.length, (int[])localObject1);
/* 11190 */           ((BatchUpdateException)localObject2).fillInStackTrace();
/* 11191 */           throw ((Throwable)localObject2);
/*       */         }
/*       */         finally
/*       */         {
/* 11196 */           if ((this.sqlKind.isPlsqlOrCall()) || (j > this.validRows)) {
/* 11197 */             this.validRows = j;
/*       */           }
/* 11199 */           checkValidRowsStatus();
/* 11200 */           this.currentBatchAccumulatedBindsSize = 0;
/* 11201 */           this.currentRank = 0;
/*       */         }
/*       */ 
/* 11204 */         if (this.validRows < 0)
/*       */         {
/* 11206 */           for (i = 0; i < localObject1.length; i++) {
/* 11207 */             localObject1[i] = -3;
/*       */           }
/*       */ 
/* 11210 */           BatchUpdateException localBatchUpdateException2 = DatabaseError.createBatchUpdateException(81, 0, (int[])localObject1);
/* 11211 */           localBatchUpdateException2.fillInStackTrace();
/* 11212 */           throw localBatchUpdateException2;
/*       */         }
/*       */ 
/*       */       }
/*       */ 
/* 11221 */       this.connection.registerHeartbeat();
/*       */ 
/* 11227 */       return localObject1;
/*       */     }
/*       */   }
/*       */ 
/*       */   void pushBatch(boolean paramBoolean)
/*       */   {
/* 11237 */     PushedBatch localPushedBatch = new PushedBatch();
/*       */ 
/* 11239 */     localPushedBatch.currentBatchByteLens = new int[this.numberOfBindPositions];
/*       */ 
/* 11241 */     System.arraycopy(this.currentBatchByteLens, 0, localPushedBatch.currentBatchByteLens, 0, this.numberOfBindPositions);
/*       */ 
/* 11244 */     localPushedBatch.currentBatchCharLens = new int[this.numberOfBindPositions];
/*       */ 
/* 11246 */     System.arraycopy(this.currentBatchCharLens, 0, localPushedBatch.currentBatchCharLens, 0, this.numberOfBindPositions);
/*       */ 
/* 11249 */     localPushedBatch.lastBoundByteLens = new int[this.numberOfBindPositions];
/*       */ 
/* 11251 */     System.arraycopy(this.lastBoundByteLens, 0, localPushedBatch.lastBoundByteLens, 0, this.numberOfBindPositions);
/*       */ 
/* 11254 */     localPushedBatch.lastBoundCharLens = new int[this.numberOfBindPositions];
/*       */ 
/* 11256 */     System.arraycopy(this.lastBoundCharLens, 0, localPushedBatch.lastBoundCharLens, 0, this.numberOfBindPositions);
/*       */ 
/* 11259 */     if (this.currentBatchBindAccessors != null)
/*       */     {
/* 11261 */       localPushedBatch.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
/*       */ 
/* 11263 */       System.arraycopy(this.currentBatchBindAccessors, 0, localPushedBatch.currentBatchBindAccessors, 0, this.numberOfBindPositions);
/*       */     }
/*       */ 
/* 11267 */     localPushedBatch.lastBoundNeeded = this.lastBoundNeeded;
/* 11268 */     localPushedBatch.need_to_parse = this.needToParse;
/* 11269 */     localPushedBatch.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
/* 11270 */     localPushedBatch.first_row_in_batch = this.firstRowInBatch;
/* 11271 */     localPushedBatch.number_of_rows_to_be_bound = (this.currentRank - this.firstRowInBatch);
/*       */ 
/* 11273 */     if (this.pushedBatches == null)
/* 11274 */       this.pushedBatches = localPushedBatch;
/*       */     else {
/* 11276 */       this.pushedBatchesTail.next = localPushedBatch;
/*       */     }
/* 11278 */     this.pushedBatchesTail = localPushedBatch;
/*       */ 
/* 11280 */     this.currentBatchAccumulatedBindsSize = 0;
/*       */ 
/* 11282 */     if (!paramBoolean)
/*       */     {
/* 11288 */       int[] arrayOfInt = this.currentBatchByteLens;
/*       */ 
/* 11290 */       this.currentBatchByteLens = this.lastBoundByteLens;
/* 11291 */       this.lastBoundByteLens = arrayOfInt;
/*       */ 
/* 11293 */       for (int i = 0; i < this.numberOfBindPositions; i++) {
/* 11294 */         this.currentBatchByteLens[i] = 0;
/*       */       }
/* 11296 */       arrayOfInt = this.currentBatchCharLens;
/*       */ 
/* 11298 */       this.currentBatchCharLens = this.lastBoundCharLens;
/* 11299 */       this.lastBoundCharLens = arrayOfInt;
/*       */ 
/* 11301 */       for (i = 0; i < this.numberOfBindPositions; i++) {
/* 11302 */         this.currentBatchCharLens[i] = 0;
/*       */       }
/* 11304 */       this.lastBoundNeeded = false;
/*       */ 
/* 11306 */       this.firstRowInBatch = this.currentRank;
/*       */     }
/*       */   }
/*       */ 
/*       */   int doScrollPstmtExecuteUpdate()
/*       */     throws SQLException
/*       */   {
/* 11314 */     doScrollExecuteCommon();
/*       */ 
/* 11316 */     if (this.sqlKind.isSELECT()) {
/* 11317 */       this.scrollRsetTypeSolved = true;
/*       */     }
/* 11319 */     return this.validRows;
/*       */   }
/*       */ 
/*       */   public int copyBinds(Statement paramStatement, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 11334 */     if (this.numberOfBindPositions > 0)
/*       */     {
/* 11336 */       OraclePreparedStatement localOraclePreparedStatement = (OraclePreparedStatement)paramStatement;
/*       */ 
/* 11338 */       int i = this.bindIndicatorSubRange + 5;
/*       */ 
/* 11340 */       int j = this.bindByteSubRange;
/* 11341 */       int k = this.bindCharSubRange;
/* 11342 */       int m = this.indicatorsOffset;
/* 11343 */       int n = this.valueLengthsOffset;
/*       */ 
/* 11345 */       for (int i1 = 0; i1 < this.numberOfBindPositions; i1++)
/*       */       {
/* 11347 */         short s = this.bindIndicators[(i + 0)];
/*       */ 
/* 11349 */         int i2 = this.bindIndicators[(i + 1)];
/*       */ 
/* 11351 */         int i3 = this.bindIndicators[(i + 2)];
/*       */ 
/* 11354 */         int i4 = i1 + paramInt;
/*       */ 
/* 11358 */         if (localOraclePreparedStatement.parameterDatum == null) {
/* 11359 */           localOraclePreparedStatement.parameterDatum = new byte[localOraclePreparedStatement.numberOfBindRowsAllocated][localOraclePreparedStatement.numberOfBindPositions];
/*       */         }
/*       */ 
/* 11362 */         if (localOraclePreparedStatement.parameterOtype == null) {
/* 11363 */           localOraclePreparedStatement.parameterOtype = new OracleTypeADT[localOraclePreparedStatement.numberOfBindRowsAllocated][localOraclePreparedStatement.numberOfBindPositions];
/*       */         }
/*       */ 
/* 11366 */         if (this.bindIndicators[m] == -1)
/*       */         {
/* 11368 */           localOraclePreparedStatement.currentRowBinders[i4] = copiedNullBinder(s, i2);
/*       */ 
/* 11370 */           if (i3 > 0)
/* 11371 */             localOraclePreparedStatement.currentRowCharLens[i4] = 1;
/*       */         }
/*       */         else
/*       */         {
/*       */           Object localObject;
/* 11373 */           if ((s == 109) || (s == 111))
/*       */           {
/* 11375 */             localOraclePreparedStatement.currentRowBinders[i4] = (s == 109 ? this.theNamedTypeBinder : this.theRefTypeBinder);
/*       */ 
/* 11380 */             localObject = this.parameterDatum[0][i1];
/* 11381 */             int i5 = localObject.length;
/* 11382 */             byte[] arrayOfByte = new byte[i5];
/*       */ 
/* 11384 */             localOraclePreparedStatement.parameterDatum[0][i4] = arrayOfByte;
/*       */ 
/* 11386 */             System.arraycopy(localObject, 0, arrayOfByte, 0, i5);
/*       */ 
/* 11388 */             localOraclePreparedStatement.parameterOtype[0][i4] = this.parameterOtype[0][i1];
/* 11389 */             localOraclePreparedStatement.currentRowByteLens[i4] = i2;
/*       */           }
/* 11391 */           else if (i2 > 0)
/*       */           {
/* 11393 */             localOraclePreparedStatement.currentRowBinders[i4] = copiedByteBinder(s, this.bindBytes, j, i2, this.bindIndicators[n]);
/*       */ 
/* 11395 */             localOraclePreparedStatement.currentRowByteLens[i4] = i2;
/*       */           }
/* 11397 */           else if (i3 > 0)
/*       */           {
/* 11399 */             localOraclePreparedStatement.currentRowBinders[i4] = copiedCharBinder(s, this.bindChars, k, i3, this.bindIndicators[n], getInoutIndicator(i1));
/*       */ 
/* 11401 */             localOraclePreparedStatement.currentRowCharLens[i4] = i3;
/*       */           }
/*       */           else
/*       */           {
/* 11405 */             localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 89, new StringBuilder().append("copyBinds doesn't understand type ").append(s).toString());
/* 11406 */             ((SQLException)localObject).fillInStackTrace();
/* 11407 */             throw ((Throwable)localObject);
/*       */           }
/*       */         }
/* 11410 */         j += this.bindBufferCapacity * i2;
/* 11411 */         k += this.bindBufferCapacity * i3;
/* 11412 */         m += this.numberOfBindRowsAllocated;
/* 11413 */         n += this.numberOfBindRowsAllocated;
/* 11414 */         i += 10;
/*       */       }
/*       */     }
/*       */ 
/* 11418 */     return this.numberOfBindPositions;
/*       */   }
/*       */ 
/*       */   Binder copiedNullBinder(short paramShort, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 11425 */     return new CopiedNullBinder(paramShort, paramInt);
/*       */   }
/*       */ 
/*       */   Binder copiedByteBinder(short paramShort1, byte[] paramArrayOfByte, int paramInt1, int paramInt2, short paramShort2)
/*       */     throws SQLException
/*       */   {
/* 11433 */     byte[] arrayOfByte = new byte[paramInt2];
/*       */ 
/* 11435 */     System.arraycopy(paramArrayOfByte, paramInt1, arrayOfByte, 0, paramInt2);
/*       */ 
/* 11437 */     return new CopiedByteBinder(paramShort1, paramInt2, arrayOfByte, paramShort2);
/*       */   }
/*       */ 
/*       */   Binder copiedCharBinder(short paramShort1, char[] paramArrayOfChar, int paramInt1, int paramInt2, short paramShort2, short paramShort3)
/*       */     throws SQLException
/*       */   {
/* 11445 */     char[] arrayOfChar = new char[paramInt2];
/*       */ 
/* 11447 */     System.arraycopy(paramArrayOfChar, paramInt1, arrayOfChar, 0, paramInt2);
/*       */ 
/* 11449 */     return new CopiedCharBinder(paramShort1, arrayOfChar, paramShort2, paramShort3);
/*       */   }
/*       */ 
/*       */   protected void hardClose()
/*       */     throws SQLException
/*       */   {
/* 11457 */     super.hardClose();
/*       */ 
/* 11459 */     releaseBuffers();
/*       */ 
/* 11464 */     if (!this.connection.isClosed())
/*       */     {
/* 11466 */       cleanAllTempLobs();
/*       */     }
/*       */ 
/* 11469 */     this.lastBoundBytes = null;
/* 11470 */     this.lastBoundChars = null;
/*       */   }
/*       */ 
/*       */   protected void alwaysOnClose()
/*       */     throws SQLException
/*       */   {
/* 11482 */     if (this.currentRank > 0)
/*       */     {
/* 11484 */       if (this.m_batchStyle == 2) {
/* 11485 */         clearBatch();
/*       */       }
/*       */       else
/*       */       {
/* 11491 */         int i = this.validRows;
/*       */ 
/* 11493 */         this.prematureBatchCount = sendBatch();
/* 11494 */         this.validRows = i;
/*       */       }
/*       */ 
/*       */     }
/*       */ 
/* 11509 */     if (this.sqlKind.isSELECT()) {
/* 11510 */       Object localObject = this.children;
/*       */ 
/* 11512 */       while (localObject != null) {
/* 11513 */         OracleStatement localOracleStatement = ((OracleStatement)localObject).nextChild;
/*       */ 
/* 11516 */         if (((OracleStatement)localObject).serverCursor) {
/* 11517 */           ((OracleStatement)localObject).cursorId = 0;
/*       */         }
/* 11519 */         localObject = localOracleStatement;
/*       */       }
/*       */     }
/*       */ 
/* 11523 */     super.alwaysOnClose();
/*       */   }
/*       */ 
/*       */   public void setDisableStmtCaching(boolean paramBoolean)
/*       */   {
/* 11536 */     synchronized (this.connection)
/*       */     {
/* 11538 */       if (paramBoolean == true)
/* 11539 */         this.cacheState = 3;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setFormOfUse(int paramInt, short paramShort)
/*       */   {
/* 11549 */     synchronized (this.connection)
/*       */     {
/* 11552 */       int i = paramInt - 1;
/*       */ 
/* 11554 */       if (this.currentRowFormOfUse[i] != paramShort)
/*       */       {
/* 11556 */         this.currentRowFormOfUse[i] = paramShort;
/*       */         Accessor localAccessor;
/* 11560 */         if (this.currentRowBindAccessors != null)
/*       */         {
/* 11562 */           localAccessor = this.currentRowBindAccessors[i];
/*       */ 
/* 11564 */           if (localAccessor != null) {
/* 11565 */             localAccessor.setFormOfUse(paramShort);
/*       */           }
/*       */         }
/*       */ 
/* 11569 */         if (this.accessors != null)
/*       */         {
/* 11571 */           localAccessor = this.accessors[i];
/*       */ 
/* 11573 */           if (localAccessor != null)
/* 11574 */             localAccessor.setFormOfUse(paramShort);
/*       */         }
/*       */       }
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setURL(int paramInt, URL paramURL)
/*       */     throws SQLException
/*       */   {
/* 11601 */     setURLInternal(paramInt, paramURL);
/*       */   }
/*       */ 
/*       */   void setURLInternal(int paramInt, URL paramURL)
/*       */     throws SQLException
/*       */   {
/* 11608 */     if (paramURL == null) {
/* 11609 */       setNull(paramInt, 1);
/*       */     }
/*       */     else
/* 11612 */       setStringInternal(paramInt, paramURL.toString());
/*       */   }
/*       */ 
/*       */   public ParameterMetaData getParameterMetaData()
/*       */     throws SQLException
/*       */   {
/* 11620 */     ensureOpen();
/* 11621 */     return OracleParameterMetaData.getParameterMetaData(this.sqlObject, this.connection);
/*       */   }
/*       */ 
/*       */   public oracle.jdbc.OracleParameterMetaData OracleGetParameterMetaData()
/*       */     throws SQLException
/*       */   {
/* 11644 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 11645 */     localSQLException.fillInStackTrace();
/* 11646 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void registerReturnParameter(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException1;
/* 11656 */     if (this.numberOfBindPositions <= 0)
/*       */     {
/* 11658 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 11659 */       localSQLException1.fillInStackTrace();
/* 11660 */       throw localSQLException1;
/*       */     }
/*       */ 
/* 11663 */     if (this.numReturnParams <= 0)
/*       */     {
/* 11665 */       this.numReturnParams = this.sqlObject.getReturnParameterCount();
/* 11666 */       if (this.numReturnParams <= 0)
/*       */       {
/* 11668 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 11669 */         localSQLException1.fillInStackTrace();
/* 11670 */         throw localSQLException1;
/*       */       }
/*       */     }
/*       */ 
/* 11674 */     int i = paramInt1 - 1;
/* 11675 */     if ((i < this.numberOfBindPositions - this.numReturnParams) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/* 11678 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 11679 */       localSQLException2.fillInStackTrace();
/* 11680 */       throw localSQLException2;
/*       */     }
/*       */ 
/* 11683 */     int j = getInternalTypeForDmlReturning(paramInt2);
/*       */ 
/* 11685 */     short s = 0;
/* 11686 */     if ((this.currentRowFormOfUse != null) && (this.currentRowFormOfUse[i] != 0)) {
/* 11687 */       s = this.currentRowFormOfUse[i];
/*       */     }
/* 11689 */     registerReturnParameterInternal(i, j, paramInt2, -1, s, null);
/*       */ 
/* 11692 */     this.currentRowBinders[i] = this.theReturnParamBinder;
/*       */   }
/*       */ 
/*       */   public void registerReturnParameter(int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/* 11703 */     if (this.numberOfBindPositions <= 0)
/*       */     {
/* 11705 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 11706 */       localSQLException1.fillInStackTrace();
/* 11707 */       throw localSQLException1;
/*       */     }
/*       */ 
/* 11710 */     int i = paramInt1 - 1;
/*       */     SQLException localSQLException2;
/* 11711 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/* 11713 */       localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 11714 */       localSQLException2.fillInStackTrace();
/* 11715 */       throw localSQLException2;
/*       */     }
/*       */ 
/* 11718 */     if ((paramInt2 != 1) && (paramInt2 != 12) && (paramInt2 != -1) && (paramInt2 != -2) && (paramInt2 != -3) && (paramInt2 != -4) && (paramInt2 != 12))
/*       */     {
/* 11727 */       localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 11728 */       localSQLException2.fillInStackTrace();
/* 11729 */       throw localSQLException2;
/*       */     }
/*       */ 
/* 11733 */     if (paramInt3 <= 0)
/*       */     {
/* 11736 */       localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 11737 */       localSQLException2.fillInStackTrace();
/* 11738 */       throw localSQLException2;
/*       */     }
/*       */ 
/* 11742 */     int j = getInternalTypeForDmlReturning(paramInt2);
/*       */ 
/* 11744 */     short s = 0;
/* 11745 */     if ((this.currentRowFormOfUse != null) && (this.currentRowFormOfUse[i] != 0)) {
/* 11746 */       s = this.currentRowFormOfUse[i];
/*       */     }
/* 11748 */     registerReturnParameterInternal(i, j, paramInt2, paramInt3, s, null);
/*       */ 
/* 11751 */     this.currentRowBinders[i] = this.theReturnParamBinder;
/*       */   }
/*       */ 
/*       */   public void registerReturnParameter(int paramInt1, int paramInt2, String paramString)
/*       */     throws SQLException
/*       */   {
/* 11762 */     if (this.numberOfBindPositions <= 0)
/*       */     {
/* 11764 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 11765 */       localSQLException1.fillInStackTrace();
/* 11766 */       throw localSQLException1;
/*       */     }
/*       */ 
/* 11769 */     int i = paramInt1 - 1;
/* 11770 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/* 11772 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 11773 */       localSQLException2.fillInStackTrace();
/* 11774 */       throw localSQLException2;
/*       */     }
/*       */ 
/* 11777 */     int j = getInternalTypeForDmlReturning(paramInt2);
/* 11778 */     if ((j != 111) && (j != 109))
/*       */     {
/* 11782 */       SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 11783 */       localSQLException3.fillInStackTrace();
/* 11784 */       throw localSQLException3;
/*       */     }
/*       */ 
/* 11788 */     registerReturnParameterInternal(i, j, paramInt2, -1, (short)0, paramString);
/*       */ 
/* 11791 */     this.currentRowBinders[i] = this.theReturnParamBinder;
/*       */   }
/*       */ 
/*       */   public ResultSet getReturnResultSet()
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/* 11799 */     if (this.closed)
/*       */     {
/* 11801 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 11802 */       localSQLException.fillInStackTrace();
/* 11803 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11806 */     if ((this.accessors == null) || (this.numReturnParams == 0))
/*       */     {
/* 11808 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 144);
/* 11809 */       localSQLException.fillInStackTrace();
/* 11810 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11813 */     if ((this.currentResultSet == null) || (this.numReturnParams == 0) || (!this.isOpen))
/*       */     {
/* 11817 */       this.isComplete = true;
/* 11818 */       computeOffsetOfFirstUserColumn();
/* 11819 */       this.currentResultSet = OracleResultSet.createResultSet(this);
/*       */     }
/*       */ 
/* 11822 */     return this.currentResultSet;
/*       */   }
/*       */ 
/*       */   int getInternalTypeForDmlReturning(int paramInt)
/*       */     throws SQLException
/*       */   {
/* 11836 */     int i = 0;
/*       */ 
/* 11838 */     switch (paramInt)
/*       */     {
/*       */     case -7:
/*       */     case -6:
/*       */     case -5:
/*       */     case 2:
/*       */     case 3:
/*       */     case 4:
/*       */     case 5:
/*       */     case 6:
/*       */     case 7:
/*       */     case 8:
/* 11850 */       i = 6;
/* 11851 */       break;
/*       */     case 100:
/* 11854 */       i = 100;
/* 11855 */       break;
/*       */     case 101:
/* 11858 */       i = 101;
/* 11859 */       break;
/*       */     case -15:
/*       */     case 1:
/* 11863 */       i = 96;
/* 11864 */       break;
/*       */     case -9:
/*       */     case 12:
/* 11868 */       i = 1;
/* 11869 */       break;
/*       */     case -16:
/*       */     case -1:
/* 11873 */       i = 8;
/* 11874 */       break;
/*       */     case 91:
/*       */     case 92:
/* 11878 */       i = 12;
/* 11879 */       break;
/*       */     case 93:
/* 11882 */       i = 180;
/* 11883 */       break;
/*       */     case -101:
/* 11886 */       i = 181;
/* 11887 */       break;
/*       */     case -102:
/* 11890 */       i = 231;
/* 11891 */       break;
/*       */     case -103:
/* 11894 */       i = 182;
/* 11895 */       break;
/*       */     case -104:
/* 11898 */       i = 183;
/* 11899 */       break;
/*       */     case -3:
/*       */     case -2:
/* 11903 */       i = 23;
/* 11904 */       break;
/*       */     case -4:
/* 11907 */       i = 24;
/* 11908 */       break;
/*       */     case -8:
/* 11911 */       i = 104;
/* 11912 */       break;
/*       */     case 2004:
/* 11915 */       i = 113;
/* 11916 */       break;
/*       */     case 2005:
/*       */     case 2011:
/* 11920 */       i = 112;
/* 11921 */       break;
/*       */     case -13:
/* 11924 */       i = 114;
/* 11925 */       break;
/*       */     case 2002:
/*       */     case 2003:
/*       */     case 2007:
/*       */     case 2008:
/*       */     case 2009:
/* 11932 */       i = 109;
/* 11933 */       break;
/*       */     case 2006:
/* 11936 */       i = 111;
/* 11937 */       break;
/*       */     case 70:
/* 11940 */       i = 1;
/* 11941 */       break;
/*       */     default:
/* 11945 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 11946 */       localSQLException.fillInStackTrace();
/* 11947 */       throw localSQLException;
/*       */     }
/*       */ 
/* 11952 */     return i;
/*       */   }
/*       */ 
/*       */   void registerReturnParamsForAutoKey()
/*       */     throws SQLException
/*       */   {
/* 11960 */     int[] arrayOfInt1 = this.autoKeyInfo.returnTypes;
/* 11961 */     short[] arrayOfShort = this.autoKeyInfo.tableFormOfUses;
/* 11962 */     int[] arrayOfInt2 = this.autoKeyInfo.columnIndexes;
/*       */ 
/* 11964 */     int i = arrayOfInt1.length;
/*       */ 
/* 11967 */     int j = this.numberOfBindPositions - i;
/* 11968 */     this.offsetOfFirstUserColumn = (j - 1);
/*       */ 
/* 11971 */     for (int k = 0; k < i; k++)
/*       */     {
/* 11973 */       int m = j + k;
/* 11974 */       this.currentRowBinders[m] = this.theReturnParamBinder;
/*       */ 
/* 11976 */       short s = this.connection.defaultnchar ? 2 : 1;
/*       */ 
/* 11979 */       if ((arrayOfShort != null) && (arrayOfInt2 != null))
/*       */       {
/* 11981 */         if (arrayOfShort[(arrayOfInt2[k] - 1)] == 2)
/*       */         {
/* 11984 */           s = 2;
/* 11985 */           setFormOfUse(m + 1, s);
/*       */         }
/*       */       }
/*       */ 
/* 11989 */       checkTypeForAutoKey(arrayOfInt1[k]);
/*       */ 
/* 11991 */       String str = null;
/* 11992 */       if (arrayOfInt1[k] == 111) {
/* 11993 */         str = this.autoKeyInfo.tableTypeNames[(arrayOfInt2[k] - 1)];
/*       */       }
/* 11995 */       registerReturnParameterInternal(m, arrayOfInt1[k], arrayOfInt1[k], -1, s, str);
/*       */     }
/*       */   }
/*       */ 
/*       */   void cleanOldTempLobs()
/*       */   {
/* 12005 */     if ((this.m_batchStyle != 1) || (this.currentRank == this.batch - 1))
/*       */     {
/* 12007 */       super.cleanOldTempLobs();
/*       */     }
/*       */   }
/*       */ 
/*       */   void resetOnExceptionDuringExecute()
/*       */   {
/* 12014 */     super.resetOnExceptionDuringExecute();
/* 12015 */     this.currentRank = 0;
/* 12016 */     this.currentBatchNeedToPrepareBinds = true;
/*       */   }
/*       */ 
/*       */   void resetCurrentRowBinders()
/*       */   {
/* 12025 */     Binder[] arrayOfBinder = this.currentRowBinders;
/* 12026 */     if ((this.binders != null) && (this.currentRowBinders != null) && (arrayOfBinder != this.binders[0]))
/*       */     {
/* 12030 */       this.currentRowBinders = this.binders[0];
/* 12031 */       this.binders[this.numberOfBoundRows] = arrayOfBinder;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 12052 */     setAsciiStreamInternal(paramInt, paramInputStream);
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12072 */     setAsciiStreamInternal(paramInt, paramInputStream, paramLong);
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 12091 */     setBinaryStreamInternal(paramInt, paramInputStream);
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12111 */     setBinaryStreamInternal(paramInt, paramInputStream, paramLong);
/*       */   }
/*       */ 
/*       */   public void setBlob(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 12129 */     setBlobInternal(paramInt, paramInputStream);
/*       */   }
/*       */ 
/*       */   public void setBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12148 */     if (paramLong < 0L)
/*       */     {
/* 12150 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
/* 12151 */       localSQLException.fillInStackTrace();
/* 12152 */       throw localSQLException;
/*       */     }
/* 12154 */     setBlobInternal(paramInt, paramInputStream, paramLong);
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12173 */     setCharacterStreamInternal(paramInt, paramReader);
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12193 */     setCharacterStreamInternal(paramInt, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setClob(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12212 */     if (paramLong < 0L)
/*       */     {
/* 12214 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
/* 12215 */       localSQLException.fillInStackTrace();
/* 12216 */       throw localSQLException;
/*       */     }
/* 12218 */     setClobInternal(paramInt, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setClob(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12237 */     setClobInternal(paramInt, paramReader);
/*       */   }
/*       */ 
/*       */   public void setRowId(int paramInt, RowId paramRowId)
/*       */     throws SQLException
/*       */   {
/* 12257 */     setRowIdInternal(paramInt, paramRowId);
/*       */   }
/*       */ 
/*       */   public void setNCharacterStream(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12278 */     setNCharacterStreamInternal(paramInt, paramReader);
/*       */   }
/*       */ 
/*       */   public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12299 */     setNCharacterStreamInternal(paramInt, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setNClob(int paramInt, NClob paramNClob)
/*       */     throws SQLException
/*       */   {
/* 12319 */     setNClobInternal(paramInt, paramNClob);
/*       */   }
/*       */ 
/*       */   public void setNClob(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12340 */     setNClobInternal(paramInt, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setNClob(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12360 */     setNClobInternal(paramInt, paramReader);
/*       */   }
/*       */ 
/*       */   public void setSQLXML(int paramInt, SQLXML paramSQLXML)
/*       */     throws SQLException
/*       */   {
/* 12372 */     setSQLXMLInternal(paramInt, paramSQLXML);
/*       */   }
/*       */ 
/*       */   public void setNString(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/* 12392 */     setNStringInternal(paramInt, paramString);
/*       */   }
/*       */ 
/*       */   void setAsciiStreamInternal(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 12400 */     setAsciiStreamInternal(paramInt, paramInputStream, 0L, false);
/*       */   }
/*       */ 
/*       */   void setAsciiStreamInternal(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12408 */     setAsciiStreamInternal(paramInt, paramInputStream, paramLong, true);
/*       */   }
/*       */ 
/*       */   void setBinaryStreamInternal(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 12416 */     setBinaryStreamInternal(paramInt, paramInputStream, 0L, false);
/*       */   }
/*       */ 
/*       */   void setBinaryStreamInternal(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12424 */     setBinaryStreamInternal(paramInt, paramInputStream, paramLong, true);
/*       */   }
/*       */ 
/*       */   void setBlobInternal(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12433 */     int i = paramInt - 1;
/*       */ 
/* 12435 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/* 12437 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 12438 */       localSQLException.fillInStackTrace();
/* 12439 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12442 */     if (paramInputStream == null)
/* 12443 */       setNullInternal(paramInt, 2004);
/*       */     else
/* 12445 */       setBinaryStreamContentsForBlobCritical(paramInt, paramInputStream, paramLong, paramLong != -1L);
/*       */   }
/*       */ 
/*       */   void setBlobInternal(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 12454 */     setBlobInternal(paramInt, paramInputStream, -1L);
/*       */   }
/*       */ 
/*       */   void setCharacterStreamInternal(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12462 */     setCharacterStreamInternal(paramInt, paramReader, 0L, false);
/*       */   }
/*       */ 
/*       */   void setCharacterStreamInternal(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12470 */     setCharacterStreamInternal(paramInt, paramReader, paramLong, true);
/*       */   }
/*       */ 
/*       */   void setClobInternal(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12478 */     setClobInternal(paramInt, paramReader, -1L);
/*       */   }
/*       */ 
/*       */   void setClobInternal(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12486 */     int i = paramInt - 1;
/*       */ 
/* 12488 */     if ((i < 0) || (paramInt > this.numberOfBindPositions))
/*       */     {
/* 12490 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 12491 */       localSQLException.fillInStackTrace();
/* 12492 */       throw localSQLException;
/*       */     }
/*       */ 
/* 12495 */     if (paramReader == null)
/* 12496 */       setNullInternal(paramInt, 2005);
/*       */     else
/* 12498 */       setReaderContentsForClobCritical(paramInt, paramReader, paramLong, paramLong != -1L);
/*       */   }
/*       */ 
/*       */   void setNCharacterStreamInternal(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12506 */     setFormOfUse(paramInt, (short)2);
/* 12507 */     setCharacterStreamInternal(paramInt, paramReader, 0L, false);
/*       */   }
/*       */ 
/*       */   void setNCharacterStreamInternal(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12515 */     setFormOfUse(paramInt, (short)2);
/* 12516 */     setCharacterStreamInternal(paramInt, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   void setNClobInternal(int paramInt, NClob paramNClob)
/*       */     throws SQLException
/*       */   {
/* 12524 */     setFormOfUse(paramInt, (short)2);
/* 12525 */     setClobInternal(paramInt, paramNClob);
/*       */   }
/*       */ 
/*       */   void setNClobInternal(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 12533 */     setFormOfUse(paramInt, (short)2);
/* 12534 */     setClobInternal(paramInt, paramReader);
/*       */   }
/*       */ 
/*       */   void setNClobInternal(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 12542 */     setFormOfUse(paramInt, (short)2);
/* 12543 */     setClobInternal(paramInt, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   void setNStringInternal(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/* 12551 */     setFormOfUse(paramInt, (short)2);
/* 12552 */     setStringInternal(paramInt, paramString);
/*       */   }
/*       */ 
/*       */   void setRowIdInternal(int paramInt, RowId paramRowId)
/*       */     throws SQLException
/*       */   {
/* 12560 */     setROWIDInternal(paramInt, (ROWID)paramRowId);
/*       */   }
/*       */ 
/*       */   public void setArrayAtName(String paramString, Array paramArray)
/*       */     throws SQLException
/*       */   {
/* 12584 */     if (paramString == null)
/*       */     {
/* 12586 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12587 */       ((SQLException)localObject).fillInStackTrace();
/* 12588 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12593 */     Object localObject = paramString.intern();
/* 12594 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12595 */     int i = 0;
/* 12596 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12598 */     for (int k = 0; k < j; k++) {
/* 12599 */       if (arrayOfString[k] == localObject) {
/* 12600 */         setArray(k + 1, paramArray);
/*       */ 
/* 12602 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12606 */     if (i == 0)
/*       */     {
/* 12608 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12609 */       localSQLException.fillInStackTrace();
/* 12610 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBigDecimalAtName(String paramString, BigDecimal paramBigDecimal)
/*       */     throws SQLException
/*       */   {
/* 12630 */     if (paramString == null)
/*       */     {
/* 12632 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12633 */       ((SQLException)localObject).fillInStackTrace();
/* 12634 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12639 */     Object localObject = paramString.intern();
/* 12640 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12641 */     int i = 0;
/* 12642 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12644 */     for (int k = 0; k < j; k++) {
/* 12645 */       if (arrayOfString[k] == localObject) {
/* 12646 */         setBigDecimal(k + 1, paramBigDecimal);
/*       */ 
/* 12648 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12652 */     if (i == 0)
/*       */     {
/* 12654 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12655 */       localSQLException.fillInStackTrace();
/* 12656 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBlobAtName(String paramString, Blob paramBlob)
/*       */     throws SQLException
/*       */   {
/* 12676 */     if (paramString == null)
/*       */     {
/* 12678 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12679 */       ((SQLException)localObject).fillInStackTrace();
/* 12680 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12685 */     Object localObject = paramString.intern();
/* 12686 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12687 */     int i = 0;
/* 12688 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12690 */     for (int k = 0; k < j; k++) {
/* 12691 */       if (arrayOfString[k] == localObject) {
/* 12692 */         setBlob(k + 1, paramBlob);
/*       */ 
/* 12694 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12698 */     if (i == 0)
/*       */     {
/* 12700 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12701 */       localSQLException.fillInStackTrace();
/* 12702 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBooleanAtName(String paramString, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/* 12722 */     if (paramString == null)
/*       */     {
/* 12724 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12725 */       ((SQLException)localObject).fillInStackTrace();
/* 12726 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12731 */     Object localObject = paramString.intern();
/* 12732 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12733 */     int i = 0;
/* 12734 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12736 */     for (int k = 0; k < j; k++) {
/* 12737 */       if (arrayOfString[k] == localObject) {
/* 12738 */         setBoolean(k + 1, paramBoolean);
/*       */ 
/* 12740 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12744 */     if (i == 0)
/*       */     {
/* 12746 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12747 */       localSQLException.fillInStackTrace();
/* 12748 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setByteAtName(String paramString, byte paramByte)
/*       */     throws SQLException
/*       */   {
/* 12768 */     if (paramString == null)
/*       */     {
/* 12770 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12771 */       ((SQLException)localObject).fillInStackTrace();
/* 12772 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12777 */     Object localObject = paramString.intern();
/* 12778 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12779 */     int i = 0;
/* 12780 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12782 */     for (int k = 0; k < j; k++) {
/* 12783 */       if (arrayOfString[k] == localObject) {
/* 12784 */         setByte(k + 1, paramByte);
/*       */ 
/* 12786 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12790 */     if (i == 0)
/*       */     {
/* 12792 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12793 */       localSQLException.fillInStackTrace();
/* 12794 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBytesAtName(String paramString, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/* 12814 */     if (paramString == null)
/*       */     {
/* 12816 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12817 */       ((SQLException)localObject).fillInStackTrace();
/* 12818 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12823 */     Object localObject = paramString.intern();
/* 12824 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12825 */     int i = 0;
/* 12826 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12828 */     for (int k = 0; k < j; k++) {
/* 12829 */       if (arrayOfString[k] == localObject) {
/* 12830 */         setBytes(k + 1, paramArrayOfByte);
/*       */ 
/* 12832 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12836 */     if (i == 0)
/*       */     {
/* 12838 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12839 */       localSQLException.fillInStackTrace();
/* 12840 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setClobAtName(String paramString, Clob paramClob)
/*       */     throws SQLException
/*       */   {
/* 12860 */     if (paramString == null)
/*       */     {
/* 12862 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12863 */       ((SQLException)localObject).fillInStackTrace();
/* 12864 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12869 */     Object localObject = paramString.intern();
/* 12870 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12871 */     int i = 0;
/* 12872 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12874 */     for (int k = 0; k < j; k++) {
/* 12875 */       if (arrayOfString[k] == localObject) {
/* 12876 */         setClob(k + 1, paramClob);
/*       */ 
/* 12878 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12882 */     if (i == 0)
/*       */     {
/* 12884 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12885 */       localSQLException.fillInStackTrace();
/* 12886 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDateAtName(String paramString, Date paramDate)
/*       */     throws SQLException
/*       */   {
/* 12906 */     if (paramString == null)
/*       */     {
/* 12908 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12909 */       ((SQLException)localObject).fillInStackTrace();
/* 12910 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12915 */     Object localObject = paramString.intern();
/* 12916 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12917 */     int i = 0;
/* 12918 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12920 */     for (int k = 0; k < j; k++) {
/* 12921 */       if (arrayOfString[k] == localObject) {
/* 12922 */         setDate(k + 1, paramDate);
/*       */ 
/* 12924 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12928 */     if (i == 0)
/*       */     {
/* 12930 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12931 */       localSQLException.fillInStackTrace();
/* 12932 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDateAtName(String paramString, Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 12952 */     if (paramString == null)
/*       */     {
/* 12954 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 12955 */       ((SQLException)localObject).fillInStackTrace();
/* 12956 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 12961 */     Object localObject = paramString.intern();
/* 12962 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 12963 */     int i = 0;
/* 12964 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 12966 */     for (int k = 0; k < j; k++) {
/* 12967 */       if (arrayOfString[k] == localObject) {
/* 12968 */         setDate(k + 1, paramDate, paramCalendar);
/*       */ 
/* 12970 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 12974 */     if (i == 0)
/*       */     {
/* 12976 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 12977 */       localSQLException.fillInStackTrace();
/* 12978 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDoubleAtName(String paramString, double paramDouble)
/*       */     throws SQLException
/*       */   {
/* 12998 */     if (paramString == null)
/*       */     {
/* 13000 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13001 */       ((SQLException)localObject).fillInStackTrace();
/* 13002 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13007 */     Object localObject = paramString.intern();
/* 13008 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13009 */     int i = 0;
/* 13010 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13012 */     for (int k = 0; k < j; k++) {
/* 13013 */       if (arrayOfString[k] == localObject) {
/* 13014 */         setDouble(k + 1, paramDouble);
/*       */ 
/* 13016 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13020 */     if (i == 0)
/*       */     {
/* 13022 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13023 */       localSQLException.fillInStackTrace();
/* 13024 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setFloatAtName(String paramString, float paramFloat)
/*       */     throws SQLException
/*       */   {
/* 13044 */     if (paramString == null)
/*       */     {
/* 13046 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13047 */       ((SQLException)localObject).fillInStackTrace();
/* 13048 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13053 */     Object localObject = paramString.intern();
/* 13054 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13055 */     int i = 0;
/* 13056 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13058 */     for (int k = 0; k < j; k++) {
/* 13059 */       if (arrayOfString[k] == localObject) {
/* 13060 */         setFloat(k + 1, paramFloat);
/*       */ 
/* 13062 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13066 */     if (i == 0)
/*       */     {
/* 13068 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13069 */       localSQLException.fillInStackTrace();
/* 13070 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setIntAtName(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 13090 */     if (paramString == null)
/*       */     {
/* 13092 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13093 */       ((SQLException)localObject).fillInStackTrace();
/* 13094 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13099 */     Object localObject = paramString.intern();
/* 13100 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13101 */     int i = 0;
/* 13102 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13104 */     for (int k = 0; k < j; k++) {
/* 13105 */       if (arrayOfString[k] == localObject) {
/* 13106 */         setInt(k + 1, paramInt);
/*       */ 
/* 13108 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13112 */     if (i == 0)
/*       */     {
/* 13114 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13115 */       localSQLException.fillInStackTrace();
/* 13116 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setLongAtName(String paramString, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 13136 */     if (paramString == null)
/*       */     {
/* 13138 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13139 */       ((SQLException)localObject).fillInStackTrace();
/* 13140 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13145 */     Object localObject = paramString.intern();
/* 13146 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13147 */     int i = 0;
/* 13148 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13150 */     for (int k = 0; k < j; k++) {
/* 13151 */       if (arrayOfString[k] == localObject) {
/* 13152 */         setLong(k + 1, paramLong);
/*       */ 
/* 13154 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13158 */     if (i == 0)
/*       */     {
/* 13160 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13161 */       localSQLException.fillInStackTrace();
/* 13162 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNClobAtName(String paramString, NClob paramNClob)
/*       */     throws SQLException
/*       */   {
/* 13182 */     if (paramString == null)
/*       */     {
/* 13184 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13185 */       ((SQLException)localObject).fillInStackTrace();
/* 13186 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13191 */     Object localObject = paramString.intern();
/* 13192 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13193 */     int i = 0;
/* 13194 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13196 */     for (int k = 0; k < j; k++) {
/* 13197 */       if (arrayOfString[k] == localObject) {
/* 13198 */         setNClob(k + 1, paramNClob);
/*       */ 
/* 13200 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13204 */     if (i == 0)
/*       */     {
/* 13206 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13207 */       localSQLException.fillInStackTrace();
/* 13208 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNStringAtName(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/* 13228 */     if (paramString1 == null)
/*       */     {
/* 13230 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13231 */       ((SQLException)localObject).fillInStackTrace();
/* 13232 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13237 */     Object localObject = paramString1.intern();
/* 13238 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13239 */     int i = 0;
/* 13240 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13242 */     for (int k = 0; k < j; k++) {
/* 13243 */       if (arrayOfString[k] == localObject) {
/* 13244 */         setNString(k + 1, paramString2);
/*       */ 
/* 13246 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13250 */     if (i == 0)
/*       */     {
/* 13252 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/* 13253 */       localSQLException.fillInStackTrace();
/* 13254 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setObjectAtName(String paramString, Object paramObject)
/*       */     throws SQLException
/*       */   {
/* 13274 */     if (paramString == null)
/*       */     {
/* 13276 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13277 */       ((SQLException)localObject).fillInStackTrace();
/* 13278 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13283 */     Object localObject = paramString.intern();
/* 13284 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13285 */     int i = 0;
/* 13286 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13288 */     for (int k = 0; k < j; k++) {
/* 13289 */       if (arrayOfString[k] == localObject) {
/* 13290 */         setObject(k + 1, paramObject);
/*       */ 
/* 13292 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13296 */     if (i == 0)
/*       */     {
/* 13298 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13299 */       localSQLException.fillInStackTrace();
/* 13300 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setObjectAtName(String paramString, Object paramObject, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 13320 */     if (paramString == null)
/*       */     {
/* 13322 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13323 */       ((SQLException)localObject).fillInStackTrace();
/* 13324 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13329 */     Object localObject = paramString.intern();
/* 13330 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13331 */     int i = 0;
/* 13332 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13334 */     for (int k = 0; k < j; k++) {
/* 13335 */       if (arrayOfString[k] == localObject) {
/* 13336 */         setObject(k + 1, paramObject, paramInt);
/*       */ 
/* 13338 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13342 */     if (i == 0)
/*       */     {
/* 13344 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13345 */       localSQLException.fillInStackTrace();
/* 13346 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setRefAtName(String paramString, Ref paramRef)
/*       */     throws SQLException
/*       */   {
/* 13366 */     if (paramString == null)
/*       */     {
/* 13368 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13369 */       ((SQLException)localObject).fillInStackTrace();
/* 13370 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13375 */     Object localObject = paramString.intern();
/* 13376 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13377 */     int i = 0;
/* 13378 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13380 */     for (int k = 0; k < j; k++) {
/* 13381 */       if (arrayOfString[k] == localObject) {
/* 13382 */         setRef(k + 1, paramRef);
/*       */ 
/* 13384 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13388 */     if (i == 0)
/*       */     {
/* 13390 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13391 */       localSQLException.fillInStackTrace();
/* 13392 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setRowIdAtName(String paramString, RowId paramRowId)
/*       */     throws SQLException
/*       */   {
/* 13412 */     if (paramString == null)
/*       */     {
/* 13414 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13415 */       ((SQLException)localObject).fillInStackTrace();
/* 13416 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13421 */     Object localObject = paramString.intern();
/* 13422 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13423 */     int i = 0;
/* 13424 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13426 */     for (int k = 0; k < j; k++) {
/* 13427 */       if (arrayOfString[k] == localObject) {
/* 13428 */         setRowId(k + 1, paramRowId);
/*       */ 
/* 13430 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13434 */     if (i == 0)
/*       */     {
/* 13436 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13437 */       localSQLException.fillInStackTrace();
/* 13438 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setShortAtName(String paramString, short paramShort)
/*       */     throws SQLException
/*       */   {
/* 13458 */     if (paramString == null)
/*       */     {
/* 13460 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13461 */       ((SQLException)localObject).fillInStackTrace();
/* 13462 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13467 */     Object localObject = paramString.intern();
/* 13468 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13469 */     int i = 0;
/* 13470 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13472 */     for (int k = 0; k < j; k++) {
/* 13473 */       if (arrayOfString[k] == localObject) {
/* 13474 */         setShort(k + 1, paramShort);
/*       */ 
/* 13476 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13480 */     if (i == 0)
/*       */     {
/* 13482 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13483 */       localSQLException.fillInStackTrace();
/* 13484 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setSQLXMLAtName(String paramString, SQLXML paramSQLXML)
/*       */     throws SQLException
/*       */   {
/* 13504 */     if (paramString == null)
/*       */     {
/* 13506 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13507 */       ((SQLException)localObject).fillInStackTrace();
/* 13508 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13513 */     Object localObject = paramString.intern();
/* 13514 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13515 */     int i = 0;
/* 13516 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13518 */     for (int k = 0; k < j; k++) {
/* 13519 */       if (arrayOfString[k] == localObject) {
/* 13520 */         setSQLXML(k + 1, paramSQLXML);
/*       */ 
/* 13522 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13526 */     if (i == 0)
/*       */     {
/* 13528 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13529 */       localSQLException.fillInStackTrace();
/* 13530 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setStringAtName(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/* 13550 */     if (paramString1 == null)
/*       */     {
/* 13552 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13553 */       ((SQLException)localObject).fillInStackTrace();
/* 13554 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13559 */     Object localObject = paramString1.intern();
/* 13560 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13561 */     int i = 0;
/* 13562 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13564 */     for (int k = 0; k < j; k++) {
/* 13565 */       if (arrayOfString[k] == localObject) {
/* 13566 */         setString(k + 1, paramString2);
/*       */ 
/* 13568 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13572 */     if (i == 0)
/*       */     {
/* 13574 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/* 13575 */       localSQLException.fillInStackTrace();
/* 13576 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTimeAtName(String paramString, Time paramTime)
/*       */     throws SQLException
/*       */   {
/* 13596 */     if (paramString == null)
/*       */     {
/* 13598 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13599 */       ((SQLException)localObject).fillInStackTrace();
/* 13600 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13605 */     Object localObject = paramString.intern();
/* 13606 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13607 */     int i = 0;
/* 13608 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13610 */     for (int k = 0; k < j; k++) {
/* 13611 */       if (arrayOfString[k] == localObject) {
/* 13612 */         setTime(k + 1, paramTime);
/*       */ 
/* 13614 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13618 */     if (i == 0)
/*       */     {
/* 13620 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13621 */       localSQLException.fillInStackTrace();
/* 13622 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTimeAtName(String paramString, Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 13642 */     if (paramString == null)
/*       */     {
/* 13644 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13645 */       ((SQLException)localObject).fillInStackTrace();
/* 13646 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13651 */     Object localObject = paramString.intern();
/* 13652 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13653 */     int i = 0;
/* 13654 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13656 */     for (int k = 0; k < j; k++) {
/* 13657 */       if (arrayOfString[k] == localObject) {
/* 13658 */         setTime(k + 1, paramTime, paramCalendar);
/*       */ 
/* 13660 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13664 */     if (i == 0)
/*       */     {
/* 13666 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13667 */       localSQLException.fillInStackTrace();
/* 13668 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTimestampAtName(String paramString, Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/* 13688 */     if (paramString == null)
/*       */     {
/* 13690 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13691 */       ((SQLException)localObject).fillInStackTrace();
/* 13692 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13697 */     Object localObject = paramString.intern();
/* 13698 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13699 */     int i = 0;
/* 13700 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13702 */     for (int k = 0; k < j; k++) {
/* 13703 */       if (arrayOfString[k] == localObject) {
/* 13704 */         setTimestamp(k + 1, paramTimestamp);
/*       */ 
/* 13706 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13710 */     if (i == 0)
/*       */     {
/* 13712 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13713 */       localSQLException.fillInStackTrace();
/* 13714 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTimestampAtName(String paramString, Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/* 13734 */     if (paramString == null)
/*       */     {
/* 13736 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13737 */       ((SQLException)localObject).fillInStackTrace();
/* 13738 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13743 */     Object localObject = paramString.intern();
/* 13744 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13745 */     int i = 0;
/* 13746 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13748 */     for (int k = 0; k < j; k++) {
/* 13749 */       if (arrayOfString[k] == localObject) {
/* 13750 */         setTimestamp(k + 1, paramTimestamp, paramCalendar);
/*       */ 
/* 13752 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13756 */     if (i == 0)
/*       */     {
/* 13758 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13759 */       localSQLException.fillInStackTrace();
/* 13760 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setURLAtName(String paramString, URL paramURL)
/*       */     throws SQLException
/*       */   {
/* 13780 */     if (paramString == null)
/*       */     {
/* 13782 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13783 */       ((SQLException)localObject).fillInStackTrace();
/* 13784 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13789 */     Object localObject = paramString.intern();
/* 13790 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13791 */     int i = 0;
/* 13792 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13794 */     for (int k = 0; k < j; k++) {
/* 13795 */       if (arrayOfString[k] == localObject) {
/* 13796 */         setURL(k + 1, paramURL);
/*       */ 
/* 13798 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13802 */     if (i == 0)
/*       */     {
/* 13804 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13805 */       localSQLException.fillInStackTrace();
/* 13806 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setARRAYAtName(String paramString, ARRAY paramARRAY)
/*       */     throws SQLException
/*       */   {
/* 13826 */     if (paramString == null)
/*       */     {
/* 13828 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13829 */       ((SQLException)localObject).fillInStackTrace();
/* 13830 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13835 */     Object localObject = paramString.intern();
/* 13836 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13837 */     int i = 0;
/* 13838 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13840 */     for (int k = 0; k < j; k++) {
/* 13841 */       if (arrayOfString[k] == localObject) {
/* 13842 */         setARRAY(k + 1, paramARRAY);
/*       */ 
/* 13844 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13848 */     if (i == 0)
/*       */     {
/* 13850 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13851 */       localSQLException.fillInStackTrace();
/* 13852 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBFILEAtName(String paramString, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/* 13872 */     if (paramString == null)
/*       */     {
/* 13874 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13875 */       ((SQLException)localObject).fillInStackTrace();
/* 13876 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13881 */     Object localObject = paramString.intern();
/* 13882 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13883 */     int i = 0;
/* 13884 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13886 */     for (int k = 0; k < j; k++) {
/* 13887 */       if (arrayOfString[k] == localObject) {
/* 13888 */         setBFILE(k + 1, paramBFILE);
/*       */ 
/* 13890 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13894 */     if (i == 0)
/*       */     {
/* 13896 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13897 */       localSQLException.fillInStackTrace();
/* 13898 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBfileAtName(String paramString, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/* 13918 */     if (paramString == null)
/*       */     {
/* 13920 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13921 */       ((SQLException)localObject).fillInStackTrace();
/* 13922 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13927 */     Object localObject = paramString.intern();
/* 13928 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13929 */     int i = 0;
/* 13930 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13932 */     for (int k = 0; k < j; k++) {
/* 13933 */       if (arrayOfString[k] == localObject) {
/* 13934 */         setBfile(k + 1, paramBFILE);
/*       */ 
/* 13936 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13940 */     if (i == 0)
/*       */     {
/* 13942 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13943 */       localSQLException.fillInStackTrace();
/* 13944 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryFloatAtName(String paramString, float paramFloat)
/*       */     throws SQLException
/*       */   {
/* 13964 */     if (paramString == null)
/*       */     {
/* 13966 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 13967 */       ((SQLException)localObject).fillInStackTrace();
/* 13968 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 13973 */     Object localObject = paramString.intern();
/* 13974 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 13975 */     int i = 0;
/* 13976 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 13978 */     for (int k = 0; k < j; k++) {
/* 13979 */       if (arrayOfString[k] == localObject) {
/* 13980 */         setBinaryFloat(k + 1, paramFloat);
/*       */ 
/* 13982 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 13986 */     if (i == 0)
/*       */     {
/* 13988 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 13989 */       localSQLException.fillInStackTrace();
/* 13990 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryFloatAtName(String paramString, BINARY_FLOAT paramBINARY_FLOAT)
/*       */     throws SQLException
/*       */   {
/* 14010 */     if (paramString == null)
/*       */     {
/* 14012 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14013 */       ((SQLException)localObject).fillInStackTrace();
/* 14014 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14019 */     Object localObject = paramString.intern();
/* 14020 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14021 */     int i = 0;
/* 14022 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14024 */     for (int k = 0; k < j; k++) {
/* 14025 */       if (arrayOfString[k] == localObject) {
/* 14026 */         setBinaryFloat(k + 1, paramBINARY_FLOAT);
/*       */ 
/* 14028 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14032 */     if (i == 0)
/*       */     {
/* 14034 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14035 */       localSQLException.fillInStackTrace();
/* 14036 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryDoubleAtName(String paramString, double paramDouble)
/*       */     throws SQLException
/*       */   {
/* 14056 */     if (paramString == null)
/*       */     {
/* 14058 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14059 */       ((SQLException)localObject).fillInStackTrace();
/* 14060 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14065 */     Object localObject = paramString.intern();
/* 14066 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14067 */     int i = 0;
/* 14068 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14070 */     for (int k = 0; k < j; k++) {
/* 14071 */       if (arrayOfString[k] == localObject) {
/* 14072 */         setBinaryDouble(k + 1, paramDouble);
/*       */ 
/* 14074 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14078 */     if (i == 0)
/*       */     {
/* 14080 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14081 */       localSQLException.fillInStackTrace();
/* 14082 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryDoubleAtName(String paramString, BINARY_DOUBLE paramBINARY_DOUBLE)
/*       */     throws SQLException
/*       */   {
/* 14102 */     if (paramString == null)
/*       */     {
/* 14104 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14105 */       ((SQLException)localObject).fillInStackTrace();
/* 14106 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14111 */     Object localObject = paramString.intern();
/* 14112 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14113 */     int i = 0;
/* 14114 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14116 */     for (int k = 0; k < j; k++) {
/* 14117 */       if (arrayOfString[k] == localObject) {
/* 14118 */         setBinaryDouble(k + 1, paramBINARY_DOUBLE);
/*       */ 
/* 14120 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14124 */     if (i == 0)
/*       */     {
/* 14126 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14127 */       localSQLException.fillInStackTrace();
/* 14128 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBLOBAtName(String paramString, BLOB paramBLOB)
/*       */     throws SQLException
/*       */   {
/* 14148 */     if (paramString == null)
/*       */     {
/* 14150 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14151 */       ((SQLException)localObject).fillInStackTrace();
/* 14152 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14157 */     Object localObject = paramString.intern();
/* 14158 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14159 */     int i = 0;
/* 14160 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14162 */     for (int k = 0; k < j; k++) {
/* 14163 */       if (arrayOfString[k] == localObject) {
/* 14164 */         setBLOB(k + 1, paramBLOB);
/*       */ 
/* 14166 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14170 */     if (i == 0)
/*       */     {
/* 14172 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14173 */       localSQLException.fillInStackTrace();
/* 14174 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCHARAtName(String paramString, CHAR paramCHAR)
/*       */     throws SQLException
/*       */   {
/* 14194 */     if (paramString == null)
/*       */     {
/* 14196 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14197 */       ((SQLException)localObject).fillInStackTrace();
/* 14198 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14203 */     Object localObject = paramString.intern();
/* 14204 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14205 */     int i = 0;
/* 14206 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14208 */     for (int k = 0; k < j; k++) {
/* 14209 */       if (arrayOfString[k] == localObject) {
/* 14210 */         setCHAR(k + 1, paramCHAR);
/*       */ 
/* 14212 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14216 */     if (i == 0)
/*       */     {
/* 14218 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14219 */       localSQLException.fillInStackTrace();
/* 14220 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCLOBAtName(String paramString, CLOB paramCLOB)
/*       */     throws SQLException
/*       */   {
/* 14240 */     if (paramString == null)
/*       */     {
/* 14242 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14243 */       ((SQLException)localObject).fillInStackTrace();
/* 14244 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14249 */     Object localObject = paramString.intern();
/* 14250 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14251 */     int i = 0;
/* 14252 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14254 */     for (int k = 0; k < j; k++) {
/* 14255 */       if (arrayOfString[k] == localObject) {
/* 14256 */         setCLOB(k + 1, paramCLOB);
/*       */ 
/* 14258 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14262 */     if (i == 0)
/*       */     {
/* 14264 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14265 */       localSQLException.fillInStackTrace();
/* 14266 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCursorAtName(String paramString, ResultSet paramResultSet)
/*       */     throws SQLException
/*       */   {
/* 14286 */     if (paramString == null)
/*       */     {
/* 14288 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14289 */       ((SQLException)localObject).fillInStackTrace();
/* 14290 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14295 */     Object localObject = paramString.intern();
/* 14296 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14297 */     int i = 0;
/* 14298 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14300 */     for (int k = 0; k < j; k++) {
/* 14301 */       if (arrayOfString[k] == localObject) {
/* 14302 */         setCursor(k + 1, paramResultSet);
/*       */ 
/* 14304 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14308 */     if (i == 0)
/*       */     {
/* 14310 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14311 */       localSQLException.fillInStackTrace();
/* 14312 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDATEAtName(String paramString, DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/* 14332 */     if (paramString == null)
/*       */     {
/* 14334 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14335 */       ((SQLException)localObject).fillInStackTrace();
/* 14336 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14341 */     Object localObject = paramString.intern();
/* 14342 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14343 */     int i = 0;
/* 14344 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14346 */     for (int k = 0; k < j; k++) {
/* 14347 */       if (arrayOfString[k] == localObject) {
/* 14348 */         setDATE(k + 1, paramDATE);
/*       */ 
/* 14350 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14354 */     if (i == 0)
/*       */     {
/* 14356 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14357 */       localSQLException.fillInStackTrace();
/* 14358 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setFixedCHARAtName(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/* 14378 */     if (paramString1 == null)
/*       */     {
/* 14380 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14381 */       ((SQLException)localObject).fillInStackTrace();
/* 14382 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14387 */     Object localObject = paramString1.intern();
/* 14388 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14389 */     int i = 0;
/* 14390 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14392 */     for (int k = 0; k < j; k++) {
/* 14393 */       if (arrayOfString[k] == localObject) {
/* 14394 */         setFixedCHAR(k + 1, paramString2);
/*       */ 
/* 14396 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14400 */     if (i == 0)
/*       */     {
/* 14402 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/* 14403 */       localSQLException.fillInStackTrace();
/* 14404 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setINTERVALDSAtName(String paramString, INTERVALDS paramINTERVALDS)
/*       */     throws SQLException
/*       */   {
/* 14424 */     if (paramString == null)
/*       */     {
/* 14426 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14427 */       ((SQLException)localObject).fillInStackTrace();
/* 14428 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14433 */     Object localObject = paramString.intern();
/* 14434 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14435 */     int i = 0;
/* 14436 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14438 */     for (int k = 0; k < j; k++) {
/* 14439 */       if (arrayOfString[k] == localObject) {
/* 14440 */         setINTERVALDS(k + 1, paramINTERVALDS);
/*       */ 
/* 14442 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14446 */     if (i == 0)
/*       */     {
/* 14448 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14449 */       localSQLException.fillInStackTrace();
/* 14450 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setINTERVALYMAtName(String paramString, INTERVALYM paramINTERVALYM)
/*       */     throws SQLException
/*       */   {
/* 14470 */     if (paramString == null)
/*       */     {
/* 14472 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14473 */       ((SQLException)localObject).fillInStackTrace();
/* 14474 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14479 */     Object localObject = paramString.intern();
/* 14480 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14481 */     int i = 0;
/* 14482 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14484 */     for (int k = 0; k < j; k++) {
/* 14485 */       if (arrayOfString[k] == localObject) {
/* 14486 */         setINTERVALYM(k + 1, paramINTERVALYM);
/*       */ 
/* 14488 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14492 */     if (i == 0)
/*       */     {
/* 14494 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14495 */       localSQLException.fillInStackTrace();
/* 14496 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNUMBERAtName(String paramString, NUMBER paramNUMBER)
/*       */     throws SQLException
/*       */   {
/* 14516 */     if (paramString == null)
/*       */     {
/* 14518 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14519 */       ((SQLException)localObject).fillInStackTrace();
/* 14520 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14525 */     Object localObject = paramString.intern();
/* 14526 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14527 */     int i = 0;
/* 14528 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14530 */     for (int k = 0; k < j; k++) {
/* 14531 */       if (arrayOfString[k] == localObject) {
/* 14532 */         setNUMBER(k + 1, paramNUMBER);
/*       */ 
/* 14534 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14538 */     if (i == 0)
/*       */     {
/* 14540 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14541 */       localSQLException.fillInStackTrace();
/* 14542 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setOPAQUEAtName(String paramString, OPAQUE paramOPAQUE)
/*       */     throws SQLException
/*       */   {
/* 14562 */     if (paramString == null)
/*       */     {
/* 14564 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14565 */       ((SQLException)localObject).fillInStackTrace();
/* 14566 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14571 */     Object localObject = paramString.intern();
/* 14572 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14573 */     int i = 0;
/* 14574 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14576 */     for (int k = 0; k < j; k++) {
/* 14577 */       if (arrayOfString[k] == localObject) {
/* 14578 */         setOPAQUE(k + 1, paramOPAQUE);
/*       */ 
/* 14580 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14584 */     if (i == 0)
/*       */     {
/* 14586 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14587 */       localSQLException.fillInStackTrace();
/* 14588 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setOracleObjectAtName(String paramString, Datum paramDatum)
/*       */     throws SQLException
/*       */   {
/* 14608 */     if (paramString == null)
/*       */     {
/* 14610 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14611 */       ((SQLException)localObject).fillInStackTrace();
/* 14612 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14617 */     Object localObject = paramString.intern();
/* 14618 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14619 */     int i = 0;
/* 14620 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14622 */     for (int k = 0; k < j; k++) {
/* 14623 */       if (arrayOfString[k] == localObject) {
/* 14624 */         setOracleObject(k + 1, paramDatum);
/*       */ 
/* 14626 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14630 */     if (i == 0)
/*       */     {
/* 14632 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14633 */       localSQLException.fillInStackTrace();
/* 14634 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setORADataAtName(String paramString, ORAData paramORAData)
/*       */     throws SQLException
/*       */   {
/* 14654 */     if (paramString == null)
/*       */     {
/* 14656 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14657 */       ((SQLException)localObject).fillInStackTrace();
/* 14658 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14663 */     Object localObject = paramString.intern();
/* 14664 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14665 */     int i = 0;
/* 14666 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14668 */     for (int k = 0; k < j; k++) {
/* 14669 */       if (arrayOfString[k] == localObject) {
/* 14670 */         setORAData(k + 1, paramORAData);
/*       */ 
/* 14672 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14676 */     if (i == 0)
/*       */     {
/* 14678 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14679 */       localSQLException.fillInStackTrace();
/* 14680 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setRAWAtName(String paramString, RAW paramRAW)
/*       */     throws SQLException
/*       */   {
/* 14700 */     if (paramString == null)
/*       */     {
/* 14702 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14703 */       ((SQLException)localObject).fillInStackTrace();
/* 14704 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14709 */     Object localObject = paramString.intern();
/* 14710 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14711 */     int i = 0;
/* 14712 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14714 */     for (int k = 0; k < j; k++) {
/* 14715 */       if (arrayOfString[k] == localObject) {
/* 14716 */         setRAW(k + 1, paramRAW);
/*       */ 
/* 14718 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14722 */     if (i == 0)
/*       */     {
/* 14724 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14725 */       localSQLException.fillInStackTrace();
/* 14726 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setREFAtName(String paramString, REF paramREF)
/*       */     throws SQLException
/*       */   {
/* 14746 */     if (paramString == null)
/*       */     {
/* 14748 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14749 */       ((SQLException)localObject).fillInStackTrace();
/* 14750 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14755 */     Object localObject = paramString.intern();
/* 14756 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14757 */     int i = 0;
/* 14758 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14760 */     for (int k = 0; k < j; k++) {
/* 14761 */       if (arrayOfString[k] == localObject) {
/* 14762 */         setREF(k + 1, paramREF);
/*       */ 
/* 14764 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14768 */     if (i == 0)
/*       */     {
/* 14770 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14771 */       localSQLException.fillInStackTrace();
/* 14772 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setRefTypeAtName(String paramString, REF paramREF)
/*       */     throws SQLException
/*       */   {
/* 14792 */     if (paramString == null)
/*       */     {
/* 14794 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14795 */       ((SQLException)localObject).fillInStackTrace();
/* 14796 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14801 */     Object localObject = paramString.intern();
/* 14802 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14803 */     int i = 0;
/* 14804 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14806 */     for (int k = 0; k < j; k++) {
/* 14807 */       if (arrayOfString[k] == localObject) {
/* 14808 */         setRefType(k + 1, paramREF);
/*       */ 
/* 14810 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14814 */     if (i == 0)
/*       */     {
/* 14816 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14817 */       localSQLException.fillInStackTrace();
/* 14818 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setROWIDAtName(String paramString, ROWID paramROWID)
/*       */     throws SQLException
/*       */   {
/* 14838 */     if (paramString == null)
/*       */     {
/* 14840 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14841 */       ((SQLException)localObject).fillInStackTrace();
/* 14842 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14847 */     Object localObject = paramString.intern();
/* 14848 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14849 */     int i = 0;
/* 14850 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14852 */     for (int k = 0; k < j; k++) {
/* 14853 */       if (arrayOfString[k] == localObject) {
/* 14854 */         setROWID(k + 1, paramROWID);
/*       */ 
/* 14856 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14860 */     if (i == 0)
/*       */     {
/* 14862 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14863 */       localSQLException.fillInStackTrace();
/* 14864 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setSTRUCTAtName(String paramString, STRUCT paramSTRUCT)
/*       */     throws SQLException
/*       */   {
/* 14884 */     if (paramString == null)
/*       */     {
/* 14886 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14887 */       ((SQLException)localObject).fillInStackTrace();
/* 14888 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14893 */     Object localObject = paramString.intern();
/* 14894 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14895 */     int i = 0;
/* 14896 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14898 */     for (int k = 0; k < j; k++) {
/* 14899 */       if (arrayOfString[k] == localObject) {
/* 14900 */         setSTRUCT(k + 1, paramSTRUCT);
/*       */ 
/* 14902 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14906 */     if (i == 0)
/*       */     {
/* 14908 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14909 */       localSQLException.fillInStackTrace();
/* 14910 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPLTZAtName(String paramString, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*       */     throws SQLException
/*       */   {
/* 14930 */     if (paramString == null)
/*       */     {
/* 14932 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14933 */       ((SQLException)localObject).fillInStackTrace();
/* 14934 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14939 */     Object localObject = paramString.intern();
/* 14940 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14941 */     int i = 0;
/* 14942 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14944 */     for (int k = 0; k < j; k++) {
/* 14945 */       if (arrayOfString[k] == localObject) {
/* 14946 */         setTIMESTAMPLTZ(k + 1, paramTIMESTAMPLTZ);
/*       */ 
/* 14948 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14952 */     if (i == 0)
/*       */     {
/* 14954 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 14955 */       localSQLException.fillInStackTrace();
/* 14956 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPTZAtName(String paramString, TIMESTAMPTZ paramTIMESTAMPTZ)
/*       */     throws SQLException
/*       */   {
/* 14976 */     if (paramString == null)
/*       */     {
/* 14978 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 14979 */       ((SQLException)localObject).fillInStackTrace();
/* 14980 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 14985 */     Object localObject = paramString.intern();
/* 14986 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 14987 */     int i = 0;
/* 14988 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 14990 */     for (int k = 0; k < j; k++) {
/* 14991 */       if (arrayOfString[k] == localObject) {
/* 14992 */         setTIMESTAMPTZ(k + 1, paramTIMESTAMPTZ);
/*       */ 
/* 14994 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 14998 */     if (i == 0)
/*       */     {
/* 15000 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15001 */       localSQLException.fillInStackTrace();
/* 15002 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPAtName(String paramString, TIMESTAMP paramTIMESTAMP)
/*       */     throws SQLException
/*       */   {
/* 15022 */     if (paramString == null)
/*       */     {
/* 15024 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15025 */       ((SQLException)localObject).fillInStackTrace();
/* 15026 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15031 */     Object localObject = paramString.intern();
/* 15032 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15033 */     int i = 0;
/* 15034 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 15036 */     for (int k = 0; k < j; k++) {
/* 15037 */       if (arrayOfString[k] == localObject) {
/* 15038 */         setTIMESTAMP(k + 1, paramTIMESTAMP);
/*       */ 
/* 15040 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 15044 */     if (i == 0)
/*       */     {
/* 15046 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15047 */       localSQLException.fillInStackTrace();
/* 15048 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCustomDatumAtName(String paramString, CustomDatum paramCustomDatum)
/*       */     throws SQLException
/*       */   {
/* 15068 */     if (paramString == null)
/*       */     {
/* 15070 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15071 */       ((SQLException)localObject).fillInStackTrace();
/* 15072 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15077 */     Object localObject = paramString.intern();
/* 15078 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15079 */     int i = 0;
/* 15080 */     int j = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*       */ 
/* 15082 */     for (int k = 0; k < j; k++) {
/* 15083 */       if (arrayOfString[k] == localObject) {
/* 15084 */         setCustomDatum(k + 1, paramCustomDatum);
/*       */ 
/* 15086 */         i = 1;
/*       */       }
/*       */     }
/*       */ 
/* 15090 */     if (i == 0)
/*       */     {
/* 15092 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15093 */       localSQLException.fillInStackTrace();
/* 15094 */       throw localSQLException;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBlobAtName(String paramString, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 15116 */     if (paramString == null)
/*       */     {
/* 15118 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15119 */       ((SQLException)localObject).fillInStackTrace();
/* 15120 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15125 */     Object localObject = paramString.intern();
/* 15126 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15127 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15128 */     int j = 1;
/*       */ 
/* 15130 */     for (int k = 0; k < i; k++) {
/* 15131 */       if (arrayOfString[k] == localObject) {
/* 15132 */         if (j != 0) {
/* 15133 */           setBlob(k + 1, paramInputStream);
/*       */ 
/* 15135 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15139 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15140 */           localSQLException2.fillInStackTrace();
/* 15141 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15146 */     if (j != 0)
/*       */     {
/* 15148 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15149 */       localSQLException1.fillInStackTrace();
/* 15150 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBlobAtName(String paramString, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15170 */     if (paramString == null)
/*       */     {
/* 15172 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15173 */       ((SQLException)localObject).fillInStackTrace();
/* 15174 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15179 */     Object localObject = paramString.intern();
/* 15180 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15181 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15182 */     int j = 1;
/*       */ 
/* 15184 */     for (int k = 0; k < i; k++) {
/* 15185 */       if (arrayOfString[k] == localObject) {
/* 15186 */         if (j != 0) {
/* 15187 */           setBlob(k + 1, paramInputStream, paramLong);
/*       */ 
/* 15189 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15193 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15194 */           localSQLException2.fillInStackTrace();
/* 15195 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15200 */     if (j != 0)
/*       */     {
/* 15202 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15203 */       localSQLException1.fillInStackTrace();
/* 15204 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setClobAtName(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 15224 */     if (paramString == null)
/*       */     {
/* 15226 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15227 */       ((SQLException)localObject).fillInStackTrace();
/* 15228 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15233 */     Object localObject = paramString.intern();
/* 15234 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15235 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15236 */     int j = 1;
/*       */ 
/* 15238 */     for (int k = 0; k < i; k++) {
/* 15239 */       if (arrayOfString[k] == localObject) {
/* 15240 */         if (j != 0) {
/* 15241 */           setClob(k + 1, paramReader);
/*       */ 
/* 15243 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15247 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15248 */           localSQLException2.fillInStackTrace();
/* 15249 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15254 */     if (j != 0)
/*       */     {
/* 15256 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15257 */       localSQLException1.fillInStackTrace();
/* 15258 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setClobAtName(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15278 */     if (paramString == null)
/*       */     {
/* 15280 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15281 */       ((SQLException)localObject).fillInStackTrace();
/* 15282 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15287 */     Object localObject = paramString.intern();
/* 15288 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15289 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15290 */     int j = 1;
/*       */ 
/* 15292 */     for (int k = 0; k < i; k++) {
/* 15293 */       if (arrayOfString[k] == localObject) {
/* 15294 */         if (j != 0) {
/* 15295 */           setClob(k + 1, paramReader, paramLong);
/*       */ 
/* 15297 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15301 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15302 */           localSQLException2.fillInStackTrace();
/* 15303 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15308 */     if (j != 0)
/*       */     {
/* 15310 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15311 */       localSQLException1.fillInStackTrace();
/* 15312 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNClobAtName(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 15332 */     if (paramString == null)
/*       */     {
/* 15334 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15335 */       ((SQLException)localObject).fillInStackTrace();
/* 15336 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15341 */     Object localObject = paramString.intern();
/* 15342 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15343 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15344 */     int j = 1;
/*       */ 
/* 15346 */     for (int k = 0; k < i; k++) {
/* 15347 */       if (arrayOfString[k] == localObject) {
/* 15348 */         if (j != 0) {
/* 15349 */           setNClob(k + 1, paramReader);
/*       */ 
/* 15351 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15355 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15356 */           localSQLException2.fillInStackTrace();
/* 15357 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15362 */     if (j != 0)
/*       */     {
/* 15364 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15365 */       localSQLException1.fillInStackTrace();
/* 15366 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNClobAtName(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15386 */     if (paramString == null)
/*       */     {
/* 15388 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15389 */       ((SQLException)localObject).fillInStackTrace();
/* 15390 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15395 */     Object localObject = paramString.intern();
/* 15396 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15397 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15398 */     int j = 1;
/*       */ 
/* 15400 */     for (int k = 0; k < i; k++) {
/* 15401 */       if (arrayOfString[k] == localObject) {
/* 15402 */         if (j != 0) {
/* 15403 */           setNClob(k + 1, paramReader, paramLong);
/*       */ 
/* 15405 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15409 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15410 */           localSQLException2.fillInStackTrace();
/* 15411 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15416 */     if (j != 0)
/*       */     {
/* 15418 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15419 */       localSQLException1.fillInStackTrace();
/* 15420 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStreamAtName(String paramString, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 15440 */     if (paramString == null)
/*       */     {
/* 15442 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15443 */       ((SQLException)localObject).fillInStackTrace();
/* 15444 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15449 */     Object localObject = paramString.intern();
/* 15450 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15451 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15452 */     int j = 1;
/*       */ 
/* 15454 */     for (int k = 0; k < i; k++) {
/* 15455 */       if (arrayOfString[k] == localObject) {
/* 15456 */         if (j != 0) {
/* 15457 */           setAsciiStream(k + 1, paramInputStream);
/*       */ 
/* 15459 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15463 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15464 */           localSQLException2.fillInStackTrace();
/* 15465 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15470 */     if (j != 0)
/*       */     {
/* 15472 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15473 */       localSQLException1.fillInStackTrace();
/* 15474 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStreamAtName(String paramString, InputStream paramInputStream, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 15494 */     if (paramString == null)
/*       */     {
/* 15496 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15497 */       ((SQLException)localObject).fillInStackTrace();
/* 15498 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15503 */     Object localObject = paramString.intern();
/* 15504 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15505 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15506 */     int j = 1;
/*       */ 
/* 15508 */     for (int k = 0; k < i; k++) {
/* 15509 */       if (arrayOfString[k] == localObject) {
/* 15510 */         if (j != 0) {
/* 15511 */           setAsciiStream(k + 1, paramInputStream, paramInt);
/*       */ 
/* 15513 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15517 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15518 */           localSQLException2.fillInStackTrace();
/* 15519 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15524 */     if (j != 0)
/*       */     {
/* 15526 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15527 */       localSQLException1.fillInStackTrace();
/* 15528 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStreamAtName(String paramString, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15548 */     if (paramString == null)
/*       */     {
/* 15550 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15551 */       ((SQLException)localObject).fillInStackTrace();
/* 15552 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15557 */     Object localObject = paramString.intern();
/* 15558 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15559 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15560 */     int j = 1;
/*       */ 
/* 15562 */     for (int k = 0; k < i; k++) {
/* 15563 */       if (arrayOfString[k] == localObject) {
/* 15564 */         if (j != 0) {
/* 15565 */           setAsciiStream(k + 1, paramInputStream, paramLong);
/*       */ 
/* 15567 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15571 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15572 */           localSQLException2.fillInStackTrace();
/* 15573 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15578 */     if (j != 0)
/*       */     {
/* 15580 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15581 */       localSQLException1.fillInStackTrace();
/* 15582 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryStreamAtName(String paramString, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/* 15602 */     if (paramString == null)
/*       */     {
/* 15604 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15605 */       ((SQLException)localObject).fillInStackTrace();
/* 15606 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15611 */     Object localObject = paramString.intern();
/* 15612 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15613 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15614 */     int j = 1;
/*       */ 
/* 15616 */     for (int k = 0; k < i; k++) {
/* 15617 */       if (arrayOfString[k] == localObject) {
/* 15618 */         if (j != 0) {
/* 15619 */           setBinaryStream(k + 1, paramInputStream);
/*       */ 
/* 15621 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15625 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15626 */           localSQLException2.fillInStackTrace();
/* 15627 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15632 */     if (j != 0)
/*       */     {
/* 15634 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15635 */       localSQLException1.fillInStackTrace();
/* 15636 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryStreamAtName(String paramString, InputStream paramInputStream, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 15656 */     if (paramString == null)
/*       */     {
/* 15658 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15659 */       ((SQLException)localObject).fillInStackTrace();
/* 15660 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15665 */     Object localObject = paramString.intern();
/* 15666 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15667 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15668 */     int j = 1;
/*       */ 
/* 15670 */     for (int k = 0; k < i; k++) {
/* 15671 */       if (arrayOfString[k] == localObject) {
/* 15672 */         if (j != 0) {
/* 15673 */           setBinaryStream(k + 1, paramInputStream, paramInt);
/*       */ 
/* 15675 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15679 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15680 */           localSQLException2.fillInStackTrace();
/* 15681 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15686 */     if (j != 0)
/*       */     {
/* 15688 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15689 */       localSQLException1.fillInStackTrace();
/* 15690 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryStreamAtName(String paramString, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15710 */     if (paramString == null)
/*       */     {
/* 15712 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15713 */       ((SQLException)localObject).fillInStackTrace();
/* 15714 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15719 */     Object localObject = paramString.intern();
/* 15720 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15721 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15722 */     int j = 1;
/*       */ 
/* 15724 */     for (int k = 0; k < i; k++) {
/* 15725 */       if (arrayOfString[k] == localObject) {
/* 15726 */         if (j != 0) {
/* 15727 */           setBinaryStream(k + 1, paramInputStream, paramLong);
/*       */ 
/* 15729 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15733 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15734 */           localSQLException2.fillInStackTrace();
/* 15735 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15740 */     if (j != 0)
/*       */     {
/* 15742 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15743 */       localSQLException1.fillInStackTrace();
/* 15744 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStreamAtName(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 15764 */     if (paramString == null)
/*       */     {
/* 15766 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15767 */       ((SQLException)localObject).fillInStackTrace();
/* 15768 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15773 */     Object localObject = paramString.intern();
/* 15774 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15775 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15776 */     int j = 1;
/*       */ 
/* 15778 */     for (int k = 0; k < i; k++) {
/* 15779 */       if (arrayOfString[k] == localObject) {
/* 15780 */         if (j != 0) {
/* 15781 */           setCharacterStream(k + 1, paramReader);
/*       */ 
/* 15783 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15787 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15788 */           localSQLException2.fillInStackTrace();
/* 15789 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15794 */     if (j != 0)
/*       */     {
/* 15796 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15797 */       localSQLException1.fillInStackTrace();
/* 15798 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStreamAtName(String paramString, Reader paramReader, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 15818 */     if (paramString == null)
/*       */     {
/* 15820 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15821 */       ((SQLException)localObject).fillInStackTrace();
/* 15822 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15827 */     Object localObject = paramString.intern();
/* 15828 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15829 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15830 */     int j = 1;
/*       */ 
/* 15832 */     for (int k = 0; k < i; k++) {
/* 15833 */       if (arrayOfString[k] == localObject) {
/* 15834 */         if (j != 0) {
/* 15835 */           setCharacterStream(k + 1, paramReader, paramInt);
/*       */ 
/* 15837 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15841 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15842 */           localSQLException2.fillInStackTrace();
/* 15843 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15848 */     if (j != 0)
/*       */     {
/* 15850 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15851 */       localSQLException1.fillInStackTrace();
/* 15852 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStreamAtName(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15872 */     if (paramString == null)
/*       */     {
/* 15874 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15875 */       ((SQLException)localObject).fillInStackTrace();
/* 15876 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15881 */     Object localObject = paramString.intern();
/* 15882 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15883 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15884 */     int j = 1;
/*       */ 
/* 15886 */     for (int k = 0; k < i; k++) {
/* 15887 */       if (arrayOfString[k] == localObject) {
/* 15888 */         if (j != 0) {
/* 15889 */           setCharacterStream(k + 1, paramReader, paramLong);
/*       */ 
/* 15891 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15895 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15896 */           localSQLException2.fillInStackTrace();
/* 15897 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15902 */     if (j != 0)
/*       */     {
/* 15904 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15905 */       localSQLException1.fillInStackTrace();
/* 15906 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNCharacterStreamAtName(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/* 15926 */     if (paramString == null)
/*       */     {
/* 15928 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15929 */       ((SQLException)localObject).fillInStackTrace();
/* 15930 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15935 */     Object localObject = paramString.intern();
/* 15936 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15937 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15938 */     int j = 1;
/*       */ 
/* 15940 */     for (int k = 0; k < i; k++) {
/* 15941 */       if (arrayOfString[k] == localObject) {
/* 15942 */         if (j != 0) {
/* 15943 */           setNCharacterStream(k + 1, paramReader);
/*       */ 
/* 15945 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 15949 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 15950 */           localSQLException2.fillInStackTrace();
/* 15951 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 15956 */     if (j != 0)
/*       */     {
/* 15958 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 15959 */       localSQLException1.fillInStackTrace();
/* 15960 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNCharacterStreamAtName(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/* 15980 */     if (paramString == null)
/*       */     {
/* 15982 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 15983 */       ((SQLException)localObject).fillInStackTrace();
/* 15984 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 15989 */     Object localObject = paramString.intern();
/* 15990 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 15991 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 15992 */     int j = 1;
/*       */ 
/* 15994 */     for (int k = 0; k < i; k++) {
/* 15995 */       if (arrayOfString[k] == localObject) {
/* 15996 */         if (j != 0) {
/* 15997 */           setNCharacterStream(k + 1, paramReader, paramLong);
/*       */ 
/* 15999 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 16003 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 16004 */           localSQLException2.fillInStackTrace();
/* 16005 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 16010 */     if (j != 0)
/*       */     {
/* 16012 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 16013 */       localSQLException1.fillInStackTrace();
/* 16014 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setUnicodeStreamAtName(String paramString, InputStream paramInputStream, int paramInt)
/*       */     throws SQLException
/*       */   {
/* 16034 */     if (paramString == null)
/*       */     {
/* 16036 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 16037 */       ((SQLException)localObject).fillInStackTrace();
/* 16038 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 16043 */     Object localObject = paramString.intern();
/* 16044 */     String[] arrayOfString = this.sqlObject.getParameterList();
/* 16045 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/* 16046 */     int j = 1;
/*       */ 
/* 16048 */     for (int k = 0; k < i; k++) {
/* 16049 */       if (arrayOfString[k] == localObject) {
/* 16050 */         if (j != 0) {
/* 16051 */           setUnicodeStream(k + 1, paramInputStream, paramInt);
/*       */ 
/* 16053 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/* 16057 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/* 16058 */           localSQLException2.fillInStackTrace();
/* 16059 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/* 16064 */     if (j != 0)
/*       */     {
/* 16066 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 16067 */       localSQLException1.fillInStackTrace();
/* 16068 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   class PushedBatch
/*       */   {
/*       */     int[] currentBatchByteLens;
/*       */     int[] currentBatchCharLens;
/*       */     int[] lastBoundByteLens;
/*       */     int[] lastBoundCharLens;
/*       */     Accessor[] currentBatchBindAccessors;
/*       */     boolean lastBoundNeeded;
/*       */     boolean need_to_parse;
/*       */     boolean current_batch_need_to_prepare_binds;
/*       */     int first_row_in_batch;
/*       */     int number_of_rows_to_be_bound;
/*       */     PushedBatch next;
/*       */ 
/*       */     PushedBatch()
/*       */     {
/*       */     }
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OraclePreparedStatement
 * JD-Core Version:    0.6.2
 */