/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ public class OracleParameterMetaDataParser
/*     */ {
/*     */   static final int UNINITIALIZED = -1;
/*  39 */   static final String[] EMPTY_LIST = new String[0];
/*     */   String parameterSql;
/*  43 */   OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
/*  44 */   int parameterCount = -1;
/*     */   boolean needToParseSql;
/*     */   private static final int cMax = 127;
/*  91 */   private static final int[][] TRANSITION = OracleParameterMetaDataParserStates.TRANSITION;
/*     */ 
/*  94 */   private static final int[][] ACTION = OracleParameterMetaDataParserStates.ACTION;
/*     */   private static final int NO_ACTION = 0;
/*     */   private static final int WHERE_ACTION = 2;
/*     */   private static final int PARAMETER_ACTION = 3;
/*     */   private static final int END_PARAMETER_ACTION = 4;
/*     */   private static final int COUNT_BIND_ACTION = 5;
/*     */   private static final int START_NCHAR_LITERAL_ACTION = 6;
/*     */   private static final int END_NCHAR_LITERAL_ACTION = 7;
/*     */   private static final int SAVE_DELIMITER_ACTION = 8;
/*     */   private static final int LOOK_FOR_DELIMITER_ACTION = 9;
/*     */   private static final int RECORD_TABLE_NAME_ACTION = 10;
/*     */   private static final int END_RECORD_TABLE_NAME_ACTION = 11;
/*     */   private static final int DONE_RECORD_TABLE_NAME_ACTION = 12;
/*     */   private static final int START_RECORD_COLUMN_NAME_ACTION = 13;
/*     */   private static final int RECORD_COLUMN_NAME_ACTION = 14;
/*     */   private static final int END_RECORD_COLUMN_NAME_ACTION = 15;
/*     */   private static final int DONE_RECORD_COLUMN_NAME_ACTION = 16;
/*     */   private static final int NO_PARAMETER_METADATA_ACTION = 17;
/*     */   private static final int BEGIN_COMMENT_ACTION = 18;
/*     */   private static final int END_COMMENT_ACTION = 19;
/*     */   private static final int RESET_RECORDING_ACTION = 20;
/*     */   private static final int INITIAL_STATE = 0;
/*     */   private static final int RESTART_STATE = 22;
/*     */   private static final boolean DEBUG_CBI = false;
/* 135 */   ArrayList<String> tableName = new ArrayList();
/* 136 */   ArrayList<String> columnName = new ArrayList();
/* 137 */   byte[] bindStatusForInsert = null;
/* 138 */   char[] currentParameter = null;
/*     */ 
/* 643 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected void initialize(String paramString, OracleStatement.SqlKind paramSqlKind, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  74 */     if ((paramString == null) || (paramString.length() == 0))
/*     */     {
/*  76 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 104);
/*  77 */       localSQLException.fillInStackTrace();
/*  78 */       throw localSQLException;
/*     */     }
/*     */ 
/*  81 */     this.sqlKind = paramSqlKind;
/*  82 */     this.parameterSql = paramString;
/*  83 */     this.parameterCount = paramInt;
/*     */ 
/*  85 */     this.needToParseSql = true;
/*     */   }
/*     */ 
/*     */   void computeBasicInfo(String paramString)
/*     */     throws SQLException
/*     */   {
/* 144 */     int i = 0;
/*     */ 
/* 146 */     int j = 0;
/*     */ 
/* 148 */     int k = 0;
/*     */ 
/* 150 */     int m = 0;
/* 151 */     int n = paramString.length();
/* 152 */     int i1 = n + 1;
/*     */ 
/* 154 */     char[] arrayOfChar = new char[''];
/* 155 */     int i2 = 0;
/* 156 */     int i3 = 0;
/* 157 */     this.columnName.clear();
/* 158 */     this.tableName.clear();
/* 159 */     int i4 = 0;
/* 160 */     int i5 = 0;
/* 161 */     int i6 = 0;
/* 162 */     int i7 = 0;
/* 163 */     int i8 = 0;
/* 164 */     int i9 = 1;
/* 165 */     int i10 = -1;
/*     */ 
/* 167 */     this.bindStatusForInsert = null;
/*     */ 
/* 171 */     for (int i11 = 0; i11 < i1; i11++)
/*     */     {
/* 173 */       char c1 = i11 < n ? paramString.charAt(i11) : ' ';
/* 174 */       char c2 = c1;
/*     */ 
/* 176 */       if (c1 > '')
/*     */       {
/* 179 */         if (Character.isLetterOrDigit(c1))
/* 180 */           c2 = 'X';
/*     */         else
/* 182 */           c2 = ' ';
/*     */       }
/*     */       Object localObject;
/* 199 */       switch (ACTION[m][c2])
/*     */       {
/*     */       case 18:
/* 203 */         i10 = m;
/* 204 */         m = c2 == '/' ? 18 : 20;
/* 205 */         break;
/*     */       case 19:
/* 208 */         m = i10;
/* 209 */         i10 = -1;
/* 210 */         break;
/*     */       case 20:
/* 213 */         i3 = 0;
/* 214 */         i2 = 0;
/* 215 */         i10 = 68;
/* 216 */         break;
/*     */       case 0:
/* 219 */         break;
/*     */       case 2:
/* 222 */         i2 -= 5;
/* 223 */         break;
/*     */       case 3:
/* 227 */         if (i3 > 0)
/*     */         {
/* 229 */           String str = new String(arrayOfChar, 0, i3);
/* 230 */           if (str.trim().length() > 0)
/* 231 */             this.columnName.add(str);
/*     */         }
/* 233 */         i3 = 0;
/*     */ 
/* 235 */         if (k == 0)
/*     */         {
/* 237 */           i7 = i11;
/*     */         }
/*     */ 
/* 240 */         k++;
/* 241 */         i4 = 1;
/* 242 */         break;
/*     */       case 5:
/* 246 */         if (i4 != 0)
/*     */         {
/* 248 */           if (this.bindStatusForInsert == null)
/*     */           {
/* 250 */             int i12 = Math.max(50, i >> 1);
/* 251 */             this.bindStatusForInsert = new byte[i12];
/* 252 */           } else if (i >= this.bindStatusForInsert.length)
/*     */           {
/* 254 */             localObject = new byte[this.bindStatusForInsert.length << 1];
/* 255 */             System.arraycopy(this.bindStatusForInsert, 0, localObject, 0, this.bindStatusForInsert.length);
/*     */ 
/* 258 */             this.bindStatusForInsert = ((byte[])localObject);
/*     */           }
/* 260 */           this.bindStatusForInsert[i] = 1;
/*     */         }
/* 262 */         i8 = i11;
/* 263 */         i++;
/* 264 */         i4 = 0;
/*     */       case 4:
/* 270 */         i4 = 0;
/* 271 */         k = 0;
/*     */ 
/* 273 */         break;
/*     */       case 10:
/* 276 */         arrayOfChar[(i2++)] = c2;
/* 277 */         break;
/*     */       case 11:
/* 281 */         if (i2 > 0)
/*     */         {
/* 283 */           localObject = new String(arrayOfChar, 0, i2).trim();
/* 284 */           if (((String)localObject).length() > 0)
/* 285 */             this.tableName.add(localObject);
/*     */         }
/* 287 */         i2 = 0;
/*     */ 
/* 289 */         break;
/*     */       case 12:
/* 292 */         if (i2 > 0)
/*     */         {
/* 294 */           localObject = new String(arrayOfChar, 0, i2).trim();
/* 295 */           if (((String)localObject).length() > 0)
/* 296 */             this.tableName.add(localObject);
/* 297 */           i2 = 0;
/* 298 */         }break;
/*     */       case 13:
/* 303 */         if (i2 > 0)
/*     */         {
/* 305 */           localObject = new String(arrayOfChar, 0, i2).trim();
/* 306 */           if (((String)localObject).length() > 0)
/* 307 */             this.tableName.add(localObject);
/* 308 */           i2 = 0;
/*     */         }
/* 310 */         if (this.tableName.isEmpty())
/*     */         {
/* 315 */           i9 = 0;
/*     */         }
/* 317 */         else if (this.sqlKind != OracleStatement.SqlKind.INSERT)
/*     */         {
/* 319 */           i3 = 0;
/* 320 */           arrayOfChar[(i3++)] = c2; } break;
/*     */       case 14:
/* 326 */         arrayOfChar[(i3++)] = c2;
/* 327 */         break;
/*     */       case 15:
/* 330 */         if (i9 != 0)
/*     */         {
/* 332 */           if (i3 > 0)
/*     */           {
/* 334 */             localObject = new String(arrayOfChar, 0, i3);
/* 335 */             if (((String)localObject).trim().length() > 0)
/* 336 */               this.columnName.add(localObject);
/*     */           }
/* 338 */           i3 = 0; } break;
/*     */       case 16:
/* 343 */         if (i9 != 0)
/*     */         {
/* 345 */           if (i3 > 0)
/*     */           {
/* 347 */             localObject = new String(arrayOfChar, 0, i3);
/* 348 */             if (((String)localObject).trim().length() > 0)
/* 349 */               this.columnName.add(localObject);
/*     */           }
/* 351 */           i3 = 0; } break;
/*     */       case 17:
/* 357 */         i9 = 0;
/*     */       case 1:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/* 362 */       case 9: } m = TRANSITION[m][c2];
/*     */     }
/*     */ 
/* 365 */     if (i9 != 0)
/*     */     {
/* 367 */       if ((this.sqlKind == OracleStatement.SqlKind.INSERT) && (i8 < i7))
/*     */       {
/* 370 */         if (this.bindStatusForInsert == null)
/*     */         {
/* 372 */           this.bindStatusForInsert = new byte[50];
/* 373 */         } else if (i >= this.bindStatusForInsert.length)
/*     */         {
/* 375 */           byte[] arrayOfByte = new byte[this.bindStatusForInsert.length << 1];
/* 376 */           System.arraycopy(this.bindStatusForInsert, 0, arrayOfByte, 0, this.bindStatusForInsert.length);
/*     */ 
/* 379 */           this.bindStatusForInsert = arrayOfByte;
/*     */         }
/* 381 */         this.bindStatusForInsert[(i++)] = 1;
/*     */       }
/*     */     } else {
/* 384 */       if (!this.tableName.isEmpty()) this.tableName.clear();
/* 385 */       if (!this.columnName.isEmpty()) this.columnName.clear();
/* 386 */       this.bindStatusForInsert = null;
/* 387 */       i = -1;
/*     */     }
/*     */ 
/* 391 */     this.needToParseSql = false;
/*     */   }
/*     */ 
/*     */   String[] getColumnNames()
/*     */   {
/* 415 */     String[] arrayOfString = new String[this.columnName.size()];
/* 416 */     return (String[])this.columnName.toArray(arrayOfString);
/*     */   }
/*     */ 
/*     */   String[] getTableNames()
/*     */   {
/* 423 */     String[] arrayOfString = new String[this.tableName.size()];
/* 424 */     return (String[])this.tableName.toArray(arrayOfString);
/*     */   }
/*     */ 
/*     */   public String getParameterMetaDataSql()
/*     */     throws SQLException
/*     */   {
/* 432 */     if (this.needToParseSql) computeBasicInfo(this.parameterSql);
/*     */ 
/* 437 */     if ((this.sqlKind.isPlsqlOrCall()) || (this.parameterCount == 0)) {
/* 438 */       return null;
/*     */     }
/* 440 */     String[] arrayOfString1 = getTableNames();
/* 441 */     if ((arrayOfString1 == null) || (arrayOfString1.length == 0)) {
/* 442 */       return null;
/*     */     }
/* 444 */     String[] arrayOfString2 = getColumnNames();
/* 445 */     StringBuilder localStringBuilder = new StringBuilder(100);
/* 446 */     localStringBuilder.append("SELECT ");
/*     */ 
/* 448 */     if (arrayOfString2.length == 0)
/*     */     {
/* 450 */       if (this.sqlKind == OracleStatement.SqlKind.INSERT)
/*     */       {
/* 452 */         localStringBuilder.append("* ");
/*     */       }
/*     */       else {
/* 455 */         return null;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 460 */       i = this.bindStatusForInsert != null ? 1 : 0;
/* 461 */       int j = 0;
/* 462 */       for (int k = 0; k < arrayOfString2.length; k++)
/*     */       {
/* 464 */         if ((i == 0) || (this.bindStatusForInsert[k] == 1))
/*     */         {
/* 467 */           if (j++ != 0)
/* 468 */             localStringBuilder.append(", ");
/* 469 */           localStringBuilder.append(arrayOfString2[k]);
/*     */         }
/*     */       }
/*     */     }
/* 472 */     localStringBuilder.append(" FROM ");
/* 473 */     for (int i = 0; i < arrayOfString1.length; i++)
/*     */     {
/* 475 */       if (i != 0)
/* 476 */         localStringBuilder.append(", ");
/* 477 */       localStringBuilder.append(arrayOfString1[i]);
/*     */     }
/* 479 */     return localStringBuilder.substring(0, localStringBuilder.length());
/*     */   }
/*     */ 
/*     */   boolean needBindStatusForParameterMetaData()
/*     */     throws SQLException
/*     */   {
/* 487 */     return (this.columnName.size() > 0) && (this.parameterCount > 0) && (this.bindStatusForInsert != null);
/*     */   }
/*     */ 
/*     */   byte[] getBindStatusForInsert()
/*     */   {
/* 496 */     return this.bindStatusForInsert;
/*     */   }
/*     */ 
/*     */   public static void main(String[] paramArrayOfString)
/*     */   {
/* 504 */     String[] arrayOfString1 = null;
/* 505 */     if (paramArrayOfString.length < 1) {
/* 506 */       System.err.println("ERROR: incorrect usage. OracleParameterMetaDataParser <-test| sql >");
/* 507 */       return;
/* 508 */     }if ("-test".equals(paramArrayOfString[0]))
/*     */     {
/* 510 */       arrayOfString1 = new String[] { "insert into JAVA_KEYWORDS (\"ABSTRACT\",\"ASSERT\",\"BOOLEAN\",\"BREAK\",\"BYTE\",\"CASE\",\"CATCH\",\"CHAR\",\"CLASS\",\"CONST \",\"CONTINUE\",\"DEFAULT\",\"DO\",\"DOUBLE\",\"ELSE\",\"ENUM \",\"EXTENDS\",\"FINAL\",\"FINALLY\",\"FLOAT\",\"FOR\",\"GOTO \",\"IF\",\"IMPLEMENTS\",\"IMPORT\",\"INSTANCEOF\",\"INT\",\"INTERFACE\",\"LONG\",\"NATIVE\",\"NEW\",\"PACKAGE\",\"PRIVATE\",\"PROTECTED\",\"PUBLIC\",\"RETU RN\",\"SHORT\",\"STATIC\",\"STRICTFP \",\"SUPER\",\"SWITCH\",\"SYNCHRONIZED\",\"THIS\",\"THROW\",\"THROWS\",\"TRANS IENT\",\"TRY\",\"VOID\",\"VOLATILE\",\"WHILE\", \"ID\") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?  ,?,?,?,?,?,?,?,?,?,?,?,?)", "INSERT INTO emp(empno,ename,sal) VALUES(:B1, :b2, :b3)", "INSERT INTO T1 VALUES(:BIND1, :bind2)", "begin INSERT INTO T1 VALUES(:BIND1, :bind2); end;", "UPDATE T1 SET  C1 = :B1 and c2 = :b2 and c3 = 'abc'", "UPDATE T1 SET C1 = :B1 and  c2 = :b2 and c3 = 'abc'", "UPDATE T1 SET    C1 = :B1 and    c2 = :b2 and    c3 = 'abc' and c4 = :b4", "SELECT ename from emp where empno = :a1 and sal = :a2", "DELETE FROM EMP WHERE EMPNO>:x", "DELETE FROM EMP WHERE EMPNO   >   :1", "DELETE FROM EMP WHERE EMPNO\n>\n:2", "DELETE FROM EMP WHERE EMPNO\n<>\n:3", "DELETE FROM EMP WHERE EMPNO\n<>\n'abc'", "SELECT ename, d.deptno from emp e, dept d where empno = ?  and sal = ? and e.deptno = d.deptno", "SELECT ename, d.deptno from emp e, dept d where empno = :a1 and sal = :a2 and e.deptno = d.deptno", "SELECT ename, deptno   from    emp   , dept    where    empno =    :a1 and   sal = :a2", "SELECT * FROM TKPJST58_TAB WHERE C1 = :2", "SELECT * FROM TKPJST58_TAB WHERE C1 is null and c2 = :1 and c3 = :4", "SELECT * FROM TKPJST58_TAB WHERE C1 is NULL  AND C2 = :1   AND C3 = :2   AND C4 = :3   AND C5 = :4   AND C6 = :5   AND C7 = :6   AND C8 = :7   AND C9 = :8   AND C10 = :9   AND C11 = :10   AND C12 = :11   AND C13 = :12   AND C14 = :13   AND C15 = :14   AND C16 is not null  AND C17 <> :15", "SELECT * FROM TKPJST58_TAB WHERE C1 = ?  AND C2 = ?  AND C3 = ?  AND C4 = ?  AND C5 = ?  AND C6 = ?  AND C7 = ?  AND C8 = ?  AND C9 = ?  AND C10 = ?  AND C11 = ?  AND C12 = ?  AND C13 = ?  AND C14 = ?  AND C15 = ?  AND C16 = ?  AND C17 = ?", "INSERT INTO TKPJST58_TAB(c1, c2, c3, c4, c5, c9, c14, c10) values (?,?,?,?,?,?,?,?)", "INSERT INTO TKPJST58_TAB values (12,'abc',?,?,?,?,?,?)", "INSERT INTO TKPJST58_TAB values (12,'abc',:1,:2,:3,:4,:5)", "INSERT INTO TKPJST58_TAB(c1,c2,c3,c4,c5,c6,c7) values (12,'abc',:1,:2,:3,:4,:5)", "INSERT INTO TKPJST58_TAB(c1,c2,c3,c4,c5,c6,c7) values (12,'abc',:1,:2,55,:4,:5)", "insert into rawtab values ('010203040506', '0708090a0b0c0d')", "begin insert into asciitab values (200,'21-sep-71',?,?,?); end;", "select col from dummy_tab where rowid=?", "SELECT * FROM test2 WHERE key >= ? ORDER BY key", "SELECT * FROM test2 WHERE key>=? ORDER BY key", "INSERT INTO tkpjb2354325_tab VALUES (111, {ts '1999-12-31 12:59:59'})", "SELECT user FROM dual WHERE  ? < { fn LOCATE('TEST123TEST', 1) }", "INSERT INTO tkpjb2354325_tab VALUES (111, {ts '1999-12-31 12:59:59'}, :3)", "delete from tkpjdg02_view where id >? returning id, name into ?, ?", "SELECT * FROM TABLE( CAST(? AS TYPE_VARCHAR_NT) )", "insert into (select t.col1 as column1, t.col2 as column2 from tkpjsc37 t  where t.col1 in (?,?,?,?)) values ( ?, ?)", "delete from tkpjdg02_view where id >? returning_id = ?", "insert into tkpjir93_tab values (?,q'!name LIKE '%DBMS_%%'!')", "insert into tkpjir93_tab values (?,q'{SELECT * FROM employees WHERE last_name = 'Smith';}'", "insert into xml_test values ('adf', '<?xml version=\"1.0\" encoding=\"UTF-8\"?><a></a>')", "SELECT * FROM test2 WHERE key>=? and ORDER_id=?  order BY key", "insert into emp(empno, ename, sal) values (?, N'abc', ?)", "UPDATE tkpjb5752856_tab SET c2=N'????C Mother''s Maiden Name????'", "INSERT INTO TKPJST58_TAB(c1, c2, c3, c4, c5, c9, c14, c10) values (12,'abc',?,?,?,?,?,?)", "UPDATE /*abc*/T1 SET/*xyz*/ C1 = :B1 /*nyl*/and/*bac*/ c2 = :b2 and c3 = 'abc'", "SELECT * FROM TKPJST58_TAB WHERE C1 is/*abc*/ null and c2 = :1 and c3 = :4", "SELECT * FROM TKPJST58_TAB WHERE C1 is/*abc*/not--xyz\n null and c2 = :1 and c3 = :4", "UPDATE TKPJST58_TAB/*comment1*/set/*comment2*/ C1 = ?  WHERE  C4 = /*abc*/? ", "UPDATE TKPJST58_TAB set C1 = ?  and c2 = ? WHERE  C4 = /*abc*/? and c5 = ?" };
/*     */     }
/*     */     else
/*     */     {
/* 573 */       arrayOfString1 = paramArrayOfString;
/*     */     }
/*     */ 
/* 576 */     for (String str1 : arrayOfString1)
/*     */       try {
/* 578 */         OracleSql localOracleSql = new OracleSql(null);
/* 579 */         localOracleSql.initialize(str1);
/* 580 */         String str2 = localOracleSql.getSql(true, true);
/*     */ 
/* 582 */         System.err.println(new StringBuilder().append("SQL:").append(str2).toString());
/* 583 */         System.err.println(new StringBuilder().append("  SqlKind:").append(localOracleSql.sqlKind).append(", Parameter Count=").append(localOracleSql.parameterCount).toString());
/* 584 */         if ((!localOracleSql.sqlKind.isPlsqlOrCall()) && (localOracleSql.parameterCount > 0))
/*     */         {
/* 586 */           OracleParameterMetaDataParser localOracleParameterMetaDataParser = new OracleParameterMetaDataParser();
/*     */ 
/* 588 */           localOracleParameterMetaDataParser.initialize(str2, localOracleSql.sqlKind, localOracleSql.parameterCount);
/* 589 */           System.err.println(new StringBuilder().append("  Parameter SQL: ").append(localOracleParameterMetaDataParser.getParameterMetaDataSql()).toString());
/*     */         }
/*     */         else
/*     */         {
/* 593 */           System.err.println("  Cannot get Parameter MetaData");
/*     */         }
/* 595 */         System.err.println("\n");
/*     */       }
/*     */       catch (Exception localException)
/*     */       {
/* 599 */         System.out.println(localException);
/* 600 */         localException.printStackTrace();
/*     */       }
/*     */   }
/*     */ 
/*     */   private static final void dumpTransitionMatrix(String paramString)
/*     */   {
/*     */     try {
/* 607 */       PrintWriter localPrintWriter = new PrintWriter(paramString);
/* 608 */       localPrintWriter.print(",");
/* 609 */       for (int i = 0; i < 128; i++) localPrintWriter.print(new StringBuilder().append("'").append(i < 32 ? new StringBuilder().append("0x").append(Integer.toHexString(i)).toString() : Character.toString((char)i)).append(i < 127 ? "'," : "'").toString());
/* 610 */       localPrintWriter.println();
/* 611 */       int[][] arrayOfInt = OracleParameterMetaDataParserStates.TRANSITION;
/* 612 */       String[] arrayOfString = OracleParameterMetaDataParserStates.PARSER_STATE_NAME;
/* 613 */       for (int j = 0; j < TRANSITION.length; j++) {
/* 614 */         localPrintWriter.print(new StringBuilder().append(arrayOfString[j]).append(",").toString());
/* 615 */         for (int k = 0; k < arrayOfInt[j].length; k++) localPrintWriter.print(new StringBuilder().append(arrayOfString[arrayOfInt[j][k]]).append(k < 127 ? "," : "").toString());
/* 616 */         localPrintWriter.println();
/*     */       }
/* 618 */       localPrintWriter.close();
/*     */     }
/*     */     catch (Throwable localThrowable) {
/* 621 */       System.err.println(localThrowable);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 638 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleParameterMetaDataParser
 * JD-Core Version:    0.6.2
 */