/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.ParameterMetaData;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*     */ 
/*     */ class OracleParameterMetaData
/*     */   implements oracle.jdbc.internal.OracleParameterMetaData
/*     */ {
/*  27 */   int parameterCount = 0;
/*     */   int[] isNullable;
/*     */   boolean[] isSigned;
/*     */   int[] precision;
/*     */   int[] scale;
/*     */   int[] parameterType;
/*     */   String[] parameterTypeName;
/*     */   String[] parameterClassName;
/*     */   int[] parameterMode;
/*  37 */   boolean throwUnsupportedFeature = false;
/*     */ 
/* 221 */   int parameterNoNulls = 0;
/*     */ 
/* 229 */   int parameterNullable = 1;
/*     */ 
/* 237 */   int parameterNullableUnknown = 2;
/*     */ 
/* 390 */   int parameterModeUnknown = 0;
/*     */ 
/* 397 */   int parameterModeIn = 1;
/*     */ 
/* 404 */   int parameterModeInOut = 2;
/*     */ 
/* 411 */   int parameterModeOut = 4;
/*     */   Object acProxy;
/* 519 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   static final ParameterMetaData getParameterMetaData(OracleSql paramOracleSql, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/*  45 */     OracleParameterMetaData localOracleParameterMetaData = null;
/*  46 */     String str1 = paramOracleSql.getSql(true, true);
/*  47 */     int i = paramOracleSql.getParameterCount();
/*     */ 
/*  49 */     OracleParameterMetaDataParser localOracleParameterMetaDataParser = null;
/*  50 */     String str2 = null;
/*     */ 
/*  52 */     if ((!paramOracleSql.sqlKind.isPlsqlOrCall()) && (paramOracleSql.getReturnParameterCount() < 1) && (i > 0))
/*     */     {
/*  56 */       localOracleParameterMetaDataParser = new OracleParameterMetaDataParser();
/*  57 */       localOracleParameterMetaDataParser.initialize(str1, paramOracleSql.sqlKind, i);
/*  58 */       str2 = localOracleParameterMetaDataParser.getParameterMetaDataSql();
/*     */     }
/*     */ 
/*  61 */     if (str2 == null)
/*     */     {
/*  63 */       localOracleParameterMetaData = new OracleParameterMetaData(i);
/*     */     }
/*     */     else {
/*  66 */       PreparedStatement localPreparedStatement = null;
/*     */       try
/*     */       {
/*  69 */         localPreparedStatement = paramConnection.prepareStatement(str2);
/*  70 */         ResultSetMetaData localResultSetMetaData = localPreparedStatement.getMetaData();
/*  71 */         if (localOracleParameterMetaDataParser.needBindStatusForParameterMetaData())
/*     */         {
/*  73 */           localOracleParameterMetaData = new OracleParameterMetaData(localResultSetMetaData, paramOracleSql.getParameterCount(), localOracleParameterMetaDataParser.getBindStatusForInsert());
/*     */         }
/*     */         else
/*     */         {
/*  78 */           localOracleParameterMetaData = new OracleParameterMetaData(localResultSetMetaData);
/*     */         }
/*     */       }
/*     */       finally {
/*  82 */         if (localPreparedStatement != null) {
/*  83 */           localPreparedStatement.close();
/*     */         }
/*     */       }
/*     */     }
/*  87 */     return localOracleParameterMetaData;
/*     */   }
/*     */ 
/*     */   private OracleParameterMetaData(ResultSetMetaData paramResultSetMetaData)
/*     */     throws SQLException
/*     */   {
/*  93 */     this.parameterCount = paramResultSetMetaData.getColumnCount();
/*  94 */     this.isNullable = new int[this.parameterCount];
/*  95 */     this.isSigned = new boolean[this.parameterCount];
/*  96 */     this.precision = new int[this.parameterCount];
/*  97 */     this.scale = new int[this.parameterCount];
/*  98 */     this.parameterType = new int[this.parameterCount];
/*  99 */     this.parameterTypeName = new String[this.parameterCount];
/* 100 */     this.parameterClassName = new String[this.parameterCount];
/* 101 */     this.parameterMode = new int[this.parameterCount];
/*     */ 
/* 103 */     int i = 1; for (int j = 0; i <= this.parameterCount; j++)
/*     */     {
/* 105 */       this.isNullable[j] = paramResultSetMetaData.isNullable(i);
/* 106 */       this.isSigned[j] = paramResultSetMetaData.isSigned(i);
/* 107 */       this.precision[j] = paramResultSetMetaData.getPrecision(i);
/* 108 */       this.scale[j] = paramResultSetMetaData.getScale(i);
/* 109 */       this.parameterType[j] = paramResultSetMetaData.getColumnType(i);
/* 110 */       this.parameterTypeName[j] = paramResultSetMetaData.getColumnTypeName(i);
/* 111 */       this.parameterClassName[j] = paramResultSetMetaData.getColumnClassName(i);
/* 112 */       this.parameterMode[j] = this.parameterModeIn;
/*     */ 
/* 103 */       i++;
/*     */     }
/*     */   }
/*     */ 
/*     */   private OracleParameterMetaData(ResultSetMetaData paramResultSetMetaData, int paramInt, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 120 */     this.parameterCount = paramInt;
/* 121 */     this.isNullable = new int[this.parameterCount];
/* 122 */     this.isSigned = new boolean[this.parameterCount];
/* 123 */     this.precision = new int[this.parameterCount];
/* 124 */     this.scale = new int[this.parameterCount];
/* 125 */     this.parameterType = new int[this.parameterCount];
/* 126 */     this.parameterTypeName = new String[this.parameterCount];
/* 127 */     this.parameterClassName = new String[this.parameterCount];
/* 128 */     this.parameterMode = new int[this.parameterCount];
/*     */ 
/* 130 */     int i = 1; for (int j = 0; i <= this.parameterCount; i++)
/*     */     {
/* 132 */       if (paramArrayOfByte[(i - 1)] == 1)
/*     */       {
/* 135 */         this.isNullable[j] = paramResultSetMetaData.isNullable(i);
/* 136 */         this.isSigned[j] = paramResultSetMetaData.isSigned(i);
/* 137 */         this.precision[j] = paramResultSetMetaData.getPrecision(i);
/* 138 */         this.scale[j] = paramResultSetMetaData.getScale(i);
/* 139 */         this.parameterType[j] = paramResultSetMetaData.getColumnType(i);
/* 140 */         this.parameterTypeName[j] = paramResultSetMetaData.getColumnTypeName(i);
/* 141 */         this.parameterClassName[j] = paramResultSetMetaData.getColumnClassName(i);
/* 142 */         this.parameterMode[j] = this.parameterModeIn;
/* 143 */         j++;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   OracleParameterMetaData(int paramInt) throws SQLException {
/* 149 */     this.parameterCount = paramInt;
/* 150 */     this.throwUnsupportedFeature = true;
/*     */   }
/*     */ 
/*     */   public int getParameterCount()
/*     */     throws SQLException
/*     */   {
/* 166 */     return this.parameterCount;
/*     */   }
/*     */ 
/*     */   void checkValidIndex(int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     SQLException localSQLException;
/* 172 */     if (this.throwUnsupportedFeature)
/*     */     {
/* 175 */       localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 176 */       localSQLException.fillInStackTrace();
/* 177 */       throw localSQLException;
/*     */     }
/* 179 */     if ((paramInt < 1) || (paramInt > this.parameterCount))
/*     */     {
/* 182 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 183 */       localSQLException.fillInStackTrace();
/* 184 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int isNullable(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 210 */     checkValidIndex(paramInt);
/* 211 */     return this.isNullable[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public boolean isSigned(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 257 */     checkValidIndex(paramInt);
/* 258 */     return this.isSigned[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public int getPrecision(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 280 */     checkValidIndex(paramInt);
/* 281 */     return this.precision[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public int getScale(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 303 */     checkValidIndex(paramInt);
/* 304 */     return this.scale[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public int getParameterType(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 327 */     checkValidIndex(paramInt);
/* 328 */     return this.parameterType[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public String getParameterTypeName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 351 */     checkValidIndex(paramInt);
/* 352 */     return this.parameterTypeName[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public String getParameterClassName(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 380 */     checkValidIndex(paramInt);
/* 381 */     return this.parameterClassName[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public int getParameterMode(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 435 */     checkValidIndex(paramInt);
/* 436 */     return this.parameterMode[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public boolean isWrapperFor(Class<?> paramClass)
/*     */     throws SQLException
/*     */   {
/* 456 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*     */ 
/* 458 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 459 */     localSQLException.fillInStackTrace();
/* 460 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public <T> T unwrap(Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 482 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*     */ 
/* 484 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 485 */     localSQLException.fillInStackTrace();
/* 486 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 502 */     return null;
/*     */   }
/*     */ 
/*     */   public void setACProxy(Object paramObject)
/*     */   {
/* 510 */     this.acProxy = paramObject;
/*     */   }
/*     */ 
/*     */   public Object getACProxy()
/*     */   {
/* 515 */     return this.acProxy;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleParameterMetaData
 * JD-Core Version:    0.6.2
 */