/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import oracle.jdbc.pool.OracleOCIConnectionPool;
/*     */ 
/*     */ public abstract class OracleOCIConnection extends T2CConnection
/*     */ {
/*  29 */   OracleOCIConnectionPool ociConnectionPool = null;
/*  30 */   boolean isPool = false;
/*  31 */   boolean aliasing = false;
/*     */ 
/* 149 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleOCIConnection(String paramString, Properties paramProperties, Object paramObject)
/*     */     throws SQLException
/*     */   {
/*  42 */     this(paramString, paramProperties, (OracleDriverExtension)paramObject);
/*     */   }
/*     */ 
/*     */   OracleOCIConnection(String paramString, Properties paramProperties, OracleDriverExtension paramOracleDriverExtension)
/*     */     throws SQLException
/*     */   {
/*  58 */     super(paramString, paramProperties, paramOracleDriverExtension);
/*     */   }
/*     */ 
/*     */   public synchronized byte[] getConnectionId()
/*     */     throws SQLException
/*     */   {
/*  70 */     byte[] arrayOfByte = t2cGetConnectionId(this.m_nativeState);
/*     */ 
/*  72 */     if (arrayOfByte == null)
/*     */     {
/*  74 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId");
/*  75 */       localSQLException.fillInStackTrace();
/*  76 */       throw localSQLException;
/*     */     }
/*     */ 
/*  79 */     this.aliasing = true;
/*     */ 
/*  81 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public synchronized void passwordChange(String paramString1, String paramString2, String paramString3)
/*     */     throws SQLException, IOException
/*     */   {
/* 100 */     ociPasswordChange(paramString1, paramString2, paramString3);
/*     */   }
/*     */ 
/*     */   public synchronized void close()
/*     */     throws SQLException
/*     */   {
/* 113 */     if ((this.lifecycle == 2) || (this.lifecycle == 4) || (this.aliasing)) {
/* 114 */       return;
/*     */     }
/* 116 */     super.close();
/*     */ 
/* 118 */     this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
/*     */   }
/*     */ 
/*     */   public synchronized void setConnectionPool(OracleOCIConnectionPool paramOracleOCIConnectionPool)
/*     */   {
/* 128 */     this.ociConnectionPool = paramOracleOCIConnectionPool;
/*     */   }
/*     */ 
/*     */   public synchronized void setStmtCacheSize(int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 144 */     super.setStmtCacheSize(paramInt, paramBoolean);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleOCIConnection
 * JD-Core Version:    0.6.2
 */