/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.logging.Level;
/*     */ 
/*     */ public class OracleLog
/*     */ {
/*     */   private static final int maxPrintBytes = 512;
/*     */   public static final boolean TRACE = false;
/* 532 */   public static final Level INTERNAL_ERROR = OracleLevel.INTERNAL_ERROR;
/* 533 */   public static final Level TRACE_1 = OracleLevel.TRACE_1;
/* 534 */   public static final Level TRACE_10 = OracleLevel.TRACE_10;
/* 535 */   public static final Level TRACE_16 = OracleLevel.TRACE_16;
/* 536 */   public static final Level TRACE_20 = OracleLevel.TRACE_20;
/* 537 */   public static final Level TRACE_30 = OracleLevel.TRACE_30;
/* 538 */   public static final Level TRACE_32 = OracleLevel.TRACE_32;
/*     */   static boolean securityExceptionWhileGettingSystemProperties;
/*     */ 
/*     */   public static boolean isDebugZip()
/*     */   {
/*  69 */     boolean bool = true;
/*     */ 
/*  72 */     bool = false;
/*  73 */     return bool;
/*     */   }
/*     */ 
/*     */   public static boolean isPrivateLogAvailable()
/*     */   {
/*  88 */     boolean bool = false;
/*     */ 
/*  92 */     return bool;
/*     */   }
/*     */ 
/*     */   public static boolean isEnabled()
/*     */   {
/* 102 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean registerClassNameAndGetCurrentTraceSetting(Class paramClass)
/*     */   {
/* 113 */     return false;
/*     */   }
/*     */ 
/*     */   public static void setTrace(boolean paramBoolean)
/*     */   {
/*     */   }
/*     */ 
/*     */   private static void initialize()
/*     */   {
/* 137 */     setupFromSystemProperties();
/*     */   }
/*     */ 
/*     */   public static void setupFromSystemProperties()
/*     */   {
/* 148 */     boolean bool = false;
/* 149 */     securityExceptionWhileGettingSystemProperties = false;
/*     */     try
/*     */     {
/* 152 */       String str = null;
/* 153 */       str = getSystemProperty("oracle.jdbc.Trace", null);
/* 154 */       if ((str != null) && (str.compareTo("true") == 0))
/* 155 */         bool = true;
/*     */     }
/*     */     catch (SecurityException localSecurityException)
/*     */     {
/* 159 */       securityExceptionWhileGettingSystemProperties = true;
/*     */     }
/* 161 */     setTrace(bool);
/*     */   }
/*     */ 
/*     */   private static String getSystemProperty(String paramString)
/*     */   {
/* 178 */     return getSystemProperty(paramString, null);
/*     */   }
/*     */ 
/*     */   private static String getSystemProperty(String paramString1, String paramString2)
/*     */   {
/* 186 */     if (paramString1 != null)
/*     */     {
/* 188 */       final String str1 = paramString1;
/* 189 */       final String str2 = paramString2;
/* 190 */       String[] arrayOfString = { paramString2 };
/* 191 */       AccessController.doPrivileged(new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 195 */           this.val$retStr[0] = System.getProperty(str1, str2);
/* 196 */           return null;
/*     */         }
/*     */       });
/* 199 */       return arrayOfString[0];
/*     */     }
/* 201 */     return paramString2;
/*     */   }
/*     */ 
/*     */   public static String argument()
/*     */   {
/* 211 */     return "";
/*     */   }
/*     */ 
/*     */   public static String argument(boolean paramBoolean) {
/* 215 */     return Boolean.toString(paramBoolean);
/*     */   }
/*     */ 
/*     */   public static String argument(byte paramByte) {
/* 219 */     return Byte.toString(paramByte);
/*     */   }
/*     */ 
/*     */   public static String argument(short paramShort) {
/* 223 */     return Short.toString(paramShort);
/*     */   }
/*     */ 
/*     */   public static String argument(int paramInt) {
/* 227 */     return Integer.toString(paramInt);
/*     */   }
/*     */ 
/*     */   public static String argument(long paramLong) {
/* 231 */     return Long.toString(paramLong);
/*     */   }
/*     */ 
/*     */   public static String argument(float paramFloat) {
/* 235 */     return Float.toString(paramFloat);
/*     */   }
/*     */ 
/*     */   public static String argument(double paramDouble) {
/* 239 */     return Double.toString(paramDouble);
/*     */   }
/*     */ 
/*     */   public static String argument(Object paramObject) {
/* 243 */     if (paramObject == null) return "null";
/* 244 */     if ((paramObject instanceof String)) return "\"" + (String)paramObject + "\"";
/* 245 */     return paramObject.toString();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static String byteToHexString(byte paramByte)
/*     */   {
/* 267 */     StringBuffer localStringBuffer = new StringBuffer("");
/* 268 */     int i = 0xFF & paramByte;
/*     */ 
/* 270 */     if (i <= 15)
/* 271 */       localStringBuffer.append("0x0");
/*     */     else {
/* 273 */       localStringBuffer.append("0x");
/*     */     }
/* 275 */     localStringBuffer.append(Integer.toHexString(i));
/*     */ 
/* 277 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static String bytesToPrintableForm(String paramString, byte[] paramArrayOfByte)
/*     */   {
/* 298 */     int i = paramArrayOfByte == null ? 0 : paramArrayOfByte.length;
/*     */ 
/* 300 */     return bytesToPrintableForm(paramString, paramArrayOfByte, i);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static String bytesToPrintableForm(String paramString, byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 324 */     String str = null;
/*     */ 
/* 326 */     if (paramArrayOfByte == null)
/* 327 */       str = paramString + ": null";
/*     */     else {
/* 329 */       str = paramString + " (" + paramArrayOfByte.length + " bytes):\n" + bytesToFormattedStr(paramArrayOfByte, paramInt, "  ");
/*     */     }
/*     */ 
/* 332 */     return str;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static String bytesToFormattedStr(byte[] paramArrayOfByte, int paramInt, String paramString)
/*     */   {
/* 359 */     StringBuffer localStringBuffer = new StringBuffer("");
/*     */ 
/* 361 */     if (paramString == null) {
/* 362 */       paramString = new String("");
/*     */     }
/* 364 */     localStringBuffer.append(paramString);
/*     */ 
/* 366 */     if (paramArrayOfByte == null)
/*     */     {
/* 368 */       localStringBuffer.append("byte [] is null");
/*     */ 
/* 370 */       return localStringBuffer.toString();
/*     */     }
/*     */ 
/* 373 */     for (int i = 0; i < paramInt; i++)
/*     */     {
/* 375 */       if (i >= 512)
/*     */       {
/* 377 */         localStringBuffer.append("\n" + paramString + "... last " + (paramInt - 512) + " bytes were not printed to limit the output size");
/*     */ 
/* 380 */         break;
/*     */       }
/*     */ 
/* 383 */       if ((i > 0) && (i % 20 == 0)) {
/* 384 */         localStringBuffer.append("\n" + paramString);
/*     */       }
/* 386 */       if (i % 20 == 10) {
/* 387 */         localStringBuffer.append(" ");
/*     */       }
/* 389 */       int j = 0xFF & paramArrayOfByte[i];
/*     */ 
/* 391 */       if (j <= 15) {
/* 392 */         localStringBuffer.append("0");
/*     */       }
/* 394 */       localStringBuffer.append(Integer.toHexString(j) + " ");
/*     */     }
/*     */ 
/* 397 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static byte[] strToUcs2Bytes(String paramString)
/*     */   {
/* 414 */     if (paramString == null) {
/* 415 */       return null;
/*     */     }
/* 417 */     return charsToUcs2Bytes(paramString.toCharArray());
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static byte[] charsToUcs2Bytes(char[] paramArrayOfChar)
/*     */   {
/* 434 */     if (paramArrayOfChar == null) {
/* 435 */       return null;
/*     */     }
/* 437 */     return charsToUcs2Bytes(paramArrayOfChar, paramArrayOfChar.length);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static byte[] charsToUcs2Bytes(char[] paramArrayOfChar, int paramInt)
/*     */   {
/* 456 */     if (paramArrayOfChar == null) {
/* 457 */       return null;
/*     */     }
/* 459 */     if (paramInt < 0) {
/* 460 */       return null;
/*     */     }
/* 462 */     return charsToUcs2Bytes(paramArrayOfChar, paramInt, 0);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static byte[] charsToUcs2Bytes(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*     */   {
/* 474 */     if (paramArrayOfChar == null) {
/* 475 */       return null;
/*     */     }
/* 477 */     if (paramInt1 > paramArrayOfChar.length - paramInt2) {
/* 478 */       paramInt1 = paramArrayOfChar.length - paramInt2;
/*     */     }
/* 480 */     if (paramInt1 < 0) {
/* 481 */       return null;
/*     */     }
/* 483 */     byte[] arrayOfByte = new byte[2 * paramInt1];
/*     */ 
/* 485 */     int j = paramInt2; for (int i = 0; j < paramInt1; j++)
/*     */     {
/* 487 */       arrayOfByte[(i++)] = ((byte)(paramArrayOfChar[j] >> '\b' & 0xFF));
/* 488 */       arrayOfByte[(i++)] = ((byte)(paramArrayOfChar[j] & 0xFF));
/*     */     }
/*     */ 
/* 491 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static String toPrintableStr(String paramString, int paramInt)
/*     */   {
/* 509 */     if (paramString == null)
/*     */     {
/* 511 */       return "null";
/*     */     }
/*     */ 
/* 514 */     if (paramString.length() > paramInt)
/*     */     {
/* 516 */       return paramString.substring(0, paramInt - 1) + "\n ... the actual length was " + paramString.length();
/*     */     }
/*     */ 
/* 520 */     return paramString;
/*     */   }
/*     */ 
/*     */   public static String toHex(long paramLong, int paramInt)
/*     */   {
/*     */     String str;
/* 556 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 559 */       str = "00" + Long.toString(paramLong & 0xFF, 16);
/* 560 */       break;
/*     */     case 2:
/* 562 */       str = "0000" + Long.toString(paramLong & 0xFFFF, 16);
/* 563 */       break;
/*     */     case 3:
/* 565 */       str = "000000" + Long.toString(paramLong & 0xFFFFFF, 16);
/* 566 */       break;
/*     */     case 4:
/* 568 */       str = "00000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/* 569 */       break;
/*     */     case 5:
/* 571 */       str = "0000000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/* 572 */       break;
/*     */     case 6:
/* 574 */       str = "000000000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/* 575 */       break;
/*     */     case 7:
/* 577 */       str = "00000000000000" + Long.toString(paramLong & 0xFFFFFFFF, 16);
/*     */ 
/* 579 */       break;
/*     */     case 8:
/* 581 */       return toHex(paramLong >> 32, 4) + toHex(paramLong, 4).substring(2);
/*     */     default:
/* 584 */       return "more than 8 bytes";
/*     */     }
/* 586 */     return "0x" + str.substring(str.length() - 2 * paramInt);
/*     */   }
/*     */ 
/*     */   public static String toHex(byte paramByte)
/*     */   {
/* 591 */     String str = "00" + Integer.toHexString(paramByte & 0xFF);
/* 592 */     return "0x" + str.substring(str.length() - 2);
/*     */   }
/*     */ 
/*     */   public static String toHex(short paramShort)
/*     */   {
/* 597 */     return toHex(paramShort, 2);
/*     */   }
/*     */ 
/*     */   public static String toHex(int paramInt)
/*     */   {
/* 602 */     return toHex(paramInt, 4);
/*     */   }
/*     */ 
/*     */   public static String toHex(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 607 */     if (paramArrayOfByte == null)
/* 608 */       return "null";
/* 609 */     if (paramInt > paramArrayOfByte.length)
/* 610 */       return "byte array not long enough";
/* 611 */     String str = "[";
/* 612 */     int i = Math.min(64, paramInt);
/* 613 */     for (int j = 0; j < i; j++)
/*     */     {
/* 615 */       str = str + toHex(paramArrayOfByte[j]) + " ";
/*     */     }
/* 617 */     if (i < paramInt)
/* 618 */       str = str + "...";
/* 619 */     return str + "]";
/*     */   }
/*     */ 
/*     */   public static String toHex(byte[] paramArrayOfByte)
/*     */   {
/* 624 */     if (paramArrayOfByte == null)
/* 625 */       return "null";
/* 626 */     return toHex(paramArrayOfByte, paramArrayOfByte.length);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 547 */     initialize();
/*     */   }
/*     */ 
/*     */   private static class OracleLevel extends Level
/*     */   {
/* 634 */     static final OracleLevel INTERNAL_ERROR = new OracleLevel("INTERNAL_ERROR", 1100);
/* 635 */     static final OracleLevel TRACE_1 = new OracleLevel("TRACE_1", Level.FINE.intValue());
/* 636 */     static final OracleLevel TRACE_10 = new OracleLevel("TRACE_10", 446);
/* 637 */     static final OracleLevel TRACE_16 = new OracleLevel("TRACE_16", Level.FINER.intValue());
/* 638 */     static final OracleLevel TRACE_20 = new OracleLevel("TRACE_20", 376);
/* 639 */     static final OracleLevel TRACE_30 = new OracleLevel("TRACE_30", 316);
/* 640 */     static final OracleLevel TRACE_32 = new OracleLevel("TRACE_32", Level.FINEST.intValue());
/*     */ 
/*     */     OracleLevel(String paramString, int paramInt) {
/* 643 */       super(paramInt);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleLog
 * JD-Core Version:    0.6.2
 */