/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ abstract class OracleInputStream extends OracleBufferedStream
/*     */ {
/*     */   int columnIndex;
/*     */   Accessor accessor;
/*     */   OracleInputStream nextStream;
/*  35 */   boolean hasBeenOpen = false;
/*     */ 
/* 257 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected OracleInputStream(OracleStatement paramOracleStatement, int paramInt, Accessor paramAccessor)
/*     */   {
/*  39 */     super(paramOracleStatement, paramOracleStatement.connection.getDefaultStreamChunkSize());
/*     */ 
/*  41 */     this.closed = true;
/*  42 */     this.statement = paramOracleStatement;
/*  43 */     this.columnIndex = paramInt;
/*  44 */     this.accessor = paramAccessor;
/*  45 */     this.nextStream = null;
/*     */ 
/*  55 */     OracleInputStream localOracleInputStream = this.statement.streamList;
/*     */ 
/*  57 */     if ((localOracleInputStream == null) || (this.columnIndex < localOracleInputStream.columnIndex))
/*     */     {
/*  61 */       this.nextStream = this.statement.streamList;
/*  62 */       this.statement.streamList = this;
/*     */     }
/*  64 */     else if (this.columnIndex == localOracleInputStream.columnIndex)
/*     */     {
/*  69 */       this.nextStream = localOracleInputStream.nextStream;
/*  70 */       localOracleInputStream.nextStream = null;
/*  71 */       this.statement.streamList = this;
/*     */     }
/*     */     else
/*     */     {
/*  76 */       while ((localOracleInputStream.nextStream != null) && (this.columnIndex > localOracleInputStream.nextStream.columnIndex))
/*     */       {
/*  78 */         localOracleInputStream = localOracleInputStream.nextStream;
/*     */       }
/*     */ 
/*  81 */       if ((localOracleInputStream.nextStream != null) && (this.columnIndex == localOracleInputStream.nextStream.columnIndex))
/*     */       {
/*  85 */         this.nextStream = localOracleInputStream.nextStream.nextStream;
/*  86 */         localOracleInputStream.nextStream.nextStream = null;
/*  87 */         localOracleInputStream.nextStream = this;
/*     */       }
/*     */       else
/*     */       {
/*  93 */         this.nextStream = localOracleInputStream.nextStream;
/*  94 */         localOracleInputStream.nextStream = this;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 108 */     return "OIS@" + Integer.toHexString(hashCode()) + "{" + "statement = " + this.statement + ", accessor = " + this.accessor + ", nextStream = " + this.nextStream + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
/*     */   }
/*     */ 
/*     */   public boolean needBytes(int paramInt)
/*     */     throws IOException
/*     */   {
/* 124 */     if (this.closed) {
/* 125 */       return false;
/*     */     }
/* 127 */     if (this.pos >= this.count)
/*     */     {
/* 129 */       if (paramInt > this.currentBufferSize)
/*     */       {
/* 131 */         this.currentBufferSize = Math.max(paramInt, this.initialBufferSize);
/* 132 */         this.resizableBuffer = new byte[this.currentBufferSize];
/*     */       }
/*     */       try
/*     */       {
/* 136 */         int i = getBytes(this.currentBufferSize);
/*     */ 
/* 138 */         this.pos = 0;
/* 139 */         this.count = i;
/*     */ 
/* 141 */         if (this.count == -1)
/*     */         {
/* 145 */           if (this.nextStream == null) {
/* 146 */             this.statement.connection.releaseLine();
/*     */           }
/* 148 */           this.closed = true;
/*     */ 
/* 150 */           this.accessor.fetchNextColumns();
/*     */ 
/* 152 */           return false;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 161 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 162 */         localIOException.fillInStackTrace();
/* 163 */         throw localIOException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 168 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isNull()
/*     */     throws IOException
/*     */   {
/* 180 */     boolean bool = false;
/*     */     try
/*     */     {
/* 184 */       bool = this.accessor.isNull(0);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 189 */       IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 190 */       localIOException.fillInStackTrace();
/* 191 */       throw localIOException;
/*     */     }
/*     */ 
/* 195 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 207 */     return this.closed;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 213 */     synchronized (this.statement.connection)
/*     */     {
/* 220 */       if ((!this.closed) && (this.hasBeenOpen))
/*     */       {
/* 224 */         while (this.statement.nextStream != this)
/*     */         {
/* 226 */           this.statement.nextStream.close();
/*     */ 
/* 228 */           this.statement.nextStream = this.statement.nextStream.nextStream;
/*     */         }
/*     */ 
/* 231 */         if (!isNull())
/*     */         {
/* 234 */           while (needBytes(Math.max(this.initialBufferSize, this.currentBufferSize)))
/*     */           {
/* 238 */             this.pos = this.count;
/*     */           }
/*     */         }
/*     */ 
/* 242 */         this.closed = true;
/* 243 */         this.resizableBuffer = null;
/* 244 */         this.currentBufferSize = 0;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public abstract int getBytes(int paramInt)
/*     */     throws IOException;
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleInputStream
 * JD-Core Version:    0.6.2
 */