/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.lang.management.ManagementFactory;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Connection;
/*      */ import java.sql.Driver;
/*      */ import java.sql.DriverManager;
/*      */ import java.sql.DriverPropertyInfo;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.logging.Level;
/*      */ import java.util.logging.Logger;
/*      */ import javax.management.InstanceAlreadyExistsException;
/*      */ import javax.management.InstanceNotFoundException;
/*      */ import javax.management.JMException;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.ObjectName;
/*      */ import oracle.jdbc.OracleDatabaseMetaData;
/*      */ import oracle.jdbc.babelfish.BabelfishCallableStatement;
/*      */ import oracle.jdbc.babelfish.BabelfishConnection;
/*      */ import oracle.jdbc.babelfish.BabelfishGenericProxy;
/*      */ import oracle.jdbc.babelfish.BabelfishPreparedStatement;
/*      */ import oracle.jdbc.babelfish.BabelfishStatement;
/*      */ import oracle.jdbc.babelfish.TranslationManager;
/*      */ import oracle.jdbc.babelfish.Translator;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.proxy.ProxyFactory;
/*      */ import oracle.security.pki.OraclePKIProvider;
/*      */ 
/*      */ public class OracleDriver
/*      */   implements Driver
/*      */ {
/*      */   public static final String oracle_string = "oracle";
/*      */   public static final String jdbc_string = "jdbc";
/*      */   public static final String protocol_string = "protocol";
/*      */   public static final String user_string = "user";
/*      */   public static final String password_string = "password";
/*      */   public static final String database_string = "database";
/*      */   public static final String server_string = "server";
/*      */ 
/*      */   /** @deprecated */
/*      */   public static final String access_string = "access";
/*      */ 
/*      */   /** @deprecated */
/*      */   public static final String protocolFullName_string = "protocolFullName";
/*      */   public static final String logon_as_internal_str = "internal_logon";
/*      */   public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
/*      */   public static final String prefetch_string = "prefetch";
/*      */   public static final String row_prefetch_string = "rowPrefetch";
/*      */   public static final String default_row_prefetch_string = "defaultRowPrefetch";
/*      */   public static final String batch_string = "batch";
/*      */   public static final String execute_batch_string = "executeBatch";
/*      */   public static final String default_execute_batch_string = "defaultExecuteBatch";
/*      */   public static final String process_escapes_string = "processEscapes";
/*      */   public static final String accumulate_batch_result = "AccumulateBatchResult";
/*      */   public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
/*      */   public static final String v8compatible_string = "V8Compatible";
/*      */   public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
/*      */   public static final String prelim_auth_string = "prelim_auth";
/*      */   public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
/*      */ 
/*      */   /** @deprecated */
/*      */   public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
/*      */   public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
/*      */   public static final String read_timeout = "oracle.jdbc.ReadTimeout";
/*      */   public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
/*      */   public static final String defaultncharprop_string = "defaultNChar";
/*      */   public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
/*      */   public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
/*      */   public static final String remarks_string = "remarks";
/*      */   public static final String report_remarks_string = "remarksReporting";
/*      */   public static final String synonyms_string = "synonyms";
/*      */   public static final String include_synonyms_string = "includeSynonyms";
/*      */   public static final String restrict_getTables_string = "restrictGetTables";
/*      */   public static final String fixed_string_string = "fixedString";
/*      */   public static final String dll_string = "oracle.jdbc.ocinativelibrary";
/*      */   public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
/*      */   public static final String disable_defineColumnType_string = "disableDefineColumnType";
/*      */   public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
/*      */   public static final String dataSizeUnitsPropertyName = "";
/*      */   public static final String dataSizeBytes = "";
/*      */   public static final String dataSizeChars = "";
/*      */   public static final String set_new_password_string = "OCINewPassword";
/*      */   public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
/*      */   public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
/*      */   static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
/*      */   static final int EXTENSION_TYPE_GEN_ERROR = -2;
/*      */   static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
/*      */   static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
/*      */   static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
/*      */   static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
/*      */   private static final int NUMBER_OF_EXTENSION_TYPES = 4;
/*  144 */   private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
/*      */   private static final String DRIVER_PACKAGE_STRING = "driver";
/*  160 */   private static final String[] driverExtensionClassNames = { "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension" };
/*      */   private static Properties driverAccess;
/*  179 */   protected static Connection defaultConn = null;
/*  180 */   private static OracleDriver defaultDriver = null;
/*      */   public static final Map<String, Class> systemTypeMap;
/*      */   private static final String DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME = "/oracle/jdbc/defaultConnectionProperties.properties";
/*      */   protected static final Properties DEFAULT_CONNECTION_PROPERTIES;
/*  291 */   private static ObjectName diagnosticMBeanObjectName = null;
/*      */ 
/* 1004 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public static void registerMBeans()
/*      */   {
/*      */     try
/*      */     {
/*  303 */       MBeanServer localMBeanServer = null;
/*      */       Object localObject;
/*      */       try
/*      */       {
/*  306 */         Class localClass = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
/*  307 */         localObject = localClass.newInstance();
/*  308 */         Method localMethod = localClass.getMethod("getMBeanServer", new Class[0]);
/*  309 */         localMBeanServer = (MBeanServer)localMethod.invoke(localObject, new Object[0]);
/*      */       }
/*      */       catch (NoClassDefFoundError localNoClassDefFoundError)
/*      */       {
/*  314 */         localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */       }
/*      */       catch (ClassNotFoundException localClassNotFoundException)
/*      */       {
/*  319 */         localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */       }
/*      */       catch (NoSuchMethodException localNoSuchMethodException) {
/*  322 */         Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", localNoSuchMethodException);
/*      */ 
/*  326 */         localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */       }
/*      */       catch (InstantiationException localInstantiationException) {
/*  329 */         Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", localInstantiationException);
/*      */ 
/*  333 */         localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */       }
/*      */       catch (IllegalAccessException localIllegalAccessException) {
/*  336 */         Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", localIllegalAccessException);
/*      */ 
/*  340 */         localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */       }
/*      */       catch (InvocationTargetException localInvocationTargetException) {
/*  343 */         Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", localInvocationTargetException);
/*      */ 
/*  347 */         localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */       }
/*  349 */       if (localMBeanServer != null) {
/*  350 */         ClassLoader localClassLoader = OracleDriver.class.getClassLoader();
/*  351 */         localObject = localClassLoader == null ? "nullLoader" : localClassLoader.getClass().getName();
/*  352 */         int i = 0;
/*      */         while (true) {
/*  354 */           String str = new StringBuilder().append((String)localObject).append("@").append(Integer.toHexString((localClassLoader == null ? 0 : localClassLoader.hashCode()) + i++)).toString();
/*      */ 
/*  356 */           diagnosticMBeanObjectName = new ObjectName(new StringBuilder().append("com.oracle.jdbc:type=diagnosability,name=").append(str).toString());
/*      */           try
/*      */           {
/*  359 */             localMBeanServer.registerMBean(new OracleDiagnosabilityMBean(), diagnosticMBeanObjectName);
/*      */           }
/*      */           catch (InstanceAlreadyExistsException localInstanceAlreadyExistsException)
/*      */           {
/*      */           }
/*      */         }
/*      */       }
/*      */       else {
/*  367 */         Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
/*      */       }
/*      */     }
/*      */     catch (JMException localJMException)
/*      */     {
/*  372 */       Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", localJMException);
/*      */     }
/*      */     catch (Throwable localThrowable)
/*      */     {
/*  378 */       Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", localThrowable);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Connection connect(String paramString, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  417 */     if (paramString.regionMatches(0, "jdbc:default:connection", 0, 23))
/*      */     {
/*  419 */       String str1 = "jdbc:oracle:kprb";
/*  420 */       int j = paramString.length();
/*      */ 
/*  422 */       if (j > 23)
/*  423 */         paramString = str1.concat(paramString.substring(23, paramString.length()));
/*      */       else {
/*  425 */         paramString = str1.concat(":");
/*      */       }
/*  427 */       str1 = null;
/*      */     }
/*      */ 
/*  437 */     int i = oracleDriverExtensionTypeFromURL(paramString);
/*      */ 
/*  439 */     if (i == -2) {
/*  440 */       return null;
/*      */     }
/*  442 */     if (i == -3)
/*      */     {
/*  444 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 67);
/*  445 */       ((SQLException)localObject1).fillInStackTrace();
/*  446 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/*  449 */     Object localObject1 = null;
/*      */ 
/*  451 */     localObject1 = this.driverExtensions[i];
/*      */ 
/*  453 */     if (localObject1 == null)
/*      */     {
/*      */       try
/*      */       {
/*  458 */         synchronized (this)
/*      */         {
/*  460 */           if (localObject1 == null)
/*      */           {
/*  466 */             localObject1 = (OracleDriverExtension)Class.forName(driverExtensionClassNames[i]).newInstance();
/*      */ 
/*  468 */             this.driverExtensions[i] = localObject1;
/*      */           }
/*      */           else
/*      */           {
/*  472 */             localObject1 = this.driverExtensions[i];
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*  480 */         localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localException);
/*  481 */         ((SQLException)localObject3).fillInStackTrace();
/*  482 */         throw ((Throwable)localObject3);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  489 */     if (paramProperties == null) {
/*  490 */       paramProperties = new Properties();
/*      */     }
/*      */ 
/*  501 */     Enumeration localEnumeration = DriverManager.getDrivers();
/*      */ 
/*  504 */     while (localEnumeration.hasMoreElements())
/*      */     {
/*  506 */       localObject3 = (Driver)localEnumeration.nextElement();
/*      */ 
/*  508 */       if ((localObject3 instanceof OracleDriver))
/*      */       {
/*      */         break;
/*      */       }
/*      */     }
/*  513 */     while (localEnumeration.hasMoreElements())
/*      */     {
/*  515 */       localObject3 = (Driver)localEnumeration.nextElement();
/*      */ 
/*  517 */       if ((localObject3 instanceof OracleDriver)) {
/*  518 */         DriverManager.deregisterDriver((Driver)localObject3);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  525 */     Object localObject3 = null;
/*      */ 
/*  535 */     if ((i != 2) || (!paramProperties.containsKey("connection_pool")) || (!paramProperties.getProperty("connection_pool").equals("connection_pool")))
/*      */     {
/*  540 */       String str2 = null;
/*  541 */       if (paramProperties != null)
/*      */       {
/*  543 */         str2 = paramProperties.getProperty("oracle.jdbc.sqlTranslationProfile");
/*      */       }
/*  545 */       if (str2 == null)
/*      */       {
/*  547 */         str2 = PhysicalConnection.getSqlTranslationProfile();
/*      */       }
/*      */ 
/*  551 */       if (str2 != null)
/*      */       {
/*  553 */         localObject3 = babelfishConnect(paramProperties, str2, paramString, (OracleDriverExtension)localObject1, i);
/*      */       }
/*      */       else
/*      */       {
/*  558 */         localObject3 = (PhysicalConnection)((OracleDriverExtension)localObject1).getConnection(paramString, paramProperties);
/*  559 */         ((PhysicalConnection)localObject3).protocolId = i;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  565 */       localObject3 = (PhysicalConnection)((OracleDriverExtension)localObject1).getConnection(paramString, paramProperties);
/*  566 */       ((PhysicalConnection)localObject3).protocolId = i;
/*      */     }
/*      */ 
/*  570 */     return localObject3;
/*      */   }
/*      */ 
/*      */   private Connection babelfishConnect(Properties paramProperties, String paramString1, String paramString2, OracleDriverExtension paramOracleDriverExtension, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  585 */     paramProperties.put("oracle.jdbc.sqlTranslationProfile", paramString1);
/*      */ 
/*  588 */     paramString1 = null;
/*  589 */     if (paramProperties != null)
/*      */     {
/*  591 */       paramString1 = paramProperties.getProperty("oracle.jdbc.sqlErrorTranslationFile");
/*      */     }
/*  593 */     if (paramString1 == null)
/*      */     {
/*  595 */       paramString1 = System.getProperty("oracle.jdbc.sqlErrorTranslationFile", null);
/*      */     }
/*  597 */     if (paramString1 != null)
/*      */     {
/*  599 */       paramProperties.put("oracle.jdbc.sqlErrorTranslationFile", paramString1);
/*      */     }
/*      */ 
/*  603 */     paramString1 = null;
/*  604 */     if (paramProperties != null)
/*      */     {
/*  606 */       paramString1 = paramProperties.getProperty("user");
/*  607 */       if (paramString1 == null)
/*      */       {
/*  609 */         paramString1 = paramProperties.getProperty("oracle.jdbc.user");
/*      */       }
/*      */     }
/*  612 */     if (paramString1 == null)
/*      */     {
/*  614 */       paramString1 = System.getProperty("oracle.jdbc.user", null);
/*      */     }
/*  616 */     if (paramString1 == null)
/*      */     {
/*  618 */       localObject = PhysicalConnection.parseUrl(paramString2, null, null);
/*  619 */       paramString1 = (String)((Hashtable)localObject).get("user");
/*      */     }
/*      */ 
/*  622 */     paramProperties.put("user", paramString1);
/*      */ 
/*  626 */     Object localObject = ProxyFactory.createJDBCProxyFactory(new Class[] { BabelfishGenericProxy.class, BabelfishConnection.class, BabelfishStatement.class, BabelfishPreparedStatement.class, BabelfishCallableStatement.class });
/*      */ 
/*  638 */     Translator localTranslator = TranslationManager.getTranslator(paramString2, paramProperties.getProperty("user"), paramProperties.getProperty("oracle.jdbc.sqlTranslationProfile"), paramProperties.getProperty("oracle.jdbc.sqlErrorTranslationFile"));
/*      */     try
/*      */     {
/*  646 */       PhysicalConnection localPhysicalConnection = (PhysicalConnection)paramOracleDriverExtension.getConnection(paramString2, paramProperties);
/*  647 */       localPhysicalConnection.protocolId = paramInt;
/*      */ 
/*  649 */       Connection localConnection = (Connection)((ProxyFactory)localObject).proxyFor(localPhysicalConnection);
/*  650 */       ((BabelfishConnection)localConnection).setTranslator(localTranslator);
/*  651 */       localTranslator.activateServerTranslation(localPhysicalConnection);
/*  652 */       return localConnection;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  656 */       throw localTranslator.translateError(localSQLException);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Connection defaultConnection()
/*      */     throws SQLException
/*      */   {
/*  675 */     if ((defaultConn == null) || (defaultConn.isClosed()))
/*      */     {
/*  677 */       synchronized (OracleDriver.class)
/*      */       {
/*  679 */         if ((defaultConn == null) || (defaultConn.isClosed()))
/*      */         {
/*  681 */           defaultConn = connect("jdbc:oracle:kprb:", new Properties());
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  686 */     return defaultConn;
/*      */   }
/*      */ 
/*      */   static final int oracleDriverExtensionTypeFromURL(String paramString)
/*      */   {
/*  711 */     int i = paramString.indexOf(58);
/*      */ 
/*  713 */     if (i == -1) {
/*  714 */       return -2;
/*      */     }
/*  716 */     if (!paramString.regionMatches(true, 0, "jdbc", 0, i)) {
/*  717 */       return -2;
/*      */     }
/*  719 */     i++;
/*      */ 
/*  721 */     int j = paramString.indexOf(58, i);
/*      */ 
/*  723 */     if (j == -1) {
/*  724 */       return -2;
/*      */     }
/*  726 */     if (!paramString.regionMatches(true, i, "oracle", 0, j - i))
/*      */     {
/*  728 */       return -2;
/*      */     }
/*  730 */     j++;
/*      */ 
/*  732 */     int k = paramString.indexOf(58, j);
/*      */ 
/*  734 */     String str = null;
/*      */ 
/*  741 */     if (k == -1) {
/*  742 */       return -3;
/*      */     }
/*  744 */     str = paramString.substring(j, k);
/*      */ 
/*  746 */     if (str.equals("thin")) {
/*  747 */       return 0;
/*      */     }
/*  749 */     if ((str.equals("oci8")) || (str.equals("oci"))) {
/*  750 */       return 2;
/*      */     }
/*      */ 
/*  754 */     return -3;
/*      */   }
/*      */ 
/*      */   public boolean acceptsURL(String paramString)
/*      */   {
/*  779 */     if (paramString.startsWith("jdbc:oracle:"))
/*      */     {
/*  781 */       return oracleDriverExtensionTypeFromURL(paramString) > -2;
/*      */     }
/*      */ 
/*  784 */     return false;
/*      */   }
/*      */ 
/*      */   public DriverPropertyInfo[] getPropertyInfo(String paramString, Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  797 */     Class localClass = null;
/*      */     try
/*      */     {
/*  800 */       localClass = Class.forName("oracle.jdbc.OracleConnection");
/*      */     }
/*      */     catch (ClassNotFoundException localClassNotFoundException) {
/*      */     }
/*  804 */     int i = 0;
/*  805 */     Object localObject1 = new String[''];
/*  806 */     Object localObject2 = new String[''];
/*      */ 
/*  808 */     Field[] arrayOfField = localClass.getFields();
/*  809 */     for (int j = 0; j < arrayOfField.length; j++)
/*      */     {
/*  811 */       if ((arrayOfField[j].getName().startsWith("CONNECTION_PROPERTY_")) && (!arrayOfField[j].getName().endsWith("_DEFAULT")) && (!arrayOfField[j].getName().endsWith("_ACCESSMODE")))
/*      */       {
/*      */         try
/*      */         {
/*  817 */           String str1 = (String)arrayOfField[j].get(null);
/*  818 */           Field localField = localClass.getField(new StringBuilder().append(arrayOfField[j].getName()).append("_DEFAULT").toString());
/*  819 */           String str2 = (String)localField.get(null);
/*  820 */           if (i == localObject1.length)
/*      */           {
/*  822 */             String[] arrayOfString1 = new String[localObject1.length * 2];
/*  823 */             String[] arrayOfString2 = new String[localObject1.length * 2];
/*  824 */             System.arraycopy(localObject1, 0, arrayOfString1, 0, localObject1.length);
/*  825 */             System.arraycopy(localObject2, 0, arrayOfString2, 0, localObject1.length);
/*  826 */             localObject1 = arrayOfString1;
/*  827 */             localObject2 = arrayOfString2;
/*      */           }
/*  829 */           localObject1[i] = str1;
/*  830 */           localObject2[i] = str2;
/*  831 */           i++;
/*      */         }
/*      */         catch (IllegalAccessException localIllegalAccessException) {
/*      */         }
/*      */         catch (NoSuchFieldException localNoSuchFieldException) {
/*      */         }
/*      */       }
/*      */     }
/*  839 */     DriverPropertyInfo[] arrayOfDriverPropertyInfo = new DriverPropertyInfo[i];
/*  840 */     for (int k = 0; k < i; k++)
/*  841 */       arrayOfDriverPropertyInfo[k] = new DriverPropertyInfo(localObject1[k], localObject2[k]);
/*  842 */     return arrayOfDriverPropertyInfo;
/*      */   }
/*      */ 
/*      */   public int getMajorVersion()
/*      */   {
/*  854 */     return OracleDatabaseMetaData.getDriverMajorVersionInfo();
/*      */   }
/*      */ 
/*      */   public int getMinorVersion()
/*      */   {
/*  866 */     return OracleDatabaseMetaData.getDriverMinorVersionInfo();
/*      */   }
/*      */ 
/*      */   public boolean jdbcCompliant()
/*      */   {
/*  878 */     return true;
/*      */   }
/*      */ 
/*      */   public String processSqlEscapes(String paramString)
/*      */     throws SQLException
/*      */   {
/*  898 */     OracleSql localOracleSql = new OracleSql(null);
/*      */ 
/*  902 */     localOracleSql.initialize(paramString);
/*      */ 
/*  904 */     return localOracleSql.parse(paramString);
/*      */   }
/*      */ 
/*      */   public static String getCompileTime()
/*      */   {
/*  919 */     return "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   }
/*      */ 
/*      */   public static String getSystemPropertyFastConnectionFailover(String paramString)
/*      */   {
/*  926 */     return PhysicalConnection.getSystemPropertyFastConnectionFailover(paramString);
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/*  941 */     return null;
/*      */   }
/*      */ 
/*      */   protected void finalize()
/*      */     throws Throwable
/*      */   {
/*  955 */     if (diagnosticMBeanObjectName != null)
/*      */     {
/*      */       try
/*      */       {
/*  959 */         MBeanServer localMBeanServer = null;
/*      */         try
/*      */         {
/*  964 */           Class localClass = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
/*  965 */           Object localObject = localClass.newInstance();
/*  966 */           Method localMethod = localClass.getMethod("getMBeanServer", new Class[0]);
/*  967 */           localMBeanServer = (MBeanServer)localMethod.invoke(localObject, new Object[0]);
/*      */         }
/*      */         catch (Throwable localThrowable2)
/*      */         {
/*  973 */           localMBeanServer = ManagementFactory.getPlatformMBeanServer();
/*      */         }
/*      */ 
/*  976 */         if (localMBeanServer != null)
/*      */         {
/*      */           try
/*      */           {
/*  980 */             localMBeanServer.unregisterMBean(diagnosticMBeanObjectName);
/*      */           }
/*      */           catch (InstanceNotFoundException localInstanceNotFoundException) {
/*      */           }
/*      */         }
/*  985 */         else Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBeans are unregistered.");
/*      */ 
/*      */       }
/*      */       catch (Throwable localThrowable1)
/*      */       {
/*  991 */         Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while unregistering Oracle JDBC Diagnosability MBean.", localThrowable1);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     try
/*      */     {
/*  187 */       if (defaultDriver == null)
/*      */       {
/*  189 */         defaultDriver = new oracle.jdbc.OracleDriver();
/*  190 */         DriverManager.registerDriver(defaultDriver);
/*      */       }
/*      */ 
/*  197 */       AccessController.doPrivileged(new PrivilegedAction()
/*      */       {
/*      */         public Object run()
/*      */         {
/*  201 */           OracleDriver.registerMBeans();
/*  202 */           return null;
/*      */         }
/*      */       });
/*  218 */       Timestamp localTimestamp = Timestamp.valueOf("2000-01-01 00:00:00.0");
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  223 */       Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "SQLException in static block.", localSQLException);
/*      */     }
/*      */     catch (RuntimeException localRuntimeException)
/*      */     {
/*  229 */       Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "RuntimeException in static block.", localRuntimeException);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  243 */       OraclePKIProvider localOraclePKIProvider = new OraclePKIProvider();
/*      */     }
/*      */     catch (Throwable localThrowable)
/*      */     {
/*      */     }
/*      */ 
/*  254 */     systemTypeMap = new Hashtable(2);
/*      */     try
/*      */     {
/*  262 */       systemTypeMap.put("SYS.ANYDATA", Class.forName("oracle.sql.AnyDataFactory"));
/*  263 */       systemTypeMap.put("SYS.ANYTYPE", Class.forName("oracle.sql.TypeDescriptorFactory"));
/*      */     }
/*      */     catch (ClassNotFoundException localClassNotFoundException)
/*      */     {
/*      */     }
/*      */ 
/*  278 */     DEFAULT_CONNECTION_PROPERTIES = new Properties();
/*      */     try
/*      */     {
/*  281 */       InputStream localInputStream = PhysicalConnection.class.getResourceAsStream("/oracle/jdbc/defaultConnectionProperties.properties");
/*  282 */       if (localInputStream != null) DEFAULT_CONNECTION_PROPERTIES.load(localInputStream);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleDriver
 * JD-Core Version:    0.6.2
 */