/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.util.logging.Level;
/*     */ import java.util.logging.Logger;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.StandardMBean;
/*     */ 
/*     */ public class OracleDiagnosabilityMBean extends StandardMBean
/*     */   implements DiagnosabilityMXBean
/*     */ {
/*     */   OracleDiagnosabilityMBean()
/*     */   {
/*  26 */     super(DiagnosabilityMXBean.class, true);
/*     */   }
/*     */ 
/*     */   public boolean getLoggingEnabled()
/*     */   {
/*  41 */     return OracleLog.isEnabled();
/*     */   }
/*     */ 
/*     */   public void setLoggingEnabled(boolean paramBoolean)
/*     */   {
/*  57 */     OracleLog.setTrace(paramBoolean);
/*     */   }
/*     */ 
/*     */   public boolean stateManageable()
/*     */   {
/*  68 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean statisticsProvider()
/*     */   {
/*  79 */     return false;
/*     */   }
/*     */ 
/*     */   protected String getDescription(MBeanInfo paramMBeanInfo)
/*     */   {
/*  87 */     return DatabaseError.findMessage("DiagnosabilityMBeanDescription", this);
/*     */   }
/*     */ 
/*     */   protected String getDescription(MBeanConstructorInfo paramMBeanConstructorInfo)
/*     */   {
/*  96 */     return DatabaseError.findMessage("DiagnosabilityMBeanConstructor()", this);
/*     */   }
/*     */ 
/*     */   protected String getDescription(MBeanAttributeInfo paramMBeanAttributeInfo)
/*     */   {
/* 104 */     String str = paramMBeanAttributeInfo.getName();
/* 105 */     if (str.equals("LoggingEnabled")) {
/* 106 */       return DatabaseError.findMessage("DiagnosabilityMBeanLoggingEnabledDescription", this);
/*     */     }
/* 108 */     if (str.equals("stateManageable")) {
/* 109 */       return DatabaseError.findMessage("DiagnosabilityMBeanStateManageableDescription", this);
/*     */     }
/* 111 */     if (str.equals("statisticsProvider")) {
/* 112 */       return DatabaseError.findMessage("DiagnosabilityMBeanStatisticsProviderDescription", this);
/*     */     }
/*     */ 
/* 115 */     Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Got a request to describe an unexpected  Attribute: " + str);
/*     */ 
/* 118 */     return super.getDescription(paramMBeanAttributeInfo);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleDiagnosabilityMBean
 * JD-Core Version:    0.6.2
 */