/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import oracle.jdbc.OracleCallableStatement;
/*     */ import oracle.jdbc.internal.OracleResultSet;
/*     */ 
/*     */ class OracleDatabaseMetaData extends oracle.jdbc.OracleDatabaseMetaData
/*     */ {
/* 915 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleDatabaseMetaData(oracle.jdbc.internal.OracleConnection paramOracleConnection)
/*     */   {
/*  35 */     super(paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public OracleDatabaseMetaData(OracleConnection paramOracleConnection)
/*     */   {
/*  42 */     this(paramOracleConnection);
/*     */   }
/*     */ 
/*     */   public synchronized ResultSet getColumns(String paramString1, String paramString2, String paramString3, String paramString4)
/*     */     throws SQLException
/*     */   {
/* 117 */     boolean bool = this.connection.getIncludeSynonyms();
/* 118 */     if ((bool) && (paramString2 != null) && (!hasSqlWildcard(paramString2)) && (paramString3 != null) && (!hasSqlWildcard(paramString3)))
/*     */     {
/* 124 */       return getColumnsNoWildcards(stripSqlEscapes(paramString2), stripSqlEscapes(paramString3), paramString4);
/*     */     }
/*     */ 
/* 128 */     return getColumnsWithWildcards(paramString2, paramString3, paramString4, bool);
/*     */   }
/*     */ 
/*     */   ResultSet getColumnsNoWildcards(String paramString1, String paramString2, String paramString3)
/*     */     throws SQLException
/*     */   {
/* 143 */     String str = getColumnsNoWildcardsPlsql();
/* 144 */     CallableStatement localCallableStatement = this.connection.prepareCall(str);
/* 145 */     localCallableStatement.setString(1, paramString1);
/* 146 */     localCallableStatement.setString(2, paramString2);
/* 147 */     localCallableStatement.setString(3, paramString3 == null ? "%" : paramString3);
/* 148 */     localCallableStatement.registerOutParameter(4, -10);
/* 149 */     localCallableStatement.execute();
/* 150 */     ResultSet localResultSet = ((OracleCallableStatement)localCallableStatement).getCursor(4);
/* 151 */     ((OracleResultSet)localResultSet).closeStatementOnClose();
/* 152 */     return localResultSet;
/*     */   }
/*     */ 
/*     */   ResultSet getColumnsWithWildcards(String paramString1, String paramString2, String paramString3, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 164 */     int i = this.connection.getVersionNumber();
/*     */ 
/* 177 */     String str1 = "SELECT ";
/* 178 */     String str2 = " NULL AS table_cat,\n";
/*     */ 
/* 184 */     String str3 = "";
/* 185 */     if (((i >= 10200 ? 1 : 0) & (i < 11100 ? 1 : 0) & paramBoolean) != 0) str3 = "/*+ CHOOSE */";
/*     */ 
/* 187 */     String str4 = "       t.owner AS table_schem,\n       t.table_name AS table_name,\n";
/*     */ 
/* 190 */     String str5 = "       DECODE(s.owner, NULL, t.owner, s.owner)\n              AS table_schem,\n       DECODE(s.synonym_name, NULL, t.table_name, s.synonym_name)\n              AS table_name,\n";
/*     */ 
/* 196 */     String str6 = "         DECODE (t.data_type, 'CHAR', t.char_length,                   'VARCHAR', t.char_length,                   'VARCHAR2', t.char_length,                   'NVARCHAR2', t.char_length,                   'NCHAR', t.char_length,                   'NUMBER', 0,           t.data_length)";
/*     */ 
/* 205 */     String str7 = new StringBuilder().append("       t.column_name AS column_name,\n       DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', ").append(((PhysicalConnection)this.connection).mapDateToTimestamp ? "93" : "91").append(", 'RAW', -3, 'LONG RAW', -4,  \n").append("               'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, \n").append("               'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n").append("               'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n").append("               'INTERVAL YEAR(2) TO MONTH', -103, \n").append("               'INTERVAL DAY(2) TO SECOND(6)', -104, \n").append("               'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, \n").append("               'XMLTYPE', 2009, \n").append("               1111)\n").append("              AS data_type,\n").append("       t.data_type AS type_name,\n").append("       DECODE (t.data_precision, ").append("               null, DECODE(t.data_type, ").append("                       'NUMBER', DECODE(t.data_scale, ").append("                                   null, ").append(((PhysicalConnection)this.connection).j2ee13Compliant ? "38" : "0").append("                                   , 38), ").append(str6).append("                           ),").append("         t.data_precision)\n").append("              AS column_size,\n").append("       0 AS buffer_length,\n").append("       DECODE (t.data_type, ").append("               'NUMBER', DECODE(t.data_precision, ").append("                                null, DECODE(t.data_scale, ").append("                                             null, ").append(((PhysicalConnection)this.connection).j2ee13Compliant ? "0" : "-127").append("                                             , t.data_scale), ").append("                                 t.data_scale), ").append("               t.data_scale) AS decimal_digits,\n").append("       10 AS num_prec_radix,\n").append("       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n").toString();
/*     */ 
/* 243 */     String str8 = "       c.comments AS remarks,\n";
/*     */ 
/* 245 */     String str9 = "       NULL AS remarks,\n";
/*     */ 
/* 247 */     String str10 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable,\n";
/*     */ 
/* 254 */     String str11 = "         null as SCOPE_CATALOG,\n       null as SCOPE_SCHEMA,\n       null as SCOPE_TABLE,\n       null as SOURCE_DATA_TYPE,\n       'NO' as IS_AUTOINCREMENT\n";
/*     */ 
/* 261 */     String str12 = "FROM all_tab_columns t";
/*     */ 
/* 263 */     String str13 = ", all_synonyms s";
/* 264 */     String str14 = ", all_col_comments c";
/*     */ 
/* 266 */     String str15 = "WHERE t.owner LIKE :1 ESCAPE '/'\n  AND t.table_name LIKE :2 ESCAPE '/'\n  AND t.column_name LIKE :3 ESCAPE '/'\n";
/*     */ 
/* 270 */     String str16 = "WHERE (t.owner LIKE :4 ESCAPE '/' OR\n       (s.owner LIKE :5 ESCAPE '/' AND t.owner = s.table_owner))\n  AND (t.table_name LIKE :6 ESCAPE '/' OR\n       s.synonym_name LIKE :7 ESCAPE '/')\n  AND t.column_name LIKE :8 ESCAPE '/'\n";
/*     */ 
/* 277 */     String str17 = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
/*     */ 
/* 281 */     String str18 = "  AND s.table_name (+) = t.table_name\n  AND ((DECODE(s.owner, t.owner, 'OK',\n                       'PUBLIC', 'OK',\n                       NULL, 'OK',\n                       'NOT OK') = 'OK') OR\n       (t.owner LIKE :9 AND t.owner = s.table_owner) OR\n       (s.owner LIKE :10 AND t.owner = s.table_owner))";
/*     */ 
/* 290 */     String str19 = "ORDER BY table_schem, table_name, ordinal_position\n";
/*     */ 
/* 296 */     String str20 = new StringBuilder().append(str1).append(str3).append(str2).toString();
/*     */ 
/* 298 */     if (paramBoolean)
/* 299 */       str20 = new StringBuilder().append(str20).append(str5).toString();
/*     */     else {
/* 301 */       str20 = new StringBuilder().append(str20).append(str4).toString();
/*     */     }
/* 303 */     str20 = new StringBuilder().append(str20).append(str7).toString();
/*     */ 
/* 305 */     if (this.connection.getRemarksReporting())
/* 306 */       str20 = new StringBuilder().append(str20).append(str8).toString();
/*     */     else {
/* 308 */       str20 = new StringBuilder().append(str20).append(str9).toString();
/*     */     }
/* 310 */     str20 = new StringBuilder().append(str20).append(str10).append(str11).append(str12).toString();
/*     */ 
/* 312 */     if (this.connection.getRemarksReporting()) {
/* 313 */       str20 = new StringBuilder().append(str20).append(str14).toString();
/*     */     }
/* 315 */     if (paramBoolean) {
/* 316 */       str20 = new StringBuilder().append(str20).append(str13).toString();
/*     */     }
/* 318 */     if (paramBoolean)
/* 319 */       str20 = new StringBuilder().append(str20).append("\n").append(str16).toString();
/*     */     else {
/* 321 */       str20 = new StringBuilder().append(str20).append("\n").append(str15).toString();
/*     */     }
/* 323 */     if (this.connection.getRemarksReporting()) {
/* 324 */       str20 = new StringBuilder().append(str20).append(str17).toString();
/*     */     }
/* 326 */     if (this.connection.getIncludeSynonyms()) {
/* 327 */       str20 = new StringBuilder().append(str20).append(str18).toString();
/*     */     }
/* 329 */     str20 = new StringBuilder().append(str20).append("\n").append(str19).toString();
/*     */ 
/* 332 */     PreparedStatement localPreparedStatement = this.connection.prepareStatement(str20);
/*     */ 
/* 334 */     if (paramBoolean)
/*     */     {
/* 336 */       localPreparedStatement.setString(1, paramString1 == null ? "%" : paramString1);
/* 337 */       localPreparedStatement.setString(2, paramString1 == null ? "%" : paramString1);
/* 338 */       localPreparedStatement.setString(3, paramString2 == null ? "%" : paramString2);
/* 339 */       localPreparedStatement.setString(4, paramString2 == null ? "%" : paramString2);
/* 340 */       localPreparedStatement.setString(5, paramString3 == null ? "%" : paramString3);
/* 341 */       localPreparedStatement.setString(6, paramString1 == null ? "%" : paramString1);
/* 342 */       localPreparedStatement.setString(7, paramString1 == null ? "%" : paramString1);
/*     */     }
/*     */     else
/*     */     {
/* 346 */       localPreparedStatement.setString(1, paramString1 == null ? "%" : paramString1);
/* 347 */       localPreparedStatement.setString(2, paramString2 == null ? "%" : paramString2);
/* 348 */       localPreparedStatement.setString(3, paramString3 == null ? "%" : paramString3);
/*     */     }
/*     */ 
/* 351 */     OracleResultSet localOracleResultSet = (OracleResultSet)localPreparedStatement.executeQuery();
/*     */ 
/* 354 */     localOracleResultSet.closeStatementOnClose();
/*     */ 
/* 356 */     return localOracleResultSet;
/*     */   }
/*     */ 
/*     */   public ResultSet getTypeInfo()
/*     */     throws SQLException
/*     */   {
/* 414 */     Statement localStatement = this.connection.createStatement();
/* 415 */     int i = this.connection.getVersionNumber();
/* 416 */     int j = this.connection.getVarTypeMaxLenCompat();
/* 417 */     int k = 2000;
/* 418 */     int m = 2000;
/* 419 */     int n = 4000;
/* 420 */     int i1 = 4000;
/* 421 */     int i2 = 2000;
/* 422 */     if (j == 2)
/*     */     {
/* 424 */       k = 2000;
/* 425 */       m = 2000;
/* 426 */       n = 32767;
/* 427 */       i1 = 32766;
/* 428 */       i2 = 32767;
/*     */     }
/*     */ 
/* 504 */     String str1 = new StringBuilder().append("union select\n 'CHAR' as type_name, 1 as data_type, ").append(k).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 1 as case_sensitive, 3 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'CHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 514 */     String str2 = new StringBuilder().append("union select\n 'NCHAR' as type_name, -15 as data_type, ").append(m).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 1 as case_sensitive, 3 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'NCHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 524 */     String str3 = new StringBuilder().append("union select\n 'VARCHAR2' as type_name, 12 as data_type, ").append(n).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 1 as case_sensitive, 3 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'VARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 534 */     String str4 = new StringBuilder().append("union select\n 'NVARCHAR2' as type_name, -9 as data_type, ").append(i1).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 1 as case_sensitive, 3 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'nVARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 554 */     String str5 = new StringBuilder().append("union select\n 'DATE' as type_name, ").append(((PhysicalConnection)this.connection).mapDateToTimestamp ? "93" : "91").append("as data_type, 7 as precision,\n").append(" NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 0 as case_sensitive, 3 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 626 */     String str6 = new StringBuilder().append("union select\n 'RAW' as type_name, -3 as data_type, ").append(i2).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 0 as case_sensitive, 3 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 646 */     String str7 = "-1";
/*     */ 
/* 648 */     String str8 = new StringBuilder().append("union select\n 'BLOB' as type_name, 2004 as data_type, ").append(str7).append(" as precision,\n").append(" null as literal_prefix, null as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 0 as case_sensitive, 0 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'BLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 658 */     String str9 = new StringBuilder().append("union select\n 'CLOB' as type_name, 2005 as data_type, ").append(str7).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 1 as case_sensitive, 0 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'CLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 668 */     String str10 = new StringBuilder().append("union select\n 'NCLOB' as type_name, 2011 as data_type, ").append(str7).append(" as precision,\n").append(" '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n").append(" 1 as nullable, 1 as case_sensitive, 0 as searchable,\n").append(" 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n").append(" 'NCLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n").append(" NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n").append("from dual\n").toString();
/*     */ 
/* 711 */     String str11 = new StringBuilder().append("select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append(str1).append(str2).append(str3).append(str4).append(str5).append("union select\n 'DATE' as type_name, 92 as data_type, 7 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'TIMESTAMP' as type_name, 93 as data_type, 11 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'TIMESTAMP WITH TIME ZONE' as type_name, -101 as data_type, 13 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, -102 as data_type, 11 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'INTERVALYM' as type_name, -103 as data_type, 5 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALYM' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'INTERVALDS' as type_name, -104 as data_type, 4 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALDS' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append(str6).append("union select\n 'LONG' as type_name, -1 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'LONG RAW' as type_name, -4 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append(str8).append(str9).append(str10).append("union select\n 'REF' as type_name, 2006 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'REF' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'ARRAY' as type_name, 2003 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'ARRAY' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("union select\n 'STRUCT' as type_name, 2002 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'STRUCT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n").append("order by data_type\n").toString();
/*     */ 
/* 728 */     OracleResultSet localOracleResultSet = (OracleResultSet)localStatement.executeQuery(str11);
/*     */ 
/* 731 */     localOracleResultSet.closeStatementOnClose();
/*     */ 
/* 733 */     return localOracleResultSet;
/*     */   }
/*     */ 
/*     */   String getColumnsNoWildcardsPlsql()
/*     */     throws SQLException
/*     */   {
/* 740 */     String str1 = "declare\n  in_owner varchar2(32) := null;\n  in_name varchar2(32) := null;\n  my_user_name varchar2(32) := null;\n  cnt number := 0;\n  out_owner varchar2(32) := null;\n  out_name  varchar2(32):= null;\n  loc varchar2(32) := null;\n  xxx SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if( my_user_name = in_owner ) then\n    select count(*) into cnt from user_tables where table_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'USER_TABLES';\n    else\n      begin\n        select table_owner, table_name into out_owner, out_name from user_synonyms where synonym_name = in_name;\n      exception\n        when NO_DATA_FOUND then\n        out_owner := null;\n        out_name := null;\n      end;\n      if( not(out_name is null) ) then\n        loc := 'USER_SYNONYMS';\n      end if;\n    end if;\n  else\n    select count(*) into cnt from all_tables where owner = in_owner and table_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'ALL_TABLES';\n    else\n      begin\n        select table_owner, table_name into out_owner, out_name from all_synonyms \n          where  owner = in_owner and synonym_name = in_name;\n      exception\n        when NO_DATA_FOUND then\n          out_owner := null;\n          out_name := null;\n      end;\n      if( not(out_owner is null) ) then\n        loc := 'ALL_SYNONYMS';\n      end if;\n    end if;\n  end if;\n";
/*     */ 
/* 793 */     int i = this.connection.getVersionNumber();
/* 794 */     String str2 = "open xxx for SELECT NULL AS table_cat,\n";
/*     */ 
/* 796 */     String str3 = "       in_owner AS table_schem,\n       in_name AS table_name,\n";
/*     */ 
/* 799 */     String str4 = "         DECODE (t.data_type, 'CHAR', t.char_length,                   'VARCHAR', t.char_length,                   'VARCHAR2', t.char_length,                   'NVARCHAR2', t.char_length,                   'NCHAR', t.char_length,                   'NUMBER', 0,           t.data_length)";
/*     */ 
/* 808 */     String str5 = new StringBuilder().append("       t.column_name AS column_name,\n       DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', ").append(this.connection.getMapDateToTimestamp() ? "93" : "91").append(", 'RAW', -3, 'LONG RAW', -4,  \n").append("               'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, \n").append("               'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n").append("               'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n").append("               'INTERVAL YEAR(2) TO MONTH', -103, \n").append("               'INTERVAL DAY(2) TO SECOND(6)', -104, \n").append("               'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, \n").append("               'XMLTYPE', 2009, \n").append("               1111)\n").append("              AS data_type,\n").append("       t.data_type AS type_name,\n").append("       DECODE (t.data_precision, ").append("               null, DECODE(t.data_type, ").append("                       'NUMBER', DECODE(t.data_scale, ").append("                                   null, ").append(((PhysicalConnection)this.connection).j2ee13Compliant ? "38" : "0").append("                                   , 38), ").append(str4).append("                           ),").append("         t.data_precision)\n").append("              AS column_size,\n").append("       0 AS buffer_length,\n").append("       DECODE (t.data_type, ").append("               'NUMBER', DECODE(t.data_precision, ").append("                                null, DECODE(t.data_scale, ").append("                                             null, ").append(((PhysicalConnection)this.connection).j2ee13Compliant ? "0" : "-127").append("                                             , t.data_scale), ").append("                                 t.data_scale), ").append("               t.data_scale) AS decimal_digits,\n").append("       10 AS num_prec_radix,\n").append("       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n").toString();
/*     */ 
/* 846 */     String str6 = "       c.comments AS remarks,\n";
/*     */ 
/* 848 */     String str7 = "       NULL AS remarks,\n";
/*     */ 
/* 850 */     String str8 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable,\n";
/*     */ 
/* 857 */     String str9 = "         null as SCOPE_CATALOG,\n       null as SCOPE_SCHEMA,\n       null as SCOPE_TABLE,\n       null as SOURCE_DATA_TYPE,\n       'NO' as IS_AUTOINCREMENT\n";
/*     */ 
/* 864 */     String str10 = "FROM all_tab_columns t";
/*     */ 
/* 866 */     String str11 = ", all_col_comments c";
/*     */ 
/* 868 */     String str12 = "WHERE t.owner = out_owner \n  AND t.table_name = out_name\n AND t.column_name LIKE ? ESCAPE '/'\n";
/*     */ 
/* 873 */     String str13 = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
/*     */ 
/* 878 */     String str14 = "ORDER BY table_schem, table_name, ordinal_position\n";
/*     */ 
/* 883 */     String str15 = str2;
/*     */ 
/* 885 */     str15 = new StringBuilder().append(str15).append(str3).toString();
/*     */ 
/* 887 */     str15 = new StringBuilder().append(str15).append(str5).toString();
/*     */ 
/* 889 */     if (this.connection.getRemarksReporting())
/* 890 */       str15 = new StringBuilder().append(str15).append(str6).toString();
/*     */     else {
/* 892 */       str15 = new StringBuilder().append(str15).append(str7).toString();
/*     */     }
/* 894 */     str15 = new StringBuilder().append(str15).append(str8).append(str9).append(str10).toString();
/*     */ 
/* 896 */     if (this.connection.getRemarksReporting()) {
/* 897 */       str15 = new StringBuilder().append(str15).append(str11).toString();
/*     */     }
/* 899 */     str15 = new StringBuilder().append(str15).append("\n").append(str12).toString();
/*     */ 
/* 901 */     if (this.connection.getRemarksReporting()) {
/* 902 */       str15 = new StringBuilder().append(str15).append(str13).toString();
/*     */     }
/*     */ 
/* 905 */     str15 = new StringBuilder().append(str15).append("\n").append(str14).toString();
/*     */ 
/* 907 */     String str16 = "; \n ? := xxx;\n end;";
/*     */ 
/* 909 */     String str17 = new StringBuilder().append(str1).append(str15).append(str16).toString();
/* 910 */     return str17;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleDatabaseMetaData
 * JD-Core Version:    0.6.2
 */