/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class OracleConversionReader extends Reader
/*     */ {
/*     */   static final int CHUNK_SIZE = 32768;
/*     */   DBConversion dbConversion;
/*     */   int conversion;
/*     */   InputStream istream;
/*     */   char[] buf;
/*     */   byte[] byteBuf;
/*     */   int pos;
/*     */   int count;
/*     */   int numUnconvertedBytes;
/*     */   boolean isClosed;
/*     */   boolean endOfStream;
/*     */   private short csform;
/*     */   int[] nbytes;
/* 362 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleConversionReader(DBConversion paramDBConversion, InputStream paramInputStream, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  57 */     if ((paramDBConversion == null) || (paramInputStream == null) || ((paramInt != 8) && (paramInt != 9)))
/*     */     {
/*  61 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  62 */       localSQLException.fillInStackTrace();
/*  63 */       throw localSQLException;
/*     */     }
/*     */ 
/*  66 */     this.dbConversion = paramDBConversion;
/*  67 */     this.conversion = paramInt;
/*  68 */     this.istream = paramInputStream;
/*  69 */     this.pos = (this.count = 0);
/*  70 */     this.numUnconvertedBytes = 0;
/*     */ 
/*  72 */     this.isClosed = false;
/*  73 */     this.nbytes = new int[1];
/*     */ 
/*  75 */     if (paramInt == 8)
/*     */     {
/*  77 */       this.byteBuf = new byte[16384];
/*  78 */       this.buf = new char[32768];
/*     */     }
/*  80 */     else if (paramInt == 9)
/*     */     {
/*  82 */       this.byteBuf = new byte[32768];
/*  83 */       this.buf = new char[32768];
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setFormOfUse(short paramShort)
/*     */   {
/*  92 */     this.csform = paramShort;
/*     */   }
/*     */ 
/*     */   public int read(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 119 */     ensureOpen();
/*     */ 
/* 121 */     if (!needChars()) {
/* 122 */       return -1;
/*     */     }
/* 124 */     int i = paramInt1;
/* 125 */     int j = i + Math.min(paramInt2, paramArrayOfChar.length - paramInt1);
/*     */ 
/* 127 */     i += writeChars(paramArrayOfChar, i, j - i);
/*     */ 
/* 129 */     while ((i < j) && (needChars()))
/*     */     {
/* 131 */       i += writeChars(paramArrayOfChar, i, j - i);
/*     */     }
/*     */ 
/* 134 */     return i - paramInt1;
/*     */   }
/*     */ 
/*     */   protected boolean needChars()
/*     */     throws IOException
/*     */   {
/* 148 */     ensureOpen();
/*     */ 
/* 150 */     if (this.pos >= this.count)
/*     */     {
/* 154 */       if (!this.endOfStream)
/*     */       {
/*     */         try
/*     */         {
/* 158 */           int i = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
/*     */ 
/* 161 */           if (i == -1)
/*     */           {
/* 163 */             this.endOfStream = true;
/*     */ 
/* 165 */             this.istream.close();
/*     */ 
/* 167 */             if (this.numUnconvertedBytes != 0)
/*     */             {
/* 169 */               SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 55);
/* 170 */               localSQLException2.fillInStackTrace();
/* 171 */               throw localSQLException2;
/*     */             }
/*     */           }
/*     */ 
/* 175 */           i += this.numUnconvertedBytes;
/*     */ 
/* 177 */           if (i > 0)
/*     */           {
/* 179 */             switch (this.conversion)
/*     */             {
/*     */             case 8:
/* 184 */               this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, i, this.buf);
/*     */ 
/* 186 */               break;
/*     */             case 9:
/* 191 */               this.nbytes[0] = i;
/*     */ 
/* 193 */               if (this.csform == 2) {
/* 194 */                 this.count = this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
/*     */               }
/*     */               else
/*     */               {
/* 199 */                 this.count = this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
/*     */               }
/*     */ 
/* 204 */               this.numUnconvertedBytes = this.nbytes[0];
/*     */ 
/* 206 */               for (int j = 0; j < this.numUnconvertedBytes; j++) {
/* 207 */                 this.byteBuf[j] = this.byteBuf[(i - this.numUnconvertedBytes + j)];
/*     */               }
/* 209 */               break;
/*     */             default:
/* 214 */               localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/* 215 */               ((SQLException)localObject).fillInStackTrace();
/* 216 */               throw ((Throwable)localObject);
/*     */             }
/*     */ 
/* 220 */             if (this.count > 0)
/*     */             {
/* 222 */               this.pos = 0;
/*     */ 
/* 224 */               return true;
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (SQLException localSQLException1)
/*     */         {
/* 233 */           Object localObject = DatabaseError.createIOException(localSQLException1);
/* 234 */           ((IOException)localObject).fillInStackTrace();
/* 235 */           throw ((Throwable)localObject);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 240 */       return false;
/*     */     }
/*     */ 
/* 243 */     return true;
/*     */   }
/*     */ 
/*     */   protected int writeChars(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*     */   {
/* 258 */     int i = Math.min(paramInt2, this.count - this.pos);
/*     */ 
/* 260 */     System.arraycopy(this.buf, this.pos, paramArrayOfChar, paramInt1, i);
/*     */ 
/* 262 */     this.pos += i;
/*     */ 
/* 264 */     return i;
/*     */   }
/*     */ 
/*     */   public boolean ready()
/*     */     throws IOException
/*     */   {
/* 286 */     ensureOpen();
/*     */ 
/* 288 */     return this.pos < this.count;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 308 */     if (!this.isClosed)
/*     */     {
/* 310 */       this.isClosed = true;
/*     */ 
/* 312 */       this.istream.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 328 */       if (this.isClosed)
/*     */       {
/* 330 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 331 */         localSQLException1.fillInStackTrace();
/* 332 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 338 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 339 */       localIOException.fillInStackTrace();
/* 340 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 357 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleConversionReader
 * JD-Core Version:    0.6.2
 */