/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class OracleConversionInputStream extends OracleBufferedStream
/*     */ {
/*     */   static final int CHUNK_SIZE = 32768;
/*     */   DBConversion converter;
/*     */   int conversion;
/*     */   InputStream istream;
/*     */   Reader reader;
/*     */   byte[] convbuf;
/*     */   char[] javaChars;
/*     */   int maxSize;
/*     */   int totalSize;
/*     */   int numUnconvertedBytes;
/*     */   boolean endOfStream;
/*     */   private short csform;
/*     */   int[] nbytes;
/* 526 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleConversionInputStream(DBConversion paramDBConversion, InputStream paramInputStream, int paramInt)
/*     */   {
/*  50 */     this(paramDBConversion, paramInputStream, paramInt, (short)1);
/*     */   }
/*     */ 
/*     */   public OracleConversionInputStream(DBConversion paramDBConversion, InputStream paramInputStream, int paramInt, short paramShort)
/*     */   {
/*  60 */     super(32768);
/*     */ 
/*  62 */     this.istream = paramInputStream;
/*  63 */     this.conversion = paramInt;
/*  64 */     this.converter = paramDBConversion;
/*  65 */     this.maxSize = 0;
/*  66 */     this.totalSize = 0;
/*  67 */     this.numUnconvertedBytes = 0;
/*  68 */     this.endOfStream = false;
/*  69 */     this.nbytes = new int[1];
/*  70 */     this.csform = paramShort;
/*  71 */     this.currentBufferSize = this.initialBufferSize;
/*  72 */     this.resizableBuffer = new byte[this.currentBufferSize];
/*     */     int i;
/*  74 */     switch (paramInt)
/*     */     {
/*     */     case 0:
/*  79 */       this.javaChars = new char[32768];
/*  80 */       this.convbuf = new byte[32768];
/*     */ 
/*  83 */       break;
/*     */     case 1:
/*  87 */       this.convbuf = new byte[16384];
/*  88 */       this.javaChars = new char[16384];
/*     */ 
/*  91 */       break;
/*     */     case 2:
/*  95 */       this.convbuf = new byte[16384];
/*  96 */       this.javaChars = new char[32768];
/*     */ 
/*  99 */       break;
/*     */     case 3:
/* 103 */       this.convbuf = new byte[8192];
/* 104 */       this.javaChars = new char[16384];
/*     */ 
/* 107 */       break;
/*     */     case 4:
/* 111 */       i = 32768 / this.converter.getMaxCharbyteSize();
/*     */ 
/* 113 */       this.convbuf = new byte[i * 2];
/* 114 */       this.javaChars = new char[i];
/*     */ 
/* 117 */       break;
/*     */     case 5:
/* 121 */       if (this.converter.isUcs2CharSet())
/*     */       {
/* 123 */         this.convbuf = new byte[16384];
/* 124 */         this.javaChars = new char[16384];
/*     */       }
/*     */       else
/*     */       {
/* 128 */         this.convbuf = new byte[32768];
/* 129 */         this.javaChars = new char[32768];
/*     */       }
/*     */ 
/* 133 */       break;
/*     */     case 7:
/* 137 */       i = 32768 / (paramShort == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
/*     */ 
/* 139 */       this.javaChars = new char[i];
/*     */ 
/* 142 */       break;
/*     */     case 6:
/*     */     default:
/* 146 */       this.convbuf = new byte[32768];
/* 147 */       this.javaChars = new char[32768];
/*     */     }
/*     */   }
/*     */ 
/*     */   public OracleConversionInputStream(DBConversion paramDBConversion, InputStream paramInputStream, int paramInt1, int paramInt2)
/*     */   {
/* 158 */     this(paramDBConversion, paramInputStream, paramInt1, (short)1);
/*     */ 
/* 160 */     this.maxSize = paramInt2;
/* 161 */     this.totalSize = 0;
/*     */   }
/*     */ 
/*     */   public OracleConversionInputStream(DBConversion paramDBConversion, Reader paramReader, int paramInt1, int paramInt2, short paramShort)
/*     */   {
/* 170 */     this(paramDBConversion, (InputStream)null, paramInt1, paramShort);
/*     */ 
/* 172 */     this.reader = paramReader;
/* 173 */     this.maxSize = paramInt2;
/* 174 */     this.totalSize = 0;
/*     */   }
/*     */ 
/*     */   public void setFormOfUse(short paramShort)
/*     */   {
/* 182 */     this.csform = paramShort;
/*     */   }
/*     */ 
/*     */   public boolean needBytes(int paramInt)
/*     */     throws IOException
/*     */   {
/* 189 */     return needBytes();
/*     */   }
/*     */ 
/*     */   public boolean needBytes()
/*     */     throws IOException
/*     */   {
/* 199 */     if (this.closed) {
/* 200 */       return false;
/*     */     }
/*     */ 
/* 204 */     if (this.pos < this.count) {
/* 205 */       return true;
/*     */     }
/* 207 */     if (this.istream != null)
/*     */     {
/* 209 */       return needBytesFromStream();
/*     */     }
/* 211 */     if (this.reader != null)
/*     */     {
/* 213 */       return needBytesFromReader();
/*     */     }
/*     */ 
/* 216 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean needBytesFromReader()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 226 */       int i = 0;
/*     */ 
/* 228 */       if (this.maxSize == 0)
/*     */       {
/* 230 */         i = this.javaChars.length;
/*     */       }
/*     */       else
/*     */       {
/* 234 */         i = Math.min(this.maxSize - this.totalSize, this.javaChars.length);
/*     */       }
/*     */ 
/* 237 */       if (i <= 0)
/*     */       {
/* 239 */         return false;
/*     */       }
/*     */ 
/* 242 */       int j = this.reader.read(this.javaChars, 0, i);
/*     */ 
/* 244 */       if (j == -1)
/*     */       {
/* 246 */         return false;
/*     */       }
/*     */ 
/* 250 */       this.totalSize += j;
/*     */ 
/* 254 */       switch (this.conversion)
/*     */       {
/*     */       case 7:
/* 259 */         if (this.csform == 2)
/* 260 */           this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, j, this.resizableBuffer);
/*     */         else {
/* 262 */           this.count = this.converter.javaCharsToCHARBytes(this.javaChars, j, this.resizableBuffer);
/*     */         }
/*     */ 
/* 265 */         break;
/*     */       default:
/* 269 */         System.arraycopy(this.convbuf, 0, this.resizableBuffer, 0, j);
/*     */ 
/* 271 */         this.count = j;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 278 */       IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 279 */       localIOException.fillInStackTrace();
/* 280 */       throw localIOException;
/*     */     }
/*     */ 
/* 285 */     this.pos = 0;
/*     */ 
/* 288 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean needBytesFromStream()
/*     */     throws IOException
/*     */   {
/* 296 */     if (!this.endOfStream)
/*     */     {
/*     */       try
/*     */       {
/* 300 */         int i = 0;
/*     */ 
/* 302 */         if (this.maxSize == 0)
/*     */         {
/* 304 */           i = this.convbuf.length;
/*     */         }
/*     */         else
/*     */         {
/* 308 */           i = Math.min(this.maxSize - this.totalSize, this.convbuf.length);
/*     */         }
/*     */ 
/* 311 */         int j = 0;
/*     */         SQLException localSQLException2;
/* 313 */         if (i <= 0)
/*     */         {
/* 317 */           this.endOfStream = true;
/*     */ 
/* 319 */           this.istream.close();
/*     */ 
/* 321 */           if (this.numUnconvertedBytes != 0)
/*     */           {
/* 323 */             localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 55);
/* 324 */             localSQLException2.fillInStackTrace();
/* 325 */             throw localSQLException2;
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 332 */           j = this.istream.read(this.convbuf, this.numUnconvertedBytes, i - this.numUnconvertedBytes);
/*     */         }
/*     */ 
/* 338 */         if (j == -1)
/*     */         {
/* 342 */           this.endOfStream = true;
/*     */ 
/* 344 */           this.istream.close();
/*     */ 
/* 346 */           if (this.numUnconvertedBytes != 0)
/*     */           {
/* 348 */             localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 55);
/* 349 */             localSQLException2.fillInStackTrace();
/* 350 */             throw localSQLException2;
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 355 */           j += this.numUnconvertedBytes;
/* 356 */           this.totalSize += j;
/*     */         }
/*     */ 
/* 359 */         if (j <= 0)
/*     */         {
/* 361 */           return false;
/*     */         }
/*     */         int k;
/*     */         int m;
/* 367 */         switch (this.conversion)
/*     */         {
/*     */         case 0:
/* 374 */           this.nbytes[0] = j;
/*     */ 
/* 376 */           k = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
/*     */ 
/* 381 */           this.numUnconvertedBytes = this.nbytes[0];
/*     */ 
/* 383 */           for (m = 0; m < this.numUnconvertedBytes; m++) {
/* 384 */             this.convbuf[m] = this.convbuf[(j - this.numUnconvertedBytes)];
/*     */           }
/*     */ 
/* 387 */           this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, k, this.resizableBuffer);
/*     */ 
/* 390 */           break;
/*     */         case 1:
/* 396 */           this.nbytes[0] = j;
/*     */ 
/* 398 */           k = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
/*     */ 
/* 403 */           this.numUnconvertedBytes = this.nbytes[0];
/*     */ 
/* 405 */           for (m = 0; m < this.numUnconvertedBytes; m++) {
/* 406 */             this.convbuf[m] = this.convbuf[(j - this.numUnconvertedBytes)];
/*     */           }
/*     */ 
/* 409 */           this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, k, this.resizableBuffer);
/*     */ 
/* 412 */           break;
/*     */         case 2:
/* 418 */           k = DBConversion.RAWBytesToHexChars(this.convbuf, j, this.javaChars);
/*     */ 
/* 422 */           this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, k, this.resizableBuffer);
/*     */ 
/* 425 */           break;
/*     */         case 3:
/* 431 */           k = DBConversion.RAWBytesToHexChars(this.convbuf, j, this.javaChars);
/*     */ 
/* 435 */           this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, k, this.resizableBuffer);
/*     */ 
/* 438 */           break;
/*     */         case 4:
/* 444 */           k = DBConversion.ucs2BytesToJavaChars(this.convbuf, j, this.javaChars);
/*     */ 
/* 448 */           this.count = this.converter.javaCharsToCHARBytes(this.javaChars, k, this.resizableBuffer);
/*     */ 
/* 451 */           break;
/*     */         case 12:
/* 457 */           k = DBConversion.ucs2BytesToJavaChars(this.convbuf, j, this.javaChars);
/*     */ 
/* 462 */           this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, k, this.resizableBuffer);
/*     */ 
/* 467 */           break;
/*     */         case 5:
/* 473 */           DBConversion.asciiBytesToJavaChars(this.convbuf, j, this.javaChars);
/*     */ 
/* 476 */           this.count = this.converter.javaCharsToCHARBytes(this.javaChars, j, this.resizableBuffer);
/*     */ 
/* 479 */           break;
/*     */         case 6:
/*     */         case 7:
/*     */         case 8:
/*     */         case 9:
/*     */         case 10:
/*     */         case 11:
/*     */         default:
/* 483 */           System.arraycopy(this.convbuf, 0, this.resizableBuffer, 0, j);
/*     */ 
/* 485 */           this.count = j;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException1)
/*     */       {
/* 493 */         IOException localIOException = DatabaseError.createIOException(localSQLException1);
/* 494 */         localIOException.fillInStackTrace();
/* 495 */         throw localIOException;
/*     */       }
/*     */ 
/* 500 */       this.pos = 0;
/*     */ 
/* 503 */       return true;
/*     */     }
/*     */ 
/* 506 */     return false;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 521 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleConversionInputStream
 * JD-Core Version:    0.6.2
 */