/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleClob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.CLOB;
/*     */ 
/*     */ class OracleClobWriter extends Writer
/*     */ {
/*     */   DBConversion dbConversion;
/*     */   OracleClob clob;
/*     */   long lobOffset;
/*     */   char[] charBuf;
/*     */   byte[] nativeBuf;
/*     */   int pos;
/*     */   int count;
/*     */   int chunkSize;
/*     */   boolean isClosed;
/* 309 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleClobWriter(CLOB paramCLOB, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  47 */     this(paramCLOB, paramInt);
/*     */   }
/*     */ 
/*     */   public OracleClobWriter(OracleClob paramOracleClob, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  58 */     this(paramOracleClob, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleClobWriter(CLOB paramCLOB, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  73 */     this(paramCLOB, paramInt, paramLong);
/*     */   }
/*     */ 
/*     */   public OracleClobWriter(OracleClob paramOracleClob, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  88 */     if ((paramOracleClob == null) || (paramInt <= 0) || (paramOracleClob.getJavaSqlConnection() == null) || (paramLong < 1L))
/*     */     {
/*  91 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/*  94 */     this.dbConversion = ((PhysicalConnection)paramOracleClob.getInternalConnection()).conversion;
/*     */ 
/*  97 */     this.clob = paramOracleClob;
/*  98 */     this.lobOffset = paramLong;
/*     */ 
/* 100 */     this.charBuf = new char[paramInt];
/* 101 */     this.nativeBuf = new byte[paramInt * 3];
/* 102 */     this.pos = (this.count = 0);
/* 103 */     this.chunkSize = paramInt;
/*     */ 
/* 105 */     this.isClosed = false;
/*     */   }
/*     */ 
/*     */   public void write(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 127 */     synchronized (this.lock)
/*     */     {
/* 129 */       ensureOpen();
/*     */ 
/* 131 */       int i = paramInt1;
/* 132 */       int j = Math.min(paramInt2, paramArrayOfChar.length - paramInt1);
/*     */ 
/* 134 */       if (j >= 2 * this.chunkSize)
/*     */       {
/* 141 */         if (this.count > 0) flushBuffer();
/*     */         try
/*     */         {
/* 144 */           this.lobOffset += this.clob.putChars(this.lobOffset, paramArrayOfChar, paramInt1, j);
/*     */         }
/*     */         catch (SQLException localSQLException)
/*     */         {
/* 149 */           IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 150 */           localIOException.fillInStackTrace();
/* 151 */           throw localIOException;
/*     */         }
/*     */ 
/* 154 */         return;
/*     */       }
/*     */ 
/* 157 */       int k = i + j;
/*     */ 
/* 159 */       while (i < k)
/*     */       {
/* 161 */         int m = Math.min(this.chunkSize - this.count, k - i);
/*     */ 
/* 163 */         System.arraycopy(paramArrayOfChar, i, this.charBuf, this.count, m);
/*     */ 
/* 165 */         i += m;
/* 166 */         this.count += m;
/*     */ 
/* 168 */         if (this.count >= this.chunkSize)
/* 169 */           flushBuffer();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 193 */     synchronized (this.lock)
/*     */     {
/* 195 */       ensureOpen();
/* 196 */       flushBuffer();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 217 */     synchronized (this.lock)
/*     */     {
/* 219 */       flushBuffer();
/*     */ 
/* 221 */       this.isClosed = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void flushBuffer()
/*     */     throws IOException
/*     */   {
/* 233 */     synchronized (this.lock)
/*     */     {
/*     */       try
/*     */       {
/* 237 */         if (this.count > 0)
/*     */         {
/* 239 */           this.lobOffset += this.clob.putChars(this.lobOffset, this.charBuf, 0, this.count);
/* 240 */           this.count = 0;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 246 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 247 */         localIOException.fillInStackTrace();
/* 248 */         throw localIOException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 266 */       if (this.isClosed)
/*     */       {
/* 268 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 269 */         localSQLException1.fillInStackTrace();
/* 270 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 276 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 277 */       localIOException.fillInStackTrace();
/* 278 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/*     */     try
/*     */     {
/* 298 */       return this.clob.getInternalConnection();
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 302 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleClobWriter
 * JD-Core Version:    0.6.2
 */