/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleClob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.CLOB;
/*     */ 
/*     */ class OracleClobReader extends Reader
/*     */ {
/*     */   OracleClob clob;
/*     */   DBConversion dbConversion;
/*     */   long lobOffset;
/*     */   long markedChar;
/*     */   char[] resizableBuffer;
/*     */   int initialBufferSize;
/*     */   int currentBufferSize;
/*     */   int pos;
/*     */   int count;
/*  40 */   long maxPosition = 9223372036854775807L;
/*     */   boolean isClosed;
/*     */   boolean endOfStream;
/* 559 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleClobReader(CLOB paramCLOB)
/*     */     throws SQLException
/*     */   {
/*  52 */     this(paramCLOB);
/*     */   }
/*     */ 
/*     */   public OracleClobReader(OracleClob paramOracleClob)
/*     */     throws SQLException
/*     */   {
/*  62 */     this(paramOracleClob, ((PhysicalConnection)paramOracleClob.getInternalConnection()).getDefaultStreamChunkSize() / 3);
/*     */   }
/*     */ 
/*     */   public OracleClobReader(CLOB paramCLOB, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  77 */     this(paramCLOB, paramInt);
/*     */   }
/*     */ 
/*     */   public OracleClobReader(OracleClob paramOracleClob, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  88 */     this(paramOracleClob, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleClobReader(CLOB paramCLOB, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 102 */     this(paramCLOB, paramInt, paramLong);
/*     */   }
/*     */ 
/*     */   public OracleClobReader(OracleClob paramOracleClob, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 117 */     if ((paramOracleClob == null) || (paramInt <= 0) || (paramOracleClob.getInternalConnection() == null) || (paramLong < 1L))
/*     */     {
/* 120 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/* 123 */     this.dbConversion = ((PhysicalConnection)paramOracleClob.getInternalConnection()).conversion;
/*     */ 
/* 126 */     this.clob = paramOracleClob;
/* 127 */     this.lobOffset = paramLong;
/* 128 */     this.markedChar = -1L;
/*     */ 
/* 130 */     this.resizableBuffer = null;
/* 131 */     this.initialBufferSize = paramInt;
/* 132 */     this.currentBufferSize = 0;
/* 133 */     this.pos = (this.count = 0);
/*     */ 
/* 135 */     this.isClosed = false;
/*     */   }
/*     */ 
/*     */   public OracleClobReader(CLOB paramCLOB, int paramInt, long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 150 */     this(paramCLOB, paramInt, paramLong1, paramLong2);
/*     */   }
/*     */ 
/*     */   public OracleClobReader(OracleClob paramOracleClob, int paramInt, long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 163 */     this(paramOracleClob, paramInt, paramLong1);
/* 164 */     this.maxPosition = (paramLong1 + paramLong2);
/*     */   }
/*     */ 
/*     */   public int read(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 190 */     ensureOpen();
/*     */ 
/* 192 */     int i = paramInt1;
/* 193 */     int j = i + Math.min(paramInt2, paramArrayOfChar.length - paramInt1);
/*     */ 
/* 195 */     if (!needChars(j - i)) {
/* 196 */       return -1;
/*     */     }
/*     */ 
/* 199 */     i += writeChars(paramArrayOfChar, i, j - i);
/*     */ 
/* 201 */     while ((i < j) && (needChars(j - i)))
/*     */     {
/* 203 */       i += writeChars(paramArrayOfChar, i, j - i);
/*     */     }
/*     */ 
/* 206 */     return i - paramInt1;
/*     */   }
/*     */ 
/*     */   protected boolean needChars(int paramInt)
/*     */     throws IOException
/*     */   {
/* 224 */     ensureOpen();
/*     */ 
/* 226 */     if (this.pos >= this.count)
/*     */     {
/* 228 */       if (!this.endOfStream)
/*     */       {
/*     */         try
/*     */         {
/* 232 */           if (paramInt > this.currentBufferSize)
/*     */           {
/* 234 */             this.currentBufferSize = Math.max(paramInt, this.initialBufferSize);
/* 235 */             PhysicalConnection localPhysicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
/*     */ 
/* 237 */             synchronized (localPhysicalConnection) {
/* 238 */               this.resizableBuffer = localPhysicalConnection.getCharBuffer(this.currentBufferSize);
/*     */             }
/*     */           }
/*     */ 
/* 242 */           int i = this.currentBufferSize;
/* 243 */           if (this.maxPosition - this.lobOffset < this.currentBufferSize) i = (int)(this.maxPosition - this.lobOffset);
/*     */ 
/* 245 */           this.count = this.clob.getChars(this.lobOffset, i, this.resizableBuffer);
/*     */ 
/* 248 */           if (this.count < this.currentBufferSize) {
/* 249 */             this.endOfStream = true;
/*     */           }
/* 251 */           if (this.count > 0)
/*     */           {
/* 253 */             this.pos = 0;
/* 254 */             this.lobOffset += this.count;
/* 255 */             if (this.lobOffset >= this.maxPosition) this.endOfStream = true;
/*     */ 
/* 257 */             return true;
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (SQLException localSQLException)
/*     */         {
/* 263 */           ??? = DatabaseError.createIOException(localSQLException);
/* 264 */           ((IOException)???).fillInStackTrace();
/* 265 */           throw ((Throwable)???);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 270 */       return false;
/*     */     }
/*     */ 
/* 273 */     return true;
/*     */   }
/*     */ 
/*     */   protected int writeChars(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*     */   {
/* 288 */     int i = Math.min(paramInt2, this.count - this.pos);
/*     */ 
/* 290 */     System.arraycopy(this.resizableBuffer, this.pos, paramArrayOfChar, paramInt1, i);
/*     */ 
/* 292 */     this.pos += i;
/*     */ 
/* 294 */     return i;
/*     */   }
/*     */ 
/*     */   public boolean ready()
/*     */     throws IOException
/*     */   {
/* 316 */     ensureOpen();
/*     */ 
/* 318 */     return this.pos < this.count;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 337 */     if (this.isClosed) {
/* 338 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 342 */       this.isClosed = true;
/*     */ 
/* 344 */       PhysicalConnection localPhysicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
/* 345 */       synchronized (localPhysicalConnection)
/*     */       {
/* 347 */         if (this.resizableBuffer != null)
/*     */         {
/* 349 */           localPhysicalConnection.cacheBuffer(this.resizableBuffer);
/* 350 */           this.resizableBuffer = null;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 356 */       ??? = DatabaseError.createIOException(localSQLException);
/* 357 */       ((IOException)???).fillInStackTrace();
/* 358 */       throw ((Throwable)???);
/*     */     }
/*     */   }
/*     */ 
/*     */   void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 376 */       if (this.isClosed)
/*     */       {
/* 378 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 379 */         localSQLException1.fillInStackTrace();
/* 380 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 386 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 387 */       localIOException.fillInStackTrace();
/* 388 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 406 */     return true;
/*     */   }
/*     */ 
/*     */   public void mark(int paramInt)
/*     */     throws IOException
/*     */   {
/* 432 */     if (paramInt < 0) {
/* 433 */       throw new IllegalArgumentException(DatabaseError.findMessage(195, null));
/*     */     }
/* 435 */     this.markedChar = (this.lobOffset - this.count + this.pos);
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/* 461 */     ensureOpen();
/*     */ 
/* 463 */     if (this.markedChar < 0L) {
/* 464 */       throw new IOException(DatabaseError.findMessage(195, null));
/*     */     }
/* 466 */     this.lobOffset = this.markedChar;
/* 467 */     this.pos = this.count;
/* 468 */     this.endOfStream = false;
/*     */   }
/*     */ 
/*     */   public long skip(long paramLong)
/*     */     throws IOException
/*     */   {
/* 491 */     ensureOpen();
/*     */ 
/* 493 */     long l1 = 0L;
/*     */ 
/* 495 */     if (this.count - this.pos >= paramLong)
/*     */     {
/* 497 */       this.pos = ((int)(this.pos + paramLong));
/* 498 */       l1 += paramLong;
/*     */     }
/*     */     else
/*     */     {
/* 502 */       l1 += this.count - this.pos;
/* 503 */       this.pos = this.count;
/*     */       try
/*     */       {
/* 507 */         long l2 = this.clob.length() - this.lobOffset + 1L;
/*     */ 
/* 509 */         if (l2 >= paramLong - l1)
/*     */         {
/* 511 */           this.lobOffset += paramLong - l1;
/* 512 */           l1 += paramLong - l1;
/*     */         }
/*     */         else
/*     */         {
/* 516 */           this.lobOffset += l2;
/* 517 */           l1 += l2;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 523 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 524 */         localIOException.fillInStackTrace();
/* 525 */         throw localIOException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 530 */     return l1;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/*     */     try
/*     */     {
/* 548 */       return this.clob.getInternalConnection();
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 552 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleClobReader
 * JD-Core Version:    0.6.2
 */