/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleClob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.CLOB;
/*     */ 
/*     */ class OracleClobOutputStream extends OutputStream
/*     */ {
/*     */   long lobOffset;
/*     */   OracleClob clob;
/*     */   byte[] buf;
/*     */   int count;
/*     */   int bufSize;
/*     */   boolean isClosed;
/* 354 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleClobOutputStream(CLOB paramCLOB, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  46 */     this(paramCLOB, paramInt);
/*     */   }
/*     */ 
/*     */   public OracleClobOutputStream(OracleClob paramOracleClob, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  57 */     this(paramOracleClob, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleClobOutputStream(CLOB paramCLOB, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  71 */     this(paramCLOB, paramInt, paramLong);
/*     */   }
/*     */ 
/*     */   public OracleClobOutputStream(OracleClob paramOracleClob, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  85 */     if ((paramOracleClob == null) || (paramInt <= 0) || (paramLong < 1L))
/*     */     {
/*  87 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/*  90 */     this.clob = paramOracleClob;
/*  91 */     this.lobOffset = paramLong;
/*     */ 
/*  93 */     PhysicalConnection localPhysicalConnection = (PhysicalConnection)paramOracleClob.getInternalConnection();
/*  94 */     synchronized (localPhysicalConnection) {
/*  95 */       this.buf = localPhysicalConnection.getByteBuffer(paramInt);
/*     */     }
/*  97 */     this.count = 0;
/*  98 */     this.bufSize = paramInt;
/*     */ 
/* 100 */     this.isClosed = false;
/*     */   }
/*     */ 
/*     */   public void write(int paramInt)
/*     */     throws IOException
/*     */   {
/* 119 */     ensureOpen();
/*     */ 
/* 121 */     if (this.count >= this.bufSize) {
/* 122 */       flushBuffer();
/*     */     }
/* 124 */     this.buf[(this.count++)] = ((byte)paramInt);
/*     */   }
/*     */ 
/*     */   public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 146 */     ensureOpen();
/*     */ 
/* 148 */     int i = paramInt1;
/* 149 */     int j = Math.min(paramInt2, paramArrayOfByte.length - paramInt1);
/*     */ 
/* 151 */     if (j >= 2 * this.bufSize)
/*     */     {
/* 158 */       if (this.count > 0) flushBuffer();
/*     */       try
/*     */       {
/* 161 */         char[] arrayOfChar = new char[j];
/*     */ 
/* 163 */         for (int m = 0; m < j; m++) {
/* 164 */           arrayOfChar[m] = ((char)paramArrayOfByte[(m + paramInt1)]);
/*     */         }
/* 166 */         this.lobOffset += this.clob.putChars(this.lobOffset, arrayOfChar);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 171 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 172 */         localIOException.fillInStackTrace();
/* 173 */         throw localIOException;
/*     */       }
/*     */ 
/* 176 */       return;
/*     */     }
/*     */ 
/* 179 */     int k = i + j;
/*     */ 
/* 181 */     while (i < k)
/*     */     {
/* 183 */       int n = Math.min(this.bufSize - this.count, k - i);
/*     */ 
/* 185 */       System.arraycopy(paramArrayOfByte, i, this.buf, this.count, n);
/*     */ 
/* 187 */       i += n;
/* 188 */       this.count += n;
/*     */ 
/* 190 */       if (this.count >= this.bufSize)
/* 191 */         flushBuffer();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 213 */     ensureOpen();
/*     */ 
/* 215 */     flushBuffer();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 234 */     if (this.isClosed) {
/* 235 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 239 */       this.isClosed = true;
/* 240 */       flushBuffer();
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/*     */         PhysicalConnection localPhysicalConnection1;
/* 245 */         PhysicalConnection localPhysicalConnection2 = (PhysicalConnection)this.clob.getInternalConnection();
/* 246 */         synchronized (localPhysicalConnection2)
/*     */         {
/* 248 */           if (this.buf != null)
/*     */           {
/* 250 */             localPhysicalConnection2.cacheBuffer(this.buf);
/* 251 */             this.buf = null;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException2)
/*     */       {
/* 257 */         ??? = DatabaseError.createIOException(localSQLException2);
/* 258 */         ((IOException)???).fillInStackTrace();
/* 259 */         throw ((Throwable)???);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void flushBuffer()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 277 */       if (this.count > 0)
/*     */       {
/* 279 */         char[] arrayOfChar = new char[this.count];
/*     */ 
/* 281 */         for (int i = 0; i < this.count; i++) {
/* 282 */           arrayOfChar[i] = ((char)this.buf[i]);
/*     */         }
/* 284 */         this.lobOffset += this.clob.putChars(this.lobOffset, arrayOfChar);
/*     */ 
/* 286 */         this.count = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 292 */       IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 293 */       localIOException.fillInStackTrace();
/* 294 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 311 */       if (this.isClosed)
/*     */       {
/* 313 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 314 */         localSQLException1.fillInStackTrace();
/* 315 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 321 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 322 */       localIOException.fillInStackTrace();
/* 323 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/*     */     try
/*     */     {
/* 343 */       return this.clob.getInternalConnection();
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 347 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleClobOutputStream
 * JD-Core Version:    0.6.2
 */