/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleClob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class OracleClobInputStream extends OracleBufferedStream
/*     */ {
/*     */   protected long lobOffset;
/*     */   protected OracleClob clob;
/*     */   protected long markedByte;
/*     */   protected boolean endOfStream;
/*     */   protected char[] charBuf;
/*     */   protected boolean asciiStrictConversion;
/* 368 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleClobInputStream(OracleClob paramOracleClob, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  38 */     this(paramOracleClob, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleClobInputStream(OracleClob paramOracleClob, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  52 */     super(paramInt);
/*     */ 
/*  55 */     if ((paramOracleClob == null) || (paramInt <= 0) || (paramLong < 1L))
/*     */     {
/*  57 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/*  60 */     this.lobOffset = paramLong;
/*  61 */     this.clob = paramOracleClob;
/*  62 */     this.markedByte = -1L;
/*  63 */     this.endOfStream = false;
/*  64 */     this.asciiStrictConversion = ((PhysicalConnection)paramOracleClob.getInternalConnection()).isStrictAsciiConversion;
/*     */   }
/*     */ 
/*     */   public boolean needBytes(int paramInt)
/*     */     throws IOException
/*     */   {
/*  82 */     ensureOpen();
/*     */ 
/*  84 */     if (this.pos >= this.count)
/*     */     {
/*  86 */       if (!this.endOfStream)
/*     */       {
/*     */         try
/*     */         {
/*  90 */           if ((paramInt > this.currentBufferSize) || (paramInt == 0))
/*     */           {
/*  92 */             this.currentBufferSize = Math.max(paramInt, this.initialBufferSize);
/*  93 */             PhysicalConnection localPhysicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
/*     */ 
/*  95 */             synchronized (localPhysicalConnection) {
/*  96 */               this.resizableBuffer = localPhysicalConnection.getByteBuffer(this.currentBufferSize);
/*  97 */               this.charBuf = localPhysicalConnection.getCharBuffer(this.currentBufferSize);
/*     */             }
/*     */           }
/* 100 */           this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
/*     */ 
/* 103 */           CharacterSet.convertJavaCharsToASCIIBytes(this.charBuf, 0, this.resizableBuffer, 0, this.count, this.asciiStrictConversion);
/*     */ 
/* 105 */           if (this.count < this.currentBufferSize) {
/* 106 */             this.endOfStream = true;
/*     */           }
/* 108 */           if (this.count > 0)
/*     */           {
/* 110 */             this.pos = 0;
/* 111 */             this.lobOffset += this.count;
/*     */ 
/* 113 */             return true;
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (SQLException localSQLException)
/*     */         {
/* 119 */           ??? = DatabaseError.createIOException(localSQLException);
/* 120 */           ((IOException)???).fillInStackTrace();
/* 121 */           throw ((Throwable)???);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 126 */       return false;
/*     */     }
/*     */ 
/* 129 */     return true;
/*     */   }
/*     */ 
/*     */   protected void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 144 */       if (this.closed)
/*     */       {
/* 146 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 147 */         localSQLException1.fillInStackTrace();
/* 148 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 154 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 155 */       localIOException.fillInStackTrace();
/* 156 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 177 */     return true;
/*     */   }
/*     */ 
/*     */   public void mark(int paramInt)
/*     */   {
/* 200 */     if (paramInt < 0) {
/* 201 */       throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
/*     */     }
/* 203 */     this.markedByte = (this.lobOffset - this.count + this.pos);
/*     */   }
/*     */ 
/*     */   public void markInternal(int paramInt)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/* 224 */     ensureOpen();
/*     */ 
/* 226 */     if (this.markedByte < 0L) {
/* 227 */       throw new IOException(DatabaseError.findMessage(195, null));
/*     */     }
/* 229 */     this.lobOffset = this.markedByte;
/* 230 */     this.pos = this.count;
/* 231 */     this.endOfStream = false;
/*     */   }
/*     */ 
/*     */   public long skip(long paramLong)
/*     */     throws IOException
/*     */   {
/* 255 */     ensureOpen();
/*     */ 
/* 257 */     long l1 = 0L;
/*     */ 
/* 259 */     if (this.count - this.pos >= paramLong)
/*     */     {
/* 261 */       this.pos = ((int)(this.pos + paramLong));
/* 262 */       l1 += paramLong;
/*     */     }
/*     */     else
/*     */     {
/* 266 */       l1 += this.count - this.pos;
/* 267 */       this.pos = this.count;
/*     */       try
/*     */       {
/* 271 */         long l2 = 0L;
/*     */ 
/* 273 */         l2 = this.clob.length() - this.lobOffset + 1L;
/*     */ 
/* 275 */         if (l2 >= paramLong - l1)
/*     */         {
/* 277 */           this.lobOffset += paramLong - l1;
/* 278 */           l1 += paramLong - l1;
/*     */         }
/*     */         else
/*     */         {
/* 282 */           this.lobOffset += l2;
/* 283 */           l1 += l2;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 289 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 290 */         localIOException.fillInStackTrace();
/* 291 */         throw localIOException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 296 */     return l1;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 304 */     if (this.closed)
/* 305 */       return;
/*     */     try
/*     */     {
/* 308 */       super.close();
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/*     */         PhysicalConnection localPhysicalConnection1;
/* 313 */         PhysicalConnection localPhysicalConnection2 = (PhysicalConnection)this.clob.getInternalConnection();
/*     */ 
/* 315 */         synchronized (localPhysicalConnection2)
/*     */         {
/* 317 */           if (this.charBuf != null)
/*     */           {
/* 319 */             localPhysicalConnection2.cacheBuffer(this.charBuf);
/* 320 */             this.charBuf = null;
/*     */           }
/* 322 */           if (this.resizableBuffer != null)
/*     */           {
/* 324 */             localPhysicalConnection2.cacheBuffer(this.resizableBuffer);
/* 325 */             this.resizableBuffer = null;
/*     */           }
/* 327 */           this.currentBufferSize = 0;
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException2)
/*     */       {
/* 332 */         ??? = DatabaseError.createIOException(localSQLException2);
/* 333 */         ((IOException)???).fillInStackTrace();
/* 334 */         throw ((Throwable)???);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/*     */     try
/*     */     {
/* 357 */       return this.clob.getInternalConnection();
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 361 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleClobInputStream
 * JD-Core Version:    0.6.2
 */