/*       */ package oracle.jdbc.driver;
/*       */ 
/*       */ import java.io.InputStream;
/*       */ import java.io.Reader;
/*       */ import java.math.BigDecimal;
/*       */ import java.net.URL;
/*       */ import java.sql.Array;
/*       */ import java.sql.Blob;
/*       */ import java.sql.Clob;
/*       */ import java.sql.Date;
/*       */ import java.sql.NClob;
/*       */ import java.sql.Ref;
/*       */ import java.sql.ResultSet;
/*       */ import java.sql.RowId;
/*       */ import java.sql.SQLException;
/*       */ import java.sql.SQLXML;
/*       */ import java.sql.Time;
/*       */ import java.sql.Timestamp;
/*       */ import java.util.Calendar;
/*       */ import java.util.Map;
/*       */ import oracle.jdbc.OracleDataFactory;
/*       */ import oracle.sql.ANYDATA;
/*       */ import oracle.sql.ARRAY;
/*       */ import oracle.sql.BFILE;
/*       */ import oracle.sql.BINARY_DOUBLE;
/*       */ import oracle.sql.BINARY_FLOAT;
/*       */ import oracle.sql.BLOB;
/*       */ import oracle.sql.CHAR;
/*       */ import oracle.sql.CLOB;
/*       */ import oracle.sql.CustomDatum;
/*       */ import oracle.sql.CustomDatumFactory;
/*       */ import oracle.sql.DATE;
/*       */ import oracle.sql.Datum;
/*       */ import oracle.sql.INTERVALDS;
/*       */ import oracle.sql.INTERVALYM;
/*       */ import oracle.sql.NUMBER;
/*       */ import oracle.sql.OPAQUE;
/*       */ import oracle.sql.ORAData;
/*       */ import oracle.sql.ORADataFactory;
/*       */ import oracle.sql.RAW;
/*       */ import oracle.sql.REF;
/*       */ import oracle.sql.ROWID;
/*       */ import oracle.sql.STRUCT;
/*       */ import oracle.sql.StructDescriptor;
/*       */ import oracle.sql.TIMESTAMP;
/*       */ import oracle.sql.TIMESTAMPLTZ;
/*       */ import oracle.sql.TIMESTAMPTZ;
/*       */ 
/*       */ abstract class OracleCallableStatement extends OraclePreparedStatement
/*       */   implements oracle.jdbc.internal.OracleCallableStatement
/*       */ {
/*    49 */   boolean atLeastOneOrdinalParameter = false;
/*    50 */   boolean atLeastOneNamedParameter = false;
/*       */ 
/*    53 */   String[] namedParameters = new String[8];
/*       */ 
/*    56 */   int parameterCount = 0;
/*       */ 
/*    59 */   final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
/*       */ 
/* 10163 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*       */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*       */   public static final boolean TRACE = false;
/*       */ 
/*       */   OracleCallableStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*    80 */     this(paramPhysicalConnection, paramString, paramInt1, paramInt2, 1003, 1007);
/*       */   }
/*       */ 
/*       */   OracleCallableStatement(PhysicalConnection paramPhysicalConnection, String paramString, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/*    98 */     super(paramPhysicalConnection, paramString, 1, paramInt2, paramInt3, paramInt4);
/*       */ 
/*   101 */     this.statementType = 2;
/*       */   }
/*       */ 
/*       */   void registerOutParameterInternal(int paramInt1, int paramInt2, int paramInt3, int paramInt4, String paramString)
/*       */     throws SQLException
/*       */   {
/*   114 */     ensureOpen();
/*   115 */     int i = paramInt1 - 1;
/*       */     SQLException localSQLException1;
/*   116 */     if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */     {
/*   118 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   119 */       localSQLException1.fillInStackTrace();
/*   120 */       throw localSQLException1;
/*       */     }
/*       */ 
/*   123 */     if (paramInt2 == 0)
/*       */     {
/*   125 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/*   126 */       localSQLException1.fillInStackTrace();
/*   127 */       throw localSQLException1;
/*       */     }
/*   129 */     int j = getInternalType(paramInt2);
/*       */ 
/*   131 */     resetBatch();
/*   132 */     this.currentRowNeedToPrepareBinds = true;
/*       */ 
/*   134 */     if (this.currentRowBindAccessors == null) {
/*   135 */       this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
/*       */     }
/*       */ 
/*   138 */     switch (paramInt2)
/*       */     {
/*       */     case -4:
/*       */     case -3:
/*       */     case -1:
/*       */     case 1:
/*       */     case 12:
/*       */     case 70:
/*   146 */       break;
/*       */     case -16:
/*       */     case -15:
/*       */     case -9:
/*   151 */       this.currentRowFormOfUse[i] = 2;
/*   152 */       break;
/*       */     case 2011:
/*   154 */       paramInt4 = 0;
/*   155 */       this.currentRowFormOfUse[i] = 2;
/*   156 */       break;
/*       */     case 2009:
/*   158 */       paramInt4 = 0;
/*   159 */       paramString = "SYS.XMLTYPE";
/*   160 */       break;
/*       */     case 2002:
/*       */     case 2003:
/*   164 */       if ((paramString == null) || (paramString.length() == 0))
/*       */       {
/*   166 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "empty Object name");
/*   167 */         localSQLException2.fillInStackTrace();
/*   168 */         throw localSQLException2;
/*       */       }
/*       */       break;
/*       */     }
/*       */ 
/*   173 */     paramInt4 = 0;
/*       */ 
/*   177 */     this.currentRowBindAccessors[i] = allocateAccessor(j, paramInt2, i + 1, paramInt4, this.currentRowFormOfUse[i], paramString, true);
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(int paramInt1, int paramInt2, String paramString)
/*       */     throws SQLException
/*       */   {
/*   216 */     if ((paramString == null) || (paramString.length() == 0))
/*       */     {
/*   218 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "empty Object name");
/*   219 */       localSQLException.fillInStackTrace();
/*   220 */       throw localSQLException;
/*       */     }
/*       */ 
/*   226 */     synchronized (this.connection) {
/*   227 */       registerOutParameterInternal(paramInt1, paramInt2, 0, 0, paramString);
/*   228 */       this.atLeastOneOrdinalParameter = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void registerOutParameterBytes(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/*   257 */     synchronized (this.connection)
/*       */     {
/*   264 */       registerOutParameterInternal(paramInt1, paramInt2, paramInt3, paramInt4, null);
/*   265 */       this.atLeastOneOrdinalParameter = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public void registerOutParameterChars(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/*   294 */     synchronized (this.connection)
/*       */     {
/*   301 */       registerOutParameterInternal(paramInt1, paramInt2, paramInt3, paramInt4, null);
/*   302 */       this.atLeastOneOrdinalParameter = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/*   319 */     synchronized (this.connection)
/*       */     {
/*   326 */       registerOutParameterInternal(paramInt1, paramInt2, paramInt3, paramInt4, null);
/*   327 */       this.atLeastOneOrdinalParameter = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*   344 */     synchronized (this.connection)
/*       */     {
/*   351 */       registerOutParameterInternal(paramString, paramInt1, paramInt2, paramInt3, null);
/*   352 */       this.atLeastOneNamedParameter = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void registerOutParameterAtName(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*   369 */     String str = paramString.intern();
/*   370 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*   371 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*   372 */     int j = 1;
/*       */ 
/*   374 */     for (int k = 0; k < i; k++)
/*       */     {
/*   376 */       if (arrayOfString[k] == str)
/*       */       {
/*   378 */         if (j != 0)
/*       */         {
/*   380 */           registerOutParameter(k + 1, paramInt);
/*       */ 
/*   382 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/*   387 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/*   388 */           localSQLException2.fillInStackTrace();
/*   389 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/*   394 */     if (j != 0)
/*       */     {
/*   396 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/*   397 */       localSQLException1.fillInStackTrace();
/*   398 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void registerOutParameterAtName(String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*   413 */     String str = paramString.intern();
/*   414 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*   415 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*   416 */     int j = 1;
/*       */ 
/*   418 */     for (int k = 0; k < i; k++)
/*       */     {
/*   420 */       if (arrayOfString[k] == str)
/*       */       {
/*   422 */         if (j != 0)
/*       */         {
/*   424 */           registerOutParameter(k + 1, paramInt1, paramInt2);
/*       */ 
/*   426 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/*   431 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/*   432 */           localSQLException2.fillInStackTrace();
/*   433 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/*   438 */     if (j != 0)
/*       */     {
/*   440 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/*   441 */       localSQLException1.fillInStackTrace();
/*   442 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void registerOutParameterAtName(String paramString1, int paramInt, String paramString2)
/*       */     throws SQLException
/*       */   {
/*   456 */     String str = paramString1.intern();
/*   457 */     String[] arrayOfString = this.sqlObject.getParameterList();
/*   458 */     int i = Math.min(this.sqlObject.getParameterCount(), arrayOfString.length);
/*   459 */     int j = 1;
/*       */ 
/*   461 */     for (int k = 0; k < i; k++)
/*       */     {
/*   463 */       if (arrayOfString[k] == str)
/*       */       {
/*   465 */         if (j != 0)
/*       */         {
/*   467 */           registerOutParameter(k + 1, paramInt, paramString2);
/*       */ 
/*   469 */           j = 0;
/*       */         }
/*       */         else
/*       */         {
/*   474 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 135);
/*   475 */           localSQLException2.fillInStackTrace();
/*   476 */           throw localSQLException2;
/*       */         }
/*       */       }
/*       */     }
/*       */ 
/*   481 */     if (j != 0)
/*       */     {
/*   483 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/*   484 */       localSQLException1.fillInStackTrace();
/*   485 */       throw localSQLException1;
/*       */     }
/*       */   }
/*       */ 
/*       */   boolean isOracleBatchStyle()
/*       */   {
/*   498 */     return false;
/*       */   }
/*       */ 
/*       */   void resetBatch()
/*       */   {
/*   508 */     this.batch = 1;
/*       */   }
/*       */ 
/*       */   public void setExecuteBatch(int paramInt)
/*       */     throws SQLException
/*       */   {
/*       */   }
/*       */ 
/*       */   public int sendBatch()
/*       */     throws SQLException
/*       */   {
/*   542 */     synchronized (this.connection)
/*       */     {
/*   550 */       return this.validRows;
/*       */     }
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*   574 */     registerOutParameter(paramInt1, paramInt2, 0, -1);
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(int paramInt1, int paramInt2, int paramInt3)
/*       */     throws SQLException
/*       */   {
/*   591 */     registerOutParameter(paramInt1, paramInt2, paramInt3, -1);
/*       */   }
/*       */ 
/*       */   public boolean wasNull()
/*       */     throws SQLException
/*       */   {
/*   604 */     return wasNullValue(0);
/*       */   }
/*       */ 
/*       */   public String getString(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   619 */     if (this.closed)
/*       */     {
/*   621 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   622 */       ((SQLException)localObject).fillInStackTrace();
/*   623 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   626 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   629 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   630 */       ((SQLException)localObject).fillInStackTrace();
/*   631 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   635 */     Object localObject = null;
/*   636 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   641 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   642 */       localSQLException.fillInStackTrace();
/*   643 */       throw localSQLException;
/*       */     }
/*       */ 
/*   646 */     this.lastIndex = paramInt;
/*       */ 
/*   648 */     if (this.streamList != null) {
/*   649 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   652 */     return ((Accessor)localObject).getString(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Datum getOracleObject(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   667 */     if (this.closed)
/*       */     {
/*   669 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   670 */       ((SQLException)localObject).fillInStackTrace();
/*   671 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   674 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   677 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   678 */       ((SQLException)localObject).fillInStackTrace();
/*   679 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   683 */     Object localObject = null;
/*   684 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   689 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   690 */       localSQLException.fillInStackTrace();
/*   691 */       throw localSQLException;
/*       */     }
/*       */ 
/*   694 */     this.lastIndex = paramInt;
/*       */ 
/*   696 */     if (this.streamList != null) {
/*   697 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   700 */     return ((Accessor)localObject).getOracleObject(this.currentRank);
/*       */   }
/*       */ 
/*       */   public ROWID getROWID(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   715 */     if (this.closed)
/*       */     {
/*   717 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   718 */       ((SQLException)localObject).fillInStackTrace();
/*   719 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   722 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   725 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   726 */       ((SQLException)localObject).fillInStackTrace();
/*   727 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   731 */     Object localObject = null;
/*   732 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   737 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   738 */       localSQLException.fillInStackTrace();
/*   739 */       throw localSQLException;
/*       */     }
/*       */ 
/*   742 */     this.lastIndex = paramInt;
/*       */ 
/*   744 */     if (this.streamList != null) {
/*   745 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   748 */     return ((Accessor)localObject).getROWID(this.currentRank);
/*       */   }
/*       */ 
/*       */   public NUMBER getNUMBER(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   763 */     if (this.closed)
/*       */     {
/*   765 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   766 */       ((SQLException)localObject).fillInStackTrace();
/*   767 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   770 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   773 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   774 */       ((SQLException)localObject).fillInStackTrace();
/*   775 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   779 */     Object localObject = null;
/*   780 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   785 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   786 */       localSQLException.fillInStackTrace();
/*   787 */       throw localSQLException;
/*       */     }
/*       */ 
/*   790 */     this.lastIndex = paramInt;
/*       */ 
/*   792 */     if (this.streamList != null) {
/*   793 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   796 */     return ((Accessor)localObject).getNUMBER(this.currentRank);
/*       */   }
/*       */ 
/*       */   public DATE getDATE(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   811 */     if (this.closed)
/*       */     {
/*   813 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   814 */       ((SQLException)localObject).fillInStackTrace();
/*   815 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   818 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   821 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   822 */       ((SQLException)localObject).fillInStackTrace();
/*   823 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   827 */     Object localObject = null;
/*   828 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   833 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   834 */       localSQLException.fillInStackTrace();
/*   835 */       throw localSQLException;
/*       */     }
/*       */ 
/*   838 */     this.lastIndex = paramInt;
/*       */ 
/*   840 */     if (this.streamList != null) {
/*   841 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   844 */     return ((Accessor)localObject).getDATE(this.currentRank);
/*       */   }
/*       */ 
/*       */   public INTERVALYM getINTERVALYM(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   859 */     if (this.closed)
/*       */     {
/*   861 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   862 */       ((SQLException)localObject).fillInStackTrace();
/*   863 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   866 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   869 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   870 */       ((SQLException)localObject).fillInStackTrace();
/*   871 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   875 */     Object localObject = null;
/*   876 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   881 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   882 */       localSQLException.fillInStackTrace();
/*   883 */       throw localSQLException;
/*       */     }
/*       */ 
/*   886 */     this.lastIndex = paramInt;
/*       */ 
/*   888 */     if (this.streamList != null) {
/*   889 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   892 */     return ((Accessor)localObject).getINTERVALYM(this.currentRank);
/*       */   }
/*       */ 
/*       */   public INTERVALDS getINTERVALDS(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   907 */     if (this.closed)
/*       */     {
/*   909 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   910 */       ((SQLException)localObject).fillInStackTrace();
/*   911 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   914 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   917 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   918 */       ((SQLException)localObject).fillInStackTrace();
/*   919 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   923 */     Object localObject = null;
/*   924 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   929 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   930 */       localSQLException.fillInStackTrace();
/*   931 */       throw localSQLException;
/*       */     }
/*       */ 
/*   934 */     this.lastIndex = paramInt;
/*       */ 
/*   936 */     if (this.streamList != null) {
/*   937 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   940 */     return ((Accessor)localObject).getINTERVALDS(this.currentRank);
/*       */   }
/*       */ 
/*       */   public TIMESTAMP getTIMESTAMP(int paramInt)
/*       */     throws SQLException
/*       */   {
/*   955 */     if (this.closed)
/*       */     {
/*   957 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*   958 */       ((SQLException)localObject).fillInStackTrace();
/*   959 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   962 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*   965 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*   966 */       ((SQLException)localObject).fillInStackTrace();
/*   967 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*   971 */     Object localObject = null;
/*   972 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*   977 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*   978 */       localSQLException.fillInStackTrace();
/*   979 */       throw localSQLException;
/*       */     }
/*       */ 
/*   982 */     this.lastIndex = paramInt;
/*       */ 
/*   984 */     if (this.streamList != null) {
/*   985 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*   988 */     return ((Accessor)localObject).getTIMESTAMP(this.currentRank);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1003 */     if (this.closed)
/*       */     {
/*  1005 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1006 */       ((SQLException)localObject).fillInStackTrace();
/*  1007 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1010 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1013 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1014 */       ((SQLException)localObject).fillInStackTrace();
/*  1015 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1019 */     Object localObject = null;
/*  1020 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1025 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1026 */       localSQLException.fillInStackTrace();
/*  1027 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1030 */     this.lastIndex = paramInt;
/*       */ 
/*  1032 */     if (this.streamList != null) {
/*  1033 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1036 */     return ((Accessor)localObject).getTIMESTAMPTZ(this.currentRank);
/*       */   }
/*       */ 
/*       */   public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1051 */     if (this.closed)
/*       */     {
/*  1053 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1054 */       ((SQLException)localObject).fillInStackTrace();
/*  1055 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1058 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1061 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1062 */       ((SQLException)localObject).fillInStackTrace();
/*  1063 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1067 */     Object localObject = null;
/*  1068 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1073 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1074 */       localSQLException.fillInStackTrace();
/*  1075 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1078 */     this.lastIndex = paramInt;
/*       */ 
/*  1080 */     if (this.streamList != null) {
/*  1081 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1084 */     return ((Accessor)localObject).getTIMESTAMPLTZ(this.currentRank);
/*       */   }
/*       */ 
/*       */   public REF getREF(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1099 */     if (this.closed)
/*       */     {
/*  1101 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1102 */       ((SQLException)localObject).fillInStackTrace();
/*  1103 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1106 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1109 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1110 */       ((SQLException)localObject).fillInStackTrace();
/*  1111 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1115 */     Object localObject = null;
/*  1116 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1121 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1122 */       localSQLException.fillInStackTrace();
/*  1123 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1126 */     this.lastIndex = paramInt;
/*       */ 
/*  1128 */     if (this.streamList != null) {
/*  1129 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1132 */     return ((Accessor)localObject).getREF(this.currentRank);
/*       */   }
/*       */ 
/*       */   public ARRAY getARRAY(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1147 */     if (this.closed)
/*       */     {
/*  1149 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1150 */       ((SQLException)localObject).fillInStackTrace();
/*  1151 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1154 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1157 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1158 */       ((SQLException)localObject).fillInStackTrace();
/*  1159 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1163 */     Object localObject = null;
/*  1164 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1169 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1170 */       localSQLException.fillInStackTrace();
/*  1171 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1174 */     this.lastIndex = paramInt;
/*       */ 
/*  1176 */     if (this.streamList != null) {
/*  1177 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1180 */     return ((Accessor)localObject).getARRAY(this.currentRank);
/*       */   }
/*       */ 
/*       */   public STRUCT getSTRUCT(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1195 */     if (this.closed)
/*       */     {
/*  1197 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1198 */       ((SQLException)localObject).fillInStackTrace();
/*  1199 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1202 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1205 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1206 */       ((SQLException)localObject).fillInStackTrace();
/*  1207 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1211 */     Object localObject = null;
/*  1212 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1217 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1218 */       localSQLException.fillInStackTrace();
/*  1219 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1222 */     this.lastIndex = paramInt;
/*       */ 
/*  1224 */     if (this.streamList != null) {
/*  1225 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1228 */     return ((Accessor)localObject).getSTRUCT(this.currentRank);
/*       */   }
/*       */ 
/*       */   public OPAQUE getOPAQUE(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1243 */     if (this.closed)
/*       */     {
/*  1245 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1246 */       ((SQLException)localObject).fillInStackTrace();
/*  1247 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1250 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1253 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1254 */       ((SQLException)localObject).fillInStackTrace();
/*  1255 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1259 */     Object localObject = null;
/*  1260 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1265 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1266 */       localSQLException.fillInStackTrace();
/*  1267 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1270 */     this.lastIndex = paramInt;
/*       */ 
/*  1272 */     if (this.streamList != null) {
/*  1273 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1276 */     return ((Accessor)localObject).getOPAQUE(this.currentRank);
/*       */   }
/*       */ 
/*       */   public CHAR getCHAR(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1291 */     if (this.closed)
/*       */     {
/*  1293 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1294 */       ((SQLException)localObject).fillInStackTrace();
/*  1295 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1298 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1301 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1302 */       ((SQLException)localObject).fillInStackTrace();
/*  1303 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1307 */     Object localObject = null;
/*  1308 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1313 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1314 */       localSQLException.fillInStackTrace();
/*  1315 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1318 */     this.lastIndex = paramInt;
/*       */ 
/*  1320 */     if (this.streamList != null) {
/*  1321 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1324 */     return ((Accessor)localObject).getCHAR(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Reader getCharacterStream(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1340 */     if (this.closed)
/*       */     {
/*  1342 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1343 */       ((SQLException)localObject).fillInStackTrace();
/*  1344 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1347 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1350 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1351 */       ((SQLException)localObject).fillInStackTrace();
/*  1352 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1356 */     Object localObject = null;
/*  1357 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1362 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1363 */       localSQLException.fillInStackTrace();
/*  1364 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1367 */     this.lastIndex = paramInt;
/*       */ 
/*  1369 */     if (this.streamList != null) {
/*  1370 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1373 */     return ((Accessor)localObject).getCharacterStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public RAW getRAW(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1388 */     if (this.closed)
/*       */     {
/*  1390 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1391 */       ((SQLException)localObject).fillInStackTrace();
/*  1392 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1395 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1398 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1399 */       ((SQLException)localObject).fillInStackTrace();
/*  1400 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1404 */     Object localObject = null;
/*  1405 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1410 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1411 */       localSQLException.fillInStackTrace();
/*  1412 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1415 */     this.lastIndex = paramInt;
/*       */ 
/*  1417 */     if (this.streamList != null) {
/*  1418 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1421 */     return ((Accessor)localObject).getRAW(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BLOB getBLOB(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1437 */     if (this.closed)
/*       */     {
/*  1439 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1440 */       ((SQLException)localObject).fillInStackTrace();
/*  1441 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1444 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1447 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1448 */       ((SQLException)localObject).fillInStackTrace();
/*  1449 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1453 */     Object localObject = null;
/*  1454 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1459 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1460 */       localSQLException.fillInStackTrace();
/*  1461 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1464 */     this.lastIndex = paramInt;
/*       */ 
/*  1466 */     if (this.streamList != null) {
/*  1467 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1470 */     return ((Accessor)localObject).getBLOB(this.currentRank);
/*       */   }
/*       */ 
/*       */   public CLOB getCLOB(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1485 */     if (this.closed)
/*       */     {
/*  1487 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1488 */       ((SQLException)localObject).fillInStackTrace();
/*  1489 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1492 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1495 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1496 */       ((SQLException)localObject).fillInStackTrace();
/*  1497 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1501 */     Object localObject = null;
/*  1502 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1507 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1508 */       localSQLException.fillInStackTrace();
/*  1509 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1512 */     this.lastIndex = paramInt;
/*       */ 
/*  1514 */     if (this.streamList != null) {
/*  1515 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1518 */     return ((Accessor)localObject).getCLOB(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BFILE getBFILE(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1533 */     if (this.closed)
/*       */     {
/*  1535 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1536 */       ((SQLException)localObject).fillInStackTrace();
/*  1537 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1540 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1543 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1544 */       ((SQLException)localObject).fillInStackTrace();
/*  1545 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1549 */     Object localObject = null;
/*  1550 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1555 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1556 */       localSQLException.fillInStackTrace();
/*  1557 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1560 */     this.lastIndex = paramInt;
/*       */ 
/*  1562 */     if (this.streamList != null) {
/*  1563 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1566 */     return ((Accessor)localObject).getBFILE(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BFILE getBfile(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1581 */     if (this.closed)
/*       */     {
/*  1583 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1584 */       ((SQLException)localObject).fillInStackTrace();
/*  1585 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1588 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1591 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1592 */       ((SQLException)localObject).fillInStackTrace();
/*  1593 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1597 */     Object localObject = null;
/*  1598 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1603 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1604 */       localSQLException.fillInStackTrace();
/*  1605 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1608 */     this.lastIndex = paramInt;
/*       */ 
/*  1610 */     if (this.streamList != null) {
/*  1611 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1614 */     return ((Accessor)localObject).getBFILE(this.currentRank);
/*       */   }
/*       */ 
/*       */   public boolean getBoolean(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1629 */     if (this.closed)
/*       */     {
/*  1631 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1632 */       ((SQLException)localObject).fillInStackTrace();
/*  1633 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1636 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1639 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1640 */       ((SQLException)localObject).fillInStackTrace();
/*  1641 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1645 */     Object localObject = null;
/*  1646 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1651 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1652 */       localSQLException.fillInStackTrace();
/*  1653 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1656 */     this.lastIndex = paramInt;
/*       */ 
/*  1658 */     if (this.streamList != null) {
/*  1659 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1662 */     return ((Accessor)localObject).getBoolean(this.currentRank);
/*       */   }
/*       */ 
/*       */   public byte getByte(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1677 */     if (this.closed)
/*       */     {
/*  1679 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1680 */       ((SQLException)localObject).fillInStackTrace();
/*  1681 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1684 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1687 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1688 */       ((SQLException)localObject).fillInStackTrace();
/*  1689 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1693 */     Object localObject = null;
/*  1694 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1699 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1700 */       localSQLException.fillInStackTrace();
/*  1701 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1704 */     this.lastIndex = paramInt;
/*       */ 
/*  1706 */     if (this.streamList != null) {
/*  1707 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1710 */     return ((Accessor)localObject).getByte(this.currentRank);
/*       */   }
/*       */ 
/*       */   public short getShort(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1725 */     if (this.closed)
/*       */     {
/*  1727 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1728 */       ((SQLException)localObject).fillInStackTrace();
/*  1729 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1732 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1735 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1736 */       ((SQLException)localObject).fillInStackTrace();
/*  1737 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1741 */     Object localObject = null;
/*  1742 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1747 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1748 */       localSQLException.fillInStackTrace();
/*  1749 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1752 */     this.lastIndex = paramInt;
/*       */ 
/*  1754 */     if (this.streamList != null) {
/*  1755 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1758 */     return ((Accessor)localObject).getShort(this.currentRank);
/*       */   }
/*       */ 
/*       */   public int getInt(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1773 */     if (this.closed)
/*       */     {
/*  1775 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1776 */       ((SQLException)localObject).fillInStackTrace();
/*  1777 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1780 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1783 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1784 */       ((SQLException)localObject).fillInStackTrace();
/*  1785 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1789 */     Object localObject = null;
/*  1790 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1795 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1796 */       localSQLException.fillInStackTrace();
/*  1797 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1800 */     this.lastIndex = paramInt;
/*       */ 
/*  1802 */     if (this.streamList != null) {
/*  1803 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1806 */     return ((Accessor)localObject).getInt(this.currentRank);
/*       */   }
/*       */ 
/*       */   public long getLong(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1821 */     if (this.closed)
/*       */     {
/*  1823 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1824 */       ((SQLException)localObject).fillInStackTrace();
/*  1825 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1828 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1831 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1832 */       ((SQLException)localObject).fillInStackTrace();
/*  1833 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1837 */     Object localObject = null;
/*  1838 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1843 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1844 */       localSQLException.fillInStackTrace();
/*  1845 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1848 */     this.lastIndex = paramInt;
/*       */ 
/*  1850 */     if (this.streamList != null) {
/*  1851 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1854 */     return ((Accessor)localObject).getLong(this.currentRank);
/*       */   }
/*       */ 
/*       */   public float getFloat(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1869 */     if (this.closed)
/*       */     {
/*  1871 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1872 */       ((SQLException)localObject).fillInStackTrace();
/*  1873 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1876 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1879 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1880 */       ((SQLException)localObject).fillInStackTrace();
/*  1881 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1885 */     Object localObject = null;
/*  1886 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1891 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1892 */       localSQLException.fillInStackTrace();
/*  1893 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1896 */     this.lastIndex = paramInt;
/*       */ 
/*  1898 */     if (this.streamList != null) {
/*  1899 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1902 */     return ((Accessor)localObject).getFloat(this.currentRank);
/*       */   }
/*       */ 
/*       */   public double getDouble(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  1917 */     if (this.closed)
/*       */     {
/*  1919 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1920 */       ((SQLException)localObject).fillInStackTrace();
/*  1921 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1924 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1927 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1928 */       ((SQLException)localObject).fillInStackTrace();
/*  1929 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1933 */     Object localObject = null;
/*  1934 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  1939 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1940 */       localSQLException.fillInStackTrace();
/*  1941 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1944 */     this.lastIndex = paramInt;
/*       */ 
/*  1946 */     if (this.streamList != null) {
/*  1947 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  1950 */     return ((Accessor)localObject).getDouble(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  1965 */     if (this.closed)
/*       */     {
/*  1967 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  1968 */       ((SQLException)localObject).fillInStackTrace();
/*  1969 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1972 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  1975 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  1976 */       ((SQLException)localObject).fillInStackTrace();
/*  1977 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  1981 */     Object localObject = null;
/*  1982 */     if ((paramInt1 <= 0) || (paramInt1 > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt1 - 1)]) == null))
/*       */     {
/*  1987 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  1988 */       localSQLException.fillInStackTrace();
/*  1989 */       throw localSQLException;
/*       */     }
/*       */ 
/*  1992 */     this.lastIndex = paramInt1;
/*       */ 
/*  1994 */     if (this.streamList != null) {
/*  1995 */       closeUsedStreams(paramInt1);
/*       */     }
/*       */ 
/*  1998 */     return ((Accessor)localObject).getBigDecimal(this.currentRank);
/*       */   }
/*       */ 
/*       */   public byte[] getBytes(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2013 */     if (this.closed)
/*       */     {
/*  2015 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2016 */       ((SQLException)localObject).fillInStackTrace();
/*  2017 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2020 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2023 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2024 */       ((SQLException)localObject).fillInStackTrace();
/*  2025 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2029 */     Object localObject = null;
/*  2030 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2035 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2036 */       localSQLException.fillInStackTrace();
/*  2037 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2040 */     this.lastIndex = paramInt;
/*       */ 
/*  2042 */     if (this.streamList != null) {
/*  2043 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2046 */     return ((Accessor)localObject).getBytes(this.currentRank);
/*       */   }
/*       */ 
/*       */   public byte[] privateGetBytes(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2056 */     if (this.closed)
/*       */     {
/*  2058 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2059 */       ((SQLException)localObject).fillInStackTrace();
/*  2060 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2063 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2066 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2067 */       ((SQLException)localObject).fillInStackTrace();
/*  2068 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2072 */     Object localObject = null;
/*  2073 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2078 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2079 */       localSQLException.fillInStackTrace();
/*  2080 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2083 */     this.lastIndex = paramInt;
/*       */ 
/*  2085 */     if (this.streamList != null) {
/*  2086 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2089 */     return ((Accessor)localObject).getBytesInternal(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Date getDate(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2104 */     if (this.closed)
/*       */     {
/*  2106 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2107 */       ((SQLException)localObject).fillInStackTrace();
/*  2108 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2111 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2114 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2115 */       ((SQLException)localObject).fillInStackTrace();
/*  2116 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2120 */     Object localObject = null;
/*  2121 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2126 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2127 */       localSQLException.fillInStackTrace();
/*  2128 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2131 */     this.lastIndex = paramInt;
/*       */ 
/*  2133 */     if (this.streamList != null) {
/*  2134 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2137 */     return ((Accessor)localObject).getDate(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Time getTime(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2152 */     if (this.closed)
/*       */     {
/*  2154 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2155 */       ((SQLException)localObject).fillInStackTrace();
/*  2156 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2159 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2162 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2163 */       ((SQLException)localObject).fillInStackTrace();
/*  2164 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2168 */     Object localObject = null;
/*  2169 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2174 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2175 */       localSQLException.fillInStackTrace();
/*  2176 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2179 */     this.lastIndex = paramInt;
/*       */ 
/*  2181 */     if (this.streamList != null) {
/*  2182 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2185 */     return ((Accessor)localObject).getTime(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Timestamp getTimestamp(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2200 */     if (this.closed)
/*       */     {
/*  2202 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2203 */       ((SQLException)localObject).fillInStackTrace();
/*  2204 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2207 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2210 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2211 */       ((SQLException)localObject).fillInStackTrace();
/*  2212 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2216 */     Object localObject = null;
/*  2217 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2222 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2223 */       localSQLException.fillInStackTrace();
/*  2224 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2227 */     this.lastIndex = paramInt;
/*       */ 
/*  2229 */     if (this.streamList != null) {
/*  2230 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2233 */     return ((Accessor)localObject).getTimestamp(this.currentRank);
/*       */   }
/*       */ 
/*       */   public InputStream getAsciiStream(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2248 */     if (this.closed)
/*       */     {
/*  2250 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2251 */       ((SQLException)localObject).fillInStackTrace();
/*  2252 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2255 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2258 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2259 */       ((SQLException)localObject).fillInStackTrace();
/*  2260 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2264 */     Object localObject = null;
/*  2265 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2270 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2271 */       localSQLException.fillInStackTrace();
/*  2272 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2275 */     this.lastIndex = paramInt;
/*       */ 
/*  2277 */     if (this.streamList != null) {
/*  2278 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2281 */     return ((Accessor)localObject).getAsciiStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public InputStream getUnicodeStream(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2296 */     if (this.closed)
/*       */     {
/*  2298 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2299 */       ((SQLException)localObject).fillInStackTrace();
/*  2300 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2303 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2306 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2307 */       ((SQLException)localObject).fillInStackTrace();
/*  2308 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2312 */     Object localObject = null;
/*  2313 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2318 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2319 */       localSQLException.fillInStackTrace();
/*  2320 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2323 */     this.lastIndex = paramInt;
/*       */ 
/*  2325 */     if (this.streamList != null) {
/*  2326 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2329 */     return ((Accessor)localObject).getUnicodeStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public InputStream getBinaryStream(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2344 */     if (this.closed)
/*       */     {
/*  2346 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2347 */       ((SQLException)localObject).fillInStackTrace();
/*  2348 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2351 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2354 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2355 */       ((SQLException)localObject).fillInStackTrace();
/*  2356 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2360 */     Object localObject = null;
/*  2361 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2366 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2367 */       localSQLException.fillInStackTrace();
/*  2368 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2371 */     this.lastIndex = paramInt;
/*       */ 
/*  2373 */     if (this.streamList != null) {
/*  2374 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2377 */     return ((Accessor)localObject).getBinaryStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Object getObject(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2392 */     if (this.closed)
/*       */     {
/*  2394 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2395 */       ((SQLException)localObject).fillInStackTrace();
/*  2396 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2399 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2402 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2403 */       ((SQLException)localObject).fillInStackTrace();
/*  2404 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2408 */     Object localObject = null;
/*  2409 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2414 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2415 */       localSQLException.fillInStackTrace();
/*  2416 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2419 */     this.lastIndex = paramInt;
/*       */ 
/*  2421 */     if (this.streamList != null) {
/*  2422 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2425 */     return ((Accessor)localObject).getObject(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Object getAnyDataEmbeddedObject(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2439 */     Object localObject1 = null;
/*  2440 */     Object localObject2 = getObject(paramInt);
/*  2441 */     if ((localObject2 instanceof ANYDATA))
/*       */     {
/*  2443 */       Datum localDatum = ((ANYDATA)localObject2).accessDatum();
/*  2444 */       if (localDatum != null) localObject1 = localDatum.toJdbc();
/*       */     }
/*  2446 */     return localObject1;
/*       */   }
/*       */ 
/*       */   public Object getCustomDatum(int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*       */     throws SQLException
/*       */   {
/*  2461 */     if (this.closed)
/*       */     {
/*  2463 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2464 */       ((SQLException)localObject).fillInStackTrace();
/*  2465 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2468 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2471 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2472 */       ((SQLException)localObject).fillInStackTrace();
/*  2473 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2477 */     Object localObject = null;
/*  2478 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2483 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2484 */       localSQLException.fillInStackTrace();
/*  2485 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2488 */     this.lastIndex = paramInt;
/*       */ 
/*  2490 */     if (this.streamList != null) {
/*  2491 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2494 */     return ((Accessor)localObject).getCustomDatum(this.currentRank, paramCustomDatumFactory);
/*       */   }
/*       */ 
/*       */   public Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory)
/*       */     throws SQLException
/*       */   {
/*  2508 */     if (this.closed)
/*       */     {
/*  2510 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2511 */       ((SQLException)localObject).fillInStackTrace();
/*  2512 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2515 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2518 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2519 */       ((SQLException)localObject).fillInStackTrace();
/*  2520 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2524 */     Object localObject = null;
/*  2525 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2530 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2531 */       localSQLException.fillInStackTrace();
/*  2532 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2535 */     this.lastIndex = paramInt;
/*       */ 
/*  2537 */     if (this.streamList != null) {
/*  2538 */       closeUsedStreams(paramInt);
/*       */     }
/*  2540 */     return ((Accessor)localObject).getObject(this.currentRank, paramOracleDataFactory);
/*       */   }
/*       */ 
/*       */   public Object getORAData(int paramInt, ORADataFactory paramORADataFactory)
/*       */     throws SQLException
/*       */   {
/*  2555 */     if (this.closed)
/*       */     {
/*  2557 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2558 */       ((SQLException)localObject).fillInStackTrace();
/*  2559 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2562 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2565 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2566 */       ((SQLException)localObject).fillInStackTrace();
/*  2567 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2571 */     Object localObject = null;
/*  2572 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2577 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2578 */       localSQLException.fillInStackTrace();
/*  2579 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2582 */     this.lastIndex = paramInt;
/*       */ 
/*  2584 */     if (this.streamList != null) {
/*  2585 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2588 */     return ((Accessor)localObject).getORAData(this.currentRank, paramORADataFactory);
/*       */   }
/*       */ 
/*       */   public ResultSet getCursor(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2603 */     if (this.closed)
/*       */     {
/*  2605 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2606 */       ((SQLException)localObject).fillInStackTrace();
/*  2607 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2610 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2613 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2614 */       ((SQLException)localObject).fillInStackTrace();
/*  2615 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2619 */     Object localObject = null;
/*  2620 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2625 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2626 */       localSQLException.fillInStackTrace();
/*  2627 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2630 */     this.lastIndex = paramInt;
/*       */ 
/*  2632 */     if (this.streamList != null) {
/*  2633 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2636 */     return ((Accessor)localObject).getCursor(this.currentRank);
/*       */   }
/*       */ 
/*       */   public void clearParameters()
/*       */     throws SQLException
/*       */   {
/*  2643 */     synchronized (this.connection)
/*       */     {
/*  2651 */       super.clearParameters();
/*       */     }
/*       */   }
/*       */ 
/*       */   public Object getObject(int paramInt, Map paramMap)
/*       */     throws SQLException
/*       */   {
/*  2677 */     if (this.closed)
/*       */     {
/*  2679 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2680 */       ((SQLException)localObject).fillInStackTrace();
/*  2681 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2684 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2687 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2688 */       ((SQLException)localObject).fillInStackTrace();
/*  2689 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2693 */     Object localObject = null;
/*  2694 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2699 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2700 */       localSQLException.fillInStackTrace();
/*  2701 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2704 */     this.lastIndex = paramInt;
/*       */ 
/*  2706 */     if (this.streamList != null) {
/*  2707 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2710 */     return ((Accessor)localObject).getObject(this.currentRank, paramMap);
/*       */   }
/*       */ 
/*       */   public Ref getRef(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2725 */     if (this.closed)
/*       */     {
/*  2727 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2728 */       ((SQLException)localObject).fillInStackTrace();
/*  2729 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2732 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2735 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2736 */       ((SQLException)localObject).fillInStackTrace();
/*  2737 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2741 */     Object localObject = null;
/*  2742 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2747 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2748 */       localSQLException.fillInStackTrace();
/*  2749 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2752 */     this.lastIndex = paramInt;
/*       */ 
/*  2754 */     if (this.streamList != null) {
/*  2755 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2758 */     return ((Accessor)localObject).getREF(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Blob getBlob(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2773 */     if (this.closed)
/*       */     {
/*  2775 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2776 */       ((SQLException)localObject).fillInStackTrace();
/*  2777 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2780 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2783 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2784 */       ((SQLException)localObject).fillInStackTrace();
/*  2785 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2789 */     Object localObject = null;
/*  2790 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2795 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2796 */       localSQLException.fillInStackTrace();
/*  2797 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2800 */     this.lastIndex = paramInt;
/*       */ 
/*  2802 */     if (this.streamList != null) {
/*  2803 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2806 */     return ((Accessor)localObject).getBLOB(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Clob getClob(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2821 */     if (this.closed)
/*       */     {
/*  2823 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2824 */       ((SQLException)localObject).fillInStackTrace();
/*  2825 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2828 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2831 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2832 */       ((SQLException)localObject).fillInStackTrace();
/*  2833 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2837 */     Object localObject = null;
/*  2838 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2843 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2844 */       localSQLException.fillInStackTrace();
/*  2845 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2848 */     this.lastIndex = paramInt;
/*       */ 
/*  2850 */     if (this.streamList != null) {
/*  2851 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2854 */     return ((Accessor)localObject).getCLOB(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Array getArray(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2869 */     if (this.closed)
/*       */     {
/*  2871 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2872 */       ((SQLException)localObject).fillInStackTrace();
/*  2873 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2876 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2879 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2880 */       ((SQLException)localObject).fillInStackTrace();
/*  2881 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2885 */     Object localObject = null;
/*  2886 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2891 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2892 */       localSQLException.fillInStackTrace();
/*  2893 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2896 */     this.lastIndex = paramInt;
/*       */ 
/*  2898 */     if (this.streamList != null) {
/*  2899 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2902 */     return ((Accessor)localObject).getARRAY(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BigDecimal getBigDecimal(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  2917 */     if (this.closed)
/*       */     {
/*  2919 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2920 */       ((SQLException)localObject).fillInStackTrace();
/*  2921 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2924 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2927 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2928 */       ((SQLException)localObject).fillInStackTrace();
/*  2929 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2933 */     Object localObject = null;
/*  2934 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2939 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2940 */       localSQLException.fillInStackTrace();
/*  2941 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2944 */     this.lastIndex = paramInt;
/*       */ 
/*  2946 */     if (this.streamList != null) {
/*  2947 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2950 */     return ((Accessor)localObject).getBigDecimal(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Date getDate(int paramInt, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  2965 */     if (this.closed)
/*       */     {
/*  2967 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  2968 */       ((SQLException)localObject).fillInStackTrace();
/*  2969 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2972 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  2975 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  2976 */       ((SQLException)localObject).fillInStackTrace();
/*  2977 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  2981 */     Object localObject = null;
/*  2982 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  2987 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  2988 */       localSQLException.fillInStackTrace();
/*  2989 */       throw localSQLException;
/*       */     }
/*       */ 
/*  2992 */     this.lastIndex = paramInt;
/*       */ 
/*  2994 */     if (this.streamList != null) {
/*  2995 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  2998 */     return ((Accessor)localObject).getDate(this.currentRank, paramCalendar);
/*       */   }
/*       */ 
/*       */   public Time getTime(int paramInt, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  3013 */     if (this.closed)
/*       */     {
/*  3015 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  3016 */       ((SQLException)localObject).fillInStackTrace();
/*  3017 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3020 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  3023 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3024 */       ((SQLException)localObject).fillInStackTrace();
/*  3025 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3029 */     Object localObject = null;
/*  3030 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  3035 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  3036 */       localSQLException.fillInStackTrace();
/*  3037 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3040 */     this.lastIndex = paramInt;
/*       */ 
/*  3042 */     if (this.streamList != null) {
/*  3043 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  3046 */     return ((Accessor)localObject).getTime(this.currentRank, paramCalendar);
/*       */   }
/*       */ 
/*       */   public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  3061 */     if (this.closed)
/*       */     {
/*  3063 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  3064 */       ((SQLException)localObject).fillInStackTrace();
/*  3065 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3068 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  3071 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3072 */       ((SQLException)localObject).fillInStackTrace();
/*  3073 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3077 */     Object localObject = null;
/*  3078 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  3083 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  3084 */       localSQLException.fillInStackTrace();
/*  3085 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3088 */     this.lastIndex = paramInt;
/*       */ 
/*  3090 */     if (this.streamList != null) {
/*  3091 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  3094 */     return ((Accessor)localObject).getTimestamp(this.currentRank, paramCalendar);
/*       */   }
/*       */ 
/*       */   public void addBatch()
/*       */     throws SQLException
/*       */   {
/*  3145 */     if (this.currentRowBindAccessors != null)
/*       */     {
/*  3148 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Stored procedure with out or inout parameters cannot be batched");
/*  3149 */       localSQLException.fillInStackTrace();
/*  3150 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3154 */     super.addBatch();
/*       */   }
/*       */ 
/*       */   protected void alwaysOnClose()
/*       */     throws SQLException
/*       */   {
/*  3164 */     this.sqlObject.resetNamedParameters();
/*       */ 
/*  3167 */     this.namedParameters = new String[8];
/*  3168 */     this.parameterCount = 0;
/*  3169 */     this.atLeastOneOrdinalParameter = false;
/*  3170 */     this.atLeastOneNamedParameter = false;
/*       */ 
/*  3172 */     super.alwaysOnClose();
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  3214 */     registerOutParameterInternal(paramString, paramInt, 0, -1, null);
/*  3215 */     this.atLeastOneNamedParameter = true;
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(String paramString, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  3253 */     registerOutParameterInternal(paramString, paramInt1, paramInt2, -1, null);
/*  3254 */     this.atLeastOneNamedParameter = true;
/*       */   }
/*       */ 
/*       */   public void registerOutParameter(String paramString1, int paramInt, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  3304 */     registerOutParameterInternal(paramString1, paramInt, 0, -1, paramString2);
/*  3305 */     this.atLeastOneNamedParameter = true;
/*       */   }
/*       */ 
/*       */   void registerOutParameterInternal(String paramString1, int paramInt1, int paramInt2, int paramInt3, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  3313 */     int i = addNamedPara(paramString1);
/*  3314 */     registerOutParameterInternal(i, paramInt1, paramInt2, paramInt3, paramString2);
/*       */   }
/*       */ 
/*       */   public URL getURL(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  3344 */     if (this.closed)
/*       */     {
/*  3346 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  3347 */       ((SQLException)localObject).fillInStackTrace();
/*  3348 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3351 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  3354 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3355 */       ((SQLException)localObject).fillInStackTrace();
/*  3356 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3360 */     Object localObject = null;
/*  3361 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  3366 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  3367 */       localSQLException.fillInStackTrace();
/*  3368 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3371 */     this.lastIndex = paramInt;
/*       */ 
/*  3373 */     if (this.streamList != null) {
/*  3374 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  3377 */     return ((Accessor)localObject).getURL(this.currentRank);
/*       */   }
/*       */ 
/*       */   public void setStringForClob(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  3409 */     int i = addNamedPara(paramString1);
/*  3410 */     if ((paramString2 == null) || (paramString2.length() == 0))
/*       */     {
/*  3412 */       setNull(i, 2005);
/*  3413 */       return;
/*       */     }
/*  3415 */     setStringForClob(i, paramString2);
/*       */   }
/*       */ 
/*       */   public void setStringForClob(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  3439 */     if ((paramString == null) || (paramString.length() == 0))
/*       */     {
/*  3441 */       setNull(paramInt, 2005);
/*  3442 */       return;
/*       */     }
/*  3444 */     synchronized (this.connection) {
/*  3445 */       setStringForClobCritical(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBytesForBlob(String paramString, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  3475 */     int i = addNamedPara(paramString);
/*  3476 */     setBytesForBlob(i, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   public void setBytesForBlob(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  3499 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0))
/*       */     {
/*  3501 */       setNull(paramInt, 2004);
/*  3502 */       return;
/*       */     }
/*  3504 */     synchronized (this.connection) {
/*  3505 */       setBytesForBlobCritical(paramInt, paramArrayOfByte);
/*       */     }
/*       */   }
/*       */ 
/*       */   public String getString(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3539 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3542 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3543 */       ((SQLException)localObject).fillInStackTrace();
/*  3544 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3548 */     if (paramString == null)
/*       */     {
/*  3551 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3552 */       ((SQLException)localObject).fillInStackTrace();
/*  3553 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3557 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3560 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3562 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3565 */     i++;
/*       */ 
/*  3567 */     Accessor localAccessor = null;
/*  3568 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  3573 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  3574 */       localSQLException.fillInStackTrace();
/*  3575 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3578 */     this.lastIndex = i;
/*       */ 
/*  3580 */     if (this.streamList != null) {
/*  3581 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  3584 */     return localAccessor.getString(this.currentRank);
/*       */   }
/*       */ 
/*       */   public boolean getBoolean(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3610 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3613 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3614 */       ((SQLException)localObject).fillInStackTrace();
/*  3615 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3619 */     if (paramString == null)
/*       */     {
/*  3622 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3623 */       ((SQLException)localObject).fillInStackTrace();
/*  3624 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3628 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3631 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3633 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3636 */     i++;
/*       */ 
/*  3638 */     Accessor localAccessor = null;
/*  3639 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  3644 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  3645 */       localSQLException.fillInStackTrace();
/*  3646 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3649 */     this.lastIndex = i;
/*       */ 
/*  3651 */     if (this.streamList != null) {
/*  3652 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  3655 */     return localAccessor.getBoolean(this.currentRank);
/*       */   }
/*       */ 
/*       */   public byte getByte(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3681 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3684 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3685 */       ((SQLException)localObject).fillInStackTrace();
/*  3686 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3690 */     if (paramString == null)
/*       */     {
/*  3693 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3694 */       ((SQLException)localObject).fillInStackTrace();
/*  3695 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3699 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3702 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3704 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3707 */     i++;
/*       */ 
/*  3709 */     Accessor localAccessor = null;
/*  3710 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  3715 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  3716 */       localSQLException.fillInStackTrace();
/*  3717 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3720 */     this.lastIndex = i;
/*       */ 
/*  3722 */     if (this.streamList != null) {
/*  3723 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  3726 */     return localAccessor.getByte(this.currentRank);
/*       */   }
/*       */ 
/*       */   public short getShort(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3752 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3755 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3756 */       ((SQLException)localObject).fillInStackTrace();
/*  3757 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3761 */     if (paramString == null)
/*       */     {
/*  3764 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3765 */       ((SQLException)localObject).fillInStackTrace();
/*  3766 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3770 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3773 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3775 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3778 */     i++;
/*       */ 
/*  3780 */     Accessor localAccessor = null;
/*  3781 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  3786 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  3787 */       localSQLException.fillInStackTrace();
/*  3788 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3791 */     this.lastIndex = i;
/*       */ 
/*  3793 */     if (this.streamList != null) {
/*  3794 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  3797 */     return localAccessor.getShort(this.currentRank);
/*       */   }
/*       */ 
/*       */   public int getInt(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3824 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3827 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3828 */       ((SQLException)localObject).fillInStackTrace();
/*  3829 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3833 */     if (paramString == null)
/*       */     {
/*  3836 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3837 */       ((SQLException)localObject).fillInStackTrace();
/*  3838 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3842 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3845 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3847 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3850 */     i++;
/*       */ 
/*  3852 */     Accessor localAccessor = null;
/*  3853 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  3858 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  3859 */       localSQLException.fillInStackTrace();
/*  3860 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3863 */     this.lastIndex = i;
/*       */ 
/*  3865 */     if (this.streamList != null) {
/*  3866 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  3869 */     return localAccessor.getInt(this.currentRank);
/*       */   }
/*       */ 
/*       */   public long getLong(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3896 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3899 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3900 */       ((SQLException)localObject).fillInStackTrace();
/*  3901 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3905 */     if (paramString == null)
/*       */     {
/*  3908 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3909 */       ((SQLException)localObject).fillInStackTrace();
/*  3910 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3914 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3917 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3919 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3922 */     i++;
/*       */ 
/*  3924 */     Accessor localAccessor = null;
/*  3925 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  3930 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  3931 */       localSQLException.fillInStackTrace();
/*  3932 */       throw localSQLException;
/*       */     }
/*       */ 
/*  3935 */     this.lastIndex = i;
/*       */ 
/*  3937 */     if (this.streamList != null) {
/*  3938 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  3941 */     return localAccessor.getLong(this.currentRank);
/*       */   }
/*       */ 
/*       */   public float getFloat(String paramString)
/*       */     throws SQLException
/*       */   {
/*  3967 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  3970 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  3971 */       ((SQLException)localObject).fillInStackTrace();
/*  3972 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3976 */     if (paramString == null)
/*       */     {
/*  3979 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  3980 */       ((SQLException)localObject).fillInStackTrace();
/*  3981 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  3985 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  3988 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  3990 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  3993 */     i++;
/*       */ 
/*  3995 */     Accessor localAccessor = null;
/*  3996 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4001 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4002 */       localSQLException.fillInStackTrace();
/*  4003 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4006 */     this.lastIndex = i;
/*       */ 
/*  4008 */     if (this.streamList != null) {
/*  4009 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4012 */     return localAccessor.getFloat(this.currentRank);
/*       */   }
/*       */ 
/*       */   public double getDouble(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4038 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4041 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4042 */       ((SQLException)localObject).fillInStackTrace();
/*  4043 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4047 */     if (paramString == null)
/*       */     {
/*  4050 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4051 */       ((SQLException)localObject).fillInStackTrace();
/*  4052 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4056 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4059 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4061 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4064 */     i++;
/*       */ 
/*  4066 */     Accessor localAccessor = null;
/*  4067 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4072 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4073 */       localSQLException.fillInStackTrace();
/*  4074 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4077 */     this.lastIndex = i;
/*       */ 
/*  4079 */     if (this.streamList != null) {
/*  4080 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4083 */     return localAccessor.getDouble(this.currentRank);
/*       */   }
/*       */ 
/*       */   public byte[] getBytes(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4110 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4113 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4114 */       ((SQLException)localObject).fillInStackTrace();
/*  4115 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4119 */     if (paramString == null)
/*       */     {
/*  4122 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4123 */       ((SQLException)localObject).fillInStackTrace();
/*  4124 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4128 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4131 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4133 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4136 */     i++;
/*       */ 
/*  4138 */     Accessor localAccessor = null;
/*  4139 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4144 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4145 */       localSQLException.fillInStackTrace();
/*  4146 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4149 */     this.lastIndex = i;
/*       */ 
/*  4151 */     if (this.streamList != null) {
/*  4152 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4155 */     return localAccessor.getBytes(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Date getDate(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4181 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4184 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4185 */       ((SQLException)localObject).fillInStackTrace();
/*  4186 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4190 */     if (paramString == null)
/*       */     {
/*  4193 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4194 */       ((SQLException)localObject).fillInStackTrace();
/*  4195 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4199 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4202 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4204 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4207 */     i++;
/*       */ 
/*  4209 */     Accessor localAccessor = null;
/*  4210 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4215 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4216 */       localSQLException.fillInStackTrace();
/*  4217 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4220 */     this.lastIndex = i;
/*       */ 
/*  4222 */     if (this.streamList != null) {
/*  4223 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4226 */     return localAccessor.getDate(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Time getTime(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4252 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4255 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4256 */       ((SQLException)localObject).fillInStackTrace();
/*  4257 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4261 */     if (paramString == null)
/*       */     {
/*  4264 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4265 */       ((SQLException)localObject).fillInStackTrace();
/*  4266 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4270 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4273 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4275 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4278 */     i++;
/*       */ 
/*  4280 */     Accessor localAccessor = null;
/*  4281 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4286 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4287 */       localSQLException.fillInStackTrace();
/*  4288 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4291 */     this.lastIndex = i;
/*       */ 
/*  4293 */     if (this.streamList != null) {
/*  4294 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4297 */     return localAccessor.getTime(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Timestamp getTimestamp(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4323 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4326 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4327 */       ((SQLException)localObject).fillInStackTrace();
/*  4328 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4332 */     if (paramString == null)
/*       */     {
/*  4335 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4336 */       ((SQLException)localObject).fillInStackTrace();
/*  4337 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4341 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4344 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4346 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4349 */     i++;
/*       */ 
/*  4351 */     Accessor localAccessor = null;
/*  4352 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4357 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4358 */       localSQLException.fillInStackTrace();
/*  4359 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4362 */     this.lastIndex = i;
/*       */ 
/*  4364 */     if (this.streamList != null) {
/*  4365 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4368 */     return localAccessor.getTimestamp(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Object getObject(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4401 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4404 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4405 */       ((SQLException)localObject).fillInStackTrace();
/*  4406 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4410 */     if (paramString == null)
/*       */     {
/*  4413 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4414 */       ((SQLException)localObject).fillInStackTrace();
/*  4415 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4419 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4422 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4424 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4427 */     i++;
/*       */ 
/*  4429 */     Accessor localAccessor = null;
/*  4430 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4435 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4436 */       localSQLException.fillInStackTrace();
/*  4437 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4440 */     this.lastIndex = i;
/*       */ 
/*  4442 */     if (this.streamList != null) {
/*  4443 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4446 */     return localAccessor.getObject(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BigDecimal getBigDecimal(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4473 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4476 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4477 */       ((SQLException)localObject).fillInStackTrace();
/*  4478 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4482 */     if (paramString == null)
/*       */     {
/*  4485 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4486 */       ((SQLException)localObject).fillInStackTrace();
/*  4487 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4491 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4494 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4496 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4499 */     i++;
/*       */ 
/*  4501 */     Accessor localAccessor = null;
/*  4502 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4507 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4508 */       localSQLException.fillInStackTrace();
/*  4509 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4512 */     this.lastIndex = i;
/*       */ 
/*  4514 */     if (this.streamList != null) {
/*  4515 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4518 */     return localAccessor.getBigDecimal(this.currentRank);
/*       */   }
/*       */ 
/*       */   public BigDecimal getBigDecimal(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  4532 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4535 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4536 */       ((SQLException)localObject).fillInStackTrace();
/*  4537 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4541 */     if (paramString == null)
/*       */     {
/*  4544 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4545 */       ((SQLException)localObject).fillInStackTrace();
/*  4546 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4550 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4553 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4555 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4558 */     i++;
/*       */ 
/*  4560 */     Accessor localAccessor = null;
/*  4561 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4566 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4567 */       localSQLException.fillInStackTrace();
/*  4568 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4571 */     this.lastIndex = i;
/*       */ 
/*  4573 */     if (this.streamList != null) {
/*  4574 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4577 */     return localAccessor.getBigDecimal(this.currentRank, paramInt);
/*       */   }
/*       */ 
/*       */   public Object getObject(String paramString, Map paramMap)
/*       */     throws SQLException
/*       */   {
/*  4610 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4613 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4614 */       ((SQLException)localObject).fillInStackTrace();
/*  4615 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4619 */     if (paramString == null)
/*       */     {
/*  4622 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4623 */       ((SQLException)localObject).fillInStackTrace();
/*  4624 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4628 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4631 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4633 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4636 */     i++;
/*       */ 
/*  4638 */     Accessor localAccessor = null;
/*  4639 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4644 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4645 */       localSQLException.fillInStackTrace();
/*  4646 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4649 */     this.lastIndex = i;
/*       */ 
/*  4651 */     if (this.streamList != null) {
/*  4652 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4655 */     return localAccessor.getObject(this.currentRank, paramMap);
/*       */   }
/*       */ 
/*       */   public Ref getRef(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4682 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4685 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4686 */       ((SQLException)localObject).fillInStackTrace();
/*  4687 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4691 */     if (paramString == null)
/*       */     {
/*  4694 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4695 */       ((SQLException)localObject).fillInStackTrace();
/*  4696 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4700 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4703 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4705 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4708 */     i++;
/*       */ 
/*  4710 */     Accessor localAccessor = null;
/*  4711 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4716 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4717 */       localSQLException.fillInStackTrace();
/*  4718 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4721 */     this.lastIndex = i;
/*       */ 
/*  4723 */     if (this.streamList != null) {
/*  4724 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4727 */     return localAccessor.getREF(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Blob getBlob(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4754 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4757 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4758 */       ((SQLException)localObject).fillInStackTrace();
/*  4759 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4763 */     if (paramString == null)
/*       */     {
/*  4766 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4767 */       ((SQLException)localObject).fillInStackTrace();
/*  4768 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4772 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4775 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4777 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4780 */     i++;
/*       */ 
/*  4782 */     Accessor localAccessor = null;
/*  4783 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4788 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4789 */       localSQLException.fillInStackTrace();
/*  4790 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4793 */     this.lastIndex = i;
/*       */ 
/*  4795 */     if (this.streamList != null) {
/*  4796 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4799 */     return localAccessor.getBLOB(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Clob getClob(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4825 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4828 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4829 */       ((SQLException)localObject).fillInStackTrace();
/*  4830 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4834 */     if (paramString == null)
/*       */     {
/*  4837 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4838 */       ((SQLException)localObject).fillInStackTrace();
/*  4839 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4843 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4846 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4848 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4851 */     i++;
/*       */ 
/*  4853 */     Accessor localAccessor = null;
/*  4854 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4859 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4860 */       localSQLException.fillInStackTrace();
/*  4861 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4864 */     this.lastIndex = i;
/*       */ 
/*  4866 */     if (this.streamList != null) {
/*  4867 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4870 */     return localAccessor.getCLOB(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Array getArray(String paramString)
/*       */     throws SQLException
/*       */   {
/*  4897 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4900 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4901 */       ((SQLException)localObject).fillInStackTrace();
/*  4902 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4906 */     if (paramString == null)
/*       */     {
/*  4909 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4910 */       ((SQLException)localObject).fillInStackTrace();
/*  4911 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4915 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4918 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  4920 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  4923 */     i++;
/*       */ 
/*  4925 */     Accessor localAccessor = null;
/*  4926 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  4931 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  4932 */       localSQLException.fillInStackTrace();
/*  4933 */       throw localSQLException;
/*       */     }
/*       */ 
/*  4936 */     this.lastIndex = i;
/*       */ 
/*  4938 */     if (this.streamList != null) {
/*  4939 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  4942 */     return localAccessor.getARRAY(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Date getDate(String paramString, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  4977 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  4980 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  4981 */       ((SQLException)localObject).fillInStackTrace();
/*  4982 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4986 */     if (paramString == null)
/*       */     {
/*  4989 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  4990 */       ((SQLException)localObject).fillInStackTrace();
/*  4991 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  4995 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  4998 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  5000 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  5003 */     i++;
/*       */ 
/*  5005 */     Accessor localAccessor = null;
/*  5006 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  5011 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  5012 */       localSQLException.fillInStackTrace();
/*  5013 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5016 */     this.lastIndex = i;
/*       */ 
/*  5018 */     if (this.streamList != null) {
/*  5019 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  5022 */     return localAccessor.getDate(this.currentRank, paramCalendar);
/*       */   }
/*       */ 
/*       */   public Time getTime(String paramString, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  5057 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  5060 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  5061 */       ((SQLException)localObject).fillInStackTrace();
/*  5062 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5066 */     if (paramString == null)
/*       */     {
/*  5069 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  5070 */       ((SQLException)localObject).fillInStackTrace();
/*  5071 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5075 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  5078 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  5080 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  5083 */     i++;
/*       */ 
/*  5085 */     Accessor localAccessor = null;
/*  5086 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  5091 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  5092 */       localSQLException.fillInStackTrace();
/*  5093 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5096 */     this.lastIndex = i;
/*       */ 
/*  5098 */     if (this.streamList != null) {
/*  5099 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  5102 */     return localAccessor.getTime(this.currentRank, paramCalendar);
/*       */   }
/*       */ 
/*       */   public Timestamp getTimestamp(String paramString, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  5138 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  5141 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  5142 */       ((SQLException)localObject).fillInStackTrace();
/*  5143 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5147 */     if (paramString == null)
/*       */     {
/*  5150 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  5151 */       ((SQLException)localObject).fillInStackTrace();
/*  5152 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5156 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  5159 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  5161 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  5164 */     i++;
/*       */ 
/*  5166 */     Accessor localAccessor = null;
/*  5167 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  5172 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  5173 */       localSQLException.fillInStackTrace();
/*  5174 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5177 */     this.lastIndex = i;
/*       */ 
/*  5179 */     if (this.streamList != null) {
/*  5180 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  5183 */     return localAccessor.getTimestamp(this.currentRank, paramCalendar);
/*       */   }
/*       */ 
/*       */   public URL getURL(String paramString)
/*       */     throws SQLException
/*       */   {
/*  5212 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  5215 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  5216 */       ((SQLException)localObject).fillInStackTrace();
/*  5217 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5221 */     if (paramString == null)
/*       */     {
/*  5224 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  5225 */       ((SQLException)localObject).fillInStackTrace();
/*  5226 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  5230 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  5233 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  5235 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  5238 */     i++;
/*       */ 
/*  5240 */     Accessor localAccessor = null;
/*  5241 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  5246 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  5247 */       localSQLException.fillInStackTrace();
/*  5248 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5251 */     this.lastIndex = i;
/*       */ 
/*  5253 */     if (this.streamList != null) {
/*  5254 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  5257 */     return localAccessor.getURL(this.currentRank);
/*       */   }
/*       */ 
/*       */   /** @deprecated */
/*       */   public InputStream getAsciiStream(String paramString)
/*       */     throws SQLException
/*       */   {
/*  5267 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/*  5268 */     localSQLException.fillInStackTrace();
/*  5269 */     throw localSQLException;
/*       */   }
/*       */ 
/*       */   public void registerIndexTableOutParameter(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*       */     throws SQLException
/*       */   {
/*  5308 */     synchronized (this.connection)
/*       */     {
/*  5316 */       int i = paramInt1 - 1;
/*  5317 */       if ((i < 0) || (paramInt1 > this.numberOfBindPositions))
/*       */       {
/*  5319 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5320 */         localSQLException1.fillInStackTrace();
/*  5321 */         throw localSQLException1;
/*       */       }
/*       */ 
/*  5324 */       int j = getInternalType(paramInt3);
/*       */ 
/*  5326 */       if ((j == 96) || (j == 1))
/*       */       {
/*  5329 */         if ((paramInt4 < 0) || (paramInt4 > this.maxIbtVarcharElementLength))
/*       */         {
/*  5331 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 53);
/*  5332 */           localSQLException2.fillInStackTrace();
/*  5333 */           throw localSQLException2;
/*       */         }
/*  5335 */         if (paramInt4 == 0) {
/*  5336 */           paramInt4 = this.maxIbtVarcharElementLength;
/*       */         }
/*       */       }
/*  5339 */       resetBatch();
/*  5340 */       this.currentRowNeedToPrepareBinds = true;
/*       */ 
/*  5342 */       if (this.currentRowBindAccessors == null) {
/*  5343 */         this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
/*       */       }
/*  5345 */       this.currentRowBindAccessors[i] = allocateIndexTableAccessor(new PlsqlIbtBindInfo(this, null, paramInt2, 0, j, paramInt4), this.currentRowFormOfUse[i]);
/*       */ 
/*  5354 */       this.hasIbtBind = true;
/*       */     }
/*       */   }
/*       */ 
/*       */   Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo paramPlsqlIbtBindInfo, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  5366 */     return new PlsqlIndexTableAccessor(this, paramPlsqlIbtBindInfo, paramShort);
/*       */   }
/*       */ 
/*       */   public Object getPlsqlIndexTable(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5384 */     synchronized (this.connection)
/*       */     {
/*  5392 */       Datum[] arrayOfDatum = getOraclePlsqlIndexTable(paramInt);
/*       */ 
/*  5394 */       Accessor localAccessor = this.outBindAccessors[(paramInt - 1)];
/*       */ 
/*  5396 */       int i = localAccessor.plsqlIndexTableBindInfo().element_internal_type;
/*       */ 
/*  5398 */       Object localObject1 = null;
/*       */ 
/*  5400 */       switch (i)
/*       */       {
/*       */       case 9:
/*  5403 */         localObject1 = new String[arrayOfDatum.length];
/*  5404 */         break;
/*       */       case 6:
/*  5406 */         localObject1 = new BigDecimal[arrayOfDatum.length];
/*  5407 */         break;
/*       */       default:
/*  5410 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid column type");
/*  5411 */         localSQLException.fillInStackTrace();
/*  5412 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5416 */       for (int j = 0; j < localObject1.length; j++) {
/*  5417 */         localObject1[j] = ((arrayOfDatum[j] != null) && (arrayOfDatum[j].getLength() != 0L) ? arrayOfDatum[j].toJdbc() : null);
/*       */       }
/*       */ 
/*  5422 */       return localObject1;
/*       */     }
/*       */   }
/*       */ 
/*       */   public Object getPlsqlIndexTable(int paramInt, Class paramClass)
/*       */     throws SQLException
/*       */   {
/*  5442 */     synchronized (this.connection)
/*       */     {
/*  5449 */       Datum[] arrayOfDatum = getOraclePlsqlIndexTable(paramInt);
/*       */ 
/*  5451 */       if ((paramClass == null) || (!paramClass.isPrimitive()))
/*       */       {
/*  5453 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  5454 */         ((SQLException)localObject1).fillInStackTrace();
/*  5455 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  5458 */       Object localObject1 = paramClass.getName();
/*       */       int i;
/*  5460 */       if (((String)localObject1).equals("byte"))
/*       */       {
/*  5462 */         localObject2 = new byte[arrayOfDatum.length];
/*  5463 */         for (i = 0; i < arrayOfDatum.length; i++)
/*  5464 */           localObject2[i] = (arrayOfDatum[i] != null ? arrayOfDatum[i].byteValue() : 0);
/*  5465 */         return localObject2;
/*       */       }
/*  5467 */       if (((String)localObject1).equals("char"))
/*       */       {
/*  5469 */         localObject2 = new char[arrayOfDatum.length];
/*  5470 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5471 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? (char)arrayOfDatum[i].intValue() : 0);
/*       */         }
/*  5473 */         return localObject2;
/*       */       }
/*  5475 */       if (((String)localObject1).equals("double"))
/*       */       {
/*  5477 */         localObject2 = new double[arrayOfDatum.length];
/*  5478 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5479 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? arrayOfDatum[i].doubleValue() : 0.0D);
/*       */         }
/*  5481 */         return localObject2;
/*       */       }
/*  5483 */       if (((String)localObject1).equals("float"))
/*       */       {
/*  5485 */         localObject2 = new float[arrayOfDatum.length];
/*  5486 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5487 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? arrayOfDatum[i].floatValue() : 0.0F);
/*       */         }
/*  5489 */         return localObject2;
/*       */       }
/*  5491 */       if (((String)localObject1).equals("int"))
/*       */       {
/*  5493 */         localObject2 = new int[arrayOfDatum.length];
/*  5494 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5495 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? arrayOfDatum[i].intValue() : 0);
/*       */         }
/*  5497 */         return localObject2;
/*       */       }
/*  5499 */       if (((String)localObject1).equals("long"))
/*       */       {
/*  5501 */         localObject2 = new long[arrayOfDatum.length];
/*  5502 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5503 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? arrayOfDatum[i].longValue() : 0L);
/*       */         }
/*  5505 */         return localObject2;
/*       */       }
/*  5507 */       if (((String)localObject1).equals("short"))
/*       */       {
/*  5509 */         localObject2 = new short[arrayOfDatum.length];
/*  5510 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5511 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? (short)arrayOfDatum[i].intValue() : 0);
/*       */         }
/*  5513 */         return localObject2;
/*       */       }
/*  5515 */       if (((String)localObject1).equals("boolean"))
/*       */       {
/*  5517 */         localObject2 = new boolean[arrayOfDatum.length];
/*  5518 */         for (i = 0; i < arrayOfDatum.length; i++) {
/*  5519 */           localObject2[i] = ((arrayOfDatum[i] != null) && (arrayOfDatum[i].getLength() != 0L) ? arrayOfDatum[i].booleanValue() : 0);
/*       */         }
/*  5521 */         return localObject2;
/*       */       }
/*       */ 
/*  5525 */       Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/*  5526 */       ((SQLException)localObject2).fillInStackTrace();
/*  5527 */       throw ((Throwable)localObject2);
/*       */     }
/*       */   }
/*       */ 
/*       */   public Datum[] getOraclePlsqlIndexTable(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  5545 */     synchronized (this.connection)
/*       */     {
/*  5554 */       if (this.closed)
/*       */       {
/*  5556 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5557 */         ((SQLException)localObject1).fillInStackTrace();
/*  5558 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  5561 */       if (this.atLeastOneNamedParameter)
/*       */       {
/*  5564 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  5565 */         ((SQLException)localObject1).fillInStackTrace();
/*  5566 */         throw ((Throwable)localObject1);
/*       */       }
/*       */ 
/*  5570 */       Object localObject1 = null;
/*  5571 */       if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject1 = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */       {
/*  5576 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  5577 */         localSQLException.fillInStackTrace();
/*  5578 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5581 */       this.lastIndex = paramInt;
/*       */ 
/*  5583 */       if (this.streamList != null) {
/*  5584 */         closeUsedStreams(paramInt);
/*       */       }
/*       */ 
/*  5587 */       return ((Accessor)localObject1).getOraclePlsqlIndexTable(this.currentRank);
/*       */     }
/*       */   }
/*       */ 
/*       */   public boolean execute()
/*       */     throws SQLException
/*       */   {
/*  5607 */     synchronized (this.connection) {
/*  5608 */       ensureOpen();
/*  5609 */       if ((this.atLeastOneNamedParameter) && (this.atLeastOneOrdinalParameter))
/*       */       {
/*  5611 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  5612 */         localSQLException.fillInStackTrace();
/*  5613 */         throw localSQLException;
/*       */       }
/*  5615 */       if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters))
/*  5616 */         this.needToParse = true;
/*  5617 */       return super.execute();
/*       */     }
/*       */   }
/*       */ 
/*       */   public int executeUpdate()
/*       */     throws SQLException
/*       */   {
/*  5631 */     synchronized (this.connection)
/*       */     {
/*  5638 */       ensureOpen();
/*  5639 */       if ((this.atLeastOneNamedParameter) && (this.atLeastOneOrdinalParameter))
/*       */       {
/*  5641 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  5642 */         localSQLException.fillInStackTrace();
/*  5643 */         throw localSQLException;
/*       */       }
/*  5645 */       if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters))
/*  5646 */         this.needToParse = true;
/*  5647 */       return super.executeUpdate();
/*       */     }
/*       */   }
/*       */ 
/*       */   void releaseBuffers()
/*       */   {
/*  5654 */     super.releaseBuffers();
/*       */   }
/*       */ 
/*       */   public void setArray(int paramInt, Array paramArray)
/*       */     throws SQLException
/*       */   {
/*  5673 */     if (this.closed)
/*       */     {
/*  5675 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5676 */       localSQLException.fillInStackTrace();
/*  5677 */       throw localSQLException;
/*       */     }
/*       */ 
/*  5681 */     this.atLeastOneOrdinalParameter = true;
/*  5682 */     setArrayInternal(paramInt, paramArray);
/*       */   }
/*       */ 
/*       */   public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*       */     throws SQLException
/*       */   {
/*  5689 */     synchronized (this.connection)
/*       */     {
/*  5696 */       if (this.closed)
/*       */       {
/*  5698 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5699 */         localSQLException.fillInStackTrace();
/*  5700 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5706 */       this.atLeastOneOrdinalParameter = true;
/*  5707 */       setBigDecimalInternal(paramInt, paramBigDecimal);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBlob(int paramInt, Blob paramBlob)
/*       */     throws SQLException
/*       */   {
/*  5715 */     synchronized (this.connection)
/*       */     {
/*  5722 */       if (this.closed)
/*       */       {
/*  5724 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5725 */         localSQLException.fillInStackTrace();
/*  5726 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5732 */       this.atLeastOneOrdinalParameter = true;
/*  5733 */       setBlobInternal(paramInt, paramBlob);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBoolean(int paramInt, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  5741 */     synchronized (this.connection)
/*       */     {
/*  5748 */       if (this.closed)
/*       */       {
/*  5750 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5751 */         localSQLException.fillInStackTrace();
/*  5752 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5758 */       this.atLeastOneOrdinalParameter = true;
/*  5759 */       setBooleanInternal(paramInt, paramBoolean);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setByte(int paramInt, byte paramByte)
/*       */     throws SQLException
/*       */   {
/*  5767 */     synchronized (this.connection)
/*       */     {
/*  5774 */       if (this.closed)
/*       */       {
/*  5776 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5777 */         localSQLException.fillInStackTrace();
/*  5778 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5784 */       this.atLeastOneOrdinalParameter = true;
/*  5785 */       setByteInternal(paramInt, paramByte);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBytes(int paramInt, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  5793 */     synchronized (this.connection)
/*       */     {
/*  5800 */       if (this.closed)
/*       */       {
/*  5802 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5803 */         localSQLException.fillInStackTrace();
/*  5804 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5810 */       this.atLeastOneOrdinalParameter = true;
/*  5811 */       setBytesInternal(paramInt, paramArrayOfByte);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setClob(int paramInt, Clob paramClob)
/*       */     throws SQLException
/*       */   {
/*  5819 */     synchronized (this.connection)
/*       */     {
/*  5826 */       if (this.closed)
/*       */       {
/*  5828 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5829 */         localSQLException.fillInStackTrace();
/*  5830 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5836 */       this.atLeastOneOrdinalParameter = true;
/*  5837 */       setClobInternal(paramInt, paramClob);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDate(int paramInt, Date paramDate)
/*       */     throws SQLException
/*       */   {
/*  5845 */     synchronized (this.connection)
/*       */     {
/*  5852 */       if (this.closed)
/*       */       {
/*  5854 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5855 */         localSQLException.fillInStackTrace();
/*  5856 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5862 */       this.atLeastOneOrdinalParameter = true;
/*  5863 */       setDateInternal(paramInt, paramDate);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDate(int paramInt, Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  5871 */     synchronized (this.connection)
/*       */     {
/*  5878 */       if (this.closed)
/*       */       {
/*  5880 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5881 */         localSQLException.fillInStackTrace();
/*  5882 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5888 */       this.atLeastOneOrdinalParameter = true;
/*  5889 */       setDateInternal(paramInt, paramDate, paramCalendar);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDouble(int paramInt, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  5897 */     synchronized (this.connection)
/*       */     {
/*  5904 */       if (this.closed)
/*       */       {
/*  5906 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5907 */         localSQLException.fillInStackTrace();
/*  5908 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5914 */       this.atLeastOneOrdinalParameter = true;
/*  5915 */       setDoubleInternal(paramInt, paramDouble);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setFloat(int paramInt, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  5923 */     synchronized (this.connection)
/*       */     {
/*  5930 */       if (this.closed)
/*       */       {
/*  5932 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5933 */         localSQLException.fillInStackTrace();
/*  5934 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5940 */       this.atLeastOneOrdinalParameter = true;
/*  5941 */       setFloatInternal(paramInt, paramFloat);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setInt(int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  5949 */     synchronized (this.connection)
/*       */     {
/*  5956 */       if (this.closed)
/*       */       {
/*  5958 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5959 */         localSQLException.fillInStackTrace();
/*  5960 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5966 */       this.atLeastOneOrdinalParameter = true;
/*  5967 */       setIntInternal(paramInt1, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setLong(int paramInt, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  5975 */     synchronized (this.connection)
/*       */     {
/*  5982 */       if (this.closed)
/*       */       {
/*  5984 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  5985 */         localSQLException.fillInStackTrace();
/*  5986 */         throw localSQLException;
/*       */       }
/*       */ 
/*  5992 */       this.atLeastOneOrdinalParameter = true;
/*  5993 */       setLongInternal(paramInt, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNClob(int paramInt, NClob paramNClob)
/*       */     throws SQLException
/*       */   {
/*  6001 */     synchronized (this.connection)
/*       */     {
/*  6008 */       if (this.closed)
/*       */       {
/*  6010 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6011 */         localSQLException.fillInStackTrace();
/*  6012 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6018 */       this.atLeastOneOrdinalParameter = true;
/*  6019 */       setNClobInternal(paramInt, paramNClob);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNString(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  6027 */     synchronized (this.connection)
/*       */     {
/*  6034 */       if (this.closed)
/*       */       {
/*  6036 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6037 */         localSQLException.fillInStackTrace();
/*  6038 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6044 */       this.atLeastOneOrdinalParameter = true;
/*  6045 */       setNStringInternal(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setObject(int paramInt, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  6059 */     if (this.closed)
/*       */     {
/*  6061 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6062 */       localSQLException.fillInStackTrace();
/*  6063 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6067 */     this.atLeastOneOrdinalParameter = true;
/*  6068 */     setObjectInternal(paramInt, paramObject);
/*       */   }
/*       */ 
/*       */   public void setObject(int paramInt1, Object paramObject, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  6081 */     if (this.closed)
/*       */     {
/*  6083 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6084 */       localSQLException.fillInStackTrace();
/*  6085 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6089 */     this.atLeastOneOrdinalParameter = true;
/*  6090 */     setObjectInternal(paramInt1, paramObject, paramInt2);
/*       */   }
/*       */ 
/*       */   public void setRef(int paramInt, Ref paramRef)
/*       */     throws SQLException
/*       */   {
/*  6103 */     if (this.closed)
/*       */     {
/*  6105 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6106 */       localSQLException.fillInStackTrace();
/*  6107 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6111 */     this.atLeastOneOrdinalParameter = true;
/*  6112 */     setRefInternal(paramInt, paramRef);
/*       */   }
/*       */ 
/*       */   public void setRowId(int paramInt, RowId paramRowId)
/*       */     throws SQLException
/*       */   {
/*  6119 */     synchronized (this.connection)
/*       */     {
/*  6126 */       if (this.closed)
/*       */       {
/*  6128 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6129 */         localSQLException.fillInStackTrace();
/*  6130 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6136 */       this.atLeastOneOrdinalParameter = true;
/*  6137 */       setRowIdInternal(paramInt, paramRowId);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setShort(int paramInt, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  6145 */     synchronized (this.connection)
/*       */     {
/*  6152 */       if (this.closed)
/*       */       {
/*  6154 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6155 */         localSQLException.fillInStackTrace();
/*  6156 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6162 */       this.atLeastOneOrdinalParameter = true;
/*  6163 */       setShortInternal(paramInt, paramShort);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setSQLXML(int paramInt, SQLXML paramSQLXML)
/*       */     throws SQLException
/*       */   {
/*  6171 */     synchronized (this.connection)
/*       */     {
/*  6178 */       if (this.closed)
/*       */       {
/*  6180 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6181 */         localSQLException.fillInStackTrace();
/*  6182 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6188 */       this.atLeastOneOrdinalParameter = true;
/*  6189 */       setSQLXMLInternal(paramInt, paramSQLXML);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setString(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  6197 */     synchronized (this.connection)
/*       */     {
/*  6204 */       if (this.closed)
/*       */       {
/*  6206 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6207 */         localSQLException.fillInStackTrace();
/*  6208 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6214 */       this.atLeastOneOrdinalParameter = true;
/*  6215 */       setStringInternal(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTime(int paramInt, Time paramTime)
/*       */     throws SQLException
/*       */   {
/*  6223 */     synchronized (this.connection)
/*       */     {
/*  6230 */       if (this.closed)
/*       */       {
/*  6232 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6233 */         localSQLException.fillInStackTrace();
/*  6234 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6240 */       this.atLeastOneOrdinalParameter = true;
/*  6241 */       setTimeInternal(paramInt, paramTime);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTime(int paramInt, Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  6249 */     synchronized (this.connection)
/*       */     {
/*  6256 */       if (this.closed)
/*       */       {
/*  6258 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6259 */         localSQLException.fillInStackTrace();
/*  6260 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6266 */       this.atLeastOneOrdinalParameter = true;
/*  6267 */       setTimeInternal(paramInt, paramTime, paramCalendar);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTimestamp(int paramInt, Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/*  6275 */     synchronized (this.connection)
/*       */     {
/*  6282 */       if (this.closed)
/*       */       {
/*  6284 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6285 */         localSQLException.fillInStackTrace();
/*  6286 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6292 */       this.atLeastOneOrdinalParameter = true;
/*  6293 */       setTimestampInternal(paramInt, paramTimestamp);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  6301 */     synchronized (this.connection)
/*       */     {
/*  6308 */       if (this.closed)
/*       */       {
/*  6310 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6311 */         localSQLException.fillInStackTrace();
/*  6312 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6318 */       this.atLeastOneOrdinalParameter = true;
/*  6319 */       setTimestampInternal(paramInt, paramTimestamp, paramCalendar);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setURL(int paramInt, URL paramURL)
/*       */     throws SQLException
/*       */   {
/*  6327 */     synchronized (this.connection)
/*       */     {
/*  6334 */       if (this.closed)
/*       */       {
/*  6336 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6337 */         localSQLException.fillInStackTrace();
/*  6338 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6344 */       this.atLeastOneOrdinalParameter = true;
/*  6345 */       setURLInternal(paramInt, paramURL);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setARRAY(int paramInt, ARRAY paramARRAY)
/*       */     throws SQLException
/*       */   {
/*  6359 */     if (this.closed)
/*       */     {
/*  6361 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6362 */       localSQLException.fillInStackTrace();
/*  6363 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6367 */     this.atLeastOneOrdinalParameter = true;
/*  6368 */     setARRAYInternal(paramInt, paramARRAY);
/*       */   }
/*       */ 
/*       */   public void setBFILE(int paramInt, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  6375 */     synchronized (this.connection)
/*       */     {
/*  6382 */       if (this.closed)
/*       */       {
/*  6384 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6385 */         localSQLException.fillInStackTrace();
/*  6386 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6392 */       this.atLeastOneOrdinalParameter = true;
/*  6393 */       setBFILEInternal(paramInt, paramBFILE);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBfile(int paramInt, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  6401 */     synchronized (this.connection)
/*       */     {
/*  6408 */       if (this.closed)
/*       */       {
/*  6410 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6411 */         localSQLException.fillInStackTrace();
/*  6412 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6418 */       this.atLeastOneOrdinalParameter = true;
/*  6419 */       setBfileInternal(paramInt, paramBFILE);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryFloat(int paramInt, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  6427 */     synchronized (this.connection)
/*       */     {
/*  6434 */       if (this.closed)
/*       */       {
/*  6436 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6437 */         localSQLException.fillInStackTrace();
/*  6438 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6444 */       this.atLeastOneOrdinalParameter = true;
/*  6445 */       setBinaryFloatInternal(paramInt, paramFloat);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryFloat(int paramInt, BINARY_FLOAT paramBINARY_FLOAT)
/*       */     throws SQLException
/*       */   {
/*  6453 */     synchronized (this.connection)
/*       */     {
/*  6460 */       if (this.closed)
/*       */       {
/*  6462 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6463 */         localSQLException.fillInStackTrace();
/*  6464 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6470 */       this.atLeastOneOrdinalParameter = true;
/*  6471 */       setBinaryFloatInternal(paramInt, paramBINARY_FLOAT);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryDouble(int paramInt, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  6479 */     synchronized (this.connection)
/*       */     {
/*  6486 */       if (this.closed)
/*       */       {
/*  6488 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6489 */         localSQLException.fillInStackTrace();
/*  6490 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6496 */       this.atLeastOneOrdinalParameter = true;
/*  6497 */       setBinaryDoubleInternal(paramInt, paramDouble);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryDouble(int paramInt, BINARY_DOUBLE paramBINARY_DOUBLE)
/*       */     throws SQLException
/*       */   {
/*  6505 */     synchronized (this.connection)
/*       */     {
/*  6512 */       if (this.closed)
/*       */       {
/*  6514 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6515 */         localSQLException.fillInStackTrace();
/*  6516 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6522 */       this.atLeastOneOrdinalParameter = true;
/*  6523 */       setBinaryDoubleInternal(paramInt, paramBINARY_DOUBLE);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBLOB(int paramInt, BLOB paramBLOB)
/*       */     throws SQLException
/*       */   {
/*  6531 */     synchronized (this.connection)
/*       */     {
/*  6538 */       if (this.closed)
/*       */       {
/*  6540 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6541 */         localSQLException.fillInStackTrace();
/*  6542 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6548 */       this.atLeastOneOrdinalParameter = true;
/*  6549 */       setBLOBInternal(paramInt, paramBLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCHAR(int paramInt, CHAR paramCHAR)
/*       */     throws SQLException
/*       */   {
/*  6557 */     synchronized (this.connection)
/*       */     {
/*  6564 */       if (this.closed)
/*       */       {
/*  6566 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6567 */         localSQLException.fillInStackTrace();
/*  6568 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6574 */       this.atLeastOneOrdinalParameter = true;
/*  6575 */       setCHARInternal(paramInt, paramCHAR);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCLOB(int paramInt, CLOB paramCLOB)
/*       */     throws SQLException
/*       */   {
/*  6583 */     synchronized (this.connection)
/*       */     {
/*  6590 */       if (this.closed)
/*       */       {
/*  6592 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6593 */         localSQLException.fillInStackTrace();
/*  6594 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6600 */       this.atLeastOneOrdinalParameter = true;
/*  6601 */       setCLOBInternal(paramInt, paramCLOB);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCursor(int paramInt, ResultSet paramResultSet)
/*       */     throws SQLException
/*       */   {
/*  6609 */     synchronized (this.connection)
/*       */     {
/*  6616 */       if (this.closed)
/*       */       {
/*  6618 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6619 */         localSQLException.fillInStackTrace();
/*  6620 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6626 */       this.atLeastOneOrdinalParameter = true;
/*  6627 */       setCursorInternal(paramInt, paramResultSet);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setDATE(int paramInt, DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/*  6635 */     synchronized (this.connection)
/*       */     {
/*  6642 */       if (this.closed)
/*       */       {
/*  6644 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6645 */         localSQLException.fillInStackTrace();
/*  6646 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6652 */       this.atLeastOneOrdinalParameter = true;
/*  6653 */       setDATEInternal(paramInt, paramDATE);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setFixedCHAR(int paramInt, String paramString)
/*       */     throws SQLException
/*       */   {
/*  6661 */     synchronized (this.connection)
/*       */     {
/*  6668 */       if (this.closed)
/*       */       {
/*  6670 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6671 */         localSQLException.fillInStackTrace();
/*  6672 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6678 */       this.atLeastOneOrdinalParameter = true;
/*  6679 */       setFixedCHARInternal(paramInt, paramString);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setINTERVALDS(int paramInt, INTERVALDS paramINTERVALDS)
/*       */     throws SQLException
/*       */   {
/*  6687 */     synchronized (this.connection)
/*       */     {
/*  6694 */       if (this.closed)
/*       */       {
/*  6696 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6697 */         localSQLException.fillInStackTrace();
/*  6698 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6704 */       this.atLeastOneOrdinalParameter = true;
/*  6705 */       setINTERVALDSInternal(paramInt, paramINTERVALDS);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setINTERVALYM(int paramInt, INTERVALYM paramINTERVALYM)
/*       */     throws SQLException
/*       */   {
/*  6713 */     synchronized (this.connection)
/*       */     {
/*  6720 */       if (this.closed)
/*       */       {
/*  6722 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6723 */         localSQLException.fillInStackTrace();
/*  6724 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6730 */       this.atLeastOneOrdinalParameter = true;
/*  6731 */       setINTERVALYMInternal(paramInt, paramINTERVALYM);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNUMBER(int paramInt, NUMBER paramNUMBER)
/*       */     throws SQLException
/*       */   {
/*  6739 */     synchronized (this.connection)
/*       */     {
/*  6746 */       if (this.closed)
/*       */       {
/*  6748 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6749 */         localSQLException.fillInStackTrace();
/*  6750 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6756 */       this.atLeastOneOrdinalParameter = true;
/*  6757 */       setNUMBERInternal(paramInt, paramNUMBER);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setOPAQUE(int paramInt, OPAQUE paramOPAQUE)
/*       */     throws SQLException
/*       */   {
/*  6771 */     if (this.closed)
/*       */     {
/*  6773 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6774 */       localSQLException.fillInStackTrace();
/*  6775 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6779 */     this.atLeastOneOrdinalParameter = true;
/*  6780 */     setOPAQUEInternal(paramInt, paramOPAQUE);
/*       */   }
/*       */ 
/*       */   public void setOracleObject(int paramInt, Datum paramDatum)
/*       */     throws SQLException
/*       */   {
/*  6793 */     if (this.closed)
/*       */     {
/*  6795 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6796 */       localSQLException.fillInStackTrace();
/*  6797 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6801 */     this.atLeastOneOrdinalParameter = true;
/*  6802 */     setOracleObjectInternal(paramInt, paramDatum);
/*       */   }
/*       */ 
/*       */   public void setORAData(int paramInt, ORAData paramORAData)
/*       */     throws SQLException
/*       */   {
/*  6815 */     if (this.closed)
/*       */     {
/*  6817 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6818 */       localSQLException.fillInStackTrace();
/*  6819 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6823 */     this.atLeastOneOrdinalParameter = true;
/*  6824 */     setORADataInternal(paramInt, paramORAData);
/*       */   }
/*       */ 
/*       */   public void setRAW(int paramInt, RAW paramRAW)
/*       */     throws SQLException
/*       */   {
/*  6831 */     synchronized (this.connection)
/*       */     {
/*  6838 */       if (this.closed)
/*       */       {
/*  6840 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6841 */         localSQLException.fillInStackTrace();
/*  6842 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6848 */       this.atLeastOneOrdinalParameter = true;
/*  6849 */       setRAWInternal(paramInt, paramRAW);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setREF(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  6863 */     if (this.closed)
/*       */     {
/*  6865 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6866 */       localSQLException.fillInStackTrace();
/*  6867 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6871 */     this.atLeastOneOrdinalParameter = true;
/*  6872 */     setREFInternal(paramInt, paramREF);
/*       */   }
/*       */ 
/*       */   public void setRefType(int paramInt, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  6885 */     if (this.closed)
/*       */     {
/*  6887 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6888 */       localSQLException.fillInStackTrace();
/*  6889 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6893 */     this.atLeastOneOrdinalParameter = true;
/*  6894 */     setRefTypeInternal(paramInt, paramREF);
/*       */   }
/*       */ 
/*       */   public void setROWID(int paramInt, ROWID paramROWID)
/*       */     throws SQLException
/*       */   {
/*  6901 */     synchronized (this.connection)
/*       */     {
/*  6908 */       if (this.closed)
/*       */       {
/*  6910 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6911 */         localSQLException.fillInStackTrace();
/*  6912 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6918 */       this.atLeastOneOrdinalParameter = true;
/*  6919 */       setROWIDInternal(paramInt, paramROWID);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setSTRUCT(int paramInt, STRUCT paramSTRUCT)
/*       */     throws SQLException
/*       */   {
/*  6933 */     if (this.closed)
/*       */     {
/*  6935 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6936 */       localSQLException.fillInStackTrace();
/*  6937 */       throw localSQLException;
/*       */     }
/*       */ 
/*  6941 */     this.atLeastOneOrdinalParameter = true;
/*  6942 */     setSTRUCTInternal(paramInt, paramSTRUCT);
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPLTZ(int paramInt, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*       */     throws SQLException
/*       */   {
/*  6949 */     synchronized (this.connection)
/*       */     {
/*  6956 */       if (this.closed)
/*       */       {
/*  6958 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6959 */         localSQLException.fillInStackTrace();
/*  6960 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6966 */       this.atLeastOneOrdinalParameter = true;
/*  6967 */       setTIMESTAMPLTZInternal(paramInt, paramTIMESTAMPLTZ);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPTZ(int paramInt, TIMESTAMPTZ paramTIMESTAMPTZ)
/*       */     throws SQLException
/*       */   {
/*  6975 */     synchronized (this.connection)
/*       */     {
/*  6982 */       if (this.closed)
/*       */       {
/*  6984 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  6985 */         localSQLException.fillInStackTrace();
/*  6986 */         throw localSQLException;
/*       */       }
/*       */ 
/*  6992 */       this.atLeastOneOrdinalParameter = true;
/*  6993 */       setTIMESTAMPTZInternal(paramInt, paramTIMESTAMPTZ);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMP(int paramInt, TIMESTAMP paramTIMESTAMP)
/*       */     throws SQLException
/*       */   {
/*  7001 */     synchronized (this.connection)
/*       */     {
/*  7008 */       if (this.closed)
/*       */       {
/*  7010 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7011 */         localSQLException.fillInStackTrace();
/*  7012 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7018 */       this.atLeastOneOrdinalParameter = true;
/*  7019 */       setTIMESTAMPInternal(paramInt, paramTIMESTAMP);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCustomDatum(int paramInt, CustomDatum paramCustomDatum)
/*       */     throws SQLException
/*       */   {
/*  7033 */     if (this.closed)
/*       */     {
/*  7035 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7036 */       localSQLException.fillInStackTrace();
/*  7037 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7041 */     this.atLeastOneOrdinalParameter = true;
/*  7042 */     setCustomDatumInternal(paramInt, paramCustomDatum);
/*       */   }
/*       */ 
/*       */   public void setBlob(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/*  7049 */     synchronized (this.connection)
/*       */     {
/*  7056 */       if (this.closed)
/*       */       {
/*  7058 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7059 */         localSQLException.fillInStackTrace();
/*  7060 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7066 */       this.atLeastOneOrdinalParameter = true;
/*  7067 */       setBlobInternal(paramInt, paramInputStream);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7075 */     synchronized (this.connection)
/*       */     {
/*       */       SQLException localSQLException;
/*  7082 */       if (this.closed)
/*       */       {
/*  7084 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7085 */         localSQLException.fillInStackTrace();
/*  7086 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7091 */       if (paramLong < 0L)
/*       */       {
/*  7093 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
/*  7094 */         localSQLException.fillInStackTrace();
/*  7095 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7098 */       this.atLeastOneOrdinalParameter = true;
/*  7099 */       setBlobInternal(paramInt, paramInputStream, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setClob(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  7107 */     synchronized (this.connection)
/*       */     {
/*  7114 */       if (this.closed)
/*       */       {
/*  7116 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7117 */         localSQLException.fillInStackTrace();
/*  7118 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7124 */       this.atLeastOneOrdinalParameter = true;
/*  7125 */       setClobInternal(paramInt, paramReader);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setClob(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7133 */     synchronized (this.connection)
/*       */     {
/*       */       SQLException localSQLException;
/*  7140 */       if (this.closed)
/*       */       {
/*  7142 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7143 */         localSQLException.fillInStackTrace();
/*  7144 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7150 */       if (paramLong < 0L)
/*       */       {
/*  7152 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
/*  7153 */         localSQLException.fillInStackTrace();
/*  7154 */         throw localSQLException;
/*       */       }
/*  7156 */       this.atLeastOneOrdinalParameter = true;
/*  7157 */       setClobInternal(paramInt, paramReader, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNClob(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  7165 */     synchronized (this.connection)
/*       */     {
/*  7172 */       if (this.closed)
/*       */       {
/*  7174 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7175 */         localSQLException.fillInStackTrace();
/*  7176 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7182 */       this.atLeastOneOrdinalParameter = true;
/*  7183 */       setNClobInternal(paramInt, paramReader);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNClob(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7191 */     synchronized (this.connection)
/*       */     {
/*  7198 */       if (this.closed)
/*       */       {
/*  7200 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7201 */         localSQLException.fillInStackTrace();
/*  7202 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7208 */       this.atLeastOneOrdinalParameter = true;
/*  7209 */       setNClobInternal(paramInt, paramReader, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/*  7217 */     synchronized (this.connection)
/*       */     {
/*  7224 */       if (this.closed)
/*       */       {
/*  7226 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7227 */         localSQLException.fillInStackTrace();
/*  7228 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7234 */       this.atLeastOneOrdinalParameter = true;
/*  7235 */       setAsciiStreamInternal(paramInt, paramInputStream);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7243 */     synchronized (this.connection)
/*       */     {
/*  7250 */       if (this.closed)
/*       */       {
/*  7252 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7253 */         localSQLException.fillInStackTrace();
/*  7254 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7260 */       this.atLeastOneOrdinalParameter = true;
/*  7261 */       setAsciiStreamInternal(paramInt1, paramInputStream, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7269 */     synchronized (this.connection)
/*       */     {
/*  7276 */       if (this.closed)
/*       */       {
/*  7278 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7279 */         localSQLException.fillInStackTrace();
/*  7280 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7286 */       this.atLeastOneOrdinalParameter = true;
/*  7287 */       setAsciiStreamInternal(paramInt, paramInputStream, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(int paramInt, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/*  7295 */     synchronized (this.connection)
/*       */     {
/*  7302 */       if (this.closed)
/*       */       {
/*  7304 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7305 */         localSQLException.fillInStackTrace();
/*  7306 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7312 */       this.atLeastOneOrdinalParameter = true;
/*  7313 */       setBinaryStreamInternal(paramInt, paramInputStream);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7321 */     synchronized (this.connection)
/*       */     {
/*  7328 */       if (this.closed)
/*       */       {
/*  7330 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7331 */         localSQLException.fillInStackTrace();
/*  7332 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7338 */       this.atLeastOneOrdinalParameter = true;
/*  7339 */       setBinaryStreamInternal(paramInt1, paramInputStream, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7347 */     synchronized (this.connection)
/*       */     {
/*  7354 */       if (this.closed)
/*       */       {
/*  7356 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7357 */         localSQLException.fillInStackTrace();
/*  7358 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7364 */       this.atLeastOneOrdinalParameter = true;
/*  7365 */       setBinaryStreamInternal(paramInt, paramInputStream, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  7373 */     synchronized (this.connection)
/*       */     {
/*  7380 */       if (this.closed)
/*       */       {
/*  7382 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7383 */         localSQLException.fillInStackTrace();
/*  7384 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7390 */       this.atLeastOneOrdinalParameter = true;
/*  7391 */       setCharacterStreamInternal(paramInt, paramReader);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7399 */     synchronized (this.connection)
/*       */     {
/*  7406 */       if (this.closed)
/*       */       {
/*  7408 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7409 */         localSQLException.fillInStackTrace();
/*  7410 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7416 */       this.atLeastOneOrdinalParameter = true;
/*  7417 */       setCharacterStreamInternal(paramInt1, paramReader, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7425 */     synchronized (this.connection)
/*       */     {
/*  7432 */       if (this.closed)
/*       */       {
/*  7434 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7435 */         localSQLException.fillInStackTrace();
/*  7436 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7442 */       this.atLeastOneOrdinalParameter = true;
/*  7443 */       setCharacterStreamInternal(paramInt, paramReader, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNCharacterStream(int paramInt, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  7451 */     synchronized (this.connection)
/*       */     {
/*  7458 */       if (this.closed)
/*       */       {
/*  7460 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7461 */         localSQLException.fillInStackTrace();
/*  7462 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7468 */       this.atLeastOneOrdinalParameter = true;
/*  7469 */       setNCharacterStreamInternal(paramInt, paramReader);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7477 */     synchronized (this.connection)
/*       */     {
/*  7484 */       if (this.closed)
/*       */       {
/*  7486 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7487 */         localSQLException.fillInStackTrace();
/*  7488 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7494 */       this.atLeastOneOrdinalParameter = true;
/*  7495 */       setNCharacterStreamInternal(paramInt, paramReader, paramLong);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setUnicodeStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  7503 */     synchronized (this.connection)
/*       */     {
/*  7510 */       if (this.closed)
/*       */       {
/*  7512 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7513 */         localSQLException.fillInStackTrace();
/*  7514 */         throw localSQLException;
/*       */       }
/*       */ 
/*  7520 */       this.atLeastOneOrdinalParameter = true;
/*  7521 */       setUnicodeStreamInternal(paramInt1, paramInputStream, paramInt2);
/*       */     }
/*       */   }
/*       */ 
/*       */   public void setArray(String paramString, Array paramArray)
/*       */     throws SQLException
/*       */   {
/*  7536 */     if (this.closed)
/*       */     {
/*  7538 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7539 */       localSQLException.fillInStackTrace();
/*  7540 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7546 */     int i = addNamedPara(paramString);
/*  7547 */     setArrayInternal(i, paramArray);
/*       */   }
/*       */ 
/*       */   public void setBigDecimal(String paramString, BigDecimal paramBigDecimal)
/*       */     throws SQLException
/*       */   {
/*  7560 */     if (this.closed)
/*       */     {
/*  7562 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7563 */       localSQLException.fillInStackTrace();
/*  7564 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7570 */     int i = addNamedPara(paramString);
/*  7571 */     setBigDecimalInternal(i, paramBigDecimal);
/*       */   }
/*       */ 
/*       */   public void setBlob(String paramString, Blob paramBlob)
/*       */     throws SQLException
/*       */   {
/*  7584 */     if (this.closed)
/*       */     {
/*  7586 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7587 */       localSQLException.fillInStackTrace();
/*  7588 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7594 */     int i = addNamedPara(paramString);
/*  7595 */     setBlobInternal(i, paramBlob);
/*       */   }
/*       */ 
/*       */   public void setBoolean(String paramString, boolean paramBoolean)
/*       */     throws SQLException
/*       */   {
/*  7608 */     if (this.closed)
/*       */     {
/*  7610 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7611 */       localSQLException.fillInStackTrace();
/*  7612 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7618 */     int i = addNamedPara(paramString);
/*  7619 */     setBooleanInternal(i, paramBoolean);
/*       */   }
/*       */ 
/*       */   public void setByte(String paramString, byte paramByte)
/*       */     throws SQLException
/*       */   {
/*  7632 */     if (this.closed)
/*       */     {
/*  7634 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7635 */       localSQLException.fillInStackTrace();
/*  7636 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7642 */     int i = addNamedPara(paramString);
/*  7643 */     setByteInternal(i, paramByte);
/*       */   }
/*       */ 
/*       */   public void setBytes(String paramString, byte[] paramArrayOfByte)
/*       */     throws SQLException
/*       */   {
/*  7656 */     if (this.closed)
/*       */     {
/*  7658 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7659 */       localSQLException.fillInStackTrace();
/*  7660 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7666 */     int i = addNamedPara(paramString);
/*  7667 */     setBytesInternal(i, paramArrayOfByte);
/*       */   }
/*       */ 
/*       */   public void setClob(String paramString, Clob paramClob)
/*       */     throws SQLException
/*       */   {
/*  7680 */     if (this.closed)
/*       */     {
/*  7682 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7683 */       localSQLException.fillInStackTrace();
/*  7684 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7690 */     int i = addNamedPara(paramString);
/*  7691 */     setClobInternal(i, paramClob);
/*       */   }
/*       */ 
/*       */   public void setDate(String paramString, Date paramDate)
/*       */     throws SQLException
/*       */   {
/*  7704 */     if (this.closed)
/*       */     {
/*  7706 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7707 */       localSQLException.fillInStackTrace();
/*  7708 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7714 */     int i = addNamedPara(paramString);
/*  7715 */     setDateInternal(i, paramDate);
/*       */   }
/*       */ 
/*       */   public void setDate(String paramString, Date paramDate, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  7728 */     if (this.closed)
/*       */     {
/*  7730 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7731 */       localSQLException.fillInStackTrace();
/*  7732 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7738 */     int i = addNamedPara(paramString);
/*  7739 */     setDateInternal(i, paramDate, paramCalendar);
/*       */   }
/*       */ 
/*       */   public void setDouble(String paramString, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  7752 */     if (this.closed)
/*       */     {
/*  7754 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7755 */       localSQLException.fillInStackTrace();
/*  7756 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7762 */     int i = addNamedPara(paramString);
/*  7763 */     setDoubleInternal(i, paramDouble);
/*       */   }
/*       */ 
/*       */   public void setFloat(String paramString, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  7776 */     if (this.closed)
/*       */     {
/*  7778 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7779 */       localSQLException.fillInStackTrace();
/*  7780 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7786 */     int i = addNamedPara(paramString);
/*  7787 */     setFloatInternal(i, paramFloat);
/*       */   }
/*       */ 
/*       */   public void setInt(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  7800 */     if (this.closed)
/*       */     {
/*  7802 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7803 */       localSQLException.fillInStackTrace();
/*  7804 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7810 */     int i = addNamedPara(paramString);
/*  7811 */     setIntInternal(i, paramInt);
/*       */   }
/*       */ 
/*       */   public void setLong(String paramString, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  7824 */     if (this.closed)
/*       */     {
/*  7826 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7827 */       localSQLException.fillInStackTrace();
/*  7828 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7834 */     int i = addNamedPara(paramString);
/*  7835 */     setLongInternal(i, paramLong);
/*       */   }
/*       */ 
/*       */   public void setNClob(String paramString, NClob paramNClob)
/*       */     throws SQLException
/*       */   {
/*  7848 */     if (this.closed)
/*       */     {
/*  7850 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7851 */       localSQLException.fillInStackTrace();
/*  7852 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7858 */     int i = addNamedPara(paramString);
/*  7859 */     setNClobInternal(i, paramNClob);
/*       */   }
/*       */ 
/*       */   public void setNString(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  7872 */     if (this.closed)
/*       */     {
/*  7874 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7875 */       localSQLException.fillInStackTrace();
/*  7876 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7882 */     int i = addNamedPara(paramString1);
/*  7883 */     setNStringInternal(i, paramString2);
/*       */   }
/*       */ 
/*       */   public void setObject(String paramString, Object paramObject)
/*       */     throws SQLException
/*       */   {
/*  7896 */     if (this.closed)
/*       */     {
/*  7898 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7899 */       localSQLException.fillInStackTrace();
/*  7900 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7906 */     int i = addNamedPara(paramString);
/*  7907 */     setObjectInternal(i, paramObject);
/*       */   }
/*       */ 
/*       */   public void setObject(String paramString, Object paramObject, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  7920 */     if (this.closed)
/*       */     {
/*  7922 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7923 */       localSQLException.fillInStackTrace();
/*  7924 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7930 */     int i = addNamedPara(paramString);
/*  7931 */     setObjectInternal(i, paramObject, paramInt);
/*       */   }
/*       */ 
/*       */   public void setRef(String paramString, Ref paramRef)
/*       */     throws SQLException
/*       */   {
/*  7944 */     if (this.closed)
/*       */     {
/*  7946 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7947 */       localSQLException.fillInStackTrace();
/*  7948 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7954 */     int i = addNamedPara(paramString);
/*  7955 */     setRefInternal(i, paramRef);
/*       */   }
/*       */ 
/*       */   public void setRowId(String paramString, RowId paramRowId)
/*       */     throws SQLException
/*       */   {
/*  7968 */     if (this.closed)
/*       */     {
/*  7970 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7971 */       localSQLException.fillInStackTrace();
/*  7972 */       throw localSQLException;
/*       */     }
/*       */ 
/*  7978 */     int i = addNamedPara(paramString);
/*  7979 */     setRowIdInternal(i, paramRowId);
/*       */   }
/*       */ 
/*       */   public void setShort(String paramString, short paramShort)
/*       */     throws SQLException
/*       */   {
/*  7992 */     if (this.closed)
/*       */     {
/*  7994 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  7995 */       localSQLException.fillInStackTrace();
/*  7996 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8002 */     int i = addNamedPara(paramString);
/*  8003 */     setShortInternal(i, paramShort);
/*       */   }
/*       */ 
/*       */   public void setSQLXML(String paramString, SQLXML paramSQLXML)
/*       */     throws SQLException
/*       */   {
/*  8016 */     if (this.closed)
/*       */     {
/*  8018 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8019 */       localSQLException.fillInStackTrace();
/*  8020 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8026 */     int i = addNamedPara(paramString);
/*  8027 */     setSQLXMLInternal(i, paramSQLXML);
/*       */   }
/*       */ 
/*       */   public void setString(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  8040 */     if (this.closed)
/*       */     {
/*  8042 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8043 */       localSQLException.fillInStackTrace();
/*  8044 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8050 */     int i = addNamedPara(paramString1);
/*  8051 */     setStringInternal(i, paramString2);
/*       */   }
/*       */ 
/*       */   public void setTime(String paramString, Time paramTime)
/*       */     throws SQLException
/*       */   {
/*  8064 */     if (this.closed)
/*       */     {
/*  8066 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8067 */       localSQLException.fillInStackTrace();
/*  8068 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8074 */     int i = addNamedPara(paramString);
/*  8075 */     setTimeInternal(i, paramTime);
/*       */   }
/*       */ 
/*       */   public void setTime(String paramString, Time paramTime, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  8088 */     if (this.closed)
/*       */     {
/*  8090 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8091 */       localSQLException.fillInStackTrace();
/*  8092 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8098 */     int i = addNamedPara(paramString);
/*  8099 */     setTimeInternal(i, paramTime, paramCalendar);
/*       */   }
/*       */ 
/*       */   public void setTimestamp(String paramString, Timestamp paramTimestamp)
/*       */     throws SQLException
/*       */   {
/*  8112 */     if (this.closed)
/*       */     {
/*  8114 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8115 */       localSQLException.fillInStackTrace();
/*  8116 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8122 */     int i = addNamedPara(paramString);
/*  8123 */     setTimestampInternal(i, paramTimestamp);
/*       */   }
/*       */ 
/*       */   public void setTimestamp(String paramString, Timestamp paramTimestamp, Calendar paramCalendar)
/*       */     throws SQLException
/*       */   {
/*  8136 */     if (this.closed)
/*       */     {
/*  8138 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8139 */       localSQLException.fillInStackTrace();
/*  8140 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8146 */     int i = addNamedPara(paramString);
/*  8147 */     setTimestampInternal(i, paramTimestamp, paramCalendar);
/*       */   }
/*       */ 
/*       */   public void setURL(String paramString, URL paramURL)
/*       */     throws SQLException
/*       */   {
/*  8160 */     if (this.closed)
/*       */     {
/*  8162 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8163 */       localSQLException.fillInStackTrace();
/*  8164 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8170 */     int i = addNamedPara(paramString);
/*  8171 */     setURLInternal(i, paramURL);
/*       */   }
/*       */ 
/*       */   public void setARRAY(String paramString, ARRAY paramARRAY)
/*       */     throws SQLException
/*       */   {
/*  8184 */     if (this.closed)
/*       */     {
/*  8186 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8187 */       localSQLException.fillInStackTrace();
/*  8188 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8194 */     int i = addNamedPara(paramString);
/*  8195 */     setARRAYInternal(i, paramARRAY);
/*       */   }
/*       */ 
/*       */   public void setBFILE(String paramString, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  8208 */     if (this.closed)
/*       */     {
/*  8210 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8211 */       localSQLException.fillInStackTrace();
/*  8212 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8218 */     int i = addNamedPara(paramString);
/*  8219 */     setBFILEInternal(i, paramBFILE);
/*       */   }
/*       */ 
/*       */   public void setBfile(String paramString, BFILE paramBFILE)
/*       */     throws SQLException
/*       */   {
/*  8232 */     if (this.closed)
/*       */     {
/*  8234 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8235 */       localSQLException.fillInStackTrace();
/*  8236 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8242 */     int i = addNamedPara(paramString);
/*  8243 */     setBfileInternal(i, paramBFILE);
/*       */   }
/*       */ 
/*       */   public void setBinaryFloat(String paramString, float paramFloat)
/*       */     throws SQLException
/*       */   {
/*  8256 */     if (this.closed)
/*       */     {
/*  8258 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8259 */       localSQLException.fillInStackTrace();
/*  8260 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8266 */     int i = addNamedPara(paramString);
/*  8267 */     setBinaryFloatInternal(i, paramFloat);
/*       */   }
/*       */ 
/*       */   public void setBinaryFloat(String paramString, BINARY_FLOAT paramBINARY_FLOAT)
/*       */     throws SQLException
/*       */   {
/*  8280 */     if (this.closed)
/*       */     {
/*  8282 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8283 */       localSQLException.fillInStackTrace();
/*  8284 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8290 */     int i = addNamedPara(paramString);
/*  8291 */     setBinaryFloatInternal(i, paramBINARY_FLOAT);
/*       */   }
/*       */ 
/*       */   public void setBinaryDouble(String paramString, double paramDouble)
/*       */     throws SQLException
/*       */   {
/*  8304 */     if (this.closed)
/*       */     {
/*  8306 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8307 */       localSQLException.fillInStackTrace();
/*  8308 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8314 */     int i = addNamedPara(paramString);
/*  8315 */     setBinaryDoubleInternal(i, paramDouble);
/*       */   }
/*       */ 
/*       */   public void setBinaryDouble(String paramString, BINARY_DOUBLE paramBINARY_DOUBLE)
/*       */     throws SQLException
/*       */   {
/*  8328 */     if (this.closed)
/*       */     {
/*  8330 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8331 */       localSQLException.fillInStackTrace();
/*  8332 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8338 */     int i = addNamedPara(paramString);
/*  8339 */     setBinaryDoubleInternal(i, paramBINARY_DOUBLE);
/*       */   }
/*       */ 
/*       */   public void setBLOB(String paramString, BLOB paramBLOB)
/*       */     throws SQLException
/*       */   {
/*  8352 */     if (this.closed)
/*       */     {
/*  8354 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8355 */       localSQLException.fillInStackTrace();
/*  8356 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8362 */     int i = addNamedPara(paramString);
/*  8363 */     setBLOBInternal(i, paramBLOB);
/*       */   }
/*       */ 
/*       */   public void setCHAR(String paramString, CHAR paramCHAR)
/*       */     throws SQLException
/*       */   {
/*  8376 */     if (this.closed)
/*       */     {
/*  8378 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8379 */       localSQLException.fillInStackTrace();
/*  8380 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8386 */     int i = addNamedPara(paramString);
/*  8387 */     setCHARInternal(i, paramCHAR);
/*       */   }
/*       */ 
/*       */   public void setCLOB(String paramString, CLOB paramCLOB)
/*       */     throws SQLException
/*       */   {
/*  8400 */     if (this.closed)
/*       */     {
/*  8402 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8403 */       localSQLException.fillInStackTrace();
/*  8404 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8410 */     int i = addNamedPara(paramString);
/*  8411 */     setCLOBInternal(i, paramCLOB);
/*       */   }
/*       */ 
/*       */   public void setCursor(String paramString, ResultSet paramResultSet)
/*       */     throws SQLException
/*       */   {
/*  8424 */     if (this.closed)
/*       */     {
/*  8426 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8427 */       localSQLException.fillInStackTrace();
/*  8428 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8434 */     int i = addNamedPara(paramString);
/*  8435 */     setCursorInternal(i, paramResultSet);
/*       */   }
/*       */ 
/*       */   public void setDATE(String paramString, DATE paramDATE)
/*       */     throws SQLException
/*       */   {
/*  8448 */     if (this.closed)
/*       */     {
/*  8450 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8451 */       localSQLException.fillInStackTrace();
/*  8452 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8458 */     int i = addNamedPara(paramString);
/*  8459 */     setDATEInternal(i, paramDATE);
/*       */   }
/*       */ 
/*       */   public void setFixedCHAR(String paramString1, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  8472 */     if (this.closed)
/*       */     {
/*  8474 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8475 */       localSQLException.fillInStackTrace();
/*  8476 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8482 */     int i = addNamedPara(paramString1);
/*  8483 */     setFixedCHARInternal(i, paramString2);
/*       */   }
/*       */ 
/*       */   public void setINTERVALDS(String paramString, INTERVALDS paramINTERVALDS)
/*       */     throws SQLException
/*       */   {
/*  8496 */     if (this.closed)
/*       */     {
/*  8498 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8499 */       localSQLException.fillInStackTrace();
/*  8500 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8506 */     int i = addNamedPara(paramString);
/*  8507 */     setINTERVALDSInternal(i, paramINTERVALDS);
/*       */   }
/*       */ 
/*       */   public void setINTERVALYM(String paramString, INTERVALYM paramINTERVALYM)
/*       */     throws SQLException
/*       */   {
/*  8520 */     if (this.closed)
/*       */     {
/*  8522 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8523 */       localSQLException.fillInStackTrace();
/*  8524 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8530 */     int i = addNamedPara(paramString);
/*  8531 */     setINTERVALYMInternal(i, paramINTERVALYM);
/*       */   }
/*       */ 
/*       */   public void setNUMBER(String paramString, NUMBER paramNUMBER)
/*       */     throws SQLException
/*       */   {
/*  8544 */     if (this.closed)
/*       */     {
/*  8546 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8547 */       localSQLException.fillInStackTrace();
/*  8548 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8554 */     int i = addNamedPara(paramString);
/*  8555 */     setNUMBERInternal(i, paramNUMBER);
/*       */   }
/*       */ 
/*       */   public void setOPAQUE(String paramString, OPAQUE paramOPAQUE)
/*       */     throws SQLException
/*       */   {
/*  8568 */     if (this.closed)
/*       */     {
/*  8570 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8571 */       localSQLException.fillInStackTrace();
/*  8572 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8578 */     int i = addNamedPara(paramString);
/*  8579 */     setOPAQUEInternal(i, paramOPAQUE);
/*       */   }
/*       */ 
/*       */   public void setOracleObject(String paramString, Datum paramDatum)
/*       */     throws SQLException
/*       */   {
/*  8592 */     if (this.closed)
/*       */     {
/*  8594 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8595 */       localSQLException.fillInStackTrace();
/*  8596 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8602 */     int i = addNamedPara(paramString);
/*  8603 */     setOracleObjectInternal(i, paramDatum);
/*       */   }
/*       */ 
/*       */   public void setORAData(String paramString, ORAData paramORAData)
/*       */     throws SQLException
/*       */   {
/*  8616 */     if (this.closed)
/*       */     {
/*  8618 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8619 */       localSQLException.fillInStackTrace();
/*  8620 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8626 */     int i = addNamedPara(paramString);
/*  8627 */     setORADataInternal(i, paramORAData);
/*       */   }
/*       */ 
/*       */   public void setRAW(String paramString, RAW paramRAW)
/*       */     throws SQLException
/*       */   {
/*  8640 */     if (this.closed)
/*       */     {
/*  8642 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8643 */       localSQLException.fillInStackTrace();
/*  8644 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8650 */     int i = addNamedPara(paramString);
/*  8651 */     setRAWInternal(i, paramRAW);
/*       */   }
/*       */ 
/*       */   public void setREF(String paramString, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  8664 */     if (this.closed)
/*       */     {
/*  8666 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8667 */       localSQLException.fillInStackTrace();
/*  8668 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8674 */     int i = addNamedPara(paramString);
/*  8675 */     setREFInternal(i, paramREF);
/*       */   }
/*       */ 
/*       */   public void setRefType(String paramString, REF paramREF)
/*       */     throws SQLException
/*       */   {
/*  8688 */     if (this.closed)
/*       */     {
/*  8690 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8691 */       localSQLException.fillInStackTrace();
/*  8692 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8698 */     int i = addNamedPara(paramString);
/*  8699 */     setRefTypeInternal(i, paramREF);
/*       */   }
/*       */ 
/*       */   public void setROWID(String paramString, ROWID paramROWID)
/*       */     throws SQLException
/*       */   {
/*  8712 */     if (this.closed)
/*       */     {
/*  8714 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8715 */       localSQLException.fillInStackTrace();
/*  8716 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8722 */     int i = addNamedPara(paramString);
/*  8723 */     setROWIDInternal(i, paramROWID);
/*       */   }
/*       */ 
/*       */   public void setSTRUCT(String paramString, STRUCT paramSTRUCT)
/*       */     throws SQLException
/*       */   {
/*  8736 */     if (this.closed)
/*       */     {
/*  8738 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8739 */       localSQLException.fillInStackTrace();
/*  8740 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8746 */     int i = addNamedPara(paramString);
/*  8747 */     setSTRUCTInternal(i, paramSTRUCT);
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPLTZ(String paramString, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*       */     throws SQLException
/*       */   {
/*  8760 */     if (this.closed)
/*       */     {
/*  8762 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8763 */       localSQLException.fillInStackTrace();
/*  8764 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8770 */     int i = addNamedPara(paramString);
/*  8771 */     setTIMESTAMPLTZInternal(i, paramTIMESTAMPLTZ);
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMPTZ(String paramString, TIMESTAMPTZ paramTIMESTAMPTZ)
/*       */     throws SQLException
/*       */   {
/*  8784 */     if (this.closed)
/*       */     {
/*  8786 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8787 */       localSQLException.fillInStackTrace();
/*  8788 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8794 */     int i = addNamedPara(paramString);
/*  8795 */     setTIMESTAMPTZInternal(i, paramTIMESTAMPTZ);
/*       */   }
/*       */ 
/*       */   public void setTIMESTAMP(String paramString, TIMESTAMP paramTIMESTAMP)
/*       */     throws SQLException
/*       */   {
/*  8808 */     if (this.closed)
/*       */     {
/*  8810 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8811 */       localSQLException.fillInStackTrace();
/*  8812 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8818 */     int i = addNamedPara(paramString);
/*  8819 */     setTIMESTAMPInternal(i, paramTIMESTAMP);
/*       */   }
/*       */ 
/*       */   public void setCustomDatum(String paramString, CustomDatum paramCustomDatum)
/*       */     throws SQLException
/*       */   {
/*  8832 */     if (this.closed)
/*       */     {
/*  8834 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8835 */       localSQLException.fillInStackTrace();
/*  8836 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8842 */     int i = addNamedPara(paramString);
/*  8843 */     setCustomDatumInternal(i, paramCustomDatum);
/*       */   }
/*       */ 
/*       */   public void setBlob(String paramString, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/*  8856 */     if (this.closed)
/*       */     {
/*  8858 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8859 */       localSQLException.fillInStackTrace();
/*  8860 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8866 */     int i = addNamedPara(paramString);
/*  8867 */     setBlobInternal(i, paramInputStream);
/*       */   }
/*       */ 
/*       */   public void setBlob(String paramString, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/*  8880 */     if (this.closed)
/*       */     {
/*  8882 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8883 */       localSQLException.fillInStackTrace();
/*  8884 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8889 */     if (paramLong < 0L)
/*       */     {
/*  8891 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
/*  8892 */       localSQLException.fillInStackTrace();
/*  8893 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8896 */     int i = addNamedPara(paramString);
/*  8897 */     setBlobInternal(i, paramInputStream, paramLong);
/*       */   }
/*       */ 
/*       */   public void setClob(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  8910 */     if (this.closed)
/*       */     {
/*  8912 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8913 */       localSQLException.fillInStackTrace();
/*  8914 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8920 */     int i = addNamedPara(paramString);
/*  8921 */     setClobInternal(i, paramReader);
/*       */   }
/*       */ 
/*       */   public void setClob(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*       */     SQLException localSQLException;
/*  8934 */     if (this.closed)
/*       */     {
/*  8936 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8937 */       localSQLException.fillInStackTrace();
/*  8938 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8944 */     if (paramLong < 0L)
/*       */     {
/*  8946 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
/*  8947 */       localSQLException.fillInStackTrace();
/*  8948 */       throw localSQLException;
/*       */     }
/*  8950 */     int i = addNamedPara(paramString);
/*  8951 */     setClobInternal(i, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setNClob(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  8964 */     if (this.closed)
/*       */     {
/*  8966 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8967 */       localSQLException.fillInStackTrace();
/*  8968 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8974 */     int i = addNamedPara(paramString);
/*  8975 */     setNClobInternal(i, paramReader);
/*       */   }
/*       */ 
/*       */   public void setNClob(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  8988 */     if (this.closed)
/*       */     {
/*  8990 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  8991 */       localSQLException.fillInStackTrace();
/*  8992 */       throw localSQLException;
/*       */     }
/*       */ 
/*  8998 */     int i = addNamedPara(paramString);
/*  8999 */     setNClobInternal(i, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(String paramString, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/*  9012 */     if (this.closed)
/*       */     {
/*  9014 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9015 */       localSQLException.fillInStackTrace();
/*  9016 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9022 */     int i = addNamedPara(paramString);
/*  9023 */     setAsciiStreamInternal(i, paramInputStream);
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9036 */     if (this.closed)
/*       */     {
/*  9038 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9039 */       localSQLException.fillInStackTrace();
/*  9040 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9046 */     int i = addNamedPara(paramString);
/*  9047 */     setAsciiStreamInternal(i, paramInputStream, paramInt);
/*       */   }
/*       */ 
/*       */   public void setAsciiStream(String paramString, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  9060 */     if (this.closed)
/*       */     {
/*  9062 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9063 */       localSQLException.fillInStackTrace();
/*  9064 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9070 */     int i = addNamedPara(paramString);
/*  9071 */     setAsciiStreamInternal(i, paramInputStream, paramLong);
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(String paramString, InputStream paramInputStream)
/*       */     throws SQLException
/*       */   {
/*  9084 */     if (this.closed)
/*       */     {
/*  9086 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9087 */       localSQLException.fillInStackTrace();
/*  9088 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9094 */     int i = addNamedPara(paramString);
/*  9095 */     setBinaryStreamInternal(i, paramInputStream);
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9108 */     if (this.closed)
/*       */     {
/*  9110 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9111 */       localSQLException.fillInStackTrace();
/*  9112 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9118 */     int i = addNamedPara(paramString);
/*  9119 */     setBinaryStreamInternal(i, paramInputStream, paramInt);
/*       */   }
/*       */ 
/*       */   public void setBinaryStream(String paramString, InputStream paramInputStream, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  9132 */     if (this.closed)
/*       */     {
/*  9134 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9135 */       localSQLException.fillInStackTrace();
/*  9136 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9142 */     int i = addNamedPara(paramString);
/*  9143 */     setBinaryStreamInternal(i, paramInputStream, paramLong);
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  9156 */     if (this.closed)
/*       */     {
/*  9158 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9159 */       localSQLException.fillInStackTrace();
/*  9160 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9166 */     int i = addNamedPara(paramString);
/*  9167 */     setCharacterStreamInternal(i, paramReader);
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(String paramString, Reader paramReader, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9180 */     if (this.closed)
/*       */     {
/*  9182 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9183 */       localSQLException.fillInStackTrace();
/*  9184 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9190 */     int i = addNamedPara(paramString);
/*  9191 */     setCharacterStreamInternal(i, paramReader, paramInt);
/*       */   }
/*       */ 
/*       */   public void setCharacterStream(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  9204 */     if (this.closed)
/*       */     {
/*  9206 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9207 */       localSQLException.fillInStackTrace();
/*  9208 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9214 */     int i = addNamedPara(paramString);
/*  9215 */     setCharacterStreamInternal(i, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setNCharacterStream(String paramString, Reader paramReader)
/*       */     throws SQLException
/*       */   {
/*  9228 */     if (this.closed)
/*       */     {
/*  9230 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9231 */       localSQLException.fillInStackTrace();
/*  9232 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9238 */     int i = addNamedPara(paramString);
/*  9239 */     setNCharacterStreamInternal(i, paramReader);
/*       */   }
/*       */ 
/*       */   public void setNCharacterStream(String paramString, Reader paramReader, long paramLong)
/*       */     throws SQLException
/*       */   {
/*  9252 */     if (this.closed)
/*       */     {
/*  9254 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9255 */       localSQLException.fillInStackTrace();
/*  9256 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9262 */     int i = addNamedPara(paramString);
/*  9263 */     setNCharacterStreamInternal(i, paramReader, paramLong);
/*       */   }
/*       */ 
/*       */   public void setUnicodeStream(String paramString, InputStream paramInputStream, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9276 */     if (this.closed)
/*       */     {
/*  9278 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9279 */       localSQLException.fillInStackTrace();
/*  9280 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9286 */     int i = addNamedPara(paramString);
/*  9287 */     setUnicodeStreamInternal(i, paramInputStream, paramInt);
/*       */   }
/*       */ 
/*       */   public void setNull(String paramString1, int paramInt, String paramString2)
/*       */     throws SQLException
/*       */   {
/*  9301 */     if (this.closed)
/*       */     {
/*  9303 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9304 */       localSQLException.fillInStackTrace();
/*  9305 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9311 */     int i = addNamedPara(paramString1);
/*  9312 */     setNullInternal(i, paramInt, paramString2);
/*       */   }
/*       */ 
/*       */   public void setNull(String paramString, int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9326 */     if (this.closed)
/*       */     {
/*  9328 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9329 */       localSQLException.fillInStackTrace();
/*  9330 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9336 */     int i = addNamedPara(paramString);
/*  9337 */     setNullInternal(i, paramInt);
/*       */   }
/*       */ 
/*       */   public void setStructDescriptor(String paramString, StructDescriptor paramStructDescriptor)
/*       */     throws SQLException
/*       */   {
/*  9351 */     if (this.closed)
/*       */     {
/*  9353 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9354 */       localSQLException.fillInStackTrace();
/*  9355 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9359 */     int i = addNamedPara(paramString);
/*  9360 */     setStructDescriptorInternal(i, paramStructDescriptor);
/*       */   }
/*       */ 
/*       */   public void setObject(String paramString, Object paramObject, int paramInt1, int paramInt2)
/*       */     throws SQLException
/*       */   {
/*  9376 */     if (this.closed)
/*       */     {
/*  9378 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9379 */       localSQLException.fillInStackTrace();
/*  9380 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9384 */     int i = addNamedPara(paramString);
/*  9385 */     setObjectInternal(i, paramObject, paramInt1, paramInt2);
/*       */   }
/*       */ 
/*       */   public void setPlsqlIndexTable(int paramInt1, Object paramObject, int paramInt2, int paramInt3, int paramInt4, int paramInt5)
/*       */     throws SQLException
/*       */   {
/*  9397 */     synchronized (this.connection)
/*       */     {
/*  9404 */       if (this.closed)
/*       */       {
/*  9406 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9407 */         localSQLException.fillInStackTrace();
/*  9408 */         throw localSQLException;
/*       */       }
/*       */ 
/*  9412 */       this.atLeastOneOrdinalParameter = true;
/*  9413 */       setPlsqlIndexTableInternal(paramInt1, paramObject, paramInt2, paramInt3, paramInt4, paramInt5);
/*       */     }
/*       */   }
/*       */ 
/*       */   int addNamedPara(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9431 */     if (this.closed)
/*       */     {
/*  9433 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9434 */       ((SQLException)localObject).fillInStackTrace();
/*  9435 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9438 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9440 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9442 */       if (localObject == this.namedParameters[i]) {
/*  9443 */         return i + 1;
/*       */       }
/*       */     }
/*  9446 */     if (this.parameterCount >= this.namedParameters.length)
/*       */     {
/*  9448 */       String[] arrayOfString = new String[this.namedParameters.length * 2];
/*  9449 */       System.arraycopy(this.namedParameters, 0, arrayOfString, 0, this.namedParameters.length);
/*  9450 */       this.namedParameters = arrayOfString;
/*       */     }
/*       */ 
/*  9453 */     this.namedParameters[(this.parameterCount++)] = localObject;
/*       */ 
/*  9455 */     this.atLeastOneNamedParameter = true;
/*  9456 */     return this.parameterCount;
/*       */   }
/*       */ 
/*       */   public Reader getCharacterStream(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9471 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  9474 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9475 */       ((SQLException)localObject).fillInStackTrace();
/*  9476 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9480 */     if (paramString == null)
/*       */     {
/*  9483 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9484 */       ((SQLException)localObject).fillInStackTrace();
/*  9485 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9489 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9492 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9494 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  9497 */     i++;
/*       */ 
/*  9499 */     Accessor localAccessor = null;
/*  9500 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  9505 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  9506 */       localSQLException.fillInStackTrace();
/*  9507 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9510 */     this.lastIndex = i;
/*       */ 
/*  9512 */     if (this.streamList != null) {
/*  9513 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  9516 */     return localAccessor.getCharacterStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public InputStream getUnicodeStream(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9529 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  9532 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9533 */       ((SQLException)localObject).fillInStackTrace();
/*  9534 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9538 */     if (paramString == null)
/*       */     {
/*  9541 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9542 */       ((SQLException)localObject).fillInStackTrace();
/*  9543 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9547 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9550 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9552 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  9555 */     i++;
/*       */ 
/*  9557 */     Accessor localAccessor = null;
/*  9558 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  9563 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  9564 */       localSQLException.fillInStackTrace();
/*  9565 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9568 */     this.lastIndex = i;
/*       */ 
/*  9570 */     if (this.streamList != null) {
/*  9571 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  9574 */     return localAccessor.getUnicodeStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public InputStream getBinaryStream(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9587 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  9590 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9591 */       ((SQLException)localObject).fillInStackTrace();
/*  9592 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9596 */     if (paramString == null)
/*       */     {
/*  9599 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9600 */       ((SQLException)localObject).fillInStackTrace();
/*  9601 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9605 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9608 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9610 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  9613 */     i++;
/*       */ 
/*  9615 */     Accessor localAccessor = null;
/*  9616 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  9621 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  9622 */       localSQLException.fillInStackTrace();
/*  9623 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9626 */     this.lastIndex = i;
/*       */ 
/*  9628 */     if (this.streamList != null) {
/*  9629 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  9632 */     return localAccessor.getBinaryStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public RowId getRowId(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9646 */     if (this.closed)
/*       */     {
/*  9648 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9649 */       ((SQLException)localObject).fillInStackTrace();
/*  9650 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9653 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  9656 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9657 */       ((SQLException)localObject).fillInStackTrace();
/*  9658 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9662 */     Object localObject = null;
/*  9663 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  9668 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  9669 */       localSQLException.fillInStackTrace();
/*  9670 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9673 */     this.lastIndex = paramInt;
/*       */ 
/*  9675 */     if (this.streamList != null) {
/*  9676 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  9679 */     return ((Accessor)localObject).getROWID(this.currentRank);
/*       */   }
/*       */ 
/*       */   public RowId getRowId(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9692 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  9695 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9696 */       ((SQLException)localObject).fillInStackTrace();
/*  9697 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9701 */     if (paramString == null)
/*       */     {
/*  9704 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9705 */       ((SQLException)localObject).fillInStackTrace();
/*  9706 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9710 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9713 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9715 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  9718 */     i++;
/*       */ 
/*  9720 */     Accessor localAccessor = null;
/*  9721 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  9726 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  9727 */       localSQLException.fillInStackTrace();
/*  9728 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9731 */     this.lastIndex = i;
/*       */ 
/*  9733 */     if (this.streamList != null) {
/*  9734 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  9737 */     return localAccessor.getROWID(this.currentRank);
/*       */   }
/*       */ 
/*       */   public NClob getNClob(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9751 */     if (this.closed)
/*       */     {
/*  9753 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9754 */       ((SQLException)localObject).fillInStackTrace();
/*  9755 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9758 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  9761 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9762 */       ((SQLException)localObject).fillInStackTrace();
/*  9763 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9767 */     Object localObject = null;
/*  9768 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  9773 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  9774 */       localSQLException.fillInStackTrace();
/*  9775 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9778 */     this.lastIndex = paramInt;
/*       */ 
/*  9780 */     if (this.streamList != null) {
/*  9781 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  9784 */     return ((Accessor)localObject).getNClob(this.currentRank);
/*       */   }
/*       */ 
/*       */   public NClob getNClob(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9797 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  9800 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9801 */       ((SQLException)localObject).fillInStackTrace();
/*  9802 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9806 */     if (paramString == null)
/*       */     {
/*  9809 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9810 */       ((SQLException)localObject).fillInStackTrace();
/*  9811 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9815 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9818 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9820 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  9823 */     i++;
/*       */ 
/*  9825 */     Accessor localAccessor = null;
/*  9826 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  9831 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  9832 */       localSQLException.fillInStackTrace();
/*  9833 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9836 */     this.lastIndex = i;
/*       */ 
/*  9838 */     if (this.streamList != null) {
/*  9839 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/*  9842 */     return localAccessor.getNClob(this.currentRank);
/*       */   }
/*       */ 
/*       */   public SQLXML getSQLXML(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9855 */     if (this.closed)
/*       */     {
/*  9857 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9858 */       ((SQLException)localObject).fillInStackTrace();
/*  9859 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9862 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  9865 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9866 */       ((SQLException)localObject).fillInStackTrace();
/*  9867 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9871 */     Object localObject = null;
/*  9872 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  9877 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  9878 */       localSQLException.fillInStackTrace();
/*  9879 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9882 */     this.lastIndex = paramInt;
/*       */ 
/*  9884 */     if (this.streamList != null) {
/*  9885 */       closeUsedStreams(paramInt);
/*       */     }
/*  9887 */     return ((Accessor)localObject).getSQLXML(this.currentRank);
/*       */   }
/*       */ 
/*       */   public SQLXML getSQLXML(String paramString)
/*       */     throws SQLException
/*       */   {
/*  9900 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/*  9903 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9904 */       ((SQLException)localObject).fillInStackTrace();
/*  9905 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9909 */     if (paramString == null)
/*       */     {
/*  9912 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  9913 */       ((SQLException)localObject).fillInStackTrace();
/*  9914 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9918 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/*  9921 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/*  9923 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/*  9926 */     i++;
/*       */ 
/*  9928 */     Accessor localAccessor = null;
/*  9929 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/*  9934 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/*  9935 */       localSQLException.fillInStackTrace();
/*  9936 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9939 */     this.lastIndex = i;
/*       */ 
/*  9941 */     if (this.streamList != null) {
/*  9942 */       closeUsedStreams(i);
/*       */     }
/*  9944 */     return localAccessor.getSQLXML(this.currentRank);
/*       */   }
/*       */ 
/*       */   public String getNString(int paramInt)
/*       */     throws SQLException
/*       */   {
/*  9958 */     if (this.closed)
/*       */     {
/*  9960 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/*  9961 */       ((SQLException)localObject).fillInStackTrace();
/*  9962 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9965 */     if (this.atLeastOneNamedParameter)
/*       */     {
/*  9968 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/*  9969 */       ((SQLException)localObject).fillInStackTrace();
/*  9970 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/*  9974 */     Object localObject = null;
/*  9975 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/*  9980 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  9981 */       localSQLException.fillInStackTrace();
/*  9982 */       throw localSQLException;
/*       */     }
/*       */ 
/*  9985 */     this.lastIndex = paramInt;
/*       */ 
/*  9987 */     if (this.streamList != null) {
/*  9988 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/*  9991 */     return ((Accessor)localObject).getNString(this.currentRank);
/*       */   }
/*       */ 
/*       */   public String getNString(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10004 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/* 10007 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/* 10008 */       ((SQLException)localObject).fillInStackTrace();
/* 10009 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10013 */     if (paramString == null)
/*       */     {
/* 10016 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 10017 */       ((SQLException)localObject).fillInStackTrace();
/* 10018 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10022 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/* 10025 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/* 10027 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/* 10030 */     i++;
/*       */ 
/* 10032 */     Accessor localAccessor = null;
/* 10033 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/* 10038 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/* 10039 */       localSQLException.fillInStackTrace();
/* 10040 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10043 */     this.lastIndex = i;
/*       */ 
/* 10045 */     if (this.streamList != null) {
/* 10046 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/* 10049 */     return localAccessor.getNString(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Reader getNCharacterStream(int paramInt)
/*       */     throws SQLException
/*       */   {
/* 10063 */     if (this.closed)
/*       */     {
/* 10065 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9);
/* 10066 */       ((SQLException)localObject).fillInStackTrace();
/* 10067 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10070 */     if (this.atLeastOneNamedParameter)
/*       */     {
/* 10073 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/* 10074 */       ((SQLException)localObject).fillInStackTrace();
/* 10075 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10079 */     Object localObject = null;
/* 10080 */     if ((paramInt <= 0) || (paramInt > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localObject = this.outBindAccessors[(paramInt - 1)]) == null))
/*       */     {
/* 10085 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 10086 */       localSQLException.fillInStackTrace();
/* 10087 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10090 */     this.lastIndex = paramInt;
/*       */ 
/* 10092 */     if (this.streamList != null) {
/* 10093 */       closeUsedStreams(paramInt);
/*       */     }
/*       */ 
/* 10096 */     return ((Accessor)localObject).getNCharacterStream(this.currentRank);
/*       */   }
/*       */ 
/*       */   public Reader getNCharacterStream(String paramString)
/*       */     throws SQLException
/*       */   {
/* 10109 */     if (!this.atLeastOneNamedParameter)
/*       */     {
/* 10112 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
/* 10113 */       ((SQLException)localObject).fillInStackTrace();
/* 10114 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10118 */     if (paramString == null)
/*       */     {
/* 10121 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 10122 */       ((SQLException)localObject).fillInStackTrace();
/* 10123 */       throw ((Throwable)localObject);
/*       */     }
/*       */ 
/* 10127 */     Object localObject = paramString.toUpperCase().intern();
/*       */ 
/* 10130 */     for (int i = 0; i < this.parameterCount; i++)
/*       */     {
/* 10132 */       if (localObject == this.namedParameters[i])
/*       */         break;
/*       */     }
/* 10135 */     i++;
/*       */ 
/* 10137 */     Accessor localAccessor = null;
/* 10138 */     if ((i <= 0) || (i > this.numberOfBindPositions) || (this.outBindAccessors == null) || ((localAccessor = this.outBindAccessors[(i - 1)]) == null))
/*       */     {
/* 10143 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6);
/* 10144 */       localSQLException.fillInStackTrace();
/* 10145 */       throw localSQLException;
/*       */     }
/*       */ 
/* 10148 */     this.lastIndex = i;
/*       */ 
/* 10150 */     if (this.streamList != null) {
/* 10151 */       closeUsedStreams(i);
/*       */     }
/*       */ 
/* 10154 */     return localAccessor.getNCharacterStream(this.currentRank);
/*       */   }
/*       */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleCallableStatement
 * JD-Core Version:    0.6.2
 */