/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ abstract class OracleBufferedStream extends InputStream
/*     */ {
/*     */   byte[] resizableBuffer;
/*     */   int initialBufferSize;
/*     */   int currentBufferSize;
/*     */   int pos;
/*     */   int count;
/*  29 */   long maxPosition = 2147483647L;
/*     */   boolean closed;
/*     */   OracleStatement statement;
/* 289 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleBufferedStream(int paramInt)
/*     */   {
/*  36 */     this.pos = 0;
/*  37 */     this.count = 0;
/*  38 */     this.closed = false;
/*  39 */     this.initialBufferSize = paramInt;
/*  40 */     this.currentBufferSize = 0;
/*  41 */     this.resizableBuffer = null;
/*     */   }
/*     */ 
/*     */   public OracleBufferedStream(OracleStatement paramOracleStatement, int paramInt)
/*     */   {
/*  47 */     this(paramInt);
/*     */ 
/*  50 */     this.statement = paramOracleStatement;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/*  59 */     this.closed = true;
/*  60 */     this.resizableBuffer = null;
/*     */   }
/*     */ 
/*     */   public boolean needBytes()
/*     */     throws IOException
/*     */   {
/*  67 */     return needBytes(Math.max(this.initialBufferSize, this.currentBufferSize));
/*     */   }
/*     */ 
/*     */   public abstract boolean needBytes(int paramInt)
/*     */     throws IOException;
/*     */ 
/*     */   public int flushBytes(int paramInt)
/*     */   {
/*  76 */     int i = paramInt > this.count - this.pos ? this.count - this.pos : paramInt;
/*     */ 
/*  78 */     this.pos += i;
/*     */ 
/*  80 */     return i;
/*     */   }
/*     */ 
/*     */   public int writeBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*  87 */     int i = paramInt2 > this.count - this.pos ? this.count - this.pos : paramInt2;
/*     */ 
/*  89 */     System.arraycopy(this.resizableBuffer, this.pos, paramArrayOfByte, paramInt1, i);
/*     */ 
/*  91 */     this.pos += i;
/*     */ 
/*  93 */     return i;
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException
/*     */   {
/* 100 */     if (this.statement == null)
/*     */     {
/* 102 */       synchronized (this) {
/* 103 */         return readInternal();
/*     */       }
/*     */     }
/*     */ 
/* 107 */     synchronized (this.statement.connection) {
/* 108 */       return readInternal();
/*     */     }
/*     */   }
/*     */ 
/*     */   private final int readInternal()
/*     */     throws IOException
/*     */   {
/* 118 */     if ((this.closed) || (isNull())) {
/* 119 */       return -1;
/*     */     }
/* 121 */     if (needBytes()) {
/* 122 */       return this.resizableBuffer[(this.pos++)] & 0xFF;
/*     */     }
/* 124 */     return -1;
/*     */   }
/*     */ 
/*     */   public int read(byte[] paramArrayOfByte)
/*     */     throws IOException
/*     */   {
/* 131 */     return read(paramArrayOfByte, 0, paramArrayOfByte.length);
/*     */   }
/*     */ 
/*     */   public int read(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 140 */     if (paramInt2 == 0) return 0;
/*     */ 
/* 142 */     if (this.statement == null)
/*     */     {
/* 144 */       synchronized (this) {
/* 145 */         return readInternal(paramArrayOfByte, paramInt1, paramInt2);
/*     */       }
/*     */     }
/*     */ 
/* 149 */     synchronized (this.statement.connection) {
/* 150 */       return readInternal(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final int readInternal(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 161 */     int j = paramInt1;
/*     */ 
/* 163 */     if ((this.closed) || (isNull()))
/* 164 */       return -1;
/*     */     int i;
/* 166 */     if (paramInt2 > paramArrayOfByte.length)
/* 167 */       i = j + paramArrayOfByte.length;
/*     */     else {
/* 169 */       i = j + paramInt2;
/*     */     }
/* 171 */     if (!needBytes(paramInt2)) {
/* 172 */       return -1;
/*     */     }
/* 174 */     j += writeBytes(paramArrayOfByte, j, i - j);
/*     */ 
/* 176 */     while ((j < i) && (needBytes(i - j)))
/*     */     {
/* 178 */       j += writeBytes(paramArrayOfByte, j, i - j);
/*     */     }
/*     */ 
/* 181 */     return j - paramInt1;
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 188 */     if ((this.closed) || (isNull())) {
/* 189 */       return 0;
/*     */     }
/* 191 */     return this.count - this.pos;
/*     */   }
/*     */ 
/*     */   public boolean isNull()
/*     */     throws IOException
/*     */   {
/* 198 */     return false;
/*     */   }
/*     */ 
/*     */   public void mark(int paramInt)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/* 214 */     synchronized (this.statement.connection)
/*     */     {
/* 216 */       throw new IOException(DatabaseError.findMessage(194, null));
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 224 */     return false;
/*     */   }
/*     */ 
/*     */   public long skip(int paramInt)
/*     */     throws IOException
/*     */   {
/* 237 */     if (this.statement == null)
/*     */     {
/* 239 */       synchronized (this) {
/* 240 */         return skipInternal(paramInt);
/*     */       }
/*     */     }
/*     */ 
/* 244 */     synchronized (this.statement.connection) {
/* 245 */       return skipInternal(paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final int skipInternal(int paramInt)
/*     */     throws IOException
/*     */   {
/* 254 */     int i = 0;
/* 255 */     int j = paramInt;
/*     */ 
/* 257 */     if ((this.closed) || (isNull())) {
/* 258 */       return -1;
/*     */     }
/* 260 */     if (!needBytes()) {
/* 261 */       return -1;
/*     */     }
/* 263 */     while ((i < j) && (needBytes()))
/*     */     {
/* 265 */       i += flushBytes(j - i);
/*     */     }
/*     */ 
/* 268 */     return i;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 283 */     return this.statement.getConnectionDuringExceptionHandling();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleBufferedStream
 * JD-Core Version:    0.6.2
 */