/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleBlob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.BLOB;
/*     */ 
/*     */ class OracleBlobOutputStream extends OutputStream
/*     */ {
/*     */   long lobOffset;
/*     */   OracleBlob blob;
/*     */   byte[] buf;
/*     */   int count;
/*     */   int bufSize;
/*     */   boolean isClosed;
/* 346 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleBlobOutputStream(BLOB paramBLOB, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  45 */     this(paramBLOB, paramInt);
/*     */   }
/*     */ 
/*     */   public OracleBlobOutputStream(OracleBlob paramOracleBlob, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  58 */     this(paramOracleBlob, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleBlobOutputStream(BLOB paramBLOB, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  72 */     this(paramBLOB, paramInt, paramLong);
/*     */   }
/*     */ 
/*     */   public OracleBlobOutputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  89 */     if ((paramOracleBlob == null) || (paramInt <= 0) || (paramLong < 1L))
/*     */     {
/*  91 */       throw new IllegalArgumentException("Illegal Arguments");
/*     */     }
/*     */ 
/*  94 */     this.blob = paramOracleBlob;
/*  95 */     this.lobOffset = paramLong;
/*     */ 
/*  97 */     PhysicalConnection localPhysicalConnection = (PhysicalConnection)paramOracleBlob.getInternalConnection();
/*  98 */     synchronized (localPhysicalConnection) {
/*  99 */       this.buf = localPhysicalConnection.getByteBuffer(paramInt);
/*     */     }
/* 101 */     this.count = 0;
/* 102 */     this.bufSize = paramInt;
/*     */ 
/* 104 */     this.isClosed = false;
/*     */   }
/*     */ 
/*     */   public void write(int paramInt)
/*     */     throws IOException
/*     */   {
/* 123 */     ensureOpen();
/*     */ 
/* 125 */     if (this.count >= this.bufSize) {
/* 126 */       flushBuffer();
/*     */     }
/* 128 */     this.buf[(this.count++)] = ((byte)paramInt);
/*     */   }
/*     */ 
/*     */   public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 150 */     ensureOpen();
/*     */ 
/* 152 */     int i = paramInt1;
/* 153 */     int j = Math.min(paramInt2, paramArrayOfByte.length - paramInt1);
/*     */ 
/* 155 */     if (j >= 2 * this.bufSize)
/*     */     {
/* 162 */       if (this.count > 0) flushBuffer();
/*     */       try
/*     */       {
/* 165 */         this.lobOffset += this.blob.setBytes(this.lobOffset, paramArrayOfByte, paramInt1, j);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 170 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 171 */         localIOException.fillInStackTrace();
/* 172 */         throw localIOException;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 178 */       int k = i + j;
/*     */ 
/* 180 */       while (i < k)
/*     */       {
/* 182 */         int m = Math.min(this.bufSize - this.count, k - i);
/*     */ 
/* 184 */         System.arraycopy(paramArrayOfByte, i, this.buf, this.count, m);
/*     */ 
/* 186 */         i += m;
/* 187 */         this.count += m;
/*     */ 
/* 189 */         if (this.count >= this.bufSize)
/* 190 */           flushBuffer();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 211 */     ensureOpen();
/*     */ 
/* 213 */     flushBuffer();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 232 */     if (this.isClosed) {
/* 233 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 237 */       this.isClosed = true;
/* 238 */       flushBuffer();
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/*     */         PhysicalConnection localPhysicalConnection1;
/* 243 */         PhysicalConnection localPhysicalConnection2 = (PhysicalConnection)this.blob.getInternalConnection();
/* 244 */         synchronized (localPhysicalConnection2)
/*     */         {
/* 246 */           if (this.buf != null)
/*     */           {
/* 248 */             localPhysicalConnection2.cacheBuffer(this.buf);
/* 249 */             this.buf = null;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (SQLException localSQLException2)
/*     */       {
/* 255 */         ??? = DatabaseError.createIOException(localSQLException2);
/* 256 */         ((IOException)???).fillInStackTrace();
/* 257 */         throw ((Throwable)???);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void flushBuffer()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 275 */       if (this.count > 0)
/*     */       {
/* 277 */         this.lobOffset += this.blob.setBytes(this.lobOffset, this.buf, 0, this.count);
/* 278 */         this.count = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 284 */       IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 285 */       localIOException.fillInStackTrace();
/* 286 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 303 */       if (this.isClosed)
/*     */       {
/* 305 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 306 */         localSQLException1.fillInStackTrace();
/* 307 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 313 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 314 */       localIOException.fillInStackTrace();
/* 315 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/*     */     try
/*     */     {
/* 335 */       return this.blob.getInternalConnection();
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 339 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleBlobOutputStream
 * JD-Core Version:    0.6.2
 */