/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.OracleBfile;
/*     */ import oracle.jdbc.internal.OracleBlob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class OracleBlobInputStream extends OracleBufferedStream
/*     */ {
/*     */   long lobOffset;
/*     */   OracleBlob blob;
/*     */   OracleBfile bfile;
/*     */   boolean isStreamForBlob;
/*     */   long markedByte;
/*  38 */   boolean endOfStream = false;
/*  39 */   long maxPosition = 9223372036854775807L;
/*     */ 
/* 405 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleBlobInputStream(OracleBlob paramOracleBlob, int paramInt)
/*     */     throws SQLException
/*     */   {
/*  49 */     this(paramOracleBlob, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleBlobInputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  65 */     super(paramInt);
/*     */ 
/*  68 */     if ((paramOracleBlob == null) || (paramInt <= 0) || (paramLong < 1L))
/*     */     {
/*  70 */       throw new IllegalArgumentException("Illegal Arguments");
/*     */     }
/*     */ 
/*  73 */     this.isStreamForBlob = true;
/*  74 */     this.blob = paramOracleBlob;
/*  75 */     this.bfile = null;
/*  76 */     this.markedByte = -1L;
/*  77 */     this.lobOffset = paramLong;
/*     */   }
/*     */ 
/*     */   public OracleBlobInputStream(OracleBlob paramOracleBlob, int paramInt, long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/*  92 */     this(paramOracleBlob, paramInt, paramLong1);
/*  93 */     this.maxPosition = (paramLong1 + paramLong2);
/*     */   }
/*     */ 
/*     */   public OracleBlobInputStream(OracleBfile paramOracleBfile, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 104 */     this(paramOracleBfile, paramInt, 1L);
/*     */   }
/*     */ 
/*     */   public OracleBlobInputStream(OracleBfile paramOracleBfile, int paramInt, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 119 */     super(paramInt);
/*     */ 
/* 122 */     if ((paramOracleBfile == null) || (paramInt <= 0) || (paramLong < 1L))
/*     */     {
/* 124 */       throw new IllegalArgumentException("Illegal Arguments");
/*     */     }
/*     */ 
/* 127 */     this.isStreamForBlob = false;
/* 128 */     this.blob = null;
/* 129 */     this.bfile = paramOracleBfile;
/* 130 */     this.markedByte = -1L;
/* 131 */     this.lobOffset = paramLong;
/*     */   }
/*     */ 
/*     */   public boolean needBytes(int paramInt)
/*     */     throws IOException
/*     */   {
/* 147 */     ensureOpen();
/*     */ 
/* 149 */     if (this.pos >= this.count)
/*     */     {
/* 151 */       if (!this.endOfStream)
/*     */       {
/* 153 */         if ((paramInt > this.currentBufferSize) || (paramInt == 0))
/*     */         {
/* 155 */           this.currentBufferSize = Math.max(paramInt, this.initialBufferSize);
/* 156 */           this.resizableBuffer = new byte[this.currentBufferSize];
/*     */         }
/*     */         try
/*     */         {
/* 161 */           int i;
/* 161 */           if (this.currentBufferSize < this.maxPosition - this.lobOffset) i = this.currentBufferSize; else {
/* 162 */             i = (int)(this.maxPosition - this.lobOffset);
/*     */           }
/*     */ 
/* 165 */           if (this.isStreamForBlob)
/* 166 */             this.count = this.blob.getBytes(this.lobOffset, i, this.resizableBuffer);
/*     */           else {
/* 168 */             this.count = this.bfile.getBytes(this.lobOffset, i, this.resizableBuffer);
/*     */           }
/*     */ 
/* 171 */           if (this.count < this.currentBufferSize) {
/* 172 */             this.endOfStream = true;
/*     */           }
/* 174 */           if (this.count > 0)
/*     */           {
/* 178 */             this.pos = 0;
/* 179 */             this.lobOffset += this.count;
/* 180 */             if (this.lobOffset > this.maxPosition) this.endOfStream = true;
/*     */ 
/* 182 */             return true;
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (SQLException localSQLException)
/*     */         {
/* 188 */           IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 189 */           localIOException.fillInStackTrace();
/* 190 */           throw localIOException;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 195 */       return false;
/*     */     }
/*     */ 
/* 198 */     return true;
/*     */   }
/*     */ 
/*     */   void ensureOpen()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 213 */       if (this.closed)
/*     */       {
/* 215 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 57, null);
/* 216 */         localSQLException1.fillInStackTrace();
/* 217 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/* 223 */       IOException localIOException = DatabaseError.createIOException(localSQLException2);
/* 224 */       localIOException.fillInStackTrace();
/* 225 */       throw localIOException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 246 */     return true;
/*     */   }
/*     */ 
/*     */   public void mark(int paramInt)
/*     */   {
/* 269 */     if (paramInt < 0) {
/* 270 */       throw new IllegalArgumentException("Read-ahead limit < 0");
/*     */     }
/* 272 */     this.markedByte = (this.lobOffset - this.count + this.pos);
/*     */   }
/*     */ 
/*     */   public void markInternal(int paramInt)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/* 295 */     ensureOpen();
/*     */ 
/* 297 */     if (this.markedByte < 0L) {
/* 298 */       throw new IOException("Mark invalid or stream not marked.");
/*     */     }
/* 300 */     this.lobOffset = this.markedByte;
/* 301 */     this.pos = this.count;
/* 302 */     this.endOfStream = false;
/*     */   }
/*     */ 
/*     */   public long skip(long paramLong)
/*     */     throws IOException
/*     */   {
/* 326 */     ensureOpen();
/*     */ 
/* 328 */     long l1 = 0L;
/*     */ 
/* 330 */     if (this.count - this.pos >= paramLong)
/*     */     {
/* 332 */       this.pos = ((int)(this.pos + paramLong));
/* 333 */       l1 += paramLong;
/*     */     }
/*     */     else
/*     */     {
/* 337 */       l1 += this.count - this.pos;
/* 338 */       this.pos = this.count;
/*     */       try
/*     */       {
/* 342 */         long l2 = 0L;
/*     */ 
/* 344 */         if (this.isStreamForBlob)
/* 345 */           l2 = this.blob.length() - this.lobOffset + 1L;
/*     */         else {
/* 347 */           l2 = this.bfile.length() - this.lobOffset + 1L;
/*     */         }
/* 349 */         if (l2 >= paramLong - l1)
/*     */         {
/* 351 */           this.lobOffset += paramLong - l1;
/* 352 */           l1 += paramLong - l1;
/*     */         }
/*     */         else
/*     */         {
/* 356 */           this.lobOffset += l2;
/* 357 */           l1 += l2;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 363 */         IOException localIOException = DatabaseError.createIOException(localSQLException);
/* 364 */         localIOException.fillInStackTrace();
/* 365 */         throw localIOException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 370 */     return l1;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 386 */     OracleConnection localOracleConnection = null;
/*     */     try
/*     */     {
/* 390 */       if ((this.isStreamForBlob) && (this.blob != null))
/* 391 */         localOracleConnection = this.blob.getInternalConnection();
/* 392 */       else if ((!this.isStreamForBlob) && (this.bfile != null))
/* 393 */         localOracleConnection = this.bfile.getInternalConnection();
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 397 */       localOracleConnection = null;
/*     */     }
/*     */ 
/* 400 */     return localOracleConnection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.OracleBlobInputStream
 * JD-Core Version:    0.6.2
 */