/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Map;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.NUMBER;
/*      */ 
/*      */ abstract class NumberCommonAccessor extends Accessor
/*      */ {
/*      */   protected final byte[] tmpBytes;
/*      */   static final boolean GET_XXX_ROUNDS = false;
/* 2333 */   int[] digs = new int[27];
/*      */   static final int LNXSGNBT = 128;
/*      */   static final byte LNXDIGS = 20;
/*      */   static final byte LNXEXPBS = 64;
/*      */   static final int LNXEXPMX = 127;
/* 3182 */   static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
/*      */   static final byte MAX_LONG_EXPONENT = 9;
/*      */   static final byte MIN_LONG_EXPONENT = 9;
/*      */   static final byte MAX_INT_EXPONENT = 4;
/*      */   static final byte MIN_INT_EXPONENT = 4;
/*      */   static final byte MAX_SHORT_EXPONENT = 2;
/*      */   static final byte MIN_SHORT_EXPONENT = 2;
/*      */   static final byte MAX_BYTE_EXPONENT = 1;
/*      */   static final byte MIN_BYTE_EXPONENT = 1;
/* 3193 */   static final int[] MAX_LONG = { 202, 10, 23, 34, 73, 4, 69, 55, 78, 59, 8 };
/*      */ 
/* 3197 */   static final int[] MIN_LONG = { 53, 92, 79, 68, 29, 98, 33, 47, 24, 43, 93, 102 };
/*      */   static final int MAX_LONG_length = 11;
/*      */   static final int MIN_LONG_length = 12;
/* 3207 */   static final double[] factorTable = { 9.999999999999999E+253D, 1.E+252D, 9.999999999999999E+249D, 1.0E+248D, 1.E+246D, 1.E+244D, 1.E+242D, 1.0E+240D, 1.0E+238D, 1.E+236D, 1.0E+234D, 1.E+232D, 1.E+230D, 9.999999999999999E+227D, 1.0E+226D, 1.0E+224D, 1.0E+222D, 1.0E+220D, 1.E+218D, 1.0E+216D, 1.0E+214D, 9.999999999999999E+211D, 9.999999999999999E+209D, 1.0E+208D, 1.0E+206D, 1.0E+204D, 9.999999999999999E+201D, 1.0E+200D, 1.0E+198D, 1.0E+196D, 9.999999999999999E+193D, 1.0E+192D, 1.E+190D, 1.0E+188D, 1.0E+186D, 1.0E+184D, 1.E+182D, 1.0E+180D, 1.E+178D, 1.0E+176D, 1.E+174D, 1.E+172D, 1.0E+170D, 9.999999999999999E+167D, 9.999999999999999E+165D, 1.0E+164D, 9.999999999999999E+161D, 1.0E+160D, 1.0E+158D, 1.0E+156D, 1.0E+154D, 1.0E+152D, 1.0E+150D, 1.0E+148D, 9.999999999999999E+145D, 1.0E+144D, 1.E+142D, 1.E+140D, 1.0E+138D, 1.E+136D, 9.999999999999999E+133D, 1.0E+132D, 1.E+130D, 1.E+128D, 9.999999999999999E+125D, 1.0E+124D, 1.0E+122D, 1.0E+120D, 1.0E+118D, 1.0E+116D, 1.0E+114D, 9.999999999999999E+111D, 1.0E+110D, 1.0E+108D, 1.E+106D, 1.0E+104D, 1.0E+102D, 1.0E+100D, 1.0E+098D, 1.0E+096D, 1.0E+094D, 1.0E+092D, 1.0E+090D, 1.0E+088D, 1.0E+086D, 1.E+084D, 1.0E+082D, 1.0E+080D, 1.0E+078D, 1.0E+076D, 1.0E+074D, 9.999999999999999E+071D, 1.E+070D, 1.0E+068D, 1.0E+066D, 1.0E+064D, 1.0E+062D, 1.0E+060D, 9.999999999999999E+057D, 1.E+056D, 1.E+054D, 1.0E+052D, 1.E+050D, 1.0E+048D, 1.0E+046D, 1.E+044D, 1.0E+042D, 1.0E+040D, 1.0E+038D, 1.0E+036D, 1.0E+034D, 1.E+032D, 1.0E+030D, 1.0E+028D, 1.0E+026D, 1.0E+024D, 1.0E+022D, 1.0E+020D, 1.0E+018D, 10000000000000000.0D, 100000000000000.0D, 1000000000000.0D, 10000000000.0D, 100000000.0D, 1000000.0D, 10000.0D, 100.0D, 1.0D, 0.01D, 0.0001D, 1.0E-006D, 1.0E-008D, 1.0E-010D, 1.0E-012D, 1.0E-014D, 1.0E-016D, 1.E-018D, 1.0E-020D, 1.0E-022D, 9.999999999999999E-025D, 1.0E-026D, 1.0E-028D, 1.E-030D, 1.E-032D, 9.999999999999999E-035D, 9.999999999999999E-037D, 1.0E-038D, 9.999999999999999E-041D, 1.0E-042D, 1.0E-044D, 1.0E-046D, 1.0E-048D, 1.0E-050D, 1.0E-052D, 1.0E-054D, 1.0E-056D, 1.0E-058D, 1.0E-060D, 1.0E-062D, 1.0E-064D, 1.0E-066D, 1.E-068D, 1.0E-070D, 1.0E-072D, 1.0E-074D, 9.999999999999999E-077D, 1.0E-078D, 1.0E-080D, 1.0E-082D, 1.0E-084D, 1.E-086D, 9.999999999999999E-089D, 1.0E-090D, 1.0E-092D, 1.0E-094D, 9.999999999999999E-097D, 9.999999999999999E-099D, 1.0E-100D, 9.999999999999999E-103D, 9.999999999999999E-105D, 9.999999999999999E-107D, 1.0E-108D, 1.E-110D, 1.0E-112D, 1.E-114D, 1.0E-116D, 1.0E-118D, 1.0E-120D, 1.E-122D, 9.999999999999999E-125D, 1.0E-126D, 1.E-128D, 1.E-130D, 1.0E-132D, 1.0E-134D, 1.0E-136D, 1.E-138D, 1.0E-140D, 1.0E-142D, 1.0E-144D, 1.0E-146D, 9.999999999999999E-149D, 1.0E-150D, 1.E-152D, 1.0E-154D, 1.0E-156D, 1.E-158D, 1.0E-160D, 1.0E-162D, 1.0E-164D, 1.0E-166D, 1.0E-168D, 1.0E-170D, 1.0E-172D, 1.0E-174D, 1.0E-176D, 1.0E-178D, 1.0E-180D, 1.0E-182D, 1.E-184D, 9.999999999999999E-187D, 1.0E-188D, 1.0E-190D, 1.E-192D, 1.0E-194D, 1.0E-196D, 9.999999999999999E-199D, 1.0E-200D, 1.0E-202D, 1.0E-204D, 1.0E-206D, 1.E-208D, 1.0E-210D, 1.0E-212D, 9.999999999999999E-215D, 1.0E-216D, 1.0E-218D, 1.0E-220D, 1.0E-222D, 1.0E-224D, 9.999999999999999E-227D, 1.0E-228D, 1.0E-230D, 1.0E-232D, 1.0E-234D, 1.0E-236D, 1.0E-238D, 1.0E-240D, 1.0E-242D, 9.999999999999999E-245D, 1.0E-246D, 1.0E-248D, 1.E-250D, 9.999999999999999E-253D, 9.999999999999999E-255D };
/*      */ 
/* 3244 */   static final double[] small10pow = { 1.0D, 10.0D, 100.0D, 1000.0D, 10000.0D, 100000.0D, 1000000.0D, 10000000.0D, 100000000.0D, 1000000000.0D, 10000000000.0D, 100000000000.0D, 1000000000000.0D, 10000000000000.0D, 100000000000000.0D, 1000000000000000.0D, 10000000000000000.0D, 1.0E+017D, 1.0E+018D, 1.0E+019D, 1.0E+020D, 1.0E+021D, 1.0E+022D };
/*      */ 
/* 3251 */   static final int tablemax = factorTable.length;
/*      */   static final double tablemaxexponent = 127.0D;
/* 3253 */   static final double tableminexponent = 127.0D - (tablemax - 20);
/*      */   static final int MANTISSA_SIZE = 53;
/* 3258 */   static final int[] expdigs0 = { 25597, 55634, 18440, 18324, 42485, 50370, 56862, 11593, 45703, 57341, 10255, 12549, 59579, 5 };
/*      */ 
/* 3264 */   static final int[] expdigs1 = { 50890, 19916, 24149, 23777, 11324, 41057, 14921, 56274, 30917, 19462, 54968, 47943, 38791, 3872 };
/*      */ 
/* 3270 */   static final int[] expdigs2 = { 24101, 29690, 40218, 29073, 29604, 22037, 27674, 9082, 56670, 55244, 20865, 54874, 47573, 38 };
/*      */ 
/* 3276 */   static final int[] expdigs3 = { 22191, 40873, 1607, 45622, 23883, 24544, 32988, 43530, 61694, 55616, 43150, 32976, 27418, 25379 };
/*      */ 
/* 3282 */   static final int[] expdigs4 = { 55927, 44317, 6569, 54851, 238, 63160, 51447, 12231, 55667, 25459, 5674, 40962, 52047, 253 };
/*      */ 
/* 3288 */   static final int[] expdigs5 = { 56264, 8962, 51839, 64773, 39323, 49783, 15587, 30924, 36601, 56615, 27581, 36454, 35254, 2 };
/*      */ 
/* 3294 */   static final int[] expdigs6 = { 21545, 25466, 59727, 37873, 13099, 7602, 15571, 49963, 37664, 46896, 14328, 59258, 17403, 1663 };
/*      */ 
/* 3300 */   static final int[] expdigs7 = { 12011, 4842, 3874, 57395, 38141, 46606, 49307, 60792, 31833, 21440, 9318, 47123, 41461, 16 };
/*      */ 
/* 3306 */   static final int[] expdigs8 = { 52383, 25023, 56409, 43947, 51036, 17420, 62725, 5735, 53692, 44882, 64439, 36137, 24719, 10900 };
/*      */ 
/* 3312 */   static final int[] expdigs9 = { 65404, 27119, 57580, 26653, 42453, 19179, 26186, 42000, 1847, 62708, 14406, 12813, 247, 109 };
/*      */ 
/* 3318 */   static final int[] expdigs10 = { 36698, 50078, 40552, 35000, 49576, 56552, 261, 49572, 31475, 59609, 45363, 46658, 5900, 1 };
/*      */ 
/* 3324 */   static final int[] expdigs11 = { 33321, 54106, 42443, 60698, 47535, 24088, 45785, 18352, 47026, 40291, 5183, 35843, 24059, 714 };
/*      */ 
/* 3330 */   static final int[] expdigs12 = { 12129, 44450, 22706, 34030, 37175, 8760, 31915, 56544, 23407, 52176, 7260, 41646, 9415, 7 };
/*      */ 
/* 3336 */   static final int[] expdigs13 = { 43054, 17160, 43698, 6780, 36385, 52800, 62346, 52747, 33988, 2855, 31979, 38083, 44325, 4681 };
/*      */ 
/* 3342 */   static final int[] expdigs14 = { 60723, 40803, 16165, 19073, 2985, 9703, 41911, 37227, 41627, 1994, 38986, 27250, 53527, 46 };
/*      */ 
/* 3348 */   static final int[] expdigs15 = { 36481, 57623, 45627, 58488, 53274, 7238, 2063, 31221, 62631, 25319, 35409, 25293, 54667, 30681 };
/*      */ 
/* 3354 */   static final int[] expdigs16 = { 52138, 47106, 3077, 4517, 41165, 38738, 39997, 10142, 13078, 16637, 53438, 54647, 53630, 306 };
/*      */ 
/* 3360 */   static final int[] expdigs17 = { 25425, 24719, 55736, 8564, 12208, 3664, 51518, 17140, 61079, 30312, 2500, 30693, 4468, 3 };
/*      */ 
/* 3366 */   static final int[] expdigs18 = { 58368, 65134, 52675, 3178, 26300, 7986, 11833, 515, 23109, 63525, 29138, 19030, 50114, 2010 };
/*      */ 
/* 3372 */   static final int[] expdigs19 = { 41216, 15724, 12323, 26246, 59245, 58406, 46648, 13767, 11372, 15053, 61895, 48686, 7054, 20 };
/*      */ 
/* 3378 */   static final int[] expdigs20 = { 0, 29248, 62416, 1433, 14025, 43846, 39905, 44375, 137, 47955, 62409, 33386, 48983, 13177 };
/*      */ 
/* 3384 */   static final int[] expdigs21 = { 0, 21264, 53708, 60962, 25043, 64008, 31200, 50906, 9831, 56185, 43877, 36378, 50952, 131 };
/*      */ 
/* 3390 */   static final int[] expdigs22 = { 0, 50020, 25440, 60247, 44814, 39961, 6865, 26068, 34832, 9081, 17478, 44928, 20825, 1 };
/*      */ 
/* 3396 */   static final int[] expdigs23 = { 0, 0, 52929, 10084, 25506, 6346, 61348, 31525, 52689, 61296, 27615, 15903, 40426, 863 };
/*      */ 
/* 3402 */   static final int[] expdigs24 = { 0, 16384, 24122, 53840, 43508, 13170, 51076, 37670, 58198, 31414, 57292, 61762, 41691, 8 };
/*      */ 
/* 3408 */   static final int[] expdigs25 = { 0, 0, 4096, 29077, 42481, 30581, 10617, 59493, 46251, 1892, 5557, 4505, 52391, 5659 };
/*      */ 
/* 3414 */   static final int[] expdigs26 = { 0, 0, 58368, 11431, 1080, 29797, 47947, 36639, 42405, 50481, 29546, 9875, 39190, 56 };
/*      */ 
/* 3420 */   static final int[] expdigs27 = { 0, 0, 0, 57600, 63028, 53094, 12749, 18174, 21993, 48265, 14922, 59933, 4030, 37092 };
/*      */ 
/* 3426 */   static final int[] expdigs28 = { 0, 0, 0, 576, 1941, 35265, 9302, 42780, 50682, 28007, 29640, 28124, 60333, 370 };
/*      */ 
/* 3432 */   static final int[] expdigs29 = { 0, 0, 0, 5904, 8539, 12149, 36793, 43681, 12958, 60573, 21267, 35015, 46478, 3 };
/*      */ 
/* 3438 */   static final int[] expdigs30 = { 0, 0, 0, 0, 7268, 50548, 47962, 3644, 22719, 26999, 41893, 7421, 56711, 2430 };
/*      */ 
/* 3443 */   static final int[] expdigs31 = { 0, 0, 0, 0, 7937, 49002, 60772, 28216, 38893, 55975, 63988, 59711, 20227, 24 };
/*      */ 
/* 3448 */   static final int[] expdigs32 = { 0, 0, 0, 16384, 38090, 63404, 55657, 8801, 62648, 13666, 57656, 60234, 15930 };
/*      */ 
/* 3453 */   static final int[] expdigs33 = { 0, 0, 0, 4096, 37081, 37989, 16940, 55138, 17665, 39458, 9751, 20263, 159 };
/*      */ 
/* 3458 */   static final int[] expdigs34 = { 0, 0, 0, 58368, 35104, 16108, 61773, 14313, 30323, 54789, 57113, 38868, 1 };
/*      */ 
/* 3463 */   static final int[] expdigs35 = { 0, 0, 0, 8448, 18701, 29652, 51080, 65023, 27172, 37903, 3192, 1044 };
/*      */ 
/* 3468 */   static final int[] expdigs36 = { 0, 0, 0, 37440, 63101, 2917, 39177, 50457, 25830, 50186, 28867, 10 };
/*      */ 
/* 3473 */   static final int[] expdigs37 = { 0, 0, 0, 56080, 45850, 37384, 3668, 12301, 38269, 18196, 6842 };
/*      */ 
/* 3478 */   static final int[] expdigs38 = { 0, 0, 0, 46436, 13565, 50181, 34770, 37478, 5625, 27707, 68 };
/*      */ 
/* 3483 */   static final int[] expdigs39 = { 0, 0, 0, 32577, 45355, 38512, 38358, 3651, 36101, 44841 };
/*      */ 
/* 3488 */   static final int[] expdigs40 = { 0, 0, 16384, 28506, 5696, 56746, 15456, 50499, 27230, 448 };
/*      */ 
/* 3493 */   static final int[] expdigs41 = { 0, 0, 4096, 285, 9232, 58239, 57170, 38515, 31729, 4 };
/*      */ 
/* 3498 */   static final int[] expdigs42 = { 0, 0, 58368, 41945, 57108, 12378, 28752, 48226, 2938 };
/*      */ 
/* 3503 */   static final int[] expdigs43 = { 0, 0, 24832, 47605, 49067, 23716, 61891, 25385, 29 };
/*      */ 
/* 3508 */   static final int[] expdigs44 = { 0, 0, 8768, 2442, 50298, 23174, 19624, 19259 };
/*      */ 
/* 3513 */   static final int[] expdigs45 = { 0, 0, 40720, 45899, 1813, 31689, 38862, 192 };
/*      */ 
/* 3518 */   static final int[] expdigs46 = { 0, 0, 36452, 14221, 34752, 48813, 60681, 1 };
/*      */ 
/* 3523 */   static final int[] expdigs47 = { 0, 0, 61313, 34220, 16731, 11629, 1262 };
/*      */ 
/* 3528 */   static final int[] expdigs48 = { 0, 16384, 60906, 18036, 40144, 40748, 12 };
/*      */ 
/* 3533 */   static final int[] expdigs49 = { 0, 4096, 609, 15909, 52830, 8271 };
/*      */ 
/* 3538 */   static final int[] expdigs50 = { 0, 58368, 3282, 56520, 47058, 82 };
/*      */ 
/* 3543 */   static final int[] expdigs51 = { 0, 41216, 52461, 7118, 54210 };
/*      */ 
/* 3548 */   static final int[] expdigs52 = { 0, 45632, 51642, 6624, 542 };
/*      */ 
/* 3553 */   static final int[] expdigs53 = { 0, 25360, 24109, 27591, 5 };
/*      */ 
/* 3558 */   static final int[] expdigs54 = { 0, 42852, 46771, 3552 };
/*      */ 
/* 3563 */   static final int[] expdigs55 = { 0, 28609, 34546, 35 };
/*      */ 
/* 3568 */   static final int[] expdigs56 = { 16384, 4218, 23283 };
/*      */ 
/* 3573 */   static final int[] expdigs57 = { 4096, 54437, 232 };
/*      */ 
/* 3578 */   static final int[] expdigs58 = { 58368, 21515, 2 };
/*      */ 
/* 3583 */   static final int[] expdigs59 = { 57600, 1525 };
/*      */ 
/* 3588 */   static final int[] expdigs60 = { 16960, 15 };
/*      */ 
/* 3593 */   static final int[] expdigs61 = { 10000 };
/*      */ 
/* 3598 */   static final int[] expdigs62 = { 100 };
/*      */ 
/* 3603 */   static final int[] expdigs63 = { 1 };
/*      */ 
/* 3608 */   static final int[] expdigs64 = { 36700, 62914, 23592, 49807, 10485, 36700, 62914, 23592, 49807, 10485, 36700, 62914, 23592, 655 };
/*      */ 
/* 3614 */   static final int[] expdigs65 = { 14784, 18979, 33659, 19503, 2726, 9542, 629, 2202, 40475, 10590, 4299, 47815, 36280, 6 };
/*      */ 
/* 3620 */   static final int[] expdigs66 = { 16332, 9978, 33613, 31138, 35584, 64252, 13857, 14424, 62281, 46279, 36150, 46573, 63392, 4294 };
/*      */ 
/* 3626 */   static final int[] expdigs67 = { 6716, 24348, 22618, 23904, 21327, 3919, 44703, 19149, 28803, 48959, 6259, 50273, 62237, 42 };
/*      */ 
/* 3632 */   static final int[] expdigs68 = { 8471, 23660, 38254, 26440, 33662, 38879, 9869, 11588, 41479, 23225, 60127, 24310, 32615, 28147 };
/*      */ 
/* 3638 */   static final int[] expdigs69 = { 13191, 6790, 63297, 30410, 12788, 42987, 23691, 28296, 32527, 38898, 41233, 4830, 31128, 281 };
/*      */ 
/* 3644 */   static final int[] expdigs70 = { 4064, 53152, 62236, 29139, 46658, 12881, 31694, 4870, 19986, 24637, 9587, 28884, 53395, 2 };
/*      */ 
/* 3650 */   static final int[] expdigs71 = { 26266, 10526, 16260, 55017, 35680, 40443, 19789, 17356, 30195, 55905, 28426, 63010, 44197, 1844 };
/*      */ 
/* 3656 */   static final int[] expdigs72 = { 38273, 7969, 37518, 26764, 23294, 63974, 18547, 17868, 24550, 41191, 17323, 53714, 29277, 18 };
/*      */ 
/* 3662 */   static final int[] expdigs73 = { 16739, 37738, 38090, 26589, 43521, 1543, 15713, 10671, 11975, 41533, 18106, 9348, 16921, 12089 };
/*      */ 
/* 3668 */   static final int[] expdigs74 = { 14585, 61981, 58707, 16649, 25994, 39992, 28337, 17801, 37475, 22697, 31638, 16477, 58496, 120 };
/*      */ 
/* 3674 */   static final int[] expdigs75 = { 58472, 2585, 40564, 27691, 44824, 27269, 58610, 54572, 35108, 30373, 35050, 10650, 13692, 1 };
/*      */ 
/* 3680 */   static final int[] expdigs76 = { 50392, 58911, 41968, 49557, 29112, 29939, 43526, 63500, 55595, 27220, 25207, 38361, 18456, 792 };
/*      */ 
/* 3686 */   static final int[] expdigs77 = { 26062, 32046, 3696, 45060, 46821, 40931, 50242, 60272, 24148, 20588, 6150, 44948, 60477, 7 };
/*      */ 
/* 3692 */   static final int[] expdigs78 = { 12430, 30407, 320, 41980, 58777, 41755, 41041, 13609, 45167, 13348, 40838, 60354, 19454, 5192 };
/*      */ 
/* 3698 */   static final int[] expdigs79 = { 30926, 26518, 13110, 43018, 54982, 48258, 24658, 15209, 63366, 11929, 20069, 43857, 60487, 51 };
/*      */ 
/* 3704 */   static final int[] expdigs80 = { 51263, 54048, 48761, 48627, 30576, 49046, 4414, 61195, 61755, 48474, 19124, 55906, 15511, 34028 };
/*      */ 
/* 3710 */   static final int[] expdigs81 = { 39834, 11681, 47018, 3107, 64531, 54229, 41331, 41899, 51735, 42427, 59173, 13010, 18505, 340 };
/*      */ 
/* 3716 */   static final int[] expdigs82 = { 27268, 6670, 31272, 9861, 45865, 10372, 12865, 62678, 23454, 35158, 20252, 29621, 26399, 3 };
/*      */ 
/* 3722 */   static final int[] expdigs83 = { 57738, 46147, 66, 48154, 11239, 21430, 55809, 46003, 15044, 25138, 52780, 48043, 4883, 2230 };
/*      */ 
/* 3728 */   static final int[] expdigs84 = { 20893, 62065, 64225, 52254, 59094, 55919, 60195, 5702, 48647, 50058, 7736, 41768, 19709, 22 };
/*      */ 
/* 3734 */   static final int[] expdigs85 = { 37714, 32321, 45840, 36031, 33290, 47121, 5146, 28127, 9887, 25390, 52929, 2698, 1073, 14615 };
/*      */ 
/* 3740 */   static final int[] expdigs86 = { 35111, 8187, 18153, 56721, 40309, 59453, 51824, 4868, 45974, 3530, 43783, 8546, 9841, 146 };
/*      */ 
/* 3746 */   static final int[] expdigs87 = { 23288, 61030, 42779, 19572, 29894, 47780, 45082, 32816, 43713, 33458, 25341, 63655, 30244, 1 };
/*      */ 
/* 3752 */   static final int[] expdigs88 = { 58138, 33000, 62869, 37127, 61799, 298, 46353, 5693, 63898, 62040, 989, 23191, 53065, 957 };
/*      */ 
/* 3758 */   static final int[] expdigs89 = { 42524, 32442, 36673, 15444, 22900, 658, 61412, 32824, 21610, 64190, 1975, 11373, 37886, 9 };
/*      */ 
/* 3764 */   static final int[] expdigs90 = { 26492, 4357, 32437, 10852, 34233, 53968, 55056, 34692, 64553, 38226, 41929, 21646, 6667, 6277 };
/*      */ 
/* 3770 */   static final int[] expdigs91 = { 61213, 698, 16053, 50571, 2963, 50347, 13657, 48188, 46520, 19387, 33187, 25775, 50529, 62 };
/*      */ 
/* 3776 */   static final int[] expdigs92 = { 42864, 54351, 45226, 20476, 23443, 17724, 3780, 44701, 52910, 23402, 28374, 46862, 40234, 41137 };
/*      */ 
/* 3782 */   static final int[] expdigs93 = { 23366, 62147, 58123, 44113, 55284, 39498, 3314, 9622, 9704, 27759, 25187, 43722, 24650, 411 };
/*      */ 
/* 3788 */   static final int[] expdigs94 = { 38899, 44530, 19586, 37141, 1863, 9570, 32801, 31553, 51870, 62536, 51369, 30583, 7455, 4 };
/*      */ 
/* 3794 */   static final int[] expdigs95 = { 10421, 4321, 43699, 3472, 65252, 17057, 13858, 29819, 14733, 21490, 40602, 31315, 65186, 2695 };
/*      */ 
/* 3800 */   static final int[] expdigs96 = { 6002, 54438, 29272, 34113, 17036, 25074, 36183, 953, 25051, 12011, 20722, 4245, 62911, 26 };
/*      */ 
/* 3806 */   static final int[] expdigs97 = { 14718, 45935, 8408, 42891, 21312, 56531, 44159, 45581, 20325, 36295, 35509, 24455, 30844, 17668 };
/*      */ 
/* 3812 */   static final int[] expdigs98 = { 54542, 45023, 23021, 3050, 31015, 20881, 50904, 40432, 33626, 14125, 44264, 60537, 44872, 176 };
/*      */ 
/* 3818 */   static final int[] expdigs99 = { 60183, 8969, 14648, 17725, 11451, 50016, 34587, 46279, 19341, 42084, 16826, 5848, 50256, 1 };
/*      */ 
/* 3824 */   static final int[] expdigs100 = { 64999, 53685, 60382, 19151, 25736, 5357, 31302, 23283, 14225, 52622, 56781, 39489, 60351, 1157 };
/*      */ 
/* 3830 */   static final int[] expdigs101 = { 1305, 4469, 39270, 18541, 63827, 59035, 54707, 16616, 32910, 48367, 64137, 2360, 37959, 11 };
/*      */ 
/* 3836 */   static final int[] expdigs102 = { 45449, 32125, 19705, 56098, 51958, 5225, 18285, 13654, 9341, 25888, 50946, 26855, 36068, 7588 };
/*      */ 
/* 3842 */   static final int[] expdigs103 = { 27324, 53405, 43450, 25464, 3796, 3329, 46058, 53220, 26307, 53998, 33932, 23861, 58032, 75 };
/*      */ 
/* 3848 */   static final int[] expdigs104 = { 63080, 50735, 1844, 21406, 57926, 63607, 24936, 52889, 23469, 64488, 539, 8859, 21210, 49732 };
/*      */ 
/* 3854 */   static final int[] expdigs105 = { 62890, 39828, 3950, 32982, 39245, 21607, 40226, 50991, 18584, 10475, 59643, 40720, 21183, 497 };
/*      */ 
/* 3860 */   static final int[] expdigs106 = { 37329, 64623, 11835, 985, 46923, 48712, 28582, 21481, 28366, 41392, 13703, 49559, 63781, 4 };
/*      */ 
/* 3866 */   static final int[] expdigs107 = { 3316, 60011, 41933, 47959, 54404, 39790, 12283, 941, 46090, 42226, 18108, 38803, 16879, 3259 };
/*      */ 
/* 3872 */   static final int[] expdigs108 = { 46563, 56305, 5006, 45044, 49040, 12849, 778, 6563, 46336, 3043, 7390, 2354, 38835, 32 };
/*      */ 
/* 3878 */   static final int[] expdigs109 = { 28653, 3742, 33331, 2671, 39772, 29981, 56489, 1973, 26280, 26022, 56391, 56434, 57039, 21359 };
/*      */ 
/* 3884 */   static final int[] expdigs110 = { 9461, 17732, 7542, 26241, 8917, 24548, 61513, 13126, 59245, 41547, 1874, 41852, 39236, 213 };
/*      */ 
/* 3890 */   static final int[] expdigs111 = { 36794, 22459, 63645, 14024, 42032, 53329, 25518, 11272, 18287, 20076, 62933, 3039, 8912, 2 };
/*      */ 
/* 3896 */   static final int[] expdigs112 = { 14926, 15441, 32337, 42579, 26354, 35154, 22815, 36955, 12564, 8047, 856, 41917, 55080, 1399 };
/*      */ 
/* 3902 */   static final int[] expdigs113 = { 8668, 50617, 10153, 17465, 1574, 28532, 15301, 58041, 38791, 60373, 663, 29255, 65431, 13 };
/*      */ 
/* 3908 */   static final int[] expdigs114 = { 21589, 32199, 24754, 45321, 9349, 26230, 35019, 37508, 20896, 42986, 31405, 12458, 65173, 9173 };
/*      */ 
/* 3914 */   static final int[] expdigs115 = { 46746, 1632, 61196, 50915, 64318, 41549, 2971, 23968, 59191, 58756, 61917, 779, 48493, 91 };
/*      */ 
/* 3920 */   static final int[] expdigs116 = { 1609, 63382, 15744, 15685, 51627, 56348, 33838, 52458, 44148, 11077, 56293, 41906, 45227, 60122 };
/*      */ 
/* 3926 */   static final int[] expdigs117 = { 19676, 45198, 6055, 38823, 8380, 49060, 17377, 58196, 43039, 21737, 59545, 12870, 14870, 601 };
/*      */ 
/* 3932 */   static final int[] expdigs118 = { 4128, 2418, 28241, 13495, 26298, 3767, 31631, 5169, 8950, 27087, 56956, 4060, 804, 6 };
/*      */ 
/* 3938 */   static final int[] expdigs119 = { 39930, 40673, 19029, 54677, 38145, 23200, 41325, 24564, 24955, 54484, 23863, 52998, 13147, 3940 };
/*      */ 
/* 3944 */   static final int[] expdigs120 = { 3676, 24655, 34924, 27416, 23974, 887, 10899, 4833, 21221, 28725, 19899, 57546, 26345, 39 };
/*      */ 
/* 3950 */   static final int[] expdigs121 = { 28904, 41324, 18596, 42292, 12070, 52013, 30810, 61057, 55753, 32324, 38953, 6752, 32688, 25822 };
/*      */ 
/* 3956 */   static final int[] expdigs122 = { 42232, 26627, 2807, 27948, 50583, 49016, 32420, 64180, 3178, 3600, 21361, 52496, 14744, 258 };
/*      */ 
/* 3962 */   static final int[] expdigs123 = { 2388, 59904, 28863, 7488, 31963, 8354, 47510, 15059, 2653, 58363, 31670, 21496, 38158, 2 };
/*      */ 
/* 3968 */   static final int[] expdigs124 = { 50070, 5266, 26158, 10774, 15148, 6873, 30230, 33898, 63720, 51799, 4515, 50124, 19875, 1692 };
/*      */ 
/* 3974 */   static final int[] expdigs125 = { 54240, 3984, 12058, 2729, 13914, 11865, 38313, 39660, 10467, 20834, 36745, 57517, 60491, 16 };
/*      */ 
/* 3980 */   static final int[] expdigs126 = { 5387, 58214, 9214, 13883, 14445, 34873, 21745, 13490, 23334, 25008, 58535, 19372, 44484, 11090 };
/*      */ 
/* 3986 */   static final int[] expdigs127 = { 27578, 64807, 12543, 794, 13907, 61297, 12013, 64360, 15961, 20566, 24178, 15922, 59427, 110 };
/*      */ 
/* 3992 */   static final int[] expdigs128 = { 49427, 41935, 46000, 59645, 45358, 51075, 15848, 32756, 38170, 14623, 35631, 57175, 7147, 1 };
/*      */ 
/* 3998 */   static final int[] expdigs129 = { 33941, 39160, 55469, 45679, 22878, 60091, 37210, 18508, 1638, 57398, 65026, 41643, 54966, 726 };
/*      */ 
/* 4004 */   static final int[] expdigs130 = { 60632, 24639, 41842, 62060, 20544, 59583, 52800, 1495, 48513, 43827, 10480, 1727, 17589, 7 };
/*      */ 
/* 4010 */   static final int[] expdigs131 = { 5590, 60244, 53985, 26632, 53049, 33628, 58267, 54922, 21641, 62744, 58109, 2070, 26887, 4763 };
/*      */ 
/* 4016 */   static final int[] expdigs132 = { 62970, 37957, 34618, 29757, 24123, 2302, 17622, 58876, 44780, 6525, 33349, 36065, 41556, 47 };
/*      */ 
/* 4022 */   static final int[] expdigs133 = { 1615, 24878, 20040, 11487, 23235, 27766, 59005, 57847, 60881, 11588, 63635, 61281, 31817, 31217 };
/*      */ 
/* 4028 */   static final int[] expdigs134 = { 14434, 2870, 65081, 44023, 40864, 40254, 47120, 6476, 32066, 23053, 17020, 19618, 11459, 312 };
/*      */ 
/* 4034 */   static final int[] expdigs135 = { 43398, 40005, 36695, 8304, 12205, 16131, 42414, 38075, 63890, 2851, 61774, 59833, 7978, 3 };
/*      */ 
/* 4040 */   static final int[] expdigs136 = { 56426, 22060, 15473, 31824, 19088, 38788, 64386, 12875, 35770, 65519, 11824, 19623, 56959, 2045 };
/*      */ 
/* 4046 */   static final int[] expdigs137 = { 16292, 32333, 10640, 47504, 29026, 30534, 23581, 6682, 10188, 24248, 44027, 51969, 30060, 20 };
/*      */ 
/* 4052 */   static final int[] expdigs138 = { 29432, 37518, 55373, 2727, 33243, 22572, 16689, 35625, 34145, 15830, 59880, 32552, 52948, 13407 };
/*      */ 
/* 4058 */   static final int[] expdigs139 = { 61898, 27244, 41841, 33450, 18682, 13988, 24415, 11497, 1652, 34237, 34677, 325, 5117, 134 };
/*      */ 
/* 4064 */   static final int[] expdigs140 = { 16347, 3549, 48915, 22616, 21158, 51913, 32356, 21086, 3293, 8862, 1002, 26873, 22333, 1 };
/*      */ 
/* 4070 */   static final int[] expdigs141 = { 25966, 63733, 28215, 31946, 40858, 58538, 11004, 6877, 6109, 3965, 35478, 37365, 45488, 878 };
/*      */ 
/* 4076 */   static final int[] expdigs142 = { 45479, 34060, 17321, 19980, 1719, 16314, 29601, 8588, 58388, 22321, 14117, 63288, 51572, 8 };
/*      */ 
/* 4082 */   static final int[] expdigs143 = { 46861, 47640, 11481, 23766, 46730, 53756, 8682, 60589, 42028, 27453, 29714, 31598, 39954, 5758 };
/*      */ 
/* 4088 */   static final int[] expdigs144 = { 29304, 58803, 51232, 27762, 60760, 17576, 19092, 26820, 11561, 48771, 6850, 27841, 38410, 57 };
/*      */ 
/* 4094 */   static final int[] expdigs145 = { 2916, 49445, 34666, 46387, 18627, 58279, 60468, 190, 3545, 51889, 51605, 47909, 40910, 37739 };
/*      */ 
/* 4100 */   static final int[] expdigs146 = { 19034, 62098, 15419, 33887, 38852, 53011, 28129, 37357, 11176, 48360, 9035, 9654, 25968, 377 };
/*      */ 
/* 4106 */   static final int[] expdigs147 = { 25094, 10451, 7363, 55389, 57404, 27399, 11422, 39695, 28947, 12935, 61694, 26310, 50722, 3 };
/*      */ 
/* 4112 */   static final int[][] expdigstable = { expdigs0, expdigs1, expdigs2, expdigs3, expdigs4, expdigs5, expdigs6, expdigs7, expdigs8, expdigs9, expdigs10, expdigs11, expdigs12, expdigs13, expdigs14, expdigs15, expdigs16, expdigs17, expdigs18, expdigs19, expdigs20, expdigs21, expdigs22, expdigs23, expdigs24, expdigs25, expdigs26, expdigs27, expdigs28, expdigs29, expdigs30, expdigs31, expdigs32, expdigs33, expdigs34, expdigs35, expdigs36, expdigs37, expdigs38, expdigs39, expdigs40, expdigs41, expdigs42, expdigs43, expdigs44, expdigs45, expdigs46, expdigs47, expdigs48, expdigs49, expdigs50, expdigs51, expdigs52, expdigs53, expdigs54, expdigs55, expdigs56, expdigs57, expdigs58, expdigs59, expdigs60, expdigs61, expdigs62, expdigs63, expdigs64, expdigs65, expdigs66, expdigs67, expdigs68, expdigs69, expdigs70, expdigs71, expdigs72, expdigs73, expdigs74, expdigs75, expdigs76, expdigs77, expdigs78, expdigs79, expdigs80, expdigs81, expdigs82, expdigs83, expdigs84, expdigs85, expdigs86, expdigs87, expdigs88, expdigs89, expdigs90, expdigs91, expdigs92, expdigs93, expdigs94, expdigs95, expdigs96, expdigs97, expdigs98, expdigs99, expdigs100, expdigs101, expdigs102, expdigs103, expdigs104, expdigs105, expdigs106, expdigs107, expdigs108, expdigs109, expdigs110, expdigs111, expdigs112, expdigs113, expdigs114, expdigs115, expdigs116, expdigs117, expdigs118, expdigs119, expdigs120, expdigs121, expdigs122, expdigs123, expdigs124, expdigs125, expdigs126, expdigs127, expdigs128, expdigs129, expdigs130, expdigs131, expdigs132, expdigs133, expdigs134, expdigs135, expdigs136, expdigs137, expdigs138, expdigs139, expdigs140, expdigs141, expdigs142, expdigs143, expdigs144, expdigs145, expdigs146, expdigs147 };
/*      */ 
/* 4141 */   static final int[] nexpdigstable = { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 12, 12, 11, 11, 10, 10, 10, 9, 9, 8, 8, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 3, 3, 3, 2, 2, 1, 1, 1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 };
/*      */ 
/* 4153 */   static final int[] binexpstable = { 90, 89, 89, 88, 88, 88, 87, 87, 86, 86, 86, 85, 85, 84, 84, 83, 83, 83, 82, 82, 81, 81, 81, 80, 80, 79, 79, 78, 78, 78, 77, 77, 76, 76, 76, 75, 75, 74, 74, 73, 73, 73, 72, 72, 71, 71, 71, 70, 70, 69, 69, 68, 68, 68, 67, 67, 66, 66, 66, 65, 65, 64, 64, 64, 63, 63, 62, 62, 61, 61, 61, 60, 60, 59, 59, 59, 58, 58, 57, 57, 56, 56, 56, 55, 55, 54, 54, 54, 53, 53, 52, 52, 51, 51, 51, 50, 50, 49, 49, 49, 48, 48, 47, 47, 46, 46, 46, 45, 45, 44, 44, 44, 43, 43, 42, 42, 41, 41, 41, 40, 40, 39, 39, 39, 38, 38, 37, 37, 37, 36, 36, 35, 35, 34, 34, 34, 33, 33, 32, 32, 32, 31, 31, 30, 30, 29, 29, 29 };
/*      */ 
/* 4177 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   NumberCommonAccessor(OracleStatement paramOracleStatement, int paramInt, boolean paramBoolean)
/*      */   {
/*   26 */     super(Representation.NUMBER, paramOracleStatement, paramInt, paramBoolean);
/*   27 */     this.tmpBytes = new byte[this.representationMaxLength];
/*      */   }
/*      */ 
/*      */   void init(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*   34 */     init(paramOracleStatement, 6, 6, paramShort, paramBoolean);
/*   35 */     initForDataAccess(paramInt2, paramInt1, null);
/*      */   }
/*      */ 
/*      */   void init(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort)
/*      */     throws SQLException
/*      */   {
/*   44 */     init(paramOracleStatement, 6, 6, paramShort, false);
/*   45 */     initForDescribe(paramInt1, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort, null);
/*      */ 
/*   47 */     initForDataAccess(0, paramInt2, null);
/*      */   }
/*      */ 
/*      */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*      */     throws SQLException
/*      */   {
/*   54 */     super.initForDataAccess(paramInt1, paramInt2, paramString);
/*      */ 
/*   56 */     this.byteLength += 1;
/*      */   }
/*      */ 
/*      */   int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/*   73 */     if (isNull(paramInt)) return 0;
/*      */ 
/*   75 */     int i = getLength(paramInt);
/*   76 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*   77 */     int j = this.tmpBytes[0];
/*      */ 
/*   79 */     int k = 0;
/*      */     int m;
/*      */     int n;
/*      */     int i1;
/*      */     int i2;
/*      */     int i5;
/*   83 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/*   88 */       m = (byte)((j & 0xFFFFFF7F) - 65);
/*   89 */       n = (byte)(i - 1);
/*      */ 
/*   91 */       i1 = n > m + 1 ? m + 2 : n + 1;
/*   92 */       i2 = i1;
/*      */ 
/*   94 */       if (m >= 4)
/*      */       {
/*   96 */         if (m > 4)
/*      */         {
/*   99 */           throwOverflow();
/*      */         }
/*  101 */         long l1 = 0L;
/*      */ 
/*  103 */         if (i1 > 1)
/*      */         {
/*  105 */           l1 = this.tmpBytes[1] - 1;
/*      */ 
/*  107 */           for (i5 = 2; i5 < i2; i5++) {
/*  108 */             l1 = l1 * 100L + (this.tmpBytes[i5] - 1);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  115 */         for (i5 = m - n; i5 >= 0; i5--) {
/*  116 */           l1 *= 100L;
/*      */         }
/*  118 */         if (l1 > 2147483647L) {
/*  119 */           throwOverflow();
/*      */         }
/*  121 */         k = (int)l1;
/*      */       }
/*      */       else
/*      */       {
/*  125 */         if (i1 > 1)
/*      */         {
/*  127 */           k = this.tmpBytes[1] - 1;
/*      */ 
/*  129 */           for (i3 = 2; i3 < i2; i3++) {
/*  130 */             k = k * 100 + (this.tmpBytes[i3] - 1);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  137 */         for (int i3 = m - n; i3 >= 0; i3--) {
/*  138 */           k *= 100;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  146 */       m = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*  147 */       n = (byte)(i - 1);
/*      */ 
/*  149 */       if ((n != 20) || (this.tmpBytes[n] == 102)) {
/*  150 */         n = (byte)(n - 1);
/*      */       }
/*  152 */       i1 = n > m + 1 ? m + 2 : n + 1;
/*  153 */       i2 = i1;
/*      */ 
/*  163 */       if (m >= 4)
/*      */       {
/*  165 */         if (m > 4)
/*      */         {
/*  179 */           throwOverflow();
/*      */         }
/*      */ 
/*  182 */         long l2 = 0L;
/*      */ 
/*  184 */         if (i1 > 1)
/*      */         {
/*  186 */           l2 = 101 - this.tmpBytes[1];
/*      */ 
/*  188 */           for (i5 = 2; i5 < i2; i5++) {
/*  189 */             l2 = l2 * 100L + (101 - this.tmpBytes[i5]);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  196 */         for (i5 = m - n; i5 >= 0; i5--) {
/*  197 */           l2 *= 100L;
/*      */         }
/*  199 */         l2 = -l2;
/*      */ 
/*  201 */         if (l2 < -2147483648L) {
/*  202 */           throwOverflow();
/*      */         }
/*  204 */         k = (int)l2;
/*      */       }
/*      */       else
/*      */       {
/*  208 */         if (i1 > 1)
/*      */         {
/*  210 */           k = 101 - this.tmpBytes[1];
/*      */ 
/*  212 */           for (i4 = 2; i4 < i2; i4++) {
/*  213 */             k = k * 100 + (101 - this.tmpBytes[i4]);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  220 */         for (int i4 = m - n; i4 >= 0; i4--) {
/*  221 */           k *= 100;
/*      */         }
/*  223 */         k = -k;
/*      */       }
/*      */     }
/*      */ 
/*  227 */     return k;
/*      */   }
/*      */ 
/*      */   boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  244 */     if (isNull(paramInt)) return false;
/*      */ 
/*  246 */     int i = getLength(paramInt);
/*  247 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*      */ 
/*  249 */     return (i != 1) || (this.tmpBytes[0] != -128);
/*      */   }
/*      */ 
/*      */   short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  266 */     if (isNull(paramInt)) return 0;
/*      */ 
/*  269 */     int i = getLength(paramInt);
/*  270 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*  271 */     int j = this.tmpBytes[0];
/*      */ 
/*  273 */     int k = 0;
/*      */     int m;
/*      */     int n;
/*      */     int i1;
/*      */     int i2;
/*      */     int i3;
/*  277 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/*  282 */       m = (byte)((j & 0xFFFFFF7F) - 65);
/*      */ 
/*  284 */       if (m > 2)
/*      */       {
/*  287 */         throwOverflow();
/*      */       }
/*  289 */       n = (byte)(i - 1);
/*      */ 
/*  291 */       i1 = n > m + 1 ? m + 2 : n + 1;
/*  292 */       i2 = i1;
/*      */ 
/*  294 */       if (i1 > 1)
/*      */       {
/*  296 */         k = this.tmpBytes[1] - 1;
/*      */ 
/*  298 */         for (i3 = 2; i3 < i2; i3++) {
/*  299 */           k = k * 100 + (this.tmpBytes[i3] - 1);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  306 */       for (i3 = m - n; i3 >= 0; i3--) {
/*  307 */         k *= 100;
/*      */       }
/*  309 */       if ((m == 2) && 
/*  310 */         (k > 32767)) {
/*  311 */         throwOverflow();
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  318 */       m = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/*  320 */       if (m > 2)
/*      */       {
/*  323 */         throwOverflow();
/*      */       }
/*  325 */       n = (byte)(i - 1);
/*      */ 
/*  327 */       if ((n != 20) || (this.tmpBytes[n] == 102)) {
/*  328 */         n = (byte)(n - 1);
/*      */       }
/*  330 */       i1 = n > m + 1 ? m + 2 : n + 1;
/*  331 */       i2 = i1;
/*      */ 
/*  333 */       if (i1 > 1)
/*      */       {
/*  335 */         k = 101 - this.tmpBytes[1];
/*      */ 
/*  337 */         for (i3 = 2; i3 < i2; i3++) {
/*  338 */           k = k * 100 + (101 - this.tmpBytes[i3]);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  345 */       for (i3 = m - n; i3 >= 0; i3--) {
/*  346 */         k *= 100;
/*      */       }
/*  348 */       k = -k;
/*      */ 
/*  350 */       if ((m == 2) && 
/*  351 */         (k < -32768)) {
/*  352 */         throwOverflow();
/*      */       }
/*      */     }
/*  355 */     return (short)k;
/*      */   }
/*      */ 
/*      */   byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  372 */     if (isNull(paramInt)) return 0;
/*      */ 
/*  374 */     int i = getLength(paramInt);
/*  375 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*  376 */     int j = this.tmpBytes[0];
/*      */ 
/*  378 */     int k = 0;
/*      */     int m;
/*      */     int n;
/*  382 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/*  387 */       m = (byte)((j & 0xFFFFFF7F) - 65);
/*      */ 
/*  389 */       if (m > 1)
/*      */       {
/*  392 */         throwOverflow();
/*      */       }
/*  394 */       n = (byte)(i - 1);
/*      */ 
/*  396 */       if (n > m + 1)
/*      */       {
/*  398 */         switch (m)
/*      */         {
/*      */         default:
/*  402 */           break;
/*      */         case -1:
/*  408 */           break;
/*      */         case 0:
/*  411 */           k = this.tmpBytes[1] - 1;
/*      */ 
/*  416 */           break;
/*      */         case 1:
/*  419 */           k = (this.tmpBytes[1] - 1) * 100 + (this.tmpBytes[2] - 1);
/*      */ 
/*  425 */           if (k <= 127) break;
/*  426 */           throwOverflow(); break;
/*      */         }
/*      */ 
/*      */       }
/*  431 */       else if (n == 1)
/*      */       {
/*  433 */         if (m == 1)
/*      */         {
/*  435 */           k = (this.tmpBytes[1] - 1) * 100;
/*      */ 
/*  437 */           if (k > 127)
/*  438 */             throwOverflow();
/*      */         }
/*      */         else {
/*  441 */           k = this.tmpBytes[1] - 1;
/*      */         }
/*  443 */       } else if (n == 2)
/*      */       {
/*  445 */         k = (this.tmpBytes[1] - 1) * 100 + (this.tmpBytes[2] - 1);
/*      */ 
/*  448 */         if (k > 127) {
/*  449 */           throwOverflow();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  457 */       m = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/*  459 */       if (m > 1)
/*      */       {
/*  462 */         throwOverflow();
/*      */       }
/*  464 */       n = (byte)(i - 1);
/*      */ 
/*  466 */       if ((n != 20) || (this.tmpBytes[n] == 102)) {
/*  467 */         n = (byte)(n - 1);
/*      */       }
/*  469 */       if (n > m + 1)
/*      */       {
/*  471 */         switch (m)
/*      */         {
/*      */         default:
/*  475 */           break;
/*      */         case -1:
/*  481 */           break;
/*      */         case 0:
/*  484 */           k = -(101 - this.tmpBytes[1]);
/*      */ 
/*  489 */           break;
/*      */         case 1:
/*  492 */           k = -((101 - this.tmpBytes[1]) * 100 + (101 - this.tmpBytes[2]));
/*      */ 
/*  498 */           if (k >= -128) break;
/*  499 */           throwOverflow(); break;
/*      */         }
/*      */ 
/*      */       }
/*  504 */       else if (n == 1)
/*      */       {
/*  506 */         if (m == 1)
/*      */         {
/*  508 */           k = -(101 - this.tmpBytes[1]) * 100;
/*      */ 
/*  510 */           if (k < -128)
/*  511 */             throwOverflow();
/*      */         }
/*      */         else {
/*  514 */           k = -(101 - this.tmpBytes[1]);
/*      */         }
/*  516 */       } else if (n == 2)
/*      */       {
/*  518 */         k = -((101 - this.tmpBytes[1]) * 100 + (101 - this.tmpBytes[2]));
/*      */ 
/*  521 */         if (k < -128) {
/*  522 */           throwOverflow();
/*      */         }
/*      */       }
/*      */     }
/*  526 */     return (byte)k;
/*      */   }
/*      */ 
/*      */   long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  543 */     if (isNull(paramInt)) return 0L;
/*      */ 
/*  545 */     int i = getLength(paramInt);
/*  546 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*      */ 
/*  548 */     int j = this.tmpBytes[0];
/*  549 */     long l = 0L;
/*      */     int k;
/*      */     int n;
/*      */     int i1;
/*      */     int i2;
/*      */     int i3;
/*      */     int m;
/*  557 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/*  562 */       if ((j == -128) && (i == 1)) {
/*  563 */         return 0L;
/*      */       }
/*  565 */       k = (byte)((j & 0xFFFFFF7F) - 65);
/*      */ 
/*  570 */       if (k > 9)
/*      */       {
/*  573 */         throwOverflow();
/*      */       }
/*  575 */       if (k == 9)
/*      */       {
/*  577 */         n = 1;
/*  578 */         i1 = i;
/*      */ 
/*  580 */         if (i > 11) {
/*  581 */           i1 = 11;
/*      */         }
/*  583 */         while (n < i1)
/*      */         {
/*  587 */           i2 = this.tmpBytes[n] & 0xFF;
/*  588 */           i3 = MAX_LONG[n];
/*      */ 
/*  590 */           if (i2 != i3)
/*      */           {
/*  592 */             if (i2 < i3) {
/*      */               break;
/*      */             }
/*  595 */             throwOverflow();
/*      */           }
/*      */ 
/*  598 */           n++;
/*      */         }
/*      */ 
/*  601 */         if ((n == i1) && (i > 11)) {
/*  602 */           throwOverflow();
/*      */         }
/*      */       }
/*  605 */       m = (byte)(i - 1);
/*      */ 
/*  607 */       n = m > k + 1 ? k + 2 : m + 1;
/*  608 */       i1 = n;
/*      */ 
/*  610 */       if (n > 1)
/*      */       {
/*  612 */         l = this.tmpBytes[1] - 1;
/*      */ 
/*  614 */         for (i2 = 2; i2 < i1; i2++) {
/*  615 */           l = l * 100L + (this.tmpBytes[i2] - 1);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  622 */       for (i2 = k - m; i2 >= 0; i2--) {
/*  623 */         l *= 100L;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  630 */       k = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/*  635 */       if (k > 9)
/*      */       {
/*  638 */         throwOverflow();
/*      */       }
/*  640 */       if (k == 9)
/*      */       {
/*  642 */         n = 1;
/*  643 */         i1 = i;
/*      */ 
/*  645 */         if (i > 12) {
/*  646 */           i1 = 12;
/*      */         }
/*  648 */         while (n < i1)
/*      */         {
/*  652 */           i2 = this.tmpBytes[n] & 0xFF;
/*  653 */           i3 = MIN_LONG[n];
/*      */ 
/*  655 */           if (i2 != i3)
/*      */           {
/*  657 */             if (i2 > i3) {
/*      */               break;
/*      */             }
/*  660 */             throwOverflow();
/*      */           }
/*      */ 
/*  663 */           n++;
/*      */         }
/*      */ 
/*  666 */         if ((n == i1) && (i < 12)) {
/*  667 */           throwOverflow();
/*      */         }
/*      */       }
/*  670 */       m = (byte)(i - 1);
/*      */ 
/*  672 */       if ((m != 20) || (this.tmpBytes[m] == 102)) {
/*  673 */         m = (byte)(m - 1);
/*      */       }
/*  675 */       n = m > k + 1 ? k + 2 : m + 1;
/*  676 */       i1 = n;
/*      */ 
/*  678 */       if (n > 1)
/*      */       {
/*  680 */         l = 101 - this.tmpBytes[1];
/*      */ 
/*  682 */         for (i2 = 2; i2 < i1; i2++) {
/*  683 */           l = l * 100L + (101 - this.tmpBytes[i2]);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  690 */       for (i2 = k - m; i2 >= 0; i2--) {
/*  691 */         l *= 100L;
/*      */       }
/*  693 */       l = -l;
/*      */     }
/*      */ 
/*  696 */     return l;
/*      */   }
/*      */ 
/*      */   float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  713 */     if (isNull(paramInt)) return 0.0F;
/*      */ 
/*  716 */     int i = getLength(paramInt);
/*  717 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*  718 */     int j = this.tmpBytes[0];
/*      */ 
/*  721 */     double d = 0.0D;
/*      */ 
/*  723 */     int n = 1;
/*      */     int k;
/*      */     int i1;
/*      */     int m;
/*  734 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/*  739 */       if ((j == -128) && (i == 1)) {
/*  740 */         return 0.0F;
/*      */       }
/*  742 */       if ((i == 2) && (j == -1) && (this.tmpBytes[1] == 101))
/*      */       {
/*  744 */         return (1.0F / 1.0F);
/*      */       }
/*  746 */       k = (byte)((j & 0xFFFFFF7F) - 65);
/*      */ 
/*  748 */       i1 = i - 1;
/*      */ 
/*  750 */       while ((this.tmpBytes[n] == 1) && (i1 > 0))
/*      */       {
/*  752 */         n++;
/*  753 */         i1--;
/*  754 */         k = (byte)(k - 1);
/*      */       }
/*      */ 
/*  762 */       m = (int)(127.0D - k);
/*      */ 
/*  764 */       switch (i1)
/*      */       {
/*      */       case 1:
/*  768 */         d = (this.tmpBytes[n] - 1) * factorTable[m];
/*      */ 
/*  770 */         break;
/*      */       case 2:
/*  773 */         d = ((this.tmpBytes[n] - 1) * 100 + (this.tmpBytes[(n + 1)] - 1)) * factorTable[(m + 1)];
/*      */ 
/*  776 */         break;
/*      */       case 3:
/*  779 */         d = ((this.tmpBytes[n] - 1) * 10000 + (this.tmpBytes[(n + 1)] - 1) * 100 + (this.tmpBytes[(n + 2)] - 1)) * factorTable[(m + 2)];
/*      */ 
/*  783 */         break;
/*      */       case 4:
/*  786 */         d = ((this.tmpBytes[n] - 1) * 1000000 + (this.tmpBytes[(n + 1)] - 1) * 10000 + (this.tmpBytes[(n + 2)] - 1) * 100 + (this.tmpBytes[(n + 3)] - 1)) * factorTable[(m + 3)];
/*      */ 
/*  790 */         break;
/*      */       case 5:
/*  793 */         d = ((this.tmpBytes[(n + 1)] - 1) * 1000000 + (this.tmpBytes[(n + 2)] - 1) * 10000 + (this.tmpBytes[(n + 3)] - 1) * 100 + (this.tmpBytes[(n + 4)] - 1)) * factorTable[(m + 4)] + (this.tmpBytes[n] - 1) * factorTable[m];
/*      */ 
/*  799 */         break;
/*      */       case 6:
/*  802 */         d = ((this.tmpBytes[(n + 2)] - 1) * 1000000 + (this.tmpBytes[(n + 3)] - 1) * 10000 + (this.tmpBytes[(n + 4)] - 1) * 100 + (this.tmpBytes[(n + 5)] - 1)) * factorTable[(m + 5)] + ((this.tmpBytes[n] - 1) * 100 + (this.tmpBytes[(n + 1)] - 1)) * factorTable[(m + 1)];
/*      */ 
/*  808 */         break;
/*      */       default:
/*  811 */         d = ((this.tmpBytes[(n + 3)] - 1) * 1000000 + (this.tmpBytes[(n + 4)] - 1) * 10000 + (this.tmpBytes[(n + 5)] - 1) * 100 + (this.tmpBytes[(n + 6)] - 1)) * factorTable[(m + 6)] + ((this.tmpBytes[n] - 1) * 10000 + (this.tmpBytes[(n + 1)] - 1) * 100 + (this.tmpBytes[(n + 2)] - 1)) * factorTable[(m + 2)];
/*      */ 
/*  817 */         break;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  825 */       if ((j == 0) && (i == 1)) {
/*  826 */         return (1.0F / -1.0F);
/*      */       }
/*  828 */       k = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/*  830 */       i1 = i - 1;
/*      */ 
/*  832 */       if ((i1 != 20) || (this.tmpBytes[i1] == 102)) {
/*  833 */         i1--;
/*      */       }
/*  835 */       while ((this.tmpBytes[n] == 1) && (i1 > 0))
/*      */       {
/*  837 */         n++;
/*  838 */         i1--;
/*  839 */         k = (byte)(k - 1);
/*      */       }
/*      */ 
/*  847 */       m = (int)(127.0D - k);
/*      */ 
/*  849 */       switch (i1)
/*      */       {
/*      */       case 1:
/*  853 */         d = -(101 - this.tmpBytes[n]) * factorTable[m];
/*      */ 
/*  855 */         break;
/*      */       case 2:
/*  858 */         d = -((101 - this.tmpBytes[n]) * 100 + (101 - this.tmpBytes[(n + 1)])) * factorTable[(m + 1)];
/*      */ 
/*  861 */         break;
/*      */       case 3:
/*  864 */         d = -((101 - this.tmpBytes[n]) * 10000 + (101 - this.tmpBytes[(n + 1)]) * 100 + (101 - this.tmpBytes[(n + 2)])) * factorTable[(m + 2)];
/*      */ 
/*  868 */         break;
/*      */       case 4:
/*  871 */         d = -((101 - this.tmpBytes[n]) * 1000000 + (101 - this.tmpBytes[(n + 1)]) * 10000 + (101 - this.tmpBytes[(n + 2)]) * 100 + (101 - this.tmpBytes[(n + 3)])) * factorTable[(m + 3)];
/*      */ 
/*  875 */         break;
/*      */       case 5:
/*  878 */         d = -(((101 - this.tmpBytes[(n + 1)]) * 1000000 + (101 - this.tmpBytes[(n + 2)]) * 10000 + (101 - this.tmpBytes[(n + 3)]) * 100 + (101 - this.tmpBytes[(n + 4)])) * factorTable[(m + 4)] + (101 - this.tmpBytes[n]) * factorTable[m]);
/*      */ 
/*  884 */         break;
/*      */       case 6:
/*  887 */         d = -(((101 - this.tmpBytes[(n + 2)]) * 1000000 + (101 - this.tmpBytes[(n + 3)]) * 10000 + (101 - this.tmpBytes[(n + 4)]) * 100 + (101 - this.tmpBytes[(n + 5)])) * factorTable[(m + 5)] + ((101 - this.tmpBytes[n]) * 100 + (101 - this.tmpBytes[(n + 1)])) * factorTable[(m + 1)]);
/*      */ 
/*  893 */         break;
/*      */       default:
/*  896 */         d = -(((101 - this.tmpBytes[(n + 3)]) * 1000000 + (101 - this.tmpBytes[(n + 4)]) * 10000 + (101 - this.tmpBytes[(n + 5)]) * 100 + (101 - this.tmpBytes[(n + 6)])) * factorTable[(m + 6)] + ((101 - this.tmpBytes[n]) * 10000 + (101 - this.tmpBytes[(n + 1)]) * 100 + (101 - this.tmpBytes[(n + 2)])) * factorTable[(m + 2)]);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  907 */     return (float)d;
/*      */   }
/*      */ 
/*      */   double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  924 */     if (isNull(paramInt)) return 0.0D;
/*      */ 
/*  927 */     int i = getLength(paramInt);
/*  928 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/*      */ 
/*  930 */     int j = this.tmpBytes[0];
/*      */ 
/*  932 */     int m = 1;
/*  933 */     int n = i - 1;
/*      */ 
/*  938 */     int i6 = 1;
/*      */     int k;
/*      */     int i5;
/*      */     int i3;
/*  948 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/*  953 */       if ((j == -128) && (i == 1)) {
/*  954 */         return 0.0D;
/*      */       }
/*  956 */       if ((i == 2) && (j == -1) && (this.tmpBytes[1] == 101))
/*      */       {
/*  958 */         return (1.0D / 0.0D);
/*      */       }
/*  960 */       k = (byte)((j & 0xFFFFFF7F) - 65);
/*      */ 
/*  962 */       i5 = (this.tmpBytes[(m + n - 1)] - 1) % 10 == 0 ? 1 : 0;
/*      */ 
/*  964 */       i3 = this.tmpBytes[m] - 1;
/*      */     }
/*      */     else
/*      */     {
/*  977 */       i6 = 0;
/*      */ 
/*  979 */       if ((j == 0) && (i == 1)) {
/*  980 */         return (-1.0D / 0.0D);
/*      */       }
/*  982 */       k = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/*  984 */       if ((n != 20) || (this.tmpBytes[n] == 102)) {
/*  985 */         n--;
/*      */       }
/*  987 */       i5 = (101 - this.tmpBytes[(m + n - 1)]) % 10 == 0 ? 1 : 0;
/*      */ 
/*  989 */       i3 = 101 - this.tmpBytes[m];
/*      */     }
/*      */ 
/*  998 */     int i4 = n << 1;
/*      */ 
/* 1000 */     if (i5 != 0) {
/* 1001 */       i4--;
/*      */     }
/* 1003 */     int i7 = (k + 1 << 1) - i4;
/*      */ 
/* 1005 */     if (i3 < 10)
/* 1006 */       i4--;
/*      */     int i8;
/*      */     int i9;
/*      */     int i10;
/*      */     int i11;
/*      */     int i12;
/*      */     int i13;
/*      */     int i14;
/*      */     int i17;
/*      */     int i18;
/*      */     double d1;
/*      */     int i19;
/* 1008 */     if ((i4 <= 15) && (((i7 >= 0) && (i7 <= 37 - i4)) || ((i7 < 0) && (i7 >= -22))))
/*      */     {
/* 1013 */       i8 = 0;
/* 1014 */       i9 = 0;
/* 1015 */       i10 = 0;
/* 1016 */       i11 = 0;
/* 1017 */       i12 = 0;
/* 1018 */       i13 = 0;
/* 1019 */       i14 = 0;
/*      */ 
/* 1021 */       if (i6 != 0) {
/* 1022 */         switch (n)
/*      */         {
/*      */         default:
/* 1026 */           i14 = this.tmpBytes[(m + 7)] - 1;
/*      */         case 7:
/* 1029 */           i13 = this.tmpBytes[(m + 6)] - 1;
/*      */         case 6:
/* 1032 */           i12 = this.tmpBytes[(m + 5)] - 1;
/*      */         case 5:
/* 1035 */           i11 = this.tmpBytes[(m + 4)] - 1;
/*      */         case 4:
/* 1038 */           i10 = this.tmpBytes[(m + 3)] - 1;
/*      */         case 3:
/* 1041 */           i9 = this.tmpBytes[(m + 2)] - 1;
/*      */         case 2:
/* 1044 */           i8 = this.tmpBytes[(m + 1)] - 1;
/*      */         case 1:
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1050 */         switch (n)
/*      */         {
/*      */         default:
/* 1054 */           i14 = 101 - this.tmpBytes[(m + 7)];
/*      */         case 7:
/* 1057 */           i13 = 101 - this.tmpBytes[(m + 6)];
/*      */         case 6:
/* 1060 */           i12 = 101 - this.tmpBytes[(m + 5)];
/*      */         case 5:
/* 1063 */           i11 = 101 - this.tmpBytes[(m + 4)];
/*      */         case 4:
/* 1066 */           i10 = 101 - this.tmpBytes[(m + 3)];
/*      */         case 3:
/* 1069 */           i9 = 101 - this.tmpBytes[(m + 2)];
/*      */         case 2:
/* 1072 */           i8 = 101 - this.tmpBytes[(m + 1)];
/*      */         case 1:
/*      */         }
/*      */       }
/*      */       double d2;
/* 1081 */       if (i5 != 0)
/* 1082 */         switch (n)
/*      */         {
/*      */         default:
/* 1086 */           d2 = i3 / 10;
/*      */ 
/* 1088 */           break;
/*      */         case 2:
/* 1091 */           d2 = i3 * 10 + i8 / 10;
/*      */ 
/* 1093 */           break;
/*      */         case 3:
/* 1096 */           d2 = i3 * 1000 + i8 * 10 + i9 / 10;
/*      */ 
/* 1098 */           break;
/*      */         case 4:
/* 1101 */           d2 = i3 * 100000 + i8 * 1000 + i9 * 10 + i10 / 10;
/*      */ 
/* 1104 */           break;
/*      */         case 5:
/* 1107 */           d2 = i3 * 10000000 + i8 * 100000 + i9 * 1000 + i10 * 10 + i11 / 10;
/*      */ 
/* 1110 */           break;
/*      */         case 6:
/* 1113 */           i17 = i8 * 10000000 + i9 * 100000 + i10 * 1000 + i11 * 10 + i12 / 10;
/*      */ 
/* 1115 */           d2 = i3 * 1000000000L + i17;
/*      */ 
/* 1117 */           break;
/*      */         case 7:
/* 1120 */           i17 = i9 * 10000000 + i10 * 100000 + i11 * 1000 + i12 * 10 + i13 / 10;
/*      */ 
/* 1122 */           i18 = i3 * 100 + i8;
/* 1123 */           d2 = i18 * 1000000000L + i17;
/*      */ 
/* 1125 */           break;
/*      */         case 8:
/* 1128 */           i17 = i10 * 10000000 + i11 * 100000 + i12 * 1000 + i13 * 10 + i14 / 10;
/*      */ 
/* 1130 */           i18 = i3 * 10000 + i8 * 100 + i9;
/* 1131 */           d2 = i18 * 1000000000L + i17;
/*      */ 
/* 1133 */           break;
/*      */         }
/*      */       else {
/* 1136 */         switch (n)
/*      */         {
/*      */         default:
/* 1140 */           d2 = i3;
/*      */ 
/* 1142 */           break;
/*      */         case 2:
/* 1145 */           d2 = i3 * 100 + i8;
/*      */ 
/* 1147 */           break;
/*      */         case 3:
/* 1150 */           d2 = i3 * 10000 + i8 * 100 + i9;
/*      */ 
/* 1152 */           break;
/*      */         case 4:
/* 1155 */           d2 = i3 * 1000000 + i8 * 10000 + i9 * 100 + i10;
/*      */ 
/* 1158 */           break;
/*      */         case 5:
/* 1161 */           i17 = i8 * 1000000 + i9 * 10000 + i10 * 100 + i11;
/* 1162 */           d2 = i3 * 100000000L + i17;
/*      */ 
/* 1164 */           break;
/*      */         case 6:
/* 1167 */           i17 = i9 * 1000000 + i10 * 10000 + i11 * 100 + i12;
/* 1168 */           i18 = i3 * 100 + i8;
/* 1169 */           d2 = i18 * 100000000L + i17;
/*      */ 
/* 1171 */           break;
/*      */         case 7:
/* 1174 */           i17 = i10 * 1000000 + i11 * 10000 + i12 * 100 + i13;
/* 1175 */           i18 = i3 * 10000 + i8 * 100 + i9;
/* 1176 */           d2 = i18 * 100000000L + i17;
/*      */ 
/* 1178 */           break;
/*      */         case 8:
/* 1181 */           i17 = i11 * 1000000 + i12 * 10000 + i13 * 100 + i14;
/* 1182 */           i18 = i3 * 1000000 + i8 * 10000 + i9 * 100 + i10;
/* 1183 */           d2 = i18 * 100000000L + i17;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1191 */       if ((i7 == 0) || (d2 == 0.0D))
/* 1192 */         d1 = d2;
/* 1193 */       else if (i7 >= 0)
/*      */       {
/* 1195 */         if (i7 <= 22)
/*      */         {
/* 1202 */           d1 = d2 * small10pow[i7];
/*      */         }
/*      */         else
/*      */         {
/* 1206 */           i19 = 15 - i4;
/*      */ 
/* 1214 */           d2 *= small10pow[i19];
/* 1215 */           d1 = d2 * small10pow[(i7 - i19)];
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1228 */         d1 = d2 / small10pow[(-i7)];
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1233 */       i8 = 0;
/* 1234 */       i9 = 0;
/* 1235 */       i10 = 0;
/* 1236 */       i11 = 0;
/* 1237 */       i12 = 0;
/* 1238 */       i13 = 0;
/* 1239 */       i14 = 0;
/* 1240 */       int i15 = 0;
/* 1241 */       int i16 = 0;
/* 1242 */       i17 = 0;
/*      */ 
/* 1249 */       int i23 = 0;
/* 1250 */       int i24 = 0;
/* 1251 */       int i25 = 0;
/* 1252 */       int i26 = 0;
/* 1253 */       int i27 = 0;
/*      */ 
/* 1257 */       int i31 = 0;
/* 1258 */       int i32 = 0;
/*      */       int i1;
/* 1260 */       if (i6 != 0)
/*      */       {
/* 1262 */         if ((n & 0x1) != 0)
/*      */         {
/* 1264 */           i1 = 2;
/* 1265 */           i8 = i3;
/*      */         }
/*      */         else
/*      */         {
/* 1269 */           i1 = 3;
/* 1270 */           i8 = i3 * 100 + (this.tmpBytes[(m + 1)] - 1);
/*      */         }
/*      */ 
/* 1273 */         for (; i1 < n; i1 += 2)
/*      */         {
/* 1275 */           i33 = (this.tmpBytes[(m + i1 - 1)] - 1) * 100 + (this.tmpBytes[(m + i1)] - 1) + i8 * 10000;
/*      */ 
/* 1278 */           switch (i17)
/*      */           {
/*      */           default:
/* 1282 */             i8 = i33 & 0xFFFF;
/* 1283 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1284 */             i9 = i33 & 0xFFFF;
/* 1285 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1286 */             i10 = i33 & 0xFFFF;
/* 1287 */             i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1288 */             i11 = i33 & 0xFFFF;
/* 1289 */             i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1290 */             i12 = i33 & 0xFFFF;
/* 1291 */             i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1292 */             i13 = i33 & 0xFFFF;
/* 1293 */             i33 = (i33 >> 16 & 0xFFFF) + i14 * 10000;
/* 1294 */             i14 = i33 & 0xFFFF;
/* 1295 */             i33 = (i33 >> 16 & 0xFFFF) + i15 * 10000;
/* 1296 */             i15 = i33 & 0xFFFF;
/* 1297 */             i33 = (i33 >> 16 & 0xFFFF) + i16 * 10000;
/* 1298 */             i16 = i33 & 0xFFFF;
/*      */ 
/* 1300 */             break;
/*      */           case 7:
/* 1303 */             i8 = i33 & 0xFFFF;
/* 1304 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1305 */             i9 = i33 & 0xFFFF;
/* 1306 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1307 */             i10 = i33 & 0xFFFF;
/* 1308 */             i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1309 */             i11 = i33 & 0xFFFF;
/* 1310 */             i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1311 */             i12 = i33 & 0xFFFF;
/* 1312 */             i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1313 */             i13 = i33 & 0xFFFF;
/* 1314 */             i33 = (i33 >> 16 & 0xFFFF) + i14 * 10000;
/* 1315 */             i14 = i33 & 0xFFFF;
/* 1316 */             i33 = (i33 >> 16 & 0xFFFF) + i15 * 10000;
/* 1317 */             i15 = i33 & 0xFFFF;
/*      */ 
/* 1319 */             break;
/*      */           case 6:
/* 1322 */             i8 = i33 & 0xFFFF;
/* 1323 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1324 */             i9 = i33 & 0xFFFF;
/* 1325 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1326 */             i10 = i33 & 0xFFFF;
/* 1327 */             i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1328 */             i11 = i33 & 0xFFFF;
/* 1329 */             i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1330 */             i12 = i33 & 0xFFFF;
/* 1331 */             i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1332 */             i13 = i33 & 0xFFFF;
/* 1333 */             i33 = (i33 >> 16 & 0xFFFF) + i14 * 10000;
/* 1334 */             i14 = i33 & 0xFFFF;
/*      */ 
/* 1336 */             break;
/*      */           case 5:
/* 1339 */             i8 = i33 & 0xFFFF;
/* 1340 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1341 */             i9 = i33 & 0xFFFF;
/* 1342 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1343 */             i10 = i33 & 0xFFFF;
/* 1344 */             i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1345 */             i11 = i33 & 0xFFFF;
/* 1346 */             i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1347 */             i12 = i33 & 0xFFFF;
/* 1348 */             i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1349 */             i13 = i33 & 0xFFFF;
/*      */ 
/* 1351 */             break;
/*      */           case 4:
/* 1354 */             i8 = i33 & 0xFFFF;
/* 1355 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1356 */             i9 = i33 & 0xFFFF;
/* 1357 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1358 */             i10 = i33 & 0xFFFF;
/* 1359 */             i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1360 */             i11 = i33 & 0xFFFF;
/* 1361 */             i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1362 */             i12 = i33 & 0xFFFF;
/*      */ 
/* 1364 */             break;
/*      */           case 3:
/* 1367 */             i8 = i33 & 0xFFFF;
/* 1368 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1369 */             i9 = i33 & 0xFFFF;
/* 1370 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1371 */             i10 = i33 & 0xFFFF;
/* 1372 */             i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1373 */             i11 = i33 & 0xFFFF;
/*      */ 
/* 1375 */             break;
/*      */           case 2:
/* 1378 */             i8 = i33 & 0xFFFF;
/* 1379 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1380 */             i9 = i33 & 0xFFFF;
/* 1381 */             i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1382 */             i10 = i33 & 0xFFFF;
/*      */ 
/* 1384 */             break;
/*      */           case 1:
/* 1387 */             i8 = i33 & 0xFFFF;
/* 1388 */             i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1389 */             i9 = i33 & 0xFFFF;
/*      */ 
/* 1391 */             break;
/*      */           case 0:
/* 1394 */             i8 = i33 & 0xFFFF;
/*      */           }
/*      */ 
/* 1399 */           i33 = i33 >> 16 & 0xFFFF;
/*      */ 
/* 1401 */           if (i33 != 0)
/*      */           {
/* 1403 */             i17++;
/*      */ 
/* 1405 */             switch (i17)
/*      */             {
/*      */             case 8:
/* 1409 */               i16 = i33;
/*      */ 
/* 1411 */               break;
/*      */             case 7:
/* 1414 */               i15 = i33;
/*      */ 
/* 1416 */               break;
/*      */             case 6:
/* 1419 */               i14 = i33;
/*      */ 
/* 1421 */               break;
/*      */             case 5:
/* 1424 */               i13 = i33;
/*      */ 
/* 1426 */               break;
/*      */             case 4:
/* 1429 */               i12 = i33;
/*      */ 
/* 1431 */               break;
/*      */             case 3:
/* 1434 */               i11 = i33;
/*      */ 
/* 1436 */               break;
/*      */             case 2:
/* 1439 */               i10 = i33;
/*      */ 
/* 1441 */               break;
/*      */             case 1:
/* 1444 */               i9 = i33;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1456 */       if ((n & 0x1) != 0)
/*      */       {
/* 1458 */         i1 = 2;
/* 1459 */         i8 = i3;
/*      */       }
/*      */       else
/*      */       {
/* 1463 */         i1 = 3;
/* 1464 */         i8 = i3 * 100 + (101 - this.tmpBytes[(m + 1)]);
/*      */       }
/*      */ 
/* 1467 */       for (; i1 < n; i1 += 2)
/*      */       {
/* 1469 */         i33 = (101 - this.tmpBytes[(m + i1 - 1)]) * 100 + (101 - this.tmpBytes[(m + i1)]) + i8 * 10000;
/*      */ 
/* 1472 */         switch (i17)
/*      */         {
/*      */         default:
/* 1476 */           i8 = i33 & 0xFFFF;
/* 1477 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1478 */           i9 = i33 & 0xFFFF;
/* 1479 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1480 */           i10 = i33 & 0xFFFF;
/* 1481 */           i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1482 */           i11 = i33 & 0xFFFF;
/* 1483 */           i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1484 */           i12 = i33 & 0xFFFF;
/* 1485 */           i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1486 */           i13 = i33 & 0xFFFF;
/* 1487 */           i33 = (i33 >> 16 & 0xFFFF) + i14 * 10000;
/* 1488 */           i14 = i33 & 0xFFFF;
/* 1489 */           i33 = (i33 >> 16 & 0xFFFF) + i15 * 10000;
/* 1490 */           i15 = i33 & 0xFFFF;
/* 1491 */           i33 = (i33 >> 16 & 0xFFFF) + i16 * 10000;
/* 1492 */           i16 = i33 & 0xFFFF;
/*      */ 
/* 1494 */           break;
/*      */         case 7:
/* 1497 */           i8 = i33 & 0xFFFF;
/* 1498 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1499 */           i9 = i33 & 0xFFFF;
/* 1500 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1501 */           i10 = i33 & 0xFFFF;
/* 1502 */           i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1503 */           i11 = i33 & 0xFFFF;
/* 1504 */           i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1505 */           i12 = i33 & 0xFFFF;
/* 1506 */           i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1507 */           i13 = i33 & 0xFFFF;
/* 1508 */           i33 = (i33 >> 16 & 0xFFFF) + i14 * 10000;
/* 1509 */           i14 = i33 & 0xFFFF;
/* 1510 */           i33 = (i33 >> 16 & 0xFFFF) + i15 * 10000;
/* 1511 */           i15 = i33 & 0xFFFF;
/*      */ 
/* 1513 */           break;
/*      */         case 6:
/* 1516 */           i8 = i33 & 0xFFFF;
/* 1517 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1518 */           i9 = i33 & 0xFFFF;
/* 1519 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1520 */           i10 = i33 & 0xFFFF;
/* 1521 */           i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1522 */           i11 = i33 & 0xFFFF;
/* 1523 */           i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1524 */           i12 = i33 & 0xFFFF;
/* 1525 */           i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1526 */           i13 = i33 & 0xFFFF;
/* 1527 */           i33 = (i33 >> 16 & 0xFFFF) + i14 * 10000;
/* 1528 */           i14 = i33 & 0xFFFF;
/*      */ 
/* 1530 */           break;
/*      */         case 5:
/* 1533 */           i8 = i33 & 0xFFFF;
/* 1534 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1535 */           i9 = i33 & 0xFFFF;
/* 1536 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1537 */           i10 = i33 & 0xFFFF;
/* 1538 */           i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1539 */           i11 = i33 & 0xFFFF;
/* 1540 */           i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1541 */           i12 = i33 & 0xFFFF;
/* 1542 */           i33 = (i33 >> 16 & 0xFFFF) + i13 * 10000;
/* 1543 */           i13 = i33 & 0xFFFF;
/*      */ 
/* 1545 */           break;
/*      */         case 4:
/* 1548 */           i8 = i33 & 0xFFFF;
/* 1549 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1550 */           i9 = i33 & 0xFFFF;
/* 1551 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1552 */           i10 = i33 & 0xFFFF;
/* 1553 */           i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1554 */           i11 = i33 & 0xFFFF;
/* 1555 */           i33 = (i33 >> 16 & 0xFFFF) + i12 * 10000;
/* 1556 */           i12 = i33 & 0xFFFF;
/*      */ 
/* 1558 */           break;
/*      */         case 3:
/* 1561 */           i8 = i33 & 0xFFFF;
/* 1562 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1563 */           i9 = i33 & 0xFFFF;
/* 1564 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1565 */           i10 = i33 & 0xFFFF;
/* 1566 */           i33 = (i33 >> 16 & 0xFFFF) + i11 * 10000;
/* 1567 */           i11 = i33 & 0xFFFF;
/*      */ 
/* 1569 */           break;
/*      */         case 2:
/* 1572 */           i8 = i33 & 0xFFFF;
/* 1573 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1574 */           i9 = i33 & 0xFFFF;
/* 1575 */           i33 = (i33 >> 16 & 0xFFFF) + i10 * 10000;
/* 1576 */           i10 = i33 & 0xFFFF;
/*      */ 
/* 1578 */           break;
/*      */         case 1:
/* 1581 */           i8 = i33 & 0xFFFF;
/* 1582 */           i33 = (i33 >> 16 & 0xFFFF) + i9 * 10000;
/* 1583 */           i9 = i33 & 0xFFFF;
/*      */ 
/* 1585 */           break;
/*      */         case 0:
/* 1588 */           i8 = i33 & 0xFFFF;
/*      */         }
/*      */ 
/* 1593 */         i33 = i33 >> 16 & 0xFFFF;
/*      */ 
/* 1595 */         if (i33 != 0)
/*      */         {
/* 1597 */           i17++;
/*      */ 
/* 1599 */           switch (i17)
/*      */           {
/*      */           case 8:
/* 1603 */             i16 = i33;
/*      */ 
/* 1605 */             break;
/*      */           case 7:
/* 1608 */             i15 = i33;
/*      */ 
/* 1610 */             break;
/*      */           case 6:
/* 1613 */             i14 = i33;
/*      */ 
/* 1615 */             break;
/*      */           case 5:
/* 1618 */             i13 = i33;
/*      */ 
/* 1620 */             break;
/*      */           case 4:
/* 1623 */             i12 = i33;
/*      */ 
/* 1625 */             break;
/*      */           case 3:
/* 1628 */             i11 = i33;
/*      */ 
/* 1630 */             break;
/*      */           case 2:
/* 1633 */             i10 = i33;
/*      */ 
/* 1635 */             break;
/*      */           case 1:
/* 1638 */             i9 = i33;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1682 */       int i30 = i17;
/*      */ 
/* 1684 */       i17++;
/*      */ 
/* 1686 */       int i20 = 62 - k + n;
/*      */ 
/* 1688 */       int i21 = nexpdigstable[i20];
/* 1689 */       int[] arrayOfInt = expdigstable[i20];
/* 1690 */       i32 = i17 + 5;
/*      */ 
/* 1692 */       int i33 = 0;
/*      */ 
/* 1694 */       if (i21 > i32)
/*      */       {
/* 1696 */         i33 = i21 - i32;
/* 1697 */         i21 = i32;
/*      */       }
/*      */ 
/* 1700 */       i19 = 0;
/* 1701 */       int i22 = 0;
/* 1702 */       int i28 = i21 - 1 + (i17 - 1) - 4;
/*      */       int i34;
/*      */       int i2;
/* 1704 */       for (i18 = 0; i18 < i28; i18++)
/*      */       {
/* 1706 */         i34 = i22 & 0xFFFF;
/*      */ 
/* 1708 */         i22 = i22 >> 16 & 0xFFFF;
/*      */ 
/* 1710 */         i35 = i17 < i18 + 1 ? i17 : i18 + 1;
/*      */ 
/* 1712 */         for (i2 = i18 - i21 + 1 > 0 ? i18 - i21 + 1 : 0; i2 < i35; 
/* 1713 */           i2++)
/*      */         {
/* 1715 */           i36 = i33 + i18 - i2;
/*      */ 
/* 1718 */           switch (i2)
/*      */           {
/*      */           case 8:
/* 1722 */             i37 = i16 * arrayOfInt[i36];
/*      */ 
/* 1724 */             break;
/*      */           case 7:
/* 1727 */             i37 = i15 * arrayOfInt[i36];
/*      */ 
/* 1729 */             break;
/*      */           case 6:
/* 1732 */             i37 = i14 * arrayOfInt[i36];
/*      */ 
/* 1734 */             break;
/*      */           case 5:
/* 1737 */             i37 = i13 * arrayOfInt[i36];
/*      */ 
/* 1739 */             break;
/*      */           case 4:
/* 1742 */             i37 = i12 * arrayOfInt[i36];
/*      */ 
/* 1744 */             break;
/*      */           case 3:
/* 1747 */             i37 = i11 * arrayOfInt[i36];
/*      */ 
/* 1749 */             break;
/*      */           case 2:
/* 1752 */             i37 = i10 * arrayOfInt[i36];
/*      */ 
/* 1754 */             break;
/*      */           case 1:
/* 1757 */             i37 = i9 * arrayOfInt[i36];
/*      */ 
/* 1759 */             break;
/*      */           default:
/* 1762 */             i37 = i8 * arrayOfInt[i36];
/*      */           }
/*      */ 
/* 1767 */           i34 += (i37 & 0xFFFF);
/* 1768 */           i22 += (i37 >> 16 & 0xFFFF);
/*      */         }
/*      */ 
/* 1771 */         i31 = (i31 != 0) || ((i34 & 0xFFFF) != 0) ? 1 : 0;
/* 1772 */         i22 += (i34 >> 16 & 0xFFFF);
/*      */       }
/*      */ 
/* 1775 */       i28 += 5;
/*      */ 
/* 1777 */       for (; i18 < i28; i18++)
/*      */       {
/* 1779 */         i34 = i22 & 0xFFFF;
/*      */ 
/* 1781 */         i22 = i22 >> 16 & 0xFFFF;
/*      */ 
/* 1783 */         i35 = i17 < i18 + 1 ? i17 : i18 + 1;
/*      */ 
/* 1785 */         for (i2 = i18 - i21 + 1 > 0 ? i18 - i21 + 1 : 0; i2 < i35; 
/* 1786 */           i2++)
/*      */         {
/* 1788 */           i36 = i33 + i18 - i2;
/*      */ 
/* 1791 */           switch (i2)
/*      */           {
/*      */           case 8:
/* 1795 */             i37 = i16 * arrayOfInt[i36];
/*      */ 
/* 1800 */             break;
/*      */           case 7:
/* 1803 */             i37 = i15 * arrayOfInt[i36];
/*      */ 
/* 1808 */             break;
/*      */           case 6:
/* 1811 */             i37 = i14 * arrayOfInt[i36];
/*      */ 
/* 1816 */             break;
/*      */           case 5:
/* 1819 */             i37 = i13 * arrayOfInt[i36];
/*      */ 
/* 1824 */             break;
/*      */           case 4:
/* 1827 */             i37 = i12 * arrayOfInt[i36];
/*      */ 
/* 1832 */             break;
/*      */           case 3:
/* 1835 */             i37 = i11 * arrayOfInt[i36];
/*      */ 
/* 1840 */             break;
/*      */           case 2:
/* 1843 */             i37 = i10 * arrayOfInt[i36];
/*      */ 
/* 1848 */             break;
/*      */           case 1:
/* 1851 */             i37 = i9 * arrayOfInt[i36];
/*      */ 
/* 1856 */             break;
/*      */           default:
/* 1859 */             i37 = i8 * arrayOfInt[i36];
/*      */           }
/*      */ 
/* 1867 */           i34 += (i37 & 0xFFFF);
/* 1868 */           i22 += (i37 >> 16 & 0xFFFF);
/*      */         }
/*      */ 
/* 1871 */         switch (i19++)
/*      */         {
/*      */         case 4:
/* 1875 */           i27 = i34 & 0xFFFF;
/*      */ 
/* 1877 */           break;
/*      */         case 3:
/* 1880 */           i26 = i34 & 0xFFFF;
/*      */ 
/* 1882 */           break;
/*      */         case 2:
/* 1885 */           i25 = i34 & 0xFFFF;
/*      */ 
/* 1887 */           break;
/*      */         case 1:
/* 1890 */           i24 = i34 & 0xFFFF;
/*      */ 
/* 1892 */           break;
/*      */         default:
/* 1895 */           i23 = i34 & 0xFFFF;
/*      */         }
/*      */ 
/* 1900 */         i22 += (i34 >> 16 & 0xFFFF);
/*      */       }
/*      */ 
/* 1903 */       while (i22 != 0)
/*      */       {
/* 1905 */         if (i19 < 5) {
/* 1906 */           switch (i19++)
/*      */           {
/*      */           case 4:
/* 1910 */             i27 = i22 & 0xFFFF;
/*      */ 
/* 1912 */             break;
/*      */           case 3:
/* 1915 */             i26 = i22 & 0xFFFF;
/*      */ 
/* 1917 */             break;
/*      */           case 2:
/* 1920 */             i25 = i22 & 0xFFFF;
/*      */ 
/* 1922 */             break;
/*      */           case 1:
/* 1925 */             i24 = i22 & 0xFFFF;
/*      */ 
/* 1927 */             break;
/*      */           default:
/* 1930 */             i23 = i22 & 0xFFFF;
/*      */ 
/* 1932 */             break;
/*      */           }
/*      */         }
/*      */         else {
/* 1936 */           i31 = (i31 != 0) || (i23 != 0) ? 1 : 0;
/* 1937 */           i23 = i24;
/* 1938 */           i24 = i25;
/* 1939 */           i25 = i26;
/* 1940 */           i26 = i27;
/* 1941 */           i27 = i22 & 0xFFFF;
/*      */         }
/*      */ 
/* 1944 */         i22 = i22 >> 16 & 0xFFFF;
/* 1945 */         i30++;
/*      */       }
/*      */ 
/* 1948 */       int i29 = (binexpstable[i20] + i30) * 16 - 1;
/*      */ 
/* 1952 */       switch (i19)
/*      */       {
/*      */       case 5:
/* 1956 */         i34 = i27;
/*      */ 
/* 1958 */         break;
/*      */       case 4:
/* 1961 */         i34 = i26;
/*      */ 
/* 1963 */         break;
/*      */       case 3:
/* 1966 */         i34 = i25;
/*      */ 
/* 1968 */         break;
/*      */       case 2:
/* 1971 */         i34 = i24;
/*      */ 
/* 1973 */         break;
/*      */       default:
/* 1976 */         i34 = i23;
/*      */       }
/*      */ 
/* 1981 */       for (int i35 = i34 >> 1; i35 != 0; i35 >>= 1) {
/* 1982 */         i29++;
/*      */       }
/*      */ 
/* 1985 */       i35 = 5;
/* 1986 */       int i36 = i34 << 5;
/* 1987 */       int i37 = 0;
/*      */ 
/* 1989 */       i22 = 0;
/*      */ 
/* 1991 */       while ((i36 & 0x100000) == 0)
/*      */       {
/* 1993 */         i36 <<= 1;
/* 1994 */         i35++;
/*      */       }
/*      */ 
/* 1997 */       switch (i19)
/*      */       {
/*      */       case 5:
/* 2001 */         if (i35 > 16)
/*      */         {
/* 2004 */           i36 |= i26 << i35 - 16 | i25 >> 32 - i35;
/* 2005 */           i37 = i25 << i35 | i24 << i35 - 16 | i23 >> 32 - i35;
/*      */ 
/* 2007 */           i22 = i23 & 1 << 31 - i35;
/* 2008 */           i31 = (i31 != 0) || (i23 << i35 + 1 != 0) ? 1 : 0;
/*      */         }
/* 2011 */         else if (i35 == 16)
/*      */         {
/* 2014 */           i36 |= i26;
/* 2015 */           i37 = i25 << 16 | i24;
/* 2016 */           i22 = i23 & 0x8000;
/* 2017 */           i31 = (i31 != 0) || ((i23 & 0x7FFF) != 0) ? 1 : 0;
/*      */         }
/*      */         else
/*      */         {
/* 2023 */           i36 |= i26 >> 16 - i35;
/* 2024 */           i37 = i26 << 16 + i35 | i25 << i35 | i24 >> 16 - i35;
/*      */ 
/* 2026 */           i22 = i24 & 1 << 15 - i35;
/*      */ 
/* 2028 */           if (i35 < 15) {
/* 2029 */             i31 = (i31 != 0) || (i24 << i35 + 17 != 0) ? 1 : 0;
/*      */           }
/* 2031 */           i31 = (i31 != 0) || (i23 != 0) ? 1 : 0;
/*      */         }
/*      */ 
/* 2035 */         break;
/*      */       case 4:
/* 2038 */         if (i35 > 16)
/*      */         {
/* 2041 */           i36 |= i25 << i35 - 16 | i24 >> 32 - i35;
/* 2042 */           i37 = i24 << i35 | i23 << i35 - 16;
/*      */         }
/* 2045 */         else if (i35 == 16)
/*      */         {
/* 2048 */           i36 |= i25;
/*      */ 
/* 2050 */           i37 = i24 << 16 | i23;
/*      */         }
/*      */         else
/*      */         {
/* 2056 */           i36 |= i25 >> 16 - i35;
/* 2057 */           i37 = i25 << 16 + i35 | i24 << i35 | i23 >> 16 - i35;
/*      */ 
/* 2059 */           i22 = i23 & 1 << 15 - i35;
/*      */ 
/* 2061 */           if (i35 < 15)
/* 2062 */             i31 = (i31 != 0) || (i23 << i35 + 17 != 0) ? 1 : 0;  } break;
/*      */       case 3:
/* 2069 */         if (i35 > 16)
/*      */         {
/* 2072 */           i36 |= i24 << i35 - 16 | i23 >> 32 - i35;
/* 2073 */           i37 = i23 << i35;
/*      */         }
/* 2076 */         else if (i35 == 16)
/*      */         {
/* 2079 */           i36 |= i24;
/*      */ 
/* 2081 */           i37 = i23 << 16;
/*      */         }
/*      */         else
/*      */         {
/* 2087 */           i36 |= i24 >> 16 - i35;
/* 2088 */           i37 = i24 << 16 + i35;
/*      */ 
/* 2090 */           i37 |= i23 << i35;
/*      */         }
/*      */ 
/* 2094 */         break;
/*      */       case 2:
/* 2097 */         if (i35 > 16)
/*      */         {
/* 2100 */           i36 |= i23 << i35 - 16;
/*      */         }
/* 2103 */         else if (i35 == 16)
/*      */         {
/* 2106 */           i36 |= i23;
/*      */         }
/*      */         else
/*      */         {
/* 2112 */           i36 |= i23 >> 16 - i35;
/* 2113 */           i37 = i23 << 16 + i35;
/*      */         }
/*      */ 
/* 2117 */         break;
/*      */       }
/*      */ 
/* 2123 */       if ((i22 != 0) && ((i31 != 0) || ((i37 & 0x1) != 0)))
/*      */       {
/* 2125 */         if (i37 == -1)
/*      */         {
/* 2127 */           i37 = 0;
/* 2128 */           i36++;
/*      */ 
/* 2130 */           if ((i36 & 0x200000) != 0)
/*      */           {
/* 2132 */             i37 = i37 >> 1 | i36 << 31;
/* 2133 */             i36 >>= 1;
/* 2134 */             i29++;
/*      */           }
/*      */         }
/*      */         else {
/* 2138 */           i37++;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2151 */       long l = i29 << 52 | (i36 & 0xFFFFF) << 32 | i37 & 0xFFFFFFFF;
/*      */ 
/* 2154 */       d1 = Double.longBitsToDouble(l);
/*      */     }
/*      */ 
/* 2163 */     return i6 != 0 ? d1 : -d1;
/*      */   }
/*      */ 
/*      */   double getDoubleImprecise(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2181 */     if (isNull(paramInt)) return 0.0D;
/*      */ 
/* 2183 */     int i = getLength(paramInt);
/* 2184 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/* 2185 */     int j = this.tmpBytes[0];
/*      */ 
/* 2188 */     double d = 0.0D;
/*      */ 
/* 2190 */     int n = 1;
/*      */ 
/* 2201 */     if ((j & 0xFFFFFF80) != 0)
/*      */     {
/* 2206 */       if ((j == -128) && (i == 1)) {
/* 2207 */         return 0.0D;
/*      */       }
/* 2209 */       if ((i == 2) && (j == -1) && (this.tmpBytes[1] == 101))
/*      */       {
/* 2211 */         return (1.0D / 0.0D);
/*      */       }
/* 2213 */       k = (byte)((j & 0xFFFFFF7F) - 65);
/*      */ 
/* 2215 */       i2 = i - 1;
/*      */ 
/* 2223 */       m = (int)(127.0D - k);
/*      */ 
/* 2225 */       i1 = i2 % 4;
/*      */ 
/* 2227 */       switch (i1)
/*      */       {
/*      */       case 1:
/* 2231 */         d = (this.tmpBytes[n] - 1) * factorTable[m];
/*      */ 
/* 2233 */         break;
/*      */       case 2:
/* 2236 */         d = ((this.tmpBytes[n] - 1) * 100 + (this.tmpBytes[(n + 1)] - 1)) * factorTable[(m + 1)];
/*      */ 
/* 2239 */         break;
/*      */       case 3:
/* 2242 */         d = ((this.tmpBytes[n] - 1) * 10000 + (this.tmpBytes[(n + 1)] - 1) * 100 + (this.tmpBytes[(n + 2)] - 1)) * factorTable[(m + 2)];
/*      */ 
/* 2246 */         break;
/*      */       }
/*      */ 
/* 2252 */       for (; i1 < i2; i1 += 4) {
/* 2253 */         d += ((this.tmpBytes[(n + i1)] - 1) * 1000000 + (this.tmpBytes[(n + i1 + 1)] - 1) * 10000 + (this.tmpBytes[(n + i1 + 2)] - 1) * 100 + (this.tmpBytes[(n + i1 + 3)] - 1)) * factorTable[(m + i1 + 3)];
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2263 */     if ((j == 0) && (i == 1)) {
/* 2264 */       return (-1.0D / 0.0D);
/*      */     }
/* 2266 */     int k = (byte)(((j ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/* 2268 */     int i2 = i - 1;
/*      */ 
/* 2270 */     if ((i2 != 20) || (this.tmpBytes[i2] == 102)) {
/* 2271 */       i2--;
/*      */     }
/*      */ 
/* 2279 */     int m = (int)(127.0D - k);
/*      */ 
/* 2281 */     int i1 = i2 % 4;
/*      */ 
/* 2283 */     switch (i1)
/*      */     {
/*      */     case 1:
/* 2287 */       d = (101 - this.tmpBytes[n]) * factorTable[m];
/*      */ 
/* 2289 */       break;
/*      */     case 2:
/* 2292 */       d = ((101 - this.tmpBytes[n]) * 100 + (101 - this.tmpBytes[(n + 1)])) * factorTable[(m + 1)];
/*      */ 
/* 2295 */       break;
/*      */     case 3:
/* 2298 */       d = ((101 - this.tmpBytes[n]) * 10000 + (101 - this.tmpBytes[(n + 1)]) * 100 + (101 - this.tmpBytes[(n + 2)])) * factorTable[(m + 2)];
/*      */ 
/* 2302 */       break;
/*      */     }
/*      */ 
/* 2308 */     for (; i1 < i2; i1 += 4) {
/* 2309 */       d += ((101 - this.tmpBytes[(n + i1)]) * 1000000 + (101 - this.tmpBytes[(n + i1 + 1)]) * 10000 + (101 - this.tmpBytes[(n + i1 + 2)]) * 100 + (101 - this.tmpBytes[(n + i1 + 3)])) * factorTable[(m + i1 + 3)];
/*      */     }
/*      */ 
/* 2313 */     d = -d;
/*      */ 
/* 2317 */     return d;
/*      */   }
/*      */ 
/*      */   BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2338 */     if (isNull(paramInt)) return null;
/*      */ 
/* 2341 */     int i = getLength(paramInt);
/* 2342 */     assert (i > 0) : "Length not positive";
/* 2343 */     this.rowData.get(getOffset(paramInt), this.tmpBytes, 0, i);
/* 2344 */     for (int j = 0; j < 27; j++) {
/* 2345 */       this.digs[j] = 0;
/*      */     }
/* 2347 */     j = 0;
/* 2348 */     int k = 1;
/*      */ 
/* 2350 */     int n = 26;
/* 2351 */     int i1 = 0;
/*      */ 
/* 2354 */     int i4 = this.tmpBytes[0];
/*      */ 
/* 2359 */     int i9 = 0;
/*      */ 
/* 2361 */     if ((i4 & 0xFFFFFF80) != 0)
/*      */     {
/* 2369 */       if ((i4 == -128) && (i == 1)) {
/* 2370 */         return BIGDEC_ZERO;
/*      */       }
/* 2372 */       if ((i == 2) && (i4 == -1) && (this.tmpBytes[1] == 101))
/*      */       {
/* 2376 */         throwOverflow();
/*      */       }
/* 2378 */       i5 = 1;
/* 2379 */       i6 = (byte)((i4 & 0xFFFFFF7F) - 65);
/*      */ 
/* 2382 */       i3 = i - 1;
/* 2383 */       m = i3 - 1;
/* 2384 */       i7 = i6 - i3 + 1 << 1;
/*      */ 
/* 2386 */       if (i7 > 0)
/*      */       {
/* 2388 */         i7 = 0;
/* 2389 */         m = i6;
/*      */       }
/* 2391 */       else if (i7 < 0) {
/* 2392 */         i9 = (this.tmpBytes[i3] - 1) % 10 == 0 ? 1 : 0;
/*      */       }
/* 2394 */       k = (byte)(k + 1); j = this.tmpBytes[k] - 1;
/*      */ 
/* 2396 */       while ((m & 0x1) != 0)
/*      */       {
/* 2398 */         if (k > i3) {
/* 2399 */           j *= 100;
/*      */         } else {
/* 2401 */           k = (byte)(k + 1); j = j * 100 + (this.tmpBytes[k] - 1);
/*      */         }
/* 2403 */         m--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2414 */     if ((i4 == 0) && (i == 1))
/*      */     {
/* 2417 */       throwOverflow();
/*      */     }
/* 2419 */     int i5 = -1;
/* 2420 */     int i6 = (byte)(((i4 ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/*      */ 
/* 2423 */     int i3 = i - 1;
/*      */ 
/* 2425 */     if ((i3 != 20) || (this.tmpBytes[i3] == 102)) {
/* 2426 */       i3--;
/*      */     }
/* 2428 */     int m = i3 - 1;
/*      */ 
/* 2430 */     int i7 = i6 - i3 + 1 << 1;
/*      */ 
/* 2432 */     if (i7 > 0)
/*      */     {
/* 2434 */       i7 = 0;
/* 2435 */       m = i6;
/*      */     }
/* 2437 */     else if (i7 < 0) {
/* 2438 */       i9 = (101 - this.tmpBytes[i3]) % 10 == 0 ? 1 : 0;
/*      */     }
/* 2440 */     k = (byte)(k + 1); j = 101 - this.tmpBytes[k];
/*      */ 
/* 2442 */     while ((m & 0x1) != 0)
/*      */     {
/* 2444 */       if (k > i3) {
/* 2445 */         j *= 100;
/*      */       } else {
/* 2447 */         k = (byte)(k + 1); j = j * 100 + (101 - this.tmpBytes[k]);
/*      */       }
/* 2449 */       m--;
/*      */     }
/*      */ 
/* 2453 */     if (i9 != 0)
/*      */     {
/* 2455 */       i7++;
/* 2456 */       j /= 10;
/*      */     }
/*      */ 
/* 2459 */     int i8 = i3 - 1;
/*      */ 
/* 2461 */     while (m != 0)
/*      */     {
/* 2463 */       if (i5 == 1)
/*      */       {
/* 2465 */         if (i9 != 0)
/*      */         {
/* 2467 */           i1 = (this.tmpBytes[(k - 1)] - 1) % 10 * 1000 + (this.tmpBytes[k] - 1) * 10 + (this.tmpBytes[(k + 1)] - 1) / 10 + j * 10000;
/*      */ 
/* 2470 */           k = (byte)(k + 2);
/*      */         }
/* 2472 */         else if (k < i8)
/*      */         {
/* 2474 */           i1 = (this.tmpBytes[k] - 1) * 100 + (this.tmpBytes[(k + 1)] - 1) + j * 10000;
/*      */ 
/* 2477 */           k = (byte)(k + 2);
/*      */         }
/*      */         else
/*      */         {
/* 2481 */           i1 = 0;
/*      */ 
/* 2483 */           if (k <= i3)
/*      */           {
/* 2485 */             for (i10 = 0; 
/* 2487 */               k <= i3; i10++) {
/* 2488 */               k = (byte)(k + 1); i1 = i1 * 100 + (this.tmpBytes[k] - 1);
/*      */             }
/* 2490 */             for (; i10 < 2; i10++) {
/* 2491 */               i1 *= 100;
/*      */             }
/*      */           }
/* 2494 */           i1 += j * 10000;
/*      */         }
/*      */       }
/* 2497 */       else if (i9 != 0)
/*      */       {
/* 2499 */         i1 = (101 - this.tmpBytes[(k - 1)]) % 10 * 1000 + (101 - this.tmpBytes[k]) * 10 + (101 - this.tmpBytes[(k + 1)]) / 10 + j * 10000;
/*      */ 
/* 2502 */         k = (byte)(k + 2);
/*      */       }
/* 2504 */       else if (k < i8)
/*      */       {
/* 2506 */         i1 = (101 - this.tmpBytes[k]) * 100 + (101 - this.tmpBytes[(k + 1)]) + j * 10000;
/*      */ 
/* 2509 */         k = (byte)(k + 2);
/*      */       }
/*      */       else
/*      */       {
/* 2513 */         i1 = 0;
/*      */ 
/* 2515 */         if (k <= i3)
/*      */         {
/* 2517 */           for (i10 = 0; 
/* 2519 */             k <= i3; i10++) {
/* 2520 */             k = (byte)(k + 1); i1 = i1 * 100 + (101 - this.tmpBytes[k]);
/*      */           }
/* 2522 */           for (; i10 < 2; i10++) {
/* 2523 */             i1 *= 100;
/*      */           }
/*      */         }
/* 2526 */         i1 += j * 10000;
/*      */       }
/*      */ 
/* 2529 */       j = i1 & 0xFFFF;
/*      */ 
/* 2531 */       for (int i10 = 25; i10 >= n; i10--)
/*      */       {
/* 2533 */         i1 = (i1 >> 16) + this.digs[i10] * 10000;
/* 2534 */         this.digs[i10] = (i1 & 0xFFFF);
/*      */       }
/*      */ 
/* 2537 */       if (n > 0)
/*      */       {
/* 2539 */         i1 >>= 16;
/* 2540 */         if (i1 != 0) {
/* 2541 */           n = (byte)(n - 1); this.digs[n] = i1;
/*      */         }
/*      */       }
/* 2544 */       m -= 2;
/*      */     }
/*      */ 
/* 2547 */     this.digs[26] = j;
/*      */ 
/* 2558 */     int i11 = (byte)(this.digs[n] >> 8 & 0xFF);
/*      */     int i2;
/*      */     byte[] arrayOfByte;
/*      */     int i12;
/*      */     int i13;
/* 2560 */     if (i11 == 0)
/*      */     {
/* 2562 */       i2 = 53 - (n << 1);
/* 2563 */       arrayOfByte = new byte[i2];
/*      */ 
/* 2565 */       for (i12 = 26; i12 > n; i12--)
/*      */       {
/* 2567 */         i13 = i12 - n << 1;
/*      */ 
/* 2569 */         arrayOfByte[(i13 - 1)] = ((byte)(this.digs[i12] >> 8 & 0xFF));
/* 2570 */         arrayOfByte[i13] = ((byte)(this.digs[i12] & 0xFF));
/*      */       }
/*      */ 
/* 2573 */       arrayOfByte[0] = ((byte)(this.digs[n] & 0xFF));
/*      */     }
/*      */     else
/*      */     {
/* 2577 */       i2 = 54 - (n << 1);
/* 2578 */       arrayOfByte = new byte[i2];
/*      */ 
/* 2580 */       for (i12 = 26; i12 > n; i12--)
/*      */       {
/* 2582 */         i13 = i12 - n << 1;
/*      */ 
/* 2584 */         arrayOfByte[i13] = ((byte)(this.digs[i12] >> 8 & 0xFF));
/* 2585 */         arrayOfByte[(i13 + 1)] = ((byte)(this.digs[i12] & 0xFF));
/*      */       }
/*      */ 
/* 2588 */       arrayOfByte[0] = i11;
/* 2589 */       arrayOfByte[1] = ((byte)(this.digs[n] & 0xFF));
/*      */     }
/*      */ 
/* 2592 */     if ((i7 == 0) && (i2 < 8) && (i2 > 0)) {
/* 2593 */       long l = arrayOfByte[0] & 0xFF;
/* 2594 */       for (int i14 = 1; i14 < i2; i14++) l = l << 8 | arrayOfByte[i14] & 0xFF;
/* 2595 */       l *= i5;
/* 2596 */       return new BigDecimal(l);
/*      */     }
/*      */ 
/* 2601 */     BigInteger localBigInteger = new BigInteger(i5, arrayOfByte);
/*      */ 
/* 2603 */     return new BigDecimal(localBigInteger, -i7);
/*      */   }
/*      */ 
/*      */   BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2613 */     if (isNull(paramInt1)) return null;
/*      */ 
/* 2615 */     return getBigDecimal(paramInt1).setScale(paramInt2, 6);
/*      */   }
/*      */ 
/*      */   String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2633 */     if (isNull(paramInt)) return null;
/*      */ 
/* 2635 */     byte[] arrayOfByte = getBytesInternal(paramInt);
/* 2636 */     int i = arrayOfByte.length;
/*      */ 
/* 2917 */     NUMBER localNUMBER = new NUMBER(arrayOfByte);
/*      */ 
/* 2926 */     String str1 = NUMBER.toString(arrayOfByte);
/* 2927 */     int j = str1.length();
/*      */ 
/* 2929 */     if ((str1.startsWith("0.")) || (str1.startsWith("-0.")))
/* 2930 */       j--;
/*      */     String str2;
/* 2933 */     if (j > 38)
/*      */     {
/* 2943 */       str1 = localNUMBER.toText(-44, null);
/*      */ 
/* 2947 */       int k = str1.indexOf('E');
/* 2948 */       int m = str1.indexOf('+');
/*      */ 
/* 2950 */       if (k == -1)
/*      */       {
/* 2952 */         k = str1.indexOf('e');
/*      */       }
/*      */ 
/* 2955 */       int n = k - 1;
/*      */ 
/* 2957 */       while (str1.charAt(n) == '0')
/*      */       {
/* 2959 */         n--;
/*      */       }
/*      */ 
/* 2962 */       String str3 = str1.substring(0, n + 1);
/* 2963 */       String str4 = null;
/*      */ 
/* 2965 */       if (m > 0)
/*      */       {
/* 2967 */         str4 = str1.substring(m + 1);
/*      */       }
/*      */       else
/*      */       {
/* 2971 */         str4 = str1.substring(k + 1);
/*      */       }
/*      */ 
/* 2974 */       str2 = (str3 + "E" + str4).trim();
/*      */     }
/*      */     else {
/* 2977 */       str2 = localNUMBER.toText(38, null).trim();
/*      */     }
/*      */ 
/* 2980 */     if (str2.startsWith("-.")) {
/* 2981 */       return "-0" + str2.substring(1);
/*      */     }
/* 2983 */     if (str2.startsWith(".")) {
/* 2984 */       return "0" + str2;
/*      */     }
/*      */ 
/* 2987 */     return str2;
/*      */   }
/*      */ 
/*      */   NUMBER getNUMBER(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3008 */     if (isNull(paramInt)) return null;
/* 3009 */     return new NUMBER(getBytesInternal(paramInt));
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3025 */     if (isNull(paramInt)) return null;
/*      */ 
/* 3027 */     Object localObject = null;
/* 3028 */     if (this.externalType == 0)
/*      */     {
/* 3058 */       if ((this.statement.connection.j2ee13Compliant) && (this.precision != 0) && (this.scale == -127))
/*      */       {
/* 3060 */         localObject = new Double(getDouble(paramInt));
/*      */       }
/* 3062 */       else localObject = getBigDecimal(paramInt);
/*      */     }
/*      */     else
/*      */     {
/* 3066 */       switch (this.externalType)
/*      */       {
/*      */       case -7:
/* 3070 */         return Boolean.valueOf(getBoolean(paramInt));
/*      */       case -6:
/* 3073 */         return Byte.valueOf(getByte(paramInt));
/*      */       case 5:
/* 3076 */         return Short.valueOf(getShort(paramInt));
/*      */       case 4:
/* 3079 */         return Integer.valueOf(getInt(paramInt));
/*      */       case -5:
/* 3082 */         return Long.valueOf(getLong(paramInt));
/*      */       case 6:
/*      */       case 8:
/* 3087 */         return Double.valueOf(getDouble(paramInt));
/*      */       case 7:
/* 3090 */         return Float.valueOf(getFloat(paramInt));
/*      */       case 2:
/*      */       case 3:
/* 3095 */         return getBigDecimal(paramInt);
/*      */       case -4:
/*      */       case -3:
/*      */       case -2:
/*      */       case -1:
/*      */       case 0:
/* 3099 */       case 1: } SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3100 */       localSQLException.fillInStackTrace();
/* 3101 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3106 */     return localObject;
/*      */   }
/*      */ 
/*      */   Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 3123 */     return getObject(paramInt);
/*      */   }
/*      */ 
/*      */   Datum getOracleObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3139 */     return getNUMBER(paramInt);
/*      */   }
/*      */ 
/*      */   byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3155 */     if (isNull(paramInt)) return null;
/* 3156 */     return getBytesInternal(paramInt);
/*      */   }
/*      */ 
/*      */   void throwOverflow()
/*      */     throws SQLException
/*      */   {
/* 4169 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26);
/* 4170 */     localSQLException.fillInStackTrace();
/* 4171 */     throw localSQLException;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NumberCommonAccessor
 * JD-Core Version:    0.6.2
 */