/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Struct;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.OracleData;
/*     */ import oracle.jdbc.oracore.OracleType;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ import oracle.sql.ARRAY;
/*     */ import oracle.sql.ArrayDescriptor;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.JAVA_STRUCT;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.ORAData;
/*     */ import oracle.sql.OpaqueDescriptor;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.StructDescriptor;
/*     */ import oracle.sql.TypeDescriptor;
/*     */ import oracle.xdb.XMLType;
/*     */ 
/*     */ class NamedTypeAccessor extends TypeAccessor
/*     */ {
/*     */   static final int MAXLENGTH = -1;
/* 365 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NamedTypeAccessor(OracleStatement paramOracleStatement, String paramString, short paramShort, int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  33 */     super(Representation.NAMED_TYPE, paramOracleStatement, -1, paramBoolean);
/*     */ 
/*  35 */     init(paramOracleStatement, 109, 109, paramShort, paramBoolean);
/*  36 */     initForDataAccess(paramInt, 0, paramString);
/*     */   }
/*     */ 
/*     */   NamedTypeAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, String paramString)
/*     */     throws SQLException
/*     */   {
/*  45 */     super(Representation.NAMED_TYPE, paramOracleStatement, -1, false);
/*     */ 
/*  47 */     init(paramOracleStatement, 109, 109, paramShort, false);
/*  48 */     initForDescribe(109, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, paramString);
/*     */ 
/*  50 */     initForDataAccess(0, paramInt1, paramString);
/*     */   }
/*     */ 
/*     */   NamedTypeAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort, String paramString, OracleType paramOracleType)
/*     */     throws SQLException
/*     */   {
/*  59 */     super(Representation.NAMED_TYPE, paramOracleStatement, -1, false);
/*     */ 
/*  61 */     init(paramOracleStatement, 109, 109, paramShort, false);
/*     */ 
/*  63 */     this.describeOtype = paramOracleType;
/*     */ 
/*  65 */     initForDescribe(109, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, paramString);
/*     */ 
/*  68 */     this.internalOtype = paramOracleType;
/*     */ 
/*  70 */     initForDataAccess(0, paramInt1, paramString);
/*     */   }
/*     */ 
/*     */   OracleType otypeFromName(String paramString)
/*     */     throws SQLException
/*     */   {
/*  77 */     if (!this.outBind) {
/*  78 */       return TypeDescriptor.getTypeDescriptor(paramString, this.statement.connection).getPickler();
/*     */     }
/*  80 */     if (this.externalType == 2003) {
/*  81 */       return ArrayDescriptor.createDescriptor(paramString, this.statement.connection).getOracleTypeCOLLECTION();
/*     */     }
/*  83 */     if ((this.externalType == 2007) || (this.externalType == 2009))
/*     */     {
/*  86 */       return OpaqueDescriptor.createDescriptor(paramString, this.statement.connection).getPickler();
/*     */     }
/*     */ 
/*  89 */     return StructDescriptor.createDescriptor(paramString, this.statement.connection).getOracleTypeADT();
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  98 */     super.initForDataAccess(paramInt1, paramInt2, paramString);
/*     */ 
/* 100 */     this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 110 */     return getObject(paramInt, this.statement.connection.getTypeMap());
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 130 */     if (isNull(paramInt)) return null;
/*     */     Datum localDatum;
/* 134 */     if (this.externalType == 0)
/*     */     {
/* 136 */       localDatum = getOracleObject(paramInt);
/*     */ 
/* 138 */       if (localDatum == null) return null;
/* 139 */       if ((localDatum instanceof STRUCT))
/* 140 */         return ((STRUCT)localDatum).toJdbc(paramMap);
/* 141 */       if ((localDatum instanceof OPAQUE)) {
/* 142 */         Object localObject = ((OPAQUE)localDatum).toJdbc(paramMap);
/* 143 */         return localObject;
/*     */       }
/* 145 */       if ((localDatum instanceof ARRAY)) {
/* 146 */         return ((ARRAY)localDatum).toJdbc(paramMap);
/*     */       }
/*     */ 
/* 149 */       return localDatum.toJdbc();
/*     */     }
/*     */ 
/* 152 */     switch (this.externalType)
/*     */     {
/*     */     case 2008:
/* 157 */       paramMap = null;
/*     */     case 2000:
/*     */     case 2002:
/*     */     case 2003:
/*     */     case 2007:
/* 166 */       localDatum = getOracleObject(paramInt);
/*     */ 
/* 168 */       if (localDatum == null) {
/* 169 */         return null;
/*     */       }
/*     */ 
/* 172 */       if ((localDatum instanceof STRUCT)) {
/* 173 */         return ((STRUCT)localDatum).toJdbc(paramMap);
/*     */       }
/*     */ 
/* 176 */       if ((localDatum instanceof ARRAY)) {
/* 177 */         return ((ARRAY)localDatum).toJdbc(paramMap);
/*     */       }
/*     */ 
/* 181 */       return localDatum.toJdbc();
/*     */     case 2009:
/* 185 */       localDatum = getOracleObject(paramInt);
/* 186 */       if (localDatum == null) {
/* 187 */         return null;
/*     */       }
/*     */       try
/*     */       {
/* 191 */         return (SQLXML)localDatum;
/*     */       }
/*     */       catch (ClassCastException localClassCastException)
/*     */       {
/* 198 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 199 */         localSQLException.fillInStackTrace();
/* 200 */         throw localSQLException;
/*     */       }case 2001:
/*     */     case 2004:
/*     */     case 2005:
/*     */     case 2006:
/*     */     }
/* 206 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 207 */     localSQLException.fillInStackTrace();
/* 208 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 227 */     if (isNull(paramInt)) return null;
/*     */ 
/* 231 */     byte[] arrayOfByte = pickledBytes(paramInt);
/*     */ 
/* 233 */     if ((arrayOfByte == null) || (arrayOfByte.length == 0)) return null;
/*     */ 
/* 235 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 236 */     OracleTypeADT localOracleTypeADT = (OracleTypeADT)this.internalOtype;
/* 237 */     TypeDescriptor localTypeDescriptor = TypeDescriptor.getTypeDescriptor(localOracleTypeADT.getFullName(), localPhysicalConnection, arrayOfByte, 0L);
/*     */ 
/* 240 */     switch (localTypeDescriptor.getTypeCode())
/*     */     {
/*     */     case 2003:
/* 243 */       return new ARRAY((ArrayDescriptor)localTypeDescriptor, arrayOfByte, localPhysicalConnection);
/*     */     case 2002:
/* 246 */       return new STRUCT((StructDescriptor)localTypeDescriptor, arrayOfByte, localPhysicalConnection);
/*     */     case 2009:
/* 249 */       return XMLFactory.createXML(new OPAQUE((OpaqueDescriptor)localTypeDescriptor, arrayOfByte, localPhysicalConnection));
/*     */     case 2007:
/* 253 */       return new OPAQUE((OpaqueDescriptor)localTypeDescriptor, arrayOfByte, localPhysicalConnection);
/*     */     case 2008:
/* 256 */       return new JAVA_STRUCT((StructDescriptor)localTypeDescriptor, arrayOfByte, localPhysicalConnection);
/*     */     case 2004:
/*     */     case 2005:
/*     */     case 2006:
/*     */     }
/* 261 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/* 262 */     localSQLException.fillInStackTrace();
/* 263 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   OracleData getOracleData(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 277 */     return (OracleData)getObject(paramInt);
/*     */   }
/*     */ 
/*     */   ORAData getORAData(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 284 */     return (ORAData)getObject(paramInt);
/*     */   }
/*     */ 
/*     */   ARRAY getARRAY(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 292 */     return (ARRAY)getOracleObject(paramInt);
/*     */   }
/*     */ 
/*     */   STRUCT getSTRUCT(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 302 */     return (STRUCT)getOracleObject(paramInt);
/*     */   }
/*     */ 
/*     */   Struct getStruct(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 312 */     return (Struct)getOracleObject(paramInt);
/*     */   }
/*     */ 
/*     */   OPAQUE getOPAQUE(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 322 */     return (OPAQUE)getOracleObject(paramInt);
/*     */   }
/*     */ 
/*     */   SQLXML getSQLXML(int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 333 */       OPAQUE localOPAQUE = (OPAQUE)getOracleObject(paramInt);
/* 334 */       if (localOPAQUE == null) return null;
/* 335 */       return (SQLXML)localOPAQUE;
/*     */     }
/*     */     catch (ClassCastException localClassCastException)
/*     */     {
/* 339 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 340 */       localSQLException.fillInStackTrace();
/* 341 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 354 */     Datum localDatum = getOracleObject(paramInt);
/* 355 */     if ((localDatum instanceof XMLType)) {
/* 356 */       return ((XMLType)localDatum).getString();
/*     */     }
/* 358 */     return null;
/*     */   }
/*     */ 
/*     */   private static class XMLFactory
/*     */   {
/*     */     static Datum createXML(OPAQUE paramOPAQUE)
/*     */       throws SQLException
/*     */     {
/* 118 */       return XMLType.createXML(paramOPAQUE);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NamedTypeAccessor
 * JD-Core Version:    0.6.2
 */