/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.XSEvent;
/*     */ import oracle.jdbc.internal.XSKeyval;
/*     */ import oracle.jdbc.internal.XSNamespace;
/*     */ import oracle.jdbc.internal.XSPrincipal;
/*     */ import oracle.jdbc.internal.XSSessionNamespace;
/*     */ 
/*     */ class NTFXSEvent extends XSEvent
/*     */ {
/*     */   private final XSNamespaceI[] kpxssyncns;
/*     */   private final XSNamespaceI[] kpxssyncinvalidns;
/*     */   private final XSPrincipalI[] kpxssyncroles;
/*     */   private final XSSessionNamespaceI[] kpxssyncsessns;
/*     */   private final int kpxssyncrolever;
/*     */   private final int kpxssyncsessflg;
/*     */   private final int kpxssynccacheflg;
/*     */   private final XSKeyvalI kvl;
/* 186 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public XSNamespace[] getNamespaces()
/*     */   {
/*  55 */     return (XSNamespace[])this.kpxssyncns;
/*     */   }
/*     */ 
/*     */   public XSNamespace[] getInvalidNamespaces() {
/*  59 */     return (XSNamespace[])this.kpxssyncinvalidns;
/*     */   }
/*     */ 
/*     */   public XSPrincipal[] getSessionRoles() {
/*  63 */     return (XSPrincipal[])this.kpxssyncroles;
/*     */   }
/*     */ 
/*     */   public XSSessionNamespace[] getSessionNamespaces() {
/*  67 */     return (XSSessionNamespace[])this.kpxssyncsessns;
/*     */   }
/*     */ 
/*     */   public int getRoleVersion() {
/*  71 */     return this.kpxssyncrolever;
/*     */   }
/*     */ 
/*     */   public long getSessionFlags() {
/*  75 */     return this.kpxssyncsessflg;
/*     */   }
/*     */ 
/*     */   public long getCacheFlags() {
/*  79 */     return this.kpxssynccacheflg;
/*     */   }
/*     */ 
/*     */   public XSKeyval getKeyval() {
/*  83 */     return this.kvl;
/*     */   }
/*     */ 
/*     */   NTFXSEvent(T4CConnection paramT4CConnection)
/*     */     throws SQLException, IOException
/*     */   {
/*  89 */     super(paramT4CConnection);
/*     */ 
/* 125 */     T4CMAREngine localT4CMAREngine = paramT4CConnection.getMarshalEngine();
/* 126 */     int i = (int)localT4CMAREngine.unmarshalUB4();
/* 127 */     if (i > 0)
/* 128 */       localT4CMAREngine.unmarshalUB1();
/* 129 */     this.kpxssyncns = new XSNamespaceI[i];
/* 130 */     for (int j = 0; j < i; j++)
/*     */     {
/* 132 */       this.kpxssyncns[j] = XSNamespaceI.unmarshal(localT4CMAREngine);
/*     */     }
/*     */ 
/* 135 */     j = (int)localT4CMAREngine.unmarshalUB4();
/* 136 */     if (j > 0)
/* 137 */       localT4CMAREngine.unmarshalUB1();
/* 138 */     this.kpxssyncinvalidns = new XSNamespaceI[j];
/* 139 */     for (int k = 0; k < j; k++)
/*     */     {
/* 141 */       this.kpxssyncinvalidns[k] = XSNamespaceI.unmarshal(localT4CMAREngine);
/*     */     }
/*     */ 
/* 145 */     k = (int)localT4CMAREngine.unmarshalUB4();
/* 146 */     if (k > 0)
/* 147 */       localT4CMAREngine.unmarshalUB1();
/* 148 */     this.kpxssyncroles = new XSPrincipalI[k];
/* 149 */     for (int m = 0; m < k; m++)
/*     */     {
/* 151 */       this.kpxssyncroles[m] = XSPrincipalI.unmarshal(localT4CMAREngine);
/*     */     }
/*     */ 
/* 155 */     m = (int)localT4CMAREngine.unmarshalUB4();
/* 156 */     if (m > 0)
/* 157 */       localT4CMAREngine.unmarshalUB1();
/* 158 */     this.kpxssyncsessns = new XSSessionNamespaceI[m];
/* 159 */     for (int n = 0; n < m; n++)
/*     */     {
/* 161 */       localT4CMAREngine.unmarshalUB1();
/* 162 */       localT4CMAREngine.unmarshalUB1();
/* 163 */       localT4CMAREngine.unmarshalUB1();
/* 164 */       this.kpxssyncsessns[n] = XSSessionNamespaceI.unmarshal(localT4CMAREngine);
/*     */     }
/*     */ 
/* 167 */     this.kpxssyncrolever = ((int)localT4CMAREngine.unmarshalUB4());
/* 168 */     this.kpxssyncsessflg = ((int)localT4CMAREngine.unmarshalUB4());
/* 169 */     this.kpxssynccacheflg = ((int)localT4CMAREngine.unmarshalUB4());
/*     */ 
/* 171 */     n = localT4CMAREngine.unmarshalUB1();
/* 172 */     if (n != 0)
/*     */     {
/* 174 */       localT4CMAREngine.unmarshalUB1();
/* 175 */       localT4CMAREngine.unmarshalUB1();
/*     */ 
/* 177 */       this.kvl = XSKeyvalI.unmarshal(localT4CMAREngine);
/*     */     }
/*     */     else
/*     */     {
/* 181 */       this.kvl = null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFXSEvent
 * JD-Core Version:    0.6.2
 */