/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.BindException;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.SocketAddress;
/*     */ import java.nio.channels.ServerSocketChannel;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ class NTFManager
/*     */ {
/*  63 */   private Hashtable<Integer, NTFListener> nsListeners = new Hashtable();
/*     */ 
/*  68 */   private Hashtable<Integer, NTFRegistration> ntfRegistrations = new Hashtable();
/*     */ 
/*  78 */   private byte[] listOfJdbcRegId = new byte[20];
/*     */ 
/*  88 */   private HashMap<String, NTFJMSPerDatabaseManager> jmsPerDatabaseManagers = new HashMap();
/*     */ 
/* 357 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   synchronized boolean listenOnPortT4C(int[] paramArrayOfInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 121 */     int i = paramArrayOfInt[0];
/* 122 */     boolean bool = false;
/*     */ 
/* 126 */     while (this.nsListeners.get(Integer.valueOf(i)) == null)
/*     */     {
/*     */       try
/*     */       {
/* 134 */         ServerSocketChannel localServerSocketChannel = ServerSocketChannel.open();
/* 135 */         localServerSocketChannel.configureBlocking(false);
/*     */ 
/* 137 */         ServerSocket localServerSocket = localServerSocketChannel.socket();
/*     */ 
/* 139 */         localObject = new InetSocketAddress(i);
/*     */         try
/*     */         {
/* 143 */           localServerSocket.bind((SocketAddress)localObject);
/*     */ 
/* 145 */           bool = true;
/* 146 */           NTFListener localNTFListener = new NTFListener(this, localServerSocketChannel, i);
/* 147 */           this.nsListeners.put(Integer.valueOf(i), localNTFListener);
/* 148 */           localNTFListener.start();
/*     */         }
/*     */         catch (BindException localBindException)
/*     */         {
/* 153 */           if (!paramBoolean)
/*     */           {
/* 155 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 250);
/* 156 */             localSQLException.fillInStackTrace();
/* 157 */             throw localSQLException;
/*     */           }
/*     */ 
/* 160 */           i++;
/*     */         }
/*     */         catch (IOException localIOException2)
/*     */         {
/*     */           SQLException localSQLException;
/* 164 */           if (!paramBoolean)
/*     */           {
/* 166 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 250);
/* 167 */             localSQLException.fillInStackTrace();
/* 168 */             throw localSQLException;
/*     */           }
/*     */ 
/* 171 */           i++;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException localIOException1)
/*     */       {
/* 177 */         Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException1);
/* 178 */         ((SQLException)localObject).fillInStackTrace();
/* 179 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/*     */ 
/* 183 */     paramArrayOfInt[0] = i;
/* 184 */     return bool;
/*     */   }
/*     */ 
/*     */   synchronized int getNextJdbcRegId()
/*     */   {
/* 195 */     for (int i = 1; 
/* 196 */       i < this.listOfJdbcRegId.length; i++)
/*     */     {
/* 198 */       if (this.listOfJdbcRegId[i] == 0)
/*     */         break;
/*     */     }
/* 201 */     if (i == this.listOfJdbcRegId.length - 1)
/*     */     {
/* 203 */       byte[] arrayOfByte = new byte[this.listOfJdbcRegId.length * 2];
/* 204 */       System.arraycopy(this.listOfJdbcRegId, 0, arrayOfByte, 0, this.listOfJdbcRegId.length);
/* 205 */       this.listOfJdbcRegId = arrayOfByte;
/*     */     }
/* 207 */     this.listOfJdbcRegId[i] = 2;
/* 208 */     return i;
/*     */   }
/*     */ 
/*     */   synchronized void addRegistration(NTFRegistration paramNTFRegistration)
/*     */   {
/* 218 */     Integer localInteger = Integer.valueOf(paramNTFRegistration.getJdbcRegId());
/* 219 */     Hashtable localHashtable = (Hashtable)this.ntfRegistrations.clone();
/* 220 */     localHashtable.put(localInteger, paramNTFRegistration);
/*     */ 
/* 227 */     this.ntfRegistrations = localHashtable;
/*     */   }
/*     */ 
/*     */   synchronized boolean removeRegistration(NTFRegistration paramNTFRegistration)
/*     */   {
/* 239 */     Integer localInteger = Integer.valueOf(paramNTFRegistration.getJdbcRegId());
/* 240 */     Hashtable localHashtable = (Hashtable)this.ntfRegistrations.clone();
/* 241 */     Object localObject = localHashtable.remove(localInteger);
/*     */ 
/* 248 */     this.ntfRegistrations = localHashtable;
/*     */ 
/* 253 */     boolean bool = false;
/*     */ 
/* 255 */     if (localObject != null)
/* 256 */       bool = true;
/* 257 */     return bool;
/*     */   }
/*     */ 
/*     */   synchronized void freeJdbcRegId(int paramInt)
/*     */   {
/* 265 */     if ((this.listOfJdbcRegId != null) && (this.listOfJdbcRegId.length > paramInt))
/* 266 */       this.listOfJdbcRegId[paramInt] = 0;
/*     */   }
/*     */ 
/*     */   synchronized void cleanListenersT4C(int paramInt)
/*     */   {
/* 285 */     Enumeration localEnumeration = this.ntfRegistrations.keys();
/* 286 */     int i = 0;
/*     */     Object localObject;
/* 287 */     while ((i == 0) && (localEnumeration.hasMoreElements()))
/*     */     {
/* 289 */       localObject = localEnumeration.nextElement();
/* 290 */       NTFRegistration localNTFRegistration = (NTFRegistration)this.ntfRegistrations.get(localObject);
/* 291 */       if (localNTFRegistration.getClientTCPPort() == paramInt)
/* 292 */         i = 1;
/*     */     }
/* 294 */     if (i == 0)
/*     */     {
/* 296 */       localObject = (NTFListener)this.nsListeners.get(Integer.valueOf(paramInt));
/* 297 */       if (localObject != null)
/*     */       {
/* 299 */         ((NTFListener)localObject).closeThisListener();
/* 300 */         ((NTFListener)localObject).interrupt();
/* 301 */         this.nsListeners.remove(Integer.valueOf(paramInt));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   NTFRegistration getRegistration(int paramInt)
/*     */   {
/* 317 */     Integer localInteger = Integer.valueOf(paramInt);
/*     */ 
/* 319 */     Hashtable localHashtable = this.ntfRegistrations;
/* 320 */     NTFRegistration localNTFRegistration = (NTFRegistration)localHashtable.get(localInteger);
/* 321 */     return localNTFRegistration;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 336 */     return null;
/*     */   }
/*     */ 
/*     */   synchronized NTFJMSPerDatabaseManager getJMSPerDatabaseManager(String paramString)
/*     */   {
/* 342 */     NTFJMSPerDatabaseManager localNTFJMSPerDatabaseManager = (NTFJMSPerDatabaseManager)this.jmsPerDatabaseManagers.get(paramString);
/* 343 */     if (localNTFJMSPerDatabaseManager == null) {
/* 344 */       localNTFJMSPerDatabaseManager = new NTFJMSPerDatabaseManager(paramString);
/*     */     }
/* 346 */     this.jmsPerDatabaseManagers.put(paramString, localNTFJMSPerDatabaseManager);
/* 347 */     return localNTFJMSPerDatabaseManager;
/*     */   }
/*     */ 
/*     */   synchronized void removeJMSUtility(String paramString)
/*     */   {
/* 353 */     this.jmsPerDatabaseManagers.remove(paramString);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFManager
 * JD-Core Version:    0.6.2
 */