/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.channels.SelectionKey;
/*     */ import java.nio.channels.Selector;
/*     */ import java.nio.channels.ServerSocketChannel;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ class NTFListener extends Thread
/*     */ {
/*  47 */   private NTFConnection[] connections = null;
/*  48 */   private int nbOfConnections = 0;
/*  49 */   private boolean needsToBeClosed = false;
/*     */   NTFManager dcnManager;
/*     */   ServerSocketChannel ssChannel;
/*     */   int tcpport;
/* 134 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFListener(NTFManager paramNTFManager, ServerSocketChannel paramServerSocketChannel, int paramInt)
/*     */   {
/*  57 */     this.dcnManager = paramNTFManager;
/*  58 */     this.connections = new NTFConnection[10];
/*  59 */     this.ssChannel = paramServerSocketChannel;
/*  60 */     this.tcpport = paramInt;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/*  69 */       Selector localSelector = Selector.open();
/*  70 */       this.ssChannel.register(localSelector, 16);
/*     */       while (true)
/*     */       {
/*  77 */         localSelector.select();
/*  78 */         if (this.needsToBeClosed) {
/*     */           break;
/*     */         }
/*  81 */         Iterator localIterator = localSelector.selectedKeys().iterator();
/*  82 */         while (localIterator.hasNext())
/*     */         {
/*  84 */           SelectionKey localSelectionKey = (SelectionKey)localIterator.next();
/*     */ 
/*  86 */           if ((localSelectionKey.readyOps() & 0x10) == 16)
/*     */           {
/*  91 */             ServerSocketChannel localServerSocketChannel = (ServerSocketChannel)localSelectionKey.channel();
/*     */ 
/*  93 */             SocketChannel localSocketChannel = localServerSocketChannel.accept();
/*  94 */             NTFConnection localNTFConnection = new NTFConnection(this.dcnManager, localSocketChannel);
/*     */ 
/*  97 */             if (this.connections.length == this.nbOfConnections)
/*     */             {
/* 100 */               NTFConnection[] arrayOfNTFConnection = new NTFConnection[this.connections.length * 2];
/* 101 */               System.arraycopy(this.connections, 0, arrayOfNTFConnection, 0, this.connections.length);
/* 102 */               this.connections = arrayOfNTFConnection;
/*     */             }
/* 104 */             this.connections[(this.nbOfConnections++)] = localNTFConnection;
/* 105 */             localNTFConnection.start();
/* 106 */             localIterator.remove();
/*     */           }
/*     */         }
/*     */       }
/* 110 */       localSelector.close();
/* 111 */       this.ssChannel.close();
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   synchronized void closeThisListener()
/*     */   {
/* 125 */     for (int i = 0; i < this.nbOfConnections; i++)
/*     */     {
/* 127 */       this.connections[i].closeThisConnection();
/* 128 */       this.connections[i].interrupt();
/*     */     }
/* 130 */     this.needsToBeClosed = true;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFListener
 * JD-Core Version:    0.6.2
 */