/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class NTFJMSPerDatabaseManager
/*     */ {
/*  35 */   NTFJMSConnection[] jmsListenerConnections = null;
/*     */ 
/*  44 */   private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
/*     */   private String jmsClientId;
/*  63 */   private int noOfRegistrationsInDB = 0;
/*     */   String databaseUniqueIdentifier;
/*     */   private static final int MAX_NTF_CONNECTIONS = 2;
/*  76 */   String[] databaseInstances = null;
/*     */ 
/*  80 */   boolean isInitialized = false;
/*     */ 
/*  88 */   ArrayList<String> listenerAddresses = null;
/*     */ 
/* 232 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFJMSPerDatabaseManager(String paramString)
/*     */   {
/*  92 */     this.databaseUniqueIdentifier = paramString;
/*     */   }
/*     */ 
/*     */   void init(String paramString, String[] paramArrayOfString, ArrayList<String> paramArrayList)
/*     */   {
/* 100 */     this.jmsClientId = paramString;
/* 101 */     this.databaseInstances = paramArrayOfString;
/* 102 */     this.listenerAddresses = paramArrayList;
/* 103 */     this.isInitialized = true;
/*     */   }
/*     */ 
/*     */   synchronized void closeJMSListenerConnection()
/*     */   {
/* 115 */     if ((this.noOfRegistrationsInDB == 0) && 
/* 116 */       (this.jmsListenerConnections != null)) {
/* 117 */       for (int i = 0; i < this.jmsListenerConnections.length; i++) {
/* 118 */         if (this.jmsListenerConnections[i] != null) {
/* 119 */           this.jmsListenerConnections[i].closeThisListener();
/* 120 */           this.jmsListenerConnections[i].interrupt();
/*     */ 
/* 124 */           PhysicalConnection.ntfManager.removeJMSUtility(this.databaseUniqueIdentifier);
/*     */         }
/*     */       }
/* 127 */       this.jmsListenerConnections = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   synchronized void startJMSListenerConnection(String paramString1, String paramString2, String paramString3)
/*     */   {
/* 155 */     assert (this.jmsClientId != null) : "jmsClientId is null";
/*     */ 
/* 157 */     if ((this.jmsListenerConnections == null) || (this.jmsListenerConnections.length == 0))
/*     */     {
/*     */       int i;
/* 159 */       if (this.databaseInstances.length > 2) {
/* 160 */         i = 2;
/*     */       }
/*     */       else {
/* 163 */         i = this.databaseInstances.length;
/*     */       }
/* 165 */       this.jmsListenerConnections = new NTFJMSConnection[i];
/*     */ 
/* 167 */       for (int j = 0; j < i; j++) {
/* 168 */         String str = "notify" + j;
/* 169 */         this.jmsListenerConnections[j] = new NTFJMSConnection(this, this.jmsClientId, this.listenerAddresses, this.databaseInstances[j], paramString1, paramString2, paramString3, str);
/*     */ 
/* 177 */         this.jmsListenerConnections[j].setDaemon(true);
/* 178 */         this.jmsListenerConnections[j].start();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   String getJMSClientId()
/*     */   {
/* 189 */     return this.jmsClientId;
/*     */   }
/*     */ 
/*     */   public void setJmsClientId(String paramString)
/*     */   {
/* 198 */     this.jmsClientId = paramString;
/*     */   }
/*     */ 
/*     */   void removeRegistrationId(Long paramLong)
/*     */   {
/* 204 */     this.jmsRegIdToJDBCRegId.remove(paramLong);
/*     */   }
/*     */ 
/*     */   int getJDBCRegId(Long paramLong)
/*     */   {
/* 210 */     return ((Integer)this.jmsRegIdToJDBCRegId.get(paramLong)).intValue();
/*     */   }
/*     */ 
/*     */   void mapJMSRegIdToJDBCRegId(Long paramLong, int paramInt)
/*     */   {
/* 216 */     this.jmsRegIdToJDBCRegId.put(paramLong, Integer.valueOf(paramInt));
/*     */   }
/*     */ 
/*     */   void incrementNumberOfRegistrations()
/*     */   {
/* 222 */     this.noOfRegistrationsInDB += 1;
/*     */   }
/*     */ 
/*     */   void decrementNumberOfRegistrations()
/*     */   {
/* 228 */     this.noOfRegistrationsInDB -= 1;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFJMSPerDatabaseManager
 * JD-Core Version:    0.6.2
 */