/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Properties;
/*     */ import oracle.jdbc.pool.OracleDataSource;
/*     */ 
/*     */ class NTFJMSConnection extends Thread
/*     */ {
/*     */   int tcpport;
/*     */   String clientId;
/*     */   String instanceName;
/*     */   String serviceName;
/*     */   String url;
/*     */   String userName;
/*     */   String password;
/*     */   String connClass;
/*     */   ArrayList<String> listenerAddresses;
/*  46 */   Connection conn = null;
/*  47 */   T4CTTIoaqnfy oaqnfy = null;
/*     */   NTFJMSPerDatabaseManager jmsPerDatabaseManager;
/*  50 */   private boolean needToBeClosed = false;
/*  51 */   private boolean safeToClose = true;
/*     */ 
/* 150 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFJMSConnection(NTFJMSPerDatabaseManager paramNTFJMSPerDatabaseManager, String paramString1, ArrayList<String> paramArrayList, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6)
/*     */   {
/*  62 */     this.userName = paramString4;
/*  63 */     this.password = paramString5;
/*  64 */     this.serviceName = paramString3;
/*  65 */     this.jmsPerDatabaseManager = paramNTFJMSPerDatabaseManager;
/*  66 */     this.clientId = paramString1;
/*  67 */     this.listenerAddresses = paramArrayList;
/*  68 */     this.instanceName = paramString2;
/*     */ 
/*  76 */     assert (this.listenerAddresses != null) : "listenerAddresses is null";
/*  77 */     assert (this.instanceName != null) : "instancename is null";
/*  78 */     String str = (String)this.listenerAddresses.get(0);
/*     */ 
/*  80 */     this.url = ("jdbc:oracle:thin:@(DESCRIPTION=" + str + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))");
/*     */ 
/*  84 */     this.connClass = paramString6;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*  89 */     if (!this.needToBeClosed) {
/*  90 */       this.safeToClose = false;
/*     */       try {
/*  92 */         this.conn = getConnection(this.url, this.connClass);
/*  93 */         this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.clientId, this.jmsPerDatabaseManager);
/*  94 */         this.safeToClose = true;
/*     */ 
/*  96 */         this.oaqnfy.doRPC();
/*     */       }
/*     */       catch (Exception localException) {
/*  99 */         this.safeToClose = true;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   synchronized Connection getConnection(String paramString1, String paramString2)
/*     */     throws Exception
/*     */   {
/* 112 */     OracleDataSource localOracleDataSource = new OracleDataSource();
/* 113 */     localOracleDataSource.setURL(paramString1);
/* 114 */     localOracleDataSource.setUser(this.userName);
/* 115 */     localOracleDataSource.setPassword(this.password);
/* 116 */     if (paramString2 != null) {
/* 117 */       Properties localProperties = new Properties();
/* 118 */       localProperties.put("oracle.jdbc.DRCPConnectionClass", paramString2);
/* 119 */       localProperties.put("oracle.jdbc.jmsNotification", "true");
/* 120 */       localProperties.put("oracle.jdbc.ReadTimeout", Integer.valueOf(0));
/* 121 */       localProperties.put("oracle.net.CONNECT_TIMEOUT", Integer.valueOf(0));
/* 122 */       localOracleDataSource.setConnectionProperties(localProperties);
/*     */     }
/* 124 */     return localOracleDataSource.getConnection();
/*     */   }
/*     */ 
/*     */   void closeThisListener()
/*     */   {
/* 133 */     while (!this.safeToClose);
/* 134 */     this.needToBeClosed = true;
/*     */     try {
/* 136 */       if (this.oaqnfy != null) {
/* 137 */         this.oaqnfy.stopListening();
/*     */       }
/* 139 */       if (this.conn != null)
/* 140 */         this.conn.close();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFJMSConnection
 * JD-Core Version:    0.6.2
 */