/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.EventListener;
/*     */ import java.util.concurrent.Executor;
/*     */ import oracle.jdbc.LogicalTransactionIdEventListener;
/*     */ import oracle.jdbc.aq.AQNotificationListener;
/*     */ import oracle.jdbc.dcn.DatabaseChangeListener;
/*     */ import oracle.jdbc.internal.JMSNotificationListener;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.PDBChangeEventListener;
/*     */ import oracle.jdbc.internal.XSEventListener;
/*     */ 
/*     */ class NTFEventListener
/*     */ {
/*     */   private final AQNotificationListener aqlistener;
/*     */   private final DatabaseChangeListener dcnlistener;
/*     */   private final XSEventListener xslistener;
/*     */   private final LogicalTransactionIdEventListener ltxidlistener;
/*     */   private final JMSNotificationListener jmslistener;
/*     */   private final PDBChangeEventListener pdbChangeListener;
/*  60 */   private Executor executor = null;
/*     */ 
/* 278 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFEventListener(PDBChangeEventListener paramPDBChangeEventListener)
/*     */     throws SQLException
/*     */   {
/*  65 */     if (paramPDBChangeEventListener == null)
/*     */     {
/*  68 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 246);
/*  69 */       localSQLException.fillInStackTrace();
/*  70 */       throw localSQLException;
/*     */     }
/*     */ 
/*  73 */     this.jmslistener = null;
/*  74 */     this.dcnlistener = null;
/*  75 */     this.aqlistener = null;
/*  76 */     this.xslistener = null;
/*  77 */     this.ltxidlistener = null;
/*  78 */     this.pdbChangeListener = paramPDBChangeEventListener;
/*     */   }
/*     */ 
/*     */   NTFEventListener(DatabaseChangeListener paramDatabaseChangeListener)
/*     */     throws SQLException
/*     */   {
/*  86 */     if (paramDatabaseChangeListener == null)
/*     */     {
/*  90 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 246);
/*  91 */       localSQLException.fillInStackTrace();
/*  92 */       throw localSQLException;
/*     */     }
/*     */ 
/*  95 */     this.jmslistener = null;
/*  96 */     this.dcnlistener = paramDatabaseChangeListener;
/*  97 */     this.aqlistener = null;
/*  98 */     this.xslistener = null;
/*  99 */     this.ltxidlistener = null;
/* 100 */     this.pdbChangeListener = null;
/*     */   }
/*     */ 
/*     */   NTFEventListener(JMSNotificationListener paramJMSNotificationListener)
/*     */     throws SQLException
/*     */   {
/* 107 */     if (paramJMSNotificationListener == null)
/*     */     {
/* 111 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 246);
/* 112 */       localSQLException.fillInStackTrace();
/* 113 */       throw localSQLException;
/*     */     }
/*     */ 
/* 116 */     this.jmslistener = paramJMSNotificationListener;
/* 117 */     this.aqlistener = null;
/* 118 */     this.dcnlistener = null;
/* 119 */     this.xslistener = null;
/* 120 */     this.ltxidlistener = null;
/* 121 */     this.pdbChangeListener = null;
/*     */   }
/*     */ 
/*     */   NTFEventListener(AQNotificationListener paramAQNotificationListener)
/*     */     throws SQLException
/*     */   {
/* 129 */     if (paramAQNotificationListener == null)
/*     */     {
/* 133 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 246);
/* 134 */       localSQLException.fillInStackTrace();
/* 135 */       throw localSQLException;
/*     */     }
/*     */ 
/* 138 */     this.jmslistener = null;
/* 139 */     this.aqlistener = paramAQNotificationListener;
/* 140 */     this.dcnlistener = null;
/* 141 */     this.xslistener = null;
/* 142 */     this.ltxidlistener = null;
/* 143 */     this.pdbChangeListener = null;
/*     */   }
/*     */ 
/*     */   NTFEventListener(XSEventListener paramXSEventListener)
/*     */     throws SQLException
/*     */   {
/* 151 */     if (paramXSEventListener == null)
/*     */     {
/* 155 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 246);
/* 156 */       localSQLException.fillInStackTrace();
/* 157 */       throw localSQLException;
/*     */     }
/*     */ 
/* 160 */     this.jmslistener = null;
/* 161 */     this.aqlistener = null;
/* 162 */     this.dcnlistener = null;
/* 163 */     this.xslistener = paramXSEventListener;
/* 164 */     this.ltxidlistener = null;
/* 165 */     this.pdbChangeListener = null;
/*     */   }
/*     */ 
/*     */   NTFEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener)
/*     */     throws SQLException
/*     */   {
/* 173 */     if (paramLogicalTransactionIdEventListener == null)
/*     */     {
/* 177 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 246);
/* 178 */       localSQLException.fillInStackTrace();
/* 179 */       throw localSQLException;
/*     */     }
/*     */ 
/* 182 */     this.jmslistener = null;
/* 183 */     this.aqlistener = null;
/* 184 */     this.dcnlistener = null;
/* 185 */     this.xslistener = null;
/* 186 */     this.ltxidlistener = paramLogicalTransactionIdEventListener;
/* 187 */     this.pdbChangeListener = null;
/*     */   }
/*     */ 
/*     */   void setExecutor(Executor paramExecutor)
/*     */   {
/* 194 */     this.executor = paramExecutor;
/*     */   }
/*     */ 
/*     */   Executor getExecutor()
/*     */   {
/* 200 */     return this.executor;
/*     */   }
/*     */ 
/*     */   EventListener getListener()
/*     */   {
/* 207 */     Object localObject = this.dcnlistener;
/* 208 */     if (localObject == null) {
/* 209 */       localObject = this.aqlistener;
/*     */     }
/* 211 */     if (localObject == null) {
/* 212 */       localObject = this.jmslistener;
/*     */     }
/* 214 */     if (localObject == null) {
/* 215 */       localObject = this.pdbChangeListener;
/*     */     }
/* 217 */     return localObject;
/*     */   }
/*     */ 
/*     */   PDBChangeEventListener getPDBChangeEventListener()
/*     */   {
/* 223 */     return this.pdbChangeListener;
/*     */   }
/*     */ 
/*     */   JMSNotificationListener getJMSListener()
/*     */   {
/* 230 */     return this.jmslistener;
/*     */   }
/*     */ 
/*     */   AQNotificationListener getAQListener()
/*     */   {
/* 237 */     return this.aqlistener;
/*     */   }
/*     */ 
/*     */   DatabaseChangeListener getDCNListener()
/*     */   {
/* 244 */     return this.dcnlistener;
/*     */   }
/*     */ 
/*     */   XSEventListener getXSEventListener()
/*     */   {
/* 251 */     return this.xslistener;
/*     */   }
/*     */ 
/*     */   LogicalTransactionIdEventListener getLogicalTransactionIdEventListener()
/*     */   {
/* 258 */     return this.ltxidlistener;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 273 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFEventListener
 * JD-Core Version:    0.6.2
 */