/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.EnumSet;
/*     */ import oracle.jdbc.dcn.RowChangeDescription;
/*     */ import oracle.jdbc.dcn.RowChangeDescription.RowOperation;
/*     */ import oracle.jdbc.dcn.TableChangeDescription;
/*     */ import oracle.jdbc.dcn.TableChangeDescription.TableOperation;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class NTFDCNTableChanges
/*     */   implements TableChangeDescription
/*     */ {
/*     */   final EnumSet<TableChangeDescription.TableOperation> opcode;
/*     */   String tableName;
/*     */   final int objectNumber;
/*     */   final int numberOfRows;
/*     */   final RowChangeDescription.RowOperation[] rowOpcode;
/*     */   final int[] rowIdLength;
/*     */   final byte[][] rowid;
/*     */   final CharacterSet charset;
/*  43 */   NTFDCNRowChanges[] rowsDescription = null;
/*     */   private static final byte OPERATION_ANY = 0;
/*     */   private static final byte OPERATION_UNKNOWN = 64;
/* 141 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFDCNTableChanges(ByteBuffer paramByteBuffer, int paramInt)
/*     */   {
/*  51 */     this.charset = CharacterSet.make(paramInt);
/*  52 */     this.opcode = TableChangeDescription.TableOperation.getTableOperations(paramByteBuffer.getInt());
/*  53 */     int i = paramByteBuffer.getShort();
/*  54 */     byte[] arrayOfByte = new byte[i];
/*  55 */     paramByteBuffer.get(arrayOfByte, 0, i);
/*  56 */     this.tableName = this.charset.toStringWithReplacement(arrayOfByte, 0, i);
/*     */ 
/*  59 */     this.objectNumber = paramByteBuffer.getInt();
/*  60 */     if (!this.opcode.contains(TableChangeDescription.TableOperation.ALL_ROWS))
/*     */     {
/*  62 */       this.numberOfRows = paramByteBuffer.getShort();
/*  63 */       this.rowOpcode = new RowChangeDescription.RowOperation[this.numberOfRows];
/*  64 */       this.rowIdLength = new int[this.numberOfRows];
/*  65 */       this.rowid = new byte[this.numberOfRows][];
/*  66 */       for (int j = 0; j < this.numberOfRows; j++)
/*     */       {
/*  68 */         this.rowOpcode[j] = RowChangeDescription.RowOperation.getRowOperation(paramByteBuffer.getInt());
/*  69 */         this.rowIdLength[j] = paramByteBuffer.getShort();
/*  70 */         this.rowid[j] = new byte[this.rowIdLength[j]];
/*  71 */         paramByteBuffer.get(this.rowid[j], 0, this.rowIdLength[j]);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  76 */       this.numberOfRows = 0;
/*  77 */       this.rowid = ((byte[][])null);
/*  78 */       this.rowOpcode = null;
/*  79 */       this.rowIdLength = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getTableName()
/*     */   {
/*  87 */     return this.tableName;
/*     */   }
/*     */ 
/*     */   public int getObjectNumber()
/*     */   {
/*  93 */     return this.objectNumber;
/*     */   }
/*     */ 
/*     */   public RowChangeDescription[] getRowChangeDescription()
/*     */   {
/*  99 */     if (this.rowsDescription == null)
/*     */     {
/* 101 */       synchronized (this)
/*     */       {
/* 103 */         if (this.rowsDescription == null)
/*     */         {
/* 105 */           this.rowsDescription = new NTFDCNRowChanges[this.numberOfRows];
/* 106 */           for (int i = 0; i < this.rowsDescription.length; i++)
/* 107 */             this.rowsDescription[i] = new NTFDCNRowChanges(this.rowOpcode[i], this.rowIdLength[i], this.rowid[i]);
/*     */         }
/*     */       }
/*     */     }
/* 111 */     return this.rowsDescription;
/*     */   }
/*     */ 
/*     */   public EnumSet<TableChangeDescription.TableOperation> getTableOperations()
/*     */   {
/* 117 */     return this.opcode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 128 */     StringBuffer localStringBuffer = new StringBuffer();
/* 129 */     localStringBuffer.append("    operation=" + getTableOperations() + ", tableName=" + this.tableName + ", objectNumber=" + this.objectNumber + "\n");
/* 130 */     RowChangeDescription[] arrayOfRowChangeDescription = getRowChangeDescription();
/* 131 */     if ((arrayOfRowChangeDescription != null) && (arrayOfRowChangeDescription.length > 0))
/*     */     {
/* 133 */       localStringBuffer.append("    Row Change Description (length=" + arrayOfRowChangeDescription.length + "):\n");
/* 134 */       for (int i = 0; i < arrayOfRowChangeDescription.length; i++)
/* 135 */         localStringBuffer.append(arrayOfRowChangeDescription[i].toString());
/*     */     }
/* 137 */     return localStringBuffer.toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFDCNTableChanges
 * JD-Core Version:    0.6.2
 */