/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import java.util.concurrent.Executor;
/*     */ import oracle.jdbc.dcn.DatabaseChangeListener;
/*     */ import oracle.jdbc.dcn.DatabaseChangeRegistration;
/*     */ 
/*     */ class NTFDCNRegistration extends NTFRegistration
/*     */   implements DatabaseChangeRegistration
/*     */ {
/*     */   private final long regid;
/*  46 */   private String[] tables = new String[10];
/*  47 */   private int nbOfStringsInTable = 0;
/*     */ 
/* 218 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFDCNRegistration(int paramInt1, boolean paramBoolean, String paramString1, long paramLong, String paramString2, String paramString3, int paramInt2, Properties paramProperties, short paramShort)
/*     */   {
/*  61 */     super(paramInt1, 2, paramBoolean, paramString1, paramString3, paramInt2, paramProperties, paramString2, paramShort);
/*     */ 
/*  72 */     this.regid = paramLong;
/*     */   }
/*     */ 
/*     */   NTFDCNRegistration(String paramString1, long paramLong, String paramString2, short paramShort)
/*     */   {
/*  82 */     super(0, 2, false, paramString1, null, 0, null, paramString2, paramShort);
/*     */ 
/*  92 */     this.regid = paramLong;
/*     */   }
/*     */ 
/*     */   public int getRegistrationId()
/*     */   {
/* 105 */     return (int)this.regid;
/*     */   }
/*     */ 
/*     */   public long getRegId()
/*     */   {
/* 117 */     return this.regid;
/*     */   }
/*     */ 
/*     */   public void addListener(DatabaseChangeListener paramDatabaseChangeListener, Executor paramExecutor)
/*     */     throws SQLException
/*     */   {
/* 133 */     NTFEventListener localNTFEventListener = new NTFEventListener(paramDatabaseChangeListener);
/* 134 */     localNTFEventListener.setExecutor(paramExecutor);
/* 135 */     addListener(localNTFEventListener);
/*     */   }
/*     */ 
/*     */   public void addListener(DatabaseChangeListener paramDatabaseChangeListener)
/*     */     throws SQLException
/*     */   {
/* 149 */     NTFEventListener localNTFEventListener = new NTFEventListener(paramDatabaseChangeListener);
/* 150 */     addListener(localNTFEventListener);
/*     */   }
/*     */ 
/*     */   public void removeListener(DatabaseChangeListener paramDatabaseChangeListener)
/*     */     throws SQLException
/*     */   {
/* 163 */     super.removeListener(paramDatabaseChangeListener);
/*     */   }
/*     */ 
/*     */   synchronized void addTablesName(String[] paramArrayOfString, int paramInt)
/*     */   {
/* 170 */     if (this.nbOfStringsInTable + paramInt > this.tables.length)
/*     */     {
/* 172 */       String[] arrayOfString = new String[(this.nbOfStringsInTable + paramInt) * 2];
/* 173 */       System.arraycopy(this.tables, 0, arrayOfString, 0, this.tables.length);
/* 174 */       this.tables = arrayOfString;
/*     */     }
/*     */ 
/* 177 */     System.arraycopy(paramArrayOfString, 0, this.tables, this.nbOfStringsInTable, paramInt);
/* 178 */     this.nbOfStringsInTable += paramInt;
/*     */   }
/*     */ 
/*     */   public String[] getTables()
/*     */   {
/* 190 */     String[] arrayOfString = new String[this.nbOfStringsInTable];
/*     */ 
/* 195 */     System.arraycopy(this.tables, 0, arrayOfString, 0, this.nbOfStringsInTable);
/* 196 */     return arrayOfString;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFDCNRegistration
 * JD-Core Version:    0.6.2
 */