/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.nio.ByteBuffer;
/*     */ import oracle.jdbc.dcn.QueryChangeDescription;
/*     */ import oracle.jdbc.dcn.QueryChangeDescription.QueryChangeEventType;
/*     */ import oracle.jdbc.dcn.TableChangeDescription;
/*     */ 
/*     */ class NTFDCNQueryChanges
/*     */   implements QueryChangeDescription
/*     */ {
/*     */   private final long queryId;
/*     */   private final QueryChangeDescription.QueryChangeEventType queryopflags;
/*     */   private final int numberOfTables;
/*     */   private final NTFDCNTableChanges[] tcdesc;
/* 104 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFDCNQueryChanges(ByteBuffer paramByteBuffer, int paramInt)
/*     */   {
/*  50 */     long l1 = paramByteBuffer.getInt() & 0xFFFFFFFF;
/*  51 */     long l2 = paramByteBuffer.getInt() & 0xFFFFFFFF;
/*  52 */     this.queryId = (l1 | l2 << 32);
/*  53 */     this.queryopflags = QueryChangeDescription.QueryChangeEventType.getQueryChangeEventType(paramByteBuffer.getInt());
/*  54 */     this.numberOfTables = paramByteBuffer.getShort();
/*  55 */     this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
/*  56 */     for (int i = 0; i < this.tcdesc.length; i++)
/*  57 */       this.tcdesc[i] = new NTFDCNTableChanges(paramByteBuffer, paramInt);
/*     */   }
/*     */ 
/*     */   public long getQueryId()
/*     */   {
/*  64 */     return this.queryId;
/*     */   }
/*     */ 
/*     */   public QueryChangeDescription.QueryChangeEventType getQueryChangeEventType()
/*     */   {
/*  71 */     return this.queryopflags;
/*     */   }
/*     */ 
/*     */   public TableChangeDescription[] getTableChangeDescription()
/*     */   {
/*  78 */     return this.tcdesc;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  90 */     StringBuffer localStringBuffer = new StringBuffer();
/*  91 */     localStringBuffer.append("  query ID=" + this.queryId + ", query change event type=" + this.queryopflags + "\n");
/*  92 */     TableChangeDescription[] arrayOfTableChangeDescription = getTableChangeDescription();
/*  93 */     if (arrayOfTableChangeDescription != null)
/*     */     {
/*  95 */       localStringBuffer.append("  Table Change Description (length=" + arrayOfTableChangeDescription.length + "):");
/*  96 */       for (int i = 0; i < arrayOfTableChangeDescription.length; i++)
/*  97 */         localStringBuffer.append(arrayOfTableChangeDescription[i].toString());
/*     */     }
/*  99 */     return localStringBuffer.toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFDCNQueryChanges
 * JD-Core Version:    0.6.2
 */