/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import oracle.jdbc.dcn.DatabaseChangeEvent;
/*     */ import oracle.jdbc.dcn.DatabaseChangeEvent.AdditionalEventType;
/*     */ import oracle.jdbc.dcn.DatabaseChangeEvent.EventType;
/*     */ import oracle.jdbc.dcn.QueryChangeDescription;
/*     */ import oracle.jdbc.dcn.TableChangeDescription;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class NTFDCNEvent extends DatabaseChangeEvent
/*     */ {
/*  47 */   private int notifVersion = 0;
/*  48 */   private int notifRegid = 0;
/*     */   private DatabaseChangeEvent.EventType eventType;
/*  50 */   private DatabaseChangeEvent.AdditionalEventType additionalEventType = DatabaseChangeEvent.AdditionalEventType.NONE;
/*  51 */   private String databaseName = null;
/*  52 */   private byte[] notifXid = new byte[8];
/*  53 */   private int notifScn1 = 0;
/*  54 */   private int notifScn2 = 0;
/*     */ 
/*  56 */   private int numberOfTables = 0;
/*  57 */   private NTFDCNTableChanges[] tcdesc = null;
/*     */ 
/*  60 */   private int numberOfQueries = 0;
/*  61 */   private NTFDCNQueryChanges[] qdesc = null;
/*     */   private long registrationId;
/*     */   private NTFConnection conn;
/*     */   private int csid;
/*  66 */   private boolean isReady = false;
/*     */   private ByteBuffer dataBuffer;
/*  69 */   private boolean isDeregistrationEvent = false;
/*     */   private short databaseVersion;
/* 417 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFDCNEvent(NTFConnection paramNTFConnection, short paramShort)
/*     */     throws IOException, InterruptedException
/*     */   {
/*  76 */     super(paramNTFConnection);
/*     */ 
/*  78 */     this.conn = paramNTFConnection;
/*  79 */     this.csid = this.conn.charset.getOracleId();
/*     */ 
/*  82 */     int i = this.conn.readInt();
/*  83 */     byte[] arrayOfByte = new byte[i];
/*  84 */     this.conn.readBuffer(arrayOfByte, 0, i);
/*  85 */     this.dataBuffer = ByteBuffer.wrap(arrayOfByte);
/*  86 */     this.databaseVersion = paramShort;
/*     */   }
/*     */ 
/*     */   private void initEvent()
/*     */   {
/*  94 */     int i = this.dataBuffer.get();
/*  95 */     int j = this.dataBuffer.getInt();
/*  96 */     byte[] arrayOfByte1 = new byte[j];
/*  97 */     this.dataBuffer.get(arrayOfByte1, 0, j);
/*     */ 
/* 101 */     String str = null;
/*     */     try {
/* 103 */       str = new String(arrayOfByte1, "UTF-8");
/*     */     } catch (Exception localException1) {
/*     */     }
/* 106 */     str = str.replaceFirst("CHNF", "");
/* 107 */     this.registrationId = Long.parseLong(str);
/*     */ 
/* 110 */     int k = this.dataBuffer.get();
/* 111 */     int m = this.dataBuffer.getInt();
/* 112 */     byte[] arrayOfByte2 = new byte[m];
/* 113 */     this.dataBuffer.get(arrayOfByte2, 0, m);
/*     */ 
/* 116 */     int n = this.dataBuffer.get();
/* 117 */     int i1 = this.dataBuffer.getInt();
/* 118 */     if (this.dataBuffer.hasRemaining())
/*     */     {
/* 122 */       this.notifVersion = this.dataBuffer.getShort();
/* 123 */       this.notifRegid = this.dataBuffer.getInt();
/* 124 */       this.eventType = DatabaseChangeEvent.EventType.getEventType(this.dataBuffer.getInt());
/* 125 */       int i2 = this.dataBuffer.getShort();
/* 126 */       byte[] arrayOfByte3 = new byte[i2];
/* 127 */       this.dataBuffer.get(arrayOfByte3, 0, i2);
/*     */       try {
/* 129 */         this.databaseName = new String(arrayOfByte3, "UTF-8");
/*     */       }
/*     */       catch (Exception localException2)
/*     */       {
/*     */       }
/*     */ 
/* 138 */       this.dataBuffer.get(this.notifXid);
/*     */ 
/* 140 */       this.notifScn1 = this.dataBuffer.getInt();
/* 141 */       this.notifScn2 = this.dataBuffer.getShort();
/*     */       int i3;
/* 143 */       if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE)
/*     */       {
/* 145 */         this.numberOfTables = this.dataBuffer.getShort();
/* 146 */         this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
/* 147 */         for (i3 = 0; i3 < this.tcdesc.length; i3++)
/* 148 */           this.tcdesc[i3] = new NTFDCNTableChanges(this.dataBuffer, this.csid);
/*     */       }
/* 150 */       else if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE)
/*     */       {
/* 152 */         this.numberOfQueries = this.dataBuffer.getShort();
/* 153 */         this.qdesc = new NTFDCNQueryChanges[this.numberOfQueries];
/*     */ 
/* 162 */         for (i3 = 0; i3 < this.numberOfQueries; i3++)
/*     */         {
/* 164 */           this.qdesc[i3] = new NTFDCNQueryChanges(this.dataBuffer, this.csid);
/*     */         }
/*     */       }
/*     */     }
/* 168 */     this.isReady = true;
/*     */   }
/*     */ 
/*     */   public String getDatabaseName()
/*     */   {
/* 181 */     if (!this.isReady)
/* 182 */       initEvent();
/* 183 */     return this.databaseName;
/*     */   }
/*     */ 
/*     */   public TableChangeDescription[] getTableChangeDescription()
/*     */   {
/* 195 */     if (!this.isReady)
/* 196 */       initEvent();
/* 197 */     if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE)
/*     */     {
/* 199 */       return this.tcdesc;
/*     */     }
/*     */ 
/* 202 */     return null;
/*     */   }
/*     */ 
/*     */   public QueryChangeDescription[] getQueryChangeDescription()
/*     */   {
/* 214 */     if (!this.isReady)
/* 215 */       initEvent();
/* 216 */     if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE)
/*     */     {
/* 218 */       return this.qdesc;
/*     */     }
/*     */ 
/* 221 */     return null;
/*     */   }
/*     */ 
/*     */   public byte[] getTransactionId()
/*     */   {
/* 233 */     if (!this.isReady)
/* 234 */       initEvent();
/* 235 */     return this.notifXid;
/*     */   }
/*     */ 
/*     */   public String getTransactionId(boolean paramBoolean)
/*     */   {
/* 248 */     if (!this.isReady)
/* 249 */       initEvent();
/*     */     int i;
/*     */     int j;
/*     */     long l;
/* 252 */     if (!paramBoolean)
/*     */     {
/* 257 */       i = (this.notifXid[0] & 0xFF) << 8 | this.notifXid[1] & 0xFF;
/*     */ 
/* 260 */       j = (this.notifXid[2] & 0xFF) << 8 | this.notifXid[3] & 0xFF;
/*     */ 
/* 263 */       l = ((this.notifXid[4] & 0xFF) << 24 | (this.notifXid[5] & 0xFF) << 16 | (this.notifXid[6] & 0xFF) << 8 | this.notifXid[7] & 0xFF) & 0xFFFFFFFF;
/*     */     }
/*     */     else
/*     */     {
/* 272 */       i = (this.notifXid[1] & 0xFF) << 8 | this.notifXid[0] & 0xFF;
/*     */ 
/* 274 */       j = (this.notifXid[3] & 0xFF) << 8 | this.notifXid[2] & 0xFF;
/*     */ 
/* 276 */       l = ((this.notifXid[7] & 0xFF) << 24 | (this.notifXid[6] & 0xFF) << 16 | (this.notifXid[5] & 0xFF) << 8 | this.notifXid[4] & 0xFF) & 0xFFFFFFFF;
/*     */     }
/*     */ 
/* 283 */     String str = "" + i + "." + j + "." + l;
/* 284 */     return str;
/*     */   }
/*     */ 
/*     */   void setEventType(DatabaseChangeEvent.EventType paramEventType)
/*     */     throws IOException
/*     */   {
/* 292 */     if (!this.isReady)
/* 293 */       initEvent();
/* 294 */     this.eventType = paramEventType;
/* 295 */     if (this.eventType == DatabaseChangeEvent.EventType.DEREG)
/* 296 */       this.isDeregistrationEvent = true;
/*     */   }
/*     */ 
/*     */   void setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType paramAdditionalEventType)
/*     */   {
/* 303 */     this.additionalEventType = paramAdditionalEventType;
/*     */   }
/*     */ 
/*     */   public DatabaseChangeEvent.EventType getEventType()
/*     */   {
/* 315 */     if (!this.isReady)
/* 316 */       initEvent();
/* 317 */     return this.eventType;
/*     */   }
/*     */ 
/*     */   public DatabaseChangeEvent.AdditionalEventType getAdditionalEventType()
/*     */   {
/* 329 */     return this.additionalEventType;
/*     */   }
/*     */ 
/*     */   boolean isDeregistrationEvent()
/*     */   {
/* 338 */     return this.isDeregistrationEvent;
/*     */   }
/*     */ 
/*     */   public String getConnectionInformation()
/*     */   {
/* 350 */     return this.conn.connectionDescription;
/*     */   }
/*     */ 
/*     */   public int getRegistrationId()
/*     */   {
/* 362 */     if (!this.isReady)
/* 363 */       initEvent();
/* 364 */     return (int)this.registrationId;
/*     */   }
/*     */ 
/*     */   public long getRegId()
/*     */   {
/* 375 */     if (!this.isReady)
/* 376 */       initEvent();
/* 377 */     return this.registrationId;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 384 */     if (!this.isReady)
/* 385 */       initEvent();
/* 386 */     StringBuffer localStringBuffer = new StringBuffer();
/* 387 */     localStringBuffer.append("Connection information  : " + this.conn.connectionDescription + "\n");
/* 388 */     localStringBuffer.append("Registration ID         : " + this.registrationId + "\n");
/* 389 */     localStringBuffer.append("Notification version    : " + this.notifVersion + "\n");
/* 390 */     localStringBuffer.append("Event type              : " + this.eventType + "\n");
/* 391 */     if (this.additionalEventType != DatabaseChangeEvent.AdditionalEventType.NONE)
/* 392 */       localStringBuffer.append("Additional event type   : " + this.additionalEventType + "\n");
/* 393 */     if (this.databaseName != null) {
/* 394 */       localStringBuffer.append("Database name           : " + this.databaseName + "\n");
/*     */     }
/*     */ 
/* 398 */     TableChangeDescription[] arrayOfTableChangeDescription = getTableChangeDescription();
/* 399 */     if (arrayOfTableChangeDescription != null)
/*     */     {
/* 401 */       localStringBuffer.append("Table Change Description (length=" + this.numberOfTables + ")\n");
/* 402 */       for (int i = 0; i < arrayOfTableChangeDescription.length; i++)
/* 403 */         localStringBuffer.append(arrayOfTableChangeDescription[i].toString());
/*     */     }
/* 405 */     QueryChangeDescription[] arrayOfQueryChangeDescription = getQueryChangeDescription();
/* 406 */     if (arrayOfQueryChangeDescription != null)
/*     */     {
/* 408 */       localStringBuffer.append("Query Change Description (length=" + this.numberOfQueries + ")\n");
/* 409 */       for (int j = 0; j < arrayOfQueryChangeDescription.length; j++) {
/* 410 */         localStringBuffer.append(arrayOfQueryChangeDescription[j].toString());
/*     */       }
/*     */     }
/* 413 */     return localStringBuffer.toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFDCNEvent
 * JD-Core Version:    0.6.2
 */