/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.channels.SelectionKey;
/*     */ import java.nio.channels.Selector;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import oracle.jdbc.aq.AQNotificationEvent.AdditionalEventType;
/*     */ import oracle.jdbc.aq.AQNotificationEvent.EventType;
/*     */ import oracle.jdbc.dcn.DatabaseChangeEvent.AdditionalEventType;
/*     */ import oracle.jdbc.dcn.DatabaseChangeEvent.EventType;
/*     */ import oracle.sql.CharacterSet;
/*     */ 
/*     */ class NTFConnection extends Thread
/*     */ {
/*     */   private static final int NS_HEADER_SIZE = 10;
/*     */   private SocketChannel channel;
/*  71 */   private ByteBuffer inBuffer = null;
/*  72 */   private ByteBuffer outBuffer = null;
/*     */   private int currentNSPacketLength;
/*     */   private int currentNSPacketType;
/*     */   private ByteBuffer currentNSPacketDataBuffer;
/*  83 */   private boolean needsToBeClosed = false;
/*     */   private NTFManager ntfManager;
/*  87 */   private Selector selector = null;
/*  88 */   private Iterator iterator = null;
/*  89 */   private SelectionKey aKey = null;
/*     */   int remotePort;
/*     */   String remoteAddress;
/*     */   String remoteName;
/*     */   int localPort;
/*     */   String localAddress;
/*     */   String localName;
/*     */   String connectionDescription;
/* 100 */   CharacterSet charset = null;
/*     */   static final int NSPTCN = 1;
/*     */   static final int NSPTAC = 2;
/*     */   static final int NSPTAK = 3;
/*     */   static final int NSPTRF = 4;
/*     */   static final int NSPTRD = 5;
/*     */   static final int NSPTDA = 6;
/*     */   static final int NSPTNL = 7;
/*     */   static final int NSPTAB = 9;
/*     */   static final int NSPTRS = 11;
/*     */   static final int NSPTMK = 12;
/*     */   static final int NSPTAT = 13;
/*     */   static final int NSPTCNL = 14;
/*     */   static final int NSPTHI = 19;
/*     */   static final short KPDNFY_TIMEOUT = 1;
/*     */   static final short KPDNFY_GROUPING = 2;
/* 839 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFConnection(NTFManager paramNTFManager, SocketChannel paramSocketChannel)
/*     */   {
/*     */     try
/*     */     {
/* 125 */       this.ntfManager = paramNTFManager;
/* 126 */       this.channel = paramSocketChannel;
/* 127 */       this.channel.configureBlocking(false);
/*     */ 
/* 139 */       this.inBuffer = ByteBuffer.allocate(4096);
/* 140 */       this.outBuffer = ByteBuffer.allocate(2048);
/* 141 */       Socket localSocket = this.channel.socket();
/* 142 */       InetAddress localInetAddress1 = localSocket.getInetAddress();
/* 143 */       InetAddress localInetAddress2 = localSocket.getLocalAddress();
/* 144 */       this.remotePort = localSocket.getPort();
/* 145 */       this.localPort = localSocket.getLocalPort();
/* 146 */       this.remoteAddress = localInetAddress1.getHostAddress();
/* 147 */       this.remoteName = localInetAddress1.getHostName();
/* 148 */       this.localAddress = localInetAddress2.getHostAddress();
/* 149 */       this.localName = localInetAddress2.getHostName();
/* 150 */       this.connectionDescription = ("local=" + this.localName + "/" + this.localAddress + ":" + this.localPort + ", remote=" + this.remoteName + "/" + this.remoteAddress + ":" + this.remotePort);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/* 166 */       this.selector = Selector.open();
/* 167 */       this.channel.register(this.selector, 1);
/*     */ 
/* 169 */       int i = 0;
/*     */ 
/* 172 */       this.inBuffer.limit(0);
/*     */ 
/* 174 */       while (!this.needsToBeClosed)
/*     */       {
/* 177 */         if (!this.inBuffer.hasRemaining()) {
/*     */           do {
/* 179 */             i = readFromNetwork();
/*     */           }
/* 181 */           while (i == 0);
/*     */         }
/* 183 */         unmarshalOneNSPacket();
/*     */       }
/*     */     }
/*     */     catch (IOException localIOException2)
/*     */     {
/*     */     }
/*     */     catch (InterruptedException localInterruptedException) {
/*     */     }
/*     */     finally {
/*     */       try {
/* 193 */         this.selector.close();
/* 194 */         this.channel.close();
/*     */       }
/*     */       catch (IOException localIOException5)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private int readFromNetwork()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 225 */     this.inBuffer.compact();
/*     */     while (true)
/*     */     {
/* 228 */       if ((this.iterator == null) || (!this.iterator.hasNext()))
/*     */       {
/* 232 */         this.selector.select();
/*     */ 
/* 236 */         if (this.needsToBeClosed)
/*     */         {
/* 238 */           throw new InterruptedException();
/*     */         }
/* 240 */         this.iterator = this.selector.selectedKeys().iterator();
/*     */       } else {
/* 242 */         this.aKey = ((SelectionKey)this.iterator.next());
/*     */ 
/* 244 */         if ((this.aKey.readyOps() & 0x1) == 1) {
/* 245 */           break;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 255 */     int i = this.channel.read(this.inBuffer);
/*     */ 
/* 257 */     if (i < 0)
/*     */     {
/* 259 */       throw new EOFException();
/* 260 */     }if (i > 0)
/*     */     {
/* 263 */       this.inBuffer.flip();
/*     */     }
/*     */ 
/* 267 */     this.iterator.remove();
/*     */ 
/* 269 */     return i;
/*     */   }
/*     */ 
/*     */   private void getNextNSPacket()
/*     */     throws IOException, InterruptedException
/*     */   {
/*     */     int i;
/* 286 */     while ((!this.inBuffer.hasRemaining()) || (this.inBuffer.remaining() < 10)) {
/* 287 */       i = readFromNetwork();
/*     */     }
/*     */ 
/* 290 */     this.currentNSPacketLength = this.inBuffer.getShort();
/*     */ 
/* 292 */     this.inBuffer.position(this.inBuffer.position() + 2);
/* 293 */     this.currentNSPacketType = this.inBuffer.get();
/* 294 */     this.inBuffer.position(this.inBuffer.position() + 5);
/*     */ 
/* 298 */     while (this.inBuffer.remaining() < this.currentNSPacketLength - 10) {
/* 299 */       i = readFromNetwork();
/*     */     }
/*     */ 
/* 303 */     int j = this.inBuffer.limit();
/* 304 */     int k = this.inBuffer.position() + this.currentNSPacketLength - 10;
/*     */ 
/* 308 */     this.inBuffer.limit(k);
/* 309 */     this.currentNSPacketDataBuffer = this.inBuffer.slice();
/* 310 */     this.inBuffer.limit(j);
/*     */ 
/* 312 */     this.inBuffer.position(k);
/*     */   }
/*     */ 
/*     */   private void unmarshalOneNSPacket()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 331 */     getNextNSPacket();
/*     */ 
/* 335 */     if (this.currentNSPacketDataBuffer.hasRemaining())
/* 336 */       switch (this.currentNSPacketType)
/*     */       {
/*     */       case 1:
/* 340 */         byte[] arrayOfByte1 = { 0, 24, 0, 0, 2, 0, 0, 0, 1, 52, 0, 0, 8, 0, 127, -1, 1, 0, 0, 0, 0, 24, 65, 1 };
/*     */ 
/* 345 */         this.outBuffer.clear();
/* 346 */         this.outBuffer.put(arrayOfByte1);
/* 347 */         this.outBuffer.limit(24);
/* 348 */         this.outBuffer.rewind();
/* 349 */         this.channel.write(this.outBuffer);
/* 350 */         break;
/*     */       case 6:
/* 353 */         if ((this.currentNSPacketDataBuffer.get(0) == -34) && (this.currentNSPacketDataBuffer.get(1) == -83))
/*     */         {
/* 357 */           byte[] arrayOfByte2 = { 0, 127, 0, 0, 6, 0, 0, 0, 0, 0, -34, -83, -66, -17, 0, 117, 10, 32, 1, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, 0, 31, 0, 14, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 2, 0, 4, 0, 1, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, -5, -1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0 };
/*     */ 
/* 375 */           this.outBuffer.clear();
/* 376 */           this.outBuffer.put(arrayOfByte2);
/* 377 */           this.outBuffer.limit(arrayOfByte2.length);
/* 378 */           this.outBuffer.rewind();
/* 379 */           this.channel.write(this.outBuffer);
/*     */         }
/*     */         else
/*     */         {
/* 424 */           unmarshalNSDataPacket();
/*     */         }
/*     */         break;
/*     */       }
/*     */   }
/*     */ 
/*     */   private void unmarshalNSDataPacket()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 499 */     int i = readShort();
/*     */ 
/* 502 */     int j = readInt();
/*     */ 
/* 504 */     int k = readByte();
/* 505 */     int m = readInt();
/* 506 */     int n = readShort();
/* 507 */     if ((this.charset == null) || (this.charset.getOracleId() != n)) {
/* 508 */       this.charset = CharacterSet.make(n);
/*     */     }
/*     */ 
/* 511 */     int i1 = readByte();
/* 512 */     int i2 = readInt();
/* 513 */     int i3 = readShort();
/*     */ 
/* 516 */     int i4 = readByte();
/* 517 */     int i5 = readInt();
/* 518 */     int i6 = readShort();
/*     */ 
/* 524 */     int i7 = (j - 21) / 9;
/* 525 */     int[] arrayOfInt = new int[i7];
/* 526 */     for (int i8 = 0; i8 < i7; i8++)
/*     */     {
/* 528 */       int i9 = readByte();
/* 529 */       i10 = readInt();
/* 530 */       byte[] arrayOfByte = new byte[i10];
/* 531 */       readBuffer(arrayOfByte, 0, i10);
/*     */ 
/* 535 */       for (int i11 = 0; i11 < i10; i11++) {
/* 536 */         if (i11 < 4)
/* 537 */           arrayOfInt[i8] |= (arrayOfByte[i11] & 0xFF) << 8 * (i10 - i11 - 1);
/*     */       }
/*     */     }
/* 540 */     NTFDCNEvent localNTFDCNEvent = null;
/* 541 */     NTFAQEvent localNTFAQEvent = null;
/* 542 */     int i10 = 0;
/* 543 */     short s = 0;
/* 544 */     NTFRegistration[] arrayOfNTFRegistration = null;
/*     */     int i13;
/* 546 */     if (i >= 2)
/*     */     {
/* 549 */       i12 = readShort();
/* 550 */       arrayOfNTFRegistration = new NTFRegistration[arrayOfInt.length];
/* 551 */       for (i13 = 0; i13 < arrayOfInt.length; i13++)
/*     */       {
/* 553 */         arrayOfNTFRegistration[i13] = this.ntfManager.getRegistration(arrayOfInt[i13]);
/* 554 */         if (arrayOfNTFRegistration[i13] != null)
/*     */         {
/* 556 */           i10 = arrayOfNTFRegistration[i13].getNamespace();
/* 557 */           s = arrayOfNTFRegistration[i13].getDatabaseVersion();
/*     */         }
/*     */       }
/*     */ 
/* 561 */       if (i10 == 2)
/*     */       {
/* 564 */         localNTFDCNEvent = new NTFDCNEvent(this, s);
/*     */       }
/* 566 */       else if (i10 == 1)
/*     */       {
/* 569 */         localNTFAQEvent = new NTFAQEvent(this, s);
/*     */       }
/* 571 */       else if (i10 != 0);
/*     */     }
/*     */ 
/* 584 */     int i12 = 0;
/* 585 */     if (i >= 3)
/*     */     {
/* 588 */       i13 = readShort();
/* 589 */       int i14 = readInt();
/* 590 */       int i15 = readByte();
/* 591 */       int i16 = readInt();
/* 592 */       i12 = readShort();
/* 593 */       if ((i10 == 2) && (localNTFDCNEvent != null))
/*     */       {
/* 596 */         localNTFDCNEvent.setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType.getEventType(i12));
/*     */ 
/* 599 */         if (i12 == 1)
/* 600 */           localNTFDCNEvent.setEventType(DatabaseChangeEvent.EventType.DEREG);
/*     */       }
/* 602 */       else if ((i10 == 1) && (localNTFAQEvent != null))
/*     */       {
/* 605 */         localNTFAQEvent.setAdditionalEventType(AQNotificationEvent.AdditionalEventType.getEventType(i12));
/*     */ 
/* 608 */         if (i12 == 1) {
/* 609 */           localNTFAQEvent.setEventType(AQNotificationEvent.EventType.DEREG);
/*     */         }
/*     */       }
/*     */     }
/* 613 */     if ((i <= 3) || 
/* 618 */       (arrayOfNTFRegistration != null))
/*     */     {
/* 620 */       if (i10 == 2)
/* 621 */         for (i13 = 0; i13 < arrayOfNTFRegistration.length; i13++)
/* 622 */           if ((arrayOfNTFRegistration[i13] != null) && (localNTFDCNEvent != null))
/*     */           {
/* 624 */             arrayOfNTFRegistration[i13].notify(localNTFDCNEvent);
/*     */           }
/* 626 */       if (i10 == 1)
/* 627 */         for (i13 = 0; i13 < arrayOfNTFRegistration.length; i13++)
/* 628 */           if ((arrayOfNTFRegistration[i13] != null) && (localNTFAQEvent != null))
/*     */           {
/* 630 */             arrayOfNTFRegistration[i13].notify(localNTFAQEvent);
/*     */           }
/*     */     }
/*     */   }
/*     */ 
/*     */   void closeThisConnection()
/*     */   {
/* 643 */     this.needsToBeClosed = true;
/*     */   }
/*     */ 
/*     */   byte readByte()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 655 */     byte b = 0;
/* 656 */     if (this.currentNSPacketDataBuffer.hasRemaining())
/*     */     {
/* 658 */       b = this.currentNSPacketDataBuffer.get();
/*     */     }
/*     */     else
/*     */     {
/* 662 */       getNextNSPacket();
/* 663 */       this.currentNSPacketDataBuffer.get();
/*     */     }
/* 665 */     return b;
/*     */   }
/*     */ 
/*     */   short readShort()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 675 */     short s = 0;
/* 676 */     if (this.currentNSPacketDataBuffer.remaining() >= 2)
/*     */     {
/* 678 */       s = this.currentNSPacketDataBuffer.getShort();
/*     */     }
/*     */     else
/*     */     {
/* 685 */       int i = readByte() & 0xFF;
/* 686 */       int j = readByte() & 0xFF;
/* 687 */       s = (short)(i << 8 | j);
/*     */     }
/* 689 */     return s;
/*     */   }
/*     */ 
/*     */   int readInt()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 699 */     int i = 0;
/* 700 */     if (this.currentNSPacketDataBuffer.remaining() >= 4)
/*     */     {
/* 702 */       i = this.currentNSPacketDataBuffer.getInt();
/*     */     }
/*     */     else
/*     */     {
/* 709 */       int j = readByte() & 0xFF;
/* 710 */       int k = readByte() & 0xFF;
/* 711 */       int m = readByte() & 0xFF;
/* 712 */       int n = readByte() & 0xFF;
/* 713 */       i = j << 24 | k << 16 | m << 8 | n;
/*     */     }
/* 715 */     return i;
/*     */   }
/*     */ 
/*     */   long readLong()
/*     */     throws IOException, InterruptedException
/*     */   {
/* 725 */     long l1 = 0L;
/* 726 */     if (this.currentNSPacketDataBuffer.remaining() >= 8)
/*     */     {
/* 728 */       l1 = this.currentNSPacketDataBuffer.getLong();
/*     */     }
/*     */     else
/*     */     {
/* 735 */       long l2 = readByte() & 0xFF;
/* 736 */       long l3 = readByte() & 0xFF;
/* 737 */       long l4 = readByte() & 0xFF;
/* 738 */       long l5 = readByte() & 0xFF;
/* 739 */       long l6 = readByte() & 0xFF;
/* 740 */       long l7 = readByte() & 0xFF;
/* 741 */       long l8 = readByte() & 0xFF;
/* 742 */       long l9 = readByte() & 0xFF;
/* 743 */       l1 = l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9;
/*     */     }
/* 745 */     return l1;
/*     */   }
/*     */ 
/*     */   void readBuffer(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, InterruptedException
/*     */   {
/* 758 */     if (this.currentNSPacketDataBuffer.remaining() >= paramInt2)
/*     */     {
/* 760 */       this.currentNSPacketDataBuffer.get(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 764 */       int i = 0;
/* 765 */       int j = 0;
/* 766 */       int k = 0;
/* 767 */       int m = this.currentNSPacketDataBuffer.remaining();
/* 768 */       this.currentNSPacketDataBuffer.get(paramArrayOfByte, paramInt1, m);
/* 769 */       paramInt1 += m;
/* 770 */       j += m;
/*     */ 
/* 772 */       while (i == 0)
/*     */       {
/* 774 */         getNextNSPacket();
/* 775 */         m = this.currentNSPacketDataBuffer.remaining();
/* 776 */         k = Math.min(m, paramInt2 - j);
/*     */ 
/* 778 */         this.currentNSPacketDataBuffer.get(paramArrayOfByte, paramInt1, k);
/* 779 */         paramInt1 += k;
/* 780 */         j += k;
/* 781 */         if (j == paramInt2)
/* 782 */           i = 1;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String packetToString(ByteBuffer paramByteBuffer)
/*     */     throws IOException
/*     */   {
/* 794 */     int i = 0;
/*     */ 
/* 796 */     char[] arrayOfChar = new char[8];
/* 797 */     StringBuffer localStringBuffer = new StringBuffer();
/* 798 */     int k = paramByteBuffer.position();
/*     */ 
/* 800 */     while (paramByteBuffer.hasRemaining()) {
/* 801 */       int j = paramByteBuffer.get();
/* 802 */       String str = Integer.toHexString(j & 0xFF);
/* 803 */       str = str.toUpperCase();
/* 804 */       if (str.length() == 1)
/* 805 */         str = "0" + str;
/* 806 */       localStringBuffer.append(str);
/* 807 */       localStringBuffer.append(' ');
/* 808 */       if ((j > 32) && (j < 127))
/* 809 */         arrayOfChar[i] = ((char)j);
/*     */       else
/* 811 */         arrayOfChar[i] = '.';
/* 812 */       i++;
/* 813 */       if (i == 8) {
/* 814 */         localStringBuffer.append('|');
/* 815 */         localStringBuffer.append(arrayOfChar);
/* 816 */         localStringBuffer.append('|');
/* 817 */         localStringBuffer.append('\n');
/* 818 */         i = 0;
/*     */       }
/*     */     }
/* 821 */     if (i != 0) {
/* 822 */       int m = 8 - i;
/* 823 */       for (int n = 0; n < m * 3; n++)
/* 824 */         localStringBuffer.append(' ');
/* 825 */       localStringBuffer.append('|');
/* 826 */       localStringBuffer.append(arrayOfChar, 0, i);
/* 827 */       for (n = 0; n < m; n++)
/* 828 */         localStringBuffer.append(' ');
/* 829 */       localStringBuffer.append('|');
/* 830 */       localStringBuffer.append('\n');
/*     */     }
/* 832 */     localStringBuffer.append("\nEnd of Packet\n\n");
/* 833 */     paramByteBuffer.position(k);
/* 834 */     return localStringBuffer.toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFConnection
 * JD-Core Version:    0.6.2
 */