/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQMessageProperties;
/*     */ import oracle.jdbc.aq.AQMessageProperties.DeliveryMode;
/*     */ import oracle.jdbc.aq.AQMessageProperties.MessageState;
/*     */ import oracle.jdbc.aq.AQNotificationEvent;
/*     */ import oracle.jdbc.aq.AQNotificationEvent.AdditionalEventType;
/*     */ import oracle.jdbc.aq.AQNotificationEvent.EventType;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ class NTFAQEvent extends AQNotificationEvent
/*     */ {
/*     */   private String registrationString;
/*     */   private int namespace;
/*     */   private byte[] payload;
/*  47 */   private String queueName = null;
/*  48 */   private byte[] messageId = null;
/*  49 */   private String consumerName = null;
/*     */   private NTFConnection conn;
/*     */   private AQMessagePropertiesI msgProp;
/*  52 */   private AQNotificationEvent.EventType eventType = AQNotificationEvent.EventType.REGULAR;
/*  53 */   private AQNotificationEvent.AdditionalEventType additionalEventType = AQNotificationEvent.AdditionalEventType.NONE;
/*     */   private ByteBuffer dataBuffer;
/*  55 */   private boolean isReady = false;
/*     */   private short databaseVersion;
/* 457 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NTFAQEvent(NTFConnection paramNTFConnection, short paramShort)
/*     */     throws IOException, InterruptedException
/*     */   {
/*  62 */     super(paramNTFConnection);
/*     */ 
/*  64 */     this.conn = paramNTFConnection;
/*  65 */     int i = this.conn.readInt();
/*  66 */     byte[] arrayOfByte = new byte[i];
/*  67 */     this.conn.readBuffer(arrayOfByte, 0, i);
/*  68 */     this.dataBuffer = ByteBuffer.wrap(arrayOfByte);
/*  69 */     this.databaseVersion = paramShort;
/*     */   }
/*     */ 
/*     */   private void initEvent()
/*     */     throws SQLException
/*     */   {
/*  76 */     int i = this.dataBuffer.get();
/*  77 */     int j = this.dataBuffer.getInt();
/*  78 */     byte[] arrayOfByte1 = new byte[j];
/*  79 */     this.dataBuffer.get(arrayOfByte1, 0, j);
/*  80 */     this.registrationString = this.conn.charset.toString(arrayOfByte1, 0, j);
/*     */ 
/*  84 */     int k = this.dataBuffer.get();
/*  85 */     int m = this.dataBuffer.getInt();
/*  86 */     byte[] arrayOfByte2 = new byte[m];
/*  87 */     this.dataBuffer.get(arrayOfByte2, 0, m);
/*  88 */     this.namespace = arrayOfByte2[0];
/*     */ 
/*  91 */     int n = this.dataBuffer.get();
/*  92 */     int i1 = this.dataBuffer.getInt();
/*  93 */     if (i1 > 0)
/*     */     {
/*  95 */       this.payload = new byte[i1];
/*  96 */       this.dataBuffer.get(this.payload, 0, i1);
/*     */     }
/*     */     else {
/*  99 */       this.payload = null;
/*     */     }
/* 101 */     if (this.dataBuffer.hasRemaining())
/*     */     {
/* 103 */       int i2 = 0;
/* 104 */       if (this.databaseVersion >= 10200)
/*     */       {
/* 107 */         i3 = this.dataBuffer.get();
/* 108 */         i4 = this.dataBuffer.getInt();
/* 109 */         i2 = this.dataBuffer.getInt();
/*     */       }
/*     */ 
/* 113 */       int i3 = this.dataBuffer.get();
/* 114 */       int i4 = this.dataBuffer.getInt();
/* 115 */       byte[] arrayOfByte3 = new byte[i4];
/* 116 */       this.dataBuffer.get(arrayOfByte3, 0, i4);
/* 117 */       this.queueName = this.conn.charset.toString(arrayOfByte3, 0, i4);
/*     */ 
/* 121 */       int i5 = this.dataBuffer.get();
/* 122 */       int i6 = this.dataBuffer.getInt();
/* 123 */       this.messageId = new byte[i6];
/* 124 */       this.dataBuffer.get(this.messageId, 0, i6);
/*     */ 
/* 127 */       int i7 = this.dataBuffer.get();
/* 128 */       int i8 = this.dataBuffer.getInt();
/* 129 */       byte[] arrayOfByte4 = new byte[i8];
/* 130 */       this.dataBuffer.get(arrayOfByte4, 0, i8);
/* 131 */       this.consumerName = this.conn.charset.toString(arrayOfByte4, 0, i8);
/*     */ 
/* 135 */       int i9 = this.dataBuffer.get();
/* 136 */       int i10 = this.dataBuffer.getInt();
/* 137 */       byte[] arrayOfByte5 = new byte[i10];
/* 138 */       this.dataBuffer.get(arrayOfByte5, 0, i10);
/*     */ 
/* 141 */       int i11 = this.dataBuffer.get();
/* 142 */       int i12 = this.dataBuffer.getInt();
/* 143 */       int i13 = this.dataBuffer.getInt();
/* 144 */       if (arrayOfByte5[0] == 1)
/* 145 */         i13 = -i13;
/* 146 */       int i14 = i13;
/*     */ 
/* 149 */       int i15 = this.dataBuffer.get();
/* 150 */       int i16 = this.dataBuffer.getInt();
/* 151 */       int i17 = this.dataBuffer.getInt();
/*     */ 
/* 154 */       int i18 = this.dataBuffer.get();
/* 155 */       int i19 = this.dataBuffer.getInt();
/* 156 */       byte[] arrayOfByte6 = new byte[i19];
/* 157 */       this.dataBuffer.get(arrayOfByte6, 0, i19);
/*     */ 
/* 160 */       int i20 = this.dataBuffer.get();
/* 161 */       int i21 = this.dataBuffer.getInt();
/* 162 */       int i22 = this.dataBuffer.getInt();
/* 163 */       if (arrayOfByte6[0] == 1)
/* 164 */         i22 = -i22;
/* 165 */       int i23 = i22;
/*     */ 
/* 168 */       int i24 = this.dataBuffer.get();
/* 169 */       int i25 = this.dataBuffer.getInt();
/* 170 */       int i26 = this.dataBuffer.getInt();
/*     */ 
/* 173 */       int i27 = this.dataBuffer.get();
/* 174 */       int i28 = this.dataBuffer.getInt();
/* 175 */       byte[] arrayOfByte7 = new byte[i28];
/* 176 */       this.dataBuffer.get(arrayOfByte7, 0, i28);
/* 177 */       TIMESTAMP localTIMESTAMP = new TIMESTAMP(arrayOfByte7);
/*     */ 
/* 180 */       int i29 = this.dataBuffer.get();
/* 181 */       int i30 = this.dataBuffer.getInt();
/* 182 */       byte[] arrayOfByte8 = new byte[i30];
/* 183 */       this.dataBuffer.get(arrayOfByte8, 0, i30);
/* 184 */       int i31 = arrayOfByte8[0];
/*     */ 
/* 187 */       int i32 = this.dataBuffer.get();
/* 188 */       int i33 = this.dataBuffer.getInt();
/* 189 */       byte[] arrayOfByte9 = new byte[i33];
/* 190 */       this.dataBuffer.get(arrayOfByte9, 0, i33);
/* 191 */       String str1 = this.conn.charset.toString(arrayOfByte9, 0, i33);
/*     */ 
/* 195 */       int i34 = this.dataBuffer.get();
/* 196 */       int i35 = this.dataBuffer.getInt();
/* 197 */       byte[] arrayOfByte10 = new byte[i35];
/* 198 */       this.dataBuffer.get(arrayOfByte10, 0, i35);
/* 199 */       String str2 = this.conn.charset.toString(arrayOfByte10, 0, i35);
/*     */ 
/* 203 */       int i36 = this.dataBuffer.get();
/* 204 */       int i37 = this.dataBuffer.getInt();
/* 205 */       byte[] arrayOfByte11 = null;
/* 206 */       if (i37 > 0)
/*     */       {
/* 208 */         arrayOfByte11 = new byte[i37];
/* 209 */         this.dataBuffer.get(arrayOfByte11, 0, i37);
/*     */       }
/*     */ 
/* 213 */       int i38 = this.dataBuffer.get();
/* 214 */       int i39 = this.dataBuffer.getInt();
/* 215 */       byte[] arrayOfByte12 = new byte[i39];
/* 216 */       this.dataBuffer.get(arrayOfByte12, 0, i39);
/* 217 */       String str3 = this.conn.charset.toString(arrayOfByte12, 0, i39);
/*     */ 
/* 221 */       int i40 = this.dataBuffer.get();
/* 222 */       int i41 = this.dataBuffer.getInt();
/* 223 */       byte[] arrayOfByte13 = new byte[i41];
/* 224 */       this.dataBuffer.get(arrayOfByte13, 0, i41);
/* 225 */       String str4 = this.conn.charset.toString(arrayOfByte13, 0, i41);
/*     */ 
/* 229 */       int i42 = this.dataBuffer.get();
/* 230 */       int i43 = this.dataBuffer.getInt();
/* 231 */       int i44 = this.dataBuffer.get();
/*     */ 
/* 236 */       this.msgProp = new AQMessagePropertiesI();
/* 237 */       this.msgProp.setAttempts(i26);
/* 238 */       this.msgProp.setCorrelation(str2);
/* 239 */       this.msgProp.setDelay(i17);
/* 240 */       this.msgProp.setEnqueueTime(localTIMESTAMP.timestampValue());
/* 241 */       this.msgProp.setMessageState(AQMessageProperties.MessageState.getMessageState(i31));
/* 242 */       if (this.databaseVersion >= 10200)
/* 243 */         this.msgProp.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(i2));
/* 244 */       this.msgProp.setPreviousQueueMessageId(arrayOfByte11);
/* 245 */       AQAgentI localAQAgentI = new AQAgentI();
/* 246 */       localAQAgentI.setAddress(str4);
/* 247 */       localAQAgentI.setName(str3);
/* 248 */       localAQAgentI.setProtocol(i44);
/* 249 */       this.msgProp.setSender(localAQAgentI);
/*     */ 
/* 251 */       this.msgProp.setPriority(i14);
/* 252 */       this.msgProp.setExpiration(i23);
/* 253 */       this.msgProp.setExceptionQueue(str1);
/*     */     }
/* 255 */     this.isReady = true;
/*     */   }
/*     */ 
/*     */   public AQMessageProperties getMessageProperties()
/*     */     throws SQLException
/*     */   {
/* 267 */     if (!this.isReady)
/* 268 */       initEvent();
/* 269 */     return this.msgProp;
/*     */   }
/*     */ 
/*     */   public String getRegistration()
/*     */     throws SQLException
/*     */   {
/* 281 */     if (!this.isReady)
/* 282 */       initEvent();
/* 283 */     return this.registrationString;
/*     */   }
/*     */ 
/*     */   public AQNotificationEvent.EventType getEventType()
/*     */   {
/* 295 */     return this.eventType;
/*     */   }
/*     */ 
/*     */   public AQNotificationEvent.AdditionalEventType getAdditionalEventType()
/*     */   {
/* 307 */     return this.additionalEventType;
/*     */   }
/*     */ 
/*     */   void setEventType(AQNotificationEvent.EventType paramEventType)
/*     */     throws IOException
/*     */   {
/* 314 */     this.eventType = paramEventType;
/*     */   }
/*     */ 
/*     */   void setAdditionalEventType(AQNotificationEvent.AdditionalEventType paramAdditionalEventType)
/*     */   {
/* 321 */     this.additionalEventType = paramAdditionalEventType;
/*     */   }
/*     */ 
/*     */   public byte[] getPayload()
/*     */     throws SQLException
/*     */   {
/* 333 */     if (!this.isReady)
/* 334 */       initEvent();
/* 335 */     return this.payload;
/*     */   }
/*     */ 
/*     */   public String getQueueName()
/*     */     throws SQLException
/*     */   {
/* 347 */     if (!this.isReady)
/* 348 */       initEvent();
/* 349 */     return this.queueName;
/*     */   }
/*     */ 
/*     */   public byte[] getMessageId()
/*     */     throws SQLException
/*     */   {
/* 361 */     if (!this.isReady)
/* 362 */       initEvent();
/* 363 */     return this.messageId;
/*     */   }
/*     */ 
/*     */   public String getConsumerName()
/*     */     throws SQLException
/*     */   {
/* 375 */     if (!this.isReady)
/* 376 */       initEvent();
/* 377 */     return this.consumerName;
/*     */   }
/*     */ 
/*     */   public String getConnectionInformation()
/*     */   {
/* 389 */     return this.conn.connectionDescription;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 397 */     if (!this.isReady)
/*     */     {
/*     */       try
/*     */       {
/* 401 */         initEvent();
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 405 */         return localSQLException.getMessage();
/*     */       }
/*     */     }
/* 408 */     StringBuffer localStringBuffer = new StringBuffer();
/* 409 */     localStringBuffer.append("Connection information  : " + this.conn.connectionDescription + "\n");
/* 410 */     localStringBuffer.append("Event type              : " + this.eventType + "\n");
/* 411 */     if (this.additionalEventType != AQNotificationEvent.AdditionalEventType.NONE)
/* 412 */       localStringBuffer.append("Additional event type   : " + this.additionalEventType + "\n");
/* 413 */     localStringBuffer.append("Namespace               : " + this.namespace + "\n");
/* 414 */     localStringBuffer.append("Registration            : " + this.registrationString + "\n");
/* 415 */     localStringBuffer.append("Queue name              : " + this.queueName + "\n");
/* 416 */     localStringBuffer.append("Consumer name           : " + this.consumerName + "\n");
/* 417 */     if (this.payload != null)
/*     */     {
/* 419 */       localStringBuffer.append("Payload length          : " + this.payload.length + "\n");
/* 420 */       localStringBuffer.append("Payload (first 50 bytes): " + byteBufferToHexString(this.payload, 50) + "\n");
/*     */     }
/*     */     else {
/* 423 */       localStringBuffer.append("Payload                 : null\n");
/* 424 */     }localStringBuffer.append("Message ID              : " + byteBufferToHexString(this.messageId, 50) + "\n");
/* 425 */     if (this.msgProp != null)
/* 426 */       localStringBuffer.append(this.msgProp.toString());
/* 427 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   static final String byteBufferToHexString(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 433 */     if (paramArrayOfByte == null) {
/* 434 */       return null;
/*     */     }
/* 436 */     int i = 0;
/* 437 */     int j = 1;
/* 438 */     StringBuffer localStringBuffer = new StringBuffer();
/* 439 */     while ((i < paramArrayOfByte.length) && (i < paramInt))
/*     */     {
/* 441 */       if (j == 0)
/* 442 */         localStringBuffer.append(' ');
/*     */       else
/* 444 */         j = 0;
/* 445 */       str = Integer.toHexString(paramArrayOfByte[i] & 0xFF);
/* 446 */       if (str.length() == 1)
/* 447 */         str = "0" + str;
/* 448 */       localStringBuffer.append(str);
/* 449 */       i++;
/*     */     }
/* 451 */     String str = localStringBuffer.toString();
/* 452 */     return str;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.NTFAQEvent
 * JD-Core Version:    0.6.2
 */