/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class LongRawAccessor extends RawCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 2147483647;
/*     */   OracleInputStream stream;
/*  30 */   int columnPosition = 0;
/*     */ 
/* 297 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   LongRawAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, int paramInt3)
/*     */     throws SQLException
/*     */   {
/*  36 */     super(paramOracleStatement, 2147483647, false);
/*     */ 
/*  38 */     init(paramOracleStatement, 24, 24, paramShort, false);
/*     */ 
/*  40 */     this.columnPosition = paramInt1;
/*     */ 
/*  42 */     initForDataAccess(paramInt3, paramInt2, null);
/*     */   }
/*     */ 
/*     */   LongRawAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  50 */     super(paramOracleStatement, 2147483647, false);
/*     */ 
/*  52 */     init(paramOracleStatement, 24, 24, paramShort, false);
/*     */ 
/*  54 */     this.columnPosition = paramInt1;
/*     */ 
/*  56 */     initForDescribe(24, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort, null);
/*     */ 
/*  59 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  61 */     if ((i > 0) && ((paramInt2 == 0) || (i < paramInt2))) {
/*  62 */       paramInt2 = i;
/*     */     }
/*  64 */     initForDataAccess(0, paramInt2, null);
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  72 */     if (paramInt1 != 0) {
/*  73 */       this.externalType = paramInt1;
/*     */     }
/*  75 */     this.isStream = true;
/*  76 */     this.isColumnNumberAware = true;
/*     */ 
/*  78 */     this.byteLength = 0;
/*     */ 
/*  81 */     this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
/*     */   }
/*     */ 
/*     */   OracleInputStream initForNewRow()
/*     */     throws SQLException
/*     */   {
/*  96 */     this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
/*     */ 
/* 101 */     return this.stream;
/*     */   }
/*     */ 
/*     */   void updateColumnNumber(int paramInt)
/*     */   {
/* 110 */     paramInt++;
/*     */ 
/* 113 */     this.columnPosition = paramInt;
/*     */ 
/* 115 */     if (this.stream != null)
/* 116 */       this.stream.columnIndex = paramInt;
/*     */   }
/*     */ 
/*     */   byte[] getBytesInternal(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 128 */     if (isNull(paramInt)) return null;
/* 129 */     if (this.statement.isFetchStreams) return super.getBytesInternal(paramInt);
/* 130 */     if (this.stream == null) return null;
/* 131 */     if (!this.isStream) return super.getBytesInternal(paramInt);
/* 132 */     if (this.stream.closed) {
/* 133 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 134 */       ((SQLException)localObject).fillInStackTrace();
/* 135 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 138 */     Object localObject = new ByteArrayOutputStream(1024);
/* 139 */     byte[] arrayOfByte = new byte[1024];
/*     */     try
/*     */     {
/* 142 */       int i;
/* 142 */       while ((i = this.stream.read(arrayOfByte)) != -1) ((ByteArrayOutputStream)localObject).write(arrayOfByte, 0, i);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 146 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 147 */       localSQLException.fillInStackTrace();
/* 148 */       throw localSQLException;
/*     */     }
/*     */ 
/* 151 */     return ((ByteArrayOutputStream)localObject).toByteArray();
/*     */   }
/*     */ 
/*     */   protected InputStream convertBytesToStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 159 */     ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(getBytesInternal(paramInt1));
/*     */     try {
/* 161 */       InputStream localInputStream1 = this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, paramInt2);
/* 162 */       return localInputStream1;
/*     */     }
/*     */     finally {
/*     */       try {
/* 166 */         if (localByteArrayInputStream != null) localByteArrayInputStream.close();
/*     */       }
/*     */       catch (IOException localIOException2)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 184 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 185 */     if (isNull(paramInt)) return null;
/* 186 */     if (this.statement.isFetchStreams) return convertBytesToStream(paramInt, 2);
/* 187 */     if (this.stream.closed) {
/* 188 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 189 */       localSQLException.fillInStackTrace();
/* 190 */       throw localSQLException;
/*     */     }
/* 192 */     return localPhysicalConnection.conversion.ConvertStream(this.stream, 2);
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 208 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 209 */     if (isNull(paramInt)) return null;
/* 210 */     if (this.statement.isFetchStreams) return convertBytesToStream(paramInt, 3);
/* 211 */     if (this.stream.closed) {
/* 212 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 213 */       localSQLException.fillInStackTrace();
/* 214 */       throw localSQLException;
/*     */     }
/* 216 */     return localPhysicalConnection.conversion.ConvertStream(this.stream, 3);
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 232 */     if (isNull(paramInt)) return null;
/* 233 */     if (this.statement.isFetchStreams) {
/* 234 */       localObject1 = new ByteArrayInputStream(getBytesInternal(paramInt));
/*     */       try {
/* 236 */         PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 237 */         Reader localReader1 = this.statement.connection.conversion.ConvertCharacterStream((InputStream)localObject1, 8, this.formOfUse);
/* 238 */         return localReader1;
/*     */       }
/*     */       finally {
/*     */         try {
/* 242 */           if (localObject1 != null) ((InputStream)localObject1).close(); 
/*     */         }
/*     */         catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 247 */     if (this.stream.closed) {
/* 248 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 249 */       ((SQLException)localObject1).fillInStackTrace();
/* 250 */       throw ((Throwable)localObject1);
/*     */     }
/*     */ 
/* 253 */     Object localObject1 = this.statement.connection;
/* 254 */     return ((PhysicalConnection)localObject1).conversion.ConvertCharacterStream(this.stream, 8, this.formOfUse);
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 273 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 274 */     if (isNull(paramInt)) return null;
/* 275 */     if (this.statement.isFetchStreams) return convertBytesToStream(paramInt, 6);
/* 276 */     if (this.stream.closed) {
/* 277 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 278 */       localSQLException.fillInStackTrace();
/* 279 */       throw localSQLException;
/*     */     }
/* 281 */     return localPhysicalConnection.conversion.ConvertStream(this.stream, 6);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 290 */     return "LongRawAccessor@" + Integer.toHexString(hashCode()) + "{columnPosition = " + this.columnPosition + "}";
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.LongRawAccessor
 * JD-Core Version:    0.6.2
 */