/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class LongAccessor extends CharCommonAccessor
/*     */ {
/*     */   static final int MAXLENGTH = 2147483647;
/*     */   OracleInputStream stream;
/*  30 */   int columnPosition = 0;
/*     */ 
/* 327 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   LongAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, short paramShort, int paramInt3)
/*     */     throws SQLException
/*     */   {
/*  35 */     super(paramOracleStatement, (paramInt2 > 0) && (paramInt2 < 2147483647) ? paramInt2 : 2147483647, paramShort, false);
/*     */ 
/*  39 */     init(paramOracleStatement, 8, 8, paramShort, false);
/*     */ 
/*  41 */     this.columnPosition = paramInt1;
/*     */ 
/*  43 */     initForDataAccess(paramInt3, paramInt2, null);
/*     */   }
/*     */ 
/*     */   LongAccessor(OracleStatement paramOracleStatement, int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  51 */     super(paramOracleStatement, (paramInt2 > 0) && (paramInt2 < 2147483647) ? paramInt2 : 2147483647, paramShort, false);
/*     */ 
/*  55 */     init(paramOracleStatement, 8, 8, paramShort, false);
/*     */ 
/*  57 */     this.columnPosition = paramInt1;
/*     */ 
/*  59 */     initForDescribe(8, paramInt2, paramBoolean, paramInt3, paramInt4, paramInt5, paramInt6, paramInt7, paramShort, null);
/*     */ 
/*  62 */     int i = paramOracleStatement.maxFieldSize;
/*     */ 
/*  64 */     if ((i > 0) && ((paramInt2 == 0) || (i < paramInt2))) {
/*  65 */       paramInt2 = i;
/*     */     }
/*  67 */     initForDataAccess(0, paramInt2, null);
/*     */   }
/*     */ 
/*     */   void initForDataAccess(int paramInt1, int paramInt2, String paramString)
/*     */     throws SQLException
/*     */   {
/*  75 */     if (paramInt1 != 0) {
/*  76 */       this.externalType = paramInt1;
/*     */     }
/*  78 */     this.isStream = true;
/*  79 */     this.isColumnNumberAware = true;
/*     */ 
/*  82 */     this.charLength = 0;
/*     */ 
/*  85 */     this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
/*     */   }
/*     */ 
/*     */   OracleInputStream initForNewRow()
/*     */     throws SQLException
/*     */   {
/*  95 */     this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
/*     */ 
/*  98 */     return this.stream;
/*     */   }
/*     */ 
/*     */   void updateColumnNumber(int paramInt)
/*     */   {
/* 107 */     paramInt++;
/*     */ 
/* 110 */     this.columnPosition = paramInt;
/*     */ 
/* 112 */     if (this.stream != null)
/* 113 */       this.stream.columnIndex = paramInt;
/*     */   }
/*     */ 
/*     */   byte[] getBytesInternal(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 125 */     if (this.statement.isFetchStreams) return super.getBytesInternal(paramInt);
/* 126 */     if (isNull(paramInt)) return null;
/* 127 */     if (this.stream == null) return null;
/* 128 */     if (!this.isStream) return super.getBytesInternal(paramInt);
/* 129 */     if (this.stream.closed) {
/* 130 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 131 */       ((SQLException)localObject).fillInStackTrace();
/* 132 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 135 */     Object localObject = new ByteArrayOutputStream(1024);
/* 136 */     byte[] arrayOfByte = this.statement.connection.getByteBuffer(32768);
/*     */     try
/*     */     {
/* 139 */       int i;
/* 139 */       while ((i = this.stream.read(arrayOfByte, 0, 32768)) != -1) ((ByteArrayOutputStream)localObject).write(arrayOfByte, 0, i);
/* 140 */       this.statement.connection.cacheBuffer(arrayOfByte);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 144 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 145 */       localSQLException.fillInStackTrace();
/* 146 */       throw localSQLException;
/*     */     }
/*     */ 
/* 149 */     return ((ByteArrayOutputStream)localObject).toByteArray();
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 165 */     String str = null;
/* 166 */     byte[] arrayOfByte = getBytes(paramInt);
/* 167 */     if (arrayOfByte != null) {
/* 168 */       int i = (this.statement.maxFieldSize > 0) && (this.statement.maxFieldSize < this.representationMaxLength) ? this.statement.maxFieldSize : this.representationMaxLength;
/*     */ 
/* 170 */       int j = Math.min(arrayOfByte.length, i);
/*     */ 
/* 174 */       assert (j > 0) : ("len: " + j);
/*     */ 
/* 176 */       if (this.formOfUse == 2)
/* 177 */         str = this.statement.connection.conversion.NCharBytesToString(arrayOfByte, j);
/*     */       else
/* 179 */         str = this.statement.connection.conversion.CharBytesToString(arrayOfByte, j);
/*     */     }
/* 181 */     return str;
/*     */   }
/*     */ 
/*     */   protected InputStream convertBytesToStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 188 */     ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(getBytesInternal(paramInt1));
/*     */     try {
/* 190 */       InputStream localInputStream1 = this.statement.connection.conversion.ConvertStream(localByteArrayInputStream, paramInt2);
/* 191 */       return localInputStream1;
/*     */     }
/*     */     finally {
/*     */       try {
/* 195 */         if (localByteArrayInputStream != null) localByteArrayInputStream.close();
/*     */       }
/*     */       catch (IOException localIOException2)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 213 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 214 */     if (isNull(paramInt)) return null;
/* 215 */     if (this.statement.isFetchStreams) return convertBytesToStream(paramInt, 0);
/* 216 */     if (this.stream.closed) {
/* 217 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 218 */       localSQLException.fillInStackTrace();
/* 219 */       throw localSQLException;
/*     */     }
/* 221 */     return localPhysicalConnection.conversion.ConvertStream(this.stream, 0);
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 237 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 238 */     if (isNull(paramInt)) return null;
/* 239 */     if (this.statement.isFetchStreams) return convertBytesToStream(paramInt, 1);
/* 240 */     if (this.stream.closed) {
/* 241 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 242 */       localSQLException.fillInStackTrace();
/* 243 */       throw localSQLException;
/*     */     }
/* 245 */     return localPhysicalConnection.conversion.ConvertStream(this.stream, 1);
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 261 */     if (isNull(paramInt)) return null;
/* 262 */     if (this.statement.isFetchStreams) {
/* 263 */       localObject1 = new ByteArrayInputStream(getBytesInternal(paramInt));
/*     */       try {
/* 265 */         PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 266 */         Reader localReader1 = this.statement.connection.conversion.ConvertCharacterStream((InputStream)localObject1, 9, this.formOfUse);
/* 267 */         return localReader1;
/*     */       }
/*     */       finally {
/*     */         try {
/* 271 */           if (localObject1 != null) ((InputStream)localObject1).close(); 
/*     */         }
/*     */         catch (IOException localIOException2) {  }
/*     */ 
/*     */       }
/*     */     }
/* 276 */     if (this.stream.closed) {
/* 277 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 278 */       ((SQLException)localObject1).fillInStackTrace();
/* 279 */       throw ((Throwable)localObject1);
/*     */     }
/*     */ 
/* 282 */     Object localObject1 = this.statement.connection;
/* 283 */     return ((PhysicalConnection)localObject1).conversion.ConvertCharacterStream(this.stream, 9, this.formOfUse);
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 302 */     PhysicalConnection localPhysicalConnection = this.statement.connection;
/* 303 */     if (isNull(paramInt)) return null;
/* 304 */     if (this.statement.isFetchStreams) return convertBytesToStream(paramInt, 6);
/* 305 */     if (this.stream.closed) {
/* 306 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 27);
/* 307 */       localSQLException.fillInStackTrace();
/* 308 */       throw localSQLException;
/*     */     }
/* 310 */     return localPhysicalConnection.conversion.ConvertStream(this.stream, 6);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 319 */     return "LongAccessor@" + Integer.toHexString(hashCode()) + "{columnPosition = " + this.columnPosition + "}";
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.LongAccessor
 * JD-Core Version:    0.6.2
 */