/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.net.SocketException;
/*      */ import java.security.NoSuchAlgorithmException;
/*      */ import java.security.spec.InvalidKeySpecException;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.util.EnumSet;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.concurrent.Executor;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import oracle.jdbc.LogicalTransactionIdEventListener;
/*      */ import oracle.jdbc.aq.AQMessageProperties;
/*      */ import oracle.jdbc.internal.JMSDequeueOptions;
/*      */ import oracle.jdbc.internal.JMSEnqueueOptions;
/*      */ import oracle.jdbc.internal.JMSMessage;
/*      */ import oracle.jdbc.internal.JMSNotificationRegistration;
/*      */ import oracle.jdbc.internal.JMSNotificationRegistration.Directive;
/*      */ import oracle.jdbc.internal.KeywordValueLong;
/*      */ import oracle.jdbc.internal.OracleConnection.BufferCacheStatistics;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleConnection.EndReplayCallback;
/*      */ import oracle.jdbc.internal.OracleConnection.InstanceProperty;
/*      */ import oracle.jdbc.internal.OracleConnection.ReplayOperation;
/*      */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*      */ import oracle.jdbc.internal.OracleConnection.XSOperationCode;
/*      */ import oracle.jdbc.internal.OracleConnection.XSSessionModeFlag;
/*      */ import oracle.jdbc.internal.OracleConnection.XSSessionOperationCode;
/*      */ import oracle.jdbc.internal.OracleConnection.XSSessionSetOperationCode;
/*      */ import oracle.jdbc.internal.OracleStatement;
/*      */ import oracle.jdbc.internal.PDBChangeEventListener;
/*      */ import oracle.jdbc.internal.ReplayContext;
/*      */ import oracle.jdbc.internal.XSEventListener;
/*      */ import oracle.jdbc.internal.XSKeyval;
/*      */ import oracle.jdbc.internal.XSNamespace;
/*      */ import oracle.jdbc.internal.XSPrincipal;
/*      */ import oracle.jdbc.internal.XSSecureId;
/*      */ import oracle.jdbc.internal.XSSessionParameters;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.jdbc.oracore.OracleTypeCLOB;
/*      */ import oracle.jdbc.pool.OracleConnectionCacheCallback;
/*      */ import oracle.jdbc.pool.OraclePooledConnection;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.ArrayDescriptor;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.BfileDBAccess;
/*      */ import oracle.sql.BlobDBAccess;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.ClobDBAccess;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.StructDescriptor;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ import oracle.sql.TIMEZONETAB;
/*      */ 
/*      */ class LogicalConnection extends OracleConnection
/*      */ {
/*   81 */   static final ClosedConnection closedConnection = new ClosedConnection();
/*      */   PhysicalConnection internalConnection;
/*      */   OraclePooledConnection pooledConnection;
/*      */   boolean closed;
/*   91 */   OracleCloseCallback closeCallback = null;
/*   92 */   Object privateData = null;
/*      */ 
/*   95 */   long startTime = 0L;
/*      */ 
/*   99 */   OracleConnectionCacheCallback connectionCacheCallback = null;
/*  100 */   Object connectionCacheCallbackUserObj = null;
/*  101 */   int callbackFlag = 0;
/*  102 */   int releasePriority = 0;
/*      */ 
/*  105 */   int heartbeatCount = 0;
/*  106 */   int heartbeatLastCount = 0;
/*  107 */   int heartbeatNoChangeCount = 0;
/*  108 */   boolean isAbandonedTimeoutEnabled = false;
/*      */ 
/* 1981 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   LogicalConnection(OraclePooledConnection paramOraclePooledConnection, PhysicalConnection paramPhysicalConnection, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  116 */     this.internalConnection = paramPhysicalConnection;
/*  117 */     this.pooledConnection = paramOraclePooledConnection;
/*  118 */     this.connection = this.internalConnection;
/*      */ 
/*  120 */     this.connection.setWrapper(this);
/*      */ 
/*  122 */     this.closed = false;
/*      */ 
/*  124 */     this.internalConnection.setAutoCommit(paramBoolean);
/*      */ 
/*  126 */     this.internalConnection.attachServerConnection();
/*      */   }
/*      */ 
/*      */   void registerHeartbeat()
/*      */     throws SQLException
/*      */   {
/*  142 */     if (this.isAbandonedTimeoutEnabled)
/*      */     {
/*      */       try
/*      */       {
/*  146 */         this.heartbeatCount += 1;
/*      */       }
/*      */       catch (ArithmeticException localArithmeticException)
/*      */       {
/*  150 */         this.heartbeatCount = 0;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getHeartbeatNoChangeCount()
/*      */     throws SQLException
/*      */   {
/*  163 */     if (this.heartbeatCount == this.heartbeatLastCount)
/*      */     {
/*  165 */       this.heartbeatNoChangeCount += 1;
/*      */     }
/*      */     else
/*      */     {
/*  169 */       this.heartbeatLastCount = this.heartbeatCount;
/*  170 */       this.heartbeatNoChangeCount = 0;
/*      */     }
/*      */ 
/*  173 */     return this.heartbeatNoChangeCount;
/*      */   }
/*      */ 
/*      */   public oracle.jdbc.internal.OracleConnection physicalConnectionWithin()
/*      */   {
/*  180 */     return this.internalConnection;
/*      */   }
/*      */ 
/*      */   public synchronized void registerCloseCallback(OracleCloseCallback paramOracleCloseCallback, Object paramObject)
/*      */   {
/*  193 */     this.closeCallback = paramOracleCloseCallback;
/*  194 */     this.privateData = paramObject;
/*      */   }
/*      */ 
/*      */   public Connection _getPC()
/*      */   {
/*  201 */     return this.internalConnection;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isLogicalConnection()
/*      */   {
/*  219 */     return true;
/*      */   }
/*      */ 
/*      */   public oracle.jdbc.internal.OracleConnection getPhysicalConnection()
/*      */   {
/*  226 */     return this.internalConnection;
/*      */   }
/*      */ 
/*      */   public Connection getLogicalConnection(OraclePooledConnection paramOraclePooledConnection, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  239 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 153);
/*  240 */     localSQLException.fillInStackTrace();
/*  241 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void getPropertyForPooledConnection(OraclePooledConnection paramOraclePooledConnection)
/*      */     throws SQLException
/*      */   {
/*  254 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 153);
/*  255 */     localSQLException.fillInStackTrace();
/*  256 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public synchronized void close()
/*      */     throws SQLException
/*      */   {
/*  270 */     closeInternal(this.internalConnection.isUsable);
/*      */   }
/*      */ 
/*      */   public void closeInternal(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  284 */     if (this.closed) {
/*  285 */       return;
/*      */     }
/*  287 */     if (this.closeCallback != null) {
/*  288 */       this.closeCallback.beforeClose(this, this.privateData);
/*      */     }
/*      */ 
/*  291 */     if (this.internalConnection.lifecycle == 1) {
/*  292 */       this.internalConnection.detachServerConnection((String)null);
/*      */     }
/*      */ 
/*  296 */     this.internalConnection.closeLogicalConnection();
/*      */ 
/*  299 */     this.startTime = 0L;
/*      */ 
/*  301 */     this.closed = true;
/*      */ 
/*  304 */     if ((this.pooledConnection != null) && (paramBoolean)) {
/*  305 */       this.pooledConnection.logicalClose();
/*      */     }
/*      */ 
/*  309 */     this.internalConnection = closedConnection;
/*  310 */     this.connection = closedConnection;
/*      */ 
/*  312 */     if (this.closeCallback != null)
/*  313 */       this.closeCallback.afterClose(this.privateData);
/*      */   }
/*      */ 
/*      */   public void cleanupAndClose(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  324 */     if (this.closed) {
/*  325 */       return;
/*      */     }
/*      */ 
/*  328 */     this.closed = true;
/*      */ 
/*  331 */     PhysicalConnection localPhysicalConnection = this.internalConnection;
/*  332 */     OraclePooledConnection localOraclePooledConnection = this.pooledConnection;
/*  333 */     this.internalConnection = closedConnection;
/*  334 */     this.connection = closedConnection;
/*  335 */     this.startTime = 0L;
/*      */ 
/*  337 */     if (this.closeCallback != null) {
/*  338 */       this.closeCallback.beforeClose(this, this.privateData);
/*      */     }
/*      */ 
/*  341 */     localPhysicalConnection.cleanupAndClose();
/*  342 */     localPhysicalConnection.closeLogicalConnection();
/*      */ 
/*  345 */     if ((localOraclePooledConnection != null) && (paramBoolean)) {
/*  346 */       localOraclePooledConnection.logicalClose();
/*      */     }
/*  348 */     if (this.closeCallback != null)
/*  349 */       this.closeCallback.afterClose(this.privateData);
/*      */   }
/*      */ 
/*      */   public void abort()
/*      */     throws SQLException
/*      */   {
/*  356 */     if (this.closed)
/*  357 */       return;
/*  358 */     this.internalConnection.abort();
/*  359 */     this.closed = true;
/*      */ 
/*  361 */     this.internalConnection = closedConnection;
/*  362 */     this.connection = closedConnection;
/*      */   }
/*      */ 
/*      */   public synchronized void close(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  381 */     if (this.pooledConnection != null)
/*      */     {
/*  383 */       if (this.pooledConnection.cachedConnectionAttributes != null)
/*      */       {
/*  385 */         if (paramProperties != null)
/*      */         {
/*  387 */           this.pooledConnection.cachedConnectionAttributes.clear();
/*  388 */           this.pooledConnection.cachedConnectionAttributes.putAll(paramProperties);
/*      */ 
/*  391 */           this.internalConnection.detachServerConnection((String)null);
/*      */         }
/*      */         else
/*      */         {
/*  395 */           this.internalConnection.drcpTagName = null;
/*      */         }
/*  397 */       } else if (paramProperties != null)
/*      */       {
/*  399 */         this.internalConnection.detachServerConnection((String)null);
/*  400 */         this.pooledConnection.cachedConnectionAttributes = paramProperties;
/*      */       }
/*      */     }
/*      */ 
/*  404 */     close();
/*      */   }
/*      */ 
/*      */   public synchronized void close(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  417 */     if ((paramInt & 0x1000) != 0)
/*      */     {
/*  421 */       if (this.pooledConnection != null) {
/*  422 */         this.pooledConnection.closeOption = paramInt;
/*      */       }
/*  424 */       close();
/*      */ 
/*  426 */       return;
/*      */     }
/*      */ 
/*  429 */     if ((paramInt & 0x1) != 0)
/*      */     {
/*  433 */       this.internalConnection.close(1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void applyConnectionAttributes(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  453 */     if (this.pooledConnection != null)
/*  454 */       this.pooledConnection.cachedConnectionAttributes.putAll(paramProperties);
/*      */   }
/*      */ 
/*      */   public synchronized Properties getConnectionAttributes()
/*      */     throws SQLException
/*      */   {
/*  474 */     if (this.pooledConnection != null) {
/*  475 */       return this.pooledConnection.cachedConnectionAttributes;
/*      */     }
/*  477 */     return null;
/*      */   }
/*      */ 
/*      */   public synchronized Properties getUnMatchedConnectionAttributes()
/*      */     throws SQLException
/*      */   {
/*  495 */     if (this.pooledConnection != null) {
/*  496 */       return this.pooledConnection.unMatchedCachedConnAttr;
/*      */     }
/*  498 */     return null;
/*      */   }
/*      */ 
/*      */   public synchronized void setAbandonedTimeoutEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  515 */     this.isAbandonedTimeoutEnabled = true;
/*      */   }
/*      */ 
/*      */   public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback paramOracleConnectionCacheCallback, Object paramObject, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  532 */     this.connectionCacheCallback = paramOracleConnectionCacheCallback;
/*  533 */     this.connectionCacheCallbackUserObj = paramObject;
/*  534 */     this.callbackFlag = paramInt;
/*      */   }
/*      */ 
/*      */   public OracleConnectionCacheCallback getConnectionCacheCallbackObj()
/*      */     throws SQLException
/*      */   {
/*  550 */     return this.connectionCacheCallback;
/*      */   }
/*      */ 
/*      */   public Object getConnectionCacheCallbackPrivObj()
/*      */     throws SQLException
/*      */   {
/*  565 */     return this.connectionCacheCallbackUserObj;
/*      */   }
/*      */ 
/*      */   public int getConnectionCacheCallbackFlag()
/*      */     throws SQLException
/*      */   {
/*  580 */     return this.callbackFlag;
/*      */   }
/*      */ 
/*      */   public synchronized void setConnectionReleasePriority(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  596 */     this.releasePriority = paramInt;
/*      */   }
/*      */ 
/*      */   public int getConnectionReleasePriority()
/*      */     throws SQLException
/*      */   {
/*  612 */     return this.releasePriority;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isClosed()
/*      */     throws SQLException
/*      */   {
/*  630 */     return this.closed;
/*      */   }
/*      */ 
/*      */   public void setStartTime(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  649 */     if (paramLong <= 0L)
/*      */     {
/*  652 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  653 */       localSQLException.fillInStackTrace();
/*  654 */       throw localSQLException;
/*      */     }
/*      */ 
/*  659 */     this.startTime = paramLong;
/*      */   }
/*      */ 
/*      */   public long getStartTime()
/*      */     throws SQLException
/*      */   {
/*  675 */     return this.startTime;
/*      */   }
/*      */ 
/*      */   public String getDatabaseTimeZone()
/*      */     throws SQLException
/*      */   {
/*  685 */     return this.internalConnection.getDatabaseTimeZone();
/*      */   }
/*      */ 
/*      */   public Properties getServerSessionInfo()
/*      */     throws SQLException
/*      */   {
/*  691 */     return this.internalConnection.getServerSessionInfo();
/*      */   }
/*      */ 
/*      */   public Object getClientData(Object paramObject)
/*      */   {
/*  698 */     return this.internalConnection.getClientData(paramObject);
/*      */   }
/*      */ 
/*      */   public Object setClientData(Object paramObject1, Object paramObject2)
/*      */   {
/*  705 */     return this.internalConnection.setClientData(paramObject1, paramObject2);
/*      */   }
/*      */ 
/*      */   public Object removeClientData(Object paramObject)
/*      */   {
/*  712 */     return this.internalConnection.removeClientData(paramObject);
/*      */   }
/*      */ 
/*      */   public void setClientIdentifier(String paramString)
/*      */     throws SQLException
/*      */   {
/*  719 */     this.internalConnection.setClientIdentifier(paramString);
/*      */   }
/*      */ 
/*      */   public void clearClientIdentifier(String paramString)
/*      */     throws SQLException
/*      */   {
/*  726 */     this.internalConnection.clearClientIdentifier(paramString);
/*      */   }
/*      */ 
/*      */   public short getStructAttrNCsId()
/*      */     throws SQLException
/*      */   {
/*  733 */     return this.internalConnection.getStructAttrNCsId();
/*      */   }
/*      */ 
/*      */   public Map getTypeMap()
/*      */     throws SQLException
/*      */   {
/*  740 */     return this.internalConnection.getTypeMap();
/*      */   }
/*      */ 
/*      */   public Properties getDBAccessProperties()
/*      */     throws SQLException
/*      */   {
/*  747 */     return this.internalConnection.getDBAccessProperties();
/*      */   }
/*      */ 
/*      */   public Properties getOCIHandles()
/*      */     throws SQLException
/*      */   {
/*  754 */     return this.internalConnection.getOCIHandles();
/*      */   }
/*      */ 
/*      */   public String getDatabaseProductVersion()
/*      */     throws SQLException
/*      */   {
/*  761 */     return this.internalConnection.getDatabaseProductVersion();
/*      */   }
/*      */ 
/*      */   public void cancel()
/*      */     throws SQLException
/*      */   {
/*  772 */     registerHeartbeat();
/*  773 */     this.internalConnection.cancel();
/*      */   }
/*      */ 
/*      */   public String getURL()
/*      */     throws SQLException
/*      */   {
/*  780 */     return this.internalConnection.getURL();
/*      */   }
/*      */ 
/*      */   public boolean getIncludeSynonyms()
/*      */   {
/*  787 */     return this.internalConnection.getIncludeSynonyms();
/*      */   }
/*      */ 
/*      */   public boolean getRemarksReporting()
/*      */   {
/*  794 */     return this.internalConnection.getRemarksReporting();
/*      */   }
/*      */ 
/*      */   public boolean getRestrictGetTables()
/*      */   {
/*  801 */     return this.internalConnection.getRestrictGetTables();
/*      */   }
/*      */ 
/*      */   public short getVersionNumber()
/*      */     throws SQLException
/*      */   {
/*  808 */     return this.internalConnection.getVersionNumber();
/*      */   }
/*      */ 
/*      */   public Map getJavaObjectTypeMap()
/*      */   {
/*  815 */     return this.internalConnection.getJavaObjectTypeMap();
/*      */   }
/*      */ 
/*      */   public void setJavaObjectTypeMap(Map paramMap)
/*      */   {
/*  822 */     this.internalConnection.setJavaObjectTypeMap(paramMap);
/*      */   }
/*      */ 
/*      */   public BfileDBAccess createBfileDBAccess()
/*      */     throws SQLException
/*      */   {
/*  829 */     return this.internalConnection.createBfileDBAccess();
/*      */   }
/*      */ 
/*      */   public BlobDBAccess createBlobDBAccess()
/*      */     throws SQLException
/*      */   {
/*  836 */     return this.internalConnection.createBlobDBAccess();
/*      */   }
/*      */ 
/*      */   public ClobDBAccess createClobDBAccess()
/*      */     throws SQLException
/*      */   {
/*  843 */     return this.internalConnection.createClobDBAccess();
/*      */   }
/*      */ 
/*      */   public void setDefaultFixedString(boolean paramBoolean)
/*      */   {
/*  850 */     this.internalConnection.setDefaultFixedString(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean getTimestamptzInGmt()
/*      */   {
/*  857 */     return this.internalConnection.getTimestamptzInGmt();
/*      */   }
/*      */ 
/*      */   public boolean getUse1900AsYearForTime()
/*      */   {
/*  864 */     return this.internalConnection.getUse1900AsYearForTime();
/*      */   }
/*      */ 
/*      */   public boolean getDefaultFixedString()
/*      */   {
/*  871 */     return this.internalConnection.getDefaultFixedString();
/*      */   }
/*      */ 
/*      */   public oracle.jdbc.OracleConnection getWrapper()
/*      */   {
/*  878 */     return this;
/*      */   }
/*      */ 
/*      */   public Class classForNameAndSchema(String paramString1, String paramString2)
/*      */     throws ClassNotFoundException
/*      */   {
/*  886 */     return this.internalConnection.classForNameAndSchema(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public void setFDO(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  893 */     this.internalConnection.setFDO(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public byte[] getFDO(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  900 */     return this.internalConnection.getFDO(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean getBigEndian()
/*      */     throws SQLException
/*      */   {
/*  907 */     return this.internalConnection.getBigEndian();
/*      */   }
/*      */ 
/*      */   public Object getDescriptor(byte[] paramArrayOfByte)
/*      */   {
/*  914 */     return this.internalConnection.getDescriptor(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void putDescriptor(byte[] paramArrayOfByte, Object paramObject)
/*      */     throws SQLException
/*      */   {
/*  921 */     this.internalConnection.putDescriptor(paramArrayOfByte, paramObject);
/*      */   }
/*      */ 
/*      */   public void removeDescriptor(String paramString)
/*      */   {
/*  928 */     this.internalConnection.removeDescriptor(paramString);
/*      */   }
/*      */ 
/*      */   public void removeAllDescriptor()
/*      */   {
/*  935 */     this.internalConnection.removeAllDescriptor();
/*      */   }
/*      */ 
/*      */   public int numberOfDescriptorCacheEntries()
/*      */   {
/*  942 */     return this.internalConnection.numberOfDescriptorCacheEntries();
/*      */   }
/*      */ 
/*      */   public Enumeration descriptorCacheKeys()
/*      */   {
/*  949 */     return this.internalConnection.descriptorCacheKeys();
/*      */   }
/*      */ 
/*      */   public void getOracleTypeADT(OracleTypeADT paramOracleTypeADT)
/*      */     throws SQLException
/*      */   {
/*  957 */     this.internalConnection.getOracleTypeADT(paramOracleTypeADT);
/*      */   }
/*      */ 
/*      */   public short getDbCsId()
/*      */     throws SQLException
/*      */   {
/*  964 */     return this.internalConnection.getDbCsId();
/*      */   }
/*      */ 
/*      */   public short getJdbcCsId()
/*      */     throws SQLException
/*      */   {
/*  971 */     return this.internalConnection.getJdbcCsId();
/*      */   }
/*      */ 
/*      */   public short getNCharSet()
/*      */   {
/*  978 */     return this.internalConnection.getNCharSet();
/*      */   }
/*      */ 
/*      */   public ResultSet newArrayDataResultSet(Datum[] paramArrayOfDatum, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  986 */     return this.internalConnection.newArrayDataResultSet(paramArrayOfDatum, paramLong, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   public ResultSet newArrayDataResultSet(ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  994 */     return this.internalConnection.newArrayDataResultSet(paramARRAY, paramLong, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   public ResultSet newArrayLocatorResultSet(ArrayDescriptor paramArrayDescriptor, byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1004 */     return this.internalConnection.newArrayLocatorResultSet(paramArrayDescriptor, paramArrayOfByte, paramLong, paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData newStructMetaData(StructDescriptor paramStructDescriptor)
/*      */     throws SQLException
/*      */   {
/* 1013 */     return this.internalConnection.newStructMetaData(paramStructDescriptor);
/*      */   }
/*      */ 
/*      */   public void getForm(OracleTypeADT paramOracleTypeADT, OracleTypeCLOB paramOracleTypeCLOB, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1022 */     this.internalConnection.getForm(paramOracleTypeADT, paramOracleTypeCLOB, paramInt);
/*      */   }
/*      */ 
/*      */   public int CHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/* 1030 */     return this.internalConnection.CHARBytesToJavaChars(paramArrayOfByte, paramInt, paramArrayOfChar);
/*      */   }
/*      */ 
/*      */   public int NCHARBytesToJavaChars(byte[] paramArrayOfByte, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/* 1038 */     return this.internalConnection.NCHARBytesToJavaChars(paramArrayOfByte, paramInt, paramArrayOfChar);
/*      */   }
/*      */ 
/*      */   public boolean IsNCharFixedWith()
/*      */   {
/* 1045 */     return this.internalConnection.IsNCharFixedWith();
/*      */   }
/*      */ 
/*      */   public short getDriverCharSet()
/*      */   {
/* 1052 */     return this.internalConnection.getDriverCharSet();
/*      */   }
/*      */ 
/*      */   public int getC2SNlsRatio()
/*      */   {
/* 1059 */     return this.internalConnection.getC2SNlsRatio();
/*      */   }
/*      */ 
/*      */   public int getMaxCharSize()
/*      */     throws SQLException
/*      */   {
/* 1066 */     return this.internalConnection.getMaxCharSize();
/*      */   }
/*      */ 
/*      */   public int getMaxCharbyteSize()
/*      */   {
/* 1073 */     return this.internalConnection.getMaxCharbyteSize();
/*      */   }
/*      */ 
/*      */   public int getMaxNCharbyteSize()
/*      */   {
/* 1080 */     return this.internalConnection.getMaxNCharbyteSize();
/*      */   }
/*      */ 
/*      */   public boolean isCharSetMultibyte(short paramShort)
/*      */   {
/* 1087 */     return this.internalConnection.isCharSetMultibyte(paramShort);
/*      */   }
/*      */ 
/*      */   public int javaCharsToCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1095 */     return this.internalConnection.javaCharsToCHARBytes(paramArrayOfChar, paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public int javaCharsToNCHARBytes(char[] paramArrayOfChar, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1103 */     return this.internalConnection.javaCharsToNCHARBytes(paramArrayOfChar, paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public int getStmtCacheSize()
/*      */   {
/* 1110 */     return this.internalConnection.getStmtCacheSize();
/*      */   }
/*      */ 
/*      */   public int getStatementCacheSize()
/*      */     throws SQLException
/*      */   {
/* 1117 */     return this.internalConnection.getStatementCacheSize();
/*      */   }
/*      */ 
/*      */   public boolean getImplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/* 1124 */     return this.internalConnection.getImplicitCachingEnabled();
/*      */   }
/*      */ 
/*      */   public boolean getExplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/* 1131 */     return this.internalConnection.getExplicitCachingEnabled();
/*      */   }
/*      */ 
/*      */   public void purgeImplicitCache()
/*      */     throws SQLException
/*      */   {
/* 1138 */     this.internalConnection.purgeImplicitCache();
/*      */   }
/*      */ 
/*      */   public void purgeExplicitCache()
/*      */     throws SQLException
/*      */   {
/* 1145 */     this.internalConnection.purgeExplicitCache();
/*      */   }
/*      */ 
/*      */   public PreparedStatement getStatementWithKey(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1153 */     return this.internalConnection.getStatementWithKey(paramString);
/*      */   }
/*      */ 
/*      */   public CallableStatement getCallWithKey(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1161 */     return this.internalConnection.getCallWithKey(paramString);
/*      */   }
/*      */ 
/*      */   public boolean isStatementCacheInitialized()
/*      */   {
/* 1168 */     return this.internalConnection.isStatementCacheInitialized();
/*      */   }
/*      */ 
/*      */   public void setTypeMap(Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1175 */     this.internalConnection.setTypeMap(paramMap);
/*      */   }
/*      */ 
/*      */   public String getProtocolType()
/*      */   {
/* 1182 */     return this.internalConnection.getProtocolType();
/*      */   }
/*      */ 
/*      */   public void setTxnMode(int paramInt)
/*      */   {
/* 1191 */     this.internalConnection.setTxnMode(paramInt);
/*      */   }
/*      */ 
/*      */   public int getTxnMode()
/*      */   {
/* 1198 */     return this.internalConnection.getTxnMode();
/*      */   }
/*      */ 
/*      */   public int getHeapAllocSize()
/*      */     throws SQLException
/*      */   {
/* 1206 */     return this.internalConnection.getHeapAllocSize();
/*      */   }
/*      */ 
/*      */   public int getOCIEnvHeapAllocSize()
/*      */     throws SQLException
/*      */   {
/* 1213 */     return this.internalConnection.getOCIEnvHeapAllocSize();
/*      */   }
/*      */ 
/*      */   public CLOB createClob(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1224 */     registerHeartbeat();
/* 1225 */     return this.internalConnection.createClob(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public CLOB createClobWithUnpickledBytes(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1237 */     registerHeartbeat();
/* 1238 */     return this.internalConnection.createClobWithUnpickledBytes(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public CLOB createClob(byte[] paramArrayOfByte, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 1250 */     registerHeartbeat();
/* 1251 */     return this.internalConnection.createClob(paramArrayOfByte, paramShort);
/*      */   }
/*      */ 
/*      */   public BLOB createBlob(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1262 */     registerHeartbeat();
/* 1263 */     return this.internalConnection.createBlob(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public BLOB createBlobWithUnpickledBytes(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1274 */     registerHeartbeat();
/* 1275 */     return this.internalConnection.createBlobWithUnpickledBytes(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public BFILE createBfile(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1286 */     registerHeartbeat();
/* 1287 */     return this.internalConnection.createBfile(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 1295 */     return this.internalConnection.isDescriptorSharable(paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public OracleStatement refCursorCursorToStatement(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1303 */     return this.internalConnection.refCursorCursorToStatement(paramInt);
/*      */   }
/*      */ 
/*      */   public long getTdoCState(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1310 */     return this.internalConnection.getTdoCState(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public long getTdoCState(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1317 */     return this.internalConnection.getTdoCState(paramString);
/*      */   }
/*      */ 
/*      */   public Datum toDatum(CustomDatum paramCustomDatum)
/*      */     throws SQLException
/*      */   {
/* 1323 */     return this.internalConnection.toDatum(paramCustomDatum);
/*      */   }
/*      */ 
/*      */   public XAResource getXAResource()
/*      */     throws SQLException
/*      */   {
/* 1340 */     return this.pooledConnection.getXAResource();
/*      */   }
/*      */ 
/*      */   public void setApplicationContext(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 1351 */     this.internalConnection.setApplicationContext(paramString1, paramString2, paramString3);
/*      */   }
/*      */ 
/*      */   public void clearAllApplicationContext(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1360 */     this.internalConnection.clearAllApplicationContext(paramString);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public boolean isV8Compatible()
/*      */     throws SQLException
/*      */   {
/* 1377 */     return getMapDateToTimestamp();
/*      */   }
/*      */ 
/*      */   public boolean getMapDateToTimestamp()
/*      */   {
/* 1390 */     return this.internalConnection.getMapDateToTimestamp();
/*      */   }
/*      */ 
/*      */   public byte[] createLightweightSession(String paramString, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt, KeywordValueLong[][] paramArrayOfKeywordValueLong1, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 1406 */     return this.internalConnection.createLightweightSession(paramString, paramArrayOfKeywordValueLong, paramInt, paramArrayOfKeywordValueLong1, paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public void executeLightweightSessionRoundtrip(int paramInt1, byte[] paramArrayOfByte, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt2, KeywordValueLong[][] paramArrayOfKeywordValueLong1, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 1419 */     this.internalConnection.executeLightweightSessionRoundtrip(paramInt1, paramArrayOfByte, paramArrayOfKeywordValueLong, paramInt2, paramArrayOfKeywordValueLong1, paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public void executeLightweightSessionPiggyback(int paramInt1, byte[] paramArrayOfByte, KeywordValueLong[] paramArrayOfKeywordValueLong, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1431 */     this.internalConnection.executeLightweightSessionPiggyback(paramInt1, paramArrayOfByte, paramArrayOfKeywordValueLong, paramInt2);
/*      */   }
/*      */ 
/*      */   public void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSNamespace[][] paramArrayOfXSNamespace1, XSSecureId paramXSSecureId)
/*      */     throws SQLException
/*      */   {
/* 1443 */     this.internalConnection.doXSNamespaceOp(paramXSOperationCode, paramArrayOfByte, paramArrayOfXSNamespace, paramArrayOfXSNamespace1, paramXSSecureId);
/*      */   }
/*      */ 
/*      */   public void doXSNamespaceOp(OracleConnection.XSOperationCode paramXSOperationCode, byte[] paramArrayOfByte, XSNamespace[] paramArrayOfXSNamespace, XSSecureId paramXSSecureId)
/*      */     throws SQLException
/*      */   {
/* 1452 */     this.internalConnection.doXSNamespaceOp(paramXSOperationCode, paramArrayOfByte, paramArrayOfXSNamespace, paramXSSecureId);
/*      */   }
/*      */ 
/*      */   public void doXSSessionAttachOp(int paramInt1, byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2, XSPrincipal paramXSPrincipal, String[] paramArrayOfString1, String[] paramArrayOfString2, String[] paramArrayOfString3, XSNamespace[] paramArrayOfXSNamespace1, XSNamespace[] paramArrayOfXSNamespace2, XSNamespace[] paramArrayOfXSNamespace3, TIMESTAMPTZ paramTIMESTAMPTZ1, TIMESTAMPTZ paramTIMESTAMPTZ2, int paramInt2, long paramLong, XSKeyval paramXSKeyval, int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 1474 */     this.internalConnection.doXSSessionAttachOp(paramInt1, paramArrayOfByte1, paramXSSecureId, paramArrayOfByte2, paramXSPrincipal, paramArrayOfString1, paramArrayOfString2, paramArrayOfString3, paramArrayOfXSNamespace1, paramArrayOfXSNamespace2, paramArrayOfXSNamespace3, paramTIMESTAMPTZ1, paramTIMESTAMPTZ2, paramInt2, paramLong, paramXSKeyval, paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode paramXSSessionSetOperationCode, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, XSSessionParameters paramXSSessionParameters)
/*      */     throws SQLException
/*      */   {
/* 1501 */     this.internalConnection.doXSSessionChangeOp(paramXSSessionSetOperationCode, paramArrayOfByte, paramXSSecureId, paramXSSessionParameters);
/*      */   }
/*      */ 
/*      */   public byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode paramXSSessionOperationCode, XSSecureId paramXSSecureId, byte[] paramArrayOfByte, XSPrincipal paramXSPrincipal, String paramString, XSNamespace[] paramArrayOfXSNamespace, OracleConnection.XSSessionModeFlag paramXSSessionModeFlag, XSKeyval paramXSKeyval)
/*      */     throws SQLException
/*      */   {
/* 1517 */     return this.internalConnection.doXSSessionCreateOp(paramXSSessionOperationCode, paramXSSecureId, paramArrayOfByte, paramXSPrincipal, paramString, paramArrayOfXSNamespace, paramXSSessionModeFlag, paramXSKeyval);
/*      */   }
/*      */ 
/*      */   public void doXSSessionDestroyOp(byte[] paramArrayOfByte1, XSSecureId paramXSSecureId, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 1532 */     this.internalConnection.doXSSessionDestroyOp(paramArrayOfByte1, paramXSSecureId, paramArrayOfByte2);
/*      */   }
/*      */ 
/*      */   public void doXSSessionDetachOp(int paramInt, byte[] paramArrayOfByte, XSSecureId paramXSSecureId, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1543 */     this.internalConnection.doXSSessionDetachOp(paramInt, paramArrayOfByte, paramXSSecureId, paramBoolean);
/*      */   }
/*      */ 
/*      */   public BLOB createTemporaryBlob(Connection paramConnection, boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1559 */     registerHeartbeat();
/* 1560 */     return this.internalConnection.createTemporaryBlob(paramConnection, paramBoolean, paramInt);
/*      */   }
/*      */ 
/*      */   public CLOB createTemporaryClob(Connection paramConnection, boolean paramBoolean, int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 1572 */     registerHeartbeat();
/* 1573 */     return this.internalConnection.createTemporaryClob(paramConnection, paramBoolean, paramInt, paramShort);
/*      */   }
/*      */ 
/*      */   public String getDefaultSchemaNameForNamedTypes()
/*      */     throws SQLException
/*      */   {
/* 1586 */     return this.internalConnection.getDefaultSchemaNameForNamedTypes();
/*      */   }
/*      */ 
/*      */   public boolean isUsable()
/*      */   {
/* 1603 */     return (!this.closed) && (this.internalConnection.isUsable());
/*      */   }
/*      */ 
/*      */   public byte getInstanceProperty(OracleConnection.InstanceProperty paramInstanceProperty)
/*      */     throws SQLException
/*      */   {
/* 1615 */     return this.internalConnection.getInstanceProperty(paramInstanceProperty);
/*      */   }
/*      */ 
/*      */   public void setUsable(boolean paramBoolean)
/*      */   {
/* 1634 */     this.internalConnection.setUsable(paramBoolean);
/*      */   }
/*      */ 
/*      */   public int getTimezoneVersionNumber()
/*      */     throws SQLException
/*      */   {
/* 1647 */     return this.internalConnection.getTimezoneVersionNumber();
/*      */   }
/*      */ 
/*      */   public TIMEZONETAB getTIMEZONETAB()
/*      */     throws SQLException
/*      */   {
/* 1665 */     return this.internalConnection.getTIMEZONETAB();
/*      */   }
/*      */ 
/*      */   public void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener)
/*      */     throws SQLException
/*      */   {
/* 1677 */     this.internalConnection.setPDBChangeEventListener(paramPDBChangeEventListener);
/*      */   }
/*      */ 
/*      */   public void setPDBChangeEventListener(PDBChangeEventListener paramPDBChangeEventListener, Executor paramExecutor)
/*      */     throws SQLException
/*      */   {
/* 1690 */     this.internalConnection.setPDBChangeEventListener(paramPDBChangeEventListener, paramExecutor);
/*      */   }
/*      */ 
/*      */   public void addXSEventListener(XSEventListener paramXSEventListener)
/*      */     throws SQLException
/*      */   {
/* 1703 */     this.internalConnection.addXSEventListener(paramXSEventListener);
/*      */   }
/*      */ 
/*      */   public void addXSEventListener(XSEventListener paramXSEventListener, Executor paramExecutor)
/*      */     throws SQLException
/*      */   {
/* 1717 */     this.internalConnection.addXSEventListener(paramXSEventListener, paramExecutor);
/*      */   }
/*      */ 
/*      */   public void removeXSEventListener(XSEventListener paramXSEventListener)
/*      */     throws SQLException
/*      */   {
/* 1730 */     this.internalConnection.removeXSEventListener(paramXSEventListener);
/*      */   }
/*      */ 
/*      */   public void removeAllXSEventListener()
/*      */     throws SQLException
/*      */   {
/* 1743 */     this.internalConnection.removeAllXSEventListener();
/*      */   }
/*      */ 
/*      */   public OracleConnection.BufferCacheStatistics getByteBufferCacheStatistics()
/*      */   {
/* 1748 */     return this.internalConnection.getByteBufferCacheStatistics();
/*      */   }
/*      */ 
/*      */   public OracleConnection.BufferCacheStatistics getCharBufferCacheStatistics() {
/* 1752 */     return this.internalConnection.getCharBufferCacheStatistics();
/*      */   }
/*      */ 
/*      */   public boolean isDataInLocatorEnabled() throws SQLException
/*      */   {
/* 1757 */     return this.internalConnection.isDataInLocatorEnabled();
/*      */   }
/*      */ 
/*      */   public boolean isLobStreamPosStandardCompliant() throws SQLException
/*      */   {
/* 1762 */     return this.internalConnection.isLobStreamPosStandardCompliant();
/*      */   }
/*      */ 
/*      */   public long getCurrentSCN() throws SQLException
/*      */   {
/* 1767 */     return this.internalConnection.getCurrentSCN();
/*      */   }
/*      */ 
/*      */   public EnumSet<OracleConnection.TransactionState> getTransactionState() throws SQLException
/*      */   {
/* 1772 */     return this.internalConnection.getTransactionState();
/*      */   }
/*      */ 
/*      */   public boolean isConnectionSocketKeepAlive()
/*      */     throws SocketException, SQLException
/*      */   {
/* 1779 */     return this.internalConnection.isConnectionSocketKeepAlive();
/*      */   }
/*      */ 
/*      */   public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener paramLogicalTransactionIdEventListener)
/*      */     throws SQLException
/*      */   {
/* 1787 */     this.connection.removeLogicalTransactionIdEventListener(paramLogicalTransactionIdEventListener);
/*      */   }
/*      */ 
/*      */   public void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> paramEnumSet)
/*      */     throws SQLException
/*      */   {
/* 1793 */     this.internalConnection.setReplayOperations(paramEnumSet);
/*      */   }
/*      */ 
/*      */   public void beginNonRequestCalls() throws SQLException
/*      */   {
/* 1798 */     this.internalConnection.beginNonRequestCalls();
/*      */   }
/*      */ 
/*      */   public void endNonRequestCalls() throws SQLException {
/* 1802 */     this.internalConnection.endNonRequestCalls();
/*      */   }
/*      */ 
/*      */   public void setReplayContext(ReplayContext[] paramArrayOfReplayContext) throws SQLException
/*      */   {
/* 1807 */     this.internalConnection.setReplayContext(paramArrayOfReplayContext);
/*      */   }
/*      */ 
/*      */   public void registerEndReplayCallback(OracleConnection.EndReplayCallback paramEndReplayCallback) throws SQLException {
/* 1811 */     this.internalConnection.registerEndReplayCallback(paramEndReplayCallback);
/*      */   }
/*      */ 
/*      */   public int getEOC() throws SQLException
/*      */   {
/* 1816 */     return this.internalConnection.getEOC();
/*      */   }
/*      */ 
/*      */   public ReplayContext[] getReplayContext() throws SQLException {
/* 1820 */     return this.internalConnection.getReplayContext();
/*      */   }
/*      */ 
/*      */   public ReplayContext getLastReplayContext() throws SQLException {
/* 1824 */     return this.internalConnection.getLastReplayContext();
/*      */   }
/*      */ 
/*      */   public byte[] getDerivedKeyInternal(byte[] paramArrayOfByte, int paramInt) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException
/*      */   {
/* 1829 */     return this.internalConnection.getDerivedKeyInternal(paramArrayOfByte, paramInt);
/*      */   }
/*      */ 
/*      */   public short getExecutingRPCFunctionCode() {
/* 1833 */     return this.internalConnection.getExecutingRPCFunctionCode();
/*      */   }
/*      */ 
/*      */   public String getExecutingRPCSQL() {
/* 1837 */     return this.internalConnection.getExecutingRPCSQL();
/*      */   }
/*      */ 
/*      */   public void setReplayingMode(boolean paramBoolean) throws SQLException {
/* 1841 */     this.internalConnection.setReplayingMode(paramBoolean);
/*      */   }
/*      */ 
/*      */   public void jmsEnqueue(String paramString, JMSEnqueueOptions paramJMSEnqueueOptions, JMSMessage paramJMSMessage, AQMessageProperties paramAQMessageProperties)
/*      */     throws SQLException
/*      */   {
/* 1849 */     this.internalConnection.jmsEnqueue(paramString, paramJMSEnqueueOptions, paramJMSMessage, paramAQMessageProperties);
/*      */   }
/*      */ 
/*      */   public JMSMessage jmsDequeue(String paramString, JMSDequeueOptions paramJMSDequeueOptions)
/*      */     throws SQLException
/*      */   {
/* 1857 */     JMSMessage localJMSMessage = this.internalConnection.jmsDequeue(paramString, paramJMSDequeueOptions);
/* 1858 */     return localJMSMessage;
/*      */   }
/*      */ 
/*      */   public JMSMessage jmsDequeue(String paramString1, JMSDequeueOptions paramJMSDequeueOptions, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1865 */     JMSMessage localJMSMessage = this.internalConnection.jmsDequeue(paramString1, paramJMSDequeueOptions, paramString2);
/*      */ 
/* 1867 */     return localJMSMessage;
/*      */   }
/*      */ 
/*      */   public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] paramArrayOfString, Map<String, Properties> paramMap)
/*      */     throws SQLException
/*      */   {
/* 1873 */     Map localMap = this.internalConnection.registerJMSNotification(paramArrayOfString, paramMap);
/*      */ 
/* 1875 */     return localMap;
/*      */   }
/*      */ 
/*      */   public void unregisterJMSNotification(JMSNotificationRegistration paramJMSNotificationRegistration) throws SQLException
/*      */   {
/* 1880 */     this.internalConnection.unregisterJMSNotification(paramJMSNotificationRegistration);
/*      */   }
/*      */ 
/*      */   public void ackJMSNotification(JMSNotificationRegistration paramJMSNotificationRegistration, byte[] paramArrayOfByte, JMSNotificationRegistration.Directive paramDirective)
/*      */     throws SQLException
/*      */   {
/* 1887 */     this.internalConnection.ackJMSNotification(paramJMSNotificationRegistration, paramArrayOfByte, paramDirective);
/*      */   }
/*      */ 
/*      */   public boolean isDRCPEnabled()
/*      */     throws SQLException
/*      */   {
/* 1900 */     return this.internalConnection.isDRCPEnabled();
/*      */   }
/*      */ 
/*      */   public boolean attachServerConnection()
/*      */     throws SQLException
/*      */   {
/* 1913 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 153);
/* 1914 */     localSQLException.fillInStackTrace();
/* 1915 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void detachServerConnection(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1929 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 153);
/* 1930 */     localSQLException.fillInStackTrace();
/* 1931 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public boolean needToPurgeStatementCache()
/*      */     throws SQLException
/*      */   {
/* 1954 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 153);
/* 1955 */     localSQLException.fillInStackTrace();
/* 1956 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public int getNegotiatedSDU()
/*      */     throws SQLException
/*      */   {
/* 1963 */     return this.internalConnection.getNegotiatedSDU();
/*      */   }
/*      */ 
/*      */   public int getVarTypeMaxLenCompat()
/*      */     throws SQLException
/*      */   {
/* 1969 */     return this.internalConnection.getVarTypeMaxLenCompat();
/*      */   }
/*      */ 
/*      */   public void setChecksumMode(OracleConnection.ChecksumMode paramChecksumMode)
/*      */     throws SQLException
/*      */   {
/* 1975 */     this.internalConnection.setChecksumMode(paramChecksumMode);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.LogicalConnection
 * JD-Core Version:    0.6.2
 */