/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ 
/*     */ abstract class LobCommonAccessor extends Accessor
/*     */ {
/*     */   long[] prefetchedDataOffset;
/*     */   int[] prefetchedDataLength;
/*     */   long[] prefetchedLength;
/*     */   int[] prefetchedChunkSize;
/* 368 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   LobCommonAccessor(Representation paramRepresentation, OracleStatement paramOracleStatement, int paramInt, boolean paramBoolean)
/*     */   {
/*  34 */     super(paramRepresentation, paramOracleStatement, paramInt, paramBoolean);
/*     */   }
/*     */ 
/*     */   void setCapacity(int paramInt)
/*     */   {
/*  47 */     super.setCapacity(paramInt);
/*  48 */     if ((isPrefetched()) && (this.prefetchedDataOffset == null)) {
/*  49 */       this.prefetchedDataOffset = new long[paramInt];
/*  50 */       this.prefetchedDataLength = new int[paramInt];
/*  51 */       this.prefetchedLength = new long[paramInt];
/*  52 */       this.prefetchedChunkSize = new int[paramInt];
/*     */     }
/*  54 */     else if ((isPrefetched()) && (paramInt > this.prefetchedDataOffset.length)) {
/*  55 */       Object localObject = new long[paramInt];
/*  56 */       System.arraycopy(this.prefetchedDataOffset, 0, localObject, 0, this.prefetchedDataOffset.length);
/*  57 */       this.prefetchedDataOffset = ((long[])localObject);
/*  58 */       localObject = new int[paramInt];
/*  59 */       System.arraycopy(this.prefetchedDataLength, 0, localObject, 0, this.prefetchedDataLength.length);
/*  60 */       this.prefetchedDataLength = ((int[])localObject);
/*  61 */       localObject = new long[paramInt];
/*  62 */       System.arraycopy(this.prefetchedLength, 0, localObject, 0, this.prefetchedLength.length);
/*  63 */       this.prefetchedLength = ((long[])localObject);
/*  64 */       localObject = new int[paramInt];
/*  65 */       System.arraycopy(this.prefetchedChunkSize, 0, localObject, 0, this.prefetchedChunkSize.length);
/*  66 */       this.prefetchedChunkSize = ((int[])localObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   Accessor copyForDefine(OracleStatement paramOracleStatement)
/*     */   {
/*  79 */     LobCommonAccessor localLobCommonAccessor = (LobCommonAccessor)super.copyForDefine(paramOracleStatement);
/*  80 */     localLobCommonAccessor.prefetchedDataOffset = null;
/*  81 */     localLobCommonAccessor.prefetchedDataLength = null;
/*  82 */     localLobCommonAccessor.prefetchedLength = null;
/*  83 */     localLobCommonAccessor.prefetchedChunkSize = null;
/*  84 */     return localLobCommonAccessor;
/*     */   }
/*     */ 
/*     */   protected void copyFromInternal(Accessor paramAccessor, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 101 */     super.copyFromInternal(paramAccessor, paramInt1, paramInt2);
/*     */ 
/* 103 */     if (isPrefetched()) {
/* 104 */       LobCommonAccessor localLobCommonAccessor = (LobCommonAccessor)paramAccessor;
/* 105 */       assert (localLobCommonAccessor.isPrefetched()) : "srcLobAcc is not prefetched";
/*     */ 
/* 108 */       long l = this.rowData.length();
/* 109 */       if (localLobCommonAccessor.getPrefetchedDataLength(paramInt1) <= getPrefetchedDataLength(paramInt2))
/* 110 */         l = getPrefetchedDataOffset(paramInt2);
/* 111 */       this.rowData.put(l, localLobCommonAccessor.rowData, localLobCommonAccessor.getPrefetchedDataOffset(paramInt1), localLobCommonAccessor.getPrefetchedDataLength(paramInt1));
/*     */ 
/* 115 */       setPrefetchedDataOffset(paramInt2, l);
/* 116 */       setPrefetchedDataLength(paramInt2, localLobCommonAccessor.getPrefetchedDataLength(paramInt1));
/*     */ 
/* 118 */       setPrefetchedLength(paramInt2, localLobCommonAccessor.getPrefetchedLength(paramInt1));
/* 119 */       setPrefetchedChunkSize(paramInt2, localLobCommonAccessor.getPrefetchedChunkSize(paramInt1));
/*     */     }
/*     */   }
/*     */ 
/*     */   void deleteRow(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 135 */     super.deleteRow(paramInt);
/*     */ 
/* 137 */     if (isPrefetched()) {
/* 138 */       this.rowData.freeSpace(getPrefetchedDataOffset(paramInt), getPrefetchedDataLength(paramInt));
/*     */ 
/* 140 */       delete(this.prefetchedDataOffset, paramInt);
/* 141 */       delete(this.prefetchedDataLength, paramInt);
/* 142 */       delete(this.prefetchedLength, paramInt);
/* 143 */       delete(this.prefetchedChunkSize, paramInt);
/*     */     }
/*     */   }
/*     */ 
/*     */   final boolean isPrefetched()
/*     */   {
/* 155 */     return (!this.isDMLReturnedParam) && (this.lobPrefetchSizeForThisColumn > -1);
/*     */   }
/*     */ 
/*     */   void setNoPrefetch()
/*     */   {
/* 165 */     this.lobPrefetchSizeForThisColumn = -1;
/* 166 */     this.prefetchedDataOffset = null;
/* 167 */     this.prefetchedDataLength = null;
/* 168 */     this.prefetchedLength = null;
/* 169 */     this.prefetchedChunkSize = null;
/*     */   }
/*     */ 
/*     */   final int getPrefetchLength()
/*     */   {
/* 181 */     return this.lobPrefetchSizeForThisColumn;
/*     */   }
/*     */ 
/*     */   void setPrefetchLength(int paramInt)
/*     */   {
/* 192 */     if (paramInt == -1) {
/* 193 */       setNoPrefetch();
/*     */     }
/*     */     else {
/* 196 */       this.lobPrefetchSizeForThisColumn = paramInt;
/* 197 */       if (this.rowNull != null) setCapacity(this.rowNull.length);
/*     */     }
/*     */   }
/*     */ 
/*     */   final void setPrefetchedDataOffset(int paramInt)
/*     */   {
/* 210 */     assert (this.prefetchedDataOffset.length > paramInt) : ("prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + paramInt);
/*     */ 
/* 212 */     this.prefetchedDataOffset[paramInt] = this.rowData.getPosition();
/*     */   }
/*     */ 
/*     */   final void setPrefetchedDataOffset(int paramInt, long paramLong)
/*     */   {
/* 224 */     assert (this.prefetchedDataOffset.length > paramInt) : ("prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + paramInt);
/*     */ 
/* 226 */     this.prefetchedDataOffset[paramInt] = paramLong;
/*     */   }
/*     */ 
/*     */   final void setPrefetchedDataLength(int paramInt1, int paramInt2)
/*     */   {
/* 238 */     assert (this.prefetchedDataLength.length > paramInt1) : ("prefetchedDataLength.length: " + this.prefetchedDataLength.length + " currentRow: " + paramInt1);
/*     */ 
/* 240 */     this.prefetchedDataLength[paramInt1] = paramInt2;
/*     */   }
/*     */ 
/*     */   final void setPrefetchedLength(int paramInt, long paramLong)
/*     */   {
/* 254 */     assert (this.prefetchedLength.length > paramInt) : ("prefetchedLength.length: " + this.prefetchedLength.length + " currentRow: " + paramInt);
/*     */ 
/* 256 */     this.prefetchedLength[paramInt] = paramLong;
/*     */   }
/*     */ 
/*     */   final void setPrefetchedChunkSize(int paramInt1, int paramInt2)
/*     */   {
/* 268 */     assert (this.prefetchedChunkSize.length > paramInt1) : ("prefetchedChunkSize.length: " + this.prefetchedChunkSize.length + " currentRow: " + paramInt1);
/*     */ 
/* 270 */     this.prefetchedChunkSize[paramInt1] = paramInt2;
/*     */   }
/*     */ 
/*     */   final long getPrefetchedDataOffset(int paramInt)
/*     */   {
/* 282 */     return this.prefetchedDataOffset[paramInt];
/*     */   }
/*     */ 
/*     */   final int getPrefetchedDataLength(int paramInt)
/*     */   {
/* 293 */     return this.prefetchedDataLength[paramInt];
/*     */   }
/*     */ 
/*     */   final long getPrefetchedLength(int paramInt)
/*     */   {
/* 306 */     return this.prefetchedLength[paramInt];
/*     */   }
/*     */ 
/*     */   final int getPrefetchedChunkSize(int paramInt)
/*     */   {
/* 318 */     return this.prefetchedChunkSize[paramInt];
/*     */   }
/*     */ 
/*     */   final byte[] getPrefetchedData(int paramInt)
/*     */   {
/* 326 */     if (getPrefetchLength() > -1) {
/* 327 */       return this.rowData.get(getPrefetchedDataOffset(paramInt), getPrefetchedDataLength(paramInt));
/*     */     }
/*     */ 
/* 330 */     return null;
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 346 */     return getOracleObject(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 363 */     return getOracleObject(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.LobCommonAccessor
 * JD-Core Version:    0.6.2
 */