/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.KeywordValue;
/*     */ 
/*     */ class KeywordValueI extends KeywordValue
/*     */ {
/*     */   private int keyword;
/*     */   private byte[] binaryValue;
/*     */   private String textValue;
/*     */   private byte[] textValueArr;
/* 134 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   KeywordValueI(int paramInt, String paramString, byte[] paramArrayOfByte)
/*     */   {
/*  60 */     this.keyword = paramInt;
/*  61 */     this.textValue = paramString;
/*  62 */     this.binaryValue = paramArrayOfByte;
/*  63 */     this.textValueArr = null;
/*     */   }
/*     */ 
/*     */   void doCharConversion(DBConversion paramDBConversion) throws SQLException {
/*  67 */     if (this.textValue != null)
/*  68 */       this.textValueArr = paramDBConversion.StringToCharBytes(this.textValue);
/*     */     else
/*  70 */       this.textValueArr = null;
/*     */   }
/*     */ 
/*     */   public byte[] getBinaryValue() throws SQLException
/*     */   {
/*  75 */     return this.binaryValue;
/*     */   }
/*     */ 
/*     */   public String getTextValue() throws SQLException {
/*  79 */     return this.textValue;
/*     */   }
/*     */ 
/*     */   public int getKeyword() throws SQLException {
/*  83 */     return this.keyword;
/*     */   }
/*     */ 
/*     */   void marshal(T4CMAREngine paramT4CMAREngine) throws IOException
/*     */   {
/*  88 */     if (this.textValueArr != null)
/*     */     {
/*  90 */       paramT4CMAREngine.marshalUB2(this.textValueArr.length);
/*  91 */       paramT4CMAREngine.marshalCLR(this.textValueArr, this.textValueArr.length);
/*  92 */       paramT4CMAREngine.marshalUB2(0);
/*     */     }
/*     */     else
/*     */     {
/*  96 */       paramT4CMAREngine.marshalUB2(0);
/*  97 */       if (this.binaryValue != null)
/*     */       {
/*  99 */         paramT4CMAREngine.marshalUB2(this.binaryValue.length);
/* 100 */         paramT4CMAREngine.marshalCLR(this.binaryValue, this.binaryValue.length);
/*     */       }
/*     */       else {
/* 103 */         paramT4CMAREngine.marshalUB2(0);
/*     */       }
/*     */     }
/* 105 */     paramT4CMAREngine.marshalUB2(this.keyword);
/*     */   }
/*     */ 
/*     */   static KeywordValueI unmarshal(T4CMAREngine paramT4CMAREngine) throws SQLException, IOException
/*     */   {
/* 110 */     int[] arrayOfInt = new int[1];
/* 111 */     String str = null;
/* 112 */     byte[] arrayOfByte1 = null;
/* 113 */     int i = paramT4CMAREngine.unmarshalUB2();
/* 114 */     if (i != 0)
/*     */     {
/* 116 */       byte[] arrayOfByte2 = new byte[i];
/* 117 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte2, 0, arrayOfInt);
/* 118 */       str = paramT4CMAREngine.conv.CharBytesToString(arrayOfByte2, arrayOfByte2.length);
/*     */     }
/*     */ 
/* 121 */     int j = paramT4CMAREngine.unmarshalUB2();
/* 122 */     if (j != 0)
/*     */     {
/* 124 */       arrayOfByte1 = new byte[j];
/* 125 */       paramT4CMAREngine.unmarshalCLR(arrayOfByte1, 0, arrayOfInt);
/*     */     }
/*     */ 
/* 128 */     int k = paramT4CMAREngine.unmarshalUB2();
/* 129 */     return new KeywordValueI(k, str, arrayOfByte1);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.KeywordValueI
 * JD-Core Version:    0.6.2
 */