/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.INTERVALDS;
/*     */ 
/*     */ class IntervaldsAccessor extends Accessor
/*     */ {
/*     */   static final int MAXLENGTH = 11;
/* 146 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   IntervaldsAccessor(OracleStatement paramOracleStatement, int paramInt1, short paramShort, int paramInt2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/*  25 */     super(Representation.INTERVALDS, paramOracleStatement, 11, paramBoolean);
/*     */ 
/*  27 */     init(paramOracleStatement, 183, 183, paramShort, paramBoolean);
/*  28 */     initForDataAccess(paramInt2, paramInt1, null);
/*     */   }
/*     */ 
/*     */   IntervaldsAccessor(OracleStatement paramOracleStatement, int paramInt1, boolean paramBoolean, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, short paramShort)
/*     */     throws SQLException
/*     */   {
/*  36 */     super(Representation.INTERVALDS, paramOracleStatement, 11, false);
/*     */ 
/*  38 */     init(paramOracleStatement, 183, 183, paramShort, false);
/*  39 */     initForDescribe(183, paramInt1, paramBoolean, paramInt2, paramInt3, paramInt4, paramInt5, paramInt6, paramShort, null);
/*     */ 
/*  41 */     initForDataAccess(0, paramInt1, null);
/*     */   }
/*     */ 
/*     */   String getString(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  63 */     if (isNull(paramInt)) return null;
/*  64 */     return getINTERVALDS(paramInt).toString();
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  81 */     return getINTERVALDS(paramInt);
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 103 */     return getINTERVALDS(paramInt);
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 120 */     return getINTERVALDS(paramInt);
/*     */   }
/*     */ 
/*     */   INTERVALDS getINTERVALDS(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 139 */     if (isNull(paramInt)) return null;
/* 140 */     return new INTERVALDS(getBytesInternal(paramInt));
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.IntervaldsAccessor
 * JD-Core Version:    0.6.2
 */