/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.aq.AQMessageProperties;
/*     */ import oracle.jdbc.internal.JMSMessageProperties;
/*     */ 
/*     */ public abstract class InternalFactory
/*     */ {
/*     */   public static KeywordValueI createKeywordValue(int paramInt, String paramString, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/*  51 */     return new KeywordValueI(paramInt, paramString, paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public static KeywordValueLongI createKeywordValueLong(int paramInt, String paramString, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/*  59 */     return new KeywordValueLongI(paramInt, paramString, paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public static XSAttributeI createXSAttribute()
/*     */     throws SQLException
/*     */   {
/*  65 */     return new XSAttributeI();
/*     */   }
/*     */ 
/*     */   public static XSNamespaceI createXSNamespace()
/*     */     throws SQLException
/*     */   {
/*  71 */     return new XSNamespaceI();
/*     */   }
/*     */ 
/*     */   public static AQMessagePropertiesI createAQMessageProperties() throws SQLException
/*     */   {
/*  76 */     return new AQMessagePropertiesI();
/*     */   }
/*     */ 
/*     */   public static AQAgentI createAQAgent()
/*     */     throws SQLException
/*     */   {
/*  82 */     return new AQAgentI();
/*     */   }
/*     */ 
/*     */   public static AQMessageI createAQMessage(AQMessageProperties paramAQMessageProperties)
/*     */     throws SQLException
/*     */   {
/*  89 */     return new AQMessageI((AQMessagePropertiesI)paramAQMessageProperties);
/*     */   }
/*     */ 
/*     */   public static JMSMessageI createJMSMessage(JMSMessageProperties paramJMSMessageProperties)
/*     */   {
/*  94 */     return new JMSMessageI((JMSMessagePropertiesI)paramJMSMessageProperties);
/*     */   }
/*     */ 
/*     */   public static JMSMessagePropertiesI createJMSMessageProperties() throws SQLException
/*     */   {
/*  99 */     return new JMSMessagePropertiesI();
/*     */   }
/*     */ 
/*     */   public static byte[] urowid2rowid(long[] paramArrayOfLong)
/*     */   {
/* 114 */     return T4CRowidAccessor.rowidToString(paramArrayOfLong);
/*     */   }
/*     */ 
/*     */   public static long[] rowid2urowid(byte[] paramArrayOfByte, int paramInt1, int paramInt2) throws SQLException {
/* 118 */     return T4CRowidAccessor.stringToRowid(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public static XSSecureIdI createXSecureId()
/*     */     throws SQLException
/*     */   {
/* 124 */     return new XSSecureIdI();
/*     */   }
/*     */ 
/*     */   public static XSPrincipalI createXSPrincipal()
/*     */     throws SQLException
/*     */   {
/* 130 */     return new XSPrincipalI();
/*     */   }
/*     */ 
/*     */   public static XSKeyvalI createXSKeyval()
/*     */     throws SQLException
/*     */   {
/* 136 */     return new XSKeyvalI();
/*     */   }
/*     */ 
/*     */   public static XSSessionNamespaceI createXSSessionNamespace()
/*     */     throws SQLException
/*     */   {
/* 142 */     return new XSSessionNamespaceI();
/*     */   }
/*     */ 
/*     */   public static XSSessionParametersI createXSSessionParameters() throws SQLException
/*     */   {
/* 147 */     return new XSSessionParametersI();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.InternalFactory
 * JD-Core Version:    0.6.2
 */