/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLRecoverableException;
/*      */ import java.sql.Statement;
/*      */ import oracle.jdbc.OracleResultSet.AuthorizationIndicator;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ 
/*      */ class InsensitiveScrollableResultSet extends GeneratedScrollableResultSet
/*      */ {
/*      */   protected boolean isComplete;
/*      */   protected boolean isDoneFetchingRows;
/*      */   protected final int maxRows;
/* 1082 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   InsensitiveScrollableResultSet(PhysicalConnection paramPhysicalConnection, OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/*   66 */     super(paramPhysicalConnection, paramOracleStatement);
/*      */ 
/*   68 */     this.closeStatementOnClose = (paramOracleStatement == null ? false : paramOracleStatement.isCloseOnCompletion());
/*   69 */     this.isDoneFetchingRows = false;
/*   70 */     this.fetchedRowCount = paramOracleStatement.validRows;
/*   71 */     this.isComplete = paramOracleStatement.isComplete;
/*   72 */     this.maxRows = paramOracleStatement.getMaxRows();
/*   73 */     if ((this.maxRows > 0) && (this.maxRows < this.fetchedRowCount)) {
/*   74 */       this.fetchedRowCount = this.maxRows;
/*   75 */       doneFetchingRows(false);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean isForwardOnly()
/*      */   {
/*   94 */     return false;
/*      */   }
/*      */ 
/*      */   public int getType()
/*      */   {
/*  113 */     return 1004;
/*      */   }
/*      */ 
/*      */   public int getConcurrency()
/*      */   {
/*  129 */     return 1007;
/*      */   }
/*      */ 
/*      */   public String getCursorName()
/*      */     throws SQLException
/*      */   {
/*  135 */     synchronized (this.connection)
/*      */     {
/*  143 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "getCursorName");
/*  144 */       localSQLException.fillInStackTrace();
/*  145 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*  156 */     synchronized (this.connection)
/*      */     {
/*  163 */       if (this.closed) return;
/*  164 */       super.close();
/*      */ 
/*  167 */       if (this.statement.numReturnParams > 0) return;
/*      */ 
/*  169 */       doneFetchingRows(false);
/*  170 */       this.statement.endOfResultSet(false);
/*      */ 
/*  177 */       this.statement.closeCursorOnPlainStatement();
/*      */ 
/*  179 */       if (this.closeStatementOnClose)
/*      */         try {
/*  181 */           this.statement.close();
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean wasNull() throws SQLException
/*      */   {
/*  191 */     synchronized (this.connection)
/*      */     {
/*  199 */       if (this.closed)
/*      */       {
/*  201 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "wasNull");
/*  202 */         localSQLException.fillInStackTrace();
/*  203 */         throw localSQLException;
/*      */       }
/*      */ 
/*  206 */       return this.statement.wasNullValue(this.currentRow);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean rowDeleted()
/*      */     throws SQLException
/*      */   {
/*  218 */     return false;
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/*  224 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  231 */       if (this.closed)
/*      */       {
/*  233 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getMetaData");
/*  234 */         localSQLException.fillInStackTrace();
/*  235 */         throw localSQLException;
/*      */       }
/*      */ 
/*  238 */       if (this.statement.closed)
/*      */       {
/*  240 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getMetaData");
/*  241 */         localSQLException.fillInStackTrace();
/*  242 */         throw localSQLException;
/*      */       }
/*      */ 
/*  248 */       if (!this.statement.isOpen)
/*      */       {
/*  250 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 144, "getMetaData");
/*  251 */         localSQLException.fillInStackTrace();
/*  252 */         throw localSQLException;
/*      */       }
/*      */ 
/*  255 */       return this.statement.getResultSetMetaData();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Statement getStatement()
/*      */     throws SQLException
/*      */   {
/*  262 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  270 */       if (this.closed) {
/*  271 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getStatement");
/*  272 */         localSQLException.fillInStackTrace();
/*  273 */         throw localSQLException;
/*      */       }
/*  275 */       if (this.statement.closed) {
/*  276 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getStatement");
/*  277 */         localSQLException.fillInStackTrace();
/*  278 */         throw localSQLException;
/*      */       }
/*      */ 
/*  283 */       return this.statement.wrapper == null ? this.statement : this.statement.wrapper;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int findColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/*  292 */     synchronized (this.connection)
/*      */     {
/*  299 */       return this.statement.getColumnIndex(paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFetchSize(int paramInt) throws SQLException
/*      */   {
/*  305 */     synchronized (this.connection)
/*      */     {
/*  312 */       this.statement.setPrefetchInternal(paramInt, false, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getFetchSize() throws SQLException
/*      */   {
/*  318 */     synchronized (this.connection)
/*      */     {
/*  325 */       return this.statement.getPrefetchInternal(false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isBeforeFirst()
/*      */     throws SQLException
/*      */   {
/*  335 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  342 */       if (this.closed) {
/*  343 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "isBeforeFirst");
/*  344 */         localSQLException.fillInStackTrace();
/*  345 */         throw localSQLException;
/*      */       }
/*  347 */       if (this.statement.closed) {
/*  348 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "isBeforeFirst");
/*  349 */         localSQLException.fillInStackTrace();
/*  350 */         throw localSQLException;
/*      */       }
/*  352 */       return (!isEmptyResultSet()) && (this.currentRow == -1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isAfterLast()
/*      */     throws SQLException
/*      */   {
/*  362 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  369 */       if (this.closed) {
/*  370 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "isAfterLast");
/*  371 */         localSQLException.fillInStackTrace();
/*  372 */         throw localSQLException;
/*      */       }
/*  374 */       if (this.statement.closed) {
/*  375 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "isAfterLast");
/*  376 */         localSQLException.fillInStackTrace();
/*  377 */         throw localSQLException;
/*      */       }
/*  379 */       return this.currentRow == this.fetchedRowCount;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isFirst() throws SQLException
/*      */   {
/*  385 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  392 */       if (this.closed) {
/*  393 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "isFirst");
/*  394 */         localSQLException.fillInStackTrace();
/*  395 */         throw localSQLException;
/*      */       }
/*  397 */       if (this.statement.closed) {
/*  398 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "isFirst");
/*  399 */         localSQLException.fillInStackTrace();
/*  400 */         throw localSQLException;
/*      */       }
/*  402 */       return (!isEmptyResultSet()) && (this.currentRow == 0);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isLast()
/*      */     throws SQLException
/*      */   {
/*  412 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  420 */       if (this.closed) {
/*  421 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "isLast");
/*  422 */         localSQLException.fillInStackTrace();
/*  423 */         throw localSQLException;
/*      */       }
/*  425 */       if (this.statement.closed) {
/*  426 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "isLast");
/*  427 */         localSQLException.fillInStackTrace();
/*  428 */         throw localSQLException;
/*      */       }
/*  430 */       if (isForwardOnly()) {
/*  431 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "isLast");
/*  432 */         localSQLException.fillInStackTrace();
/*  433 */         throw localSQLException;
/*      */       }
/*      */ 
/*  436 */       if ((!this.isComplete) && (this.currentRow + 1 == this.fetchedRowCount)) fetchMoreRows();
/*      */ 
/*  438 */       assert ((this.isComplete) || (this.fetchedRowCount > this.currentRow + 1)) : ("isComplete: " + this.isComplete + ", fetchedRowCount: " + this.fetchedRowCount + ", currentRow: " + this.currentRow);
/*  439 */       if (this.fetchedRowCount == 0) return false;
/*  440 */       return (this.isComplete) && (this.currentRow + 1 == this.fetchedRowCount);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getRow()
/*      */     throws SQLException
/*      */   {
/*  447 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  455 */       if (this.closed) {
/*  456 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getRow");
/*  457 */         localSQLException.fillInStackTrace();
/*  458 */         throw localSQLException;
/*      */       }
/*  460 */       if (this.statement.closed) {
/*  461 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getRow");
/*  462 */         localSQLException.fillInStackTrace();
/*  463 */         throw localSQLException;
/*      */       }
/*      */ 
/*  466 */       if (isEmptyResultSet()) return 0;
/*  467 */       if (this.currentRow == this.fetchedRowCount) return 0;
/*  468 */       return this.currentRow + 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean absolute(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/*  482 */     if (this.closed) {
/*  483 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "absolute");
/*  484 */       localSQLException.fillInStackTrace();
/*  485 */       throw localSQLException;
/*      */     }
/*  487 */     if (this.connection.isClosed()) {
/*  488 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "absolute");
/*  489 */       localSQLException.fillInStackTrace();
/*  490 */       throw localSQLException;
/*      */     }
/*  492 */     if (this.statement.closed) {
/*  493 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "absolute");
/*  494 */       localSQLException.fillInStackTrace();
/*  495 */       throw localSQLException;
/*      */     }
/*  497 */     if (isForwardOnly()) {
/*  498 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "absolute");
/*  499 */       localSQLException.fillInStackTrace();
/*  500 */       throw localSQLException;
/*      */     }
/*      */ 
/*  503 */     return absoluteInternal(paramInt);
/*      */   }
/*      */ 
/*      */   public boolean first()
/*      */     throws SQLException
/*      */   {
/*  509 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  517 */       if (this.closed) {
/*  518 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "first");
/*  519 */         localSQLException.fillInStackTrace();
/*  520 */         throw localSQLException;
/*      */       }
/*  522 */       if (this.connection.isClosed()) {
/*  523 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "first");
/*  524 */         localSQLException.fillInStackTrace();
/*  525 */         throw localSQLException;
/*      */       }
/*  527 */       if (this.statement.closed) {
/*  528 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "first");
/*  529 */         localSQLException.fillInStackTrace();
/*  530 */         throw localSQLException;
/*      */       }
/*  532 */       if (isForwardOnly()) {
/*  533 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "first");
/*  534 */         localSQLException.fillInStackTrace();
/*  535 */         throw localSQLException;
/*      */       }
/*  537 */       return absoluteInternal(1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean next() throws SQLException
/*      */   {
/*  543 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  551 */       if (this.statement.sqlKind.isPlsqlOrCall()) {
/*  552 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 166, "next");
/*  553 */         localSQLException.fillInStackTrace();
/*  554 */         throw localSQLException;
/*      */       }
/*  556 */       if (this.closed) {
/*  557 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "next");
/*  558 */         localSQLException.fillInStackTrace();
/*  559 */         throw localSQLException;
/*      */       }
/*  561 */       if (this.connection.isClosed()) {
/*  562 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "next");
/*  563 */         localSQLException.fillInStackTrace();
/*  564 */         throw localSQLException;
/*      */       }
/*  566 */       if (this.statement.closed) {
/*  567 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "next");
/*  568 */         localSQLException.fillInStackTrace();
/*  569 */         throw localSQLException;
/*      */       }
/*      */ 
/*  572 */       return absoluteInternal(this.currentRow + 2);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean previous() throws SQLException
/*      */   {
/*  578 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  586 */       if (this.closed) {
/*  587 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "previous");
/*  588 */         localSQLException.fillInStackTrace();
/*  589 */         throw localSQLException;
/*      */       }
/*  591 */       if (this.connection.isClosed()) {
/*  592 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "previous");
/*  593 */         localSQLException.fillInStackTrace();
/*  594 */         throw localSQLException;
/*      */       }
/*  596 */       if (this.statement.closed) {
/*  597 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "previous");
/*  598 */         localSQLException.fillInStackTrace();
/*  599 */         throw localSQLException;
/*      */       }
/*      */ 
/*  602 */       if (isForwardOnly()) {
/*  603 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "previous");
/*  604 */         localSQLException.fillInStackTrace();
/*  605 */         throw localSQLException;
/*      */       }
/*  607 */       if (this.currentRow > -1) return absoluteInternal(this.currentRow);
/*  608 */       return false;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean last() throws SQLException
/*      */   {
/*  614 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  622 */       if (this.closed) {
/*  623 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "last");
/*  624 */         localSQLException.fillInStackTrace();
/*  625 */         throw localSQLException;
/*      */       }
/*  627 */       if (this.connection.isClosed()) {
/*  628 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "last");
/*  629 */         localSQLException.fillInStackTrace();
/*  630 */         throw localSQLException;
/*      */       }
/*  632 */       if (this.statement.closed) {
/*  633 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "last");
/*  634 */         localSQLException.fillInStackTrace();
/*  635 */         throw localSQLException;
/*      */       }
/*  637 */       if (isForwardOnly()) {
/*  638 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "last");
/*  639 */         localSQLException.fillInStackTrace();
/*  640 */         throw localSQLException;
/*      */       }
/*      */ 
/*  643 */       if (isEmptyResultSet()) return false;
/*  644 */       while (!this.isComplete) fetchMoreRows();
/*  645 */       this.currentRow = (this.fetchedRowCount - 1);
/*  646 */       return true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void beforeFirst()
/*      */     throws SQLException
/*      */   {
/*  661 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  669 */       if (this.closed) {
/*  670 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "beforeFirst");
/*  671 */         localSQLException.fillInStackTrace();
/*  672 */         throw localSQLException;
/*      */       }
/*  674 */       if (this.connection.isClosed()) {
/*  675 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "beforeFirst");
/*  676 */         localSQLException.fillInStackTrace();
/*  677 */         throw localSQLException;
/*      */       }
/*  679 */       if (this.statement.closed) {
/*  680 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "beforeFirst");
/*  681 */         localSQLException.fillInStackTrace();
/*  682 */         throw localSQLException;
/*      */       }
/*  684 */       if (isForwardOnly()) {
/*  685 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "beforeFirst");
/*  686 */         localSQLException.fillInStackTrace();
/*  687 */         throw localSQLException;
/*      */       }
/*      */ 
/*  690 */       absolute(0);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void afterLast()
/*      */     throws SQLException
/*      */   {
/*  705 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  713 */       if (this.closed) {
/*  714 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "afterLast");
/*  715 */         localSQLException.fillInStackTrace();
/*  716 */         throw localSQLException;
/*      */       }
/*  718 */       if (this.connection.isClosed()) {
/*  719 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "afterLast");
/*  720 */         localSQLException.fillInStackTrace();
/*  721 */         throw localSQLException;
/*      */       }
/*  723 */       if (this.statement.closed) {
/*  724 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "afterLast");
/*  725 */         localSQLException.fillInStackTrace();
/*  726 */         throw localSQLException;
/*      */       }
/*  728 */       if (isForwardOnly()) {
/*  729 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "afterLast");
/*  730 */         localSQLException.fillInStackTrace();
/*  731 */         throw localSQLException;
/*      */       }
/*      */ 
/*  734 */       if (!isEmptyResultSet()) {
/*  735 */         while (!this.isComplete) fetchMoreRows();
/*  736 */         this.currentRow = this.fetchedRowCount;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean relative(int paramInt) throws SQLException
/*      */   {
/*  743 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  751 */       if (this.closed) {
/*  752 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "relative");
/*  753 */         localSQLException.fillInStackTrace();
/*  754 */         throw localSQLException;
/*      */       }
/*  756 */       if (this.connection.isClosed()) {
/*  757 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8, "relative");
/*  758 */         localSQLException.fillInStackTrace();
/*  759 */         throw localSQLException;
/*      */       }
/*  761 */       if (this.statement.closed) {
/*  762 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "relative");
/*  763 */         localSQLException.fillInStackTrace();
/*  764 */         throw localSQLException;
/*      */       }
/*  766 */       if (isForwardOnly()) {
/*  767 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 75, "relative");
/*  768 */         localSQLException.fillInStackTrace();
/*  769 */         throw localSQLException;
/*      */       }
/*  771 */       if (paramInt == 0) return isValidRow();
/*  772 */       if (paramInt == 1) return next();
/*  773 */       if (paramInt == -1) return previous();
/*  774 */       if (this.currentRow + paramInt < 0) return absoluteInternal(0);
/*  775 */       return absoluteInternal(this.currentRow + paramInt + 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void refreshRow() throws SQLException
/*      */   {
/*  781 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException1;
/*  789 */       if ((!this.statement.isRowidPrepended) || (isForwardOnly()))
/*      */       {
/*  791 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23, "refreshRow");
/*  792 */         localSQLException1.fillInStackTrace();
/*  793 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  796 */       if (this.closed) {
/*  797 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "refreshRow");
/*  798 */         localSQLException1.fillInStackTrace();
/*  799 */         throw localSQLException1;
/*      */       }
/*  801 */       if (this.statement.closed) {
/*  802 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "refreshRow");
/*  803 */         localSQLException1.fillInStackTrace();
/*  804 */         throw localSQLException1;
/*      */       }
/*  806 */       if ((this.currentRow < 0) || (this.currentRow >= this.fetchedRowCount))
/*      */       {
/*  808 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 11);
/*  809 */         localSQLException1.fillInStackTrace();
/*  810 */         throw localSQLException1;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  815 */         int i = this.currentRow + 1;
/*  816 */         if (getFetchDirection() == 1001) {
/*  817 */           i = Math.max(1, this.currentRow - getFetchSize() + 1);
/*      */         }
/*  819 */         refreshRows(i, getFetchSize());
/*      */       }
/*      */       catch (SQLRecoverableException localSQLRecoverableException)
/*      */       {
/*  823 */         throw localSQLRecoverableException;
/*      */       }
/*      */       catch (SQLException localSQLException2)
/*      */       {
/*  827 */         SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90, "Unsupported syntax for refreshRow()", localSQLException2);
/*  828 */         localSQLException3.fillInStackTrace();
/*  829 */         throw localSQLException3;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  848 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  856 */       if (this.closed)
/*      */       {
/*  858 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 11);
/*  859 */         localSQLException.fillInStackTrace();
/*  860 */         throw localSQLException;
/*      */       }
/*  862 */       if (this.currentRow < 0)
/*      */       {
/*  864 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  865 */         localSQLException.fillInStackTrace();
/*  866 */         throw localSQLException;
/*      */       }
/*  868 */       if (this.currentRow == this.fetchedRowCount)
/*      */       {
/*  870 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  871 */         localSQLException.fillInStackTrace();
/*  872 */         throw localSQLException;
/*      */       }
/*      */ 
/*  875 */       return this.statement.getAuthorizationIndicator(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean absoluteInternal(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  896 */     int i = paramInt - 1;
/*      */ 
/*  898 */     if (paramInt == 0) { this.currentRow = i;
/*  899 */     } else if ((i >= 0) && (i < this.fetchedRowCount)) { this.currentRow = i;
/*  900 */     } else if (i >= 0) {
/*  901 */       while ((!this.isComplete) && (this.fetchedRowCount <= i)) fetchMoreRows();
/*  902 */       if (i < this.fetchedRowCount) { this.currentRow = i;
/*      */       } else {
/*  904 */         assert (this.isComplete) : ("isComplete: " + this.isComplete);
/*  905 */         this.currentRow = this.fetchedRowCount;
/*  906 */         if (isForwardOnly()) doneFetchingRows(false); 
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  910 */       while (!this.isComplete) fetchMoreRows();
/*  911 */       i = this.fetchedRowCount + paramInt;
/*  912 */       if ((i >= 0) && (i < this.fetchedRowCount)) this.currentRow = i; else {
/*  913 */         this.currentRow = -1;
/*      */       }
/*      */     }
/*  916 */     assert ((this.currentRow < this.fetchedRowCount) || (this.isComplete)) : ("currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount + ", isComplete: " + this.isComplete);
/*      */ 
/*  918 */     assert ((-1 <= this.currentRow) && (this.currentRow <= this.fetchedRowCount)) : ("currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount);
/*  919 */     return (this.currentRow > -1) && (this.currentRow < this.fetchedRowCount);
/*      */   }
/*      */ 
/*      */   protected void fetchMoreRows()
/*      */     throws SQLException
/*      */   {
/*  934 */     assert (!this.isComplete) : ("isComplete: " + this.isComplete);
/*  935 */     clearWarnings();
/*      */ 
/*  937 */     this.fetchedRowCount += this.statement.fetchMoreRows(this.fetchedRowCount);
/*  938 */     this.isComplete = this.statement.isComplete;
/*  939 */     if ((this.currentRow == this.fetchedRowCount) && (isForwardOnly())) doneFetchingRows(false);
/*  940 */     if ((this.maxRows > 0) && (this.fetchedRowCount > this.maxRows)) {
/*  941 */       this.fetchedRowCount = this.maxRows;
/*  942 */       doneFetchingRows(false);
/*  943 */       this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 275);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doneFetchingRows(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  958 */     if (this.isDoneFetchingRows) return;
/*      */ 
/*  960 */     this.isDoneFetchingRows = true;
/*  961 */     this.isComplete = true;
/*      */     try
/*      */     {
/*  964 */       this.statement.closeQuery();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean isEmptyResultSet()
/*      */     throws SQLException
/*      */   {
/*  980 */     if (this.fetchedRowCount > 0) return false;
/*  981 */     if (this.isComplete) return true;
/*      */ 
/*  983 */     fetchMoreRows();
/*  984 */     assert (this.fetchedRowCount >= 0) : ("fetchedRowCount: " + this.fetchedRowCount);
/*  985 */     return this.fetchedRowCount == 0;
/*      */   }
/*      */ 
/*      */   boolean isValidRow()
/*      */     throws SQLException
/*      */   {
/*  995 */     return (this.currentRow > -1) && (this.currentRow < this.fetchedRowCount);
/*      */   }
/*      */ 
/*      */   protected int getValidRows()
/*      */   {
/* 1006 */     return this.fetchedRowCount;
/*      */   }
/*      */ 
/*      */   OracleStatement getOracleStatement()
/*      */     throws SQLException
/*      */   {
/* 1015 */     synchronized (this.connection)
/*      */     {
/* 1017 */       return this.statement;
/*      */     }
/*      */   }
/*      */ 
/*      */   void removeCurrentRowFromCache()
/*      */     throws SQLException
/*      */   {
/* 1029 */     assert (this.currentRow < this.fetchedRowCount) : ("currentRow:" + this.currentRow + " fetchedRowCount:" + this.fetchedRowCount);
/* 1030 */     if ((!this.isComplete) && (this.currentRow + 1 == this.fetchedRowCount))
/*      */     {
/* 1033 */       fetchMoreRows();
/*      */     }
/* 1035 */     this.statement.removeRowFromCache(this.currentRow);
/* 1036 */     this.fetchedRowCount -= 1;
/*      */   }
/*      */ 
/*      */   int refreshRows(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1050 */     return this.statement.refreshRows(paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   int getColumnCount()
/*      */     throws SQLException
/*      */   {
/* 1059 */     if (this.statement.accessors != null) {
/* 1060 */       return this.statement.numberOfDefinePositions - (1 + this.statement.offsetOfFirstUserColumn);
/*      */     }
/*      */ 
/* 1063 */     return getMetaData().getColumnCount();
/*      */   }
/*      */ 
/*      */   RowId getPrependedRowId()
/*      */     throws SQLException
/*      */   {
/* 1077 */     return this.statement.getPrependedRowId(this.currentRow);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.InsensitiveScrollableResultSet
 * JD-Core Version:    0.6.2
 */