/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Reader;
/*      */ import java.io.Writer;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.proxy.ProxyFactory;
/*      */ import oracle.jdbc.proxy._Proxy_;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NCLOB;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.OPAQUE;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.REF;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ abstract class GeneratedUpdatableResultSet extends OracleResultSet
/*      */ {
/*      */   protected static final int MAX_CHAR_BUFFER_SIZE = 1024;
/*      */   protected static final int MAX_BYTE_BUFFER_SIZE = 1024;
/*      */   protected static final int ASCII_STREAM = 1;
/*      */   protected static final int BINARY_STREAM = 2;
/*      */   protected static final int UNICODE_STREAM = 3;
/*      */   protected static final int VALUE_NULL = 1;
/*      */   protected static final int VALUE_NOT_NULL = 2;
/*      */   protected static final int VALUE_UNKNOWN = 3;
/*      */   protected static final int VALUE_IN_RSET = 4;
/*      */   OracleResultSet resultSet;
/*   64 */   boolean isRowDeleted = false;
/*      */ 
/* 3914 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   GeneratedUpdatableResultSet(OracleStatement paramOracleStatement, OracleResultSet paramOracleResultSet)
/*      */     throws SQLException
/*      */   {
/*   68 */     super(paramOracleStatement.connection);
/*      */ 
/*   70 */     this.resultSet = paramOracleResultSet;
/*      */   }
/*      */ 
/*      */   abstract void ensureOpen()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void setIsNull(int paramInt);
/*      */ 
/*      */   abstract void setIsNull(boolean paramBoolean);
/*      */ 
/*      */   abstract boolean isOnInsertRow();
/*      */ 
/*      */   abstract boolean isUpdatingRow()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract boolean isRowBufferUpdatedAt(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract Object getRowBufferAt(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract Datum getRowBufferDatumAt(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void setRowBufferAt(int paramInt, Datum paramDatum)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void setRowBufferAt(int paramInt, Object paramObject, int[] paramArrayOfInt)
/*      */     throws SQLException;
/*      */ 
/*      */   abstract ResultSetMetaData getInternalMetadata()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract void addToTempLobsToFree(Clob paramClob);
/*      */ 
/*      */   abstract void addToTempLobsToFree(Blob paramBlob);
/*      */ 
/*      */   abstract void cleanTempLobs();
/*      */ 
/*      */   abstract void cleanTempBlobs(ArrayList paramArrayList);
/*      */ 
/*      */   abstract void cleanTempClobs(ArrayList paramArrayList);
/*      */ 
/*      */   public Datum getOracleObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  123 */     synchronized (this.connection)
/*      */     {
/*  131 */       ensureOpen();
/*  132 */       if (this.isRowDeleted) {
/*  133 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  134 */         ((SQLException)localObject1).fillInStackTrace();
/*  135 */         throw ((Throwable)localObject1);
/*      */       }
/*  137 */       Object localObject1 = null;
/*  138 */       setIsNull(3);
/*  139 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  141 */         localObject1 = getRowBufferDatumAt(paramInt);
/*  142 */         setIsNull(localObject1 == null);
/*      */       }
/*      */       else {
/*  145 */         localObject1 = this.resultSet.getOracleObject(paramInt);
/*  146 */         setIsNull(4);
/*      */       }
/*  148 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  156 */     synchronized (this.connection)
/*      */     {
/*  163 */       ensureOpen();
/*  164 */       if (this.isRowDeleted) {
/*  165 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  166 */         ((SQLException)localObject1).fillInStackTrace();
/*  167 */         throw ((Throwable)localObject1);
/*      */       }
/*  169 */       Object localObject1 = null;
/*      */ 
/*  171 */       setIsNull(3);
/*      */ 
/*  173 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  176 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  178 */         setIsNull(localDatum == null);
/*      */ 
/*  180 */         if (localDatum != null)
/*  181 */           localObject1 = localDatum.stringValue(this.connection);
/*      */       }
/*      */       else
/*      */       {
/*  185 */         setIsNull(4);
/*      */ 
/*  187 */         localObject1 = this.resultSet.getString(paramInt);
/*      */       }
/*      */ 
/*  190 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  197 */     synchronized (this.connection)
/*      */     {
/*  204 */       ensureOpen();
/*  205 */       if (this.isRowDeleted) {
/*  206 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  207 */         localSQLException.fillInStackTrace();
/*  208 */         throw localSQLException;
/*      */       }
/*  210 */       boolean bool = false;
/*      */ 
/*  212 */       setIsNull(3);
/*      */ 
/*  214 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  217 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  219 */         setIsNull(localDatum == null);
/*      */ 
/*  221 */         if (localDatum != null)
/*  222 */           bool = localDatum.booleanValue();
/*      */       }
/*      */       else
/*      */       {
/*  226 */         setIsNull(4);
/*      */ 
/*  228 */         bool = this.resultSet.getBoolean(paramInt);
/*      */       }
/*      */ 
/*  231 */       return bool;
/*      */     }
/*      */   }
/*      */ 
/*      */   public byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  238 */     synchronized (this.connection)
/*      */     {
/*  245 */       ensureOpen();
/*  246 */       if (this.isRowDeleted) {
/*  247 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  248 */         localSQLException.fillInStackTrace();
/*  249 */         throw localSQLException;
/*      */       }
/*  251 */       byte b = 0;
/*      */ 
/*  253 */       setIsNull(3);
/*      */ 
/*  255 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  258 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  260 */         setIsNull(localDatum == null);
/*      */ 
/*  262 */         if (localDatum != null)
/*  263 */           b = localDatum.byteValue();
/*      */       }
/*      */       else
/*      */       {
/*  267 */         setIsNull(4);
/*      */ 
/*  269 */         b = this.resultSet.getByte(paramInt);
/*      */       }
/*      */ 
/*  272 */       return b;
/*      */     }
/*      */   }
/*      */ 
/*      */   public short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  279 */     synchronized (this.connection)
/*      */     {
/*  286 */       ensureOpen();
/*  287 */       if (this.isRowDeleted) {
/*  288 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  289 */         localSQLException1.fillInStackTrace();
/*  290 */         throw localSQLException1;
/*      */       }
/*  292 */       short s = 0;
/*      */ 
/*  294 */       setIsNull(3);
/*      */ 
/*  296 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  299 */         long l = getLong(paramInt);
/*      */ 
/*  301 */         if ((l > 65537L) || (l < -65538L))
/*      */         {
/*  303 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26, "getShort");
/*  304 */           localSQLException2.fillInStackTrace();
/*  305 */           throw localSQLException2;
/*      */         }
/*      */ 
/*  308 */         s = (short)(int)l;
/*      */       }
/*      */       else
/*      */       {
/*  312 */         setIsNull(4);
/*      */ 
/*  314 */         s = this.resultSet.getShort(paramInt);
/*      */       }
/*      */ 
/*  317 */       return s;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  324 */     synchronized (this.connection)
/*      */     {
/*  331 */       ensureOpen();
/*  332 */       if (this.isRowDeleted) {
/*  333 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  334 */         localSQLException.fillInStackTrace();
/*  335 */         throw localSQLException;
/*      */       }
/*  337 */       int i = 0;
/*      */ 
/*  339 */       setIsNull(3);
/*      */ 
/*  341 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  344 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  346 */         setIsNull(localDatum == null);
/*      */ 
/*  348 */         if (localDatum != null)
/*  349 */           i = localDatum.intValue();
/*      */       }
/*      */       else
/*      */       {
/*  353 */         setIsNull(4);
/*      */ 
/*  355 */         i = this.resultSet.getInt(paramInt);
/*      */       }
/*      */ 
/*  358 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  365 */     synchronized (this.connection)
/*      */     {
/*  372 */       ensureOpen();
/*  373 */       if (this.isRowDeleted) {
/*  374 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  375 */         localSQLException.fillInStackTrace();
/*  376 */         throw localSQLException;
/*      */       }
/*  378 */       long l = 0L;
/*      */ 
/*  380 */       setIsNull(3);
/*      */ 
/*  382 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  385 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  387 */         setIsNull(localDatum == null);
/*      */ 
/*  389 */         if (localDatum != null)
/*  390 */           l = localDatum.longValue();
/*      */       }
/*      */       else
/*      */       {
/*  394 */         setIsNull(4);
/*      */ 
/*  396 */         l = this.resultSet.getLong(paramInt);
/*      */       }
/*      */ 
/*  399 */       return l;
/*      */     }
/*      */   }
/*      */ 
/*      */   public float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  406 */     synchronized (this.connection)
/*      */     {
/*  413 */       ensureOpen();
/*  414 */       if (this.isRowDeleted) {
/*  415 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  416 */         localSQLException.fillInStackTrace();
/*  417 */         throw localSQLException;
/*      */       }
/*  419 */       float f = 0.0F;
/*      */ 
/*  421 */       setIsNull(3);
/*      */ 
/*  423 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  426 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  428 */         setIsNull(localDatum == null);
/*      */ 
/*  430 */         if (localDatum != null)
/*  431 */           f = localDatum.floatValue();
/*      */       }
/*      */       else
/*      */       {
/*  435 */         setIsNull(4);
/*      */ 
/*  437 */         f = this.resultSet.getFloat(paramInt);
/*      */       }
/*      */ 
/*  440 */       return f;
/*      */     }
/*      */   }
/*      */ 
/*      */   public double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  447 */     synchronized (this.connection)
/*      */     {
/*  454 */       ensureOpen();
/*  455 */       if (this.isRowDeleted) {
/*  456 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  457 */         localSQLException.fillInStackTrace();
/*  458 */         throw localSQLException;
/*      */       }
/*  460 */       double d = 0.0D;
/*      */ 
/*  462 */       setIsNull(3);
/*      */ 
/*  464 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  467 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  469 */         setIsNull(localDatum == null);
/*      */ 
/*  471 */         if (localDatum != null)
/*  472 */           d = localDatum.doubleValue();
/*      */       }
/*      */       else
/*      */       {
/*  476 */         setIsNull(4);
/*      */ 
/*  478 */         d = this.resultSet.getDouble(paramInt);
/*      */       }
/*      */ 
/*  481 */       return d;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  489 */     synchronized (this.connection)
/*      */     {
/*  496 */       ensureOpen();
/*  497 */       if (this.isRowDeleted) {
/*  498 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  499 */         ((SQLException)localObject1).fillInStackTrace();
/*  500 */         throw ((Throwable)localObject1);
/*      */       }
/*  502 */       Object localObject1 = null;
/*      */ 
/*  504 */       setIsNull(3);
/*      */ 
/*  506 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt1))))
/*      */       {
/*  509 */         Datum localDatum = getRowBufferDatumAt(paramInt1);
/*      */ 
/*  511 */         setIsNull(localDatum == null);
/*      */ 
/*  513 */         if (localDatum != null)
/*  514 */           localObject1 = localDatum.bigDecimalValue();
/*      */       }
/*      */       else
/*      */       {
/*  518 */         setIsNull(4);
/*      */ 
/*  520 */         localObject1 = this.resultSet.getBigDecimal(paramInt1);
/*      */       }
/*      */ 
/*  523 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  530 */     synchronized (this.connection)
/*      */     {
/*  537 */       ensureOpen();
/*  538 */       if (this.isRowDeleted) {
/*  539 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  540 */         ((SQLException)localObject1).fillInStackTrace();
/*  541 */         throw ((Throwable)localObject1);
/*      */       }
/*  543 */       Object localObject1 = null;
/*      */ 
/*  545 */       setIsNull(3);
/*      */ 
/*  547 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  550 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  552 */         setIsNull(localDatum == null);
/*      */ 
/*  554 */         if (localDatum != null)
/*  555 */           localObject1 = localDatum.getBytes();
/*      */       }
/*      */       else
/*      */       {
/*  559 */         setIsNull(4);
/*      */ 
/*  561 */         localObject1 = this.resultSet.getBytes(paramInt);
/*      */       }
/*      */ 
/*  564 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  571 */     synchronized (this.connection)
/*      */     {
/*  578 */       ensureOpen();
/*  579 */       if (this.isRowDeleted) {
/*  580 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  581 */         ((SQLException)localObject1).fillInStackTrace();
/*  582 */         throw ((Throwable)localObject1);
/*      */       }
/*  584 */       Object localObject1 = null;
/*      */ 
/*  586 */       setIsNull(3);
/*      */ 
/*  588 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  591 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  593 */         setIsNull(localDatum == null);
/*      */ 
/*  595 */         if (localDatum != null)
/*  596 */           localObject1 = localDatum.dateValue();
/*      */       }
/*      */       else
/*      */       {
/*  600 */         setIsNull(4);
/*      */ 
/*  602 */         localObject1 = this.resultSet.getDate(paramInt);
/*      */       }
/*      */ 
/*  605 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  612 */     synchronized (this.connection)
/*      */     {
/*  619 */       ensureOpen();
/*  620 */       if (this.isRowDeleted) {
/*  621 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  622 */         ((SQLException)localObject1).fillInStackTrace();
/*  623 */         throw ((Throwable)localObject1);
/*      */       }
/*  625 */       Object localObject1 = null;
/*      */ 
/*  627 */       setIsNull(3);
/*      */ 
/*  629 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  632 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  634 */         setIsNull(localDatum == null);
/*      */ 
/*  636 */         if (localDatum != null)
/*  637 */           localObject1 = localDatum.timeValue();
/*      */       }
/*      */       else
/*      */       {
/*  641 */         setIsNull(4);
/*      */ 
/*  643 */         localObject1 = this.resultSet.getTime(paramInt);
/*      */       }
/*      */ 
/*  646 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  654 */     synchronized (this.connection)
/*      */     {
/*  661 */       ensureOpen();
/*  662 */       if (this.isRowDeleted) {
/*  663 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  664 */         ((SQLException)localObject1).fillInStackTrace();
/*  665 */         throw ((Throwable)localObject1);
/*      */       }
/*  667 */       Object localObject1 = null;
/*      */ 
/*  669 */       setIsNull(3);
/*      */ 
/*  671 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  674 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  676 */         setIsNull(localDatum == null);
/*      */ 
/*  678 */         if (localDatum != null)
/*  679 */           localObject1 = localDatum.timestampValue();
/*      */       }
/*      */       else
/*      */       {
/*  683 */         setIsNull(4);
/*      */ 
/*  685 */         localObject1 = this.resultSet.getTimestamp(paramInt);
/*      */       }
/*      */ 
/*  688 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  696 */     synchronized (this.connection)
/*      */     {
/*  703 */       ensureOpen();
/*  704 */       if (this.isRowDeleted) {
/*  705 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  706 */         ((SQLException)localObject1).fillInStackTrace();
/*  707 */         throw ((Throwable)localObject1);
/*      */       }
/*  709 */       Object localObject1 = null;
/*      */ 
/*  711 */       setIsNull(3);
/*      */ 
/*  713 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  716 */         Object localObject2 = getRowBufferAt(paramInt);
/*      */ 
/*  718 */         setIsNull(localObject2 == null);
/*      */ 
/*  720 */         if (localObject2 != null)
/*      */         {
/*  722 */           if ((localObject2 instanceof InputStream))
/*      */           {
/*  724 */             localObject1 = (InputStream)localObject2;
/*      */           }
/*      */           else
/*      */           {
/*  728 */             Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  730 */             localObject1 = localDatum.asciiStreamValue();
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  736 */         setIsNull(4);
/*      */ 
/*  738 */         localObject1 = this.resultSet.getAsciiStream(paramInt);
/*      */       }
/*      */ 
/*  741 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  749 */     synchronized (this.connection)
/*      */     {
/*  756 */       ensureOpen();
/*  757 */       if (this.isRowDeleted) {
/*  758 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  759 */         ((SQLException)localObject1).fillInStackTrace();
/*  760 */         throw ((Throwable)localObject1);
/*      */       }
/*  762 */       Object localObject1 = null;
/*      */ 
/*  764 */       setIsNull(3);
/*      */ 
/*  766 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  769 */         Object localObject2 = getRowBufferAt(paramInt);
/*      */ 
/*  771 */         setIsNull(localObject2 == null);
/*      */ 
/*  773 */         if (localObject2 != null)
/*      */         {
/*  775 */           if ((localObject2 instanceof InputStream))
/*      */           {
/*  777 */             localObject1 = (InputStream)localObject2;
/*      */           }
/*      */           else
/*      */           {
/*  781 */             Datum localDatum = getRowBufferDatumAt(paramInt);
/*  782 */             DBConversion localDBConversion = this.connection.conversion;
/*  783 */             byte[] arrayOfByte = localDatum.shareBytes();
/*      */ 
/*  785 */             if ((localDatum instanceof RAW))
/*      */             {
/*  787 */               localObject1 = localDBConversion.ConvertStream(new ByteArrayInputStream(arrayOfByte), 3);
/*      */             }
/*  790 */             else if ((localDatum instanceof CHAR))
/*      */             {
/*  792 */               localObject1 = localDBConversion.ConvertStream(new ByteArrayInputStream(arrayOfByte), 1);
/*      */             }
/*      */             else
/*      */             {
/*  797 */               SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
/*  798 */               localSQLException.fillInStackTrace();
/*  799 */               throw localSQLException;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  806 */         setIsNull(4);
/*      */ 
/*  808 */         localObject1 = this.resultSet.getUnicodeStream(paramInt);
/*      */       }
/*      */ 
/*  811 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  819 */     synchronized (this.connection)
/*      */     {
/*  826 */       ensureOpen();
/*  827 */       if (this.isRowDeleted) {
/*  828 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  829 */         ((SQLException)localObject1).fillInStackTrace();
/*  830 */         throw ((Throwable)localObject1);
/*      */       }
/*  832 */       Object localObject1 = null;
/*      */ 
/*  834 */       setIsNull(3);
/*      */ 
/*  836 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  839 */         Object localObject2 = getRowBufferAt(paramInt);
/*      */ 
/*  841 */         setIsNull(localObject2 == null);
/*      */ 
/*  843 */         if (localObject2 != null)
/*      */         {
/*  845 */           if ((localObject2 instanceof InputStream))
/*      */           {
/*  847 */             localObject1 = (InputStream)localObject2;
/*      */           }
/*      */           else
/*      */           {
/*  851 */             Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  853 */             localObject1 = localDatum.binaryStreamValue();
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  859 */         setIsNull(4);
/*      */ 
/*  861 */         localObject1 = this.resultSet.getBinaryStream(paramInt);
/*      */       }
/*      */ 
/*  864 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  871 */     synchronized (this.connection)
/*      */     {
/*  878 */       ensureOpen();
/*  879 */       if (this.isRowDeleted) {
/*  880 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  881 */         ((SQLException)localObject1).fillInStackTrace();
/*  882 */         throw ((Throwable)localObject1);
/*      */       }
/*  884 */       Object localObject1 = null;
/*      */ 
/*  886 */       setIsNull(3);
/*      */ 
/*  888 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  891 */         Datum localDatum = getOracleObject(paramInt);
/*      */ 
/*  893 */         setIsNull(localDatum == null);
/*      */ 
/*  895 */         if (localDatum != null)
/*  896 */           localObject1 = localDatum.toJdbc();
/*      */       }
/*      */       else
/*      */       {
/*  900 */         setIsNull(4);
/*      */ 
/*  902 */         localObject1 = this.resultSet.getObject(paramInt);
/*      */       }
/*      */ 
/*  905 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/*  913 */     synchronized (this.connection)
/*      */     {
/*  921 */       ensureOpen();
/*  922 */       if (this.isRowDeleted) {
/*  923 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  924 */         ((SQLException)localObject1).fillInStackTrace();
/*  925 */         throw ((Throwable)localObject1);
/*      */       }
/*  927 */       if (paramOracleDataFactory == null) {
/*  928 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  929 */         ((SQLException)localObject1).fillInStackTrace();
/*  930 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/*  933 */       Object localObject1 = null;
/*  934 */       setIsNull(3);
/*  935 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  937 */         Object localObject2 = getObject(paramInt);
/*  938 */         setIsNull(localObject2 == null);
/*  939 */         localObject1 = paramOracleDataFactory.create(localObject2, 0);
/*      */       }
/*      */       else {
/*  942 */         setIsNull(4);
/*  943 */         localObject1 = this.resultSet.getObject(paramInt, paramOracleDataFactory);
/*      */       }
/*      */ 
/*  946 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  957 */     synchronized (this.connection)
/*      */     {
/*  964 */       ensureOpen();
/*  965 */       if (this.isRowDeleted) {
/*  966 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/*  967 */         ((SQLException)localObject1).fillInStackTrace();
/*  968 */         throw ((Throwable)localObject1);
/*      */       }
/*  970 */       Object localObject1 = null;
/*      */ 
/*  972 */       setIsNull(3);
/*      */ 
/*  974 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/*  977 */         Object localObject2 = getRowBufferAt(paramInt);
/*      */ 
/*  979 */         setIsNull(localObject2 == null);
/*      */ 
/*  981 */         if (localObject2 != null)
/*      */         {
/*  983 */           if ((localObject2 instanceof Reader))
/*      */           {
/*  985 */             localObject1 = (Reader)localObject2;
/*      */           }
/*      */           else
/*      */           {
/*  989 */             Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/*  991 */             localObject1 = localDatum.characterStreamValue();
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  997 */         setIsNull(4);
/*      */ 
/*  999 */         localObject1 = this.resultSet.getCharacterStream(paramInt);
/*      */       }
/*      */ 
/* 1002 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1011 */     synchronized (this.connection)
/*      */     {
/* 1018 */       ensureOpen();
/* 1019 */       if (this.isRowDeleted) {
/* 1020 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1021 */         ((SQLException)localObject1).fillInStackTrace();
/* 1022 */         throw ((Throwable)localObject1);
/*      */       }
/* 1024 */       Object localObject1 = null;
/*      */ 
/* 1026 */       setIsNull(3);
/*      */ 
/* 1028 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1031 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1033 */         setIsNull(localDatum == null);
/*      */ 
/* 1035 */         if (localDatum != null)
/* 1036 */           localObject1 = localDatum.bigDecimalValue();
/*      */       }
/*      */       else
/*      */       {
/* 1040 */         setIsNull(4);
/*      */ 
/* 1042 */         localObject1 = this.resultSet.getBigDecimal(paramInt);
/*      */       }
/*      */ 
/* 1045 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1054 */     synchronized (this.connection)
/*      */     {
/* 1061 */       ensureOpen();
/* 1062 */       if (this.isRowDeleted) {
/* 1063 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1064 */         ((SQLException)localObject1).fillInStackTrace();
/* 1065 */         throw ((Throwable)localObject1);
/*      */       }
/* 1067 */       Object localObject1 = null;
/*      */ 
/* 1069 */       setIsNull(3);
/*      */ 
/* 1071 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1074 */         Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1076 */         setIsNull(localDatum == null);
/*      */ 
/* 1078 */         if (localDatum != null)
/*      */         {
/* 1080 */           if ((localDatum instanceof STRUCT))
/* 1081 */             localObject1 = ((STRUCT)localDatum).toJdbc(paramMap);
/*      */           else
/* 1083 */             localObject1 = localDatum.toJdbc();
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1088 */         setIsNull(4);
/*      */ 
/* 1090 */         localObject1 = this.resultSet.getObject(paramInt, paramMap);
/*      */       }
/*      */ 
/* 1093 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Ref getRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1101 */     synchronized (this.connection)
/*      */     {
/* 1108 */       ensureOpen();
/* 1109 */       if (this.isRowDeleted) {
/* 1110 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1111 */         localSQLException.fillInStackTrace();
/* 1112 */         throw localSQLException;
/*      */       }
/* 1114 */       return getREF(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1122 */     synchronized (this.connection)
/*      */     {
/* 1129 */       ensureOpen();
/* 1130 */       if (this.isRowDeleted) {
/* 1131 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1132 */         localSQLException.fillInStackTrace();
/* 1133 */         throw localSQLException;
/*      */       }
/* 1135 */       return getBLOB(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Clob getClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1143 */     synchronized (this.connection)
/*      */     {
/* 1150 */       ensureOpen();
/* 1151 */       if (this.isRowDeleted) {
/* 1152 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1153 */         localSQLException.fillInStackTrace();
/* 1154 */         throw localSQLException;
/*      */       }
/* 1156 */       return getCLOB(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Array getArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1165 */     synchronized (this.connection)
/*      */     {
/* 1172 */       ensureOpen();
/* 1173 */       if (this.isRowDeleted) {
/* 1174 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1175 */         localSQLException.fillInStackTrace();
/* 1176 */         throw localSQLException;
/*      */       }
/* 1178 */       return getARRAY(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1187 */     synchronized (this.connection)
/*      */     {
/* 1194 */       ensureOpen();
/* 1195 */       if (this.isRowDeleted) {
/* 1196 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1197 */         ((SQLException)localObject1).fillInStackTrace();
/* 1198 */         throw ((Throwable)localObject1);
/*      */       }
/* 1200 */       Object localObject1 = null;
/*      */ 
/* 1202 */       setIsNull(3);
/*      */ 
/* 1204 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1207 */         Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1209 */         setIsNull(localDatum == null);
/*      */ 
/* 1211 */         if (localDatum != null)
/*      */         {
/* 1213 */           if ((localDatum instanceof DATE)) {
/* 1214 */             localObject1 = ((DATE)localDatum).dateValue(paramCalendar);
/*      */           }
/*      */           else
/*      */           {
/*      */             Object localObject2;
/* 1215 */             if ((localDatum instanceof TIMESTAMP))
/*      */             {
/* 1217 */               localObject2 = ((TIMESTAMP)localDatum).timestampValue(paramCalendar);
/* 1218 */               long l = ((Timestamp)localObject2).getTime();
/* 1219 */               localObject1 = new Date(l);
/*      */             }
/*      */             else
/*      */             {
/* 1225 */               localObject2 = new DATE(localDatum.stringValue(this.connection));
/*      */ 
/* 1227 */               if (localObject2 != null)
/* 1228 */                 localObject1 = ((DATE)localObject2).dateValue(paramCalendar);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       else {
/* 1234 */         setIsNull(4);
/*      */ 
/* 1236 */         localObject1 = this.resultSet.getDate(paramInt, paramCalendar);
/*      */       }
/*      */ 
/* 1239 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1248 */     synchronized (this.connection)
/*      */     {
/* 1255 */       ensureOpen();
/* 1256 */       if (this.isRowDeleted) {
/* 1257 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1258 */         ((SQLException)localObject1).fillInStackTrace();
/* 1259 */         throw ((Throwable)localObject1);
/*      */       }
/* 1261 */       Object localObject1 = null;
/*      */ 
/* 1263 */       setIsNull(3);
/*      */ 
/* 1265 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1268 */         Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1270 */         setIsNull(localDatum == null);
/*      */ 
/* 1272 */         if (localDatum != null)
/*      */         {
/* 1274 */           if ((localDatum instanceof DATE)) {
/* 1275 */             localObject1 = ((DATE)localDatum).timeValue(paramCalendar);
/*      */           }
/*      */           else
/*      */           {
/*      */             Object localObject2;
/* 1276 */             if ((localDatum instanceof TIMESTAMP))
/*      */             {
/* 1278 */               localObject2 = ((TIMESTAMP)localDatum).timestampValue(paramCalendar);
/* 1279 */               long l = ((Timestamp)localObject2).getTime();
/* 1280 */               localObject1 = new Time(l);
/*      */             }
/*      */             else
/*      */             {
/* 1285 */               localObject2 = new DATE(localDatum.stringValue(this.connection));
/*      */ 
/* 1287 */               if (localObject2 != null)
/* 1288 */                 localObject1 = ((DATE)localObject2).timeValue(paramCalendar);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       else {
/* 1294 */         setIsNull(4);
/*      */ 
/* 1296 */         localObject1 = this.resultSet.getTime(paramInt, paramCalendar);
/*      */       }
/*      */ 
/* 1299 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1308 */     synchronized (this.connection)
/*      */     {
/* 1315 */       ensureOpen();
/* 1316 */       if (this.isRowDeleted) {
/* 1317 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1318 */         ((SQLException)localObject1).fillInStackTrace();
/* 1319 */         throw ((Throwable)localObject1);
/*      */       }
/* 1321 */       Object localObject1 = null;
/*      */ 
/* 1323 */       setIsNull(3);
/*      */ 
/* 1325 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1328 */         Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1330 */         setIsNull(localDatum == null);
/*      */ 
/* 1332 */         if (localDatum != null)
/*      */         {
/* 1334 */           if ((localDatum instanceof DATE)) {
/* 1335 */             localObject1 = ((DATE)localDatum).timestampValue(paramCalendar);
/* 1336 */           } else if ((localDatum instanceof TIMESTAMP)) {
/* 1337 */             localObject1 = ((TIMESTAMP)localDatum).timestampValue(paramCalendar);
/*      */           }
/*      */           else {
/* 1340 */             DATE localDATE = new DATE(localDatum.stringValue(this.connection));
/*      */ 
/* 1342 */             if (localDATE != null)
/* 1343 */               localObject1 = localDATE.timestampValue(paramCalendar);
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1349 */         setIsNull(4);
/*      */ 
/* 1351 */         localObject1 = this.resultSet.getTimestamp(paramInt, paramCalendar);
/*      */       }
/*      */ 
/* 1354 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public URL getURL(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1362 */     synchronized (this.connection)
/*      */     {
/* 1369 */       ensureOpen();
/* 1370 */       if (this.isRowDeleted) {
/* 1371 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1372 */         ((SQLException)localObject1).fillInStackTrace();
/* 1373 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/* 1376 */       Object localObject1 = null;
/*      */ 
/* 1378 */       int i = getInternalMetadata().getColumnType(paramInt);
/* 1379 */       int j = SQLUtil.getInternalType(i);
/*      */ 
/* 1382 */       if ((j == 96) || (j == 1) || (j == 8))
/*      */       {
/*      */         try
/*      */         {
/* 1387 */           String str = getString(paramInt);
/* 1388 */           if (str == null) localObject1 = null; else {
/* 1389 */             localObject1 = new URL(str);
/*      */           }
/*      */         }
/*      */         catch (MalformedURLException localMalformedURLException)
/*      */         {
/* 1394 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 136);
/* 1395 */           localSQLException2.fillInStackTrace();
/* 1396 */           throw localSQLException2;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1403 */         SQLException localSQLException1 = DatabaseError.createUnsupportedFeatureSqlException();
/* 1404 */         localSQLException1.fillInStackTrace();
/* 1405 */         throw localSQLException1;
/*      */       }
/*      */ 
/* 1409 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getCursor(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1417 */     synchronized (this.connection)
/*      */     {
/* 1424 */       ensureOpen();
/* 1425 */       if (this.isRowDeleted) {
/* 1426 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1427 */         ((SQLException)localObject1).fillInStackTrace();
/* 1428 */         throw ((Throwable)localObject1);
/*      */       }
/* 1430 */       Object localObject1 = null;
/*      */ 
/* 1432 */       setIsNull(3);
/*      */ 
/* 1434 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1437 */         Datum localDatum = getOracleObject(paramInt);
/*      */ 
/* 1439 */         setIsNull(localDatum == null);
/*      */ 
/* 1441 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCursor");
/* 1442 */         localSQLException.fillInStackTrace();
/* 1443 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1448 */       setIsNull(4);
/*      */ 
/* 1450 */       localObject1 = this.resultSet.getCursor(paramInt);
/*      */ 
/* 1453 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ROWID getROWID(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1461 */     synchronized (this.connection)
/*      */     {
/* 1468 */       ensureOpen();
/* 1469 */       if (this.isRowDeleted) {
/* 1470 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1471 */         ((SQLException)localObject1).fillInStackTrace();
/* 1472 */         throw ((Throwable)localObject1);
/*      */       }
/* 1474 */       Object localObject1 = null;
/*      */ 
/* 1476 */       setIsNull(3);
/*      */ 
/* 1478 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1481 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1483 */         setIsNull(localDatum == null);
/*      */ 
/* 1485 */         if ((localDatum != null) && (!(localDatum instanceof ROWID)))
/*      */         {
/* 1487 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getROWID");
/* 1488 */           localSQLException.fillInStackTrace();
/* 1489 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1492 */         localObject1 = (ROWID)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1496 */         setIsNull(4);
/*      */ 
/* 1498 */         localObject1 = this.resultSet.getROWID(paramInt);
/*      */       }
/*      */ 
/* 1501 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public NUMBER getNUMBER(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1509 */     synchronized (this.connection)
/*      */     {
/* 1516 */       ensureOpen();
/* 1517 */       if (this.isRowDeleted) {
/* 1518 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1519 */         ((SQLException)localObject1).fillInStackTrace();
/* 1520 */         throw ((Throwable)localObject1);
/*      */       }
/* 1522 */       Object localObject1 = null;
/*      */ 
/* 1524 */       setIsNull(3);
/*      */ 
/* 1526 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1529 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1531 */         setIsNull(localDatum == null);
/*      */ 
/* 1533 */         if ((localDatum != null) && (!(localDatum instanceof NUMBER)))
/*      */         {
/* 1535 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getNUMBER");
/* 1536 */           localSQLException.fillInStackTrace();
/* 1537 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1540 */         localObject1 = (NUMBER)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1544 */         setIsNull(4);
/*      */ 
/* 1546 */         localObject1 = this.resultSet.getNUMBER(paramInt);
/*      */       }
/*      */ 
/* 1549 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public DATE getDATE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1557 */     synchronized (this.connection)
/*      */     {
/* 1564 */       ensureOpen();
/* 1565 */       if (this.isRowDeleted) {
/* 1566 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1567 */         ((SQLException)localObject1).fillInStackTrace();
/* 1568 */         throw ((Throwable)localObject1);
/*      */       }
/* 1570 */       Object localObject1 = null;
/*      */ 
/* 1572 */       setIsNull(3);
/*      */ 
/* 1574 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1577 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1579 */         if (localDatum != null)
/*      */         {
/* 1581 */           if ((localDatum instanceof DATE)) { localObject1 = (DATE)localDatum; }
/*      */           else
/*      */           {
/*      */             Object localObject2;
/* 1582 */             if ((localDatum instanceof TIMESTAMP))
/*      */             {
/* 1584 */               localObject2 = ((TIMESTAMP)localDatum).timestampValue();
/* 1585 */               localObject1 = new DATE((Timestamp)localObject2);
/*      */             }
/*      */             else
/*      */             {
/* 1590 */               localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getDATE");
/* 1591 */               ((SQLException)localObject2).fillInStackTrace();
/* 1592 */               throw ((Throwable)localObject2);
/*      */             }
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1598 */           setIsNull(localDatum == null);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1604 */         setIsNull(4);
/*      */ 
/* 1606 */         localObject1 = this.resultSet.getDATE(paramInt);
/*      */       }
/*      */ 
/* 1609 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMP getTIMESTAMP(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1617 */     synchronized (this.connection)
/*      */     {
/* 1624 */       ensureOpen();
/* 1625 */       if (this.isRowDeleted) {
/* 1626 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1627 */         ((SQLException)localObject1).fillInStackTrace();
/* 1628 */         throw ((Throwable)localObject1);
/*      */       }
/* 1630 */       Object localObject1 = null;
/*      */ 
/* 1632 */       setIsNull(3);
/*      */ 
/* 1634 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1637 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1639 */         setIsNull(localDatum == null);
/*      */ 
/* 1641 */         if ((localDatum != null) && (!(localDatum instanceof TIMESTAMP)))
/*      */         {
/* 1643 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
/* 1644 */           localSQLException.fillInStackTrace();
/* 1645 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1648 */         localObject1 = (TIMESTAMP)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1652 */         setIsNull(4);
/*      */ 
/* 1654 */         localObject1 = this.resultSet.getTIMESTAMP(paramInt);
/*      */       }
/*      */ 
/* 1657 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1665 */     synchronized (this.connection)
/*      */     {
/* 1672 */       ensureOpen();
/* 1673 */       if (this.isRowDeleted) {
/* 1674 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1675 */         ((SQLException)localObject1).fillInStackTrace();
/* 1676 */         throw ((Throwable)localObject1);
/*      */       }
/* 1678 */       Object localObject1 = null;
/*      */ 
/* 1680 */       setIsNull(3);
/*      */ 
/* 1682 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1685 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1687 */         setIsNull(localDatum == null);
/*      */ 
/* 1689 */         if ((localDatum != null) && (!(localDatum instanceof TIMESTAMPTZ)))
/*      */         {
/* 1691 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
/* 1692 */           localSQLException.fillInStackTrace();
/* 1693 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1696 */         localObject1 = (TIMESTAMPTZ)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1700 */         setIsNull(4);
/*      */ 
/* 1702 */         localObject1 = this.resultSet.getTIMESTAMPTZ(paramInt);
/*      */       }
/*      */ 
/* 1705 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1713 */     synchronized (this.connection)
/*      */     {
/* 1720 */       ensureOpen();
/* 1721 */       if (this.isRowDeleted) {
/* 1722 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1723 */         ((SQLException)localObject1).fillInStackTrace();
/* 1724 */         throw ((Throwable)localObject1);
/*      */       }
/* 1726 */       Object localObject1 = null;
/*      */ 
/* 1728 */       setIsNull(3);
/*      */ 
/* 1730 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1733 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1735 */         setIsNull(localDatum == null);
/*      */ 
/* 1737 */         if ((localDatum != null) && (!(localDatum instanceof TIMESTAMPLTZ)))
/*      */         {
/* 1739 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
/* 1740 */           localSQLException.fillInStackTrace();
/* 1741 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1744 */         localObject1 = (TIMESTAMPLTZ)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1748 */         setIsNull(4);
/*      */ 
/* 1750 */         localObject1 = this.resultSet.getTIMESTAMPLTZ(paramInt);
/*      */       }
/*      */ 
/* 1753 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public INTERVALDS getINTERVALDS(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1761 */     synchronized (this.connection)
/*      */     {
/* 1768 */       ensureOpen();
/* 1769 */       if (this.isRowDeleted) {
/* 1770 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1771 */         ((SQLException)localObject1).fillInStackTrace();
/* 1772 */         throw ((Throwable)localObject1);
/*      */       }
/* 1774 */       Object localObject1 = null;
/*      */ 
/* 1776 */       setIsNull(3);
/*      */ 
/* 1778 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1781 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1783 */         setIsNull(localDatum == null);
/*      */ 
/* 1785 */         if ((localDatum != null) && (!(localDatum instanceof INTERVALDS)))
/*      */         {
/* 1787 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
/* 1788 */           localSQLException.fillInStackTrace();
/* 1789 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1792 */         localObject1 = (INTERVALDS)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1796 */         setIsNull(4);
/*      */ 
/* 1798 */         localObject1 = this.resultSet.getINTERVALDS(paramInt);
/*      */       }
/*      */ 
/* 1801 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public INTERVALYM getINTERVALYM(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1809 */     synchronized (this.connection)
/*      */     {
/* 1816 */       ensureOpen();
/* 1817 */       if (this.isRowDeleted) {
/* 1818 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1819 */         ((SQLException)localObject1).fillInStackTrace();
/* 1820 */         throw ((Throwable)localObject1);
/*      */       }
/* 1822 */       Object localObject1 = null;
/*      */ 
/* 1824 */       setIsNull(3);
/*      */ 
/* 1826 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1829 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1831 */         setIsNull(localDatum == null);
/*      */ 
/* 1833 */         if ((localDatum != null) && (!(localDatum instanceof INTERVALYM)))
/*      */         {
/* 1835 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
/* 1836 */           localSQLException.fillInStackTrace();
/* 1837 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1840 */         localObject1 = (INTERVALYM)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1844 */         setIsNull(4);
/*      */ 
/* 1846 */         localObject1 = this.resultSet.getINTERVALYM(paramInt);
/*      */       }
/*      */ 
/* 1849 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ARRAY getARRAY(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1857 */     synchronized (this.connection)
/*      */     {
/* 1864 */       ensureOpen();
/* 1865 */       if (this.isRowDeleted) {
/* 1866 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1867 */         ((SQLException)localObject1).fillInStackTrace();
/* 1868 */         throw ((Throwable)localObject1);
/*      */       }
/* 1870 */       Object localObject1 = null;
/*      */ 
/* 1872 */       setIsNull(3);
/*      */ 
/* 1874 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1877 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1879 */         setIsNull(localDatum == null);
/*      */ 
/* 1881 */         if ((localDatum != null) && (!(localDatum instanceof ARRAY)))
/*      */         {
/* 1883 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getARRAY");
/* 1884 */           localSQLException.fillInStackTrace();
/* 1885 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1888 */         localObject1 = (ARRAY)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1892 */         setIsNull(4);
/*      */ 
/* 1894 */         localObject1 = this.resultSet.getARRAY(paramInt);
/*      */       }
/*      */ 
/* 1897 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public STRUCT getSTRUCT(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1905 */     synchronized (this.connection)
/*      */     {
/* 1912 */       ensureOpen();
/* 1913 */       if (this.isRowDeleted) {
/* 1914 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1915 */         ((SQLException)localObject1).fillInStackTrace();
/* 1916 */         throw ((Throwable)localObject1);
/*      */       }
/* 1918 */       Object localObject1 = null;
/*      */ 
/* 1920 */       setIsNull(3);
/*      */ 
/* 1922 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1925 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1927 */         setIsNull(localDatum == null);
/*      */ 
/* 1929 */         if ((localDatum != null) && (!(localDatum instanceof STRUCT)))
/*      */         {
/* 1931 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
/* 1932 */           localSQLException.fillInStackTrace();
/* 1933 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1936 */         localObject1 = (STRUCT)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1940 */         setIsNull(4);
/*      */ 
/* 1942 */         localObject1 = this.resultSet.getSTRUCT(paramInt);
/*      */       }
/*      */ 
/* 1945 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public OPAQUE getOPAQUE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1953 */     synchronized (this.connection)
/*      */     {
/* 1960 */       ensureOpen();
/* 1961 */       if (this.isRowDeleted) {
/* 1962 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 1963 */         ((SQLException)localObject1).fillInStackTrace();
/* 1964 */         throw ((Throwable)localObject1);
/*      */       }
/* 1966 */       Object localObject1 = null;
/*      */ 
/* 1968 */       setIsNull(3);
/*      */ 
/* 1970 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 1973 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 1975 */         setIsNull(localDatum == null);
/*      */ 
/* 1977 */         if ((localDatum != null) && (!(localDatum instanceof OPAQUE)))
/*      */         {
/* 1979 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
/* 1980 */           localSQLException.fillInStackTrace();
/* 1981 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1984 */         localObject1 = (OPAQUE)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 1988 */         setIsNull(4);
/*      */ 
/* 1990 */         localObject1 = this.resultSet.getOPAQUE(paramInt);
/*      */       }
/*      */ 
/* 1993 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public REF getREF(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2001 */     synchronized (this.connection)
/*      */     {
/* 2008 */       ensureOpen();
/* 2009 */       if (this.isRowDeleted) {
/* 2010 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2011 */         ((SQLException)localObject1).fillInStackTrace();
/* 2012 */         throw ((Throwable)localObject1);
/*      */       }
/* 2014 */       Object localObject1 = null;
/*      */ 
/* 2016 */       setIsNull(3);
/*      */ 
/* 2018 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2021 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2023 */         setIsNull(localDatum == null);
/*      */ 
/* 2025 */         if ((localDatum != null) && (!(localDatum instanceof REF)))
/*      */         {
/* 2027 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getREF");
/* 2028 */           localSQLException.fillInStackTrace();
/* 2029 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2032 */         localObject1 = (REF)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2036 */         setIsNull(4);
/*      */ 
/* 2038 */         localObject1 = this.resultSet.getREF(paramInt);
/*      */       }
/*      */ 
/* 2041 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public CHAR getCHAR(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2049 */     synchronized (this.connection)
/*      */     {
/* 2056 */       ensureOpen();
/* 2057 */       if (this.isRowDeleted) {
/* 2058 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2059 */         ((SQLException)localObject1).fillInStackTrace();
/* 2060 */         throw ((Throwable)localObject1);
/*      */       }
/* 2062 */       Object localObject1 = null;
/*      */ 
/* 2064 */       setIsNull(3);
/*      */ 
/* 2066 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2069 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2071 */         setIsNull(localDatum == null);
/*      */ 
/* 2073 */         if ((localDatum != null) && (!(localDatum instanceof CHAR)))
/*      */         {
/* 2075 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCHAR");
/* 2076 */           localSQLException.fillInStackTrace();
/* 2077 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2080 */         localObject1 = (CHAR)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2084 */         setIsNull(4);
/*      */ 
/* 2086 */         localObject1 = this.resultSet.getCHAR(paramInt);
/*      */       }
/*      */ 
/* 2089 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public RAW getRAW(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2097 */     synchronized (this.connection)
/*      */     {
/* 2104 */       ensureOpen();
/* 2105 */       if (this.isRowDeleted) {
/* 2106 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2107 */         ((SQLException)localObject1).fillInStackTrace();
/* 2108 */         throw ((Throwable)localObject1);
/*      */       }
/* 2110 */       Object localObject1 = null;
/*      */ 
/* 2112 */       setIsNull(3);
/*      */ 
/* 2114 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2117 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2119 */         setIsNull(localDatum == null);
/*      */ 
/* 2121 */         if ((localDatum != null) && (!(localDatum instanceof RAW)))
/*      */         {
/* 2123 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getRAW");
/* 2124 */           localSQLException.fillInStackTrace();
/* 2125 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2128 */         localObject1 = (RAW)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2132 */         setIsNull(4);
/*      */ 
/* 2134 */         localObject1 = this.resultSet.getRAW(paramInt);
/*      */       }
/*      */ 
/* 2137 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BLOB getBLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2145 */     synchronized (this.connection)
/*      */     {
/* 2152 */       ensureOpen();
/* 2153 */       if (this.isRowDeleted) {
/* 2154 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2155 */         ((SQLException)localObject1).fillInStackTrace();
/* 2156 */         throw ((Throwable)localObject1);
/*      */       }
/* 2158 */       Object localObject1 = null;
/*      */ 
/* 2160 */       setIsNull(3);
/*      */ 
/* 2162 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2165 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2167 */         setIsNull(localDatum == null);
/*      */ 
/* 2169 */         if ((localDatum != null) && (!(localDatum instanceof BLOB)))
/*      */         {
/* 2171 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBLOB");
/* 2172 */           localSQLException.fillInStackTrace();
/* 2173 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2176 */         localObject1 = (BLOB)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2180 */         setIsNull(4);
/*      */ 
/* 2182 */         localObject1 = this.resultSet.getBLOB(paramInt);
/*      */       }
/*      */ 
/* 2185 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public NCLOB getNCLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2193 */     synchronized (this.connection)
/*      */     {
/* 2200 */       ensureOpen();
/* 2201 */       if (this.isRowDeleted) {
/* 2202 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2203 */         ((SQLException)localObject1).fillInStackTrace();
/* 2204 */         throw ((Throwable)localObject1);
/*      */       }
/* 2206 */       Object localObject1 = null;
/*      */ 
/* 2208 */       setIsNull(3);
/*      */ 
/* 2210 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2213 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2215 */         setIsNull(localDatum == null);
/*      */ 
/* 2217 */         if ((localDatum != null) && (!(localDatum instanceof NCLOB)))
/*      */         {
/* 2219 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCLOB");
/* 2220 */           localSQLException.fillInStackTrace();
/* 2221 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2224 */         localObject1 = (NCLOB)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2228 */         setIsNull(4);
/*      */ 
/* 2230 */         localObject1 = (NCLOB)this.resultSet.getNClob(paramInt);
/*      */       }
/*      */ 
/* 2233 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public CLOB getCLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2241 */     synchronized (this.connection)
/*      */     {
/* 2248 */       ensureOpen();
/* 2249 */       if (this.isRowDeleted) {
/* 2250 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2251 */         ((SQLException)localObject1).fillInStackTrace();
/* 2252 */         throw ((Throwable)localObject1);
/*      */       }
/* 2254 */       Object localObject1 = null;
/*      */ 
/* 2256 */       setIsNull(3);
/*      */ 
/* 2258 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2261 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2263 */         setIsNull(localDatum == null);
/*      */ 
/* 2265 */         if ((localDatum != null) && (!(localDatum instanceof CLOB)))
/*      */         {
/* 2267 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getCLOB");
/* 2268 */           localSQLException.fillInStackTrace();
/* 2269 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2272 */         localObject1 = (CLOB)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2276 */         setIsNull(4);
/*      */ 
/* 2278 */         localObject1 = this.resultSet.getCLOB(paramInt);
/*      */       }
/*      */ 
/* 2281 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BFILE getBFILE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2289 */     synchronized (this.connection)
/*      */     {
/* 2296 */       ensureOpen();
/* 2297 */       if (this.isRowDeleted) {
/* 2298 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2299 */         ((SQLException)localObject1).fillInStackTrace();
/* 2300 */         throw ((Throwable)localObject1);
/*      */       }
/* 2302 */       Object localObject1 = null;
/*      */ 
/* 2304 */       setIsNull(3);
/*      */ 
/* 2306 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2309 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2311 */         setIsNull(localDatum == null);
/*      */ 
/* 2313 */         if ((localDatum != null) && (!(localDatum instanceof BFILE)))
/*      */         {
/* 2315 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getBFILE");
/* 2316 */           localSQLException.fillInStackTrace();
/* 2317 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2320 */         localObject1 = (BFILE)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2324 */         setIsNull(4);
/*      */ 
/* 2326 */         localObject1 = this.resultSet.getBFILE(paramInt);
/*      */       }
/*      */ 
/* 2329 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public BFILE getBfile(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2337 */     synchronized (this.connection)
/*      */     {
/* 2344 */       ensureOpen();
/* 2345 */       if (this.isRowDeleted) {
/* 2346 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2347 */         localSQLException.fillInStackTrace();
/* 2348 */         throw localSQLException;
/*      */       }
/* 2350 */       return getBFILE(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public CustomDatum getCustomDatum(int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */     throws SQLException
/*      */   {
/* 2359 */     synchronized (this.connection)
/*      */     {
/* 2366 */       ensureOpen();
/* 2367 */       if (this.isRowDeleted) {
/* 2368 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2369 */         ((SQLException)localObject1).fillInStackTrace();
/* 2370 */         throw ((Throwable)localObject1);
/*      */       }
/* 2372 */       if (paramCustomDatumFactory == null)
/*      */       {
/* 2374 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2375 */         ((SQLException)localObject1).fillInStackTrace();
/* 2376 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/* 2379 */       Object localObject1 = null;
/*      */ 
/* 2381 */       setIsNull(3);
/*      */ 
/* 2383 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2386 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2388 */         setIsNull(localDatum == null);
/*      */ 
/* 2390 */         localObject1 = paramCustomDatumFactory.create(localDatum, 0);
/*      */       }
/*      */       else
/*      */       {
/* 2394 */         setIsNull(4);
/*      */ 
/* 2396 */         localObject1 = this.resultSet.getCustomDatum(paramInt, paramCustomDatumFactory);
/*      */       }
/*      */ 
/* 2399 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ORAData getORAData(int paramInt, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/* 2408 */     synchronized (this.connection)
/*      */     {
/* 2415 */       ensureOpen();
/* 2416 */       if (this.isRowDeleted) {
/* 2417 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2418 */         ((SQLException)localObject1).fillInStackTrace();
/* 2419 */         throw ((Throwable)localObject1);
/*      */       }
/* 2421 */       if (paramORADataFactory == null)
/*      */       {
/* 2423 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2424 */         ((SQLException)localObject1).fillInStackTrace();
/* 2425 */         throw ((Throwable)localObject1);
/*      */       }
/*      */ 
/* 2428 */       Object localObject1 = null;
/*      */ 
/* 2430 */       setIsNull(3);
/*      */ 
/* 2432 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2435 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2437 */         setIsNull(localDatum == null);
/*      */ 
/* 2439 */         localObject1 = paramORADataFactory.create(localDatum, 0);
/*      */       }
/*      */       else
/*      */       {
/* 2443 */         setIsNull(4);
/*      */ 
/* 2445 */         localObject1 = this.resultSet.getORAData(paramInt, paramORADataFactory);
/*      */       }
/*      */ 
/* 2448 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2461 */     ensureOpen();
/* 2462 */     if (this.isRowDeleted) {
/* 2463 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2464 */       ((SQLException)localObject).fillInStackTrace();
/* 2465 */       throw ((Throwable)localObject);
/*      */     }
/* 2467 */     Object localObject = getNCLOB(paramInt);
/*      */ 
/* 2469 */     if (localObject == null) return null;
/*      */ 
/* 2471 */     if (!(localObject instanceof NClob))
/*      */     {
/* 2473 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 184);
/* 2474 */       localSQLException.fillInStackTrace();
/* 2475 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2478 */     return localObject;
/*      */   }
/*      */ 
/*      */   public String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2490 */     ensureOpen();
/* 2491 */     if (this.isRowDeleted) {
/* 2492 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2493 */       localSQLException.fillInStackTrace();
/* 2494 */       throw localSQLException;
/*      */     }
/* 2496 */     return getString(paramInt);
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2508 */     ensureOpen();
/* 2509 */     if (this.isRowDeleted) {
/* 2510 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2511 */       localSQLException.fillInStackTrace();
/* 2512 */       throw localSQLException;
/*      */     }
/* 2514 */     return getCharacterStream(paramInt);
/*      */   }
/*      */ 
/*      */   public RowId getRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2526 */     ensureOpen();
/* 2527 */     if (this.isRowDeleted) {
/* 2528 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2529 */       localSQLException.fillInStackTrace();
/* 2530 */       throw localSQLException;
/*      */     }
/* 2532 */     return getROWID(paramInt);
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2538 */     synchronized (this.connection)
/*      */     {
/* 2545 */       ensureOpen();
/* 2546 */       if (this.isRowDeleted) {
/* 2547 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 2548 */         ((SQLException)localObject1).fillInStackTrace();
/* 2549 */         throw ((Throwable)localObject1);
/*      */       }
/* 2551 */       Object localObject1 = null;
/*      */ 
/* 2553 */       setIsNull(3);
/*      */ 
/* 2555 */       if ((isOnInsertRow()) || ((isUpdatingRow()) && (isRowBufferUpdatedAt(paramInt))))
/*      */       {
/* 2558 */         Datum localDatum = getRowBufferDatumAt(paramInt);
/*      */ 
/* 2560 */         setIsNull(localDatum == null);
/*      */ 
/* 2562 */         if ((localDatum != null) && (!(localDatum instanceof SQLXML)))
/*      */         {
/* 2564 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, "getSQLXML");
/* 2565 */           localSQLException.fillInStackTrace();
/* 2566 */           throw localSQLException;
/*      */         }
/*      */ 
/* 2569 */         localObject1 = (SQLXML)localDatum;
/*      */       }
/*      */       else
/*      */       {
/* 2573 */         setIsNull(4);
/*      */ 
/* 2575 */         localObject1 = this.resultSet.getSQLXML(paramInt);
/*      */       }
/*      */ 
/* 2578 */       return localObject1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateRowId(int paramInt, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 2596 */     updateROWID(paramInt, (ROWID)paramRowId);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2610 */     updateCharacterStream(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2623 */     updateCharacterStream(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(int paramInt, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 2634 */     updateOracleObject(paramInt, (Datum)paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void updateNString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2645 */     updateString(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 2656 */     updateClob(paramInt, paramNClob);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2668 */     updateAsciiStream(paramInt, paramInputStream, (int)paramLong);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 2680 */     updateAsciiStream(paramInt, paramInputStream, 2147483647);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2692 */     updateBinaryStream(paramInt, paramInputStream, (int)paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 2704 */     updateBinaryStream(paramInt, paramInputStream, 2147483647);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2716 */     updateCharacterStream(paramInt, paramReader, (int)paramLong);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2728 */     updateCharacterStream(paramInt, paramReader, 2147483647);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 2740 */     Blob localBlob = this.connection.createBlob();
/* 2741 */     addToTempLobsToFree(localBlob);
/* 2742 */     int i = ((BLOB)localBlob).getBufferSize();
/* 2743 */     OutputStream localOutputStream = localBlob.setBinaryStream(1L);
/* 2744 */     byte[] arrayOfByte = new byte[i];
/*      */     try
/*      */     {
/*      */       while (true)
/*      */       {
/* 2749 */         int j = paramInputStream.read(arrayOfByte);
/* 2750 */         if (j == -1) break;
/* 2751 */         localOutputStream.write(arrayOfByte, 0, j);
/*      */       }
/* 2753 */       localOutputStream.close();
/* 2754 */       updateBlob(paramInt, localBlob);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2758 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2759 */       localSQLException.fillInStackTrace();
/* 2760 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2774 */     Blob localBlob = this.connection.createBlob();
/* 2775 */     addToTempLobsToFree(localBlob);
/* 2776 */     int i = ((BLOB)localBlob).getBufferSize();
/* 2777 */     OutputStream localOutputStream = localBlob.setBinaryStream(1L);
/* 2778 */     byte[] arrayOfByte = new byte[i];
/* 2779 */     long l = paramLong;
/*      */     try
/*      */     {
/* 2782 */       while (l > 0L)
/*      */       {
/* 2784 */         int j = paramInputStream.read(arrayOfByte, 0, Math.min(i, (int)l));
/* 2785 */         if (j == -1) break;
/* 2786 */         localOutputStream.write(arrayOfByte, 0, j);
/*      */ 
/* 2788 */         l -= j;
/*      */       }
/* 2790 */       localOutputStream.close();
/* 2791 */       updateBlob(paramInt, localBlob);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2795 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2796 */       localSQLException.fillInStackTrace();
/* 2797 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2811 */     updateClob(paramInt, paramReader, paramLong, (short)1);
/*      */   }
/*      */ 
/*      */   void updateClob(int paramInt, Reader paramReader, long paramLong, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2824 */     NClob localNClob = paramShort == 1 ? this.connection.createClob() : this.connection.createNClob();
/*      */ 
/* 2827 */     addToTempLobsToFree(localNClob);
/* 2828 */     int i = ((CLOB)localNClob).getBufferSize();
/* 2829 */     Writer localWriter = localNClob.setCharacterStream(1L);
/* 2830 */     char[] arrayOfChar = new char[i];
/* 2831 */     long l = paramLong;
/*      */     try
/*      */     {
/* 2834 */       while (l > 0L)
/*      */       {
/* 2836 */         int j = paramReader.read(arrayOfChar, 0, Math.min(i, (int)l));
/* 2837 */         if (j == -1) break;
/* 2838 */         localWriter.write(arrayOfChar, 0, j);
/*      */ 
/* 2840 */         l -= j;
/*      */       }
/* 2842 */       localWriter.close();
/* 2843 */       updateClob(paramInt, localNClob);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2847 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2848 */       localSQLException.fillInStackTrace();
/* 2849 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2864 */     Clob localClob = this.connection.createClob();
/* 2865 */     addToTempLobsToFree(localClob);
/* 2866 */     int i = ((CLOB)localClob).getBufferSize();
/* 2867 */     Writer localWriter = localClob.setCharacterStream(1L);
/* 2868 */     char[] arrayOfChar = new char[i];
/*      */     try
/*      */     {
/*      */       while (true)
/*      */       {
/* 2873 */         int j = paramReader.read(arrayOfChar);
/* 2874 */         if (j == -1) break;
/* 2875 */         localWriter.write(arrayOfChar, 0, j);
/*      */       }
/* 2877 */       localWriter.close();
/* 2878 */       updateClob(paramInt, localClob);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2882 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2883 */       localSQLException.fillInStackTrace();
/* 2884 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void updateClob(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2899 */     updateClob(paramInt1, paramInputStream, paramInt2, (short)1);
/*      */   }
/*      */ 
/*      */   void updateClob(int paramInt1, InputStream paramInputStream, int paramInt2, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2914 */     NClob localNClob = paramShort == 1 ? this.connection.createClob() : this.connection.createNClob();
/*      */ 
/* 2917 */     addToTempLobsToFree(localNClob);
/* 2918 */     int i = ((CLOB)localNClob).getBufferSize();
/* 2919 */     OutputStream localOutputStream = localNClob.setAsciiStream(1L);
/* 2920 */     byte[] arrayOfByte = new byte[i];
/* 2921 */     long l = paramInt2;
/*      */     try
/*      */     {
/* 2924 */       while (l > 0L)
/*      */       {
/* 2926 */         int j = paramInputStream.read(arrayOfByte, 0, Math.min(i, (int)l));
/* 2927 */         if (j == -1) break;
/* 2928 */         localOutputStream.write(arrayOfByte, 0, j);
/*      */ 
/* 2930 */         l -= j;
/*      */       }
/* 2932 */       localOutputStream.close();
/* 2933 */       updateClob(paramInt1, localNClob);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2937 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2938 */       localSQLException.fillInStackTrace();
/* 2939 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   void updateNClob(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2955 */     NClob localNClob = this.connection.createNClob();
/* 2956 */     addToTempLobsToFree(localNClob);
/* 2957 */     int i = ((NCLOB)localNClob).getBufferSize();
/* 2958 */     OutputStream localOutputStream = localNClob.setAsciiStream(1L);
/* 2959 */     byte[] arrayOfByte = new byte[i];
/* 2960 */     long l = paramInt2;
/*      */     try
/*      */     {
/* 2963 */       while (l > 0L)
/*      */       {
/* 2965 */         int j = paramInputStream.read(arrayOfByte, 0, Math.min(i, (int)l));
/* 2966 */         if (j == -1) break;
/* 2967 */         localOutputStream.write(arrayOfByte, 0, j);
/*      */ 
/* 2969 */         l -= j;
/*      */       }
/* 2971 */       localOutputStream.close();
/* 2972 */       updateNClob(paramInt1, localNClob);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 2976 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 2977 */       localSQLException.fillInStackTrace();
/* 2978 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2993 */     if (paramReader == null)
/*      */     {
/* 2995 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "updateNClob");
/* 2996 */       ((SQLException)localObject).fillInStackTrace();
/* 2997 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 3000 */     Object localObject = this.connection.createNClob();
/* 3001 */     addToTempLobsToFree((Clob)localObject);
/* 3002 */     int i = ((CLOB)localObject).getBufferSize();
/* 3003 */     Writer localWriter = ((NClob)localObject).setCharacterStream(1L);
/* 3004 */     char[] arrayOfChar = new char[i];
/* 3005 */     long l = paramLong;
/*      */     try
/*      */     {
/* 3008 */       while (l > 0L)
/*      */       {
/* 3010 */         int j = paramReader.read(arrayOfChar, 0, Math.min(i, (int)l));
/* 3011 */         if (j == -1) break;
/* 3012 */         localWriter.write(arrayOfChar, 0, j);
/*      */ 
/* 3014 */         l -= j;
/*      */       }
/* 3016 */       localWriter.close();
/* 3017 */       updateNClob(paramInt, (NClob)localObject);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3021 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3022 */       localSQLException.fillInStackTrace();
/* 3023 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 3038 */     if (paramReader == null)
/*      */     {
/* 3040 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "updateNClob");
/* 3041 */       ((SQLException)localObject).fillInStackTrace();
/* 3042 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 3045 */     Object localObject = this.connection.createNClob();
/* 3046 */     addToTempLobsToFree((Clob)localObject);
/* 3047 */     int i = ((CLOB)localObject).getBufferSize();
/* 3048 */     Writer localWriter = ((NClob)localObject).setCharacterStream(1L);
/* 3049 */     char[] arrayOfChar = new char[i];
/*      */     try
/*      */     {
/*      */       while (true)
/*      */       {
/* 3054 */         int j = paramReader.read(arrayOfChar);
/* 3055 */         if (j == -1) break;
/* 3056 */         localWriter.write(arrayOfChar, 0, j);
/*      */       }
/* 3058 */       localWriter.close();
/* 3059 */       updateNClob(paramInt, (NClob)localObject);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3063 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3064 */       localSQLException.fillInStackTrace();
/* 3065 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 3074 */     synchronized (this.connection)
/*      */     {
/* 3081 */       if ((paramString == null) || (paramString.length() == 0))
/* 3082 */         updateNull(paramInt);
/*      */       else
/* 3084 */         updateObject(paramInt, paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBoolean(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3097 */     updateObject(paramInt, Boolean.valueOf(paramBoolean));
/*      */   }
/*      */ 
/*      */   public void updateByte(int paramInt, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 3109 */     updateObject(paramInt, Integer.valueOf(paramByte));
/*      */   }
/*      */ 
/*      */   public void updateShort(int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 3121 */     updateObject(paramInt, Integer.valueOf(paramShort));
/*      */   }
/*      */ 
/*      */   public void updateInt(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3133 */     updateObject(paramInt1, Integer.valueOf(paramInt2));
/*      */   }
/*      */ 
/*      */   public void updateLong(int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3145 */     updateObject(paramInt, Long.valueOf(paramLong));
/*      */   }
/*      */ 
/*      */   public void updateFloat(int paramInt, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 3157 */     updateObject(paramInt, Float.valueOf(paramFloat));
/*      */   }
/*      */ 
/*      */   public void updateDouble(int paramInt, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 3169 */     updateObject(paramInt, Double.valueOf(paramDouble));
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 3182 */     updateObject(paramInt, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void updateBytes(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 3194 */     updateObject(paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void updateDate(int paramInt, Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 3206 */     updateObject(paramInt, paramDate);
/*      */   }
/*      */ 
/*      */   public void updateTime(int paramInt, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 3218 */     updateObject(paramInt, paramTime);
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(int paramInt, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 3231 */     updateObject(paramInt, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3245 */     ensureOpen();
/* 3246 */     if (this.isRowDeleted) {
/* 3247 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 3248 */       ((SQLException)localObject).fillInStackTrace();
/* 3249 */       throw ((Throwable)localObject);
/*      */     }
/* 3251 */     Object localObject = (OracleResultSetMetaData)getInternalMetadata();
/* 3252 */     int i = ((OracleResultSetMetaData)localObject).getColumnType(paramInt1);
/* 3253 */     if ((paramInputStream != null) && (paramInt2 > 0))
/*      */     {
/* 3255 */       switch (i)
/*      */       {
/*      */       case 2005:
/* 3258 */         updateClob(paramInt1, paramInputStream, paramInt2);
/* 3259 */         break;
/*      */       case 2011:
/* 3262 */         updateNClob(paramInt1, paramInputStream, paramInt2);
/* 3263 */         break;
/*      */       case 2004:
/* 3267 */         updateBlob(paramInt1, paramInputStream, paramInt2);
/* 3268 */         break;
/*      */       case -1:
/* 3271 */         int[] arrayOfInt = { paramInt2, 1 };
/*      */ 
/* 3275 */         setRowBufferAt(paramInt1, paramInputStream, arrayOfInt);
/* 3276 */         break;
/*      */       default:
/*      */         try
/*      */         {
/* 3281 */           int j = 0;
/* 3282 */           int k = paramInt2;
/* 3283 */           byte[] arrayOfByte = new byte[1024];
/* 3284 */           char[] arrayOfChar = new char[1024];
/* 3285 */           StringBuilder localStringBuilder = new StringBuilder(1024);
/*      */ 
/* 3287 */           while (k > 0)
/*      */           {
/* 3289 */             if (k >= 1024)
/* 3290 */               j = paramInputStream.read(arrayOfByte);
/*      */             else {
/* 3292 */               j = paramInputStream.read(arrayOfByte, 0, k);
/*      */             }
/*      */ 
/* 3296 */             if (j == -1) {
/*      */               break;
/*      */             }
/* 3299 */             DBConversion.asciiBytesToJavaChars(arrayOfByte, j, arrayOfChar);
/*      */ 
/* 3301 */             localStringBuilder.append(arrayOfChar, 0, j);
/* 3302 */             k -= j;
/*      */           }
/*      */ 
/* 3305 */           paramInputStream.close();
/* 3306 */           if (k == paramInt2)
/*      */           {
/* 3308 */             updateNull(paramInt1);
/* 3309 */             return;
/*      */           }
/*      */ 
/* 3312 */           updateString(paramInt1, localStringBuilder.toString());
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 3317 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3318 */           localSQLException.fillInStackTrace();
/* 3319 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3326 */       setRowBufferAt(paramInt1, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3340 */     ensureOpen();
/* 3341 */     if (this.isRowDeleted) {
/* 3342 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 3343 */       localSQLException1.fillInStackTrace();
/* 3344 */       throw localSQLException1;
/*      */     }
/* 3346 */     int i = getInternalMetadata().getColumnType(paramInt1);
/* 3347 */     if ((paramInputStream != null) && (paramInt2 > 0))
/*      */     {
/* 3349 */       switch (i)
/*      */       {
/*      */       case 2004:
/* 3352 */         updateBlob(paramInt1, paramInputStream, paramInt2);
/* 3353 */         break;
/*      */       case -4:
/* 3356 */         int[] arrayOfInt = { paramInt2, 2 };
/*      */ 
/* 3361 */         setRowBufferAt(paramInt1, paramInputStream, arrayOfInt);
/* 3362 */         break;
/*      */       default:
/*      */         try
/*      */         {
/* 3367 */           int j = 0;
/* 3368 */           int k = paramInt2;
/* 3369 */           byte[] arrayOfByte = new byte[1024];
/* 3370 */           ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream(1024);
/*      */ 
/* 3373 */           while (k > 0)
/*      */           {
/* 3375 */             if (k >= 1024)
/* 3376 */               j = paramInputStream.read(arrayOfByte);
/*      */             else {
/* 3378 */               j = paramInputStream.read(arrayOfByte, 0, k);
/*      */             }
/*      */ 
/* 3382 */             if (j == -1) {
/*      */               break;
/*      */             }
/* 3385 */             localByteArrayOutputStream.write(arrayOfByte, 0, j);
/* 3386 */             k -= j;
/*      */           }
/*      */ 
/* 3389 */           paramInputStream.close();
/* 3390 */           if (k == paramInt2)
/*      */           {
/* 3392 */             updateNull(paramInt1);
/* 3393 */             return;
/*      */           }
/*      */ 
/* 3396 */           updateBytes(paramInt1, localByteArrayOutputStream.toByteArray());
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 3401 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3402 */           localSQLException2.fillInStackTrace();
/* 3403 */           throw localSQLException2;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3413 */       setRowBufferAt(paramInt1, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3421 */     int i = 0; int j = paramInt2;
/*      */ 
/* 3429 */     ensureOpen();
/* 3430 */     if (this.isRowDeleted) {
/* 3431 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 3432 */       ((SQLException)localObject1).fillInStackTrace();
/* 3433 */       throw ((Throwable)localObject1);
/*      */     }
/* 3435 */     Object localObject1 = (OracleResultSetMetaData)getInternalMetadata();
/* 3436 */     int k = ((OracleResultSetMetaData)localObject1).getColumnType(paramInt1);
/* 3437 */     if ((paramReader != null) && (paramInt2 > 0))
/*      */     {
/* 3439 */       switch (k)
/*      */       {
/*      */       case 2005:
/* 3442 */         updateClob(paramInt1, paramReader, paramInt2);
/* 3443 */         break;
/*      */       case 2011:
/* 3446 */         updateNClob(paramInt1, paramReader, paramInt2);
/* 3447 */         break;
/*      */       case -1:
/* 3450 */         int[] arrayOfInt = { paramInt2 };
/*      */ 
/* 3455 */         setRowBufferAt(paramInt1, paramReader, arrayOfInt);
/* 3456 */         break;
/*      */       default:
/*      */         try
/*      */         {
/* 3461 */           char[] arrayOfChar = new char[1024];
/* 3462 */           localObject2 = new StringBuilder(1024);
/*      */ 
/* 3464 */           while (j > 0)
/*      */           {
/* 3466 */             if (j >= 1024)
/* 3467 */               i = paramReader.read(arrayOfChar);
/*      */             else {
/* 3469 */               i = paramReader.read(arrayOfChar, 0, j);
/*      */             }
/*      */ 
/* 3473 */             if (i == -1) {
/*      */               break;
/*      */             }
/* 3476 */             ((StringBuilder)localObject2).append(arrayOfChar, 0, i);
/* 3477 */             j -= i;
/*      */           }
/*      */ 
/* 3480 */           paramReader.close();
/* 3481 */           if (j == paramInt2)
/*      */           {
/* 3483 */             updateNull(paramInt1);
/* 3484 */             return;
/*      */           }
/*      */ 
/* 3487 */           updateString(paramInt1, ((StringBuilder)localObject2).toString());
/*      */         }
/*      */         catch (IOException localIOException)
/*      */         {
/* 3492 */           Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 3493 */           ((SQLException)localObject2).fillInStackTrace();
/* 3494 */           throw ((Throwable)localObject2);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3502 */       setRowBufferAt(paramInt1, null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt1, Object paramObject, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3516 */     updateObject(paramInt1, paramObject);
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 3523 */     synchronized (this.connection)
/*      */     {
/* 3530 */       ensureOpen();
/* 3531 */       if (this.isRowDeleted) {
/* 3532 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 82);
/* 3533 */         ((SQLException)localObject1).fillInStackTrace();
/* 3534 */         throw ((Throwable)localObject1);
/*      */       }
/* 3536 */       Object localObject1 = null;
/* 3537 */       if (paramObject != null)
/*      */       {
/*      */         Object localObject2;
/* 3539 */         if ((paramObject instanceof OracleData))
/*      */         {
/* 3541 */           localObject2 = ((OracleData)paramObject).toJDBCObject(this.connection);
/*      */ 
/* 3545 */           if ((localObject2 instanceof _Proxy_))
/*      */           {
/* 3547 */             final _Proxy_ local_Proxy_ = (_Proxy_)localObject2;
/* 3548 */             localObject2 = AccessController.doPrivileged(new PrivilegedAction()
/*      */             {
/*      */               public Object run()
/*      */               {
/* 3553 */                 return ProxyFactory.extractDelegate(local_Proxy_);
/*      */               }
/*      */             });
/*      */           }
/* 3557 */           paramObject = localObject2;
/*      */         }
/* 3559 */         if ((paramObject instanceof Datum))
/*      */         {
/* 3561 */           localObject1 = (Datum)paramObject;
/*      */         }
/*      */         else
/*      */         {
/* 3565 */           localObject2 = (OracleResultSetMetaData)getInternalMetadata();
/* 3566 */           int i = paramInt;
/*      */ 
/* 3568 */           int j = ((OracleResultSetMetaData)localObject2).getColumnType(i);
/*      */ 
/* 3570 */           switch (j)
/*      */           {
/*      */           case -15:
/*      */           case -9:
/*      */           case -1:
/*      */           case 1:
/*      */           case 12:
/* 3578 */             if ((paramObject instanceof byte[])) {
/* 3579 */               byte[] arrayOfByte = (byte[])paramObject;
/*      */ 
/* 3582 */               char[] arrayOfChar = new char[arrayOfByte.length * 3];
/* 3583 */               int k = DBConversion.RAWBytesToHexChars(arrayOfByte, arrayOfByte.length, arrayOfChar);
/*      */ 
/* 3585 */               paramObject = new String(arrayOfChar, 0, k);
/*      */             }break;
/*      */           }
/* 3588 */           localObject1 = SQLUtil.makeOracleDatum(this.connection, paramObject, ((OracleResultSetMetaData)localObject2).getColumnType(i), null, ((OracleResultSetMetaData)localObject2).isNCHAR(i));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 3593 */       setRowBufferAt(paramInt, (Datum)localObject1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateOracleObject(int paramInt, Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/* 3601 */     synchronized (this.connection)
/*      */     {
/* 3608 */       setRowBufferAt(paramInt, paramDatum);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateROWID(int paramInt, ROWID paramROWID)
/*      */     throws SQLException
/*      */   {
/* 3621 */     updateOracleObject(paramInt, paramROWID);
/*      */   }
/*      */ 
/*      */   public void updateNUMBER(int paramInt, NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 3633 */     updateOracleObject(paramInt, paramNUMBER);
/*      */   }
/*      */ 
/*      */   public void updateDATE(int paramInt, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/* 3645 */     updateOracleObject(paramInt, paramDATE);
/*      */   }
/*      */ 
/*      */   public void updateINTERVALYM(int paramInt, INTERVALYM paramINTERVALYM)
/*      */     throws SQLException
/*      */   {
/* 3658 */     updateOracleObject(paramInt, paramINTERVALYM);
/*      */   }
/*      */ 
/*      */   public void updateINTERVALDS(int paramInt, INTERVALDS paramINTERVALDS)
/*      */     throws SQLException
/*      */   {
/* 3671 */     updateOracleObject(paramInt, paramINTERVALDS);
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMP(int paramInt, TIMESTAMP paramTIMESTAMP)
/*      */     throws SQLException
/*      */   {
/* 3683 */     updateOracleObject(paramInt, paramTIMESTAMP);
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMPTZ(int paramInt, TIMESTAMPTZ paramTIMESTAMPTZ)
/*      */     throws SQLException
/*      */   {
/* 3696 */     updateOracleObject(paramInt, paramTIMESTAMPTZ);
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMPLTZ(int paramInt, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*      */     throws SQLException
/*      */   {
/* 3709 */     updateOracleObject(paramInt, paramTIMESTAMPLTZ);
/*      */   }
/*      */ 
/*      */   public void updateARRAY(int paramInt, ARRAY paramARRAY)
/*      */     throws SQLException
/*      */   {
/* 3721 */     updateOracleObject(paramInt, paramARRAY);
/*      */   }
/*      */ 
/*      */   public void updateSTRUCT(int paramInt, STRUCT paramSTRUCT)
/*      */     throws SQLException
/*      */   {
/* 3733 */     updateOracleObject(paramInt, paramSTRUCT);
/*      */   }
/*      */ 
/*      */   public void updateOPAQUE(int paramInt, OPAQUE paramOPAQUE)
/*      */     throws SQLException
/*      */   {
/* 3745 */     updateOracleObject(paramInt, paramOPAQUE);
/*      */   }
/*      */ 
/*      */   public void updateREF(int paramInt, REF paramREF)
/*      */     throws SQLException
/*      */   {
/* 3757 */     updateOracleObject(paramInt, paramREF);
/*      */   }
/*      */ 
/*      */   public void updateCHAR(int paramInt, CHAR paramCHAR)
/*      */     throws SQLException
/*      */   {
/* 3769 */     updateOracleObject(paramInt, paramCHAR);
/*      */   }
/*      */ 
/*      */   public void updateRAW(int paramInt, RAW paramRAW)
/*      */     throws SQLException
/*      */   {
/* 3781 */     updateOracleObject(paramInt, paramRAW);
/*      */   }
/*      */ 
/*      */   public void updateBLOB(int paramInt, BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 3793 */     updateOracleObject(paramInt, paramBLOB);
/*      */   }
/*      */ 
/*      */   public void updateCLOB(int paramInt, CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 3805 */     updateOracleObject(paramInt, paramCLOB);
/*      */   }
/*      */ 
/*      */   public void updateBFILE(int paramInt, BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 3817 */     updateOracleObject(paramInt, paramBFILE);
/*      */   }
/*      */ 
/*      */   public void updateBfile(int paramInt, BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 3829 */     updateOracleObject(paramInt, paramBFILE);
/*      */   }
/*      */ 
/*      */   public void updateCustomDatum(int paramInt, CustomDatum paramCustomDatum)
/*      */     throws SQLException
/*      */   {
/* 3842 */     throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
/*      */   }
/*      */ 
/*      */   public void updateORAData(int paramInt, ORAData paramORAData)
/*      */     throws SQLException
/*      */   {
/* 3857 */     Datum localDatum = paramORAData.toDatum(this.connection);
/*      */ 
/* 3859 */     updateOracleObject(paramInt, localDatum);
/*      */   }
/*      */ 
/*      */   public void updateRef(int paramInt, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 3871 */     updateREF(paramInt, (REF)paramRef);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 3883 */     updateBLOB(paramInt, (BLOB)paramBlob);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 3895 */     updateCLOB(paramInt, (CLOB)paramClob);
/*      */   }
/*      */ 
/*      */   public void updateArray(int paramInt, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 3907 */     updateARRAY(paramInt, (ARRAY)paramArray);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.GeneratedUpdatableResultSet
 * JD-Core Version:    0.6.2
 */