/*     */ package oracle.jdbc.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.math.BigDecimal;
/*     */ import java.net.URL;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Date;
/*     */ import java.sql.NClob;
/*     */ import java.sql.Ref;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.OracleDataFactory;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.sql.ARRAY;
/*     */ import oracle.sql.BFILE;
/*     */ import oracle.sql.BLOB;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CLOB;
/*     */ import oracle.sql.CustomDatum;
/*     */ import oracle.sql.CustomDatumFactory;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.INTERVALDS;
/*     */ import oracle.sql.INTERVALYM;
/*     */ import oracle.sql.NUMBER;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.ORAData;
/*     */ import oracle.sql.ORADataFactory;
/*     */ import oracle.sql.RAW;
/*     */ import oracle.sql.REF;
/*     */ import oracle.sql.ROWID;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ import oracle.sql.TIMESTAMPLTZ;
/*     */ import oracle.sql.TIMESTAMPTZ;
/*     */ 
/*     */ abstract class GeneratedStatement
/*     */ {
/*     */   PhysicalConnection connection;
/*  41 */   Accessor[] accessors = null;
/*     */ 
/*  44 */   int lastIndex = -1;
/*     */   OracleInputStream streamList;
/*  52 */   protected int indexOfFirstRow = 0;
/*     */ 
/*  61 */   protected int offsetOfFirstUserColumn = -1;
/*     */ 
/* 711 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected GeneratedStatement(PhysicalConnection paramPhysicalConnection)
/*     */   {
/*  66 */     this.connection = paramPhysicalConnection;
/*     */   }
/*     */ 
/*     */   abstract void closeUsedStreams(int paramInt)
/*     */     throws SQLException;
/*     */ 
/*     */   Array getArray(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  81 */     synchronized (this.connection)
/*     */     {
/*  83 */       this.lastIndex = paramInt2;
/*  84 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/*  85 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getArray(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*  92 */     synchronized (this.connection)
/*     */     {
/*  94 */       this.lastIndex = paramInt2;
/*  95 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/*  96 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBigDecimal(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   BigDecimal getBigDecimal(int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException
/*     */   {
/* 103 */     synchronized (this.connection)
/*     */     {
/* 105 */       this.lastIndex = paramInt2;
/* 106 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 107 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBigDecimal(paramInt1 - this.indexOfFirstRow, paramInt3);
/*     */     }
/*     */   }
/*     */ 
/*     */   Blob getBlob(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 114 */     synchronized (this.connection)
/*     */     {
/* 116 */       this.lastIndex = paramInt2;
/* 117 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 118 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBlob(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean getBoolean(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 125 */     synchronized (this.connection)
/*     */     {
/* 127 */       this.lastIndex = paramInt2;
/* 128 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 129 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBoolean(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   byte getByte(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 136 */     synchronized (this.connection)
/*     */     {
/* 138 */       this.lastIndex = paramInt2;
/* 139 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 140 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getByte(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   byte[] getBytes(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 147 */     synchronized (this.connection)
/*     */     {
/* 149 */       this.lastIndex = paramInt2;
/* 150 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 151 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBytes(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Clob getClob(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 158 */     synchronized (this.connection)
/*     */     {
/* 160 */       this.lastIndex = paramInt2;
/* 161 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 162 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getClob(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Date getDate(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 169 */     synchronized (this.connection)
/*     */     {
/* 171 */       this.lastIndex = paramInt2;
/* 172 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 173 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getDate(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Date getDate(int paramInt1, int paramInt2, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 180 */     synchronized (this.connection)
/*     */     {
/* 182 */       this.lastIndex = paramInt2;
/* 183 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 184 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getDate(paramInt1 - this.indexOfFirstRow, paramCalendar);
/*     */     }
/*     */   }
/*     */ 
/*     */   double getDouble(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 191 */     synchronized (this.connection)
/*     */     {
/* 193 */       this.lastIndex = paramInt2;
/* 194 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 195 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getDouble(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   float getFloat(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 202 */     synchronized (this.connection)
/*     */     {
/* 204 */       this.lastIndex = paramInt2;
/* 205 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 206 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getFloat(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   int getInt(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 213 */     synchronized (this.connection)
/*     */     {
/* 215 */       this.lastIndex = paramInt2;
/* 216 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 217 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getInt(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   long getLong(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 224 */     synchronized (this.connection)
/*     */     {
/* 226 */       this.lastIndex = paramInt2;
/* 227 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 228 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getLong(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   NClob getNClob(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 235 */     synchronized (this.connection)
/*     */     {
/* 237 */       this.lastIndex = paramInt2;
/* 238 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 239 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getNClob(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   String getNString(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 246 */     synchronized (this.connection)
/*     */     {
/* 248 */       this.lastIndex = paramInt2;
/* 249 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 250 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getNString(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 257 */     synchronized (this.connection)
/*     */     {
/* 259 */       this.lastIndex = paramInt2;
/* 260 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 261 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getObject(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt1, int paramInt2, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 268 */     synchronized (this.connection)
/*     */     {
/* 270 */       this.lastIndex = paramInt2;
/* 271 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 272 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getObject(paramInt1 - this.indexOfFirstRow, paramMap);
/*     */     }
/*     */   }
/*     */ 
/*     */   Ref getRef(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 279 */     synchronized (this.connection)
/*     */     {
/* 281 */       this.lastIndex = paramInt2;
/* 282 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 283 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getRef(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   RowId getRowId(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 290 */     synchronized (this.connection)
/*     */     {
/* 292 */       this.lastIndex = paramInt2;
/* 293 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 294 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getRowId(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   short getShort(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 301 */     synchronized (this.connection)
/*     */     {
/* 303 */       this.lastIndex = paramInt2;
/* 304 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 305 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getShort(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   SQLXML getSQLXML(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 312 */     synchronized (this.connection)
/*     */     {
/* 314 */       this.lastIndex = paramInt2;
/* 315 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 316 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getSQLXML(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   String getString(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 323 */     synchronized (this.connection)
/*     */     {
/* 325 */       this.lastIndex = paramInt2;
/* 326 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 327 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getString(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 334 */     synchronized (this.connection)
/*     */     {
/* 336 */       this.lastIndex = paramInt2;
/* 337 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 338 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTime(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Time getTime(int paramInt1, int paramInt2, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 345 */     synchronized (this.connection)
/*     */     {
/* 347 */       this.lastIndex = paramInt2;
/* 348 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 349 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTime(paramInt1 - this.indexOfFirstRow, paramCalendar);
/*     */     }
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 356 */     synchronized (this.connection)
/*     */     {
/* 358 */       this.lastIndex = paramInt2;
/* 359 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 360 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTimestamp(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Timestamp getTimestamp(int paramInt1, int paramInt2, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 367 */     synchronized (this.connection)
/*     */     {
/* 369 */       this.lastIndex = paramInt2;
/* 370 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 371 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTimestamp(paramInt1 - this.indexOfFirstRow, paramCalendar);
/*     */     }
/*     */   }
/*     */ 
/*     */   URL getURL(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 378 */     synchronized (this.connection)
/*     */     {
/* 380 */       this.lastIndex = paramInt2;
/* 381 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 382 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getURL(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   ARRAY getARRAY(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 389 */     synchronized (this.connection)
/*     */     {
/* 391 */       this.lastIndex = paramInt2;
/* 392 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 393 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getARRAY(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   BFILE getBFILE(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 400 */     synchronized (this.connection)
/*     */     {
/* 402 */       this.lastIndex = paramInt2;
/* 403 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 404 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBFILE(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   BFILE getBfile(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 411 */     synchronized (this.connection)
/*     */     {
/* 413 */       this.lastIndex = paramInt2;
/* 414 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 415 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBfile(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   BLOB getBLOB(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 422 */     synchronized (this.connection)
/*     */     {
/* 424 */       this.lastIndex = paramInt2;
/* 425 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 426 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBLOB(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   CHAR getCHAR(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 433 */     synchronized (this.connection)
/*     */     {
/* 435 */       this.lastIndex = paramInt2;
/* 436 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 437 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getCHAR(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   CLOB getCLOB(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 444 */     synchronized (this.connection)
/*     */     {
/* 446 */       this.lastIndex = paramInt2;
/* 447 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 448 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getCLOB(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   ResultSet getCursor(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 455 */     synchronized (this.connection)
/*     */     {
/* 457 */       this.lastIndex = paramInt2;
/* 458 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 459 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getCursor(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   DATE getDATE(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 466 */     synchronized (this.connection)
/*     */     {
/* 468 */       this.lastIndex = paramInt2;
/* 469 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 470 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getDATE(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   INTERVALDS getINTERVALDS(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 477 */     synchronized (this.connection)
/*     */     {
/* 479 */       this.lastIndex = paramInt2;
/* 480 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 481 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getINTERVALDS(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   INTERVALYM getINTERVALYM(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 488 */     synchronized (this.connection)
/*     */     {
/* 490 */       this.lastIndex = paramInt2;
/* 491 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 492 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getINTERVALYM(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   NUMBER getNUMBER(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 499 */     synchronized (this.connection)
/*     */     {
/* 501 */       this.lastIndex = paramInt2;
/* 502 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 503 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getNUMBER(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   OPAQUE getOPAQUE(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 510 */     synchronized (this.connection)
/*     */     {
/* 512 */       this.lastIndex = paramInt2;
/* 513 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 514 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getOPAQUE(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Datum getOracleObject(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 521 */     synchronized (this.connection)
/*     */     {
/* 523 */       this.lastIndex = paramInt2;
/* 524 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 525 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getOracleObject(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   ORAData getORAData(int paramInt1, int paramInt2, ORADataFactory paramORADataFactory)
/*     */     throws SQLException
/*     */   {
/* 532 */     synchronized (this.connection)
/*     */     {
/* 534 */       this.lastIndex = paramInt2;
/* 535 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 536 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getORAData(paramInt1 - this.indexOfFirstRow, paramORADataFactory);
/*     */     }
/*     */   }
/*     */ 
/*     */   Object getObject(int paramInt1, int paramInt2, OracleDataFactory paramOracleDataFactory)
/*     */     throws SQLException
/*     */   {
/* 543 */     synchronized (this.connection)
/*     */     {
/* 545 */       this.lastIndex = paramInt2;
/* 546 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 547 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getObject(paramInt1 - this.indexOfFirstRow, paramOracleDataFactory);
/*     */     }
/*     */   }
/*     */ 
/*     */   RAW getRAW(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 554 */     synchronized (this.connection)
/*     */     {
/* 556 */       this.lastIndex = paramInt2;
/* 557 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 558 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getRAW(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   REF getREF(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 565 */     synchronized (this.connection)
/*     */     {
/* 567 */       this.lastIndex = paramInt2;
/* 568 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 569 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getREF(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   ROWID getROWID(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 576 */     synchronized (this.connection)
/*     */     {
/* 578 */       this.lastIndex = paramInt2;
/* 579 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 580 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getROWID(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   STRUCT getSTRUCT(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 587 */     synchronized (this.connection)
/*     */     {
/* 589 */       this.lastIndex = paramInt2;
/* 590 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 591 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getSTRUCT(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 598 */     synchronized (this.connection)
/*     */     {
/* 600 */       this.lastIndex = paramInt2;
/* 601 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 602 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTIMESTAMPLTZ(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   TIMESTAMPTZ getTIMESTAMPTZ(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 609 */     synchronized (this.connection)
/*     */     {
/* 611 */       this.lastIndex = paramInt2;
/* 612 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 613 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTIMESTAMPTZ(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   TIMESTAMP getTIMESTAMP(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 620 */     synchronized (this.connection)
/*     */     {
/* 622 */       this.lastIndex = paramInt2;
/* 623 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 624 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getTIMESTAMP(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   CustomDatum getCustomDatum(int paramInt1, int paramInt2, CustomDatumFactory paramCustomDatumFactory)
/*     */     throws SQLException
/*     */   {
/* 631 */     synchronized (this.connection)
/*     */     {
/* 633 */       this.lastIndex = paramInt2;
/* 634 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 635 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getCustomDatum(paramInt1 - this.indexOfFirstRow, paramCustomDatumFactory);
/*     */     }
/*     */   }
/*     */ 
/*     */   InputStream getAsciiStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 642 */     synchronized (this.connection)
/*     */     {
/* 644 */       this.lastIndex = paramInt2;
/* 645 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 646 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getAsciiStream(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   InputStream getBinaryStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 653 */     synchronized (this.connection)
/*     */     {
/* 655 */       this.lastIndex = paramInt2;
/* 656 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 657 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getBinaryStream(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Reader getCharacterStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 664 */     synchronized (this.connection)
/*     */     {
/* 666 */       this.lastIndex = paramInt2;
/* 667 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 668 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getCharacterStream(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   Reader getNCharacterStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 675 */     synchronized (this.connection)
/*     */     {
/* 677 */       this.lastIndex = paramInt2;
/* 678 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 679 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getNCharacterStream(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   InputStream getUnicodeStream(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 686 */     synchronized (this.connection)
/*     */     {
/* 688 */       this.lastIndex = paramInt2;
/* 689 */       if (this.streamList != null) closeUsedStreams(paramInt2);
/* 690 */       return this.accessors[(paramInt2 + this.offsetOfFirstUserColumn)].getUnicodeStream(paramInt1 - this.indexOfFirstRow);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 707 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.GeneratedStatement
 * JD-Core Version:    0.6.2
 */