/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.OPAQUE;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.REF;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ abstract class GeneratedScrollableResultSet extends OracleResultSet
/*      */ {
/*      */   protected OracleStatement statement;
/*      */   protected int currentRow;
/*      */   protected int fetchedRowCount;
/* 2259 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   GeneratedScrollableResultSet(PhysicalConnection paramPhysicalConnection, OracleStatement paramOracleStatement)
/*      */     throws SQLException
/*      */   {
/*   54 */     super(paramPhysicalConnection);
/*      */ 
/*   56 */     this.statement = paramOracleStatement;
/*   57 */     this.currentRow = -1;
/*   58 */     this.fetchedRowCount = 0;
/*      */   }
/*      */ 
/*      */   public Array getArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/*   79 */     return getARRAY(paramInt);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/*   85 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*   93 */       if (this.closed) {
/*   94 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBigDecimal");
/*   95 */         localSQLException.fillInStackTrace();
/*   96 */         throw localSQLException;
/*      */       }
/*   98 */       if (this.statement.closed) {
/*   99 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBigDecimal");
/*  100 */         localSQLException.fillInStackTrace();
/*  101 */         throw localSQLException;
/*      */       }
/*  103 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  105 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  106 */         localSQLException.fillInStackTrace();
/*  107 */         throw localSQLException;
/*      */       }
/*      */ 
/*  110 */       if (this.currentRow < 0) {
/*  111 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  112 */         localSQLException.fillInStackTrace();
/*  113 */         throw localSQLException;
/*      */       }
/*  115 */       if (this.currentRow == this.fetchedRowCount) {
/*  116 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  117 */         localSQLException.fillInStackTrace();
/*  118 */         throw localSQLException;
/*      */       }
/*  120 */       return this.statement.getBigDecimal(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  127 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  135 */       if (this.closed) {
/*  136 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBigDecimal");
/*  137 */         localSQLException.fillInStackTrace();
/*  138 */         throw localSQLException;
/*      */       }
/*  140 */       if (this.statement.closed) {
/*  141 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBigDecimal");
/*  142 */         localSQLException.fillInStackTrace();
/*  143 */         throw localSQLException;
/*      */       }
/*  145 */       if ((paramInt1 < 1) || (paramInt1 > this.statement.getNumberOfColumns()))
/*      */       {
/*  147 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  148 */         localSQLException.fillInStackTrace();
/*  149 */         throw localSQLException;
/*      */       }
/*      */ 
/*  152 */       if (this.currentRow < 0) {
/*  153 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  154 */         localSQLException.fillInStackTrace();
/*  155 */         throw localSQLException;
/*      */       }
/*  157 */       if (this.currentRow == this.fetchedRowCount) {
/*  158 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  159 */         localSQLException.fillInStackTrace();
/*  160 */         throw localSQLException;
/*      */       }
/*  162 */       return this.statement.getBigDecimal(this.currentRow, paramInt1, paramInt2);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  175 */     return getBLOB(paramInt);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  181 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  189 */       if (this.closed) {
/*  190 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBoolean");
/*  191 */         localSQLException.fillInStackTrace();
/*  192 */         throw localSQLException;
/*      */       }
/*  194 */       if (this.statement.closed) {
/*  195 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBoolean");
/*  196 */         localSQLException.fillInStackTrace();
/*  197 */         throw localSQLException;
/*      */       }
/*  199 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  201 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  202 */         localSQLException.fillInStackTrace();
/*  203 */         throw localSQLException;
/*      */       }
/*      */ 
/*  206 */       if (this.currentRow < 0) {
/*  207 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  208 */         localSQLException.fillInStackTrace();
/*  209 */         throw localSQLException;
/*      */       }
/*  211 */       if (this.currentRow == this.fetchedRowCount) {
/*  212 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  213 */         localSQLException.fillInStackTrace();
/*  214 */         throw localSQLException;
/*      */       }
/*  216 */       return this.statement.getBoolean(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  223 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  231 */       if (this.closed) {
/*  232 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getByte");
/*  233 */         localSQLException.fillInStackTrace();
/*  234 */         throw localSQLException;
/*      */       }
/*  236 */       if (this.statement.closed) {
/*  237 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getByte");
/*  238 */         localSQLException.fillInStackTrace();
/*  239 */         throw localSQLException;
/*      */       }
/*  241 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  243 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  244 */         localSQLException.fillInStackTrace();
/*  245 */         throw localSQLException;
/*      */       }
/*      */ 
/*  248 */       if (this.currentRow < 0) {
/*  249 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  250 */         localSQLException.fillInStackTrace();
/*  251 */         throw localSQLException;
/*      */       }
/*  253 */       if (this.currentRow == this.fetchedRowCount) {
/*  254 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  255 */         localSQLException.fillInStackTrace();
/*  256 */         throw localSQLException;
/*      */       }
/*  258 */       return this.statement.getByte(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  265 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  273 */       if (this.closed) {
/*  274 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBytes");
/*  275 */         localSQLException.fillInStackTrace();
/*  276 */         throw localSQLException;
/*      */       }
/*  278 */       if (this.statement.closed) {
/*  279 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBytes");
/*  280 */         localSQLException.fillInStackTrace();
/*  281 */         throw localSQLException;
/*      */       }
/*  283 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  285 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  286 */         localSQLException.fillInStackTrace();
/*  287 */         throw localSQLException;
/*      */       }
/*      */ 
/*  290 */       if (this.currentRow < 0) {
/*  291 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  292 */         localSQLException.fillInStackTrace();
/*  293 */         throw localSQLException;
/*      */       }
/*  295 */       if (this.currentRow == this.fetchedRowCount) {
/*  296 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  297 */         localSQLException.fillInStackTrace();
/*  298 */         throw localSQLException;
/*      */       }
/*  300 */       return this.statement.getBytes(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Clob getClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  313 */     return getCLOB(paramInt);
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  319 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  327 */       if (this.closed) {
/*  328 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getDate");
/*  329 */         localSQLException.fillInStackTrace();
/*  330 */         throw localSQLException;
/*      */       }
/*  332 */       if (this.statement.closed) {
/*  333 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getDate");
/*  334 */         localSQLException.fillInStackTrace();
/*  335 */         throw localSQLException;
/*      */       }
/*  337 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  339 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  340 */         localSQLException.fillInStackTrace();
/*  341 */         throw localSQLException;
/*      */       }
/*      */ 
/*  344 */       if (this.currentRow < 0) {
/*  345 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  346 */         localSQLException.fillInStackTrace();
/*  347 */         throw localSQLException;
/*      */       }
/*  349 */       if (this.currentRow == this.fetchedRowCount) {
/*  350 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  351 */         localSQLException.fillInStackTrace();
/*  352 */         throw localSQLException;
/*      */       }
/*  354 */       return this.statement.getDate(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  361 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  369 */       if (this.closed) {
/*  370 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getDate");
/*  371 */         localSQLException.fillInStackTrace();
/*  372 */         throw localSQLException;
/*      */       }
/*  374 */       if (this.statement.closed) {
/*  375 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getDate");
/*  376 */         localSQLException.fillInStackTrace();
/*  377 */         throw localSQLException;
/*      */       }
/*  379 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  381 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  382 */         localSQLException.fillInStackTrace();
/*  383 */         throw localSQLException;
/*      */       }
/*      */ 
/*  386 */       if (this.currentRow < 0) {
/*  387 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  388 */         localSQLException.fillInStackTrace();
/*  389 */         throw localSQLException;
/*      */       }
/*  391 */       if (this.currentRow == this.fetchedRowCount) {
/*  392 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  393 */         localSQLException.fillInStackTrace();
/*  394 */         throw localSQLException;
/*      */       }
/*  396 */       return this.statement.getDate(this.currentRow, paramInt, paramCalendar);
/*      */     }
/*      */   }
/*      */ 
/*      */   public double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  403 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  411 */       if (this.closed) {
/*  412 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getDouble");
/*  413 */         localSQLException.fillInStackTrace();
/*  414 */         throw localSQLException;
/*      */       }
/*  416 */       if (this.statement.closed) {
/*  417 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getDouble");
/*  418 */         localSQLException.fillInStackTrace();
/*  419 */         throw localSQLException;
/*      */       }
/*  421 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  423 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  424 */         localSQLException.fillInStackTrace();
/*  425 */         throw localSQLException;
/*      */       }
/*      */ 
/*  428 */       if (this.currentRow < 0) {
/*  429 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  430 */         localSQLException.fillInStackTrace();
/*  431 */         throw localSQLException;
/*      */       }
/*  433 */       if (this.currentRow == this.fetchedRowCount) {
/*  434 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  435 */         localSQLException.fillInStackTrace();
/*  436 */         throw localSQLException;
/*      */       }
/*  438 */       return this.statement.getDouble(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  445 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  453 */       if (this.closed) {
/*  454 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getFloat");
/*  455 */         localSQLException.fillInStackTrace();
/*  456 */         throw localSQLException;
/*      */       }
/*  458 */       if (this.statement.closed) {
/*  459 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getFloat");
/*  460 */         localSQLException.fillInStackTrace();
/*  461 */         throw localSQLException;
/*      */       }
/*  463 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  465 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  466 */         localSQLException.fillInStackTrace();
/*  467 */         throw localSQLException;
/*      */       }
/*      */ 
/*  470 */       if (this.currentRow < 0) {
/*  471 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  472 */         localSQLException.fillInStackTrace();
/*  473 */         throw localSQLException;
/*      */       }
/*  475 */       if (this.currentRow == this.fetchedRowCount) {
/*  476 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  477 */         localSQLException.fillInStackTrace();
/*  478 */         throw localSQLException;
/*      */       }
/*  480 */       return this.statement.getFloat(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  487 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  495 */       if (this.closed) {
/*  496 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getInt");
/*  497 */         localSQLException.fillInStackTrace();
/*  498 */         throw localSQLException;
/*      */       }
/*  500 */       if (this.statement.closed) {
/*  501 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getInt");
/*  502 */         localSQLException.fillInStackTrace();
/*  503 */         throw localSQLException;
/*      */       }
/*  505 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  507 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  508 */         localSQLException.fillInStackTrace();
/*  509 */         throw localSQLException;
/*      */       }
/*      */ 
/*  512 */       if (this.currentRow < 0) {
/*  513 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  514 */         localSQLException.fillInStackTrace();
/*  515 */         throw localSQLException;
/*      */       }
/*  517 */       if (this.currentRow == this.fetchedRowCount) {
/*  518 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  519 */         localSQLException.fillInStackTrace();
/*  520 */         throw localSQLException;
/*      */       }
/*  522 */       return this.statement.getInt(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  529 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  537 */       if (this.closed) {
/*  538 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getLong");
/*  539 */         localSQLException.fillInStackTrace();
/*  540 */         throw localSQLException;
/*      */       }
/*  542 */       if (this.statement.closed) {
/*  543 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getLong");
/*  544 */         localSQLException.fillInStackTrace();
/*  545 */         throw localSQLException;
/*      */       }
/*  547 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  549 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  550 */         localSQLException.fillInStackTrace();
/*  551 */         throw localSQLException;
/*      */       }
/*      */ 
/*  554 */       if (this.currentRow < 0) {
/*  555 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  556 */         localSQLException.fillInStackTrace();
/*  557 */         throw localSQLException;
/*      */       }
/*  559 */       if (this.currentRow == this.fetchedRowCount) {
/*  560 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  561 */         localSQLException.fillInStackTrace();
/*  562 */         throw localSQLException;
/*      */       }
/*  564 */       return this.statement.getLong(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  571 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  579 */       if (this.closed) {
/*  580 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getNClob");
/*  581 */         localSQLException.fillInStackTrace();
/*  582 */         throw localSQLException;
/*      */       }
/*  584 */       if (this.statement.closed) {
/*  585 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getNClob");
/*  586 */         localSQLException.fillInStackTrace();
/*  587 */         throw localSQLException;
/*      */       }
/*  589 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  591 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  592 */         localSQLException.fillInStackTrace();
/*  593 */         throw localSQLException;
/*      */       }
/*      */ 
/*  596 */       if (this.currentRow < 0) {
/*  597 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  598 */         localSQLException.fillInStackTrace();
/*  599 */         throw localSQLException;
/*      */       }
/*  601 */       if (this.currentRow == this.fetchedRowCount) {
/*  602 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  603 */         localSQLException.fillInStackTrace();
/*  604 */         throw localSQLException;
/*      */       }
/*  606 */       return this.statement.getNClob(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  613 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  621 */       if (this.closed) {
/*  622 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getNString");
/*  623 */         localSQLException.fillInStackTrace();
/*  624 */         throw localSQLException;
/*      */       }
/*  626 */       if (this.statement.closed) {
/*  627 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getNString");
/*  628 */         localSQLException.fillInStackTrace();
/*  629 */         throw localSQLException;
/*      */       }
/*  631 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  633 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  634 */         localSQLException.fillInStackTrace();
/*  635 */         throw localSQLException;
/*      */       }
/*      */ 
/*  638 */       if (this.currentRow < 0) {
/*  639 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  640 */         localSQLException.fillInStackTrace();
/*  641 */         throw localSQLException;
/*      */       }
/*  643 */       if (this.currentRow == this.fetchedRowCount) {
/*  644 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  645 */         localSQLException.fillInStackTrace();
/*  646 */         throw localSQLException;
/*      */       }
/*  648 */       return this.statement.getNString(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  655 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  663 */       if (this.closed) {
/*  664 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getObject");
/*  665 */         localSQLException.fillInStackTrace();
/*  666 */         throw localSQLException;
/*      */       }
/*  668 */       if (this.statement.closed) {
/*  669 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getObject");
/*  670 */         localSQLException.fillInStackTrace();
/*  671 */         throw localSQLException;
/*      */       }
/*  673 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  675 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  676 */         localSQLException.fillInStackTrace();
/*  677 */         throw localSQLException;
/*      */       }
/*      */ 
/*  680 */       if (this.currentRow < 0) {
/*  681 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  682 */         localSQLException.fillInStackTrace();
/*  683 */         throw localSQLException;
/*      */       }
/*  685 */       if (this.currentRow == this.fetchedRowCount) {
/*  686 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  687 */         localSQLException.fillInStackTrace();
/*  688 */         throw localSQLException;
/*      */       }
/*  690 */       return this.statement.getObject(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  697 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  705 */       if (this.closed) {
/*  706 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getObject");
/*  707 */         localSQLException.fillInStackTrace();
/*  708 */         throw localSQLException;
/*      */       }
/*  710 */       if (this.statement.closed) {
/*  711 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getObject");
/*  712 */         localSQLException.fillInStackTrace();
/*  713 */         throw localSQLException;
/*      */       }
/*  715 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  717 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  718 */         localSQLException.fillInStackTrace();
/*  719 */         throw localSQLException;
/*      */       }
/*      */ 
/*  722 */       if (this.currentRow < 0) {
/*  723 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  724 */         localSQLException.fillInStackTrace();
/*  725 */         throw localSQLException;
/*      */       }
/*  727 */       if (this.currentRow == this.fetchedRowCount) {
/*  728 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  729 */         localSQLException.fillInStackTrace();
/*  730 */         throw localSQLException;
/*      */       }
/*  732 */       return this.statement.getObject(this.currentRow, paramInt, paramMap);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Ref getRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  745 */     return getREF(paramInt);
/*      */   }
/*      */ 
/*      */   public RowId getRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  757 */     return getROWID(paramInt);
/*      */   }
/*      */ 
/*      */   public short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  763 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  771 */       if (this.closed) {
/*  772 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getShort");
/*  773 */         localSQLException.fillInStackTrace();
/*  774 */         throw localSQLException;
/*      */       }
/*  776 */       if (this.statement.closed) {
/*  777 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getShort");
/*  778 */         localSQLException.fillInStackTrace();
/*  779 */         throw localSQLException;
/*      */       }
/*  781 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  783 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  784 */         localSQLException.fillInStackTrace();
/*  785 */         throw localSQLException;
/*      */       }
/*      */ 
/*  788 */       if (this.currentRow < 0) {
/*  789 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  790 */         localSQLException.fillInStackTrace();
/*  791 */         throw localSQLException;
/*      */       }
/*  793 */       if (this.currentRow == this.fetchedRowCount) {
/*  794 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  795 */         localSQLException.fillInStackTrace();
/*  796 */         throw localSQLException;
/*      */       }
/*  798 */       return this.statement.getShort(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  805 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  813 */       if (this.closed) {
/*  814 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getSQLXML");
/*  815 */         localSQLException.fillInStackTrace();
/*  816 */         throw localSQLException;
/*      */       }
/*  818 */       if (this.statement.closed) {
/*  819 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getSQLXML");
/*  820 */         localSQLException.fillInStackTrace();
/*  821 */         throw localSQLException;
/*      */       }
/*  823 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  825 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  826 */         localSQLException.fillInStackTrace();
/*  827 */         throw localSQLException;
/*      */       }
/*      */ 
/*  830 */       if (this.currentRow < 0) {
/*  831 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  832 */         localSQLException.fillInStackTrace();
/*  833 */         throw localSQLException;
/*      */       }
/*  835 */       if (this.currentRow == this.fetchedRowCount) {
/*  836 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  837 */         localSQLException.fillInStackTrace();
/*  838 */         throw localSQLException;
/*      */       }
/*  840 */       return this.statement.getSQLXML(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  847 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  855 */       if (this.closed) {
/*  856 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getString");
/*  857 */         localSQLException.fillInStackTrace();
/*  858 */         throw localSQLException;
/*      */       }
/*  860 */       if (this.statement.closed) {
/*  861 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getString");
/*  862 */         localSQLException.fillInStackTrace();
/*  863 */         throw localSQLException;
/*      */       }
/*  865 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  867 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  868 */         localSQLException.fillInStackTrace();
/*  869 */         throw localSQLException;
/*      */       }
/*      */ 
/*  872 */       if (this.currentRow < 0) {
/*  873 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  874 */         localSQLException.fillInStackTrace();
/*  875 */         throw localSQLException;
/*      */       }
/*  877 */       if (this.currentRow == this.fetchedRowCount) {
/*  878 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  879 */         localSQLException.fillInStackTrace();
/*  880 */         throw localSQLException;
/*      */       }
/*  882 */       return this.statement.getString(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  889 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  897 */       if (this.closed) {
/*  898 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTime");
/*  899 */         localSQLException.fillInStackTrace();
/*  900 */         throw localSQLException;
/*      */       }
/*  902 */       if (this.statement.closed) {
/*  903 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTime");
/*  904 */         localSQLException.fillInStackTrace();
/*  905 */         throw localSQLException;
/*      */       }
/*  907 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  909 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  910 */         localSQLException.fillInStackTrace();
/*  911 */         throw localSQLException;
/*      */       }
/*      */ 
/*  914 */       if (this.currentRow < 0) {
/*  915 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  916 */         localSQLException.fillInStackTrace();
/*  917 */         throw localSQLException;
/*      */       }
/*  919 */       if (this.currentRow == this.fetchedRowCount) {
/*  920 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  921 */         localSQLException.fillInStackTrace();
/*  922 */         throw localSQLException;
/*      */       }
/*  924 */       return this.statement.getTime(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  931 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  939 */       if (this.closed) {
/*  940 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTime");
/*  941 */         localSQLException.fillInStackTrace();
/*  942 */         throw localSQLException;
/*      */       }
/*  944 */       if (this.statement.closed) {
/*  945 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTime");
/*  946 */         localSQLException.fillInStackTrace();
/*  947 */         throw localSQLException;
/*      */       }
/*  949 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  951 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  952 */         localSQLException.fillInStackTrace();
/*  953 */         throw localSQLException;
/*      */       }
/*      */ 
/*  956 */       if (this.currentRow < 0) {
/*  957 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/*  958 */         localSQLException.fillInStackTrace();
/*  959 */         throw localSQLException;
/*      */       }
/*  961 */       if (this.currentRow == this.fetchedRowCount) {
/*  962 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/*  963 */         localSQLException.fillInStackTrace();
/*  964 */         throw localSQLException;
/*      */       }
/*  966 */       return this.statement.getTime(this.currentRow, paramInt, paramCalendar);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  973 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/*  981 */       if (this.closed) {
/*  982 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTimestamp");
/*  983 */         localSQLException.fillInStackTrace();
/*  984 */         throw localSQLException;
/*      */       }
/*  986 */       if (this.statement.closed) {
/*  987 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTimestamp");
/*  988 */         localSQLException.fillInStackTrace();
/*  989 */         throw localSQLException;
/*      */       }
/*  991 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/*  993 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/*  994 */         localSQLException.fillInStackTrace();
/*  995 */         throw localSQLException;
/*      */       }
/*      */ 
/*  998 */       if (this.currentRow < 0) {
/*  999 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1000 */         localSQLException.fillInStackTrace();
/* 1001 */         throw localSQLException;
/*      */       }
/* 1003 */       if (this.currentRow == this.fetchedRowCount) {
/* 1004 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1005 */         localSQLException.fillInStackTrace();
/* 1006 */         throw localSQLException;
/*      */       }
/* 1008 */       return this.statement.getTimestamp(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1015 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1023 */       if (this.closed) {
/* 1024 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTimestamp");
/* 1025 */         localSQLException.fillInStackTrace();
/* 1026 */         throw localSQLException;
/*      */       }
/* 1028 */       if (this.statement.closed) {
/* 1029 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTimestamp");
/* 1030 */         localSQLException.fillInStackTrace();
/* 1031 */         throw localSQLException;
/*      */       }
/* 1033 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1035 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1036 */         localSQLException.fillInStackTrace();
/* 1037 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1040 */       if (this.currentRow < 0) {
/* 1041 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1042 */         localSQLException.fillInStackTrace();
/* 1043 */         throw localSQLException;
/*      */       }
/* 1045 */       if (this.currentRow == this.fetchedRowCount) {
/* 1046 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1047 */         localSQLException.fillInStackTrace();
/* 1048 */         throw localSQLException;
/*      */       }
/* 1050 */       return this.statement.getTimestamp(this.currentRow, paramInt, paramCalendar);
/*      */     }
/*      */   }
/*      */ 
/*      */   public URL getURL(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1057 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1065 */       if (this.closed) {
/* 1066 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getURL");
/* 1067 */         localSQLException.fillInStackTrace();
/* 1068 */         throw localSQLException;
/*      */       }
/* 1070 */       if (this.statement.closed) {
/* 1071 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getURL");
/* 1072 */         localSQLException.fillInStackTrace();
/* 1073 */         throw localSQLException;
/*      */       }
/* 1075 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1077 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1078 */         localSQLException.fillInStackTrace();
/* 1079 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1082 */       if (this.currentRow < 0) {
/* 1083 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1084 */         localSQLException.fillInStackTrace();
/* 1085 */         throw localSQLException;
/*      */       }
/* 1087 */       if (this.currentRow == this.fetchedRowCount) {
/* 1088 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1089 */         localSQLException.fillInStackTrace();
/* 1090 */         throw localSQLException;
/*      */       }
/* 1092 */       return this.statement.getURL(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ARRAY getARRAY(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1099 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1107 */       if (this.closed) {
/* 1108 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getARRAY");
/* 1109 */         localSQLException.fillInStackTrace();
/* 1110 */         throw localSQLException;
/*      */       }
/* 1112 */       if (this.statement.closed) {
/* 1113 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getARRAY");
/* 1114 */         localSQLException.fillInStackTrace();
/* 1115 */         throw localSQLException;
/*      */       }
/* 1117 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1119 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1120 */         localSQLException.fillInStackTrace();
/* 1121 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1124 */       if (this.currentRow < 0) {
/* 1125 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1126 */         localSQLException.fillInStackTrace();
/* 1127 */         throw localSQLException;
/*      */       }
/* 1129 */       if (this.currentRow == this.fetchedRowCount) {
/* 1130 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1131 */         localSQLException.fillInStackTrace();
/* 1132 */         throw localSQLException;
/*      */       }
/* 1134 */       return this.statement.getARRAY(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public BFILE getBFILE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1141 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1149 */       if (this.closed) {
/* 1150 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBFILE");
/* 1151 */         localSQLException.fillInStackTrace();
/* 1152 */         throw localSQLException;
/*      */       }
/* 1154 */       if (this.statement.closed) {
/* 1155 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBFILE");
/* 1156 */         localSQLException.fillInStackTrace();
/* 1157 */         throw localSQLException;
/*      */       }
/* 1159 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1161 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1162 */         localSQLException.fillInStackTrace();
/* 1163 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1166 */       if (this.currentRow < 0) {
/* 1167 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1168 */         localSQLException.fillInStackTrace();
/* 1169 */         throw localSQLException;
/*      */       }
/* 1171 */       if (this.currentRow == this.fetchedRowCount) {
/* 1172 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1173 */         localSQLException.fillInStackTrace();
/* 1174 */         throw localSQLException;
/*      */       }
/* 1176 */       return this.statement.getBFILE(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public BFILE getBfile(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1189 */     return getBFILE(paramInt);
/*      */   }
/*      */ 
/*      */   public BLOB getBLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1195 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1203 */       if (this.closed) {
/* 1204 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBLOB");
/* 1205 */         localSQLException.fillInStackTrace();
/* 1206 */         throw localSQLException;
/*      */       }
/* 1208 */       if (this.statement.closed) {
/* 1209 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBLOB");
/* 1210 */         localSQLException.fillInStackTrace();
/* 1211 */         throw localSQLException;
/*      */       }
/* 1213 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1215 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1216 */         localSQLException.fillInStackTrace();
/* 1217 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1220 */       if (this.currentRow < 0) {
/* 1221 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1222 */         localSQLException.fillInStackTrace();
/* 1223 */         throw localSQLException;
/*      */       }
/* 1225 */       if (this.currentRow == this.fetchedRowCount) {
/* 1226 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1227 */         localSQLException.fillInStackTrace();
/* 1228 */         throw localSQLException;
/*      */       }
/* 1230 */       return this.statement.getBLOB(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public CHAR getCHAR(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1237 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1245 */       if (this.closed) {
/* 1246 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getCHAR");
/* 1247 */         localSQLException.fillInStackTrace();
/* 1248 */         throw localSQLException;
/*      */       }
/* 1250 */       if (this.statement.closed) {
/* 1251 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getCHAR");
/* 1252 */         localSQLException.fillInStackTrace();
/* 1253 */         throw localSQLException;
/*      */       }
/* 1255 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1257 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1258 */         localSQLException.fillInStackTrace();
/* 1259 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1262 */       if (this.currentRow < 0) {
/* 1263 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1264 */         localSQLException.fillInStackTrace();
/* 1265 */         throw localSQLException;
/*      */       }
/* 1267 */       if (this.currentRow == this.fetchedRowCount) {
/* 1268 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1269 */         localSQLException.fillInStackTrace();
/* 1270 */         throw localSQLException;
/*      */       }
/* 1272 */       return this.statement.getCHAR(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public CLOB getCLOB(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1279 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1287 */       if (this.closed) {
/* 1288 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getCLOB");
/* 1289 */         localSQLException.fillInStackTrace();
/* 1290 */         throw localSQLException;
/*      */       }
/* 1292 */       if (this.statement.closed) {
/* 1293 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getCLOB");
/* 1294 */         localSQLException.fillInStackTrace();
/* 1295 */         throw localSQLException;
/*      */       }
/* 1297 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1299 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1300 */         localSQLException.fillInStackTrace();
/* 1301 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1304 */       if (this.currentRow < 0) {
/* 1305 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1306 */         localSQLException.fillInStackTrace();
/* 1307 */         throw localSQLException;
/*      */       }
/* 1309 */       if (this.currentRow == this.fetchedRowCount) {
/* 1310 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1311 */         localSQLException.fillInStackTrace();
/* 1312 */         throw localSQLException;
/*      */       }
/* 1314 */       return this.statement.getCLOB(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getCursor(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1321 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1329 */       if (this.closed) {
/* 1330 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getCursor");
/* 1331 */         localSQLException.fillInStackTrace();
/* 1332 */         throw localSQLException;
/*      */       }
/* 1334 */       if (this.statement.closed) {
/* 1335 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getCursor");
/* 1336 */         localSQLException.fillInStackTrace();
/* 1337 */         throw localSQLException;
/*      */       }
/* 1339 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1341 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1342 */         localSQLException.fillInStackTrace();
/* 1343 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1346 */       if (this.currentRow < 0) {
/* 1347 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1348 */         localSQLException.fillInStackTrace();
/* 1349 */         throw localSQLException;
/*      */       }
/* 1351 */       if (this.currentRow == this.fetchedRowCount) {
/* 1352 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1353 */         localSQLException.fillInStackTrace();
/* 1354 */         throw localSQLException;
/*      */       }
/* 1356 */       return this.statement.getCursor(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public DATE getDATE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1363 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1371 */       if (this.closed) {
/* 1372 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getDATE");
/* 1373 */         localSQLException.fillInStackTrace();
/* 1374 */         throw localSQLException;
/*      */       }
/* 1376 */       if (this.statement.closed) {
/* 1377 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getDATE");
/* 1378 */         localSQLException.fillInStackTrace();
/* 1379 */         throw localSQLException;
/*      */       }
/* 1381 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1383 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1384 */         localSQLException.fillInStackTrace();
/* 1385 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1388 */       if (this.currentRow < 0) {
/* 1389 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1390 */         localSQLException.fillInStackTrace();
/* 1391 */         throw localSQLException;
/*      */       }
/* 1393 */       if (this.currentRow == this.fetchedRowCount) {
/* 1394 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1395 */         localSQLException.fillInStackTrace();
/* 1396 */         throw localSQLException;
/*      */       }
/* 1398 */       return this.statement.getDATE(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public INTERVALDS getINTERVALDS(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1405 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1413 */       if (this.closed) {
/* 1414 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getINTERVALDS");
/* 1415 */         localSQLException.fillInStackTrace();
/* 1416 */         throw localSQLException;
/*      */       }
/* 1418 */       if (this.statement.closed) {
/* 1419 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getINTERVALDS");
/* 1420 */         localSQLException.fillInStackTrace();
/* 1421 */         throw localSQLException;
/*      */       }
/* 1423 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1425 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1426 */         localSQLException.fillInStackTrace();
/* 1427 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1430 */       if (this.currentRow < 0) {
/* 1431 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1432 */         localSQLException.fillInStackTrace();
/* 1433 */         throw localSQLException;
/*      */       }
/* 1435 */       if (this.currentRow == this.fetchedRowCount) {
/* 1436 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1437 */         localSQLException.fillInStackTrace();
/* 1438 */         throw localSQLException;
/*      */       }
/* 1440 */       return this.statement.getINTERVALDS(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public INTERVALYM getINTERVALYM(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1447 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1455 */       if (this.closed) {
/* 1456 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getINTERVALYM");
/* 1457 */         localSQLException.fillInStackTrace();
/* 1458 */         throw localSQLException;
/*      */       }
/* 1460 */       if (this.statement.closed) {
/* 1461 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getINTERVALYM");
/* 1462 */         localSQLException.fillInStackTrace();
/* 1463 */         throw localSQLException;
/*      */       }
/* 1465 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1467 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1468 */         localSQLException.fillInStackTrace();
/* 1469 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1472 */       if (this.currentRow < 0) {
/* 1473 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1474 */         localSQLException.fillInStackTrace();
/* 1475 */         throw localSQLException;
/*      */       }
/* 1477 */       if (this.currentRow == this.fetchedRowCount) {
/* 1478 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1479 */         localSQLException.fillInStackTrace();
/* 1480 */         throw localSQLException;
/*      */       }
/* 1482 */       return this.statement.getINTERVALYM(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public NUMBER getNUMBER(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1489 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1497 */       if (this.closed) {
/* 1498 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getNUMBER");
/* 1499 */         localSQLException.fillInStackTrace();
/* 1500 */         throw localSQLException;
/*      */       }
/* 1502 */       if (this.statement.closed) {
/* 1503 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getNUMBER");
/* 1504 */         localSQLException.fillInStackTrace();
/* 1505 */         throw localSQLException;
/*      */       }
/* 1507 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1509 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1510 */         localSQLException.fillInStackTrace();
/* 1511 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1514 */       if (this.currentRow < 0) {
/* 1515 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1516 */         localSQLException.fillInStackTrace();
/* 1517 */         throw localSQLException;
/*      */       }
/* 1519 */       if (this.currentRow == this.fetchedRowCount) {
/* 1520 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1521 */         localSQLException.fillInStackTrace();
/* 1522 */         throw localSQLException;
/*      */       }
/* 1524 */       return this.statement.getNUMBER(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public OPAQUE getOPAQUE(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1531 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1539 */       if (this.closed) {
/* 1540 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getOPAQUE");
/* 1541 */         localSQLException.fillInStackTrace();
/* 1542 */         throw localSQLException;
/*      */       }
/* 1544 */       if (this.statement.closed) {
/* 1545 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getOPAQUE");
/* 1546 */         localSQLException.fillInStackTrace();
/* 1547 */         throw localSQLException;
/*      */       }
/* 1549 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1551 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1552 */         localSQLException.fillInStackTrace();
/* 1553 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1556 */       if (this.currentRow < 0) {
/* 1557 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1558 */         localSQLException.fillInStackTrace();
/* 1559 */         throw localSQLException;
/*      */       }
/* 1561 */       if (this.currentRow == this.fetchedRowCount) {
/* 1562 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1563 */         localSQLException.fillInStackTrace();
/* 1564 */         throw localSQLException;
/*      */       }
/* 1566 */       return this.statement.getOPAQUE(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Datum getOracleObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1573 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1581 */       if (this.closed) {
/* 1582 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getOracleObject");
/* 1583 */         localSQLException.fillInStackTrace();
/* 1584 */         throw localSQLException;
/*      */       }
/* 1586 */       if (this.statement.closed) {
/* 1587 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getOracleObject");
/* 1588 */         localSQLException.fillInStackTrace();
/* 1589 */         throw localSQLException;
/*      */       }
/* 1591 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1593 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1594 */         localSQLException.fillInStackTrace();
/* 1595 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1598 */       if (this.currentRow < 0) {
/* 1599 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1600 */         localSQLException.fillInStackTrace();
/* 1601 */         throw localSQLException;
/*      */       }
/* 1603 */       if (this.currentRow == this.fetchedRowCount) {
/* 1604 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1605 */         localSQLException.fillInStackTrace();
/* 1606 */         throw localSQLException;
/*      */       }
/* 1608 */       return this.statement.getOracleObject(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ORAData getORAData(int paramInt, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/* 1615 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1623 */       if (this.closed) {
/* 1624 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getORAData");
/* 1625 */         localSQLException.fillInStackTrace();
/* 1626 */         throw localSQLException;
/*      */       }
/* 1628 */       if (this.statement.closed) {
/* 1629 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getORAData");
/* 1630 */         localSQLException.fillInStackTrace();
/* 1631 */         throw localSQLException;
/*      */       }
/* 1633 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1635 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1636 */         localSQLException.fillInStackTrace();
/* 1637 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1640 */       if (this.currentRow < 0) {
/* 1641 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1642 */         localSQLException.fillInStackTrace();
/* 1643 */         throw localSQLException;
/*      */       }
/* 1645 */       if (this.currentRow == this.fetchedRowCount) {
/* 1646 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1647 */         localSQLException.fillInStackTrace();
/* 1648 */         throw localSQLException;
/*      */       }
/* 1650 */       return this.statement.getORAData(this.currentRow, paramInt, paramORADataFactory);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/* 1657 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1665 */       if (this.closed) {
/* 1666 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getObject");
/* 1667 */         localSQLException.fillInStackTrace();
/* 1668 */         throw localSQLException;
/*      */       }
/* 1670 */       if (this.statement.closed) {
/* 1671 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getObject");
/* 1672 */         localSQLException.fillInStackTrace();
/* 1673 */         throw localSQLException;
/*      */       }
/* 1675 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1677 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1678 */         localSQLException.fillInStackTrace();
/* 1679 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1682 */       if (this.currentRow < 0) {
/* 1683 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1684 */         localSQLException.fillInStackTrace();
/* 1685 */         throw localSQLException;
/*      */       }
/* 1687 */       if (this.currentRow == this.fetchedRowCount) {
/* 1688 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1689 */         localSQLException.fillInStackTrace();
/* 1690 */         throw localSQLException;
/*      */       }
/* 1692 */       return this.statement.getObject(this.currentRow, paramInt, paramOracleDataFactory);
/*      */     }
/*      */   }
/*      */ 
/*      */   public RAW getRAW(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1699 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1707 */       if (this.closed) {
/* 1708 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getRAW");
/* 1709 */         localSQLException.fillInStackTrace();
/* 1710 */         throw localSQLException;
/*      */       }
/* 1712 */       if (this.statement.closed) {
/* 1713 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getRAW");
/* 1714 */         localSQLException.fillInStackTrace();
/* 1715 */         throw localSQLException;
/*      */       }
/* 1717 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1719 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1720 */         localSQLException.fillInStackTrace();
/* 1721 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1724 */       if (this.currentRow < 0) {
/* 1725 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1726 */         localSQLException.fillInStackTrace();
/* 1727 */         throw localSQLException;
/*      */       }
/* 1729 */       if (this.currentRow == this.fetchedRowCount) {
/* 1730 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1731 */         localSQLException.fillInStackTrace();
/* 1732 */         throw localSQLException;
/*      */       }
/* 1734 */       return this.statement.getRAW(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public REF getREF(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1741 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1749 */       if (this.closed) {
/* 1750 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getREF");
/* 1751 */         localSQLException.fillInStackTrace();
/* 1752 */         throw localSQLException;
/*      */       }
/* 1754 */       if (this.statement.closed) {
/* 1755 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getREF");
/* 1756 */         localSQLException.fillInStackTrace();
/* 1757 */         throw localSQLException;
/*      */       }
/* 1759 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1761 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1762 */         localSQLException.fillInStackTrace();
/* 1763 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1766 */       if (this.currentRow < 0) {
/* 1767 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1768 */         localSQLException.fillInStackTrace();
/* 1769 */         throw localSQLException;
/*      */       }
/* 1771 */       if (this.currentRow == this.fetchedRowCount) {
/* 1772 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1773 */         localSQLException.fillInStackTrace();
/* 1774 */         throw localSQLException;
/*      */       }
/* 1776 */       return this.statement.getREF(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ROWID getROWID(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1783 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1791 */       if (this.closed) {
/* 1792 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getROWID");
/* 1793 */         localSQLException.fillInStackTrace();
/* 1794 */         throw localSQLException;
/*      */       }
/* 1796 */       if (this.statement.closed) {
/* 1797 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getROWID");
/* 1798 */         localSQLException.fillInStackTrace();
/* 1799 */         throw localSQLException;
/*      */       }
/* 1801 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1803 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1804 */         localSQLException.fillInStackTrace();
/* 1805 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1808 */       if (this.currentRow < 0) {
/* 1809 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1810 */         localSQLException.fillInStackTrace();
/* 1811 */         throw localSQLException;
/*      */       }
/* 1813 */       if (this.currentRow == this.fetchedRowCount) {
/* 1814 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1815 */         localSQLException.fillInStackTrace();
/* 1816 */         throw localSQLException;
/*      */       }
/* 1818 */       return this.statement.getROWID(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public STRUCT getSTRUCT(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1825 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1833 */       if (this.closed) {
/* 1834 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getSTRUCT");
/* 1835 */         localSQLException.fillInStackTrace();
/* 1836 */         throw localSQLException;
/*      */       }
/* 1838 */       if (this.statement.closed) {
/* 1839 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getSTRUCT");
/* 1840 */         localSQLException.fillInStackTrace();
/* 1841 */         throw localSQLException;
/*      */       }
/* 1843 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1845 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1846 */         localSQLException.fillInStackTrace();
/* 1847 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1850 */       if (this.currentRow < 0) {
/* 1851 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1852 */         localSQLException.fillInStackTrace();
/* 1853 */         throw localSQLException;
/*      */       }
/* 1855 */       if (this.currentRow == this.fetchedRowCount) {
/* 1856 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1857 */         localSQLException.fillInStackTrace();
/* 1858 */         throw localSQLException;
/*      */       }
/* 1860 */       return this.statement.getSTRUCT(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1867 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1875 */       if (this.closed) {
/* 1876 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTIMESTAMPLTZ");
/* 1877 */         localSQLException.fillInStackTrace();
/* 1878 */         throw localSQLException;
/*      */       }
/* 1880 */       if (this.statement.closed) {
/* 1881 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTIMESTAMPLTZ");
/* 1882 */         localSQLException.fillInStackTrace();
/* 1883 */         throw localSQLException;
/*      */       }
/* 1885 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1887 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1888 */         localSQLException.fillInStackTrace();
/* 1889 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1892 */       if (this.currentRow < 0) {
/* 1893 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1894 */         localSQLException.fillInStackTrace();
/* 1895 */         throw localSQLException;
/*      */       }
/* 1897 */       if (this.currentRow == this.fetchedRowCount) {
/* 1898 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1899 */         localSQLException.fillInStackTrace();
/* 1900 */         throw localSQLException;
/*      */       }
/* 1902 */       return this.statement.getTIMESTAMPLTZ(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ getTIMESTAMPTZ(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1909 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1917 */       if (this.closed) {
/* 1918 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTIMESTAMPTZ");
/* 1919 */         localSQLException.fillInStackTrace();
/* 1920 */         throw localSQLException;
/*      */       }
/* 1922 */       if (this.statement.closed) {
/* 1923 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTIMESTAMPTZ");
/* 1924 */         localSQLException.fillInStackTrace();
/* 1925 */         throw localSQLException;
/*      */       }
/* 1927 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1929 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1930 */         localSQLException.fillInStackTrace();
/* 1931 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1934 */       if (this.currentRow < 0) {
/* 1935 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1936 */         localSQLException.fillInStackTrace();
/* 1937 */         throw localSQLException;
/*      */       }
/* 1939 */       if (this.currentRow == this.fetchedRowCount) {
/* 1940 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1941 */         localSQLException.fillInStackTrace();
/* 1942 */         throw localSQLException;
/*      */       }
/* 1944 */       return this.statement.getTIMESTAMPTZ(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public TIMESTAMP getTIMESTAMP(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1951 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 1959 */       if (this.closed) {
/* 1960 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getTIMESTAMP");
/* 1961 */         localSQLException.fillInStackTrace();
/* 1962 */         throw localSQLException;
/*      */       }
/* 1964 */       if (this.statement.closed) {
/* 1965 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getTIMESTAMP");
/* 1966 */         localSQLException.fillInStackTrace();
/* 1967 */         throw localSQLException;
/*      */       }
/* 1969 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 1971 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 1972 */         localSQLException.fillInStackTrace();
/* 1973 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1976 */       if (this.currentRow < 0) {
/* 1977 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 1978 */         localSQLException.fillInStackTrace();
/* 1979 */         throw localSQLException;
/*      */       }
/* 1981 */       if (this.currentRow == this.fetchedRowCount) {
/* 1982 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 1983 */         localSQLException.fillInStackTrace();
/* 1984 */         throw localSQLException;
/*      */       }
/* 1986 */       return this.statement.getTIMESTAMP(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public CustomDatum getCustomDatum(int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */     throws SQLException
/*      */   {
/* 1993 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 2001 */       if (this.closed) {
/* 2002 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getCustomDatum");
/* 2003 */         localSQLException.fillInStackTrace();
/* 2004 */         throw localSQLException;
/*      */       }
/* 2006 */       if (this.statement.closed) {
/* 2007 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getCustomDatum");
/* 2008 */         localSQLException.fillInStackTrace();
/* 2009 */         throw localSQLException;
/*      */       }
/* 2011 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 2013 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2014 */         localSQLException.fillInStackTrace();
/* 2015 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2018 */       if (this.currentRow < 0) {
/* 2019 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 2020 */         localSQLException.fillInStackTrace();
/* 2021 */         throw localSQLException;
/*      */       }
/* 2023 */       if (this.currentRow == this.fetchedRowCount) {
/* 2024 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 2025 */         localSQLException.fillInStackTrace();
/* 2026 */         throw localSQLException;
/*      */       }
/* 2028 */       return this.statement.getCustomDatum(this.currentRow, paramInt, paramCustomDatumFactory);
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2035 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 2043 */       if (this.closed) {
/* 2044 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getAsciiStream");
/* 2045 */         localSQLException.fillInStackTrace();
/* 2046 */         throw localSQLException;
/*      */       }
/* 2048 */       if (this.statement.closed) {
/* 2049 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getAsciiStream");
/* 2050 */         localSQLException.fillInStackTrace();
/* 2051 */         throw localSQLException;
/*      */       }
/* 2053 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 2055 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2056 */         localSQLException.fillInStackTrace();
/* 2057 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2060 */       if (this.currentRow < 0) {
/* 2061 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 2062 */         localSQLException.fillInStackTrace();
/* 2063 */         throw localSQLException;
/*      */       }
/* 2065 */       if (this.currentRow == this.fetchedRowCount) {
/* 2066 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 2067 */         localSQLException.fillInStackTrace();
/* 2068 */         throw localSQLException;
/*      */       }
/* 2070 */       return this.statement.getAsciiStream(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2077 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 2085 */       if (this.closed) {
/* 2086 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getBinaryStream");
/* 2087 */         localSQLException.fillInStackTrace();
/* 2088 */         throw localSQLException;
/*      */       }
/* 2090 */       if (this.statement.closed) {
/* 2091 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getBinaryStream");
/* 2092 */         localSQLException.fillInStackTrace();
/* 2093 */         throw localSQLException;
/*      */       }
/* 2095 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 2097 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2098 */         localSQLException.fillInStackTrace();
/* 2099 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2102 */       if (this.currentRow < 0) {
/* 2103 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 2104 */         localSQLException.fillInStackTrace();
/* 2105 */         throw localSQLException;
/*      */       }
/* 2107 */       if (this.currentRow == this.fetchedRowCount) {
/* 2108 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 2109 */         localSQLException.fillInStackTrace();
/* 2110 */         throw localSQLException;
/*      */       }
/* 2112 */       return this.statement.getBinaryStream(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2119 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 2127 */       if (this.closed) {
/* 2128 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getCharacterStream");
/* 2129 */         localSQLException.fillInStackTrace();
/* 2130 */         throw localSQLException;
/*      */       }
/* 2132 */       if (this.statement.closed) {
/* 2133 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getCharacterStream");
/* 2134 */         localSQLException.fillInStackTrace();
/* 2135 */         throw localSQLException;
/*      */       }
/* 2137 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 2139 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2140 */         localSQLException.fillInStackTrace();
/* 2141 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2144 */       if (this.currentRow < 0) {
/* 2145 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 2146 */         localSQLException.fillInStackTrace();
/* 2147 */         throw localSQLException;
/*      */       }
/* 2149 */       if (this.currentRow == this.fetchedRowCount) {
/* 2150 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 2151 */         localSQLException.fillInStackTrace();
/* 2152 */         throw localSQLException;
/*      */       }
/* 2154 */       return this.statement.getCharacterStream(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2161 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 2169 */       if (this.closed) {
/* 2170 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getNCharacterStream");
/* 2171 */         localSQLException.fillInStackTrace();
/* 2172 */         throw localSQLException;
/*      */       }
/* 2174 */       if (this.statement.closed) {
/* 2175 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getNCharacterStream");
/* 2176 */         localSQLException.fillInStackTrace();
/* 2177 */         throw localSQLException;
/*      */       }
/* 2179 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 2181 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2182 */         localSQLException.fillInStackTrace();
/* 2183 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2186 */       if (this.currentRow < 0) {
/* 2187 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 2188 */         localSQLException.fillInStackTrace();
/* 2189 */         throw localSQLException;
/*      */       }
/* 2191 */       if (this.currentRow == this.fetchedRowCount) {
/* 2192 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 2193 */         localSQLException.fillInStackTrace();
/* 2194 */         throw localSQLException;
/*      */       }
/* 2196 */       return this.statement.getNCharacterStream(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2203 */     synchronized (this.connection)
/*      */     {
/*      */       SQLException localSQLException;
/* 2211 */       if (this.closed) {
/* 2212 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10, "getUnicodeStream");
/* 2213 */         localSQLException.fillInStackTrace();
/* 2214 */         throw localSQLException;
/*      */       }
/* 2216 */       if (this.statement.closed) {
/* 2217 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 9, "getUnicodeStream");
/* 2218 */         localSQLException.fillInStackTrace();
/* 2219 */         throw localSQLException;
/*      */       }
/* 2221 */       if ((paramInt < 1) || (paramInt > this.statement.getNumberOfColumns()))
/*      */       {
/* 2223 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3);
/* 2224 */         localSQLException.fillInStackTrace();
/* 2225 */         throw localSQLException;
/*      */       }
/*      */ 
/* 2228 */       if (this.currentRow < 0) {
/* 2229 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 14);
/* 2230 */         localSQLException.fillInStackTrace();
/* 2231 */         throw localSQLException;
/*      */       }
/* 2233 */       if (this.currentRow == this.fetchedRowCount) {
/* 2234 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 289);
/* 2235 */         localSQLException.fillInStackTrace();
/* 2236 */         throw localSQLException;
/*      */       }
/* 2238 */       return this.statement.getUnicodeStream(this.currentRow, paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 2255 */     return this.connection;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.GeneratedScrollableResultSet
 * JD-Core Version:    0.6.2
 */