/*      */ package oracle.jdbc.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Statement;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleResultSet;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.OPAQUE;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.REF;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.STRUCT;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ abstract class GeneratedResultSet
/*      */   implements OracleResultSet
/*      */ {
/*      */   protected PhysicalConnection connection;
/*      */   protected Object acProxy;
/* 2572 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public abstract boolean absolute(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void afterLast()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void beforeFirst()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void cancelRowUpdates()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void clearWarnings()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void deleteRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean first()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getConcurrency()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getCursorName()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getFetchDirection()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getFetchSize()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getHoldability()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ResultSetMetaData getMetaData()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Statement getStatement()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getType()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract SQLWarning getWarnings()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void insertRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isAfterLast()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isBeforeFirst()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isClosed()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isFirst()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean isLast()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean last()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void moveToCurrentRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void moveToInsertRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean next()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean previous()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void refreshRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean relative(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean rowDeleted()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean rowInserted()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean rowUpdated()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setFetchDirection(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void setFetchSize(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract void updateRow()
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean wasNull()
/*      */     throws SQLException;
/*      */ 
/*      */   protected GeneratedResultSet(PhysicalConnection paramPhysicalConnection)
/*      */   {
/*   86 */     this.connection = paramPhysicalConnection;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*   98 */     this.connection = null;
/*      */   }
/*      */ 
/*      */   public abstract int findColumn(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Array getArray(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Blob getBlob(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract boolean getBoolean(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract byte getByte(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract byte[] getBytes(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Clob getClob(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Date getDate(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract double getDouble(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract float getFloat(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract int getInt(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract long getLong(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract NClob getNClob(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getNString(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Object getObject(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Ref getRef(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract RowId getRowId(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract short getShort(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String getString(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Time getTime(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract Time getTime(int paramInt, Calendar paramCalendar) throws SQLException;
/*      */ 
/*      */   public abstract Timestamp getTimestamp(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract Timestamp getTimestamp(int paramInt, Calendar paramCalendar) throws SQLException;
/*      */ 
/*      */   public abstract URL getURL(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract ARRAY getARRAY(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract BFILE getBFILE(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract BFILE getBfile(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract BLOB getBLOB(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract CHAR getCHAR(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract CLOB getCLOB(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract ResultSet getCursor(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract DATE getDATE(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract INTERVALDS getINTERVALDS(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract INTERVALYM getINTERVALYM(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract NUMBER getNUMBER(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract OPAQUE getOPAQUE(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract Datum getOracleObject(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract ORAData getORAData(int paramInt, ORADataFactory paramORADataFactory) throws SQLException;
/*      */ 
/*      */   public abstract Object getObject(int paramInt, OracleDataFactory paramOracleDataFactory) throws SQLException;
/*      */ 
/*      */   public abstract RAW getRAW(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract REF getREF(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract ROWID getROWID(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract STRUCT getSTRUCT(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract TIMESTAMPLTZ getTIMESTAMPLTZ(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract TIMESTAMPTZ getTIMESTAMPTZ(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract TIMESTAMP getTIMESTAMP(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract CustomDatum getCustomDatum(int paramInt, CustomDatumFactory paramCustomDatumFactory) throws SQLException;
/*      */ 
/*      */   public abstract InputStream getAsciiStream(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract InputStream getBinaryStream(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract Reader getCharacterStream(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract Reader getNCharacterStream(int paramInt) throws SQLException;
/*      */ 
/*      */   public abstract InputStream getUnicodeStream(int paramInt) throws SQLException;
/*      */ 
/*      */   public void updateArray(int paramInt, Array paramArray) throws SQLException
/*      */   {
/*  242 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateArray");
/*  243 */     localSQLException.fillInStackTrace();
/*  244 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/*  257 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBigDecimal");
/*  258 */     localSQLException.fillInStackTrace();
/*  259 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/*  272 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBlob");
/*  273 */     localSQLException.fillInStackTrace();
/*  274 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBoolean(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  287 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBoolean");
/*  288 */     localSQLException.fillInStackTrace();
/*  289 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateByte(int paramInt, byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  302 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateByte");
/*  303 */     localSQLException.fillInStackTrace();
/*  304 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBytes(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  317 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBytes");
/*  318 */     localSQLException.fillInStackTrace();
/*  319 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/*  332 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateClob");
/*  333 */     localSQLException.fillInStackTrace();
/*  334 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateDate(int paramInt, Date paramDate)
/*      */     throws SQLException
/*      */   {
/*  347 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateDate");
/*  348 */     localSQLException.fillInStackTrace();
/*  349 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateDate(int paramInt, Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  362 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateDate");
/*  363 */     localSQLException.fillInStackTrace();
/*  364 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateDouble(int paramInt, double paramDouble)
/*      */     throws SQLException
/*      */   {
/*  377 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateDouble");
/*  378 */     localSQLException.fillInStackTrace();
/*  379 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateFloat(int paramInt, float paramFloat)
/*      */     throws SQLException
/*      */   {
/*  392 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateFloat");
/*  393 */     localSQLException.fillInStackTrace();
/*  394 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateInt(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  407 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateInt");
/*  408 */     localSQLException.fillInStackTrace();
/*  409 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateLong(int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  422 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateLong");
/*  423 */     localSQLException.fillInStackTrace();
/*  424 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/*  437 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNClob");
/*  438 */     localSQLException.fillInStackTrace();
/*  439 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  452 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNString");
/*  453 */     localSQLException.fillInStackTrace();
/*  454 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/*  467 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateObject");
/*  468 */     localSQLException.fillInStackTrace();
/*  469 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt1, Object paramObject, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  482 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateObject");
/*  483 */     localSQLException.fillInStackTrace();
/*  484 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateRef(int paramInt, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/*  497 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateRef");
/*  498 */     localSQLException.fillInStackTrace();
/*  499 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateRowId(int paramInt, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/*  512 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateRowId");
/*  513 */     localSQLException.fillInStackTrace();
/*  514 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateShort(int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/*  527 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateShort");
/*  528 */     localSQLException.fillInStackTrace();
/*  529 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(int paramInt, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/*  542 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateSQLXML");
/*  543 */     localSQLException.fillInStackTrace();
/*  544 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  557 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateString");
/*  558 */     localSQLException.fillInStackTrace();
/*  559 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTime(int paramInt, Time paramTime)
/*      */     throws SQLException
/*      */   {
/*  572 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTime");
/*  573 */     localSQLException.fillInStackTrace();
/*  574 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTime(int paramInt, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  587 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTime");
/*  588 */     localSQLException.fillInStackTrace();
/*  589 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(int paramInt, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/*  602 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTimestamp");
/*  603 */     localSQLException.fillInStackTrace();
/*  604 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  617 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTimestamp");
/*  618 */     localSQLException.fillInStackTrace();
/*  619 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateURL(int paramInt, URL paramURL)
/*      */     throws SQLException
/*      */   {
/*  632 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateURL");
/*  633 */     localSQLException.fillInStackTrace();
/*  634 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateARRAY(int paramInt, ARRAY paramARRAY)
/*      */     throws SQLException
/*      */   {
/*  647 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateARRAY");
/*  648 */     localSQLException.fillInStackTrace();
/*  649 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBFILE(int paramInt, BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/*  662 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBFILE");
/*  663 */     localSQLException.fillInStackTrace();
/*  664 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBfile(int paramInt, BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/*  677 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBfile");
/*  678 */     localSQLException.fillInStackTrace();
/*  679 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBLOB(int paramInt, BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/*  692 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBLOB");
/*  693 */     localSQLException.fillInStackTrace();
/*  694 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateCHAR(int paramInt, CHAR paramCHAR)
/*      */     throws SQLException
/*      */   {
/*  707 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateCHAR");
/*  708 */     localSQLException.fillInStackTrace();
/*  709 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateCLOB(int paramInt, CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/*  722 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateCLOB");
/*  723 */     localSQLException.fillInStackTrace();
/*  724 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateDATE(int paramInt, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/*  737 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateDATE");
/*  738 */     localSQLException.fillInStackTrace();
/*  739 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateINTERVALDS(int paramInt, INTERVALDS paramINTERVALDS)
/*      */     throws SQLException
/*      */   {
/*  752 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateINTERVALDS");
/*  753 */     localSQLException.fillInStackTrace();
/*  754 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateINTERVALYM(int paramInt, INTERVALYM paramINTERVALYM)
/*      */     throws SQLException
/*      */   {
/*  767 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateINTERVALYM");
/*  768 */     localSQLException.fillInStackTrace();
/*  769 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNUMBER(int paramInt, NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/*  782 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNUMBER");
/*  783 */     localSQLException.fillInStackTrace();
/*  784 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateOracleObject(int paramInt, Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/*  797 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateOracleObject");
/*  798 */     localSQLException.fillInStackTrace();
/*  799 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateORAData(int paramInt, ORAData paramORAData)
/*      */     throws SQLException
/*      */   {
/*  812 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateORAData");
/*  813 */     localSQLException.fillInStackTrace();
/*  814 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateRAW(int paramInt, RAW paramRAW)
/*      */     throws SQLException
/*      */   {
/*  827 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateRAW");
/*  828 */     localSQLException.fillInStackTrace();
/*  829 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateREF(int paramInt, REF paramREF)
/*      */     throws SQLException
/*      */   {
/*  842 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateREF");
/*  843 */     localSQLException.fillInStackTrace();
/*  844 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateROWID(int paramInt, ROWID paramROWID)
/*      */     throws SQLException
/*      */   {
/*  857 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateROWID");
/*  858 */     localSQLException.fillInStackTrace();
/*  859 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateSTRUCT(int paramInt, STRUCT paramSTRUCT)
/*      */     throws SQLException
/*      */   {
/*  872 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateSTRUCT");
/*  873 */     localSQLException.fillInStackTrace();
/*  874 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMPLTZ(int paramInt, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*      */     throws SQLException
/*      */   {
/*  887 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTIMESTAMPLTZ");
/*  888 */     localSQLException.fillInStackTrace();
/*  889 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMPTZ(int paramInt, TIMESTAMPTZ paramTIMESTAMPTZ)
/*      */     throws SQLException
/*      */   {
/*  902 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTIMESTAMPTZ");
/*  903 */     localSQLException.fillInStackTrace();
/*  904 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMP(int paramInt, TIMESTAMP paramTIMESTAMP)
/*      */     throws SQLException
/*      */   {
/*  917 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateTIMESTAMP");
/*  918 */     localSQLException.fillInStackTrace();
/*  919 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateCustomDatum(int paramInt, CustomDatum paramCustomDatum)
/*      */     throws SQLException
/*      */   {
/*  932 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateCustomDatum");
/*  933 */     localSQLException.fillInStackTrace();
/*  934 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/*  947 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBlob");
/*  948 */     localSQLException.fillInStackTrace();
/*  949 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  962 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBlob");
/*  963 */     localSQLException.fillInStackTrace();
/*  964 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/*  977 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateClob");
/*  978 */     localSQLException.fillInStackTrace();
/*  979 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  992 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateClob");
/*  993 */     localSQLException.fillInStackTrace();
/*  994 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 1007 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNClob");
/* 1008 */     localSQLException.fillInStackTrace();
/* 1009 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1022 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNClob");
/* 1023 */     localSQLException.fillInStackTrace();
/* 1024 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 1037 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateAsciiStream");
/* 1038 */     localSQLException.fillInStackTrace();
/* 1039 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1052 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateAsciiStream");
/* 1053 */     localSQLException.fillInStackTrace();
/* 1054 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1067 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateAsciiStream");
/* 1068 */     localSQLException.fillInStackTrace();
/* 1069 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 1082 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBinaryStream");
/* 1083 */     localSQLException.fillInStackTrace();
/* 1084 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1097 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBinaryStream");
/* 1098 */     localSQLException.fillInStackTrace();
/* 1099 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1112 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateBinaryStream");
/* 1113 */     localSQLException.fillInStackTrace();
/* 1114 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 1127 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateCharacterStream");
/* 1128 */     localSQLException.fillInStackTrace();
/* 1129 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1142 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateCharacterStream");
/* 1143 */     localSQLException.fillInStackTrace();
/* 1144 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1157 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateCharacterStream");
/* 1158 */     localSQLException.fillInStackTrace();
/* 1159 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 1172 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNCharacterStream");
/* 1173 */     localSQLException.fillInStackTrace();
/* 1174 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1187 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateNCharacterStream");
/* 1188 */     localSQLException.fillInStackTrace();
/* 1189 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void updateUnicodeStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1202 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 76, "updateUnicodeStream");
/* 1203 */     localSQLException.fillInStackTrace();
/* 1204 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public Array getArray(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1218 */     return getArray(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1229 */     return getBigDecimal(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1240 */     return getBigDecimal(findColumn(paramString), paramInt);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1251 */     return getBlob(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1262 */     return getBoolean(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public byte getByte(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1273 */     return getByte(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1284 */     return getBytes(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Clob getClob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1295 */     return getClob(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Date getDate(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1306 */     return getDate(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Date getDate(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1317 */     return getDate(findColumn(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public double getDouble(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1328 */     return getDouble(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public float getFloat(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1339 */     return getFloat(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public int getInt(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1350 */     return getInt(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public long getLong(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1361 */     return getLong(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public NClob getNClob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1372 */     return getNClob(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public String getNString(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1383 */     return getNString(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Object getObject(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1394 */     return getObject(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Object getObject(String paramString, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1405 */     return getObject(findColumn(paramString), paramMap);
/*      */   }
/*      */ 
/*      */   public Ref getRef(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1416 */     return getRef(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public RowId getRowId(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1427 */     return getRowId(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public short getShort(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1438 */     return getShort(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1449 */     return getSQLXML(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public String getString(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1460 */     return getString(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Time getTime(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1471 */     return getTime(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Time getTime(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1482 */     return getTime(findColumn(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1493 */     return getTimestamp(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1504 */     return getTimestamp(findColumn(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public URL getURL(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1515 */     return getURL(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public ARRAY getARRAY(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1526 */     return getARRAY(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public BFILE getBFILE(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1537 */     return getBFILE(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public BFILE getBfile(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1548 */     return getBfile(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public BLOB getBLOB(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1559 */     return getBLOB(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public CHAR getCHAR(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1570 */     return getCHAR(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public CLOB getCLOB(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1581 */     return getCLOB(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public ResultSet getCursor(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1592 */     return getCursor(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public DATE getDATE(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1603 */     return getDATE(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public INTERVALDS getINTERVALDS(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1614 */     return getINTERVALDS(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public INTERVALYM getINTERVALYM(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1625 */     return getINTERVALYM(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public NUMBER getNUMBER(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1636 */     return getNUMBER(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public OPAQUE getOPAQUE(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1647 */     return getOPAQUE(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Datum getOracleObject(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1658 */     return getOracleObject(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public ORAData getORAData(String paramString, ORADataFactory paramORADataFactory)
/*      */     throws SQLException
/*      */   {
/* 1669 */     return getORAData(findColumn(paramString), paramORADataFactory);
/*      */   }
/*      */ 
/*      */   public Object getObject(String paramString, OracleDataFactory paramOracleDataFactory)
/*      */     throws SQLException
/*      */   {
/* 1680 */     return getObject(findColumn(paramString), paramOracleDataFactory);
/*      */   }
/*      */ 
/*      */   public RAW getRAW(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1691 */     return getRAW(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public REF getREF(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1702 */     return getREF(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public ROWID getROWID(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1713 */     return getROWID(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public STRUCT getSTRUCT(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1724 */     return getSTRUCT(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ getTIMESTAMPLTZ(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1735 */     return getTIMESTAMPLTZ(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ getTIMESTAMPTZ(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1746 */     return getTIMESTAMPTZ(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public TIMESTAMP getTIMESTAMP(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1757 */     return getTIMESTAMP(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public CustomDatum getCustomDatum(String paramString, CustomDatumFactory paramCustomDatumFactory)
/*      */     throws SQLException
/*      */   {
/* 1768 */     return getCustomDatum(findColumn(paramString), paramCustomDatumFactory);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1779 */     return getAsciiStream(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1790 */     return getBinaryStream(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1801 */     return getCharacterStream(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1812 */     return getNCharacterStream(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1823 */     return getUnicodeStream(findColumn(paramString));
/*      */   }
/*      */ 
/*      */   public void updateArray(String paramString, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 1835 */     updateArray(findColumn(paramString), paramArray);
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(String paramString, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 1846 */     updateBigDecimal(findColumn(paramString), paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 1857 */     updateBlob(findColumn(paramString), paramBlob);
/*      */   }
/*      */ 
/*      */   public void updateBoolean(String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1868 */     updateBoolean(findColumn(paramString), paramBoolean);
/*      */   }
/*      */ 
/*      */   public void updateByte(String paramString, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 1879 */     updateByte(findColumn(paramString), paramByte);
/*      */   }
/*      */ 
/*      */   public void updateBytes(String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1890 */     updateBytes(findColumn(paramString), paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 1901 */     updateClob(findColumn(paramString), paramClob);
/*      */   }
/*      */ 
/*      */   public void updateDate(String paramString, Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 1912 */     updateDate(findColumn(paramString), paramDate);
/*      */   }
/*      */ 
/*      */   public void updateDate(String paramString, Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1923 */     updateDate(findColumn(paramString), paramDate, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void updateDouble(String paramString, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 1934 */     updateDouble(findColumn(paramString), paramDouble);
/*      */   }
/*      */ 
/*      */   public void updateFloat(String paramString, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 1945 */     updateFloat(findColumn(paramString), paramFloat);
/*      */   }
/*      */ 
/*      */   public void updateInt(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1956 */     updateInt(findColumn(paramString), paramInt);
/*      */   }
/*      */ 
/*      */   public void updateLong(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1967 */     updateLong(findColumn(paramString), paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 1978 */     updateNClob(findColumn(paramString), paramNClob);
/*      */   }
/*      */ 
/*      */   public void updateNString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1989 */     updateNString(findColumn(paramString1), paramString2);
/*      */   }
/*      */ 
/*      */   public void updateObject(String paramString, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 2000 */     updateObject(findColumn(paramString), paramObject);
/*      */   }
/*      */ 
/*      */   public void updateObject(String paramString, Object paramObject, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2011 */     updateObject(findColumn(paramString), paramObject, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateRef(String paramString, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 2022 */     updateRef(findColumn(paramString), paramRef);
/*      */   }
/*      */ 
/*      */   public void updateRowId(String paramString, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 2033 */     updateRowId(findColumn(paramString), paramRowId);
/*      */   }
/*      */ 
/*      */   public void updateShort(String paramString, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2044 */     updateShort(findColumn(paramString), paramShort);
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(String paramString, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 2055 */     updateSQLXML(findColumn(paramString), paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void updateString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 2066 */     updateString(findColumn(paramString1), paramString2);
/*      */   }
/*      */ 
/*      */   public void updateTime(String paramString, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 2077 */     updateTime(findColumn(paramString), paramTime);
/*      */   }
/*      */ 
/*      */   public void updateTime(String paramString, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 2088 */     updateTime(findColumn(paramString), paramTime, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(String paramString, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 2099 */     updateTimestamp(findColumn(paramString), paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(String paramString, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 2110 */     updateTimestamp(findColumn(paramString), paramTimestamp, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void updateURL(String paramString, URL paramURL)
/*      */     throws SQLException
/*      */   {
/* 2121 */     updateURL(findColumn(paramString), paramURL);
/*      */   }
/*      */ 
/*      */   public void updateARRAY(String paramString, ARRAY paramARRAY)
/*      */     throws SQLException
/*      */   {
/* 2132 */     updateARRAY(findColumn(paramString), paramARRAY);
/*      */   }
/*      */ 
/*      */   public void updateBFILE(String paramString, BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2143 */     updateBFILE(findColumn(paramString), paramBFILE);
/*      */   }
/*      */ 
/*      */   public void updateBfile(String paramString, BFILE paramBFILE)
/*      */     throws SQLException
/*      */   {
/* 2154 */     updateBfile(findColumn(paramString), paramBFILE);
/*      */   }
/*      */ 
/*      */   public void updateBLOB(String paramString, BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/* 2165 */     updateBLOB(findColumn(paramString), paramBLOB);
/*      */   }
/*      */ 
/*      */   public void updateCHAR(String paramString, CHAR paramCHAR)
/*      */     throws SQLException
/*      */   {
/* 2176 */     updateCHAR(findColumn(paramString), paramCHAR);
/*      */   }
/*      */ 
/*      */   public void updateCLOB(String paramString, CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 2187 */     updateCLOB(findColumn(paramString), paramCLOB);
/*      */   }
/*      */ 
/*      */   public void updateDATE(String paramString, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/* 2198 */     updateDATE(findColumn(paramString), paramDATE);
/*      */   }
/*      */ 
/*      */   public void updateINTERVALDS(String paramString, INTERVALDS paramINTERVALDS)
/*      */     throws SQLException
/*      */   {
/* 2209 */     updateINTERVALDS(findColumn(paramString), paramINTERVALDS);
/*      */   }
/*      */ 
/*      */   public void updateINTERVALYM(String paramString, INTERVALYM paramINTERVALYM)
/*      */     throws SQLException
/*      */   {
/* 2220 */     updateINTERVALYM(findColumn(paramString), paramINTERVALYM);
/*      */   }
/*      */ 
/*      */   public void updateNUMBER(String paramString, NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2231 */     updateNUMBER(findColumn(paramString), paramNUMBER);
/*      */   }
/*      */ 
/*      */   public void updateOracleObject(String paramString, Datum paramDatum)
/*      */     throws SQLException
/*      */   {
/* 2242 */     updateOracleObject(findColumn(paramString), paramDatum);
/*      */   }
/*      */ 
/*      */   public void updateORAData(String paramString, ORAData paramORAData)
/*      */     throws SQLException
/*      */   {
/* 2253 */     updateORAData(findColumn(paramString), paramORAData);
/*      */   }
/*      */ 
/*      */   public void updateRAW(String paramString, RAW paramRAW)
/*      */     throws SQLException
/*      */   {
/* 2264 */     updateRAW(findColumn(paramString), paramRAW);
/*      */   }
/*      */ 
/*      */   public void updateREF(String paramString, REF paramREF)
/*      */     throws SQLException
/*      */   {
/* 2275 */     updateREF(findColumn(paramString), paramREF);
/*      */   }
/*      */ 
/*      */   public void updateROWID(String paramString, ROWID paramROWID)
/*      */     throws SQLException
/*      */   {
/* 2286 */     updateROWID(findColumn(paramString), paramROWID);
/*      */   }
/*      */ 
/*      */   public void updateSTRUCT(String paramString, STRUCT paramSTRUCT)
/*      */     throws SQLException
/*      */   {
/* 2297 */     updateSTRUCT(findColumn(paramString), paramSTRUCT);
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMPLTZ(String paramString, TIMESTAMPLTZ paramTIMESTAMPLTZ)
/*      */     throws SQLException
/*      */   {
/* 2308 */     updateTIMESTAMPLTZ(findColumn(paramString), paramTIMESTAMPLTZ);
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMPTZ(String paramString, TIMESTAMPTZ paramTIMESTAMPTZ)
/*      */     throws SQLException
/*      */   {
/* 2319 */     updateTIMESTAMPTZ(findColumn(paramString), paramTIMESTAMPTZ);
/*      */   }
/*      */ 
/*      */   public void updateTIMESTAMP(String paramString, TIMESTAMP paramTIMESTAMP)
/*      */     throws SQLException
/*      */   {
/* 2330 */     updateTIMESTAMP(findColumn(paramString), paramTIMESTAMP);
/*      */   }
/*      */ 
/*      */   public void updateCustomDatum(String paramString, CustomDatum paramCustomDatum)
/*      */     throws SQLException
/*      */   {
/* 2341 */     updateCustomDatum(findColumn(paramString), paramCustomDatum);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 2352 */     updateBlob(findColumn(paramString), paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2363 */     updateBlob(findColumn(paramString), paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2374 */     updateClob(findColumn(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2385 */     updateClob(findColumn(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2396 */     updateNClob(findColumn(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2407 */     updateNClob(findColumn(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 2418 */     updateAsciiStream(findColumn(paramString), paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2429 */     updateAsciiStream(findColumn(paramString), paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2440 */     updateAsciiStream(findColumn(paramString), paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 2451 */     updateBinaryStream(findColumn(paramString), paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2462 */     updateBinaryStream(findColumn(paramString), paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2473 */     updateBinaryStream(findColumn(paramString), paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2484 */     updateCharacterStream(findColumn(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2495 */     updateCharacterStream(findColumn(paramString), paramReader, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2506 */     updateCharacterStream(findColumn(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 2517 */     updateNCharacterStream(findColumn(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2528 */     updateNCharacterStream(findColumn(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateUnicodeStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2539 */     updateUnicodeStream(findColumn(paramString), paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 2556 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 2563 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 2568 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.driver.GeneratedResultSet
 * JD-Core Version:    0.6.2
 */